/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import kafka.server.ActiveTenantsManager;
import kafka.server.BrokerBackpressureConfig;
import kafka.server.BrokerBackpressureConfig$;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClusterLinkQuotas$;
import kafka.server.ClusterLinkRequestQuotaAdapter;
import kafka.server.ClusterLinkRequestQuotaManager;
import kafka.server.ClusterLinkRequestQuotaManagerConfig;
import kafka.server.ClusterLinkTenantContext;
import kafka.server.ClusterLinkTenantRequestQuota;
import kafka.server.ConfigEntityName$;
import kafka.server.Defaults$;
import kafka.server.DiskUsageBasedThrottlingConfig;
import kafka.server.LinkRequestQuotaUsageType;
import kafka.server.link.ClusterLinkPrincipal;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u0005b\u0001\u0002\u00180\u0001QBQa\u000f\u0001\u0005\u0002qB\u0011b\u0010\u0001A\u0002\u0003\u0007I\u0011\u0002!\t\u0013\u0011\u0003\u0001\u0019!a\u0001\n\u0013)\u0005\"C&\u0001\u0001\u0004\u0005\t\u0015)\u0003B\u0011%a\u0005\u00011AA\u0002\u0013%Q\nC\u0005R\u0001\u0001\u0007\t\u0019!C\u0005%\"IA\u000b\u0001a\u0001\u0002\u0003\u0006KA\u0014\u0005\n+\u0002\u0001\r\u00111A\u0005\nYC\u0011b\u0019\u0001A\u0002\u0003\u0007I\u0011\u00023\t\u0013\u0019\u0004\u0001\u0019!A!B\u00139\u0006\"C4\u0001\u0001\u0004\u0005\r\u0011\"\u0003i\u0011%\u0001\b\u00011AA\u0002\u0013%\u0011\u000fC\u0005t\u0001\u0001\u0007\t\u0011)Q\u0005S\"9A\u000f\u0001a\u0001\n\u0013)\bbB=\u0001\u0001\u0004%IA\u001f\u0005\u0007y\u0002\u0001\u000b\u0015\u0002<\t\u000fu\u0004\u0001\u0019!C\u0005}\"I\u0011Q\u0001\u0001A\u0002\u0013%\u0011q\u0001\u0005\b\u0003\u0017\u0001\u0001\u0015)\u0003\u0000\u0011!\ti\u0001\u0001a\u0001\n\u0013q\b\"CA\b\u0001\u0001\u0007I\u0011BA\t\u0011\u001d\t)\u0002\u0001Q!\n}D\u0011\"a\u0006\u0001\u0005\u0004%I!!\u0007\t\u0011\u0005-\u0002\u0001)A\u0005\u00037A\u0011\"!\f\u0001\u0005\u0004%I!!\u0007\t\u0011\u0005=\u0002\u0001)A\u0005\u00037A\u0011\"!\r\u0001\u0005\u0004%I!!\u0007\t\u0011\u0005M\u0002\u0001)A\u0005\u00037A\u0011\"!\u000e\u0001\u0005\u0004%I!a\u000e\t\u0011\u0005}\u0002\u0001)A\u0005\u0003sA\u0011\"!\u0011\u0001\u0005\u0004%I!a\u0011\t\u0011\u0005-\u0003\u0001)A\u0005\u0003\u000bBq!!\u0014\u0001\t\u0003\ty\u0005C\u0004\u0002h\u0001!\t!a\u0014\t\u000f\u0005E\u0004\u0001\"\u0001\u0002t!9\u0011q\u0010\u0001\u0005\u0002\u0005\u0005\u0005bBAD\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u0003\u007f\u0003A\u0011AA(\u0011\u001d\tI\r\u0001C\u0001\u0003\u001fBq!!4\u0001\t\u0003\ty\u0005C\u0004\u0002R\u0002!\t!a\u0014\t\u000f\u0005U\u0007\u0001\"\u0003\u0002X\"9\u00111 \u0001\u0005\n\u0005u\bb\u0002B\u0002\u0001\u0011%!Q\u0001\u0005\b\u0005+\u0001A\u0011\u0002B\f\u0005\t\u001aE.^:uKJd\u0015N\\6SKF,Xm\u001d;Rk>$\u0018-T1oC\u001e,'\u000fV3ti*\u0011\u0001'M\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003I\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001kA\u0011a'O\u0007\u0002o)\t\u0001(A\u0003tG\u0006d\u0017-\u0003\u0002;o\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u001f\u0011\u0005y\u0002Q\"A\u0018\u0002'I,\u0017/^3tiF+x\u000e^1NC:\fw-\u001a:\u0016\u0003\u0005\u0003\"A\u0010\"\n\u0005\r{#AH\"mkN$XM\u001d'j].\u0014V-];fgR\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0003]\u0011X-];fgR\fVo\u001c;b\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0002G\u0013B\u0011agR\u0005\u0003\u0011^\u0012A!\u00168ji\"9!jAA\u0001\u0002\u0004\t\u0015a\u0001=%c\u0005!\"/Z9vKN$\u0018+^8uC6\u000bg.Y4fe\u0002\nA#Y2uSZ,G+\u001a8b]R\u001cX*\u00198bO\u0016\u0014X#\u0001(\u0011\u0005yz\u0015B\u0001)0\u0005Q\t5\r^5wKR+g.\u00198ug6\u000bg.Y4fe\u0006A\u0012m\u0019;jm\u0016$VM\\1oiNl\u0015M\\1hKJ|F%Z9\u0015\u0005\u0019\u001b\u0006b\u0002&\u0007\u0003\u0003\u0005\rAT\u0001\u0016C\u000e$\u0018N^3UK:\fg\u000e^:NC:\fw-\u001a:!\u0003\u0011!\u0018.\\3\u0016\u0003]\u0003\"\u0001W1\u000e\u0003eS!AW.\u0002\tU$\u0018\u000e\u001c\u0006\u0003aqS!AM/\u000b\u0005y{\u0016AB1qC\u000eDWMC\u0001a\u0003\ry'oZ\u0005\u0003Ef\u0013\u0001\"T8dWRKW.Z\u0001\ti&lWm\u0018\u0013fcR\u0011a)\u001a\u0005\b\u0015&\t\t\u00111\u0001X\u0003\u0015!\u0018.\\3!\u0003\u001diW\r\u001e:jGN,\u0012!\u001b\t\u0003U:l\u0011a\u001b\u0006\u0003O2T!!\u001c/\u0002\r\r|W.\\8o\u0013\ty7NA\u0004NKR\u0014\u0018nY:\u0002\u00175,GO]5dg~#S-\u001d\u000b\u0003\rJDqA\u0013\u0007\u0002\u0002\u0003\u0007\u0011.\u0001\u0005nKR\u0014\u0018nY:!\u0003}\u0019G.^:uKJd\u0015N\\6SKF,Xm\u001d;Rk>$\u0018mQ1qC\u000eLG/_\u000b\u0002mB\u0011ag^\u0005\u0003q^\u00121!\u00138u\u0003\r\u001aG.^:uKJd\u0015N\\6SKF,Xm\u001d;Rk>$\u0018mQ1qC\u000eLG/_0%KF$\"AR>\t\u000f){\u0011\u0011!a\u0001m\u0006\u00013\r\\;ti\u0016\u0014H*\u001b8l%\u0016\fX/Z:u#V|G/Y\"ba\u0006\u001c\u0017\u000e^=!\u0003E\u0019G.^:uKJd\u0015N\\6F]\u0006\u0014G.Z\u000b\u0002\u007fB\u0019a'!\u0001\n\u0007\u0005\rqGA\u0004C_>dW-\u00198\u0002+\rdWo\u001d;fe2Kgn[#oC\ndWm\u0018\u0013fcR\u0019a)!\u0003\t\u000f)\u0013\u0012\u0011!a\u0001\u007f\u0006\u00112\r\\;ti\u0016\u0014H*\u001b8l\u000b:\f'\r\\3!\u0003u\u0019G.^:uKJd\u0015N\\6UK:\fg\u000e^)v_R\f7/\u00128bE2,\u0017!I2mkN$XM\u001d'j].$VM\\1oiF+x\u000e^1t\u000b:\f'\r\\3`I\u0015\fHc\u0001$\u0002\u0014!9!*FA\u0001\u0002\u0004y\u0018AH2mkN$XM\u001d'j].$VM\\1oiF+x\u000e^1t\u000b:\f'\r\\3!\u0003\u001d!XM\\1oi\u0006+\"!a\u0007\u0011\t\u0005u\u0011qE\u0007\u0003\u0003?QA!!\t\u0002$\u0005!A.\u00198h\u0015\t\t)#\u0001\u0003kCZ\f\u0017\u0002BA\u0015\u0003?\u0011aa\u0015;sS:<\u0017\u0001\u0003;f]\u0006tG/\u0011\u0011\u0002\u000fQ,g.\u00198u\u0005\u0006AA/\u001a8b]R\u0014\u0005%\u0001\u0005mS:\\g*Y7f\u0003%a\u0017N\\6OC6,\u0007%A\tdY&,g\u000e^)v_R\f7i\u001c8gS\u001e,\"!!\u000f\u0011\u0007y\nY$C\u0002\u0002>=\u0012\u0001d\u00117jK:$\u0018+^8uC6\u000bg.Y4fe\u000e{gNZ5h\u0003I\u0019G.[3oiF+x\u000e^1D_:4\u0017n\u001a\u0011\u0002\r\r|gNZ5h+\t\t)\u0005E\u0002?\u0003\u000fJ1!!\u00130\u0005\u0011\u001aE.^:uKJd\u0015N\\6SKF,Xm\u001d;Rk>$\u0018-T1oC\u001e,'oQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\rE\u00164wN]3NKRDw\u000e\u001a\u000b\u0002\r\"\u001a\u0011%a\u0015\u0011\t\u0005U\u00131M\u0007\u0003\u0003/RA!!\u0017\u0002\\\u0005\u0019\u0011\r]5\u000b\t\u0005u\u0013qL\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\t\tgX\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003K\n9F\u0001\u0006CK\u001a|'/Z#bG\"\f1\"\u00194uKJlU\r\u001e5pI\"\u001a!%a\u001b\u0011\t\u0005U\u0013QN\u0005\u0005\u0003_\n9FA\u0005BMR,'/R1dQ\u0006iQ.\u001b7mSN$vNT1o_N$B!!\u001e\u0002|A\u0019a'a\u001e\n\u0007\u0005etG\u0001\u0003M_:<\u0007bBA?G\u0001\u0007\u0011QO\u0001\u0007[&dG.[:\u0002\u0015M,7\rV8OC:|7\u000f\u0006\u0003\u0002v\u0005\r\u0005BBACI\u0001\u0007a/\u0001\u0003tK\u000e\u001c\u0018\u0001\u0007;fgR\fVo\u001c;b\u000b:\f'\r\\3e\t&\u001c\u0018M\u00197fIR)a)a#\u0002\u000e\")Q0\na\u0001\u007f\"1\u0011QB\u0013A\u0002}D3!JAI!\u0011\t\u0019*!'\u000e\u0005\u0005U%\u0002BAL\u00037\na\u0001]1sC6\u001c\u0018\u0002BAN\u0003+\u0013\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:uQ\u001d)\u0013qTAV\u0003[\u0003B!!)\u0002(6\u0011\u00111\u0015\u0006\u0005\u0003K\u000b)*\u0001\u0005qe>4\u0018\u000eZ3s\u0013\u0011\tI+a)\u0003\u0013\r\u001bhoU8ve\u000e,\u0017!\u0002<bYV,G\u0006CAX\u0003g\u000b9,a/\"\u0005\u0005E\u0016A\u00034bYN,G\u0006\u001e:vK\u0006\u0012\u0011QW\u0001\u000biJ,X\r\f4bYN,\u0017EAA]\u0003-1\u0017\r\\:fY\u0019\fGn]3\"\u0005\u0005u\u0016!\u0003;sk\u0016dCO];f\u0003A!Xm\u001d;UQJ|G\u000f\u001e7f)&lW\rK\u0002'\u0003\u0007\u0004B!!\u0016\u0002F&!\u0011qYA,\u0005\u0011!Vm\u001d;\u0002SQ,7\u000f^!vi>$VO\\3SKF,Xm\u001d;Rk>$\u0018-\u00117m\u0003\n|g/\u001a$bSJd\u0015.\\5uQ\r9\u00131Y\u0001/i\u0016\u001cH/Q;u_R+h.\u001a*fcV,7\u000f^)v_R\f\u0017IY8wK\u0006sGMQ3m_^4\u0015-\u001b:MS6LG\u000fK\u0002)\u0003\u0007\f\u0011\u0006^3ti\u0006+Ho\u001c+v]\u0016\u0014V-];fgR\fVo\u001c;b\u00032d')\u001a7po\u001a\u000b\u0017N\u001d'j[&$\bfA\u0015\u0002D\u0006aQ\u000f\u001d3bi\u0016\fVo\u001c;bgR)a)!7\u0002r\"9\u00111\u001c\u0016A\u0002\u0005u\u0017A\u0002;f]\u0006tG\u000f\u0005\u0003\u0002`\u00065h\u0002BAq\u0003S\u00042!a98\u001b\t\t)OC\u0002\u0002hN\na\u0001\u0010:p_Rt\u0014bAAvo\u00051\u0001K]3eK\u001aLA!!\u000b\u0002p*\u0019\u00111^\u001c\t\u000f\u0005M(\u00061\u0001\u0002v\u0006QQ\u000f\u001d9fe\n{WO\u001c3\u0011\u0007Y\n90C\u0002\u0002z^\u0012a\u0001R8vE2,\u0017aC7bs\n,'+Z2pe\u0012$RA^A\u0000\u0005\u0003Aq!a7,\u0001\u0004\ti\u000eC\u0004\u0002,.\u0002\r!!\u001e\u0002\u0013A\u0014\u0018N\\2ja\u0006dG\u0003\u0002B\u0004\u0005'\u0001BA!\u0003\u0003\u00105\u0011!1\u0002\u0006\u0004\u0005\u001by\u0013\u0001\u00027j].LAA!\u0005\u0003\f\t!2\t\\;ti\u0016\u0014H*\u001b8l!JLgnY5qC2Dq!a7-\u0001\u0004\ti.A\tmS:\\G+\u001a8b]R\u001cuN\u001c;fqR$BA!\u0007\u0003 A\u0019aHa\u0007\n\u0007\tuqF\u0001\rDYV\u001cH/\u001a:MS:\\G+\u001a8b]R\u001cuN\u001c;fqRDq!a7.\u0001\u0004\ti\u000e")
public class ClusterLinkRequestQuotaManagerTest {
    private ClusterLinkRequestQuotaManager requestQuotaManager;
    private ActiveTenantsManager activeTenantsManager;
    private MockTime time;
    private Metrics metrics;
    private int clusterLinkRequestQuotaCapacity = 1000;
    private boolean clusterLinkEnable = true;
    private boolean clusterLinkTenantQuotasEnable = true;
    private final String tenantA;
    private final String tenantB;
    private final String linkName;
    private final ClientQuotaManagerConfig clientQuotaConfig;
    private final ClusterLinkRequestQuotaManagerConfig config;

    private ClusterLinkRequestQuotaManager requestQuotaManager() {
        return this.requestQuotaManager;
    }

    private void requestQuotaManager_$eq(ClusterLinkRequestQuotaManager x$1) {
        this.requestQuotaManager = x$1;
    }

    private ActiveTenantsManager activeTenantsManager() {
        return this.activeTenantsManager;
    }

    private void activeTenantsManager_$eq(ActiveTenantsManager x$1) {
        this.activeTenantsManager = x$1;
    }

    private MockTime time() {
        return this.time;
    }

    private void time_$eq(MockTime x$1) {
        this.time = x$1;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    private int clusterLinkRequestQuotaCapacity() {
        return this.clusterLinkRequestQuotaCapacity;
    }

    private void clusterLinkRequestQuotaCapacity_$eq(int x$1) {
        this.clusterLinkRequestQuotaCapacity = x$1;
    }

    private boolean clusterLinkEnable() {
        return this.clusterLinkEnable;
    }

    private void clusterLinkEnable_$eq(boolean x$1) {
        this.clusterLinkEnable = x$1;
    }

    private boolean clusterLinkTenantQuotasEnable() {
        return this.clusterLinkTenantQuotasEnable;
    }

    private void clusterLinkTenantQuotasEnable_$eq(boolean x$1) {
        this.clusterLinkTenantQuotasEnable = x$1;
    }

    private String tenantA() {
        return this.tenantA;
    }

    private String tenantB() {
        return this.tenantB;
    }

    private String linkName() {
        return this.linkName;
    }

    private ClientQuotaManagerConfig clientQuotaConfig() {
        return this.clientQuotaConfig;
    }

    private ClusterLinkRequestQuotaManagerConfig config() {
        return this.config;
    }

    @BeforeEach
    public void beforeMethod() {
        this.time_$eq(new MockTime());
        this.metrics_$eq(new Metrics(new MetricConfig().timeWindow(1L, TimeUnit.SECONDS), Collections.emptyList(), (Time)this.time()));
        this.activeTenantsManager_$eq(new ActiveTenantsManager(this.metrics(), (Time)this.time(), 10000L));
        this.requestQuotaManager_$eq(new ClusterLinkRequestQuotaManager(this.config(), this.metrics(), (Time)this.time(), "", (Option)None$.MODULE$, (Option)new Some((Object)this.activeTenantsManager())));
        this.requestQuotaManager().updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
    }

    @AfterEach
    public void afterMethod() {
        this.requestQuotaManager().shutdown();
        this.metrics().close();
    }

    public long millisToNanos(long millis) {
        return TimeUnit.MILLISECONDS.toNanos(millis);
    }

    public long secToNanos(int secs) {
        return TimeUnit.SECONDS.toNanos(secs);
    }

    @ParameterizedTest
    @CsvSource(value={"false,true", "true,false", "false,false", "true,true"})
    public void testQuotaEnabledDisabled(boolean clusterLinkEnable, boolean clusterLinkTenantQuotasEnable) {
        this.clusterLinkEnable_$eq(clusterLinkEnable);
        this.clusterLinkTenantQuotasEnable_$eq(clusterLinkTenantQuotasEnable);
        this.clusterLinkRequestQuotaCapacity_$eq(50);
        int throttleTime = this.maybeRecord(this.tenantA(), this.secToNanos(7000));
        if (clusterLinkEnable && clusterLinkTenantQuotasEnable) {
            Assertions.assertTrue((boolean)this.requestQuotaManager().requestQuotasEnabled());
            Assertions.assertEquals((int)1000, (int)throttleTime);
            Assertions.assertEquals((double)this.clusterLinkRequestQuotaCapacity(), (double)this.requestQuotaManager().getBrokerQuotaLimit());
            return;
        }
        Assertions.assertFalse((boolean)this.requestQuotaManager().requestQuotasEnabled());
        Assertions.assertEquals((int)0, (int)throttleTime);
        Assertions.assertEquals((double)Double.MAX_VALUE, (double)this.requestQuotaManager().getBrokerQuotaLimit(), (double)1.0);
    }

    @Test
    public void testThrottleTime() {
        ClusterLinkRequestQuotaAdapter requestQuotaAdapter = new ClusterLinkRequestQuotaAdapter((ClusterLinkTenantRequestQuota)this.requestQuotaManager(), (Option)new Some((Object)this.tenantA()), this.linkName());
        this.updateQuotas(this.tenantA(), 800.0);
        IntRef throttleTime = IntRef.create((int)this.maybeRecord(this.tenantA(), this.secToNanos(70)));
        Assertions.assertEquals((int)0, (int)throttleTime.elem);
        Assertions.assertFalse((boolean)requestQuotaAdapter.isQuotaExceeded());
        throttleTime.elem = this.maybeRecord(this.tenantA(), this.secToNanos(18));
        Assertions.assertEquals((int)0, (int)throttleTime.elem);
        Assertions.assertFalse((boolean)requestQuotaAdapter.isQuotaExceeded());
        throttleTime.elem = this.maybeRecord(this.tenantA(), this.secToNanos(1));
        Assertions.assertEquals((int)125, (int)throttleTime.elem);
        Assertions.assertTrue((boolean)requestQuotaAdapter.isQuotaExceeded());
        this.time().sleep((long)throttleTime.elem);
        Assertions.assertFalse((boolean)requestQuotaAdapter.isQuotaExceeded());
        throttleTime.elem = this.maybeRecord(this.tenantA(), this.secToNanos(8));
        Assertions.assertEquals((int)1000, (int)throttleTime.elem);
        Assertions.assertTrue((boolean)requestQuotaAdapter.isQuotaExceeded());
        this.time().sleep((long)throttleTime.elem);
        Assertions.assertFalse((boolean)requestQuotaAdapter.isQuotaExceeded());
        throttleTime.elem = this.maybeRecord(this.tenantA(), this.secToNanos(90));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 11).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            throttleTime$1.elem = this.maybeRecord(this.tenantA(), 0L);
            Assertions.assertEquals((int)1000, (int)throttleTime$1.elem);
            Assertions.assertTrue((boolean)requestQuotaAdapter.isQuotaExceeded());
            this.time().sleep((long)throttleTime$1.elem);
        });
        throttleTime.elem = this.maybeRecord(this.tenantA(), 0L);
        Assertions.assertTrue((boolean)requestQuotaAdapter.isQuotaExceeded());
        Assertions.assertEquals((int)250, (int)throttleTime.elem);
        this.time().sleep((long)throttleTime.elem);
        Assertions.assertFalse((boolean)requestQuotaAdapter.isQuotaExceeded());
    }

    @Test
    public void testAutoTuneRequestQuotaAllAboveFairLimit() {
        ClusterLinkPrincipal principalA = this.principal(this.tenantA());
        ClusterLinkPrincipal principalB = this.principal(this.tenantB());
        this.clusterLinkRequestQuotaCapacity_$eq(1200);
        this.updateQuotas(this.tenantA(), 800.0);
        this.updateQuotas(this.tenantB(), 800.0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> {
            int throttleTime1 = this.maybeRecord(this.tenantA(), this.millisToNanos(7000L));
            int throttleTime2 = this.maybeRecord(this.tenantB(), this.millisToNanos(7000L));
            this.time().sleep((long)Math.max(1000, Math.max(throttleTime1, throttleTime2)));
        });
        this.requestQuotaManager().maybeAutoTuneQuota();
        Assertions.assertEquals((double)600.0, (double)this.requestQuotaManager().dynamicQuota((KafkaPrincipal)principalA, ClusterLinkQuotas$.MODULE$.ClusterLinkClientId()).bound(), (double)0.0);
        Assertions.assertEquals((double)600.0, (double)this.requestQuotaManager().dynamicQuota((KafkaPrincipal)principalB, ClusterLinkQuotas$.MODULE$.ClusterLinkClientId()).bound(), (double)0.0);
        BrokerBackpressureConfig newBackpressureConfig = new BrokerBackpressureConfig(false, BrokerBackpressureConfig$.MODULE$.DefaultBackpressureCheckFrequencyMs(), (Seq)Nil$.MODULE$, Double.MAX_VALUE, (double)Predef$.MODULE$.Long2long(ConfluentConfigs.BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_DEFAULT), "p95");
        this.requestQuotaManager().updateBackpressureConfig(newBackpressureConfig);
        Assertions.assertEquals((double)this.requestQuotaManager().quota((KafkaPrincipal)principalA, ClusterLinkQuotas$.MODULE$.ClusterLinkClientId()).bound(), (double)this.requestQuotaManager().dynamicQuota((KafkaPrincipal)principalA, ClusterLinkQuotas$.MODULE$.ClusterLinkClientId()).bound(), (double)1.0E-8);
        Assertions.assertEquals((double)this.requestQuotaManager().quota((KafkaPrincipal)principalB, ClusterLinkQuotas$.MODULE$.ClusterLinkClientId()).bound(), (double)this.requestQuotaManager().dynamicQuota((KafkaPrincipal)principalB, ClusterLinkQuotas$.MODULE$.ClusterLinkClientId()).bound(), (double)1.0E-8);
    }

    @Test
    public void testAutoTuneRequestQuotaAboveAndBelowFairLimit() {
        ClusterLinkPrincipal principalA = this.principal(this.tenantA());
        ClusterLinkPrincipal principalB = this.principal(this.tenantB());
        this.clusterLinkRequestQuotaCapacity_$eq(1200);
        this.updateQuotas(this.tenantA(), 800.0);
        this.updateQuotas(this.tenantB(), 800.0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> {
            int throttleTime1 = this.maybeRecord(this.tenantA(), this.millisToNanos(7500L));
            int throttleTime2 = this.maybeRecord(this.tenantB(), this.millisToNanos(5000L));
            this.time().sleep((long)Math.max(1000, Math.max(throttleTime1, throttleTime2)));
        });
        this.requestQuotaManager().maybeAutoTuneQuota();
        Assertions.assertEquals((double)700.0, (double)this.requestQuotaManager().dynamicQuota((KafkaPrincipal)principalA, ClusterLinkQuotas$.MODULE$.ClusterLinkClientId()).bound(), (double)0.0);
        Assertions.assertEquals((double)600.0, (double)this.requestQuotaManager().dynamicQuota((KafkaPrincipal)principalB, ClusterLinkQuotas$.MODULE$.ClusterLinkClientId()).bound(), (double)0.0);
    }

    @Test
    public void testAutoTuneRequestQuotaAllBelowFairLimit() {
        ClusterLinkPrincipal principalA = this.principal(this.tenantA());
        ClusterLinkPrincipal principalB = this.principal(this.tenantB());
        this.clusterLinkRequestQuotaCapacity_$eq(1200);
        this.updateQuotas(this.tenantA(), 800.0);
        this.updateQuotas(this.tenantB(), 800.0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$7 -> {
            int throttleTime1 = this.maybeRecord(this.tenantA(), this.millisToNanos(1000L));
            int throttleTime2 = this.maybeRecord(this.tenantB(), this.millisToNanos(1000L));
            this.time().sleep((long)Math.max(1000, Math.max(throttleTime1, throttleTime2)));
        });
        this.requestQuotaManager().maybeAutoTuneQuota();
        Assertions.assertEquals((double)this.requestQuotaManager().quota((KafkaPrincipal)principalA, ClusterLinkQuotas$.MODULE$.ClusterLinkClientId()).bound(), (double)this.requestQuotaManager().dynamicQuota((KafkaPrincipal)principalA, ClusterLinkQuotas$.MODULE$.ClusterLinkClientId()).bound(), (double)1.0E-8);
        Assertions.assertEquals((double)this.requestQuotaManager().quota((KafkaPrincipal)principalB, ClusterLinkQuotas$.MODULE$.ClusterLinkClientId()).bound(), (double)this.requestQuotaManager().dynamicQuota((KafkaPrincipal)principalB, ClusterLinkQuotas$.MODULE$.ClusterLinkClientId()).bound(), (double)1.0E-8);
    }

    private void updateQuotas(String tenant, double upperBound) {
        this.requestQuotaManager().updateQuota((Option)new Some((Object)Sanitizer.sanitize((String)this.principal(tenant).getName())), (Option)new Some((Object)ClusterLinkQuotas$.MODULE$.ClusterLinkClientId()), (Option)new Some((Object)ClusterLinkQuotas$.MODULE$.ClusterLinkClientId()), (Option)new Some((Object)new Quota(upperBound, true)));
    }

    private int maybeRecord(String tenant, long value) {
        ClusterLinkRequestQuotaAdapter requestQuotaAdapter = new ClusterLinkRequestQuotaAdapter((ClusterLinkTenantRequestQuota)this.requestQuotaManager(), (Option)new Some((Object)tenant), this.linkName());
        requestQuotaAdapter.record(value, (LinkRequestQuotaUsageType)LinkRequestQuotaUsageType.Fetcher$.MODULE$);
        return requestQuotaAdapter.getThrottleTimeMs(this.time().milliseconds());
    }

    private ClusterLinkPrincipal principal(String tenant) {
        return (ClusterLinkPrincipal)this.requestQuotaManager().clusterLinkPrincipal(this.linkTenantContext(tenant)).get();
    }

    private ClusterLinkTenantContext linkTenantContext(String tenant) {
        return new ClusterLinkTenantContext((Option)new Some((Object)tenant), this.linkName());
    }

    public ClusterLinkRequestQuotaManagerTest() {
        this.tenantA = "tenantA";
        this.tenantB = "tenantB";
        this.linkName = "FooLink";
        BrokerBackpressureConfig x$1 = new BrokerBackpressureConfig(true, 10L * TimeUnit.HOURS.toMillis(1L), (Seq)Nil$.MODULE$, 0.0, 110.0, "p99");
        int x$2 = Defaults$.MODULE$.DefaultNumQuotaSamples();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        DiskUsageBasedThrottlingConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        double x$5 = 9.223372036854776E18;
        long x$6 = 0L;
        int x$7 = 0;
        long x$8 = Long.MAX_VALUE;
        this.clientQuotaConfig = new ClientQuotaManagerConfig(x$2, x$3, x$1, x$4, x$5, x$6, x$7, x$8);
        this.config = new ClusterLinkRequestQuotaManagerConfig(this.clientQuotaConfig(), (Function0)(JFunction0.mcZ.sp & Serializable)() -> this.clusterLinkEnable(), (Function0)(JFunction0.mcZ.sp & Serializable)() -> this.clusterLinkTenantQuotasEnable(), (Function0)(JFunction0.mcI.sp & Serializable)() -> this.clusterLinkRequestQuotaCapacity());
    }
}

