/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.test.ClusterConfig;
import kafka.test.ClusterGenerator;
import kafka.test.annotation.Type;
import org.apache.kafka.server.common.MetadataVersion;

public final class ClusterLinksRequestTest$ {
    public static final ClusterLinksRequestTest$ MODULE$ = new ClusterLinksRequestTest$();

    public void migrationEnabledZkCluster(ClusterGenerator generator) {
        ClusterConfig zkMigrationClusterConfig = ClusterConfig.defaultClusterBuilder().brokers(3).type(Type.ZK).metadataVersion(MetadataVersion.IBP_3_6_IV2).build();
        zkMigrationClusterConfig.serverProperties().put("zookeeper.metadata.migration.enable", "true");
        zkMigrationClusterConfig.serverProperties().put("controller.quorum.voters", "1@localhost:9092,2@localhost:9093,3@localhost:9094");
        zkMigrationClusterConfig.serverProperties().put("controller.listener.names", "CONTROLLER");
        zkMigrationClusterConfig.serverProperties().put("listener.security.protocol.map", "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
        zkMigrationClusterConfig.serverProperties().put("confluent.cluster.link.metadata.topic.enable", "true");
        generator.accept(zkMigrationClusterConfig);
    }

    public void allMigrationClusterTypes(ClusterGenerator generator) {
        ClusterConfig zkNonMigrationClusterConfig = ClusterConfig.defaultClusterBuilder().brokers(1).type(Type.ZK).metadataVersion(MetadataVersion.IBP_3_5_IV2).build();
        zkNonMigrationClusterConfig.serverProperties().put("zookeeper.metadata.migration.enable", "false");
        zkNonMigrationClusterConfig.serverProperties().put("confluent.cluster.link.metadata.topic.enable", "true");
        generator.accept(zkNonMigrationClusterConfig);
        ClusterConfig zkMigrationClusterConfig = ClusterConfig.defaultClusterBuilder().brokers(3).type(Type.ZK).metadataVersion(MetadataVersion.IBP_3_5_IV2).build();
        zkMigrationClusterConfig.serverProperties().put("zookeeper.metadata.migration.enable", "true");
        zkMigrationClusterConfig.serverProperties().put("controller.quorum.voters", "1@localhost:9092,2@localhost:9093,3@localhost:9094");
        zkMigrationClusterConfig.serverProperties().put("controller.listener.names", "CONTROLLER");
        zkMigrationClusterConfig.serverProperties().put("listener.security.protocol.map", "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
        zkMigrationClusterConfig.serverProperties().put("confluent.cluster.link.metadata.topic.enable", "true");
        generator.accept(zkMigrationClusterConfig);
        ClusterConfig hybridMigrationClusterConfig = ClusterConfig.defaultClusterBuilder().metadataVersion(MetadataVersion.IBP_3_6_IV2).type(Type.ZK_TO_KRAFT).build();
        hybridMigrationClusterConfig.serverProperties().put("listener.security.protocol.map", "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
        hybridMigrationClusterConfig.serverProperties().put("confluent.cluster.link.metadata.topic.enable", "true");
        generator.accept(hybridMigrationClusterConfig);
        ClusterConfig kraftClusterConfigLatestIbp = ClusterConfig.defaultClusterBuilder().type(Type.KRAFT).build();
        generator.accept(kraftClusterConfigLatestIbp);
        ClusterConfig kraftClusterConfigOlderIbpWithAlterMirrorTopicsSupport = ClusterConfig.defaultClusterBuilder().type(Type.KRAFT).metadataVersion(MetadataVersion.IBP_3_6_IV0).build();
        generator.accept(kraftClusterConfigOlderIbpWithAlterMirrorTopicsSupport);
    }

    private ClusterLinksRequestTest$() {
    }
}

