/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Properties;
import kafka.server.ConfigAdminManager;
import kafka.server.ConfigAdminManager$;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.MockConfigRepository;
import kafka.utils.TestUtils$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.AlterConfigsRequestData;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00055f\u0001\u0002\u0014(\u00011BQa\r\u0001\u0005\u0002QBqa\u000e\u0001C\u0002\u0013\u0005\u0001\b\u0003\u0004B\u0001\u0001\u0006I!\u000f\u0005\u0006\u0005\u0002!\ta\u0011\u0005\u0006#\u0002!\tA\u0015\u0005\u0006]\u0002!\tA\u0015\u0005\u0006_\u0002!\tA\u0015\u0005\u0006a\u0002!\t!\u001d\u0005\u0006q\u0002!\t!\u001d\u0005\bs\u0002\u0011\r\u0011\"\u0001{\u0011\u001d\t\u0019\u0001\u0001Q\u0001\nmDq!!\u0002\u0001\t\u0003\t9\u0001C\u0004\u0002&\u0001!\t!a\u0002\t\u000f\u0005%\u0002\u0001\"\u0001\u0002,!9\u0011Q\f\u0001\u0005\u0002\u0005\u001d\u0001bBA1\u0001\u0011\u0005\u0011q\u0001\u0005\b\u0003K\u0002A\u0011AA\u0004\u0011\u001d\tI\u0007\u0001C\u0001\u0003\u000fAq!!\u001c\u0001\t\u0003\t9\u0001C\u0004\u0002r\u0001!\t!a\u0002\t\u000f\u0005U\u0004\u0001\"\u0001\u0002\b!1\u0011\u0011\u0010\u0001\u0005\u0002ICa!a\u001f\u0001\t\u0003\u0011\u0006bBA?\u0001\u0011\u0005\u0011q\u0001\u0005\b\u0003\u0003\u0003A\u0011AA\u0004\u0011\u001d\t)\t\u0001C\u0001\u0003\u000fAq!!#\u0001\t\u0003\t9\u0001\u0003\u0004\u0002\u000e\u0002!\t!\u001d\u0005\u0007\u0003\u001f\u0003A\u0011A9\t\u000f\u0005E\u0005\u0001\"\u0001\u0002\b!9\u0011Q\u0013\u0001\u0005\u0002\u0005\u001d\u0001bBAM\u0001\u0011\u0005\u0011q\u0001\u0005\u0007\u0003;\u0003A\u0011\u0001*\t\r\u0005}\u0005\u0001\"\u0001r\u0011\u001d\t\t\u000b\u0001C\u0001\u0003\u000fAq!!*\u0001\t\u0003\t9\u0001C\u0004\u0002*\u0002!\t!a\u0002\u0003-\r{gNZ5h\u0003\u0012l\u0017N\\'b]\u0006<WM\u001d+fgRT!\u0001K\u0015\u0002\rM,'O^3s\u0015\u0005Q\u0013!B6bM.\f7\u0001A\n\u0003\u00015\u0002\"AL\u0019\u000e\u0003=R\u0011\u0001M\u0001\u0006g\u000e\fG.Y\u0005\u0003e=\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00016!\t1\u0004!D\u0001(\u0003\u0019awnZ4feV\t\u0011\b\u0005\u0002;\u007f5\t1H\u0003\u0002={\u0005)1\u000f\u001c45U*\ta(A\u0002pe\u001eL!\u0001Q\u001e\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\nQC\\3x\u0007>tg-[4BI6Lg.T1oC\u001e,'\u000f\u0006\u0002E\u000fB\u0011a'R\u0005\u0003\r\u001e\u0012!cQ8oM&<\u0017\tZ7j]6\u000bg.Y4fe\")\u0001\n\u0002a\u0001\u0013\u0006A!M]8lKJLE\r\u0005\u0002K\u001f6\t1J\u0003\u0002M\u001b\u0006!A.\u00198h\u0015\u0005q\u0015\u0001\u00026bm\u0006L!\u0001U&\u0003\u000f%sG/Z4fe\u0006\u0011\"M]8lKJ\u0004\u0014J\\2sK6,g\u000e^1m)\u0005\u0019\u0006C\u0001+l\u001d\t)\u0006N\u0004\u0002WK:\u0011qK\u0019\b\u00031\u0002t!!\u00170\u000f\u0005ikV\"A.\u000b\u0005q[\u0013A\u0002\u001fs_>$h(C\u0001?\u0013\tyV(\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003U\u0005T!aX\u001f\n\u0005\r$\u0017AB2p[6|gN\u0003\u0002+C&\u0011amZ\u0001\b[\u0016\u001c8/Y4f\u0015\t\u0019G-\u0003\u0002jU\u0006\u0011\u0013J\\2sK6,g\u000e^1m\u00032$XM]\"p]\u001aLwm\u001d*fcV,7\u000f\u001e#bi\u0006T!AZ4\n\u00051l'\u0001F!mi\u0016\u00148i\u001c8gS\u001e\u001c(+Z:pkJ\u001cWM\u0003\u0002jU\u0006\tBo\u001c9jG\u0006Ken\u0019:f[\u0016tG/\u00197\u0002-\rdWo\u001d;fe2Kgn[%oGJ,W.\u001a8uC2\fQB\u0019:pW\u0016\u0014\b\u0007T3hC\u000eLH#\u0001:\u0011\u0005M4hBA+u\u0013\t)(.A\fBYR,'oQ8oM&<7OU3rk\u0016\u001cH\u000fR1uC&\u0011An\u001e\u0006\u0003k*\fA\u0002^8qS\u000e\fE*Z4bGf\f1#\u001b8wC2LGMU3rk\u0016\u001cH/\u0012:s_J,\u0012a\u001f\t\u0003y~l\u0011! \u0006\u0003}\u001e\f\u0001B]3rk\u0016\u001cHo]\u0005\u0004\u0003\u0003i(\u0001C!qS\u0016\u0013(o\u001c:\u0002)%tg/\u00197jIJ+\u0017/^3ti\u0016\u0013(o\u001c:!\u0003%\"Xm\u001d;D_BLx+\u001b;i_V$\bK]3qe>\u001cWm]:fI\u001a{'/\u00138de\u0016lWM\u001c;bYR\u0011\u0011\u0011\u0002\t\u0004]\u0005-\u0011bAA\u0007_\t!QK\\5uQ\ra\u0011\u0011\u0003\t\u0005\u0003'\t\t#\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003\r\t\u0007/\u001b\u0006\u0005\u00037\ti\"A\u0004kkBLG/\u001a:\u000b\u0007\u0005}Q(A\u0003kk:LG/\u0003\u0003\u0002$\u0005U!\u0001\u0002+fgR\f!\t^3ti\u000e{\u0007/_,ji\"|W\u000f\u001e)sKB\u0013xnY3tg\u0016$gi\u001c:J]\u000e\u0014X-\\3oi\u0006dw+\u001b;i\u001d>\u0014V-];fgRlu\u000eZ5gS\u000e\fG/[8oQ\ri\u0011\u0011C\u0001NG>\u0004\u0018pV5uQ>,H\u000f\u0015:f!J|7-Z:tK\u00124uN]%oGJ,W.\u001a8uC2<\u0016\u000e\u001e5DYV\u001cH/\u001a:MS:\\\u0017N\\4O_J+\u0017/^3ti6{G-\u001b4jG\u0006$\u0018n\u001c8t)\u0019\ti#!\u0011\u0002RQ!\u0011\u0011BA\u0018\u0011\u001d\t\tD\u0004a\u0001\u0003g\t\u0001B^3sS\u001aLWM\u001d\t\n]\u0005U\u0012\u0011HA\u001d\u0003\u0013I1!a\u000e0\u0005%1UO\\2uS>t'\u0007\u0005\u0003\u0002<\u0005uR\"\u00016\n\u0007\u0005}\"N\u0001\u0012J]\u000e\u0014X-\\3oi\u0006d\u0017\t\u001c;fe\u000e{gNZ5hgJ+\u0017/^3ti\u0012\u000bG/\u0019\u0005\b\u0003\u0007r\u0001\u0019AA#\u0003\u0019\u0019wN\u001c4jOB!\u0011qIA'\u001b\t\tIEC\u0002\u0002L5\u000bA!\u001e;jY&!\u0011qJA%\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b\u0003'r\u0001\u0019AA+\u0003\u0019a\u0017N\\6JIB!\u0011qKA-\u001b\u00059\u0017bAA.O\n!Q+^5e\u0003E#Xm\u001d;D_BLx+\u001b;i_V$\bK]3Qe>\u001cWm]:fI\u001a{'/\u00138de\u0016lWM\u001c;bY^KG\u000f[\"mkN$XM\u001d'j].Lgn\u001a(p%\u0016\fX/Z:u\u001b>$\u0017NZ5dCRLwN\\:)\u0007=\t\t\"A*uKN$8i\u001c9z/&$\bn\\;u!J,\u0007K]8dKN\u001cX\r\u001a$pe&s7M]3nK:$\u0018\r\\,ji\"\u001cE.^:uKJd\u0015N\\6j]\u001etuNU3rk\u0016\u001cH/T8eS\u001aL7-\u0019;j_:\u001c(l\u001b\u0015\u0004!\u0005E\u0011\u0001\u0018;fgR\u001cu\u000e]=XSRDw.\u001e;Qe\u0016\u0004&o\\2fgN,GMR8s\u0013:\u001c'/Z7f]R\fGnV5uQ\u000ecWo\u001d;fe2Kgn[5oO:{'+Z9vKN$Xj\u001c3jM&\u001c\u0017\r^5p]NT6.T5he\u0006$\u0018n\u001c8)\u0007E\t\t\"\u0001\u0013uKN$8i\u001c9z/&$\bn\\;u!J,\u0007O]8dKN\u001cX\r\u001a$pe2+w-Y2zQ\r\u0011\u0012\u0011C\u0001\"i\u0016\u001cHOU3bgN,WN\u00197f\u0013:\u001c'/Z7f]R\fGNU3ta>t7/\u001a\u0015\u0004'\u0005E\u0011\u0001\b;fgR\u0014V-Y:tK6\u0014G.\u001a'fO\u0006\u001c\u0017PU3ta>t7/\u001a\u0015\u0004)\u0005E\u0011a\n;fgR4\u0016\r\\5eCR,'+Z:pkJ\u001cWMT1nK&\u001b8)\u001e:sK:$hj\u001c3f\u0013\u0012D3!FA\t\u0003a\u0011'o\\6fe2{wmZ3sc%s7M]3nK:$\u0018\r\\\u0001\u0019EJ|7.\u001a:M_\u001e<WM\u001d\u001aJ]\u000e\u0014X-\\3oi\u0006d\u0017\u0001\u0010;fgR\u0004&/\u001a9s_\u000e,7o]%oGJ,W.\u001a8uC2<\u0016\u000e\u001e5V]\u0006,H\u000f[8sSj,GM\u0011:pW\u0016\u0014Hj\\4hKJ\u001c\u0005.\u00198hKND3\u0001GA\t\u0003\t\"Xm\u001d;Qe\u0016\u0004(o\\2fgNLen\u0019:f[\u0016tG/\u00197XSRDg*\u001e7mg\"\u001a\u0011$!\u0005\u0002UQ,7\u000f\u001e)sKB\u0014xnY3tg&s7M]3nK:$\u0018\r\\,ji\"dunZ4fe\u000eC\u0017M\\4fg\"\u001a!$!\u0005\u0002OQ,7\u000f\u001e)sKB\u0014xnY3tg&s7M]3nK:$\u0018\r\\,ji\"$U\u000f\u001d7jG\u0006$Xm\u001d\u0015\u00047\u0005E\u0011a\u00052s_.,'\u000fT8hO\u0016\u0014\u0018\u0007T3hC\u000eL\u0018!\u00042s_.,'O\r'fO\u0006\u001c\u00170A\u0016uKN$\bK]3qe>\u001cWm]:MK\u001e\f7-_,ji\"\u0014%o\\6fe2{wmZ3s\u0007\"\fgnZ3tQ\rq\u0012\u0011C\u0001\u001ei\u0016\u001cH\u000f\u0015:faJ|7-Z:t\u0019\u0016<\u0017mY=XSRDg*\u001e7mg\"\u001aq$!\u0005\u0002EQ,7\u000f\u001e)sKB\u0014xnY3tg2+w-Y2z/&$\b\u000eR;qY&\u001c\u0017\r^3tQ\r\u0001\u0013\u0011C\u0001\u0013k:\\gn\\<o\u0013:\u001c'/Z7f]R\fG.A\u0007v].twn\u001e8MK\u001e\f7-_\u0001-i\u0016\u001cH\u000f\u0015:faJ|7-Z:t\u0013:\u001c'/Z7f]R\fGnV5uQVs7N\\8x]J+7o\\;sG\u0016D3aIA\t\u0003\u001d\"Xm\u001d;Qe\u0016\u0004(o\\2fgNdUmZ1ds^KG\u000f[+oW:|wO\u001c*fg>,(oY3)\u0007\u0011\n\t\"\u0001\fuKN$8i\u001c8uC&t7\u000fR;qY&\u001c\u0017\r^3tQ\r)\u0013\u0011\u0003")
public class ConfigAdminManagerTest {
    private final Logger logger = LoggerFactory.getLogger(ConfigAdminManagerTest.class);
    private final ApiError invalidRequestError = new ApiError(Errors.INVALID_REQUEST);

    public Logger logger() {
        return this.logger;
    }

    public ConfigAdminManager newConfigAdminManager(Integer brokerId) {
        Properties config = TestUtils$.MODULE$.createBrokerConfig(Predef$.MODULE$.Integer2int(brokerId), null, true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        return new ConfigAdminManager(Predef$.MODULE$.Integer2int(brokerId), new KafkaConfig((Map)config), (ConfigRepository)new MockConfigRepository(), (ClusterLinkFactory.LinkManager)Mockito.mock(ClusterLinkFactory.LinkManager.class));
    }

    public IncrementalAlterConfigsRequestData.AlterConfigsResource broker0Incremental() {
        return new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList(new IncrementalAlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar").setConfigOperation(AlterConfigOp.OpType.SET.id())).iterator()));
    }

    public IncrementalAlterConfigsRequestData.AlterConfigsResource topicAIncremental() {
        return new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList(new IncrementalAlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar").setConfigOperation(AlterConfigOp.OpType.SET.id())).iterator()));
    }

    public IncrementalAlterConfigsRequestData.AlterConfigsResource clusterLinkIncremental() {
        return new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("test-link").setResourceType(ConfigResource.Type.CLUSTER_LINK.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList(new IncrementalAlterConfigsRequestData.AlterableConfig().setName(ClusterLinkConfig$.MODULE$.AclFiltersProp()).setValue("").setConfigOperation(AlterConfigOp.OpType.SET.id()), new IncrementalAlterConfigsRequestData.AlterableConfig().setName(ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp()).setValue("").setConfigOperation(AlterConfigOp.OpType.SET.id()), new IncrementalAlterConfigsRequestData.AlterableConfig().setName(ClusterLinkConfig$.MODULE$.TopicFiltersProp()).setValue("").setConfigOperation(AlterConfigOp.OpType.SET.id()), new IncrementalAlterConfigsRequestData.AlterableConfig().setName(ClusterLinkConfig$.MODULE$.AclSyncEnableProp()).setValue("false").setConfigOperation(AlterConfigOp.OpType.SET.id()), new IncrementalAlterConfigsRequestData.AlterableConfig().setName(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()).setValue("false").setConfigOperation(AlterConfigOp.OpType.SET.id()), new IncrementalAlterConfigsRequestData.AlterableConfig().setName(ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()).setValue("false").setConfigOperation(AlterConfigOp.OpType.SET.id())).iterator()));
    }

    public AlterConfigsRequestData.AlterConfigsResource broker0Legacy() {
        return new AlterConfigsRequestData.AlterConfigsResource().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList(new AlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar")).iterator()));
    }

    public AlterConfigsRequestData.AlterConfigsResource topicALegacy() {
        return new AlterConfigsRequestData.AlterConfigsResource().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList(new AlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar")).iterator()));
    }

    public ApiError invalidRequestError() {
        return this.invalidRequestError;
    }

    @Test
    public void testCopyWithoutPreprocessedForIncremental() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        IncrementalAlterConfigsRequestData.AlterConfigsResource broker0 = this.broker0Incremental();
        IncrementalAlterConfigsRequestData.AlterConfigsResource topicA = this.topicAIncremental();
        IncrementalAlterConfigsRequestData request = new IncrementalAlterConfigsRequestData().setValidateOnly(true).setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList(broker0, topicA).iterator()));
        IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> processed1 = new IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError>();
        processed1.put(broker0, ApiError.NONE);
        Assertions.assertEquals((Object)new IncrementalAlterConfigsRequestData().setValidateOnly(true).setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList(topicA.duplicate()).iterator())), (Object)manager.maybeModifyIncrementalAlterConfigRequest(request, processed1));
        IdentityHashMap processed2 = new IdentityHashMap();
        Assertions.assertEquals((Object)new IncrementalAlterConfigsRequestData().setValidateOnly(true).setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList(broker0.duplicate(), topicA.duplicate()).iterator())), (Object)manager.maybeModifyIncrementalAlterConfigRequest(request, processed2));
        IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> processed3 = new IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError>();
        processed3.put(broker0, ApiError.NONE);
        processed3.put(topicA, ApiError.NONE);
        Assertions.assertEquals((Object)new IncrementalAlterConfigsRequestData().setValidateOnly(true), (Object)manager.maybeModifyIncrementalAlterConfigRequest(request, processed3));
    }

    @Test
    public void testCopyWithoutPreProcessedForIncrementalWithNoRequestModification() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        IncrementalAlterConfigsRequestData.AlterConfigsResource broker0 = this.broker0Incremental();
        IncrementalAlterConfigsRequestData.AlterConfigsResource topicA = this.topicAIncremental();
        IncrementalAlterConfigsRequestData request = new IncrementalAlterConfigsRequestData().setValidateOnly(true).setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList(broker0, topicA).iterator()));
        IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> processed1 = new IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError>();
        processed1.put(broker0, ApiError.NONE);
        Assertions.assertEquals((Object)new IncrementalAlterConfigsRequestData().setValidateOnly(true).setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList(topicA.duplicate()).iterator())), (Object)manager.maybeModifyIncrementalAlterConfigRequest(request, processed1));
        IdentityHashMap processed2 = new IdentityHashMap();
        Assertions.assertEquals((Object)new IncrementalAlterConfigsRequestData().setValidateOnly(true).setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList(broker0.duplicate(), topicA.duplicate()).iterator())), (Object)manager.maybeModifyIncrementalAlterConfigRequest(request, processed2));
        IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> processed3 = new IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError>();
        processed3.put(broker0, ApiError.NONE);
        processed3.put(topicA, ApiError.NONE);
        Assertions.assertEquals((Object)new IncrementalAlterConfigsRequestData().setValidateOnly(true), (Object)manager.maybeModifyIncrementalAlterConfigRequest(request, processed3));
    }

    public void copyWithoutPreProcessedForIncrementalWithClusterLinkingNoRequestModifications(Properties config, Uuid linkId, Function2<IncrementalAlterConfigsRequestData, IncrementalAlterConfigsRequestData, BoxedUnit> verifier) {
        ClusterLinkFactory.LinkManager linkManager = (ClusterLinkFactory.LinkManager)Mockito.mock(ClusterLinkFactory.LinkManager.class);
        Mockito.when((Object)linkManager.listClusterLinks()).thenReturn((Object)new .colon.colon((Object)new ClusterLinkData("test-link", linkId, (Option)None$.MODULE$, (Option)None$.MODULE$, false), (List)Nil$.MODULE$));
        ConfigAdminManager manager = new ConfigAdminManager(1, new KafkaConfig((Map)config), (ConfigRepository)new MockConfigRepository(), linkManager);
        IncrementalAlterConfigsRequestData request = new IncrementalAlterConfigsRequestData().setValidateOnly(true).setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList(this.clusterLinkIncremental()).iterator()));
        IncrementalAlterConfigsRequestData actualRequest = manager.maybeModifyIncrementalAlterConfigRequest(request, new IdentityHashMap());
        verifier.apply((Object)request, (Object)actualRequest);
    }

    @Test
    public void testCopyWithoutPreProcessedForIncrementalWithClusterLinkingNoRequestModifications() {
        Properties config = TestUtils$.MODULE$.createBrokerConfig(1, "", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        this.copyWithoutPreProcessedForIncrementalWithClusterLinkingNoRequestModifications(config, Uuid.randomUuid(), (Function2<IncrementalAlterConfigsRequestData, IncrementalAlterConfigsRequestData, BoxedUnit>)(Function2 & Serializable)(x0$1, x1$1) -> {
            ConfigAdminManagerTest.$anonfun$testCopyWithoutPreProcessedForIncrementalWithClusterLinkingNoRequestModifications$1(x0$1, x1$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCopyWithoutPreProcessedForIncrementalWithClusterLinkingNoRequestModificationsZk() {
        Properties config = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        this.copyWithoutPreProcessedForIncrementalWithClusterLinkingNoRequestModifications(config, Uuid.randomUuid(), (Function2<IncrementalAlterConfigsRequestData, IncrementalAlterConfigsRequestData, BoxedUnit>)(Function2 & Serializable)(x0$1, x1$1) -> {
            ConfigAdminManagerTest.$anonfun$testCopyWithoutPreProcessedForIncrementalWithClusterLinkingNoRequestModificationsZk$1(x0$1, x1$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCopyWithoutPreProcessedForIncrementalWithClusterLinkingNoRequestModificationsZkMigration() {
        Properties config = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        config.put("confluent.cluster.link.metadata.topic.enable", "true");
        TestUtils$.MODULE$.enableZkMigration(config);
        Uuid linkId = Uuid.randomUuid();
        this.copyWithoutPreProcessedForIncrementalWithClusterLinkingNoRequestModifications(config, linkId, (Function2<IncrementalAlterConfigsRequestData, IncrementalAlterConfigsRequestData, BoxedUnit>)(Function2 & Serializable)(x0$1, x1$1) -> {
            ConfigAdminManagerTest.$anonfun$testCopyWithoutPreProcessedForIncrementalWithClusterLinkingNoRequestModificationsZkMigration$1(linkId, x0$1, x1$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCopyWithoutPreprocessedForLegacy() {
        AlterConfigsRequestData.AlterConfigsResource broker0 = this.broker0Legacy();
        AlterConfigsRequestData.AlterConfigsResource topicA = this.topicALegacy();
        AlterConfigsRequestData request = new AlterConfigsRequestData().setValidateOnly(true).setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList(broker0, topicA).iterator()));
        IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> processed1 = new IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError>();
        processed1.put(broker0, ApiError.NONE);
        Assertions.assertEquals((Object)new AlterConfigsRequestData().setValidateOnly(true).setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList(topicA.duplicate()).iterator())), (Object)ConfigAdminManager$.MODULE$.copyWithoutPreprocessed(request, processed1));
        IdentityHashMap processed2 = new IdentityHashMap();
        Assertions.assertEquals((Object)new AlterConfigsRequestData().setValidateOnly(true).setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList(broker0.duplicate(), topicA.duplicate()).iterator())), (Object)ConfigAdminManager$.MODULE$.copyWithoutPreprocessed(request, processed2));
        IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> processed3 = new IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError>();
        processed3.put(broker0, ApiError.NONE);
        processed3.put(topicA, ApiError.NONE);
        Assertions.assertEquals((Object)new AlterConfigsRequestData().setValidateOnly(true), (Object)ConfigAdminManager$.MODULE$.copyWithoutPreprocessed(request, processed3));
    }

    @Test
    public void testReassembleIncrementalResponse() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        IncrementalAlterConfigsRequestData.AlterConfigsResource broker0 = this.broker0Incremental();
        IncrementalAlterConfigsRequestData.AlterConfigsResource topicA = this.topicAIncremental();
        IncrementalAlterConfigsRequestData original = new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList(broker0, topicA).iterator()));
        IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> preprocessed1 = new IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError>();
        preprocessed1.put(broker0, this.invalidRequestError());
        IncrementalAlterConfigsResponseData persistentResponses1 = new IncrementalAlterConfigsResponseData().setResponses(Arrays.asList(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null)));
        Assertions.assertEquals((Object)new IncrementalAlterConfigsResponseData().setResponses(Arrays.asList(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage(Errors.INVALID_REQUEST.message()), new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null))), (Object)manager.reassembleIncrementalResponse(original, preprocessed1, persistentResponses1));
        IdentityHashMap preprocessed2 = new IdentityHashMap();
        IncrementalAlterConfigsResponseData persistentResponses2 = new IncrementalAlterConfigsResponseData().setResponses(Arrays.asList(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null), new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null)));
        Assertions.assertEquals((Object)new IncrementalAlterConfigsResponseData().setResponses(Arrays.asList(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null), new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null))), (Object)manager.reassembleIncrementalResponse(original, preprocessed2, persistentResponses2));
    }

    @Test
    public void testReassembleLegacyResponse() {
        AlterConfigsRequestData.AlterConfigsResource broker0 = this.broker0Legacy();
        AlterConfigsRequestData.AlterConfigsResource topicA = this.topicALegacy();
        AlterConfigsRequestData original = new AlterConfigsRequestData().setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList(broker0, topicA).iterator()));
        IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> preprocessed1 = new IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError>();
        preprocessed1.put(broker0, this.invalidRequestError());
        AlterConfigsResponseData persistentResponses1 = new AlterConfigsResponseData().setResponses(Arrays.asList(new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null)));
        Assertions.assertEquals((Object)new AlterConfigsResponseData().setResponses(Arrays.asList(new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage(Errors.INVALID_REQUEST.message()), new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null))), (Object)ConfigAdminManager$.MODULE$.reassembleLegacyResponse(original, preprocessed1, persistentResponses1));
        IdentityHashMap preprocessed2 = new IdentityHashMap();
        AlterConfigsResponseData persistentResponses2 = new AlterConfigsResponseData().setResponses(Arrays.asList(new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null), new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null)));
        Assertions.assertEquals((Object)new AlterConfigsResponseData().setResponses(Arrays.asList(new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("0").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null), new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("a").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(null))), (Object)ConfigAdminManager$.MODULE$.reassembleLegacyResponse(original, preprocessed2, persistentResponses2));
    }

    @Test
    public void testValidateResourceNameIsCurrentNodeId() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(5));
        manager.validateResourceNameIsCurrentNodeId("5");
        Assertions.assertEquals((Object)"Node id must be an integer, but it is: ", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> manager.validateResourceNameIsCurrentNodeId("")).getMessage());
        Assertions.assertEquals((Object)"Unexpected broker id, expected 5, but received 3", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> manager.validateResourceNameIsCurrentNodeId("3")).getMessage());
        Assertions.assertEquals((Object)"Node id must be an integer, but it is: e", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> manager.validateResourceNameIsCurrentNodeId("e")).getMessage());
    }

    public IncrementalAlterConfigsRequestData.AlterConfigsResource brokerLogger1Incremental() {
        return new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("1").setResourceType(ConfigResource.Type.BROKER_LOGGER.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList(new IncrementalAlterConfigsRequestData.AlterableConfig().setName(this.logger().getName()).setValue("INFO").setConfigOperation(AlterConfigOp.OpType.SET.id())).iterator()));
    }

    public IncrementalAlterConfigsRequestData.AlterConfigsResource brokerLogger2Incremental() {
        return new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("2").setResourceType(ConfigResource.Type.BROKER_LOGGER.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList(new IncrementalAlterConfigsRequestData.AlterableConfig().setName(this.logger().getName()).setValue(null).setConfigOperation(AlterConfigOp.OpType.SET.id())).iterator()));
    }

    @Test
    public void testPreprocessIncrementalWithUnauthorizedBrokerLoggerChanges() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        IncrementalAlterConfigsRequestData.AlterConfigsResource brokerLogger1 = this.brokerLogger1Incremental();
        Assertions.assertEquals(Collections.singletonMap(brokerLogger1, new ApiError(Errors.CLUSTER_AUTHORIZATION_FAILED, null)), (Object)manager.preprocess(new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList(brokerLogger1).iterator())), (Function2 & Serializable)(x$1, x$2) -> BoxesRunTime.boxToBoolean((boolean)ConfigAdminManagerTest.$anonfun$testPreprocessIncrementalWithUnauthorizedBrokerLoggerChanges$1(x$1, x$2)), manager.preprocess$default$3()));
    }

    @Test
    public void testPreprocessIncrementalWithNulls() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(2));
        IncrementalAlterConfigsRequestData.AlterConfigsResource brokerLogger2 = this.brokerLogger2Incremental();
        Assertions.assertEquals(Collections.singletonMap(brokerLogger2, new ApiError(Errors.INVALID_REQUEST, new StringBuilder(31).append("Null value not supported for : ").append(this.logger().getName()).toString())), (Object)manager.preprocess(new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList(brokerLogger2).iterator())), (Function2 & Serializable)(x$3, x$4) -> BoxesRunTime.boxToBoolean((boolean)ConfigAdminManagerTest.$anonfun$testPreprocessIncrementalWithNulls$1(x$3, x$4)), manager.preprocess$default$3()));
    }

    @Test
    public void testPreprocessIncrementalWithLoggerChanges() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        IncrementalAlterConfigsRequestData.AlterConfigsResource brokerLogger1 = this.brokerLogger1Incremental();
        Assertions.assertEquals(Collections.singletonMap(brokerLogger1, new ApiError(Errors.NONE, null)), (Object)manager.preprocess(new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList(brokerLogger1).iterator())), (Function2 & Serializable)(x$5, x$6) -> BoxesRunTime.boxToBoolean((boolean)ConfigAdminManagerTest.$anonfun$testPreprocessIncrementalWithLoggerChanges$1(x$5, x$6)), manager.preprocess$default$3()));
    }

    @Test
    public void testPreprocessIncrementalWithDuplicates() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        IncrementalAlterConfigsRequestData.AlterConfigsResource brokerLogger1a = this.brokerLogger1Incremental();
        IncrementalAlterConfigsRequestData.AlterConfigsResource brokerLogger1b = this.brokerLogger1Incremental();
        IdentityHashMap output = manager.preprocess(new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList(brokerLogger1a, brokerLogger1b).iterator())), (Function2 & Serializable)(x$7, x$8) -> BoxesRunTime.boxToBoolean((boolean)ConfigAdminManagerTest.$anonfun$testPreprocessIncrementalWithDuplicates$1(x$7, x$8)), manager.preprocess$default$3());
        Assertions.assertEquals((int)2, (int)output.size());
        new .colon.colon((Object)brokerLogger1a, (List)new .colon.colon((Object)brokerLogger1b, (List)Nil$.MODULE$)).foreach((Function1 & Serializable)r -> {
            ConfigAdminManagerTest.$anonfun$testPreprocessIncrementalWithDuplicates$2(output, r);
            return BoxedUnit.UNIT;
        });
    }

    public AlterConfigsRequestData.AlterConfigsResource brokerLogger1Legacy() {
        return new AlterConfigsRequestData.AlterConfigsResource().setResourceName("1").setResourceType(ConfigResource.Type.BROKER_LOGGER.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList(new AlterConfigsRequestData.AlterableConfig().setName(this.logger().getName()).setValue("INFO")).iterator()));
    }

    public AlterConfigsRequestData.AlterConfigsResource broker2Legacy() {
        return new AlterConfigsRequestData.AlterConfigsResource().setResourceName("2").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList(new AlterConfigsRequestData.AlterableConfig().setName(this.logger().getName()).setValue(null)).iterator()));
    }

    @Test
    public void testPreprocessLegacyWithBrokerLoggerChanges() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        AlterConfigsRequestData.AlterConfigsResource brokerLogger1 = this.brokerLogger1Legacy();
        Assertions.assertEquals(Collections.singletonMap(brokerLogger1, new ApiError(Errors.INVALID_REQUEST, "Unknown resource type 8")), (Object)manager.preprocess(new AlterConfigsRequestData().setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList(brokerLogger1).iterator()))));
    }

    @Test
    public void testPreprocessLegacyWithNulls() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(2));
        AlterConfigsRequestData.AlterConfigsResource brokerLogger2 = this.broker2Legacy();
        Assertions.assertEquals(Collections.singletonMap(brokerLogger2, new ApiError(Errors.INVALID_REQUEST, new StringBuilder(31).append("Null value not supported for : ").append(this.logger().getName()).toString())), (Object)manager.preprocess(new AlterConfigsRequestData().setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList(brokerLogger2).iterator()))));
    }

    @Test
    public void testPreprocessLegacyWithDuplicates() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        AlterConfigsRequestData.AlterConfigsResource brokerLogger1a = this.brokerLogger1Legacy();
        AlterConfigsRequestData.AlterConfigsResource brokerLogger1b = this.brokerLogger1Legacy();
        IdentityHashMap output = manager.preprocess(new AlterConfigsRequestData().setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList(brokerLogger1a, brokerLogger1b).iterator())));
        Assertions.assertEquals((int)2, (int)output.size());
        new .colon.colon((Object)brokerLogger1a, (List)new .colon.colon((Object)brokerLogger1b, (List)Nil$.MODULE$)).foreach((Function1 & Serializable)r -> {
            ConfigAdminManagerTest.$anonfun$testPreprocessLegacyWithDuplicates$1(output, r);
            return BoxedUnit.UNIT;
        });
    }

    public IncrementalAlterConfigsRequestData.AlterConfigsResource unknownIncremental() {
        return new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("unknown").setResourceType(ConfigResource.Type.UNKNOWN.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList(new IncrementalAlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar").setConfigOperation(AlterConfigOp.OpType.SET.id())).iterator()));
    }

    public AlterConfigsRequestData.AlterConfigsResource unknownLegacy() {
        return new AlterConfigsRequestData.AlterConfigsResource().setResourceName("unknown").setResourceType(ConfigResource.Type.UNKNOWN.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList(new AlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar")).iterator()));
    }

    @Test
    public void testPreprocessIncrementalWithUnknownResource() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        IncrementalAlterConfigsRequestData.AlterConfigsResource unknown = this.unknownIncremental();
        Assertions.assertEquals(Collections.singletonMap(unknown, new ApiError(Errors.INVALID_REQUEST, "Unknown resource type 0")), (Object)manager.preprocess(new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList(unknown).iterator())), (Function2 & Serializable)(x$9, x$10) -> BoxesRunTime.boxToBoolean((boolean)ConfigAdminManagerTest.$anonfun$testPreprocessIncrementalWithUnknownResource$1(x$9, x$10)), manager.preprocess$default$3()));
    }

    @Test
    public void testPreprocessLegacyWithUnknownResource() {
        ConfigAdminManager manager = this.newConfigAdminManager(Predef$.MODULE$.int2Integer(1));
        AlterConfigsRequestData.AlterConfigsResource unknown = this.unknownLegacy();
        Assertions.assertEquals(Collections.singletonMap(unknown, new ApiError(Errors.INVALID_REQUEST, "Unknown resource type 0")), (Object)manager.preprocess(new AlterConfigsRequestData().setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList(unknown).iterator()))));
    }

    @Test
    public void testContainsDuplicates() {
        Assertions.assertFalse((boolean)ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)Nil$.MODULE$));
        Assertions.assertFalse((boolean)ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)));
        Assertions.assertTrue((boolean)ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)new .colon.colon((Object)"foo", (List)new .colon.colon((Object)"foo", (List)Nil$.MODULE$))));
        Assertions.assertFalse((boolean)ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)new .colon.colon((Object)"foo", (List)new .colon.colon((Object)"bar", (List)new .colon.colon((Object)"baz", (List)Nil$.MODULE$)))));
        Assertions.assertTrue((boolean)ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)new .colon.colon((Object)"foo", (List)new .colon.colon((Object)"bar", (List)new .colon.colon((Object)"baz", (List)new .colon.colon((Object)"foo", (List)Nil$.MODULE$))))));
    }

    public static final /* synthetic */ void $anonfun$testCopyWithoutPreProcessedForIncrementalWithClusterLinkingNoRequestModifications$1(IncrementalAlterConfigsRequestData x0$1, IncrementalAlterConfigsRequestData x1$1) {
        Assertions.assertEquals((Object)x0$1, (Object)x1$1);
    }

    public static final /* synthetic */ void $anonfun$testCopyWithoutPreProcessedForIncrementalWithClusterLinkingNoRequestModificationsZk$1(IncrementalAlterConfigsRequestData x0$1, IncrementalAlterConfigsRequestData x1$1) {
        Assertions.assertEquals((Object)x0$1, (Object)x1$1);
    }

    public static final /* synthetic */ void $anonfun$testCopyWithoutPreProcessedForIncrementalWithClusterLinkingNoRequestModificationsZkMigration$1(Uuid linkId$1, IncrementalAlterConfigsRequestData x0$1, IncrementalAlterConfigsRequestData x1$1) {
        IncrementalAlterConfigsRequestData.AlterConfigsResource resource = x0$1.resources().find(ConfigResource.Type.CLUSTER_LINK.id(), "test-link");
        IncrementalAlterConfigsRequestData.AlterConfigsResource modifiedResource = x1$1.resources().find(ConfigResource.Type.CLUSTER_LINK.id(), "test-link");
        Assertions.assertEquals((Object)resource.configs(), (Object)modifiedResource.configs());
        Assertions.assertEquals((Object)modifiedResource.clusterLinkResourceId(), (Object)linkId$1.toString());
        Assertions.assertEquals((Object)modifiedResource.resourceName(), (Object)"test-link");
    }

    public static final /* synthetic */ boolean $anonfun$testPreprocessIncrementalWithUnauthorizedBrokerLoggerChanges$1(ResourceType x$1, String x$2) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testPreprocessIncrementalWithNulls$1(ResourceType x$3, String x$4) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testPreprocessIncrementalWithLoggerChanges$1(ResourceType x$5, String x$6) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testPreprocessIncrementalWithDuplicates$1(ResourceType x$7, String x$8) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$testPreprocessIncrementalWithDuplicates$2(IdentityHashMap output$1, IncrementalAlterConfigsRequestData.AlterConfigsResource r) {
        Assertions.assertEquals((Object)new ApiError(Errors.INVALID_REQUEST, "Each resource must appear at most once."), output$1.get(r));
    }

    public static final /* synthetic */ void $anonfun$testPreprocessLegacyWithDuplicates$1(IdentityHashMap output$2, AlterConfigsRequestData.AlterConfigsResource r) {
        Assertions.assertEquals((Object)new ApiError(Errors.INVALID_REQUEST, "Each resource must appear at most once."), output$2.get(r));
    }

    public static final /* synthetic */ boolean $anonfun$testPreprocessIncrementalWithUnknownResource$1(ResourceType x$9, String x$10) {
        return false;
    }
}

