/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.server.ConfluentBrokerPlacementConstraintTest$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015d\u0001\u0002\f\u0018\u0005qAQa\t\u0001\u0005\u0002\u0011Bqa\n\u0001C\u0002\u0013\u0005\u0001\u0006\u0003\u00040\u0001\u0001\u0006I!\u000b\u0005\ba\u0001\u0011\r\u0011\"\u0001)\u0011\u0019\t\u0004\u0001)A\u0005S!9!\u0007\u0001b\u0001\n\u0003\u0019\u0004B\u0002#\u0001A\u0003%A\u0007C\u0004F\u0001\t\u0007I\u0011\u0001$\t\r\u001d\u0003\u0001\u0015!\u0003=\u0011\u0015A\u0005\u0001\"\u0011J\u0011\u0015\t\u0006\u0001\"\u0011S\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'Aq!!\b\u0001\t\u0003\ty\u0002C\u0004\u0002*\u0001!\t!a\u000b\t\r\u0005U\u0002\u0001\"\u0015)\u000f\u001d\t9d\u0006E\u0001\u0003s1aAF\f\t\u0002\u0005m\u0002BB\u0012\u0013\t\u0003\t\u0019\u0005C\u0004\u0002FI!\t!a\u0012\t\u000f\u0005}#\u0003\"\u0001\u0002b\t13i\u001c8gYV,g\u000e\u001e\"s_.,'\u000f\u00157bG\u0016lWM\u001c;D_:\u001cHO]1j]R$Vm\u001d;\u000b\u0005aI\u0012AB:feZ,'OC\u0001\u001b\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u000f\u0011\u0005y\tS\"A\u0010\u000b\u0005\u0001J\u0012aA1qS&\u0011!e\b\u0002\u0017\u0013:$Xm\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012!\n\t\u0003M\u0001i\u0011aF\u0001\bEJ|7.\u001a:2+\u0005I\u0003C\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#aA%oi\u0006A!M]8lKJ\f\u0004%A\u0004ce>\\WM\u001d\u001a\u0002\u0011\t\u0014xn[3se\u0001\nAA]1dWV\tA\u0007\u0005\u00036u%bT\"\u0001\u001c\u000b\u0005]B\u0014!C5n[V$\u0018M\u00197f\u0015\tI4&\u0001\u0006d_2dWm\u0019;j_:L!a\u000f\u001c\u0003\u00075\u000b\u0007\u000f\u0005\u0002>\u00056\taH\u0003\u0002@\u0001\u0006!A.\u00198h\u0015\u0005\t\u0015\u0001\u00026bm\u0006L!a\u0011 \u0003\rM#(/\u001b8h\u0003\u0015\u0011\u0018mY6!\u0003U\u0011'o\\6fe\u000e{gn\u001d;sC&tGOV1mk\u0016,\u0012\u0001P\u0001\u0017EJ|7.\u001a:D_:\u001cHO]1j]R4\u0016\r\\;fA\u0005yq-\u001a8fe\u0006$XmQ8oM&<7/F\u0001K!\rYEJT\u0007\u0002q%\u0011Q\n\u000f\u0002\u0004'\u0016\f\bC\u0001\u0014P\u0013\t\u0001vCA\u0006LC\u001a\\\u0017mQ8oM&<\u0017AF6sC\u001a$8i\u001c8ue>dG.\u001a:D_:4\u0017nZ:\u0015\u0003M\u00032a\u0013'U!\t)\u0006,D\u0001W\u0015\t9\u0006)\u0001\u0003vi&d\u0017BA-W\u0005)\u0001&o\u001c9feRLWm]\u0001 i\u0016\u001cHo\u0011:fCR,Gk\u001c9jG^KG\u000f\u001b\"s_.,'OV1mk\u0016\u001cHC\u0001/`!\tQS,\u0003\u0002_W\t!QK\\5u\u0011\u0015\u0001G\u00021\u0001b\u0003\u0019\tXo\u001c:v[B\u0011!-\u001b\b\u0003G\u001e\u0004\"\u0001Z\u0016\u000e\u0003\u0015T!AZ\u000e\u0002\rq\u0012xn\u001c;?\u0013\tA7&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0007*T!\u0001[\u0016)\t1a\u00070\u001f\t\u0003[Zl\u0011A\u001c\u0006\u0003_B\fa\u0001]1sC6\u001c(BA9s\u0003\u001dQW\u000f]5uKJT!a\u001d;\u0002\u000b),h.\u001b;\u000b\u0003U\f1a\u001c:h\u0013\t9hNA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fAA\\1nK\u0006\n!0\u0001\u0012|I&\u001c\b\u000f\\1z\u001d\u0006lW- \u0018|CJ<W/\\3oiN<\u0016\u000e\u001e5OC6,7/ \u0015\u0007\u0019q\f)!a\u0002\u0011\u0007u\f\t!D\u0001\u007f\u0015\tyh.\u0001\u0005qe>4\u0018\u000eZ3s\u0013\r\t\u0019A \u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\t\u0005%\u0011QB\u0011\u0003\u0003\u0017\t!A_6\"\u0005\u0005=\u0011!B6sC\u001a$\u0018A\b;fgR\u001c%/Z1uKR{\u0007/[2Pm\u0016\u0014(/\u001b3f\t\u00164\u0017-\u001e7u)\ra\u0016Q\u0003\u0005\u0006A6\u0001\r!\u0019\u0015\u0005\u001b1D\u0018\u0010\u000b\u0004\u000ey\u0006\u0015\u00111\u0004\u0017\u0005\u0003\u0013\ti!A\u0017uKN$H)\u001a7fi&tw\rV8qS\u000e\u001cuN\u001c4jO\u0012{Wm\u001d(piJ+g/\u001a:u)>$UMZ1vYR$2\u0001XA\u0011\u0011\u0015\u0001g\u00021\u0001bQ\u0011qA\u000e_=)\r9a\u0018QAA\u0014Y\u0011\tI!!\u0004\u0002;Q,7\u000f\u001e,bY&$\u0017\r^3D_:\u001cHO]1j]R$UMZ1vYR$2\u0001XA\u0017\u0011\u0015\u0001w\u00021\u0001bQ\u0011yA\u000e_=)\r=a\u0018QAA\u001aY\u0011\tI!!\u0004\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u0001'\u0007>tg\r\\;f]R\u0014%o\\6feBc\u0017mY3nK:$8i\u001c8tiJ\f\u0017N\u001c;UKN$\bC\u0001\u0014\u0013'\r\u0011\u0012Q\b\t\u0004U\u0005}\u0012bAA!W\t1\u0011I\\=SK\u001a$\"!!\u000f\u0002\u0019\r\u0014X-\u0019;f\u0007>tg-[4\u0015\t\u0005%\u00131\u000b\t\u0007E\u0006-\u0013-!\u0014\n\u0005mR\u0007cA\u001f\u0002P%\u0019\u0011\u0011\u000b \u0003\r=\u0013'.Z2u\u0011\u001d\t)\u0006\u0006a\u0001\u0003/\nqA\u0019:pW\u0016\u00148\u000f\u0005\u0003L\u0019\u0006e\u0003c\u0001\u0014\u0002\\%\u0019\u0011QL\f\u0003\u0017-\u000bgm[1Ce>\\WM]\u0001\u0011E>|Go\u001d;sCB\u001cVM\u001d<feN$2!YA2\u0011\u001d\t)&\u0006a\u0001\u0003/\u0002")
public final class ConfluentBrokerPlacementConstraintTest
extends IntegrationTestHarness {
    private final int broker1;
    private final int broker2;
    private final scala.collection.immutable.Map<Object, String> rack = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker1())), (Object)"a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker2())), (Object)"b")}));
    private final String brokerConstraintValue;

    public static scala.collection.immutable.Map<String, Object> createConfig(Seq<KafkaBroker> brokers) {
        return ConfluentBrokerPlacementConstraintTest$.MODULE$.createConfig(brokers);
    }

    public int broker1() {
        return this.broker1;
    }

    public int broker2() {
        return this.broker2;
    }

    public scala.collection.immutable.Map<Object, String> rack() {
        return this.rack;
    }

    public String brokerConstraintValue() {
        return this.brokerConstraintValue;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, this.zkConnectOrNull(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)config -> {
            config.setProperty(KafkaConfig$.MODULE$.RackProp(), (String)this.rack().apply((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(config.getProperty(KafkaConfig$.MODULE$.BrokerIdProp()))))));
            config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), "false");
            config.setProperty(KafkaConfig$.MODULE$.ControlledShutdownMaxRetriesProp(), "1");
            config.setProperty(KafkaConfig$.MODULE$.ControlledShutdownRetryBackoffMsProp(), "1000");
            config.setProperty(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), "1000");
            config.setProperty(KafkaConfig$.MODULE$.TopicPlacementConstraintsProp(), this.brokerConstraintValue());
            return KafkaConfig$.MODULE$.fromProps(config);
        });
    }

    @Override
    public Seq<Properties> kraftControllerConfigs() {
        Seq<Properties> controllerConfigs = super.kraftControllerConfigs();
        controllerConfigs.foreach((Function1 & Serializable)prop -> prop.setProperty(KafkaConfig$.MODULE$.TopicPlacementConstraintsProp(), this.brokerConstraintValue()));
        return controllerConfigs;
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateTopicWithBrokerValues(String quorum) {
        try (AdminClient resource_resource = (AdminClient)Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(ConfluentBrokerPlacementConstraintTest$.MODULE$.createConfig((Seq<KafkaBroker>)this.brokers())).asJava());){
            ConfluentBrokerPlacementConstraintTest.$anonfun$testCreateTopicWithBrokerValues$1(this, resource_resource);
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateTopicOverrideDefault(String quorum) {
        try (AdminClient resource_resource = (AdminClient)Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(ConfluentBrokerPlacementConstraintTest$.MODULE$.createConfig((Seq<KafkaBroker>)this.brokers())).asJava());){
            ConfluentBrokerPlacementConstraintTest.$anonfun$testCreateTopicOverrideDefault$1(this, resource_resource);
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeletingTopicConfigDoesNotRevertToDefault(String quorum) {
        try (AdminClient resource_resource = (AdminClient)Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(ConfluentBrokerPlacementConstraintTest$.MODULE$.createConfig((Seq<KafkaBroker>)this.brokers())).asJava());){
            ConfluentBrokerPlacementConstraintTest.$anonfun$testDeletingTopicConfigDoesNotRevertToDefault$1(this, resource_resource);
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testValidateConstraintDefault(String quorum) {
        try (AdminClient resource_resource = (AdminClient)Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(ConfluentBrokerPlacementConstraintTest$.MODULE$.createConfig((Seq<KafkaBroker>)this.brokers())).asJava());){
            ConfluentBrokerPlacementConstraintTest.$anonfun$testValidateConstraintDefault$1(this, resource_resource);
        }
    }

    @Override
    public int brokerCount() {
        return 2;
    }

    public static final /* synthetic */ void $anonfun$testCreateTopicWithBrokerValues$1(ConfluentBrokerPlacementConstraintTest $this, AdminClient client) {
        String topic = "observer-topic";
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        client.createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        TestUtils$.MODULE$.waitForPartitionMetadata($this.brokers(), topic, 0, 15000L);
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
        ConfigEntry constraint = ((Config)((KafkaFuture)client.describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)resource, (List)Nil$.MODULE$)).asJava()).values().get(resource)).get()).get("confluent.placement.constraints");
        Assertions.assertEquals((Object)$this.brokerConstraintValue(), (Object)constraint.value());
    }

    public static final /* synthetic */ void $anonfun$testCreateTopicOverrideDefault$1(ConfluentBrokerPlacementConstraintTest $this, AdminClient client) {
        String topic = "observer-topic";
        String overrideConstraintValue = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{\"rack\":\"b\"}}],\"observers\":[{\"count\":1,\"constraints\":{\"rack\":\"a\"}}]}";
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.placement.constraints"), (Object)overrideConstraintValue)}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        TestUtils$.MODULE$.waitForPartitionMetadata($this.brokers(), topic, 0, 15000L);
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
        ConfigEntry constraint = ((Config)((KafkaFuture)client.describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)resource, (List)Nil$.MODULE$)).asJava()).values().get(resource)).get()).get("confluent.placement.constraints");
        Assertions.assertNotEquals((Object)$this.brokerConstraintValue(), (Object)constraint.value());
        Assertions.assertEquals((Object)overrideConstraintValue, (Object)constraint.value());
    }

    public static final /* synthetic */ void $anonfun$testDeletingTopicConfigDoesNotRevertToDefault$1(ConfluentBrokerPlacementConstraintTest $this, AdminClient client) {
        String topic = "observer-topic";
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        client.createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        TestUtils$.MODULE$.waitForPartitionMetadata($this.brokers(), topic, 0, 15000L);
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
        AlterConfigOp operation = new AlterConfigOp(new ConfigEntry("confluent.placement.constraints", ""), AlterConfigOp.OpType.DELETE);
        client.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)operation, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all().get();
        if ($this.isKRaftTest()) {
            TestUtils$.MODULE$.ensureConsistentKRaftMetadata((Seq<KafkaBroker>)$this.brokers(), $this.controllerServer(), "Timeout waiting for controller metadata propagating to brokers");
        }
        ConfigEntry constraint = ((Config)((KafkaFuture)client.describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)resource, (List)Nil$.MODULE$)).asJava()).values().get(resource)).get()).get("confluent.placement.constraints");
        Assertions.assertEquals((Object)"", (Object)constraint.value());
    }

    public static final /* synthetic */ void $anonfun$testValidateConstraintDefault$1(ConfluentBrokerPlacementConstraintTest $this, AdminClient client) {
        String topic = "observer-topic";
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        CreateTopicsOptions option = new CreateTopicsOptions().validateOnly(true);
        ConfigEntry constraint = ((Config)client.createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava(), option).config(topic).get()).get("confluent.placement.constraints");
        Assertions.assertEquals((Object)$this.brokerConstraintValue(), (Object)constraint.value());
    }

    public ConfluentBrokerPlacementConstraintTest() {
        this.broker1 = 0;
        this.broker2 = 1;
        this.brokerConstraintValue = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{\"rack\":\"a\"}}],\"observers\":[{\"count\":1,\"constraints\":{\"rack\":\"b\"}}]}";
    }

    public static final /* synthetic */ Object $anonfun$testCreateTopicWithBrokerValues$1$adapted(ConfluentBrokerPlacementConstraintTest $this, AdminClient client) {
        ConfluentBrokerPlacementConstraintTest.$anonfun$testCreateTopicWithBrokerValues$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateTopicOverrideDefault$1$adapted(ConfluentBrokerPlacementConstraintTest $this, AdminClient client) {
        ConfluentBrokerPlacementConstraintTest.$anonfun$testCreateTopicOverrideDefault$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testDeletingTopicConfigDoesNotRevertToDefault$1$adapted(ConfluentBrokerPlacementConstraintTest $this, AdminClient client) {
        ConfluentBrokerPlacementConstraintTest.$anonfun$testDeletingTopicConfigDoesNotRevertToDefault$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateConstraintDefault$1$adapted(ConfluentBrokerPlacementConstraintTest $this, AdminClient client) {
        ConfluentBrokerPlacementConstraintTest.$anonfun$testValidateConstraintDefault$1($this, client);
        return BoxedUnit.UNIT;
    }
}

