/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.telemetry.api.events.NoOpEventEmitter;
import io.opentelemetry.context.Context;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import kafka.network.DataPlaneAcceptor$;
import kafka.network.RequestChannel;
import kafka.server.ActiveTenantsManager;
import kafka.server.AllRequests$;
import kafka.server.BrokerBackpressureConfig;
import kafka.server.BrokerBackpressureConfig$;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ConfigEntityName$;
import kafka.server.Defaults$;
import kafka.server.DiskUsageBasedThrottlingConfig;
import kafka.server.NonExemptRequest$;
import kafka.server.QueueSizePercentiles;
import kafka.server.RequestQueueSizePercentiles$;
import kafka.server.RequestType;
import kafka.server.ThreadUsageMetrics$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Percentiles;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestLogFilter;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.server.audit.NoOpAuditLogProvider;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\rma\u0001\u0002.\\\u0001\u0001DQa\u001a\u0001\u0005\u0002!Dqa\u001b\u0001C\u0002\u0013%A\u000e\u0003\u0004q\u0001\u0001\u0006I!\u001c\u0005\bc\u0002\u0011\r\u0011\"\u0003m\u0011\u0019\u0011\b\u0001)A\u0005[\"91\u000f\u0001b\u0001\n\u0013a\u0007B\u0002;\u0001A\u0003%Q\u000eC\u0004v\u0001\t\u0007I\u0011\u00027\t\rY\u0004\u0001\u0015!\u0003n\u0011\u001d9\bA1A\u0005\n1Da\u0001\u001f\u0001!\u0002\u0013i\u0007bB=\u0001\u0005\u0004%I\u0001\u001c\u0005\u0007u\u0002\u0001\u000b\u0011B7\t\u000fm\u0004!\u0019!C\u0005y\"9\u00111\u0002\u0001!\u0002\u0013i\b\u0002CA\u0007\u0001\t\u0007I\u0011\u0002?\t\u000f\u0005=\u0001\u0001)A\u0005{\"I\u0011\u0011\u0003\u0001C\u0002\u0013%\u00111\u0003\u0005\t\u0003_\u0001\u0001\u0015!\u0003\u0002\u0016!I\u0011\u0011\u0007\u0001C\u0002\u0013%\u00111\u0003\u0005\t\u0003g\u0001\u0001\u0015!\u0003\u0002\u0016!I\u0011Q\u0007\u0001C\u0002\u0013%\u0011q\u0007\u0005\t\u0003\u0003\u0002\u0001\u0015!\u0003\u0002:!I\u00111\t\u0001C\u0002\u0013%\u0011Q\t\u0005\t\u0003/\u0002\u0001\u0015!\u0003\u0002H!I\u0011\u0011\f\u0001C\u0002\u0013%\u00111\f\u0005\t\u0003G\u0002\u0001\u0015!\u0003\u0002^!I\u0011Q\r\u0001C\u0002\u0013%\u00111\f\u0005\t\u0003O\u0002\u0001\u0015!\u0003\u0002^!I\u0011\u0011\u000e\u0001C\u0002\u0013%\u00111\f\u0005\t\u0003W\u0002\u0001\u0015!\u0003\u0002^!I\u0011Q\u000e\u0001C\u0002\u0013%\u00111\f\u0005\t\u0003_\u0002\u0001\u0015!\u0003\u0002^!I\u0011\u0011\u000f\u0001C\u0002\u0013%\u00111\f\u0005\t\u0003g\u0002\u0001\u0015!\u0003\u0002^!Y\u0011Q\u000f\u0001A\u0002\u0003\u0007I\u0011BA<\u0011-\t)\t\u0001a\u0001\u0002\u0004%I!a\"\t\u0017\u0005M\u0005\u00011A\u0001B\u0003&\u0011\u0011\u0010\u0005\f\u0003+\u0003\u0001\u0019!a\u0001\n\u0013\t9\nC\u0006\u0002$\u0002\u0001\r\u00111A\u0005\n\u0005\u0015\u0006bCAU\u0001\u0001\u0007\t\u0011)Q\u0005\u00033C1\"a+\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002.\"Y\u0011Q\u0017\u0001A\u0002\u0003\u0007I\u0011BA\\\u0011-\tY\f\u0001a\u0001\u0002\u0003\u0006K!a,\t\u0017\u0005u\u0006\u00011AA\u0002\u0013%\u0011Q\u0016\u0005\f\u0003\u007f\u0003\u0001\u0019!a\u0001\n\u0013\t\t\rC\u0006\u0002F\u0002\u0001\r\u0011!Q!\n\u0005=\u0006bCAd\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0013D1\"!5\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002T\"Y\u0011q\u001b\u0001A\u0002\u0003\u0005\u000b\u0015BAf\u0011-\tI\u000e\u0001a\u0001\u0002\u0004%I!a7\t\u0017\u0005\r\b\u00011AA\u0002\u0013%\u0011Q\u001d\u0005\f\u0003S\u0004\u0001\u0019!A!B\u0013\ti\u000eC\u0004\u0002l\u0002!\t!!<\t\u000f\t\u0015\u0001\u0001\"\u0001\u0002n\"9!q\u0002\u0001\u0005\n\u00055\bb\u0002B\t\u0001\u0011%\u0011Q\u001e\u0005\b\u0005'\u0001A\u0011BAw\u0011\u001d\u0011)\u0002\u0001C\u0005\u0003[DqAa\u0006\u0001\t\u0003\ti\u000fC\u0004\u0003\"\u0001!\t!!<\t\u000f\t\u0015\u0002\u0001\"\u0001\u0002n\"9!\u0011\u0006\u0001\u0005\u0002\u00055\bb\u0002B\u0017\u0001\u0011\u0005\u0011Q\u001e\u0005\b\u0005c\u0001A\u0011AAw\u0011\u001d\u0011)\u0004\u0001C\u0001\u0003[DqA!\u000f\u0001\t\u0003\ti\u000fC\u0004\u0003>\u0001!\t!!<\t\u000f\t\u0005\u0003\u0001\"\u0001\u0002n\"9!Q\t\u0001\u0005\u0002\u00055\bb\u0002B%\u0001\u0011\u0005\u0011Q\u001e\u0005\b\u0005\u001b\u0002A\u0011AAw\u0011\u001d\u0011\t\u0006\u0001C\u0001\u0003[DqA!\u0016\u0001\t\u0003\ti\u000fC\u0004\u0003Z\u0001!\t!!<\t\u000f\tu\u0003\u0001\"\u0001\u0002n\"9!\u0011\r\u0001\u0005\u0002\u00055\bb\u0002B3\u0001\u0011\u0005\u0011Q\u001e\u0005\b\u0005S\u0002A\u0011AAw\u0011\u001d\u0011i\u0007\u0001C\u0005\u0005_BqA!%\u0001\t\u0013\u0011\u0019\nC\u0004\u0003B\u0002!IAa1\t\u000f\t-\u0007\u0001\"\u0003\u0003N\"9!1\u001a\u0001\u0005\n\tU\u0007b\u0002Bq\u0001\u0011%!1\u001d\u0005\b\u0005s\u0004A\u0011\u0002B~\u0011\u001d\u0011I\u0010\u0001C\u0005\u0005{Dqaa\u0001\u0001\t\u0013\u0019)\u0001C\u0004\u0004\u0014\u0001!\ta!\u0006\u0003M\r{gN\u001a7vK:$8\t\\5f]R\u0014V-];fgR\fVo\u001c;b\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002];\u000611/\u001a:wKJT\u0011AX\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\r\u0005\u0002cK6\t1MC\u0001e\u0003\u0015\u00198-\u00197b\u0013\t17M\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003%\u0004\"A\u001b\u0001\u000e\u0003m\u000b\u0001#[8UQJ,\u0017\r\u001a9p_2\u001c\u0016N_3\u0016\u00035\u0004\"A\u00198\n\u0005=\u001c'aA%oi\u0006\t\u0012n\u001c+ie\u0016\fG\r]8pYNK'0\u001a\u0011\u0002+9,Go^8sWRC'/Z1ea>|GnU5{K\u00061b.\u001a;x_J\\G\u000b\u001b:fC\u0012\u0004xn\u001c7TSj,\u0007%\u0001\u000bj_RC'/Z1ea>|GnQ1qC\u000eLG/_\u0001\u0016S>$\u0006N]3bIB|w\u000e\\\"ba\u0006\u001c\u0017\u000e^=!\u0003eqW\r^<pe.$\u0006N]3bIB|w\u000e\\\"ba\u0006\u001c\u0017\u000e^=\u000259,Go^8sWRC'/Z1ea>|GnQ1qC\u000eLG/\u001f\u0011\u0002\u00195\f\u00070U;fk\u0016\u001c\u0016N_3\u0002\u001b5\f\u00070U;fk\u0016\u001c\u0016N_3!\u00035!x\u000e^1m\u0007\u0006\u0004\u0018mY5us\u0006qAo\u001c;bY\u000e\u000b\u0007/Y2jif\u0004\u0013\u0001\u0003;fgR,6/\u001a:\u0016\u0003u\u00042A`A\u0004\u001b\u0005y(\u0002BA\u0001\u0003\u0007\tA\u0001\\1oO*\u0011\u0011QA\u0001\u0005U\u00064\u0018-C\u0002\u0002\n}\u0014aa\u0015;sS:<\u0017!\u0003;fgR,6/\u001a:!\u0003)!Xm\u001d;DY&,g\u000e^\u0001\fi\u0016\u001cHo\u00117jK:$\b%\u0001\u0007uKN$H*[:uK:,'/\u0006\u0002\u0002\u0016A!\u0011qCA\u0016\u001b\t\tIB\u0003\u0003\u0002\u001c\u0005u\u0011a\u00028fi^|'o\u001b\u0006\u0005\u0003?\t\t#\u0001\u0004d_6lwN\u001c\u0006\u0004=\u0006\r\"\u0002BA\u0013\u0003O\ta!\u00199bG\",'BAA\u0015\u0003\ry'oZ\u0005\u0005\u0003[\tIB\u0001\u0007MSN$XM\\3s\u001d\u0006lW-A\u0007uKN$H*[:uK:,'\u000fI\u0001\u000fg\u0016\u001cwN\u001c3MSN$XM\\3s\u0003=\u0019XmY8oI2K7\u000f^3oKJ\u0004\u0013A\u0005;fgR$v\u000e]5d!\u0006\u0014H/\u001b;j_:,\"!!\u000f\u0011\t\u0005m\u0012QH\u0007\u0003\u0003;IA!a\u0010\u0002\u001e\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0005;fgR$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013!\u0004;fgR\u0004&/\u001b8dSB\fG.\u0006\u0002\u0002HA!\u0011\u0011JA*\u001b\t\tYE\u0003\u0003\u0002N\u0005=\u0013\u0001B1vi\"TA!!\u0015\u0002\u001e\u0005A1/Z2ve&$\u00180\u0003\u0003\u0002V\u0005-#AD&bM.\f\u0007K]5oG&\u0004\u0018\r\\\u0001\u000fi\u0016\u001cH\u000f\u0015:j]\u000eL\u0007/\u00197!\u0003\u0019\u0019wN\u001c4jOV\u0011\u0011Q\f\t\u0004U\u0006}\u0013bAA17\nA2\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u0005ABo^8UK:\fg\u000e^#oIB|\u0017N\u001c;t\u0007>tg-[4\u00023Q<x\u000eV3oC:$XI\u001c3q_&tGo]\"p]\u001aLw\rI\u0001\u0015]>\u0014\u0015mY6qe\u0016\u001c8/\u001e:f\u0007>tg-[4\u0002+9|')Y2laJ,7o];sK\u000e{gNZ5hA\u00051bn\u001c+f]\u0006tG\u000fT5ti\u0016tWM]\"p]\u001aLw-A\fo_R+g.\u00198u\u0019&\u001cH/\u001a8fe\u000e{gNZ5hA\u0005qan\\)v_R\f7oQ8oM&<\u0017a\u00048p#V|G/Y:D_:4\u0017n\u001a\u0011\u0002\tQLW.Z\u000b\u0003\u0003s\u0002B!a\u001f\u0002\u00026\u0011\u0011Q\u0010\u0006\u0005\u0003\u007f\ni\"A\u0003vi&d7/\u0003\u0003\u0002\u0004\u0006u$\u0001C'pG.$\u0016.\\3\u0002\u0011QLW.Z0%KF$B!!#\u0002\u0010B\u0019!-a#\n\u0007\u000555M\u0001\u0003V]&$\b\"CAIK\u0005\u0005\t\u0019AA=\u0003\rAH%M\u0001\u0006i&lW\rI\u0001\b[\u0016$(/[2t+\t\tI\n\u0005\u0003\u0002\u001c\u0006}UBAAO\u0015\u0011\t)*!\b\n\t\u0005\u0005\u0016Q\u0014\u0002\b\u001b\u0016$(/[2t\u0003-iW\r\u001e:jGN|F%Z9\u0015\t\u0005%\u0015q\u0015\u0005\n\u0003#C\u0013\u0011!a\u0001\u00033\u000b\u0001\"\\3ue&\u001c7\u000fI\u0001\fS>\u001c\u0015\r]*f]N|'/\u0006\u0002\u00020B!\u00111TAY\u0013\u0011\t\u0019,!(\u0003\rM+gn]8s\u0003=IwnQ1q'\u0016t7o\u001c:`I\u0015\fH\u0003BAE\u0003sC\u0011\"!%,\u0003\u0003\u0005\r!a,\u0002\u0019%|7)\u00199TK:\u001cxN\u001d\u0011\u0002!9,Go^8sW\u000e\u000b\u0007oU3og>\u0014\u0018\u0001\u00068fi^|'o[\"baN+gn]8s?\u0012*\u0017\u000f\u0006\u0003\u0002\n\u0006\r\u0007\"CAI]\u0005\u0005\t\u0019AAX\u0003EqW\r^<pe.\u001c\u0015\r]*f]N|'\u000fI\u0001\u0015C\u000e$\u0018N^3UK:\fg\u000e^:NC:\fw-\u001a:\u0016\u0005\u0005-\u0007c\u00016\u0002N&\u0019\u0011qZ.\u0003)\u0005\u001bG/\u001b<f)\u0016t\u0017M\u001c;t\u001b\u0006t\u0017mZ3s\u0003a\t7\r^5wKR+g.\u00198ug6\u000bg.Y4fe~#S-\u001d\u000b\u0005\u0003\u0013\u000b)\u000eC\u0005\u0002\u0012F\n\t\u00111\u0001\u0002L\u0006)\u0012m\u0019;jm\u0016$VM\\1oiNl\u0015M\\1hKJ\u0004\u0013a\u0005:fcV,7\u000f^)v_R\fW*\u00198bO\u0016\u0014XCAAo!\rQ\u0017q\\\u0005\u0004\u0003C\\&!G\"mS\u0016tGOU3rk\u0016\u001cH/U;pi\u0006l\u0015M\\1hKJ\fqC]3rk\u0016\u001cH/U;pi\u0006l\u0015M\\1hKJ|F%Z9\u0015\t\u0005%\u0015q\u001d\u0005\n\u0003##\u0014\u0011!a\u0001\u0003;\fAC]3rk\u0016\u001cH/U;pi\u0006l\u0015M\\1hKJ\u0004\u0013\u0001\u00042fM>\u0014X-T3uQ>$GCAAEQ\r1\u0014\u0011\u001f\t\u0005\u0003g\u0014\t!\u0004\u0002\u0002v*!\u0011q_A}\u0003\r\t\u0007/\u001b\u0006\u0005\u0003w\fi0A\u0004kkBLG/\u001a:\u000b\t\u0005}\u0018qE\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0005\u0007\t)P\u0001\u0006CK\u001a|'/Z#bG\"\f1\"\u00194uKJlU\r\u001e5pI\"\u001aqG!\u0003\u0011\t\u0005M(1B\u0005\u0005\u0005\u001b\t)PA\u0005BMR,'/R1dQ\u0006A#/Z2sK\u0006$XMU3rk\u0016\u001cH/U;pi\u0006l\u0015M\\1hKJ<\u0016\u000e\u001e5pkR\fVo\u001c;bg\u0006q#/Z2sK\u0006$XMU3rk\u0016\u001cH/U;pi\u0006l\u0015M\\1hKJ<\u0016\u000e\u001e5pkR\u0014\u0015mY6qe\u0016\u001c8/\u001e:f\u0003A\u0012Xm\u0019:fCR,'+Z9vKN$\u0018+^8uC6\u000bg.Y4fe^KG\u000f[8viR+g.\u00198u\u0019&\u001cH/\u001a8fe\u0006\u0001$/Z2sK\u0006$XMU3rk\u0016\u001cH/U;pi\u0006l\u0015M\\1hKJ<\u0016\u000e\u001e5Uo>$VM\\1oi\u0016s\u0007o\\5oiN\f1\b^3ti\n\u000b7m\u001b9sKN\u001cXO]3Jg\u0012K7/\u00192mK\u0012Le\u000eR3gCVdGo\u00117jK:$\u0018+^8uC6\u000bg.Y4fe\u000e{gNZ5hQ\ra$1\u0004\t\u0005\u0003g\u0014i\"\u0003\u0003\u0003 \u0005U(\u0001\u0002+fgR\f\u0011\u0006^3ti\u0006+Ho\u001c+v]\u0016\u0014V-];fgR\fVo\u001c;b\u00032d\u0017IY8wK\u001a\u000b\u0017N\u001d'j[&$\bfA\u001f\u0003\u001c\u0005qC/Z:u\u0003V$x\u000eV;oKJ+\u0017/^3tiF+x\u000e^1BE>4X-\u00118e\u0005\u0016dwn\u001e$bSJd\u0015.\\5uQ\rq$1D\u0001*i\u0016\u001cH/Q;u_R+h.\u001a*fcV,7\u000f^)v_R\f\u0017\t\u001c7CK2|wOR1je2KW.\u001b;)\u0007}\u0012Y\"\u0001\u0015uKN$(I]8lKJ\fVo\u001c;b\u0019&l\u0017\u000e^%t\u0013:LG/[1mYf,f\u000e\\5nSR,G\rK\u0002A\u00057\tq\u0007^3ti\n\u0013xn[3s#V|G/\u0019'j[&$\u0018j]+qI\u0006$X\rZ,iK:\u0014\u0015mY6qe\u0016\u001c8/\u001e:f\u0013N$\u0015n]1cY\u0016$\u0007fA!\u0003\u001c\u0005iD/Z:u\u0005J|7.\u001a:Rk>$\u0018\rT5nSRL5OT8u+B$\u0017\r^3e\u0013\u001a$VM\\1oi2K7\u000f^3oKJtu\u000e^\"p]\u001aLw-\u001e:fI\"\u001a!Ia\u0007\u0002\tR,7\u000f\u001e(p]\u0016CX-\u001c9u%\u0016\fX/Z:u#V|G/Y:ESN\f'\r\\3e%\u0016\u001cwN\u001d3t)>$\u0018\r\u001c+ie\u0016\fG-V:bO\u0016lU\r\u001e:jGN|e\u000e\\=)\u0007\r\u0013Y\"\u0001#uKN$X\t_3naR\u0014V-];fgR<\u0016\u000e\u001e5Rk>$\u0018m]#oC\ndW\r\u001a*fG>\u0014Hm\u001d+pi\u0006dG\u000b\u001b:fC\u0012,6/Y4f\u001b\u0016$(/[2t\u001f:d\u0017\u0010K\u0002E\u00057\t\u0011\t^3ti:{g.\u0012=f[B$(+Z9vKN$x+\u001b;i#V|G/Y:F]\u0006\u0014G.\u001a3SK\u000e|'\u000fZ:BY2$\u0006N]3bIV\u001b\u0018mZ3NKR\u0014\u0018nY:)\u0007\u0015\u0013Y\"\u0001\u001duKN$(I]8lKJ\fVo\u001c;b\u0019&l\u0017\u000e^#ogV\u0014Xm]%p)\"\u0014X-\u00193q_>d\u0017j\u001d(pi>3XM]+uS2L'0\u001a3)\u0007\u0019\u0013Y\"A\u001fuKN$(I]8lKJ\fVo\u001c;b\u0019&l\u0017\u000e^#ogV\u0014Xm\u001d(fi^|'o\u001b+ie\u0016\fG\r]8pY&\u001bhj\u001c;Pm\u0016\u0014X\u000b^5mSj,G\rK\u0002H\u00057\t1\u0006^3ti\n\u0013xn[3s#V|G/\u0019'j[&$Hi\\3t\u001d>$h)\u00197m\u0005\u0016dwn^'j]VlW/\u001c\u0015\u0004\u0011\nm\u0011\u0001\u0013;fgRtU\r^<pe.$\u0006N]3bIV\u001b\u0018mZ3Ge>lgj\u001c8UK:\fg\u000e^#oIB|\u0017N\u001c;E_\u0016\u001chj\u001c;BM\u001a,7\r\u001e\"s_.,'/U;pi\u0006d\u0015.\\5uQ\rI%1D\u0001Hi\u0016\u001cH/\u00169eCR,\u0017\t\u001a6vgR,GmQ1qC\u000eLG/\u001f#pKNtu\u000e^!eUV\u001cH\u000fT5nSR<\u0006.\u001a8Rk\u0016,XmU5{K\n+Gn\\<UQJ,7\u000f[8mI\"\u001a!Ja\u0007\u0002/R,7\u000f^+qI\u0006$X-\u00113kkN$X\rZ\"ba\u0006\u001c\u0017\u000e^=EK\u000e\u0014X-Y:fg2KW.\u001b;EkJLgn\u001a*fcV,7\u000f^(wKJdw.\u00193B]\u0012\u0014\u0015mY6t\u001f\u001a4G)\u001e:j]\u001e,f\u000eZ3sY>\fG\rK\u0002L\u00057\t\u0011\u0007^3ti\n\u0013xn[3s%\u0016\fX/Z:u\u0019&l\u0017\u000e^%t\u0003\u0012TWo\u001d;fI>s'+Z9vKN$xJ^3sY>\fG\rK\u0002M\u00057\tQ\u0006^3ti\n\u0013xn[3s%\u0016\fX/Z:u\u0019&l\u0017\u000e\u001e#pKNtu\u000e\u001e$bY2\u0014U\r\\8x\u001b&t\u0017.\\;nQ\ri%1D\u0001\u001ci\u0016\u001cH/T;mi&\u0004H.\u001a+f]\u0006tG/\u00128ea>Lg\u000e^:)\u00079\u0013Y\"A\ruKN$(+Z7pm\u0016d\u0015n\u001d;f]\u0016\u0014X*\u001a;sS\u000e\u001c\bfA(\u0003\u001c\u0005\u00113/[7vY\u0006$X\rV5nK>s'+Z9vKN$\b*\u00198eY\u0016\u0014H\u000b\u001b:fC\u0012$b!!#\u0003r\t\u001d\u0005b\u0002B:!\u0002\u0007!QO\u0001\be\u0016\fX/Z:u!\u0011\u00119H!!\u000f\t\te$QP\u0007\u0003\u0005wR1!a\u0007^\u0013\u0011\u0011yHa\u001f\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&!!1\u0011BC\u0005\u001d\u0011V-];fgRTAAa \u0003|!9!\u0011\u0012)A\u0002\t-\u0015AA7t!\r\u0011'QR\u0005\u0004\u0005\u001f\u001b'\u0001\u0002'p]\u001e\fQ$Y:tKJ$()Y2laJ,7o];sK6+GO]5d-\u0006dW/\u001a\u000b\t\u0003\u0013\u0013)J!,\u0003>\"9!qS)A\u0002\te\u0015AC7fiJL7MT1nKB!!1\u0014BU\u001d\u0011\u0011iJ!*\u0011\u0007\t}5-\u0004\u0002\u0003\"*\u0019!1U0\u0002\rq\u0012xn\u001c;?\u0013\r\u00119kY\u0001\u0007!J,G-\u001a4\n\t\u0005%!1\u0016\u0006\u0004\u0005O\u001b\u0007b\u0002BX#\u0002\u0007!\u0011W\u0001\u0011Kb\u0004Xm\u0019;fIZ\u000bG.^3PaR\u0004RA\u0019BZ\u0005oK1A!.d\u0005\u0019y\u0005\u000f^5p]B\u0019!M!/\n\u0007\tm6M\u0001\u0004E_V\u0014G.\u001a\u0005\b\u0005\u007f\u000b\u0006\u0019\u0001B\\\u0003\u0015!W\r\u001c;b\u0003y\t7o]3si&{G\u000b\u001b:fC\u0012,6/Y4f\u001b\u0016$(/[2WC2,X\r\u0006\u0005\u0002\n\n\u0015'q\u0019Be\u0011\u001d\u00119J\u0015a\u0001\u00053CqAa,S\u0001\u0004\u0011\t\fC\u0004\u0003@J\u0003\rAa.\u0002G\u0005\u001c8/\u001a:u\u001d\u0016$xo\u001c:l)\"\u0014X-\u00193Vg\u0006<W-T3ue&\u001cg+\u00197vKRA\u0011\u0011\u0012Bh\u0005#\u0014\u0019\u000eC\u0004\u0003\u0018N\u0003\rA!'\t\u000f\t=6\u000b1\u0001\u00032\"9!qX*A\u0002\t]FCCAE\u0005/\u0014IN!8\u0003`\"9!q\u0013+A\u0002\te\u0005b\u0002Bn)\u0002\u0007!\u0011T\u0001\tY&\u001cH/\u001a8fe\"9!q\u0016+A\u0002\tE\u0006b\u0002B`)\u0002\u0007!qW\u0001\u0012CN\u001cXM\u001d;NKR\u0014\u0018n\u0019,bYV,G\u0003DAE\u0005K\u00149Oa;\u0003v\n]\bb\u0002BL+\u0002\u0007!\u0011\u0014\u0005\b\u0005S,\u0006\u0019\u0001BM\u0003\u00159'o\\;q\u0011\u001d\u0011i/\u0016a\u0001\u0005_\f!\"\\3ue&\u001cG+Y4t!!\u0011YJ!=\u0003\u001a\ne\u0015\u0002\u0002Bz\u0005W\u00131!T1q\u0011\u001d\u0011y+\u0016a\u0001\u0005cCqAa0V\u0001\u0004\u00119,\u0001\u0007ck&dGMU3rk\u0016\u001cH\u000f\u0006\u0002\u0003vQ!!Q\u000fB\u0000\u0011\u001d\u0019\ta\u0016a\u0001\u0003+\tA\u0002\\5ti\u0016tWM\u001d(b[\u0016\f1\"\\1zE\u0016\u0014VmY8sIR9Qna\u0002\u0004\f\r=\u0001bBB\u00051\u0002\u0007!\u0011T\u0001\u0005kN,'\u000fC\u0004\u0004\u000ea\u0003\rA!'\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012Dqa!\u0005Y\u0001\u0004\u00119,A\u0003wC2,X-A\bnS2d\u0017n\u001d+p!\u0016\u00148-\u001a8u)\u0011\u00119la\u0006\t\u000f\re\u0011\f1\u0001\u00038\u00061Q.\u001b7mSN\u0004")
public class ConfluentClientRequestQuotaManagerTest {
    private final int ioThreadpoolSize;
    private final int networkThreadpoolSize;
    private final int ioThreadpoolCapacity = this.ioThreadpoolSize() * 100;
    private final int networkThreadpoolCapacity = this.networkThreadpoolSize() * 100;
    private final int maxQueueSize;
    private final int totalCapacity = this.ioThreadpoolCapacity() + this.networkThreadpoolCapacity();
    private final String testUser;
    private final String testClient;
    private final ListenerName testListener = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    private final ListenerName secondListener = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SASL_PLAINTEXT);
    private final TopicPartition testTopicPartition = new TopicPartition("test-topic", 0);
    private final KafkaPrincipal testPrincipal = new KafkaPrincipal("User", this.testUser());
    private final ClientQuotaManagerConfig config;
    private final ClientQuotaManagerConfig twoTenantEndpointsConfig;
    private final ClientQuotaManagerConfig noBackpressureConfig;
    private final ClientQuotaManagerConfig noTenantListenerConfig;
    private final ClientQuotaManagerConfig noQuotasConfig;
    private MockTime time;
    private Metrics metrics;
    private Sensor ioCapSensor;
    private Sensor networkCapSensor;
    private ActiveTenantsManager activeTenantsManager;
    private ClientRequestQuotaManager requestQuotaManager;

    private int ioThreadpoolSize() {
        return this.ioThreadpoolSize;
    }

    private int networkThreadpoolSize() {
        return this.networkThreadpoolSize;
    }

    private int ioThreadpoolCapacity() {
        return this.ioThreadpoolCapacity;
    }

    private int networkThreadpoolCapacity() {
        return this.networkThreadpoolCapacity;
    }

    private int maxQueueSize() {
        return this.maxQueueSize;
    }

    private int totalCapacity() {
        return this.totalCapacity;
    }

    private String testUser() {
        return this.testUser;
    }

    private String testClient() {
        return this.testClient;
    }

    private ListenerName testListener() {
        return this.testListener;
    }

    private ListenerName secondListener() {
        return this.secondListener;
    }

    private TopicPartition testTopicPartition() {
        return this.testTopicPartition;
    }

    private KafkaPrincipal testPrincipal() {
        return this.testPrincipal;
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private ClientQuotaManagerConfig twoTenantEndpointsConfig() {
        return this.twoTenantEndpointsConfig;
    }

    private ClientQuotaManagerConfig noBackpressureConfig() {
        return this.noBackpressureConfig;
    }

    private ClientQuotaManagerConfig noTenantListenerConfig() {
        return this.noTenantListenerConfig;
    }

    private ClientQuotaManagerConfig noQuotasConfig() {
        return this.noQuotasConfig;
    }

    private MockTime time() {
        return this.time;
    }

    private void time_$eq(MockTime x$1) {
        this.time = x$1;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    private Sensor ioCapSensor() {
        return this.ioCapSensor;
    }

    private void ioCapSensor_$eq(Sensor x$1) {
        this.ioCapSensor = x$1;
    }

    private Sensor networkCapSensor() {
        return this.networkCapSensor;
    }

    private void networkCapSensor_$eq(Sensor x$1) {
        this.networkCapSensor = x$1;
    }

    private ActiveTenantsManager activeTenantsManager() {
        return this.activeTenantsManager;
    }

    private void activeTenantsManager_$eq(ActiveTenantsManager x$1) {
        this.activeTenantsManager = x$1;
    }

    private ClientRequestQuotaManager requestQuotaManager() {
        return this.requestQuotaManager;
    }

    private void requestQuotaManager_$eq(ClientRequestQuotaManager x$1) {
        this.requestQuotaManager = x$1;
    }

    /*
     * WARNING - void declaration
     */
    @BeforeEach
    public void beforeMethod() {
        void add_stat;
        void add_metricName;
        void add_stat2;
        void add_metricName2;
        this.time_$eq(new MockTime());
        this.metrics_$eq(new Metrics(new MetricConfig().timeWindow(1L, TimeUnit.SECONDS), Collections.emptyList(), (Time)this.time()));
        this.activeTenantsManager_$eq(new ActiveTenantsManager(this.metrics(), (Time)this.time(), 10000L));
        this.requestQuotaManager_$eq(new ClientRequestQuotaManager(this.config(), this.metrics(), (Time)this.time(), "", (Option)None$.MODULE$, (Option)new Some((Object)this.activeTenantsManager())));
        this.requestQuotaManager().updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
        this.config().backpressureConfig().tenantEndpointListenerNames().foreach(arg_0 -> ConfluentClientRequestQuotaManagerTest.$anonfun$beforeMethod$1$adapted(this.requestQuotaManager(), arg_0));
        this.ioCapSensor_$eq(this.metrics().sensor("TotalIoThreadsPercentage"));
        Sensor sensor = this.ioCapSensor();
        Value value = new Value();
        MetricName metricName = ThreadUsageMetrics$.MODULE$.ioThreadPoolCapacityMetricName(this.metrics());
        if (sensor == null) {
            throw null;
        }
        sensor.add((MetricName)add_metricName2, (MeasurableStat)add_stat2, null);
        metricName = null;
        value = null;
        this.ioCapSensor().record((double)this.ioThreadpoolCapacity());
        this.networkCapSensor_$eq(this.metrics().sensor("TotalNetworkThreadsPercentage"));
        Sensor sensor2 = this.networkCapSensor();
        Value value2 = new Value();
        MetricName metricName2 = ThreadUsageMetrics$.MODULE$.networkThreadPoolCapacityMetricName(this.metrics(), this.testListener().value());
        if (sensor2 == null) {
            throw null;
        }
        sensor2.add((MetricName)add_metricName, (MeasurableStat)add_stat, null);
        metricName2 = null;
        value2 = null;
        this.networkCapSensor().record((double)this.networkThreadpoolCapacity());
    }

    @AfterEach
    public void afterMethod() {
        this.requestQuotaManager().shutdown();
        this.metrics().close();
    }

    private void recreateRequestQuotaManagerWithoutQuotas() {
        this.requestQuotaManager().shutdown();
        this.requestQuotaManager_$eq(new ClientRequestQuotaManager(this.noQuotasConfig(), this.metrics(), (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$));
        this.config().backpressureConfig().tenantEndpointListenerNames().foreach(arg_0 -> ConfluentClientRequestQuotaManagerTest.$anonfun$recreateRequestQuotaManagerWithoutQuotas$1$adapted(this.requestQuotaManager(), arg_0));
    }

    private void recreateRequestQuotaManagerWithoutBackpressure() {
        this.requestQuotaManager().shutdown();
        this.requestQuotaManager_$eq(new ClientRequestQuotaManager(this.noBackpressureConfig(), this.metrics(), (Time)this.time(), "", (Option)None$.MODULE$, (Option)new Some((Object)this.activeTenantsManager())));
        this.config().backpressureConfig().tenantEndpointListenerNames().foreach(arg_0 -> ConfluentClientRequestQuotaManagerTest.$anonfun$recreateRequestQuotaManagerWithoutBackpressure$1$adapted(this.requestQuotaManager(), arg_0));
        this.requestQuotaManager().updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
    }

    private void recreateRequestQuotaManagerWithoutTenantListener() {
        this.requestQuotaManager().shutdown();
        this.requestQuotaManager_$eq(new ClientRequestQuotaManager(this.noTenantListenerConfig(), this.metrics(), (Time)this.time(), "", (Option)None$.MODULE$, (Option)new Some((Object)this.activeTenantsManager())));
        this.requestQuotaManager().updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
        this.config().backpressureConfig().tenantEndpointListenerNames().foreach(arg_0 -> ConfluentClientRequestQuotaManagerTest.$anonfun$recreateRequestQuotaManagerWithoutTenantListener$1$adapted(this.requestQuotaManager(), arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private void recreateRequestQuotaManagerWithTwoTenantEnpoints() {
        void add_stat;
        void add_metricName;
        this.requestQuotaManager().shutdown();
        this.requestQuotaManager_$eq(new ClientRequestQuotaManager(this.twoTenantEndpointsConfig(), this.metrics(), (Time)this.time(), "", (Option)None$.MODULE$, (Option)new Some((Object)this.activeTenantsManager())));
        this.requestQuotaManager().updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
        this.twoTenantEndpointsConfig().backpressureConfig().tenantEndpointListenerNames().foreach(arg_0 -> ConfluentClientRequestQuotaManagerTest.$anonfun$recreateRequestQuotaManagerWithTwoTenantEnpoints$1$adapted(this.requestQuotaManager(), arg_0));
        Sensor sensor = this.networkCapSensor();
        Value value = new Value();
        MetricName metricName = ThreadUsageMetrics$.MODULE$.networkThreadPoolCapacityMetricName(this.metrics(), this.secondListener().value());
        if (sensor == null) {
            throw null;
        }
        sensor.add((MetricName)add_metricName, (MeasurableStat)add_stat, null);
        metricName = null;
        value = null;
        this.networkCapSensor().record((double)this.networkThreadpoolCapacity());
    }

    @Test
    public void testBackpressureIsDisabledInDefaultClientQuotaManagerConfig() {
        Assertions.assertFalse((boolean)new ClientQuotaManagerConfig(Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L, 0, Long.MAX_VALUE).backpressureConfig().backpressureEnabledInConfig());
    }

    @Test
    public void testAutoTuneRequestQuotaAllAboveFairLimit() {
        this.requestQuotaManager().nonExemptCapacitySensor().record(1200.0);
        double upperBound_upperBound = 800.0;
        this.requestQuotaManager().updateQuota((Option)new Some((Object)"UserA"), (Option)new Some((Object)"Client1"), (Option)new Some((Object)"Client1"), (Option)new Some((Object)new Quota(upperBound_upperBound, true)));
        double upperBound_upperBound2 = 800.0;
        this.requestQuotaManager().updateQuota((Option)new Some((Object)"UserB"), (Option)new Some((Object)"Client2"), (Option)new Some((Object)"Client2"), (Option)new Some((Object)new Quota(upperBound_upperBound2, true)));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$7 -> {
            int throttleTime1 = this.maybeRecord("UserA", "Client1", this.millisToPercent(7000.0));
            int throttleTime2 = this.maybeRecord("UserB", "Client2", this.millisToPercent(7000.0));
            this.time().sleep((long)Math.max(1000, Math.max(throttleTime1, throttleTime2)));
        });
        this.requestQuotaManager().maybeAutoTuneQuota();
        Assertions.assertEquals((double)600.0, (double)this.requestQuotaManager().dynamicQuota("UserA", "Client1").bound(), (double)0.0);
        Assertions.assertEquals((double)600.0, (double)this.requestQuotaManager().dynamicQuota("UserB", "Client2").bound(), (double)0.0);
        BrokerBackpressureConfig newBackpressureConfig = new BrokerBackpressureConfig(false, BrokerBackpressureConfig$.MODULE$.DefaultBackpressureCheckFrequencyMs(), (Seq)Nil$.MODULE$, Double.MAX_VALUE, (double)Predef$.MODULE$.Long2long(ConfluentConfigs.BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_DEFAULT), "p95");
        this.requestQuotaManager().updateBackpressureConfig(newBackpressureConfig);
        Assertions.assertEquals((double)this.requestQuotaManager().quota("UserA", "Client1").bound(), (double)this.requestQuotaManager().dynamicQuota("UserA", "Client1").bound(), (double)1.0E-8);
        Assertions.assertEquals((double)this.requestQuotaManager().quota("UserB", "Client2").bound(), (double)this.requestQuotaManager().dynamicQuota("UserB", "Client2").bound(), (double)1.0E-8);
    }

    @Test
    public void testAutoTuneRequestQuotaAboveAndBelowFairLimit() {
        this.requestQuotaManager().nonExemptCapacitySensor().record(1200.0);
        double upperBound_upperBound = 800.0;
        this.requestQuotaManager().updateQuota((Option)new Some((Object)"UserA"), (Option)new Some((Object)"Client1"), (Option)new Some((Object)"Client1"), (Option)new Some((Object)new Quota(upperBound_upperBound, true)));
        double upperBound_upperBound2 = 800.0;
        this.requestQuotaManager().updateQuota((Option)new Some((Object)"UserB"), (Option)new Some((Object)"Client2"), (Option)new Some((Object)"Client2"), (Option)new Some((Object)new Quota(upperBound_upperBound2, true)));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$8 -> {
            int throttleTime1 = this.maybeRecord("UserA", "Client1", this.millisToPercent(7500.0));
            int throttleTime2 = this.maybeRecord("UserB", "Client2", this.millisToPercent(5000.0));
            this.time().sleep((long)Math.max(1000, Math.max(throttleTime1, throttleTime2)));
        });
        this.requestQuotaManager().maybeAutoTuneQuota();
        Assertions.assertEquals((double)700.0, (double)this.requestQuotaManager().dynamicQuota("UserA", "Client1").bound(), (double)1.0E-8);
        Assertions.assertEquals((double)600.0, (double)this.requestQuotaManager().dynamicQuota("UserB", "Client2").bound(), (double)1.0E-8);
    }

    @Test
    public void testAutoTuneRequestQuotaAllBelowFairLimit() {
        this.requestQuotaManager().nonExemptCapacitySensor().record(1200.0);
        double upperBound_upperBound = 800.0;
        this.requestQuotaManager().updateQuota((Option)new Some((Object)"UserA"), (Option)new Some((Object)"Client1"), (Option)new Some((Object)"Client1"), (Option)new Some((Object)new Quota(upperBound_upperBound, true)));
        double upperBound_upperBound2 = 800.0;
        this.requestQuotaManager().updateQuota((Option)new Some((Object)"UserB"), (Option)new Some((Object)"Client2"), (Option)new Some((Object)"Client2"), (Option)new Some((Object)new Quota(upperBound_upperBound2, true)));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$9 -> {
            int throttleTime1 = this.maybeRecord("UserA", "Client1", this.millisToPercent(1000.0));
            int throttleTime2 = this.maybeRecord("UserB", "Client2", this.millisToPercent(1000.0));
            this.time().sleep((long)Math.max(1000, Math.max(throttleTime1, throttleTime2)));
        });
        this.requestQuotaManager().maybeAutoTuneQuota();
        Assertions.assertEquals((double)this.requestQuotaManager().quota("UserA", "Client1").bound(), (double)this.requestQuotaManager().dynamicQuota("UserA", "Client1").bound(), (double)1.0E-8);
        Assertions.assertEquals((double)this.requestQuotaManager().quota("UserB", "Client2").bound(), (double)this.requestQuotaManager().dynamicQuota("UserB", "Client2").bound(), (double)1.0E-8);
    }

    @Test
    public void testBrokerQuotaLimitIsInitiallyUnlimited() {
        Assertions.assertEquals((double)Double.MAX_VALUE, (double)this.requestQuotaManager().getBrokerQuotaLimit(), (double)1.0);
    }

    @Test
    public void testBrokerQuotaLimitIsUpdatedWhenBackpressureIsDisabled() {
        this.recreateRequestQuotaManagerWithoutBackpressure();
        Assertions.assertFalse((boolean)this.requestQuotaManager().backpressureEnabled());
        Assertions.assertEquals((double)Double.MAX_VALUE, (double)this.requestQuotaManager().getBrokerQuotaLimit(), (double)1.0);
        this.time().sleep(this.noBackpressureConfig().backpressureConfig().backpressureCheckFrequencyMs() + 100L);
        RequestChannel.Request request = this.buildRequest();
        this.simulateTimeOnRequestHandlerThread(request, 2L);
        this.requestQuotaManager().maybeRecordAndGetThrottleTimeMs(request, this.time().milliseconds());
        double expectedBrokerQuotaLimit = (double)this.totalCapacity() * BrokerBackpressureConfig$.MODULE$.DefaultMaxResourceUtilization();
        Assertions.assertEquals((double)expectedBrokerQuotaLimit, (double)this.requestQuotaManager().getBrokerQuotaLimit(), (double)0.01);
        this.time().sleep(1L);
        request.recordNetworkThreadTimeCallback().foreach((Function1 & Serializable)record -> {
            record.apply$mcVJ$sp(1000000L);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((double)expectedBrokerQuotaLimit, (double)this.requestQuotaManager().getBrokerQuotaLimit(), (double)0.01);
    }

    @Test
    public void testBrokerQuotaLimitIsNotUpdatedIfTenantListenerNotConfigured() {
        this.recreateRequestQuotaManagerWithoutTenantListener();
        Assertions.assertFalse((boolean)this.requestQuotaManager().backpressureEnabled());
        Assertions.assertEquals((double)Double.MAX_VALUE, (double)this.requestQuotaManager().getBrokerQuotaLimit(), (double)1.0);
        this.time().sleep(this.noTenantListenerConfig().backpressureConfig().backpressureCheckFrequencyMs() + 100L);
        RequestChannel.Request request = this.buildRequest();
        this.simulateTimeOnRequestHandlerThread(request, 2L);
        this.requestQuotaManager().maybeRecordAndGetThrottleTimeMs(request, this.time().milliseconds());
        Assertions.assertEquals((double)Double.MAX_VALUE, (double)this.requestQuotaManager().getBrokerQuotaLimit(), (double)1.0);
        this.time().sleep(1L);
        request.recordNetworkThreadTimeCallback().foreach((Function1 & Serializable)record -> {
            record.apply$mcVJ$sp(1000000L);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((double)Double.MAX_VALUE, (double)this.requestQuotaManager().getBrokerQuotaLimit(), (double)1.0);
    }

    @Test
    public void testNonExemptRequestQuotasDisabledRecordsTotalThreadUsageMetricsOnly() {
        this.recreateRequestQuotaManagerWithoutQuotas();
        RequestChannel.Request request = this.buildRequest();
        this.simulateTimeOnRequestHandlerThread(request, 1L);
        int throttleMs = this.requestQuotaManager().maybeRecordAndGetThrottleTimeMs(request, this.time().milliseconds());
        Assertions.assertEquals((int)0, (int)throttleMs);
        this.assertIoThreadUsageMetricValue("request-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), 0.01);
        this.assertIoThreadUsageMetricValue("request-non-exempt-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), 0.01);
        this.assertNetworkThreadUsageMetricValue("request-network-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), 0.01);
        this.assertNetworkThreadUsageMetricValue("request-non-exempt-network-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), 0.01);
        this.requestQuotaManager().updateBrokerQuotaLimit(this.time().milliseconds());
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)None$.MODULE$, 0.01);
        this.time().sleep(2L);
        request.recordNetworkThreadTimeCallback().foreach((Function1 & Serializable)record -> {
            record.apply$mcVJ$sp(2000000L);
            return BoxedUnit.UNIT;
        });
        this.assertIoThreadUsageMetricValue("request-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), 0.01);
        this.assertIoThreadUsageMetricValue("request-non-exempt-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), 0.01);
        this.assertNetworkThreadUsageMetricValue("request-network-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.2)), 0.01);
        this.assertNetworkThreadUsageMetricValue("request-non-exempt-network-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), 0.01);
        this.requestQuotaManager().updateBrokerQuotaLimit(this.time().milliseconds());
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)None$.MODULE$, 0.01);
    }

    @Test
    public void testExemptRequestWithQuotasEnabledRecordsTotalThreadUsageMetricsOnly() {
        RequestChannel.Request request = this.buildRequest();
        this.simulateTimeOnRequestHandlerThread(request, 2L);
        this.requestQuotaManager().maybeRecordExempt(request);
        this.assertIoThreadUsageMetricValue("request-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.2)), 0.01);
        this.assertIoThreadUsageMetricValue("request-non-exempt-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), 0.01);
        this.assertNetworkThreadUsageMetricValue("request-network-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), 0.01);
        this.assertNetworkThreadUsageMetricValue("request-non-exempt-network-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), 0.01);
        this.requestQuotaManager().updateBrokerQuotaLimit(this.time().milliseconds());
        double expectedBrokerQuotaLimit = (double)this.totalCapacity() * BrokerBackpressureConfig$.MODULE$.DefaultMaxResourceUtilization() - 0.2;
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedBrokerQuotaLimit)), 0.01);
        this.time().sleep(1L);
        request.recordNetworkThreadTimeCallback().foreach((Function1 & Serializable)record -> {
            record.apply$mcVJ$sp(1000000L);
            return BoxedUnit.UNIT;
        });
        this.assertIoThreadUsageMetricValue("request-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.2)), 0.01);
        this.assertIoThreadUsageMetricValue("request-non-exempt-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), 0.01);
        this.assertNetworkThreadUsageMetricValue("request-network-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), 0.01);
        this.assertNetworkThreadUsageMetricValue("request-non-exempt-network-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), 0.01);
        this.requestQuotaManager().updateBrokerQuotaLimit(this.time().milliseconds());
        double updatedBrokerLimit = expectedBrokerQuotaLimit - 0.1;
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)updatedBrokerLimit)), 0.01);
    }

    @Test
    public void testNonExemptRequestWithQuotasEnabledRecordsAllThreadUsageMetrics() {
        RequestChannel.Request request = this.buildRequest();
        this.simulateTimeOnRequestHandlerThread(request, 2L);
        int throttleMs = this.requestQuotaManager().maybeRecordAndGetThrottleTimeMs(request, this.time().milliseconds());
        Assertions.assertEquals((int)0, (int)throttleMs);
        this.assertIoThreadUsageMetricValue("request-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.2)), 0.01);
        this.assertIoThreadUsageMetricValue("request-non-exempt-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.2)), 0.01);
        this.assertNetworkThreadUsageMetricValue("request-network-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), 0.01);
        this.assertNetworkThreadUsageMetricValue("request-non-exempt-network-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), 0.01);
        this.requestQuotaManager().updateBrokerQuotaLimit(this.time().milliseconds());
        double expectedBrokerQuotaLimit = (double)this.totalCapacity() * BrokerBackpressureConfig$.MODULE$.DefaultMaxResourceUtilization();
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedBrokerQuotaLimit)), 0.01);
        this.time().sleep(1L);
        request.recordNetworkThreadTimeCallback().foreach((Function1 & Serializable)record -> {
            record.apply$mcVJ$sp(1000000L);
            return BoxedUnit.UNIT;
        });
        this.assertIoThreadUsageMetricValue("request-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.2)), 0.01);
        this.assertIoThreadUsageMetricValue("request-non-exempt-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.2)), 0.01);
        this.assertNetworkThreadUsageMetricValue("request-network-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), 0.01);
        this.assertNetworkThreadUsageMetricValue("request-non-exempt-network-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), 0.01);
        this.requestQuotaManager().updateBrokerQuotaLimit(this.time().milliseconds());
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedBrokerQuotaLimit)), 0.01);
    }

    @Test
    public void testBrokerQuotaLimitEnsuresIoThreadpoolIsNotOverUtilized() {
        RequestChannel.Request request = this.buildRequest();
        this.simulateTimeOnRequestHandlerThread(request, 1000L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 8).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$10 -> {
            int throttleMs = this.requestQuotaManager().maybeRecordAndGetThrottleTimeMs(request, this.time().milliseconds());
            Assertions.assertEquals((int)0, (int)throttleMs);
        });
        double expectedIoThreadpoolUsage = (double)this.ioThreadpoolSize() * 100.0;
        this.time().sleep(1L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 4).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$11 -> request.recordNetworkThreadTimeCallback().foreach((Function1 & Serializable)record -> {
            record.apply$mcVJ$sp(1000000L);
            return BoxedUnit.UNIT;
        }));
        this.assertIoThreadUsageMetricValue("request-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedIoThreadpoolUsage)), 1.0);
        this.assertIoThreadUsageMetricValue("request-non-exempt-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedIoThreadpoolUsage)), 1.0);
        this.assertNetworkThreadUsageMetricValue("request-network-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.4)), 0.01);
        this.assertNetworkThreadUsageMetricValue("request-non-exempt-network-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.4)), 0.01);
        this.requestQuotaManager().updateBrokerQuotaLimit(this.time().milliseconds());
        double expectedLimit = (double)this.ioThreadpoolCapacity() * BrokerBackpressureConfig$.MODULE$.DefaultMaxResourceUtilization() + 0.4;
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedLimit)), 1.0);
    }

    @Test
    public void testBrokerQuotaLimitEnsuresNetworkThreadpoolIsNotOverUtilized() {
        RequestChannel.Request request = this.buildRequest();
        this.simulateTimeOnRequestHandlerThread(request, 10L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.ioThreadpoolSize()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$12 -> {
            int throttleMs = this.requestQuotaManager().maybeRecordAndGetThrottleTimeMs(request, this.time().milliseconds());
            Assertions.assertEquals((int)0, (int)throttleMs);
        });
        this.time().sleep(1000L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.networkThreadpoolSize()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$13 -> request.recordNetworkThreadTimeCallback().foreach((Function1 & Serializable)record -> {
            record.apply$mcVJ$sp(1000000000L);
            return BoxedUnit.UNIT;
        }));
        double expectedNetworkThreadpoolUsage = (double)this.networkThreadpoolSize() * 100.0;
        this.assertIoThreadUsageMetricValue("request-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)8.0)), 0.1);
        this.assertIoThreadUsageMetricValue("request-non-exempt-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)8.0)), 0.1);
        this.assertNetworkThreadUsageMetricValue("request-network-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedNetworkThreadpoolUsage)), 1.0);
        this.assertNetworkThreadUsageMetricValue("request-non-exempt-network-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedNetworkThreadpoolUsage)), 1.0);
        this.requestQuotaManager().updateBrokerQuotaLimit(this.time().milliseconds());
        double expectedLimit = (double)this.networkThreadpoolCapacity() * BrokerBackpressureConfig$.MODULE$.DefaultMaxResourceUtilization() + 8.0;
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedLimit)), 1.0);
    }

    @Test
    public void testBrokerQuotaLimitDoesNotFallBelowMinumum() {
        RequestChannel.Request request = this.buildRequest();
        this.simulateTimeOnRequestHandlerThread(request, 1000L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.ioThreadpoolSize()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$14 -> this.requestQuotaManager().maybeRecordExempt(request));
        this.time().sleep(1000L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.networkThreadpoolSize()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$15 -> request.recordNetworkThreadTimeCallback().foreach((Function1 & Serializable)record -> {
            record.apply$mcVJ$sp(1000000000L);
            return BoxedUnit.UNIT;
        }));
        double expectedIoThreadpoolUsage = (double)this.ioThreadpoolSize() * 100.0;
        double expectedNetworkThreadpoolUsage = (double)this.networkThreadpoolSize() * 100.0;
        this.assertIoThreadUsageMetricValue("request-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedIoThreadpoolUsage)), 1.0);
        this.assertIoThreadUsageMetricValue("request-non-exempt-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), 0.01);
        this.assertNetworkThreadUsageMetricValue("request-network-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedNetworkThreadpoolUsage)), 1.0);
        this.assertNetworkThreadUsageMetricValue("request-non-exempt-network-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), 0.01);
        this.requestQuotaManager().updateBrokerQuotaLimit(this.time().milliseconds());
        double expectedLimit = (double)this.totalCapacity() * BrokerBackpressureConfig$.MODULE$.DefaultMinNonExemptRequestUtilization();
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedLimit)), 1.0);
    }

    @Test
    public void testNetworkThreadUsageFromNonTenantEndpointDoesNotAffectBrokerQuotaLimit() {
        RequestChannel.Request request = this.buildRequest(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SASL_PLAINTEXT));
        this.simulateTimeOnRequestHandlerThread(request, 10L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.ioThreadpoolSize()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$16 -> {
            int throttleMs = this.requestQuotaManager().maybeRecordAndGetThrottleTimeMs(request, this.time().milliseconds());
            Assertions.assertEquals((int)0, (int)throttleMs);
        });
        this.time().sleep(1000L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.networkThreadpoolSize()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$17 -> request.recordNetworkThreadTimeCallback().foreach((Function1 & Serializable)record -> {
            record.apply$mcVJ$sp(1000000000L);
            return BoxedUnit.UNIT;
        }));
        this.assertIoThreadUsageMetricValue("request-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)8.0)), 0.1);
        this.assertIoThreadUsageMetricValue("request-non-exempt-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)8.0)), 0.1);
        this.assertNetworkThreadUsageMetricValue("request-network-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), 1.0);
        this.assertNetworkThreadUsageMetricValue("request-non-exempt-network-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), 1.0);
        this.requestQuotaManager().updateBrokerQuotaLimit(this.time().milliseconds());
        double expectedLimit = (double)this.totalCapacity() * BrokerBackpressureConfig$.MODULE$.DefaultMaxResourceUtilization();
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedLimit)), 1.0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUpdateAdjustedCapacityDoesNotAdjustLimitWhenQueueSizeBelowThreshold() {
        void createPercentiles_tags;
        void createPercentiles_metricNamePrefix;
        void createPercentiles_queueSize;
        void createPercentiles_metrics;
        double brokerRequestLimit = 800.0;
        Sensor queueSizeSensor = this.metrics().sensor("RequestQueueSize");
        Map map = QueueSizePercentiles.createPercentiles$default$4$((QueueSizePercentiles)RequestQueueSizePercentiles$.MODULE$);
        String string = DataPlaneAcceptor$.MODULE$.MetricPrefix();
        int n = this.maxQueueSize();
        Metrics metrics = this.metrics();
        RequestQueueSizePercentiles$ createPercentiles_this = RequestQueueSizePercentiles$.MODULE$;
        Object var9_7 = null;
        metrics = null;
        string = null;
        map = null;
        Percentiles queueSizePercentiles = QueueSizePercentiles.createPercentiles$((QueueSizePercentiles)createPercentiles_this, (Metrics)createPercentiles_metrics, (int)createPercentiles_queueSize, (String)createPercentiles_metricNamePrefix, (Map)createPercentiles_tags);
        if (queueSizeSensor == null) {
            throw null;
        }
        queueSizeSensor.add((CompoundStat)queueSizePercentiles, null);
        double correctedLimit = this.requestQuotaManager().updateAdjustedCapacity(brokerRequestLimit, brokerRequestLimit);
        Assertions.assertEquals((double)brokerRequestLimit, (double)correctedLimit, (double)0.0, (String)"Expected no request limit correction during no request load");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> queueSizeSensor.record(this.config().backpressureConfig().queueSizeCap() - 1.0));
        double newCorrectedLimit = this.requestQuotaManager().updateAdjustedCapacity(brokerRequestLimit, brokerRequestLimit);
        Assertions.assertEquals((double)brokerRequestLimit, (double)newCorrectedLimit, (double)0.0, (String)"Expected no request limit correction when queue load is below the threshold");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUpdateAdjustedCapacityDecreasesLimitDuringRequestOverloadAndBacksOffDuringUnderload() {
        void createPercentiles_tags;
        void createPercentiles_metricNamePrefix;
        void createPercentiles_queueSize;
        void createPercentiles_metrics;
        int mult = 10;
        double brokerRequestLimit = this.config().backpressureConfig().minBrokerRequestQuota() + this.config().backpressureConfig().minBrokerRequestQuota() * BrokerBackpressureConfig$.MODULE$.DefaultRequestQuotaIncreasePercentFactor() * (double)mult;
        Sensor queueSizeSensor = this.metrics().sensor("RequestQueueSize");
        Map map = QueueSizePercentiles.createPercentiles$default$4$((QueueSizePercentiles)RequestQueueSizePercentiles$.MODULE$);
        String string = DataPlaneAcceptor$.MODULE$.MetricPrefix();
        int n = this.maxQueueSize();
        Metrics metrics = this.metrics();
        RequestQueueSizePercentiles$ createPercentiles_this = RequestQueueSizePercentiles$.MODULE$;
        Object var11_8 = null;
        metrics = null;
        string = null;
        map = null;
        Percentiles queueSizePercentiles = QueueSizePercentiles.createPercentiles$((QueueSizePercentiles)createPercentiles_this, (Metrics)createPercentiles_metrics, (int)createPercentiles_queueSize, (String)createPercentiles_metricNamePrefix, (Map)createPercentiles_tags);
        if (queueSizeSensor == null) {
            throw null;
        }
        queueSizeSensor.add((CompoundStat)queueSizePercentiles, null);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> queueSizeSensor.record(this.config().backpressureConfig().queueSizeCap() + 1.0));
        DoubleRef expectedLimit = DoubleRef.create((double)brokerRequestLimit);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), mult).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            double correctedLimit = this.requestQuotaManager().updateAdjustedCapacity(brokerRequestLimit, brokerRequestLimit);
            expectedLimit$1.elem = package$.MODULE$.max(this.config().backpressureConfig().minBrokerRequestQuota(), expectedLimit$1.elem - package$.MODULE$.max(BrokerBackpressureConfig$.MODULE$.RequestQuotaMinAdjustment(), brokerRequestLimit * BrokerBackpressureConfig$.MODULE$.DefaultRequestQuotaDecreasePercentFactor()));
            Assertions.assertEquals((double)expectedLimit$1.elem, (double)correctedLimit, (double)0.0, (String)"Expected request limit correction during request overload");
        });
        double minCorrectedLimit = this.requestQuotaManager().updateAdjustedCapacity(brokerRequestLimit, brokerRequestLimit);
        Assertions.assertEquals((double)expectedLimit.elem, (double)minCorrectedLimit, (double)0.0, (String)"Expected request limit correction during request overload");
        this.time().sleep(100000L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> queueSizeSensor.record((double)(i % 10)));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), mult).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            double correctedLimit = this.requestQuotaManager().updateAdjustedCapacity(brokerRequestLimit, brokerRequestLimit);
            expectedLimit$1.elem = package$.MODULE$.min(brokerRequestLimit, expectedLimit$1.elem + package$.MODULE$.max(BrokerBackpressureConfig$.MODULE$.RequestQuotaMinAdjustment(), brokerRequestLimit * BrokerBackpressureConfig$.MODULE$.DefaultRequestQuotaIncreasePercentFactor()));
            Assertions.assertEquals((double)expectedLimit$1.elem, (double)correctedLimit, (double)0.01, (String)"Expected request limit correction during request overload");
        });
        double maxCorrectedLimit = this.requestQuotaManager().updateAdjustedCapacity(brokerRequestLimit, brokerRequestLimit);
        Assertions.assertEquals((double)expectedLimit.elem, (double)maxCorrectedLimit, (double)0.01, (String)"Expected request limit correction during request overload");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerRequestLimitIsAdjustedOnRequestOverload() {
        void createPercentiles_tags;
        void createPercentiles_metricNamePrefix;
        void createPercentiles_queueSize;
        void createPercentiles_metrics;
        RequestChannel.Request request = this.buildRequest();
        this.simulateTimeOnRequestHandlerThread(request, 500L);
        int throttleMs = this.requestQuotaManager().maybeRecordAndGetThrottleTimeMs(request, this.time().milliseconds());
        Assertions.assertEquals((int)0, (int)throttleMs);
        this.assertIoThreadUsageMetricValue("request-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)50.0)), 0.01);
        this.assertIoThreadUsageMetricValue("request-non-exempt-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)50.0)), 0.01);
        this.requestQuotaManager().updateBrokerQuotaLimit(this.time().milliseconds());
        double expectedBrokerQuotaLimit = (double)this.totalCapacity() * BrokerBackpressureConfig$.MODULE$.DefaultMaxResourceUtilization();
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedBrokerQuotaLimit)), 0.01);
        this.time().sleep(10L);
        request.recordNetworkThreadTimeCallback().foreach((Function1 & Serializable)record -> {
            record.apply$mcVJ$sp(10000000L);
            return BoxedUnit.UNIT;
        });
        this.assertNetworkThreadUsageMetricValue("request-network-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), 0.01);
        this.assertNetworkThreadUsageMetricValue("request-non-exempt-network-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), 0.01);
        this.requestQuotaManager().updateBrokerQuotaLimit(this.time().milliseconds());
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedBrokerQuotaLimit)), 0.01);
        Sensor queueSizeSensor = this.metrics().sensor("RequestQueueSize");
        Map map = QueueSizePercentiles.createPercentiles$default$4$((QueueSizePercentiles)RequestQueueSizePercentiles$.MODULE$);
        String string = DataPlaneAcceptor$.MODULE$.MetricPrefix();
        int n = this.maxQueueSize();
        Metrics metrics = this.metrics();
        RequestQueueSizePercentiles$ createPercentiles_this = RequestQueueSizePercentiles$.MODULE$;
        Object var9_9 = null;
        metrics = null;
        string = null;
        map = null;
        Percentiles queueSizePercentiles = QueueSizePercentiles.createPercentiles$((QueueSizePercentiles)createPercentiles_this, (Metrics)createPercentiles_metrics, (int)createPercentiles_queueSize, (String)createPercentiles_metricNamePrefix, (Map)createPercentiles_tags);
        if (queueSizeSensor == null) {
            throw null;
        }
        queueSizeSensor.add((CompoundStat)queueSizePercentiles, null);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> queueSizeSensor.record(this.config().backpressureConfig().queueSizeCap() + 1.0));
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedBrokerQuotaLimit)), 0.01);
        this.requestQuotaManager().updateBrokerQuotaLimit(this.time().milliseconds());
        double decreasedBrokerQuotaLimit = expectedBrokerQuotaLimit * (1.0 - BrokerBackpressureConfig$.MODULE$.DefaultRequestQuotaDecreasePercentFactor());
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)decreasedBrokerQuotaLimit)), 0.01);
        this.time().sleep(100000L);
        this.requestQuotaManager().updateBrokerQuotaLimit(this.time().milliseconds());
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)(decreasedBrokerQuotaLimit + BrokerBackpressureConfig$.MODULE$.RequestQuotaMinAdjustment()))), 0.01);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerRequestLimitDoesNotFallBelowMinimum() {
        void createPercentiles_tags;
        void createPercentiles_metricNamePrefix;
        void createPercentiles_queueSize;
        void createPercentiles_metrics;
        RequestChannel.Request request = this.buildRequest();
        this.simulateTimeOnRequestHandlerThread(request, 500L);
        int throttleMs = this.requestQuotaManager().maybeRecordAndGetThrottleTimeMs(request, this.time().milliseconds());
        Assertions.assertEquals((int)0, (int)throttleMs);
        this.time().sleep(10L);
        request.recordNetworkThreadTimeCallback().foreach((Function1 & Serializable)record -> {
            record.apply$mcVJ$sp(10000000L);
            return BoxedUnit.UNIT;
        });
        double expectedBrokerQuotaLimit = (double)this.totalCapacity() * BrokerBackpressureConfig$.MODULE$.DefaultMaxResourceUtilization();
        this.requestQuotaManager().updateBrokerQuotaLimit(this.time().milliseconds());
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedBrokerQuotaLimit)), 0.01);
        Sensor queueSizeSensor = this.metrics().sensor("RequestQueueSize");
        Map map = QueueSizePercentiles.createPercentiles$default$4$((QueueSizePercentiles)RequestQueueSizePercentiles$.MODULE$);
        String string = DataPlaneAcceptor$.MODULE$.MetricPrefix();
        int n = this.maxQueueSize();
        Metrics metrics = this.metrics();
        RequestQueueSizePercentiles$ createPercentiles_this = RequestQueueSizePercentiles$.MODULE$;
        Object var7_9 = null;
        metrics = null;
        string = null;
        map = null;
        Percentiles queueSizePercentiles = QueueSizePercentiles.createPercentiles$((QueueSizePercentiles)createPercentiles_this, (Metrics)createPercentiles_metrics, (int)createPercentiles_queueSize, (String)createPercentiles_metricNamePrefix, (Map)createPercentiles_tags);
        if (queueSizeSensor == null) {
            throw null;
        }
        queueSizeSensor.add((CompoundStat)queueSizePercentiles, null);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> queueSizeSensor.record((double)(i % 410)));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 1000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.requestQuotaManager().updateBrokerQuotaLimit(this.time().milliseconds()));
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)this.config().backpressureConfig().minBrokerRequestQuota())), 0.01);
    }

    @Test
    public void testMultipleTenantEndpoints() {
        this.recreateRequestQuotaManagerWithTwoTenantEnpoints();
        RequestChannel.Request request1 = this.buildRequest();
        this.simulateTimeOnRequestHandlerThread(request1, 2L);
        int throttleMs1 = this.requestQuotaManager().maybeRecordAndGetThrottleTimeMs(request1, this.time().milliseconds());
        Assertions.assertEquals((int)0, (int)throttleMs1);
        RequestChannel.Request request2 = this.buildRequest(this.secondListener());
        this.simulateTimeOnRequestHandlerThread(request2, 2L);
        int throttleMs2 = this.requestQuotaManager().maybeRecordAndGetThrottleTimeMs(request2, this.time().milliseconds());
        Assertions.assertEquals((int)0, (int)throttleMs2);
        this.assertIoThreadUsageMetricValue("request-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.4)), 0.01);
        this.assertIoThreadUsageMetricValue("request-non-exempt-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.4)), 0.01);
        this.assertNetworkThreadUsageMetricValue("request-network-time", this.testListener().value(), (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), 0.01);
        this.assertNetworkThreadUsageMetricValue("request-network-time", this.secondListener().value(), (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), 0.01);
        this.assertNetworkThreadUsageMetricValue("request-non-exempt-network-time", this.testListener().value(), (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), 0.01);
        this.assertNetworkThreadUsageMetricValue("request-non-exempt-network-time", this.secondListener().value(), (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), 0.01);
        this.requestQuotaManager().updateBrokerQuotaLimit(this.time().milliseconds());
        double expectedBrokerQuotaLimit = (double)(this.ioThreadpoolCapacity() + this.networkThreadpoolCapacity() + this.networkThreadpoolCapacity()) * BrokerBackpressureConfig$.MODULE$.DefaultMaxResourceUtilization();
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedBrokerQuotaLimit)), 0.01);
        this.time().sleep(1L);
        request1.recordNetworkThreadTimeCallback().foreach((Function1 & Serializable)record -> {
            record.apply$mcVJ$sp(1000000L);
            return BoxedUnit.UNIT;
        });
        request2.recordNetworkThreadTimeCallback().foreach((Function1 & Serializable)record -> {
            record.apply$mcVJ$sp(1000000L);
            return BoxedUnit.UNIT;
        });
        this.assertIoThreadUsageMetricValue("request-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.4)), 0.01);
        this.assertIoThreadUsageMetricValue("request-non-exempt-io-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.4)), 0.01);
        this.assertNetworkThreadUsageMetricValue("request-network-time", this.testListener().value(), (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), 0.01);
        this.assertNetworkThreadUsageMetricValue("request-network-time", this.secondListener().value(), (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), 0.01);
        Assertions.assertEquals((double)0.2, (double)ThreadUsageMetrics$.MODULE$.networkThreadsUsage(this.metrics(), (Seq)new .colon.colon((Object)this.testListener().value(), (List)new .colon.colon((Object)this.secondListener().value(), (List)Nil$.MODULE$)), (RequestType)AllRequests$.MODULE$), (double)0.01, (String)"request-network-time");
        this.assertNetworkThreadUsageMetricValue("request-non-exempt-network-time", this.testListener().value(), (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), 0.01);
        this.assertNetworkThreadUsageMetricValue("request-non-exempt-network-time", this.secondListener().value(), (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), 0.01);
        Assertions.assertEquals((double)0.2, (double)ThreadUsageMetrics$.MODULE$.networkThreadsUsage(this.metrics(), (Seq)new .colon.colon((Object)this.testListener().value(), (List)new .colon.colon((Object)this.secondListener().value(), (List)Nil$.MODULE$)), (RequestType)NonExemptRequest$.MODULE$), (double)0.01, (String)"request-non-exempt-network-time");
        this.requestQuotaManager().updateBrokerQuotaLimit(this.time().milliseconds());
        this.assertBackpressureMetricValue("non-exempt-request-time-capacity", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedBrokerQuotaLimit)), 0.01);
    }

    @Test
    public void testRemoveListenerMetrics() {
        RequestChannel.Request request = this.buildRequest();
        this.simulateTimeOnRequestHandlerThread(request, 10L);
        this.requestQuotaManager().maybeRecordAndGetThrottleTimeMs(request, this.time().milliseconds());
        this.time().sleep(1000L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.networkThreadpoolSize()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$18 -> request.recordNetworkThreadTimeCallback().foreach((Function1 & Serializable)record -> {
            record.apply$mcVJ$sp(1000000000L);
            return BoxedUnit.UNIT;
        }));
        double expectedNetworkThreadpoolUsage = (double)this.networkThreadpoolSize() * 100.0;
        this.assertNetworkThreadUsageMetricValue("request-network-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedNetworkThreadpoolUsage)), 1.0);
        this.assertNetworkThreadUsageMetricValue("request-non-exempt-network-time", (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)expectedNetworkThreadpoolUsage)), 1.0);
        this.requestQuotaManager().removeListenerMetrics(this.testListener().value());
        this.assertNetworkThreadUsageMetricValue("request-network-time", (Option<Object>)None$.MODULE$, 1.0);
        this.assertNetworkThreadUsageMetricValue("request-non-exempt-network-time", (Option<Object>)None$.MODULE$, 1.0);
    }

    private void simulateTimeOnRequestHandlerThread(RequestChannel.Request request, long ms) {
        request.requestDequeueTimeNanos_$eq(this.time().nanoseconds());
        this.time().sleep(ms);
        request.apiLocalCompleteTimeNanos_$eq(this.time().nanoseconds());
    }

    private void assertBackpressureMetricValue(String metricName, Option<Object> expectedValueOpt, double delta) {
        this.assertMetricValue(metricName, "backpressure-metrics", (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), expectedValueOpt, delta);
    }

    private void assertIoThreadUsageMetricValue(String metricName, Option<Object> expectedValueOpt, double delta) {
        this.assertMetricValue(metricName, ThreadUsageMetrics$.MODULE$.MetricGroup(), (scala.collection.immutable.Map<String, String>)ThreadUsageMetrics$.MODULE$.ioThreadUsageMetricTags(), expectedValueOpt, delta);
    }

    private void assertNetworkThreadUsageMetricValue(String metricName, Option<Object> expectedValueOpt, double delta) {
        this.assertNetworkThreadUsageMetricValue(metricName, this.testListener().value(), expectedValueOpt, delta);
    }

    private void assertNetworkThreadUsageMetricValue(String metricName, String listener, Option<Object> expectedValueOpt, double delta) {
        this.assertMetricValue(metricName, ThreadUsageMetrics$.MODULE$.MetricGroup(), (scala.collection.immutable.Map<String, String>)ThreadUsageMetrics$.MODULE$.listenerNetworkThreadUsageMetricTags(listener), expectedValueOpt, delta);
    }

    private void assertMetricValue(String metricName, String group, scala.collection.immutable.Map<String, String> metricTags, Option<Object> expectedValueOpt, double delta) {
        KafkaMetric metric = this.metrics().metric(this.metrics().metricName(metricName, group, "", CollectionConverters$.MODULE$.MapHasAsJava(metricTags).asJava()));
        if (expectedValueOpt instanceof Some) {
            Assertions.assertEquals((double)BoxesRunTime.unboxToDouble((Object)((Some)expectedValueOpt).value()), (double)BoxesRunTime.unboxToDouble((Object)metric.metricValue()), (double)delta, (String)metricName);
            return;
        }
        Assertions.assertNull((Object)metric);
    }

    private RequestChannel.Request buildRequest() {
        return this.buildRequest(this.testListener());
    }

    private RequestChannel.Request buildRequest(ListenerName listenerName) {
        OffsetFetchRequest.Builder builder = new OffsetFetchRequest.Builder("test-group", true, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.testTopicPartition(), (List)Nil$.MODULE$)).asJava(), false);
        OffsetFetchRequest request = (OffsetFetchRequest)builder.build();
        ByteBuffer buffer = request.serializeWithHeader(new RequestHeader(builder.apiKey(), request.version(), this.testClient(), 0));
        RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        RequestContext context = new RequestContext(header, "1", InetAddress.getLocalHost(), this.testPrincipal(), listenerName, SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, null, false);
        return new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, buffer, requestChannelMetrics, (Option)None$.MODULE$, Context.root(), NoOpEventEmitter.INSTANCE, (AuditLogProvider)NoOpAuditLogProvider.INSTANCE, RequestLogFilter.MATCH_NONE, 0L);
    }

    private int maybeRecord(String user, String clientId, double value) {
        KafkaPrincipal principal = new KafkaPrincipal("User", user);
        RequestChannel.Session session = new RequestChannel.Session(principal, null);
        return this.requestQuotaManager().maybeRecordAndGetThrottleTimeMs(session, clientId, value, this.time().milliseconds());
    }

    public double millisToPercent(double millis) {
        return millis * (double)1000 * (double)1000 * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
    }

    public ConfluentClientRequestQuotaManagerTest() {
        this.ioThreadpoolSize = 8;
        this.networkThreadpoolSize = 4;
        this.maxQueueSize = 500;
        this.testUser = "ANONYMOUS";
        this.testClient = "Client1";
        BrokerBackpressureConfig x$1 = new BrokerBackpressureConfig(true, 10L * TimeUnit.HOURS.toMillis(1L), (Seq)new .colon.colon((Object)this.testListener().value(), (List)Nil$.MODULE$), (double)this.maxQueueSize(), 110.0, "p99");
        int x$2 = Defaults$.MODULE$.DefaultNumQuotaSamples();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        DiskUsageBasedThrottlingConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        double x$5 = 9.223372036854776E18;
        long x$6 = 0L;
        int x$7 = 0;
        long x$8 = Long.MAX_VALUE;
        this.config = new ClientQuotaManagerConfig(x$2, x$3, x$1, x$4, x$5, x$6, x$7, x$8);
        BrokerBackpressureConfig x$9 = new BrokerBackpressureConfig(true, 10L * TimeUnit.HOURS.toMillis(1L), (Seq)new .colon.colon((Object)this.testListener().value(), (List)new .colon.colon((Object)this.secondListener().value(), (List)Nil$.MODULE$)), Double.MAX_VALUE, (double)Predef$.MODULE$.Long2long(ConfluentConfigs.BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_DEFAULT), "p95");
        int x$10 = Defaults$.MODULE$.DefaultNumQuotaSamples();
        int x$11 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        DiskUsageBasedThrottlingConfig x$12 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        double x$13 = 9.223372036854776E18;
        long x$14 = 0L;
        int x$15 = 0;
        long x$16 = Long.MAX_VALUE;
        this.twoTenantEndpointsConfig = new ClientQuotaManagerConfig(x$10, x$11, x$9, x$12, x$13, x$14, x$15, x$16);
        BrokerBackpressureConfig x$17 = new BrokerBackpressureConfig(false, 10L * TimeUnit.SECONDS.toMillis(1L), (Seq)new .colon.colon((Object)this.testListener().value(), (List)Nil$.MODULE$), Double.MAX_VALUE, (double)Predef$.MODULE$.Long2long(ConfluentConfigs.BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_DEFAULT), "p95");
        int x$18 = Defaults$.MODULE$.DefaultNumQuotaSamples();
        int x$19 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        DiskUsageBasedThrottlingConfig x$20 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        double x$21 = 9.223372036854776E18;
        long x$22 = 0L;
        int x$23 = 0;
        long x$24 = Long.MAX_VALUE;
        this.noBackpressureConfig = new ClientQuotaManagerConfig(x$18, x$19, x$17, x$20, x$21, x$22, x$23, x$24);
        BrokerBackpressureConfig x$25 = new BrokerBackpressureConfig(true, 10L * TimeUnit.SECONDS.toMillis(1L), (Seq)Nil$.MODULE$, Double.MAX_VALUE, (double)Predef$.MODULE$.Long2long(ConfluentConfigs.BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_DEFAULT), "p95");
        int x$26 = Defaults$.MODULE$.DefaultNumQuotaSamples();
        int x$27 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        DiskUsageBasedThrottlingConfig x$28 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        double x$29 = 9.223372036854776E18;
        long x$30 = 0L;
        int x$31 = 0;
        long x$32 = Long.MAX_VALUE;
        this.noTenantListenerConfig = new ClientQuotaManagerConfig(x$26, x$27, x$25, x$28, x$29, x$30, x$31, x$32);
        this.noQuotasConfig = new ClientQuotaManagerConfig(Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L, 0, Long.MAX_VALUE);
    }

    public static final /* synthetic */ Object $anonfun$beforeMethod$1$adapted(ClientRequestQuotaManager eta$0$1$1, String listenerName) {
        eta$0$1$1.addListenerMetrics(listenerName);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$recreateRequestQuotaManagerWithoutQuotas$1$adapted(ClientRequestQuotaManager eta$0$1$2, String listenerName) {
        eta$0$1$2.addListenerMetrics(listenerName);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$recreateRequestQuotaManagerWithoutBackpressure$1$adapted(ClientRequestQuotaManager eta$0$1$3, String listenerName) {
        eta$0$1$3.addListenerMetrics(listenerName);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$recreateRequestQuotaManagerWithoutTenantListener$1$adapted(ClientRequestQuotaManager eta$0$1$4, String listenerName) {
        eta$0$1$4.addListenerMetrics(listenerName);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$recreateRequestQuotaManagerWithTwoTenantEnpoints$1$adapted(ClientRequestQuotaManager eta$0$1$5, String listenerName) {
        eta$0$1$5.addListenerMetrics(listenerName);
        return BoxedUnit.UNIT;
    }
}

