/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeMap;
import java.util.function.Supplier;
import kafka.server.ControllerConfigurationValidator;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.metadata.placement.UsableBroker;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005%h\u0001\u0002\u0014(\u00011BQa\r\u0001\u0005\u0002QBqa\u000e\u0001C\u0002\u0013\u0005\u0001\b\u0003\u0004=\u0001\u0001\u0006I!\u000f\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0011\u0019)\u0006\u0001)A\u0005\u007f!9a\u000b\u0001b\u0001\n\u00039\u0006BB.\u0001A\u0003%\u0001\fC\u0003]\u0001\u0011\u0005Q\fC\u0003m\u0001\u0011\u0005Q\fC\u0003o\u0001\u0011\u0005Q\fC\u0003q\u0001\u0011\u0005Q\fC\u0003s\u0001\u0011\u0005Q\fC\u0003u\u0001\u0011\u0005Q\fC\u0003w\u0001\u0011\u0005Q\fC\u0003y\u0001\u0011\u0005Q\fC\u0003{\u0001\u0011\u0005Q\fC\u0003}\u0001\u0011\u0005Q\fC\u0003\u007f\u0001\u0011%q\u0010\u0003\u0004\u00020\u0001!\t!\u0018\u0005\u0007\u0003g\u0001A\u0011A/\t\r\u0005]\u0002\u0001\"\u0001^\u0011\u0019\tY\u0004\u0001C\u0001;\"1\u0011q\b\u0001\u0005\u0002uCa!a\u0011\u0001\t\u0003i\u0006BBA$\u0001\u0011\u0005Q\f\u0003\u0004\u0002L\u0001!\t!\u0018\u0005\b\u0003\u001f\u0002A\u0011AA)\u0011\u001d\ty\t\u0001C\u0001\u0003#Cq!a(\u0001\t\u0013\t\t\u000bC\u0004\u0002 \u0002!I!a+\t\u0013\u0005m\u0006!%A\u0005\n\u0005u\u0006\"CAj\u0001E\u0005I\u0011BA_\u0011\u0019\t)\u000e\u0001C\u0001;\"1\u0011\u0011\u001c\u0001\u0005\u0002uCa!!8\u0001\t\u0003i\u0006BBAq\u0001\u0011\u0005Q\f\u0003\u0004\u0002f\u0002!\t!\u0018\u0002%\u0007>tGO]8mY\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:4\u0016\r\\5eCR|'\u000fV3ti*\u0011\u0001&K\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003)\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001[A\u0011a&M\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u001b\u0011\u0005Y\u0002Q\"A\u0014\u0002\r\r|gNZ5h+\u0005I\u0004C\u0001\u001c;\u0013\tYtEA\u0006LC\u001a\\\u0017mQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\u001eY\u0006$Xm\u001d;NKR\fG-\u0019;b-\u0016\u00148/[8o'V\u0004\b\u000f\\5feV\tq\bE\u0002A\u000f&k\u0011!\u0011\u0006\u0003\u0005\u000e\u000b\u0001BZ;oGRLwN\u001c\u0006\u0003\t\u0016\u000bA!\u001e;jY*\ta)\u0001\u0003kCZ\f\u0017B\u0001%B\u0005!\u0019V\u000f\u001d9mS\u0016\u0014\bC\u0001&T\u001b\u0005Y%B\u0001'N\u0003\u0019\u0019w.\\7p]*\u0011\u0001F\u0014\u0006\u0003U=S!\u0001U)\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0016aA8sO&\u0011Ak\u0013\u0002\u0010\u001b\u0016$\u0018\rZ1uCZ+'o]5p]\u0006qB.\u0019;fgRlU\r^1eCR\fg+\u001a:tS>t7+\u001e9qY&,'\u000fI\u0001\nm\u0006d\u0017\u000eZ1u_J,\u0012\u0001\u0017\t\u0003meK!AW\u0014\u0003A\r{g\u000e\u001e:pY2,'oQ8oM&<WO]1uS>tg+\u00197jI\u0006$xN]\u0001\u000bm\u0006d\u0017\u000eZ1u_J\u0004\u0013A\t;fgR$UMZ1vYR$v\u000e]5d%\u0016\u001cx.\u001e:dK&\u001b(+\u001a6fGR,G\rF\u0001_!\tqs,\u0003\u0002a_\t!QK\\5uQ\tA!\r\u0005\u0002dU6\tAM\u0003\u0002fM\u0006\u0019\u0011\r]5\u000b\u0005\u001dD\u0017a\u00026va&$XM\u001d\u0006\u0003SF\u000bQA[;oSRL!a\u001b3\u0003\tQ+7\u000f^\u0001\u001di\u0016\u001cH/\u00138wC2LG\rV8qS\u000et\u0015-\\3SK*,7\r^3eQ\tI!-A\fuKN$XK\\6o_^t'+Z:pkJ\u001cW\rV=qK\"\u0012!BY\u0001\u0019i\u0016\u001cHOT;mYR{\u0007/[2D_:4\u0017n\u001a,bYV,\u0007FA\u0006c\u0003Q!Xm\u001d;WC2LG\rV8qS\u000e\u001cuN\u001c4jO\"\u0012ABY\u0001\u0017i\u0016\u001cH/\u00138wC2LG\rV8qS\u000e\u001cuN\u001c4jO\"\u0012QBY\u0001\"i\u0016\u001cH/\u00138wC2LGmU2iK6\fg+\u00197jI\u0006$\u0018n\u001c8D_:4\u0017n\u001a\u0015\u0003\u001d\t\fa\u0006^3ti&sg/\u00197jIN\u001b\u0007.Z7b-\u0006d\u0017\u000eZ1uS>t7i\u001c8gS\u001e\u001cE.Y:t\u001d>$hi\\;oI\"\u0012qBY\u0001\u0018i\u0016\u001cH/\u00138wC2LGM\u0011:pW\u0016\u0014XI\u001c;jifD#\u0001\u00052\u00027Q,7\u000f^%om\u0006d\u0017\u000e\u001a(fO\u0006$\u0018N^3Ce>\\WM]%eQ\t\t\"-A\u000bwKJLg-\u001f'pO\u000e{gNZ5h\u0007\"\fgnZ3\u0015\u0017y\u000b\t!a\u0001\u0002\u001e\u0005\u0005\u00121\u0006\u0005\u0006-J\u0001\r\u0001\u0017\u0005\b\u0003\u000b\u0011\u0002\u0019AA\u0004\u0003E\u0001(/\u001a<DY\u0016\fg.\u001e9Q_2L7-\u001f\t\u0005\u0003\u0013\t9B\u0004\u0003\u0002\f\u0005M\u0001cAA\u0007_5\u0011\u0011q\u0002\u0006\u0004\u0003#Y\u0013A\u0002\u001fs_>$h(C\u0002\u0002\u0016=\na\u0001\u0015:fI\u00164\u0017\u0002BA\r\u00037\u0011aa\u0015;sS:<'bAA\u000b_!9\u0011q\u0004\nA\u0002\u0005\u001d\u0011\u0001\u00058fo\u000ecW-\u00198vaB{G.[2z\u0011\u001d\t\u0019C\u0005a\u0001\u0003K\t\u0011\u0004^5fe\u000ecW-\u00198fe\u001a+\u0017\r^;sK\u0016s\u0017M\u00197fIB\u0019a&a\n\n\u0007\u0005%rFA\u0004C_>dW-\u00198\t\u000f\u00055\"\u00031\u0001\u0002\b\u0005)R\r\u001f9fGR,G-\u0012=dKB$\u0018n\u001c8UKb$\u0018!\f;fgR4\u0016\r\\5eCR,Gk\u001c9jG\u000e{gNZ5h\u0007\"\fgnZ3D_6\u0004\u0018m\u0019;j_:\u001cF/\u0019;vg\"\u00121CY\u0001*i\u0016\u001cH\u000fV8qS\u000e\u0004F.Y2f[\u0016tGo\u00115b]\u001e,7oU;dG\u0016\u001c8OT3x\u0007>tg-[4)\u0005Q\u0011\u0017\u0001\f;fgR$v\u000e]5d!2\f7-Z7f]R\u001c\u0005.\u00198hKN\u001cVoY2fgN,\u0006\u000fZ1uK\u000e{gNZ5hQ\t)\"-\u0001\u0015uKN$Hk\u001c9jGBc\u0017mY3nK:$8\t[1oO\u0016\u001c8+^2dKN\u001chj\\\"iC:<W\r\u000b\u0002\u0017E\u0006yC/Z:u)>\u0004\u0018n\u0019)mC\u000e,W.\u001a8u\u0007\"\fgnZ3t'V\u001c7-Z:t%\u0016lwN^3QY\u0006\u001cW-\\3oi\"\u0012qCY\u0001%i\u0016\u001cH\u000fV8qS\u000e\u0004F.Y2f[\u0016tGo\u00115b]\u001e,7/\u00138wC2LGMS:p]\"\u0012\u0001DY\u0001+i\u0016\u001cHOT3x)>\u0004\u0018n\u0019)mC\u000e,W.\u001a8u\u0007>tg-[4CkRtu\u000e^*vaB|'\u000f^3eQ\tI\"-\u0001\u001duKN$H)\u001a7fi\u0016$v\u000e]5d!2\f7-Z7f]R\u001cuN\u001c4jO\u0006\u001b7-\u001a9uK\u0012,e/\u001a8JM:{GoU;qa>\u0014H/\u001a3)\u0005i\u0011\u0017a\u0005;fgR$v\u000e]5d)f\u0004XmQ8oM&<Gc\u00020\u0002T\u0005]\u00131\f\u0005\b\u0003+Z\u0002\u0019AA\u0013\u0003\u0019\u0002\u0018M\u001d;ji&|gn\u0012:pkB\u001cV\u000f\u001d9peR,GMV5b'R\fG/[2D_:4\u0017n\u001a\u0005\b\u00033Z\u0002\u0019AA\u0013\u0003)jW\r^1eCR\fG)\u0019;b-\u0016\u00148/[8o'V\u0004\bo\u001c:ugB\u000b'\u000f^5uS>twI]8vaNDq!!\u0018\u001c\u0001\u0004\t)#A\u0012o_6Lg.\u00197U_BL7m]#oC\ndW\r\u001a,jCN#\u0018\r^5d\u0007>tg-[4)\u0007m\t\t\u0007\u0005\u0003\u0002d\u0005%TBAA3\u0015\r\t9GZ\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\u0005-\u0014Q\r\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\bfB\u000e\u0002p\u0005m\u0014Q\u0010\t\u0005\u0003c\n9(\u0004\u0002\u0002t)!\u0011QOA3\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018\u0002BA=\u0003g\u0012\u0011bQ:w'>,(oY3\u0002\u000bY\fG.^3-\u0011\u0005}\u00141QAD\u0003\u0017\u000b#!!!\u0002#\u0019\fGn]3-M\u0006d7/\u001a\u0017gC2\u001cX-\t\u0002\u0002\u0006\u0006\u0001BO];fY\u0019\fGn]3-M\u0006d7/Z\u0011\u0003\u0003\u0013\u000b\u0001CZ1mg\u0016dc-\u00197tK2\"(/^3\"\u0005\u00055\u0015a\u0004;sk\u0016dc-\u00197tK2\"(/^3\u00023Q,7\u000f\u001e+pa&\u001cG+\u001f9f\u0007>tg-[4DQ\u0006tw-\u001a\u000b\b=\u0006M\u0015QSAL\u0011\u001d\t)\u0006\ba\u0001\u0003KAq!!\u0017\u001d\u0001\u0004\t)\u0003C\u0004\u0002^q\u0001\r!!\n)\u0007q\t\t\u0007K\u0004\u001d\u0003_\nY(!(-\u0011\u0005}\u00141QAD\u0003\u0017\u000b!c\u0019:fCR,'I]8lKJ\u001cuN\u001c4jOR\u0011\u00111\u0015\t\u0005\u0003K\u000b9+D\u0001D\u0013\r\tIk\u0011\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001cHCCAR\u0003[\u000b\t,!.\u00028\"9\u0011q\u0016\u0010A\u0002\u0005\u0015\u0012a\u0003;jKJ4U-\u0019;ve\u0016Dq!a-\u001f\u0001\u0004\t)#\u0001\nuS\u0016\u00148\t\\3b]\u0016\u0014h)Z1ukJ,\u0007\"CA+=A\u0005\t\u0019AA\u0013\u0011%\tIL\bI\u0001\u0002\u0004\t)#\u0001\u0016o_6Lg.\u00197U_BL7m\u0011:fCRLwN\\#oC\ndW\r\u001a,jCN#\u0018\r^5d\u0007>tg-[4\u00029\r\u0014X-\u0019;f\u0005J|7.\u001a:D_:4\u0017n\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\u0018\u0016\u0005\u0003K\t\tm\u000b\u0002\u0002DB!\u0011QYAh\u001b\t\t9M\u0003\u0003\u0002J\u0006-\u0017!C;oG\",7m[3e\u0015\r\timL\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAi\u0003\u000f\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003q\u0019'/Z1uK\n\u0013xn[3s\u0007>tg-[4%I\u00164\u0017-\u001e7uIQ\nA\u0004^3tiZ\u000bG.\u001b3DY&,g\u000e^'fiJL7m]\"p]\u001aLw\r\u000b\u0002\"E\u0006qC/Z:u\u0013:4\u0018\r\\5e'V\u00147o\u0019:jaRLwN\u001c(b[\u0016\u001cE.[3oi6+GO]5dg\u000e{gNZ5hQ\t\u0011#-\u0001\u0014uKN$\u0018J\u001c<bY&$\u0017J\u001c;feZ\fGn\u00117jK:$X*\u001a;sS\u000e\u001c8i\u001c8gS\u001eD#a\t2\u0002MQ,7\u000f^+oI\u00164\u0017N\\3e\u0007>tg-[4DY&,g\u000e^'fiJL7m]\"p]\u001aLw\r\u000b\u0002%E\u0006\u0019C/Z:u\u0013:4\u0018\r\\5e\u001b\u0006$8\r[\"mS\u0016tG/T3ue&\u001c7oQ8oM&<\u0007FA\u0013c\u0001")
public class ControllerConfigurationValidatorTest {
    private final KafkaConfig config = new KafkaConfig((java.util.Map)this.createBrokerConfig(true, true, false, false));
    private final Supplier<MetadataVersion> latestMetadataVersionSupplier = () -> MetadataVersion.latestTesting();
    private final ControllerConfigurationValidator validator = new ControllerConfigurationValidator(this.config(), this.latestMetadataVersionSupplier());

    public KafkaConfig config() {
        return this.config;
    }

    private Supplier<MetadataVersion> latestMetadataVersionSupplier() {
        return this.latestMetadataVersionSupplier;
    }

    public ControllerConfigurationValidator validator() {
        return this.validator;
    }

    @Test
    public void testDefaultTopicResourceIsRejected() {
        Assertions.assertEquals((Object)"Default topic resources are not allowed.", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, ""), Collections.emptyMap())).getMessage());
    }

    @Test
    public void testInvalidTopicNameRejected() {
        Assertions.assertEquals((Object)"Topic name is invalid: '(<-invalid->)' contains one or more characters other than ASCII alphanumerics, '.', '_' and '-'", (Object)Assertions.assertThrows(InvalidTopicException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "(<-invalid->)"), Collections.emptyMap())).getMessage());
    }

    @Test
    public void testUnknownResourceType() {
        Assertions.assertEquals((Object)"Unknown resource type BROKER_LOGGER", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.BROKER_LOGGER, "foo"), Collections.emptyMap())).getMessage());
    }

    @Test
    public void testNullTopicConfigValue() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "10");
        config.put("segment.bytes", null);
        config.put("segment.ms", null);
        Assertions.assertEquals((Object)"Null value not supported for topic configs: segment.bytes,segment.ms", (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (java.util.Map)config)).getMessage());
    }

    @Test
    public void testValidTopicConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        config.put("segment.bytes", "67108864");
        this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), config);
    }

    @Test
    public void testInvalidTopicConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        config.put("segment.bytes", "67108864");
        config.put("foobar", "abc");
        Assertions.assertEquals((Object)"Unknown topic config name: foobar", (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (java.util.Map)config)).getMessage());
    }

    @Test
    public void testInvalidSchemaValidationConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("confluent.key.schema.validation", "true");
        Properties brokerConfig = this.createBrokerConfig(false, false, false, false);
        brokerConfig.put("confluent.schema.validator.interceptor.class", "io.confluent.kafka.schemaregistry.validator.RecordSchemaValidator");
        ControllerConfigurationValidator newValidator = new ControllerConfigurationValidator(new KafkaConfig((java.util.Map)brokerConfig), this.latestMetadataVersionSupplier());
        Assertions.assertEquals((Object)"confluent.key.schema.validation and / or confluent.value.schema.validation is enabled but there is no confluent.schema.registry.url specified at the broker side, will not add the corresponding validator", (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> newValidator.validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (java.util.Map)config)).getMessage());
    }

    @Test
    public void testInvalidSchemaValidationConfigClassNotFound() {
        String className = "random.class";
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("confluent.value.schema.validation", "true");
        Properties brokerConfig = this.createBrokerConfig(false, false, false, false);
        brokerConfig.put("confluent.schema.validator.interceptor.class", className);
        brokerConfig.put("confluent.schema.registry.url", "sr_url");
        ControllerConfigurationValidator newValidator = new ControllerConfigurationValidator(new KafkaConfig((java.util.Map)brokerConfig), this.latestMetadataVersionSupplier());
        Assertions.assertEquals((Object)new StringBuilder(22).append("Class ").append(className).append(" cannot be found").toString(), (Object)Assertions.assertThrows(KafkaException.class, () -> newValidator.validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (java.util.Map)config)).getMessage());
    }

    @Test
    public void testInvalidBrokerEntity() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        Assertions.assertEquals((Object)"Unable to parse broker name as a base 10 number.", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.BROKER, "blah"), (java.util.Map)config)).getMessage());
    }

    @Test
    public void testInvalidNegativeBrokerId() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        Assertions.assertEquals((Object)"Invalid negative broker ID.", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.BROKER, "-1"), (java.util.Map)config)).getMessage());
    }

    private void verifyLogConfigChange(ControllerConfigurationValidator validator, String prevCleanupPolicy, String newCleanupPolicy, boolean tierCleanerFeatureEnabled, String expectedExceptionText) {
        if (expectedExceptionText.isEmpty()) {
            try {
                validator.validateTopicConfigChange(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanup.policy"), (Object)prevCleanupPolicy)}))).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanup.policy"), (Object)newCleanupPolicy), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.tier.cleaner.enable"), (Object)Boolean.toString(tierCleanerFeatureEnabled))}))).asJava(), new ArrayList().iterator(), true);
                return;
            }
            catch (Exception e) {
                throw new RuntimeException("unexpected validation failure", e);
            }
        }
        Assertions.assertEquals((Object)expectedExceptionText, (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> validator.validateTopicConfigChange(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanup.policy"), (Object)prevCleanupPolicy)}))).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanup.policy"), (Object)newCleanupPolicy), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.tier.cleaner.enable"), (Object)Boolean.toString(tierCleanerFeatureEnabled))}))).asJava(), new ArrayList().iterator(), true)).getMessage());
    }

    @Test
    public void testValidateTopicConfigChangeCompactionStatus() {
        ControllerConfigurationValidator noTiering = new ControllerConfigurationValidator(new KafkaConfig((java.util.Map)this.createBrokerConfig(false, false, false, false)), this.latestMetadataVersionSupplier());
        this.verifyLogConfigChange(noTiering, "compact", "compact", false, "");
        this.verifyLogConfigChange(noTiering, "compact", "delete", false, "");
        this.verifyLogConfigChange(noTiering, "compact", "compact,delete", false, "");
        this.verifyLogConfigChange(noTiering, "delete", "compact", false, "");
        this.verifyLogConfigChange(noTiering, "delete", "delete", false, "");
        this.verifyLogConfigChange(noTiering, "delete", "compact,delete", false, "");
        this.verifyLogConfigChange(noTiering, "compact,delete", "compact", false, "");
        this.verifyLogConfigChange(noTiering, "compact,delete", "delete", false, "");
        this.verifyLogConfigChange(noTiering, "compact,delete", "compact,delete", false, "");
        ControllerConfigurationValidator noCleaner = new ControllerConfigurationValidator(new KafkaConfig((java.util.Map)this.createBrokerConfig(true, false, false, false)), this.latestMetadataVersionSupplier());
        this.verifyLogConfigChange(noCleaner, "compact", "compact", false, "");
        this.verifyLogConfigChange(noCleaner, "compact", "delete", false, "");
        this.verifyLogConfigChange(noCleaner, "compact", "compact,delete", false, "");
        this.verifyLogConfigChange(noCleaner, "delete", "compact", false, "Altering topic configuration from `delete` to `compact` is not currently supported. Please create a new topic with `compact` policy specified instead.");
        this.verifyLogConfigChange(noCleaner, "delete", "delete", false, "");
        this.verifyLogConfigChange(noCleaner, "delete", "compact,delete", false, "Altering topic configuration from `delete` to `compact` is not currently supported. Please create a new topic with `compact` policy specified instead.");
        this.verifyLogConfigChange(noCleaner, "compact,delete", "compact", false, "");
        this.verifyLogConfigChange(noCleaner, "compact,delete", "delete", false, "");
        this.verifyLogConfigChange(noCleaner, "compact,delete", "compact,delete", false, "");
        ControllerConfigurationValidator latest = new ControllerConfigurationValidator(new KafkaConfig((java.util.Map)this.createBrokerConfig(true, true, false, false)), this.latestMetadataVersionSupplier());
        this.verifyLogConfigChange(latest, "compact", "compact", true, "");
        this.verifyLogConfigChange(latest, "compact", "delete", true, "");
        this.verifyLogConfigChange(latest, "compact", "compact,delete", true, "");
        this.verifyLogConfigChange(latest, "delete", "compact", true, "");
        this.verifyLogConfigChange(latest, "delete", "delete", true, "");
        this.verifyLogConfigChange(latest, "delete", "compact,delete", true, "Altering topic configuration from `delete` to `compact` and `delete` is not currently supported. Please set `cleanup.policy` to either `delete` or `compact`.");
        this.verifyLogConfigChange(latest, "compact,delete", "compact", true, "");
        this.verifyLogConfigChange(latest, "compact,delete", "delete", true, "");
        this.verifyLogConfigChange(latest, "compact,delete", "compact,delete", true, "");
    }

    @Test
    public void testTopicPlacementChangesSuccessNewConfig() {
        String placementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                          |  \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 1,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack0\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 1,\n                          |    \"constraints\": {\n                          |      \"rack\": \"rack0\"\n                          |    }\n                          |  }]\n                          |}"));
        ControllerConfigurationValidator validator = new ControllerConfigurationValidator(new KafkaConfig((java.util.Map)this.createBrokerConfig()), this.latestMetadataVersionSupplier());
        TreeMap prevConfig = new TreeMap();
        java.util.Map newConfig = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.placement.constraints"), (Object)placementJson)}))).asJava();
        .colon.colon brokers = new .colon.colon((Object)new UsableBroker(0, Optional.of("rack0"), false), (List)new .colon.colon((Object)new UsableBroker(1, Optional.of("rack0"), false), (List)Nil$.MODULE$));
        validator.validateTopicConfigChange(prevConfig, newConfig, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava().iterator(), true);
    }

    @Test
    public void testTopicPlacementChangesSuccessUpdateConfig() {
        String prevPlacementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                          |  \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 1,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack0\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 1,\n                          |    \"constraints\": {\n                          |      \"rack\": \"rack0\"\n                          |    }\n                          |  }]\n                          |}"));
        String newPlacementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                          |  \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 1,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack1\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 1,\n                          |    \"constraints\": {\n                          |      \"rack\": \"rack1\"\n                          |    }\n                          |  }]\n                          |}"));
        ControllerConfigurationValidator validator = new ControllerConfigurationValidator(new KafkaConfig((java.util.Map)this.createBrokerConfig()), this.latestMetadataVersionSupplier());
        java.util.Map prevConfig = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.placement.constraints"), (Object)prevPlacementJson)}))).asJava();
        java.util.Map newConfig = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.placement.constraints"), (Object)newPlacementJson)}))).asJava();
        .colon.colon brokers = new .colon.colon((Object)new UsableBroker(0, Optional.of("rack0"), false), (List)new .colon.colon((Object)new UsableBroker(1, Optional.of("rack0"), false), (List)new .colon.colon((Object)new UsableBroker(0, Optional.of("rack1"), false), (List)new .colon.colon((Object)new UsableBroker(1, Optional.of("rack1"), false), (List)Nil$.MODULE$))));
        validator.validateTopicConfigChange(prevConfig, newConfig, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava().iterator(), true);
    }

    @Test
    public void testTopicPlacementChangesSuccessNoChange() {
        String placementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                          |  \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 1,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack0\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 1,\n                          |    \"constraints\": {\n                          |      \"rack\": \"rack0\"\n                          |    }\n                          |  }]\n                          |}"));
        ControllerConfigurationValidator validator = new ControllerConfigurationValidator(new KafkaConfig((java.util.Map)this.createBrokerConfig()), this.latestMetadataVersionSupplier());
        java.util.Map prevConfig = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.placement.constraints"), (Object)placementJson)}))).asJava();
        java.util.Map newConfig = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.placement.constraints"), (Object)placementJson)}))).asJava();
        .colon.colon brokers = new .colon.colon((Object)new UsableBroker(0, Optional.of("rack0"), false), (List)new .colon.colon((Object)new UsableBroker(1, Optional.of("rack0"), false), (List)Nil$.MODULE$));
        validator.validateTopicConfigChange(prevConfig, newConfig, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava().iterator(), true);
    }

    @Test
    public void testTopicPlacementChangesSuccessRemovePlacement() {
        String placementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                          |  \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 1,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack0\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 1,\n                          |    \"constraints\": {\n                          |      \"rack\": \"rack0\"\n                          |    }\n                          |  }]\n                          |}"));
        ControllerConfigurationValidator validator = new ControllerConfigurationValidator(new KafkaConfig((java.util.Map)this.createBrokerConfig()), this.latestMetadataVersionSupplier());
        java.util.Map prevConfig = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.placement.constraints"), (Object)placementJson)}))).asJava();
        .colon.colon brokers = new .colon.colon((Object)new UsableBroker(0, Optional.of("rack0"), false), (List)new .colon.colon((Object)new UsableBroker(1, Optional.of("rack0"), false), (List)Nil$.MODULE$));
        java.util.Map newConfig = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.placement.constraints"), (Object)"")}))).asJava();
        validator.validateTopicConfigChange(prevConfig, newConfig, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava().iterator(), true);
        TreeMap emptyConfig = new TreeMap();
        validator.validateTopicConfigChange(prevConfig, emptyConfig, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava().iterator(), true);
    }

    @Test
    public void testTopicPlacementChangesInvalidJson() {
        String placementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                          |  \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 1,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack0\"\n                          |  }]\n                          |}"));
        ControllerConfigurationValidator validator = new ControllerConfigurationValidator(new KafkaConfig((java.util.Map)this.createBrokerConfig()), this.latestMetadataVersionSupplier());
        TreeMap prevConfig = new TreeMap();
        java.util.Map newConfig = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.placement.constraints"), (Object)placementJson)}))).asJava();
        .colon.colon brokers = new .colon.colon((Object)new UsableBroker(0, Optional.of("rack0"), false), (List)new .colon.colon((Object)new UsableBroker(1, Optional.of("rack0"), false), (List)Nil$.MODULE$));
        ConfigException throwable = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> ControllerConfigurationValidatorTest.$anonfun$testTopicPlacementChangesInvalidJson$1(validator, prevConfig, newConfig, (scala.collection.immutable.Seq)brokers));
        Assertions.assertEquals((Object)new StringBuilder(113).append("Invalid value ").append(placementJson).append(" for configuration confluent.placement.constraints: Exception while parsing placement configuration").toString(), (Object)throwable.getMessage());
    }

    @Test
    public void testNewTopicPlacementConfigButNotSupported() {
        String placementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                          |  \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 1,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack0\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 1,\n                          |    \"constraints\": {\n                          |      \"rack\": \"rack0\"\n                          |    }\n                          |  }]\n                          |}"));
        ControllerConfigurationValidator validator = new ControllerConfigurationValidator(new KafkaConfig((java.util.Map)this.createBrokerConfig()), this.latestMetadataVersionSupplier());
        TreeMap prevConfig = new TreeMap();
        java.util.Map newConfig = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.placement.constraints"), (Object)placementJson)}))).asJava();
        .colon.colon brokers = new .colon.colon((Object)new UsableBroker(0, Optional.of("rack0"), false), (List)new .colon.colon((Object)new UsableBroker(1, Optional.of("rack0"), false), (List)Nil$.MODULE$));
        InvalidConfigurationException throwable = (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> ControllerConfigurationValidatorTest.$anonfun$testNewTopicPlacementConfigButNotSupported$1(validator, prevConfig, newConfig, (scala.collection.immutable.Seq)brokers));
        Assertions.assertEquals((Object)"Topic placement is not supported.", (Object)throwable.getMessage());
    }

    @Test
    public void testDeleteTopicPlacementConfigAcceptedEvenIfNotSupported() {
        String placementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                          |  \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 1,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack0\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 1,\n                          |    \"constraints\": {\n                          |      \"rack\": \"rack0\"\n                          |    }\n                          |  }]\n                          |}"));
        ControllerConfigurationValidator validator = new ControllerConfigurationValidator(new KafkaConfig((java.util.Map)this.createBrokerConfig()), this.latestMetadataVersionSupplier());
        java.util.Map prevConfig = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.placement.constraints"), (Object)placementJson)}))).asJava();
        TreeMap newConfig = new TreeMap();
        .colon.colon brokers = new .colon.colon((Object)new UsableBroker(0, Optional.of("rack0"), false), (List)new .colon.colon((Object)new UsableBroker(1, Optional.of("rack0"), false), (List)Nil$.MODULE$));
        validator.validateTopicConfigChange(prevConfig, newConfig, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava().iterator(), false);
    }

    @ParameterizedTest
    @CsvSource(value={"false,false,false", "true,false,false", "false,false,true", "true,false,true"})
    public void testTopicTypeConfig(boolean partitionGroupSupportedViaStaticConfig, boolean metadataDataVersionSupportsPartitionGroups, boolean nominalTopicsEnabledViaStaticConfig) {
        Supplier<MetadataVersion> metadataVersionSupplier = metadataDataVersionSupportsPartitionGroups ? this.latestMetadataVersionSupplier() : () -> MetadataVersion.IBP_3_6_IV2;
        ControllerConfigurationValidator validator = new ControllerConfigurationValidator(new KafkaConfig((java.util.Map)this.createBrokerConfig(false, false, partitionGroupSupportedViaStaticConfig, nominalTopicsEnabledViaStaticConfig)), metadataVersionSupplier);
        java.util.Map configStandard = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.topic.type"), (Object)"standard")}))).asJava();
        java.util.Map configKirkland = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.topic.type"), (Object)"k2")}))).asJava();
        java.util.Map configNominal = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.topic.type"), (Object)"nominal")}))).asJava();
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, "topicName");
        validator.validate(topicResource, configStandard);
        if (partitionGroupSupportedViaStaticConfig && metadataDataVersionSupportsPartitionGroups) {
            validator.validate(topicResource, configKirkland);
        } else {
            ConfigException throwable = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> validator.validate(topicResource, configKirkland));
            Assertions.assertEquals((Object)"Topic type k2 is not supported", (Object)throwable.getMessage());
        }
        if (nominalTopicsEnabledViaStaticConfig) {
            validator.validate(topicResource, configNominal);
            return;
        }
        ConfigException throwable = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> validator.validate(topicResource, configNominal));
        Assertions.assertEquals((Object)"Topic type nominal is not supported", (Object)throwable.getMessage());
    }

    @ParameterizedTest
    @CsvSource(value={"false,false,false", "true,false,false", "false,false,true", "true,false,true"})
    public void testTopicTypeConfigChange(boolean partitionGroupSupportedViaStaticConfig, boolean metadataDataVersionSupportsPartitionGroups, boolean nominalTopicsEnabledViaStaticConfig) {
        Supplier<MetadataVersion> metadataVersionSupplier = metadataDataVersionSupportsPartitionGroups ? this.latestMetadataVersionSupplier() : () -> MetadataVersion.IBP_3_6_IV2;
        ControllerConfigurationValidator validator = new ControllerConfigurationValidator(new KafkaConfig((java.util.Map)this.createBrokerConfig(false, false, partitionGroupSupportedViaStaticConfig, nominalTopicsEnabledViaStaticConfig)), metadataVersionSupplier);
        TreeMap configEmpty = new TreeMap();
        java.util.Map configExplicitStandard = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.topic.type"), (Object)"standard")}))).asJava();
        java.util.Map configExplicitK2 = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.topic.type"), (Object)"k2")}))).asJava();
        java.util.Map configExplicitNominal = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.topic.type"), (Object)"nominal")}))).asJava();
        .colon.colon brokers = new .colon.colon((Object)new UsableBroker(0, Optional.of("rack0"), false), (List)new .colon.colon((Object)new UsableBroker(1, Optional.of("rack0"), false), (List)Nil$.MODULE$));
        validator.validateTopicConfigChange(configEmpty, configEmpty, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava().iterator(), false);
        validator.validateTopicConfigChange(configEmpty, configExplicitStandard, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava().iterator(), false);
        validator.validateTopicConfigChange(configExplicitStandard, configExplicitStandard, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava().iterator(), false);
        validator.validateTopicConfigChange(configExplicitStandard, configEmpty, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava().iterator(), false);
        String expectedMessageDisallowingChangeFromStandardToK2 = "Altering topic type from `standard` to `k2` is not supported.";
        InvalidConfigurationException throwable = (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> ControllerConfigurationValidatorTest.$anonfun$testTopicTypeConfigChange$2(validator, configEmpty, configExplicitK2, (scala.collection.immutable.Seq)brokers));
        Assertions.assertEquals((Object)expectedMessageDisallowingChangeFromStandardToK2, (Object)throwable.getMessage());
        throwable = (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> ControllerConfigurationValidatorTest.$anonfun$testTopicTypeConfigChange$3(validator, configExplicitStandard, configExplicitK2, (scala.collection.immutable.Seq)brokers));
        Assertions.assertEquals((Object)expectedMessageDisallowingChangeFromStandardToK2, (Object)throwable.getMessage());
        String expectedMessageDisallowingChangeFromK2ToStandard = "Altering topic type from `k2` to `standard` is not supported.";
        throwable = (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> ControllerConfigurationValidatorTest.$anonfun$testTopicTypeConfigChange$4(validator, configExplicitK2, configEmpty, (scala.collection.immutable.Seq)brokers));
        Assertions.assertEquals((Object)expectedMessageDisallowingChangeFromK2ToStandard, (Object)throwable.getMessage());
        throwable = (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> ControllerConfigurationValidatorTest.$anonfun$testTopicTypeConfigChange$5(validator, configExplicitK2, configExplicitStandard, (scala.collection.immutable.Seq)brokers));
        Assertions.assertEquals((Object)expectedMessageDisallowingChangeFromK2ToStandard, (Object)throwable.getMessage());
        String expectedMessageDisallowingChangeFromStandardToNominal = "Altering topic type from `standard` to `nominal` is not supported.";
        throwable = (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> ControllerConfigurationValidatorTest.$anonfun$testTopicTypeConfigChange$6(validator, configEmpty, configExplicitNominal, (scala.collection.immutable.Seq)brokers));
        Assertions.assertEquals((Object)expectedMessageDisallowingChangeFromStandardToNominal, (Object)throwable.getMessage());
        throwable = (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> ControllerConfigurationValidatorTest.$anonfun$testTopicTypeConfigChange$7(validator, configExplicitStandard, configExplicitNominal, (scala.collection.immutable.Seq)brokers));
        Assertions.assertEquals((Object)expectedMessageDisallowingChangeFromStandardToNominal, (Object)throwable.getMessage());
        String expectedMessageDisallowingChangeFromNominalToStandard = "Altering topic type from `nominal` to `standard` is not supported.";
        throwable = (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> ControllerConfigurationValidatorTest.$anonfun$testTopicTypeConfigChange$8(validator, configExplicitNominal, configEmpty, (scala.collection.immutable.Seq)brokers));
        Assertions.assertEquals((Object)expectedMessageDisallowingChangeFromNominalToStandard, (Object)throwable.getMessage());
        throwable = (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> ControllerConfigurationValidatorTest.$anonfun$testTopicTypeConfigChange$9(validator, configExplicitNominal, configExplicitStandard, (scala.collection.immutable.Seq)brokers));
        Assertions.assertEquals((Object)expectedMessageDisallowingChangeFromNominalToStandard, (Object)throwable.getMessage());
        String expectedMessageDisallowingChangeFromK2ToNominal = "Altering topic type from `k2` to `nominal` is not supported.";
        throwable = (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> ControllerConfigurationValidatorTest.$anonfun$testTopicTypeConfigChange$10(validator, configExplicitK2, configExplicitNominal, (scala.collection.immutable.Seq)brokers));
        Assertions.assertEquals((Object)expectedMessageDisallowingChangeFromK2ToNominal, (Object)throwable.getMessage());
        String expectedMessageDisallowingChangeFromNominalToK2 = "Altering topic type from `nominal` to `k2` is not supported.";
        throwable = (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> ControllerConfigurationValidatorTest.$anonfun$testTopicTypeConfigChange$11(validator, configExplicitNominal, configExplicitK2, (scala.collection.immutable.Seq)brokers));
        Assertions.assertEquals((Object)expectedMessageDisallowingChangeFromNominalToK2, (Object)throwable.getMessage());
    }

    private Properties createBrokerConfig() {
        return this.createBrokerConfig(false, false, false, false);
    }

    private Properties createBrokerConfig(boolean tierFeature, boolean tierCleanerFeature, boolean partitionGroupSupportedViaStaticConfig, boolean nominalTopicCreationEnabledViaStaticConfig) {
        Properties config = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        config.put(KafkaConfig$.MODULE$.TierFeatureProp(), Boolean.toString(tierFeature));
        config.put(KafkaConfig$.MODULE$.TierCleanerFeatureEnableProp(), Boolean.toString(tierCleanerFeature));
        config.put(KafkaConfig$.MODULE$.K2TopicCreationEnabledProp(), Boolean.toString(partitionGroupSupportedViaStaticConfig));
        config.put(KafkaConfig$.MODULE$.NominalTopicCreationEnabledProp(), Boolean.toString(nominalTopicCreationEnabledViaStaticConfig));
        return config;
    }

    private boolean createBrokerConfig$default$3() {
        return false;
    }

    private boolean createBrokerConfig$default$4() {
        return false;
    }

    @Test
    public void testValidClientMetricsConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("interval.ms", "2000");
        config.put("metrics", "org.apache.kafka.client.producer.partition.queue.,org.apache.kafka.client.producer.partition.latency");
        config.put("match", "client_instance_id=b69cc35a-7a54-4790-aa69-cc2bd4ee4538,client_id=1,client_software_name=apache-kafka-java,client_software_version=2.8.0-SNAPSHOT,client_source_address=127.0.0.1,client_source_port=1234");
        this.validator().validate(new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "subscription-1"), config);
    }

    @Test
    public void testInvalidSubscriptionNameClientMetricsConfig() {
        TreeMap config = new TreeMap();
        Assertions.assertEquals((Object)"Subscription name can't be empty", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.CLIENT_METRICS, ""), (java.util.Map)config)).getMessage());
    }

    @Test
    public void testInvalidIntervalClientMetricsConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("interval.ms", "10");
        Assertions.assertEquals((Object)"Invalid value 10 for interval.ms, interval must be between 100 and 3600000 (1 hour)", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "subscription-1"), (java.util.Map)config)).getMessage());
        config.put("interval.ms", "3600001");
        Assertions.assertEquals((Object)"Invalid value 3600001 for interval.ms, interval must be between 100 and 3600000 (1 hour)", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "subscription-1"), (java.util.Map)config)).getMessage());
    }

    @Test
    public void testUndefinedConfigClientMetricsConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("random", "10");
        Assertions.assertEquals((Object)"Unknown client metrics configuration: random", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "subscription-1"), (java.util.Map)config)).getMessage());
    }

    @Test
    public void testInvalidMatchClientMetricsConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("match", "10");
        Assertions.assertEquals((Object)"Illegal client matching pattern: 10", (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "subscription-1"), (java.util.Map)config)).getMessage());
    }

    public static final /* synthetic */ void $anonfun$testTopicPlacementChangesInvalidJson$1(ControllerConfigurationValidator validator$2, TreeMap prevConfig$1, java.util.Map newConfig$1, scala.collection.immutable.Seq brokers$1) {
        validator$2.validateTopicConfigChange((java.util.Map)prevConfig$1, newConfig$1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers$1).asJava().iterator(), true);
    }

    public static final /* synthetic */ void $anonfun$testNewTopicPlacementConfigButNotSupported$1(ControllerConfigurationValidator validator$3, TreeMap prevConfig$2, java.util.Map newConfig$2, scala.collection.immutable.Seq brokers$2) {
        validator$3.validateTopicConfigChange((java.util.Map)prevConfig$2, newConfig$2, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers$2).asJava().iterator(), false);
    }

    public static final /* synthetic */ void $anonfun$testTopicTypeConfigChange$2(ControllerConfigurationValidator validator$5, TreeMap configEmpty$1, java.util.Map configExplicitK2$1, scala.collection.immutable.Seq brokers$3) {
        validator$5.validateTopicConfigChange((java.util.Map)configEmpty$1, configExplicitK2$1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers$3).asJava().iterator(), false);
    }

    public static final /* synthetic */ void $anonfun$testTopicTypeConfigChange$3(ControllerConfigurationValidator validator$5, java.util.Map configExplicitStandard$1, java.util.Map configExplicitK2$1, scala.collection.immutable.Seq brokers$3) {
        validator$5.validateTopicConfigChange(configExplicitStandard$1, configExplicitK2$1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers$3).asJava().iterator(), false);
    }

    public static final /* synthetic */ void $anonfun$testTopicTypeConfigChange$4(ControllerConfigurationValidator validator$5, java.util.Map configExplicitK2$1, TreeMap configEmpty$1, scala.collection.immutable.Seq brokers$3) {
        validator$5.validateTopicConfigChange(configExplicitK2$1, (java.util.Map)configEmpty$1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers$3).asJava().iterator(), false);
    }

    public static final /* synthetic */ void $anonfun$testTopicTypeConfigChange$5(ControllerConfigurationValidator validator$5, java.util.Map configExplicitK2$1, java.util.Map configExplicitStandard$1, scala.collection.immutable.Seq brokers$3) {
        validator$5.validateTopicConfigChange(configExplicitK2$1, configExplicitStandard$1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers$3).asJava().iterator(), false);
    }

    public static final /* synthetic */ void $anonfun$testTopicTypeConfigChange$6(ControllerConfigurationValidator validator$5, TreeMap configEmpty$1, java.util.Map configExplicitNominal$1, scala.collection.immutable.Seq brokers$3) {
        validator$5.validateTopicConfigChange((java.util.Map)configEmpty$1, configExplicitNominal$1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers$3).asJava().iterator(), false);
    }

    public static final /* synthetic */ void $anonfun$testTopicTypeConfigChange$7(ControllerConfigurationValidator validator$5, java.util.Map configExplicitStandard$1, java.util.Map configExplicitNominal$1, scala.collection.immutable.Seq brokers$3) {
        validator$5.validateTopicConfigChange(configExplicitStandard$1, configExplicitNominal$1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers$3).asJava().iterator(), false);
    }

    public static final /* synthetic */ void $anonfun$testTopicTypeConfigChange$8(ControllerConfigurationValidator validator$5, java.util.Map configExplicitNominal$1, TreeMap configEmpty$1, scala.collection.immutable.Seq brokers$3) {
        validator$5.validateTopicConfigChange(configExplicitNominal$1, (java.util.Map)configEmpty$1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers$3).asJava().iterator(), false);
    }

    public static final /* synthetic */ void $anonfun$testTopicTypeConfigChange$9(ControllerConfigurationValidator validator$5, java.util.Map configExplicitNominal$1, java.util.Map configExplicitStandard$1, scala.collection.immutable.Seq brokers$3) {
        validator$5.validateTopicConfigChange(configExplicitNominal$1, configExplicitStandard$1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers$3).asJava().iterator(), false);
    }

    public static final /* synthetic */ void $anonfun$testTopicTypeConfigChange$10(ControllerConfigurationValidator validator$5, java.util.Map configExplicitK2$1, java.util.Map configExplicitNominal$1, scala.collection.immutable.Seq brokers$3) {
        validator$5.validateTopicConfigChange(configExplicitK2$1, configExplicitNominal$1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers$3).asJava().iterator(), false);
    }

    public static final /* synthetic */ void $anonfun$testTopicTypeConfigChange$11(ControllerConfigurationValidator validator$5, java.util.Map configExplicitNominal$1, java.util.Map configExplicitK2$1, scala.collection.immutable.Seq brokers$3) {
        validator$5.validateTopicConfigChange(configExplicitNominal$1, configExplicitK2$1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers$3).asJava().iterator(), false);
    }
}

