/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.zk.ZkVersion$;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005Q3A!\u0002\u0004\u0001\u0017!)!\u0003\u0001C\u0001'!)a\u0003\u0001C\u0001/!)!\u0007\u0001C\u0001g!)\u0001\u000b\u0001C\u0001g\t12i\u001c8ue>dG.\u001a:JI6+GO]5d)\u0016\u001cHO\u0003\u0002\b\u0011\u000511/\u001a:wKJT\u0011!C\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e!5\taB\u0003\u0002\u0010\u0011\u0005Y\u0011N\u001c;fOJ\fG/[8o\u0013\t\tbB\u0001\fLC\u001a\\\u0017mU3sm\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\tA\u0003\u0005\u0002\u0016\u00015\ta!A\bhK:,'/\u0019;f\u0007>tg-[4t+\u0005A\u0002cA\r$M9\u0011!\u0004\t\b\u00037yi\u0011\u0001\b\u0006\u0003;)\ta\u0001\u0010:p_Rt\u0014\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005\u0012\u0013a\u00029bG.\fw-\u001a\u0006\u0002?%\u0011A%\n\u0002\u0004'\u0016\f(BA\u0011#!\t)r%\u0003\u0002)\r\tY1*\u00194lC\u000e{gNZ5hQ\t\u0011!\u0006\u0005\u0002,a5\tAF\u0003\u0002.]\u0005!A.\u00198h\u0015\u0005y\u0013\u0001\u00026bm\u0006L!!\r\u0017\u0003\u0011=3XM\u001d:jI\u0016\f!\u0003^3tij[7i\u001c8ue>dG.\u001a:JIR\tA\u0007\u0005\u00026m5\t!%\u0003\u00028E\t!QK\\5uQ\t\u0019\u0011\b\u0005\u0002;\u00076\t1H\u0003\u0002={\u00051\u0001/\u0019:b[NT!AP \u0002\u000f),\b/\u001b;fe*\u0011\u0001)Q\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0005\u0006\u0019qN]4\n\u0005\u0011[$!\u0005)be\u0006lW\r^3sSj,G\rV3ti\"\"1A\u0012'N!\t9%*D\u0001I\u0015\tI5(\u0001\u0005qe>4\u0018\u000eZ3s\u0013\tY\u0005JA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0002\u001d\u0006\nq*\u0001\u0002{W\u0006!C/Z:u5.\u001cuN\u001c;s_2dWM]%e/\",gN\u00178pI\u0016L5\u000fR3mKR,G\r\u000b\u0002\u0005s!\"AA\u0012'TY\u0005q\u0005")
public class ControllerIdMetricTest
extends KafkaServerTestHarness {
    public Seq<KafkaConfig> generateConfigs() {
        return ((IterableOnceOps)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnectOrNull(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1))).toSeq();
    }

    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testZkControllerId() {
        KafkaServer server = (KafkaServer)this.servers().head();
        long retry_maxWaitMs = 30000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ControllerIdMetricTest.$anonfun$testZkControllerId$1(server);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var8_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testZkControllerIdWhenZnodeIsDeleted() {
        KafkaServer server = (KafkaServer)this.servers().head();
        long retry_maxWaitMs = 30000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ControllerIdMetricTest.$anonfun$testZkControllerIdWhenZnodeIsDeleted$1(this, server);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var8_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testZkControllerId$1(KafkaServer server$1) {
        Assertions.assertEquals((int)server$1.config().brokerId(), (int)server$1.getCurrentControllerIdFromOldController());
    }

    public static final /* synthetic */ void $anonfun$testZkControllerIdWhenZnodeIsDeleted$1(ControllerIdMetricTest $this, KafkaServer server$2) {
        $this.zkClient().deleteController(ZkVersion$.MODULE$.MatchAnyVersion());
        Assertions.assertEquals((int)-1, (int)server$2.getCurrentControllerIdFromOldController());
    }
}

