/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import kafka.cluster.EndPoint;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.testkit.KafkaClusterTestKit;
import kafka.testkit.TestKitNodes;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.metrics.Metrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Function1;
import scala.Predef$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@Timeout(value=120L)
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005I2Aa\u0001\u0003\u0001\u0013!)\u0001\u0003\u0001C\u0001#!)A\u0003\u0001C\u0001+\t)4I]3bi\u0016$v\u000e]5d/&$\bn\\;u!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u\u0003\u001a$XM]*oCB\u001c\bn\u001c;M_\u0006$G+Z:u\u0015\t)a!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000f\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u000b!\tYa\"D\u0001\r\u0015\u0005i\u0011!B:dC2\f\u0017BA\b\r\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u0005\t\u0003'\u0001i\u0011\u0001B\u0001*i\u0016\u001cHo\u0011:fCR,7\t\\;ti\u0016\u0014\u0018I\u001c3SKN$\u0018M\u001d;D_:$(o\u001c7mKJtu\u000eZ3\u0015\u0003Y\u0001\"aC\f\n\u0005aa!\u0001B+oSRD#A\u0001\u000e\u0011\u0005m!S\"\u0001\u000f\u000b\u0005uq\u0012aA1qS*\u0011q\u0004I\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\t#%A\u0003kk:LGOC\u0001$\u0003\ry'oZ\u0005\u0003Kq\u0011A\u0001V3ti\"\"\u0001a\n\u0016,!\tY\u0002&\u0003\u0002*9\t9A+[7f_V$\u0018!\u0002<bYV,g$\u0001=)\t\u0001i#\u0006\r\t\u000379J!a\f\u000f\u0003\u0007Q\u000bw-I\u00012\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8")
public class CreateTopicWithoutPartitionCountAfterSnapshotLoadTest {
    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndRestartControllerNode() {
        int expectedNumberOfPartitions = 2;
        KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).setConfigProp("metadata.log.max.snapshot.interval.ms", "50").setConfigProp("num.partitions", Integer.toString(expectedNumberOfPartitions)).build();
        Admin admin = null;
        try {
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            ControllerServer controller = cluster.controllers().values().iterator().next();
            BrokerServer broker = cluster.brokers().values().iterator().next();
            int port = controller.socketServer().boundPort(((EndPoint)controller.config().controllerListeners().head()).listenerName());
            admin = Admin.create((Properties)cluster.clientProperties());
            Optional noExplicitNumPartitions = Optional.empty();
            Optional<Short> replicationFactor1 = Optional.of(Predef$.MODULE$.short2Short((short)1));
            String firstTopicName = "first-test-topic";
            List<NewTopic> newTopic = Collections.singletonList(new NewTopic(firstTopicName, noExplicitNumPartitions, replicationFactor1));
            CreateTopicsResult createTopicResult = admin.createTopics(newTopic);
            Assertions.assertEquals((int)expectedNumberOfPartitions, (Integer)((Integer)createTopicResult.numPartitions(firstTopicName).get()));
            admin.close();
            admin = null;
            Path metaLog = FileSystems.getDefault().getPath(cluster.controllers().get(BoxesRunTime.boxToInteger((int)3000)).config().metadataLogDir(), "__cluster_metadata-0");
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!CreateTopicWithoutPartitionCountAfterSnapshotLoadTest.$anonfun$testCreateClusterAndRestartControllerNode$2(metaLog)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Failed to see at least one snapshot");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            broker.shutdown();
            controller.shutdown();
            HashMap config = new HashMap();
            controller.sharedServer().controllerConfig().props().entrySet().forEach(entry -> {
                if (KafkaConfig$.MODULE$.ListenersProp().equals(entry.getKey())) {
                    config.put(KafkaConfig$.MODULE$.ListenersProp(), new StringBuilder(23).append("CONTROLLER://localhost:").append(port).toString());
                    return;
                }
                config.put(entry.getKey(), entry.getValue());
            });
            controller.sharedServer().controllerConfig().updateCurrentConfig(new KafkaConfig(config));
            controller.sharedServer().metrics_$eq(new Metrics());
            controller.startup();
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!CreateTopicWithoutPartitionCountAfterSnapshotLoadTest.$anonfun$testCreateClusterAndRestartControllerNode$5(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"Timeout waiting for new controller election");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            broker.startup();
            cluster.waitForReadyBrokers();
            admin = Admin.create((Properties)cluster.clientProperties());
            String secondTopicName = "second-test-topic";
            newTopic = Collections.singletonList(new NewTopic(secondTopicName, noExplicitNumPartitions, replicationFactor1));
            createTopicResult = admin.createTopics(newTopic);
            Assertions.assertEquals((int)expectedNumberOfPartitions, (Integer)((Integer)createTopicResult.numPartitions(secondTopicName).get()));
        }
        catch (Throwable throwable) {
            if (admin != null) {
                admin.close();
            }
            cluster.close();
            throw throwable;
        }
        admin.close();
        cluster.close();
    }

    private static final long snapshotCounter$1(Path path) {
        return path.toFile().listFiles((x$1, name) -> name.toLowerCase().endsWith("checkpoint")).length;
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndRestartControllerNode$2(Path metaLog$1) {
        return CreateTopicWithoutPartitionCountAfterSnapshotLoadTest.snapshotCounter$1(metaLog$1) > 0L;
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndRestartControllerNode$3() {
        return "Failed to see at least one snapshot";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndRestartControllerNode$6(ControllerServer x$2) {
        return x$2.controller().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndRestartControllerNode$5(KafkaClusterTestKit cluster$1) {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(cluster$1.controllers().values().iterator()).asScala().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CreateTopicWithoutPartitionCountAfterSnapshotLoadTest.$anonfun$testCreateClusterAndRestartControllerNode$6(x$2)));
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndRestartControllerNode$7() {
        return "Timeout waiting for new controller election";
    }
}

