/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import kafka.cluster.DefaultPartitionListener;
import kafka.cluster.Partition;
import kafka.log.MergedLog$;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedFetch;
import kafka.server.FullPartitionFetchMetadata;
import kafka.server.IncrementalPartitionFetchMetadata;
import kafka.server.LogReadResult;
import kafka.server.PartitionFetchMetadata;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.TierLogReadResult;
import kafka.tier.fetcher.PendingFetch;
import kafka.tier.fetcher.ReclaimableMemoryRecords;
import kafka.tier.fetcher.TierFetchDataInfo;
import kafka.tier.fetcher.TierFetchResult;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.AbstractFetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.FetchParams;
import org.apache.kafka.storage.internals.log.FetchPartitionData;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogOffsetSnapshot;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.MapOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\rb\u0001\u0002\u0012$\u0001!BQa\f\u0001\u0005\u0002ABqa\r\u0001C\u0002\u0013%A\u0007\u0003\u00049\u0001\u0001\u0006I!\u000e\u0005\bs\u0001\u0011\r\u0011\"\u0003;\u0011\u00199\u0005\u0001)A\u0005w!9\u0001\n\u0001b\u0001\n\u0013I\u0005BB'\u0001A\u0003%!\nC\u0004O\u0001\t\u0007I\u0011B(\t\rM\u0003\u0001\u0015!\u0003Q\u0011%!\u0006\u00011AA\u0002\u0013%Q\u000bC\u0005Z\u0001\u0001\u0007\t\u0019!C\u00055\"I\u0001\r\u0001a\u0001\u0002\u0003\u0006KA\u0016\u0005\u0006C\u0002!\tA\u0019\u0005\u0006]\u0002!\tA\u0019\u0005\u0006g\u0002!\tA\u0019\u0005\u0006q\u0002!\tA\u0019\u0005\u0006u\u0002!\tA\u0019\u0005\u0006y\u0002!\tA\u0019\u0005\u0006}\u0002!\tA\u0019\u0005\u0007\u0003\u0003\u0001A\u0011\u00012\t\r\u0005\u0015\u0001\u0001\"\u0001c\u0011\u0019\tI\u0001\u0001C\u0001E\"1\u0011Q\u0002\u0001\u0005\u0002\tDa!!\u0005\u0001\t\u0003\u0011\u0007BBA\u000b\u0001\u0011\u0005!\r\u0003\u0004\u0002\u001a\u0001!\tA\u0019\u0005\b\u0003;\u0001A\u0011BA\u0010\u0011\u001d\ti\u0004\u0001C\u0005\u0003\u007fAq!a\u001c\u0001\t\u0013\t\t\bC\u0004\u0002|\u0001!I!! \t\u0013\u0005]\u0007!%A\u0005\n\u0005e\u0007bBAx\u0001\u0011%\u0011\u0011\u001f\u0005\b\u0005#\u0001A\u0011\u0002B\n\u0005A!U\r\\1zK\u00124U\r^2i)\u0016\u001cHO\u0003\u0002%K\u000511/\u001a:wKJT\u0011AJ\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0006\u0005\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3F\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0002\"A\r\u0001\u000e\u0003\r\n\u0001\"\\1y\u0005f$Xm]\u000b\u0002kA\u0011!FN\u0005\u0003o-\u00121!\u00138u\u0003%i\u0017\r\u001f\"zi\u0016\u001c\b%\u0001\u0005n_\u000e\\G+[7f+\u0005Y\u0004C\u0001\u001fF\u001b\u0005i$B\u0001 @\u0003\u0011)H/\u001b7\u000b\u0005\u0011\u0002%B\u0001\u0014B\u0015\t\u00115)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\t\u0006\u0019qN]4\n\u0005\u0019k$\u0001C'pG.$\u0016.\\3\u0002\u00135|7m\u001b+j[\u0016\u0004\u0013A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0002\u0015B\u0011!gS\u0005\u0003\u0019\u000e\u0012aBU3qY&\u001c\u0017-T1oC\u001e,'/A\bsKBd\u0017nY1NC:\fw-\u001a:!\u00031\u0011X\r\u001d7jG\u0006\fVo\u001c;b+\u0005\u0001\u0006C\u0001\u001aR\u0013\t\u00116E\u0001\u0007SKBd\u0017nY1Rk>$\u0018-A\u0007sKBd\u0017nY1Rk>$\u0018\rI\u0001\u0011EJ|7.\u001a:U_BL7m\u0015;biN,\u0012A\u0016\t\u0003e]K!\u0001W\u0012\u0003!\t\u0013xn[3s)>\u0004\u0018nY*uCR\u001c\u0018\u0001\u00062s_.,'\u000fV8qS\u000e\u001cF/\u0019;t?\u0012*\u0017\u000f\u0006\u0002\\=B\u0011!\u0006X\u0005\u0003;.\u0012A!\u00168ji\"9qlCA\u0001\u0002\u00041\u0016a\u0001=%c\u0005\t\"M]8lKJ$v\u000e]5d'R\fGo\u001d\u0011\u0002\u000bM,G/\u00169\u0015\u0003mC#!\u00043\u0011\u0005\u0015dW\"\u00014\u000b\u0005\u001dD\u0017aA1qS*\u0011\u0011N[\u0001\bUV\u0004\u0018\u000e^3s\u0015\tY7)A\u0003kk:LG/\u0003\u0002nM\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D#A\u00049\u0011\u0005\u0015\f\u0018B\u0001:g\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\nuKN$X*\u001b=fIRKWM\u001d$fi\u000eD\u0007FA\bv!\t)g/\u0003\u0002xM\n!A+Z:u\u0003a!Xm\u001d;US\u0016\u0014h)\u001a;dQ\u0016\u0014X\t_2faRLwN\u001c\u0015\u0003!U\f\u0001\u0004^3ti\u001a+Go\u00195XSRDg)\u001a8dK\u0012,\u0005o\\2iQ\t\tR/A\fuKN$hj\u001c;MK\u0006$WM](s\r>dGn\\<fe\"\u0012!#^\u00013i\u0016\u001cHOR8mY><XM\u001d$fi\u000eDG+[7f\u0019\u0006<gj\u001c;SK\u000e|'\u000fZ3e\u0003N\u001cuN\\:v[\u0016\u0014h)\u001a;dQ\"\u00121#^\u0001\u001di\u0016\u001cHoQ8ogVlWM\u001d+jKJ4U\r^2i)&lW\rT1hQ\t!R/\u0001\u0019uKN$Hj\\2bYN+w-\\3oi\u0012+G.\u001a;fI\u00063G/\u001a:EK2\f\u00170\u001a3GKR\u001c\u0007n\u0011:fCRLwN\u001c\u0015\u0003+U\f!\u0003^3ti\u0012Kg/\u001a:hS:<W\t]8dQ\"\u0012a#^\u0001\u001di\u0016\u001cH\u000fR3mCf,G\rT:p\u0005\u0006\u001cX\r\u001a+jKJ,G\rT8hQ\t9R/A\u000fuKN$\u0018J\\2sK6,g\u000e^1m\r\u0016$8\r\u001b)beRLG/[8oQ\tAR/\u0001\u0019uKN$\u0018J\\2sK6,g\u000e^1m\r\u0016$8\r\u001b)beRLG/[8o/\",g\u000e\u0015:v]&tw\rR5tC\ndW\r\u001a\u0015\u00033U\f!\u0005^3ti6K\u00070\u001a3GKR\u001c\u0007\u000eR8fg:{GoQ8na2,G/Z#be2L\bF\u0001\u000ev\u0003a\u0011W/\u001b7e\r>dGn\\<fe\u001a+Go\u00195QCJ\fWn\u001d\u000b\u0007\u0003C\t)$!\u000f\u0011\t\u0005\r\u0012\u0011G\u0007\u0003\u0003KQA!a\n\u0002*\u0005\u0019An\\4\u000b\t\u0005-\u0012QF\u0001\nS:$XM\u001d8bYNT1!a\fA\u0003\u001d\u0019Ho\u001c:bO\u0016LA!a\r\u0002&\tYa)\u001a;dQB\u000b'/Y7t\u0011\u0019\t9d\u0007a\u0001k\u0005I!/\u001a9mS\u000e\f\u0017\n\u001a\u0005\u0007\u0003wY\u0002\u0019A\u001b\u0002\u00135\f\u0007pV1ji6\u001b\u0018!F3ya\u0016\u001cGOU3bI\u001a\u0013x.\u001c*fa2L7-\u0019\u000b\n7\u0006\u0005\u0013QIA+\u0003?Bq!a\u0011\u001d\u0001\u0004\t\t#A\u0006gKR\u001c\u0007\u000eU1sC6\u001c\bbBA$9\u0001\u0007\u0011\u0011J\u0001\u0011i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u0004B!a\u0013\u0002R5\u0011\u0011Q\n\u0006\u0004\u0003\u001f\u0002\u0015AB2p[6|g.\u0003\u0003\u0002T\u00055#\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0011\u001d\t9\u0006\ba\u0001\u00033\n!CZ3uG\"\u0004\u0016M\u001d;ji&|g\u000eR1uCB\u0019!'a\u0017\n\u0007\u0005u3E\u0001\fQCJ$\u0018\u000e^5p]\u001a+Go\u00195NKR\fG-\u0019;b\u0011\u001d\t\t\u0007\ba\u0001\u0003G\nQ!\u001a:s_J\u0004B!!\u001a\u0002l5\u0011\u0011q\r\u0006\u0005\u0003S\ni%\u0001\u0005qe>$xnY8m\u0013\u0011\ti'a\u001a\u0003\r\u0015\u0013(o\u001c:t\u0003=\u0011W/\u001b7e%\u0016\fGMU3tk2$H\u0003BA:\u0003s\u00022AMA;\u0013\r\t9h\t\u0002\u000e\u0019><'+Z1e%\u0016\u001cX\u000f\u001c;\t\u000f\u0005\u0005T\u00041\u0001\u0002d\u0005IR\r\u001f9fGR<U\r\u001e+jKJ4U\r^2i%\u0016\u001cX\u000f\u001c;t)\u001dY\u0016qPAJ\u0003\u001bDq!!!\u001f\u0001\u0004\t\u0019)\u0001\u0007qK:$\u0017N\\4GKR\u001c\u0007\u000e\u0005\u0003\u0002\u0006\u0006=UBAAD\u0015\u0011\tI)a#\u0002\u000f\u0019,Go\u00195fe*\u0019\u0011QR\u0013\u0002\tQLWM]\u0005\u0005\u0003#\u000b9I\u0001\u0007QK:$\u0017N\\4GKR\u001c\u0007\u000eC\u0004\u0002\u0016z\u0001\r!a&\u0002/Q|\u0007/[2QCJ$\u0018\u000e^5p]\u0016C8-\u001a9uS>t\u0007CBAM\u0003?\u000b\u0019+\u0004\u0002\u0002\u001c*\u0019\u0011QT\u0016\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\"\u0006m%aA*fcB9!&!*\u0002*\u0006=\u0016bAATW\t1A+\u001e9mKJ\u0002B!a\u0013\u0002,&!\u0011QVA'\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004RAKAY\u0003kK1!a-,\u0005\u0019y\u0005\u000f^5p]B!\u0011qWAd\u001d\u0011\tI,a1\u000f\t\u0005m\u0016\u0011Y\u0007\u0003\u0003{S1!a0(\u0003\u0019a$o\\8u}%\tA&C\u0002\u0002F.\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002J\u0006-'!\u0003+ie><\u0018M\u00197f\u0015\r\t)m\u000b\u0005\n\u0003\u001ft\u0002\u0013!a\u0001\u0003#\fqA]3d_J$7\u000f\u0005\u0003\u0002\u0006\u0006M\u0017\u0002BAk\u0003\u000f\u0013\u0001DU3dY\u0006LW.\u00192mK6+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0003\r*\u0007\u0010]3di\u001e+G\u000fV5fe\u001a+Go\u00195SKN,H\u000e^:%I\u00164\u0017-\u001e7uIM*\"!a7+\t\u0005E\u0017Q\\\u0016\u0003\u0003?\u0004B!!9\u0002l6\u0011\u00111\u001d\u0006\u0005\u0003K\f9/A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011^\u0016\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002n\u0006\r(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00061R\r\u001f9fGR\u0014V-\u00193Ge>lGj\\2bY2{w\rF\u0004\\\u0003g\f)Pa\u0002\t\u000b!\u0003\u0003\u0019\u0001&\t\u000f\u0005]\b\u00051\u0001\u0002z\u0006qa-\u001a;dQ\u0012\u000bG/Y%oM>\u001c\bCBAM\u0003?\u000bY\u0010E\u0005+\u0003{\fIE!\u0001\u00020&\u0019\u0011q`\u0016\u0003\rQ+\b\u000f\\34!\u0011\t\u0019Ca\u0001\n\t\t\u0015\u0011Q\u0005\u0002\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195ECR\f\u0017J\u001c4p\u0011\u001d\u0011I\u0001\ta\u0001\u0005\u0017\tQ\u0002[5hQ^\u000bG/\u001a:nCJ\\\u0007c\u0001\u0016\u0003\u000e%\u0019!qB\u0016\u0003\t1{gnZ\u0001\u0013EVLG\u000e\u001a)beRLG/[8o\t\u0006$\u0018\r\u0006\u0004\u0002Z\tU!q\u0004\u0005\b\u0005/\t\u0003\u0019\u0001B\r\u0003\u001d!x\u000e]5d\u0013\u0012\u0004B!a\u0013\u0003\u001c%!!QDA'\u0005\u0011)V/\u001b3\t\u000f\t\u0005\u0012\u00051\u0001\u0003\f\u0005Ya-\u001a;dQ>3gm]3u\u0001")
public class DelayedFetchTest {
    private final int maxBytes;
    private final MockTime mockTime = new MockTime();
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final ReplicaQuota replicaQuota = (ReplicaQuota)Mockito.mock(ReplicaQuota.class);
    private BrokerTopicStats brokerTopicStats;

    private int maxBytes() {
        return this.maxBytes;
    }

    private MockTime mockTime() {
        return this.mockTime;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private ReplicaQuota replicaQuota() {
        return this.replicaQuota;
    }

    private BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    private void brokerTopicStats_$eq(BrokerTopicStats x$1) {
        this.brokerTopicStats = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.brokerTopicStats_$eq(new BrokerTopicStats());
    }

    @AfterEach
    public void tearDown() {
        if (this.brokerTopicStats() != null) {
            this.brokerTopicStats().close();
            return;
        }
    }

    @Test
    public void testMixedTierFetch() {
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition topicIdPartition0 = new TopicIdPartition(topicId, 0, "topic");
        TopicIdPartition topicIdPartition1 = new TopicIdPartition(topicId, 1, "topic");
        int replicaId = 1;
        long fetchOffset = 500L;
        int highWatermark = 50;
        PartitionFetchMetadata fetchInfoPartition0 = this.buildPartitionData(topicId, fetchOffset);
        fetchInfoPartition0.setFetchOffsetMetadata(new LogOffsetMetadata(0L, 0L));
        PartitionFetchMetadata fetchInfoPartition1 = this.buildPartitionData(topicId, fetchOffset);
        fetchInfoPartition1.setFetchOffsetMetadata(LogOffsetMetadata.UNKNOWN_OFFSET_METADATA);
        FetchParams fetchParams = this.buildFollowerFetchParams(replicaId, 500);
        PendingFetch pendingFetch = (PendingFetch)Mockito.mock(PendingFetch.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)pendingFetch.isComplete())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Promise callbackPromise = Promise$.MODULE$.apply();
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition0), (Object)fetchInfoPartition0), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition1), (Object)fetchInfoPartition1), (List)Nil$.MODULE$)), this.replicaManager(), this.replicaQuota(), (Option)new Some((Object)pendingFetch), this.brokerTopicStats(), (Function1 & Serializable)value -> {
            callbackPromise.success((Object)value);
            return BoxedUnit.UNIT;
        }, true, HashMap$.MODULE$.empty());
        this.expectGetTierFetchResults(pendingFetch, (Seq<Tuple2<TopicPartition, Option<Throwable>>>)new .colon.colon((Object)new Tuple2((Object)topicIdPartition1.topicPartition(), (Object)None$.MODULE$), (List)Nil$.MODULE$), ReclaimableMemoryRecords.EMPTY);
        this.expectReadFromLocalLog(this.replicaManager(), (Seq<Tuple3<TopicIdPartition, AbstractFetchDataInfo, Option<Throwable>>>)new .colon.colon((Object)new Tuple3((Object)topicIdPartition0, (Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L), (Records)MemoryRecords.EMPTY), (Object)None$.MODULE$), (List)new .colon.colon((Object)new Tuple3((Object)topicIdPartition1, (Object)new TierFetchDataInfo(null, Optional.empty()), (Object)None$.MODULE$), (List)Nil$.MODULE$)), highWatermark);
        delayedFetch.forceComplete();
        ((PendingFetch)Mockito.verify((Object)pendingFetch)).finish();
        Assertions.assertTrue((boolean)callbackPromise.isCompleted(), (String)"Expected forceComplete to complete the request");
        Seq results = (Seq)Await$.MODULE$.result((Awaitable)callbackPromise.future(), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.SECONDS));
        Assertions.assertTrue((results.size() == 2 ? 1 : 0) != 0, (String)"Expected both a tiered and non-tiered fetch result");
        Assertions.assertTrue((boolean)results.forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DelayedFetchTest.$anonfun$testMixedTierFetch$2(highWatermark, x0$1))), (String)"Expected HWM to be set for both tiered and non-tiered results");
    }

    @Test
    public void testTierFetcherException() {
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition topicIdPartition0 = new TopicIdPartition(topicId, 0, "topic");
        TopicIdPartition topicIdPartition1 = new TopicIdPartition(topicId, 1, "topic");
        TopicIdPartition topicIdPartition2 = new TopicIdPartition(topicId, 2, "topic");
        int replicaId = 1;
        long fetchOffset = 500L;
        int highWatermark = 50;
        PartitionFetchMetadata fetchInfoPartition0 = this.buildPartitionData(topicId, fetchOffset);
        fetchInfoPartition0.setFetchOffsetMetadata(LogOffsetMetadata.UNKNOWN_OFFSET_METADATA);
        PartitionFetchMetadata fetchInfoPartition1 = this.buildPartitionData(topicId, fetchOffset);
        fetchInfoPartition1.setFetchOffsetMetadata(LogOffsetMetadata.UNKNOWN_OFFSET_METADATA);
        PartitionFetchMetadata fetchInfoPartition2 = this.buildPartitionData(topicId, fetchOffset);
        fetchInfoPartition2.setFetchOffsetMetadata(LogOffsetMetadata.UNKNOWN_OFFSET_METADATA);
        FetchParams fetchParams = this.buildFollowerFetchParams(replicaId, 500);
        PendingFetch pendingFetch = (PendingFetch)Mockito.mock(PendingFetch.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)pendingFetch.isComplete())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Promise callbackPromise = Promise$.MODULE$.apply();
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition0), (Object)fetchInfoPartition0), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition1), (Object)fetchInfoPartition1), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition2), (Object)fetchInfoPartition2), (List)Nil$.MODULE$))), this.replicaManager(), this.replicaQuota(), (Option)new Some((Object)pendingFetch), this.brokerTopicStats(), (Function1 & Serializable)value -> {
            callbackPromise.success((Object)value);
            return BoxedUnit.UNIT;
        }, true, HashMap$.MODULE$.empty());
        this.expectGetTierFetchResults(pendingFetch, (Seq<Tuple2<TopicPartition, Option<Throwable>>>)new .colon.colon((Object)new Tuple2((Object)topicIdPartition0.topicPartition(), (Object)None$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)topicIdPartition1.topicPartition(), (Object)new Some((Object)new UnknownServerException())), (List)new .colon.colon((Object)new Tuple2((Object)topicIdPartition2.topicPartition(), (Object)new Some((Object)new UnknownServerException())), (List)Nil$.MODULE$))), ReclaimableMemoryRecords.EMPTY);
        this.expectReadFromLocalLog(this.replicaManager(), (Seq<Tuple3<TopicIdPartition, AbstractFetchDataInfo, Option<Throwable>>>)new .colon.colon((Object)new Tuple3((Object)topicIdPartition0, (Object)new TierFetchDataInfo(null, Optional.empty()), (Object)new Some((Object)new FencedLeaderEpochException(""))), (List)new .colon.colon((Object)new Tuple3((Object)topicIdPartition1, (Object)new TierFetchDataInfo(null, Optional.empty()), (Object)None$.MODULE$), (List)new .colon.colon((Object)new Tuple3((Object)topicIdPartition2, (Object)new TierFetchDataInfo(null, Optional.empty()), (Object)new Some((Object)new FencedLeaderEpochException(""))), (List)Nil$.MODULE$))), highWatermark);
        delayedFetch.forceComplete();
        ((PendingFetch)Mockito.verify((Object)pendingFetch)).finish();
        Assertions.assertTrue((boolean)callbackPromise.isCompleted(), (String)"Expected forceComplete to complete the request");
        scala.collection.immutable.Map results = ((IterableOnceOps)Await$.MODULE$.result((Awaitable)callbackPromise.future(), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.SECONDS))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Assertions.assertTrue((results.size() == 3 ? 1 : 0) != 0, (String)"Expected 3 fetch results");
        Assertions.assertEquals((Object)((FetchPartitionData)results.apply((Object)topicIdPartition0)).error, (Object)Errors.FENCED_LEADER_EPOCH, (String)"Expected topicPartition0 to return a FencedLeaderException");
        Assertions.assertEquals((Object)((FetchPartitionData)results.apply((Object)topicIdPartition1)).error, (Object)Errors.UNKNOWN_SERVER_ERROR, (String)"Expected topicPartition1 to return a UnknownServerErrorException");
        Assertions.assertEquals((Object)((FetchPartitionData)results.apply((Object)topicIdPartition2)).error, (Object)Errors.FENCED_LEADER_EPOCH, (String)"Expected topicPartition2 to return a FencedLeaderException as it takes precedence over TierFetcher exceptions");
    }

    @Test
    public void testFetchWithFencedEpoch() {
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "topic");
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        int replicaId = 1;
        FullPartitionFetchMetadata fetchInfo = new FullPartitionFetchMetadata(topicIdPartition.topicId(), fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch, Optional.empty(), -1L);
        fetchInfo.setFetchOffsetMetadata(new LogOffsetMetadata(fetchOffset, fetchOffset, 0));
        FetchParams fetchParams = this.buildFollowerFetchParams(replicaId, 500);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)fetchInfo), (List)Nil$.MODULE$), this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable)responses -> {
            DelayedFetchTest.callback$1(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        }, true, HashMap$.MODULE$.empty());
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.topicId()).thenReturn((Object)new Some((Object)topicIdPartition.topicId()));
        Mockito.when((Object)partition.topicPartition()).thenReturn((Object)topicIdPartition.topicPartition());
        Mockito.when((Object)this.replicaManager().getPartitionOrException(topicIdPartition.topicPartition())).thenReturn((Object)partition);
        Mockito.when((Object)partition.fetchOffsetSnapshot(currentLeaderEpoch, true)).thenThrow(new Throwable[]{new FencedLeaderEpochException("Requested epoch has been fenced")});
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.expectReadFromReplica(fetchParams, topicIdPartition, (PartitionFetchMetadata)fetchInfo, Errors.FENCED_LEADER_EPOCH);
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedFetch.isCompleted());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
        FetchPartitionData fetchResult = (FetchPartitionData)((Option)fetchResultOpt.elem).get();
        Assertions.assertEquals((Object)Errors.FENCED_LEADER_EPOCH, (Object)fetchResult.error);
    }

    @Test
    public void testNotLeaderOrFollower() {
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "topic");
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        int replicaId = 1;
        FullPartitionFetchMetadata fetchInfo = new FullPartitionFetchMetadata(topicIdPartition.topicId(), fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch, Optional.empty(), -1L);
        FetchParams fetchParams = this.buildFollowerFetchParams(replicaId, 500);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)fetchInfo), (List)Nil$.MODULE$), this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable)responses -> {
            DelayedFetchTest.callback$2(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        }, true, HashMap$.MODULE$.empty());
        Mockito.when((Object)this.replicaManager().getPartitionOrException(topicIdPartition.topicPartition())).thenThrow(new Throwable[]{new NotLeaderOrFollowerException(new StringBuilder(26).append("Replica for ").append(topicIdPartition).append(" not available").toString())});
        this.expectReadFromReplica(fetchParams, topicIdPartition, (PartitionFetchMetadata)fetchInfo, Errors.NOT_LEADER_OR_FOLLOWER);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedFetch.isCompleted());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
    }

    @Test
    public void testFollowerFetchTimeLagNotRecordedAsConsumerFetch() {
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition topicIdPartition0 = new TopicIdPartition(topicId, 0, "topic");
        int replicaId = 1;
        long fetchOffset = 500L;
        int highWatermark = 50;
        FetchParams fetchParams = this.buildFollowerFetchParams(replicaId, 500);
        PartitionFetchMetadata fetchInfo = this.buildPartitionData(topicId, fetchOffset);
        fetchInfo.setFetchOffsetMetadata(new LogOffsetMetadata(0L, 0L));
        Promise callbackPromise = Promise$.MODULE$.apply();
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition0), (Object)fetchInfo), (List)Nil$.MODULE$), this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable)value -> {
            callbackPromise.success((Object)value);
            return BoxedUnit.UNIT;
        }, true, HashMap$.MODULE$.empty());
        byte[] x$1 = "message".getBytes();
        long x$2 = this.mockTime().milliseconds();
        CompressionType x$4 = CompressionType.NONE;
        byte x$5 = 2;
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords(x$1, null, x$4, x$2, x$5);
        this.expectReadFromLocalLog(this.replicaManager(), (Seq<Tuple3<TopicIdPartition, AbstractFetchDataInfo, Option<Throwable>>>)new .colon.colon((Object)new Tuple3((Object)topicIdPartition0, (Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L), (Records)records), (Object)None$.MODULE$), (List)Nil$.MODULE$), highWatermark);
        delayedFetch.forceComplete();
        Assertions.assertTrue((boolean)callbackPromise.isCompleted(), (String)"Expected forceComplete to complete the request");
        Seq results = (Seq)Await$.MODULE$.result((Awaitable)callbackPromise.future(), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)1, (int)results.size(), (String)"Expected tiered fetch result");
        Assertions.assertEquals((int)0, (int)this.brokerTopicStats().allTopicsStats().consumerFetchLagTimeMs().getSnapshot().size(), (String)"Follower fetch is not recorded, snapshot size is 0");
    }

    @Test
    public void testConsumerTierFetchTimeLag() {
        int fetchDelta = 3;
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition topicIdPartition0 = new TopicIdPartition(topicId, 0, "topic");
        TopicIdPartition topicIdPartition1 = new TopicIdPartition(topicId, 1, "topic");
        long fetchOffset = 500L;
        int highWatermark = 50;
        PartitionFetchMetadata fetchInfoPartition0 = this.buildPartitionData(topicId, fetchOffset);
        fetchInfoPartition0.setFetchOffsetMetadata(new LogOffsetMetadata(0L, 0L));
        PartitionFetchMetadata fetchInfoPartition1 = this.buildPartitionData(topicId, fetchOffset);
        fetchInfoPartition1.setFetchOffsetMetadata(LogOffsetMetadata.UNKNOWN_OFFSET_METADATA);
        FetchParams fetchParams = new FetchParams(ApiKeys.FETCH.latestVersion(), -1, -1L, 500L, 1, this.maxBytes(), FetchIsolation.HIGH_WATERMARK, Optional.empty());
        PendingFetch pendingFetch = (PendingFetch)Mockito.mock(PendingFetch.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)pendingFetch.isComplete())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Promise callbackPromise = Promise$.MODULE$.apply();
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition0), (Object)fetchInfoPartition0), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition1), (Object)fetchInfoPartition1), (List)Nil$.MODULE$)), this.replicaManager(), this.replicaQuota(), (Option)new Some((Object)pendingFetch), this.brokerTopicStats(), (Function1 & Serializable)value -> {
            callbackPromise.success((Object)value);
            return BoxedUnit.UNIT;
        }, true, HashMap$.MODULE$.empty());
        byte[] x$1 = "message".getBytes();
        long x$2 = this.mockTime().milliseconds();
        CompressionType x$4 = CompressionType.NONE;
        byte x$5 = 2;
        ReclaimableMemoryRecords records = new ReclaimableMemoryRecords(TestUtils$.MODULE$.singletonRecords(x$1, null, x$4, x$2, x$5).buffer(), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(Option$.MODULE$.empty())));
        this.mockTime().sleep((long)fetchDelta);
        this.expectGetTierFetchResults(pendingFetch, (Seq<Tuple2<TopicPartition, Option<Throwable>>>)new .colon.colon((Object)new Tuple2((Object)topicIdPartition1.topicPartition(), (Object)None$.MODULE$), (List)Nil$.MODULE$), records);
        this.expectReadFromLocalLog(this.replicaManager(), (Seq<Tuple3<TopicIdPartition, AbstractFetchDataInfo, Option<Throwable>>>)new .colon.colon((Object)new Tuple3((Object)topicIdPartition0, (Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L), (Records)records), (Object)None$.MODULE$), (List)new .colon.colon((Object)new Tuple3((Object)topicIdPartition1, (Object)new TierFetchDataInfo(null, Optional.empty()), (Object)None$.MODULE$), (List)Nil$.MODULE$)), highWatermark);
        delayedFetch.forceComplete();
        ((PendingFetch)Mockito.verify((Object)pendingFetch)).finish();
        Assertions.assertTrue((boolean)callbackPromise.isCompleted(), (String)"Expected forceComplete to complete the request");
        Seq results = (Seq)Await$.MODULE$.result((Awaitable)callbackPromise.future(), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)2, (int)results.size(), (String)"Expected tiered and local fetch result");
        Assertions.assertEquals((int)2, (int)this.brokerTopicStats().allTopicsStats().consumerFetchLagTimeMs().getSnapshot().size(), (String)"Expected size of recorded consumer fetch lag snapshot");
        double firstLagTimeMs = BoxesRunTime.unboxToDouble((Object)ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.doubleArrayOps(this.brokerTopicStats().allTopicsStats().consumerFetchLagTimeMs().getSnapshot().getValues())).getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> -1.0));
        Assertions.assertEquals((double)fetchDelta, (double)firstLagTimeMs, (double)0.0, (String)"Fetch Time lag last histogram value");
        double lastLagTimeMs = BoxesRunTime.unboxToDouble((Object)ArrayOps$.MODULE$.lastOption$extension(Predef$.MODULE$.doubleArrayOps(this.brokerTopicStats().allTopicsStats().consumerFetchLagTimeMs().getSnapshot().getValues())).getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> -1.0));
        Assertions.assertEquals((double)fetchDelta, (double)lastLagTimeMs, (double)0.0, (String)"Fetch Time lag last histogram value");
    }

    @Test
    public void testLocalSegmentDeletedAfterDelayedFetchCreation() {
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition topicIdPartition0 = new TopicIdPartition(topicId, 0, "topic");
        TopicIdPartition topicIdPartition1 = new TopicIdPartition(topicId, 1, "topic");
        int replicaId = 1;
        long fetchOffset = 500L;
        int highWatermark = 50;
        PartitionFetchMetadata fetchInfoPartition0 = this.buildPartitionData(topicId, fetchOffset);
        fetchInfoPartition0.setFetchOffsetMetadata(new LogOffsetMetadata(0L, 0L));
        PartitionFetchMetadata fetchInfoPartition1 = this.buildPartitionData(topicId, fetchOffset);
        fetchInfoPartition1.setFetchOffsetMetadata(new LogOffsetMetadata(0L, 0L));
        FetchParams fetchParams = this.buildFollowerFetchParams(replicaId, 500);
        PendingFetch pendingFetch = (PendingFetch)Mockito.mock(PendingFetch.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)pendingFetch.isComplete())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Promise callbackPromise = Promise$.MODULE$.apply();
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition0), (Object)fetchInfoPartition0), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition1), (Object)fetchInfoPartition1), (List)Nil$.MODULE$)), this.replicaManager(), this.replicaQuota(), (Option)new Some((Object)pendingFetch), this.brokerTopicStats(), (Function1 & Serializable)value -> {
            callbackPromise.success((Object)value);
            return BoxedUnit.UNIT;
        }, true, HashMap$.MODULE$.empty());
        this.expectGetTierFetchResults(pendingFetch, (Seq<Tuple2<TopicPartition, Option<Throwable>>>)new .colon.colon((Object)new Tuple2((Object)topicIdPartition1.topicPartition(), (Object)None$.MODULE$), (List)Nil$.MODULE$), ReclaimableMemoryRecords.EMPTY);
        this.expectReadFromLocalLog(this.replicaManager(), (Seq<Tuple3<TopicIdPartition, AbstractFetchDataInfo, Option<Throwable>>>)new .colon.colon((Object)new Tuple3((Object)topicIdPartition0, (Object)new TierFetchDataInfo(null, Optional.empty()), (Object)None$.MODULE$), (List)new .colon.colon((Object)new Tuple3((Object)topicIdPartition1, (Object)new TierFetchDataInfo(null, Optional.empty()), (Object)None$.MODULE$), (List)Nil$.MODULE$)), highWatermark);
        delayedFetch.forceComplete();
        ((PendingFetch)Mockito.verify((Object)pendingFetch)).finish();
        Assertions.assertTrue((boolean)callbackPromise.isCompleted(), (String)"Expected forceComplete to complete the request");
        scala.collection.immutable.Map results = ((IterableOnceOps)Await$.MODULE$.result((Awaitable)callbackPromise.future(), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.SECONDS))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Assertions.assertTrue((results.size() == 2 ? 1 : 0) != 0, (String)"Expected both a tiered and non-tiered fetch result");
        Assertions.assertTrue((boolean)results.forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DelayedFetchTest.$anonfun$testLocalSegmentDeletedAfterDelayedFetchCreation$2(highWatermark, x0$1))), (String)"Expected HWM to be set for both tiered and non-tiered results");
        Assertions.assertEquals((Object)((FetchPartitionData)results.apply((Object)topicIdPartition0)).records, (Object)ReclaimableMemoryRecords.EMPTY);
        Assertions.assertEquals((Object)((FetchPartitionData)results.apply((Object)topicIdPartition1)).records, (Object)ReclaimableMemoryRecords.EMPTY);
    }

    @Test
    public void testDivergingEpoch() {
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "topic");
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        Optional<Integer> lastFetchedEpoch = Optional.of(Predef$.MODULE$.int2Integer(9));
        int replicaId = 1;
        FullPartitionFetchMetadata fetchInfo = new FullPartitionFetchMetadata(topicIdPartition.topicId(), fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch, lastFetchedEpoch, -1L);
        fetchInfo.setFetchOffsetMetadata(new LogOffsetMetadata(fetchOffset, fetchOffset, 0));
        FetchParams fetchParams = this.buildFollowerFetchParams(replicaId, 500);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)fetchInfo), (List)Nil$.MODULE$), this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable)responses -> {
            DelayedFetchTest.callback$3(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        }, true, HashMap$.MODULE$.empty());
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)this.replicaManager().getPartitionOrException(topicIdPartition.topicPartition())).thenReturn((Object)partition);
        LogOffsetMetadata endOffsetMetadata = new LogOffsetMetadata(500L, 0L, 500);
        Mockito.when((Object)partition.fetchOffsetSnapshot(currentLeaderEpoch, true)).thenReturn((Object)new LogOffsetSnapshot(0L, endOffsetMetadata, endOffsetMetadata, endOffsetMetadata));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(currentLeaderEpoch, Predef$.MODULE$.Integer2int(lastFetchedEpoch.get()), false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(topicIdPartition.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(Predef$.MODULE$.Integer2int(lastFetchedEpoch.get())).setEndOffset(fetchOffset - 1L));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.expectReadFromReplica(fetchParams, topicIdPartition, (PartitionFetchMetadata)fetchInfo, Errors.NONE);
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedFetch.isCompleted());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
    }

    @Test
    public void testDelayedLsoBasedTieredLog() {
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicId, 0, "topic");
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> leaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        FullPartitionFetchMetadata fetchInfo = new FullPartitionFetchMetadata(topicId, fetchOffset, logStartOffset, this.maxBytes(), leaderEpoch, leaderEpoch, -1L);
        fetchInfo.setFetchOffsetMetadata(new LogOffsetMetadata(fetchOffset, MergedLog$.MODULE$.UnknownOffset(), 0));
        FetchParams fetchParams = new FetchParams(ApiKeys.FETCH.latestVersion(), -1, -1L, 500L, 1, this.maxBytes(), FetchIsolation.TXN_COMMITTED, Optional.empty());
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)fetchInfo), (List)Nil$.MODULE$), this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable)responses -> {
            DelayedFetchTest.callback$4(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        }, true, HashMap$.MODULE$.empty());
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.topicId()).thenReturn((Object)new Some((Object)topicIdPartition.topicId()), (Object[])new Option[]{new Some((Object)topicIdPartition.topicId()), null});
        Mockito.when((Object)partition.topicPartition()).thenReturn((Object)topicIdPartition.topicPartition());
        Mockito.when((Object)this.replicaManager().getPartitionOrException(topicIdPartition.topicPartition())).thenReturn((Object)partition);
        LogOffsetMetadata updatedOffsetMetadata = new LogOffsetMetadata(505L, 500L, 500);
        Mockito.when((Object)partition.fetchOffsetSnapshot(leaderEpoch, true)).thenReturn((Object)new LogOffsetSnapshot(0L, updatedOffsetMetadata, updatedOffsetMetadata, updatedOffsetMetadata));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(leaderEpoch, Predef$.MODULE$.Integer2int(leaderEpoch.get()), false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(topicIdPartition.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(Predef$.MODULE$.Integer2int(leaderEpoch.get())).setEndOffset(fetchOffset));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.expectReadFromReplica(fetchParams, topicIdPartition, (PartitionFetchMetadata)fetchInfo, Errors.NONE);
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedFetch.isCompleted());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
    }

    @Test
    public void testIncrementalFetchPartition() {
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition foo0 = new TopicIdPartition(topicId, 0, "foo");
        TopicIdPartition foo1 = new TopicIdPartition(topicId, 1, "foo");
        int replicaId = 1;
        FullPartitionFetchMetadata initialFetchMetadata = new FullPartitionFetchMetadata(topicId, 0L, 0L, 100, Optional.empty(), Optional.empty(), -1L);
        FetchResponseData.PartitionData initialFetchResponse = new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(0L);
        IncrementalPartitionFetchMetadata foo0Fetch = new IncrementalPartitionFetchMetadata(foo0, (PartitionFetchMetadata)initialFetchMetadata);
        DefaultPartitionListener foo0PartitionListener = new DefaultPartitionListener(false);
        foo0Fetch.maybeUpdateResponseData(initialFetchResponse, true);
        IncrementalPartitionFetchMetadata foo1Fetch = new IncrementalPartitionFetchMetadata(foo1, (PartitionFetchMetadata)initialFetchMetadata);
        DefaultPartitionListener foo1PartitionListener = new DefaultPartitionListener(false);
        foo1Fetch.maybeUpdateResponseData(initialFetchResponse, true);
        Mockito.when((Object)this.replicaManager().defaultPartitionListener(foo0.topicPartition())).thenAnswer(x$2 -> {
            foo0PartitionListener.onStartOffsetUpdated(foo0.topicPartition(), 0L);
            foo0PartitionListener.onEndOffsetUpdated(foo0.topicPartition(), 0L);
            foo0PartitionListener.onHighWatermarkUpdated(foo0.topicPartition(), 0L);
            foo0PartitionListener.onLastStableOffsetUpdated(foo0.topicPartition(), 0L);
            foo0PartitionListener.onIsrUpdated(foo0.topicPartition(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})));
            return foo0PartitionListener;
        });
        Mockito.when((Object)this.replicaManager().defaultPartitionListener(foo1.topicPartition())).thenAnswer(x$3 -> {
            foo1PartitionListener.onStartOffsetUpdated(foo1.topicPartition(), 0L);
            foo1PartitionListener.onEndOffsetUpdated(foo1.topicPartition(), 0L);
            foo1PartitionListener.onHighWatermarkUpdated(foo1.topicPartition(), 0L);
            foo1PartitionListener.onLastStableOffsetUpdated(foo1.topicPartition(), 0L);
            foo1PartitionListener.onIsrUpdated(foo0.topicPartition(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})));
            return foo1PartitionListener;
        });
        foo0Fetch.maybeRegisterAsListener(0, this.replicaManager());
        foo1Fetch.maybeRegisterAsListener(0, this.replicaManager());
        Assertions.assertFalse((boolean)foo0Fetch.fetchMetadataUpdated());
        Assertions.assertTrue((boolean)foo0Fetch.isCaughtUp(foo0Fetch.isCaughtUp$default$1()), (String)foo0Fetch.toString());
        Assertions.assertFalse((boolean)foo1Fetch.fetchMetadataUpdated());
        Assertions.assertTrue((boolean)foo1Fetch.isCaughtUp(foo1Fetch.isCaughtUp$default$1()), (String)foo1Fetch.toString());
        FetchParams fetchParams = this.buildFollowerFetchParams(replicaId, 500);
        ObjectRef fetchResult = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), (Object)foo0Fetch), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), (Object)foo1Fetch), (List)Nil$.MODULE$)), this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable)response -> {
            fetchResult.elem = new Some((Object)response.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            return BoxedUnit.UNIT;
        }, true, HashMap$.MODULE$.empty());
        Assertions.assertFalse((boolean)delayedFetch.tryComplete());
        Assertions.assertFalse((boolean)((Option)fetchResult.elem).isDefined());
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        foo1PartitionListener.onEndOffsetUpdated(foo1.topicPartition(), 10L);
        Assertions.assertFalse((boolean)foo1Fetch.isCaughtUp(foo1Fetch.isCaughtUp$default$1()), (String)foo1Fetch.toString());
        Partition fooPartition1 = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)fooPartition1.topicId()).thenReturn((Object)new Some((Object)topicId));
        Mockito.when((Object)fooPartition1.topicPartition()).thenReturn((Object)foo1.topicPartition());
        Mockito.when((Object)this.replicaManager().getPartitionOrException(foo1.topicPartition())).thenReturn((Object)fooPartition1);
        Mockito.when((Object)fooPartition1.convertToLocalOffsetMetadata(0L)).thenReturn((Object)new Some((Object)new LogOffsetMetadata(0L, 0L, 0)));
        Mockito.when((Object)fooPartition1.fetchOffsetSnapshot(Optional.empty(), true)).thenReturn((Object)new LogOffsetSnapshot(0L, new LogOffsetMetadata(10L, 0L, 100), new LogOffsetMetadata(0L), new LogOffsetMetadata(0L)));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().shouldLeaderThrottle(this.replicaQuota(), fooPartition1, 1))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.replicaManager().readFromLog(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), (Object)foo0Fetch), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), (Object)foo1Fetch), (List)Nil$.MODULE$)), this.replicaQuota(), true, true)).thenReturn((Object)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), (Object)this.buildReadResult(Errors.NONE)), (List)Nil$.MODULE$));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica(foo1.topicPartition(), replicaId))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)((Option)fetchResult.elem).isDefined());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo1})), (Object)((MapOps)((Option)fetchResult.elem).get()).keySet());
    }

    @Test
    public void testIncrementalFetchPartitionWhenPruningDisabled() {
        Uuid topicId = Uuid.randomUuid();
        int replicaId = 1;
        TopicIdPartition foo0 = new TopicIdPartition(topicId, 0, "foo");
        FullPartitionFetchMetadata initialFetchMetadata = new FullPartitionFetchMetadata(topicId, 0L, 0L, 100, Optional.empty(), Optional.empty(), -1L);
        FetchResponseData.PartitionData initialFetchResponse = new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(0L);
        IncrementalPartitionFetchMetadata foo0Fetch = new IncrementalPartitionFetchMetadata(foo0, (PartitionFetchMetadata)initialFetchMetadata);
        DefaultPartitionListener foo0PartitionListener = new DefaultPartitionListener(false);
        foo0Fetch.maybeUpdateResponseData(initialFetchResponse, true);
        Mockito.when((Object)this.replicaManager().defaultPartitionListener(foo0.topicPartition())).thenAnswer(x$4 -> {
            foo0PartitionListener.onStartOffsetUpdated(foo0.topicPartition(), 0L);
            foo0PartitionListener.onEndOffsetUpdated(foo0.topicPartition(), 0L);
            foo0PartitionListener.onHighWatermarkUpdated(foo0.topicPartition(), 0L);
            foo0PartitionListener.onLastStableOffsetUpdated(foo0.topicPartition(), 0L);
            foo0PartitionListener.onIsrUpdated(foo0.topicPartition(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})));
            return foo0PartitionListener;
        });
        foo0Fetch.maybeRegisterAsListener(0, this.replicaManager());
        Assertions.assertFalse((boolean)foo0Fetch.fetchMetadataUpdated());
        Assertions.assertTrue((boolean)foo0Fetch.isCaughtUp(foo0Fetch.isCaughtUp$default$1()), (String)foo0Fetch.toString());
        FetchParams fetchParams = this.buildFollowerFetchParams(replicaId, 500);
        ObjectRef fetchResult = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), (Object)foo0Fetch), (List)Nil$.MODULE$), this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, this.brokerTopicStats(), (Function1 & Serializable)response -> {
            fetchResult.elem = new Some((Object)response.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            return BoxedUnit.UNIT;
        }, false, HashMap$.MODULE$.empty());
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        Partition fooPartition0 = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)fooPartition0.topicId()).thenReturn((Object)new Some((Object)topicId));
        Mockito.when((Object)fooPartition0.topicPartition()).thenReturn((Object)foo0.topicPartition());
        Mockito.when((Object)this.replicaManager().getPartitionOrException(foo0.topicPartition())).thenReturn((Object)fooPartition0);
        Mockito.when((Object)fooPartition0.convertToLocalOffsetMetadata(0L)).thenReturn((Object)new Some((Object)new LogOffsetMetadata(0L, 0L, 0)));
        Mockito.when((Object)fooPartition0.fetchOffsetSnapshot(Optional.empty(), true)).thenReturn((Object)new LogOffsetSnapshot(0L, new LogOffsetMetadata(10L, 0L, 100), new LogOffsetMetadata(0L), new LogOffsetMetadata(0L)));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().shouldLeaderThrottle(this.replicaQuota(), fooPartition0, 1))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.replicaManager().readFromLog(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), (Object)foo0Fetch), (List)Nil$.MODULE$), this.replicaQuota(), true, false)).thenReturn((Object)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), (Object)this.buildReadResult(Errors.NONE)), (List)Nil$.MODULE$));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica(foo0.topicPartition(), replicaId))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)((Option)fetchResult.elem).isDefined());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo0})), (Object)((MapOps)((Option)fetchResult.elem).get()).keySet());
    }

    @Test
    public void testMixedFetchDoesNotCompleteEarly() {
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition localTopicPartition = new TopicIdPartition(topicId, 0, "topic1");
        TopicIdPartition tieredTopicPartition = new TopicIdPartition(topicId, 1, "topic2");
        int replicaId = 1;
        PartitionFetchMetadata localFetchInfo = this.buildPartitionData(topicId, 500L);
        localFetchInfo.setFetchOffsetMetadata(new LogOffsetMetadata(0L, 0L));
        PartitionFetchMetadata tierFetchInfo = this.buildPartitionData(topicId, 500L);
        tierFetchInfo.setFetchOffsetMetadata(new LogOffsetMetadata(0L, 0L));
        PendingFetch pendingFetch = (PendingFetch)Mockito.mock(PendingFetch.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)pendingFetch.isComplete())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false), ScalaRunTime$.MODULE$.toObjectArray((Object)new boolean[]{true}));
        Mockito.when((Object)pendingFetch.finish()).thenReturn(new HashMap(), (Object[])new java.util.Map[]{null});
        FetchParams fetchParams = this.buildFollowerFetchParams(replicaId, 500);
        DelayedFetch delayedFetch = new DelayedFetch(fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)localTopicPartition), (Object)localFetchInfo), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tieredTopicPartition), (Object)tierFetchInfo), (List)Nil$.MODULE$)), this.replicaManager(), this.replicaQuota(), (Option)new Some((Object)pendingFetch), this.brokerTopicStats(), (Function1 & Serializable)x$5 -> {
            DelayedFetchTest.$anonfun$testMixedFetchDoesNotCompleteEarly$1(x$5);
            return BoxedUnit.UNIT;
        }, true, HashMap$.MODULE$.empty());
        Partition localPartition = (Partition)Mockito.mock(Partition.class);
        Partition tieredPartition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)localPartition.topicId()).thenReturn((Object)new Some((Object)localTopicPartition.topicId()), (Object[])new Option[]{new Some((Object)localTopicPartition.topicId()), null});
        Mockito.when((Object)localPartition.topicPartition()).thenReturn((Object)localTopicPartition.topicPartition(), (Object[])new TopicPartition[]{localTopicPartition.topicPartition(), null});
        Mockito.when((Object)tieredPartition.topicId()).thenReturn((Object)new Some((Object)tieredTopicPartition.topicId()), (Object[])new Option[]{new Some((Object)tieredTopicPartition.topicId()), null});
        Mockito.when((Object)tieredPartition.topicPartition()).thenReturn((Object)tieredTopicPartition.topicPartition(), (Object[])new TopicPartition[]{tieredTopicPartition.topicPartition(), null});
        LogOffsetSnapshot logOffsetSnapshot = new LogOffsetSnapshot(0L, new LogOffsetMetadata(500L, 250L), new LogOffsetMetadata(500L, 250L), new LogOffsetMetadata(500L, 250L));
        Mockito.when((Object)localPartition.fetchOffsetSnapshot(Optional.empty(), true)).thenReturn((Object)logOffsetSnapshot);
        Mockito.when((Object)tieredPartition.fetchOffsetSnapshot(Optional.empty(), true)).thenReturn((Object)logOffsetSnapshot);
        Mockito.when((Object)this.replicaManager().getPartitionOrException(localTopicPartition.topicPartition())).thenReturn((Object)localPartition, (Object[])new Partition[]{localPartition, null});
        Mockito.when((Object)this.replicaManager().getPartitionOrException(tieredTopicPartition.topicPartition())).thenReturn((Object)tieredPartition, (Object[])new Partition[]{tieredPartition, null});
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().shouldLeaderThrottle((ReplicaQuota)ArgumentMatchers.any(), (Partition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.replicaManager().readFromLog((FetchParams)ArgumentMatchers.eq((Object)fetchParams), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()))).thenReturn((Object)Nil$.MODULE$, (Object[])new Seq[]{null});
        Assertions.assertFalse((boolean)delayedFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedFetch.tryComplete());
    }

    private FetchParams buildFollowerFetchParams(int replicaId, int maxWaitMs) {
        return new FetchParams(ApiKeys.FETCH.latestVersion(), replicaId, 1L, (long)maxWaitMs, 1, this.maxBytes(), FetchIsolation.LOG_END, Optional.empty());
    }

    private void expectReadFromReplica(FetchParams fetchParams, TopicIdPartition topicIdPartition, PartitionFetchMetadata fetchPartitionData, Errors error) {
        Mockito.when((Object)this.replicaManager().readFromLog(fetchParams, (Seq)new .colon.colon((Object)new Tuple2((Object)topicIdPartition, (Object)fetchPartitionData), (List)Nil$.MODULE$), this.replicaQuota(), true, true)).thenReturn((Object)new .colon.colon((Object)new Tuple2((Object)topicIdPartition, (Object)this.buildReadResult(error)), (List)Nil$.MODULE$));
    }

    private LogReadResult buildReadResult(Errors error) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        None$ x$1 = (errors == null ? errors2 != null : !errors.equals(errors2)) ? new Some((Object)error.exception()) : None$.MODULE$;
        FetchDataInfo x$2 = FetchDataInfo.EMPTY;
        None$ x$3 = None$.MODULE$;
        None$ x$11 = None$.MODULE$;
        None$ x$12 = None$.MODULE$;
        long x$13 = 0L;
        return new LogReadResult(x$2, (Option)x$3, -1L, -1L, -1L, -1L, -1L, (Option)x$11, false, false, (Option)x$12, (Option)x$1, x$13);
    }

    private void expectGetTierFetchResults(PendingFetch pendingFetch, Seq<Tuple2<TopicPartition, Option<Throwable>>> topicPartitionException, ReclaimableMemoryRecords records) {
        java.util.Map results = CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)topicPartitionException.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition topicPartition = (TopicPartition)x0$1._1();
                Option exceptionOpt = (Option)x0$1._2();
                if (topicPartition != null && exceptionOpt != null) {
                    return new Tuple2((Object)topicPartition, (Object)new TierFetchResult(records, Collections.emptyList(), (Throwable)exceptionOpt.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), 0L));
                }
            }
            throw new MatchError(x0$1);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
        Mockito.when((Object)pendingFetch.finish()).thenReturn((Object)results);
    }

    private ReclaimableMemoryRecords expectGetTierFetchResults$default$3() {
        return ReclaimableMemoryRecords.EMPTY;
    }

    private void expectReadFromLocalLog(ReplicaManager replicaManager, Seq<Tuple3<TopicIdPartition, AbstractFetchDataInfo, Option<Throwable>>> fetchDataInfos, long highWatermark) {
        Seq readResults = (Seq)fetchDataInfos.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicIdPartition tp = (TopicIdPartition)x0$1._1();
                AbstractFetchDataInfo tierFetchDataInfo = (AbstractFetchDataInfo)x0$1._2();
                Option exceptionOpt = (Option)x0$1._3();
                if (tierFetchDataInfo instanceof TierFetchDataInfo) {
                    TierFetchDataInfo tierFetchDataInfo2 = (TierFetchDataInfo)tierFetchDataInfo;
                    if (exceptionOpt != null) {
                        return new Tuple2((Object)tp, (Object)new TierLogReadResult(tierFetchDataInfo2, (Option)None$.MODULE$, highWatermark, 0L, 0L, 0L, this.mockTime().milliseconds(), 0, (Option)None$.MODULE$, (Option)None$.MODULE$, exceptionOpt, 0L));
                    }
                }
            }
            if (x0$1 != null) {
                TopicIdPartition tp = (TopicIdPartition)x0$1._1();
                AbstractFetchDataInfo fetchDataInfo = (AbstractFetchDataInfo)x0$1._2();
                Option exceptionOpt = (Option)x0$1._3();
                if (fetchDataInfo instanceof FetchDataInfo) {
                    FetchDataInfo fetchDataInfo2 = (FetchDataInfo)fetchDataInfo;
                    if (exceptionOpt != null) {
                        return new Tuple2((Object)tp, (Object)new LogReadResult(fetchDataInfo2, (Option)None$.MODULE$, highWatermark, 0L, 0L, 0L, this.mockTime().milliseconds(), (Option)None$.MODULE$, true, false, (Option)None$.MODULE$, exceptionOpt, 0L));
                    }
                }
            }
            if (x0$1 != null) {
                AbstractFetchDataInfo fetchInfo = (AbstractFetchDataInfo)x0$1._2();
                throw new IllegalStateException(new StringBuilder(52).append("Unexpected implementation of AbstractFetchDataInfo: ").append(fetchInfo.getClass()).toString());
            }
            throw new MatchError(null);
        });
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.isAddingReplica((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)replicaManager.readFromLog((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()))).thenReturn((Object)readResults);
    }

    private PartitionFetchMetadata buildPartitionData(Uuid topicId, long fetchOffset) {
        return new FullPartitionFetchMetadata(topicId, fetchOffset, 0L, Integer.MAX_VALUE, Optional.empty(), Optional.empty(), -1L);
    }

    public static final /* synthetic */ boolean $anonfun$testMixedTierFetch$2(int highWatermark$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((FetchPartitionData)x0$1._2()).highWatermark == (long)highWatermark$1;
        }
        throw new MatchError(null);
    }

    private static final void callback$1(Seq responses, ObjectRef fetchResultOpt$1) {
        fetchResultOpt$1.elem = new Some(((Tuple2)responses.head())._2());
    }

    private static final void callback$2(Seq responses, ObjectRef fetchResultOpt$2) {
        fetchResultOpt$2.elem = new Some(((Tuple2)responses.head())._2());
    }

    public static final /* synthetic */ boolean $anonfun$testLocalSegmentDeletedAfterDelayedFetchCreation$2(int highWatermark$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((FetchPartitionData)x0$1._2()).highWatermark == (long)highWatermark$2;
        }
        throw new MatchError(null);
    }

    private static final void callback$3(Seq responses, ObjectRef fetchResultOpt$3) {
        fetchResultOpt$3.elem = new Some(((Tuple2)responses.head())._2());
    }

    private static final void callback$4(Seq responses, ObjectRef fetchResultOpt$4) {
        fetchResultOpt$4.elem = new Some(((Tuple2)responses.head())._2());
    }

    public static final /* synthetic */ void $anonfun$testMixedFetchDoesNotCompleteEarly$1(Seq x$5) {
    }

    public DelayedFetchTest() {
        this.maxBytes = 1024;
    }
}

