/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.BaseRequestTest;
import kafka.utils.NotNothing$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.DeleteRecordsRequestData;
import org.apache.kafka.common.message.DeleteRecordsResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DeleteRecordsRequest;
import org.apache.kafka.common.requests.DeleteRecordsResponse;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0005\u0005mc\u0001B\b\u0011\u0001UAQA\u0007\u0001\u0005\u0002mAq!\b\u0001C\u0002\u0013%a\u0004\u0003\u0004&\u0001\u0001\u0006Ia\b\u0005\bM\u0001\u0011\r\u0011\"\u0003(\u0011\u0019Y\u0003\u0001)A\u0005Q!)A\u0006\u0001C\u0001[!)1\f\u0001C\u00019\")!\r\u0001C\u0001G\")\u0011\u000e\u0001C\u0005U\")q\u000f\u0001C\u0005q\"9\u0011q\u0001\u0001\u0005\n\u0005%\u0001bBA\u0004\u0001\u0011%\u0011Q\u0003\u0005\b\u0003;\u0001A\u0011BA\u0010\u0011\u001d\t\t\u0006\u0001C\u0005\u0003'\u0012\u0001\u0004R3mKR,'+Z2pe\u0012\u001c(+Z9vKN$H+Z:u\u0015\t\t\"#\u0001\u0004tKJ4XM\u001d\u0006\u0002'\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0017!\t9\u0002$D\u0001\u0011\u0013\tI\u0002CA\bCCN,'+Z9vKN$H+Z:u\u0003\u0019a\u0014N\\5u}Q\tA\u0004\u0005\u0002\u0018\u0001\u0005QA+S'F\u001fV#v,T*\u0016\u0003}\u0001\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012A\u0001T8oO\u0006YA+S'F\u001fV#v,T*!\u0003}iUiU*B\u000f\u0016\u001bv\f\u0015*P\tV\u001bU\tR0Q\u000bJ{\u0006+\u0011*U\u0013RKuJT\u000b\u0002QA\u0011\u0001%K\u0005\u0003U\u0005\u00121!\u00138u\u0003\u0001jUiU*B\u000f\u0016\u001bv\f\u0015*P\tV\u001bU\tR0Q\u000bJ{\u0006+\u0011*U\u0013RKuJ\u0014\u0011\u00025Q,7\u000f\u001e#fY\u0016$XMU3d_J$7\u000fS1qaf\u001c\u0015m]3\u0015\u00079\nd\b\u0005\u0002!_%\u0011\u0001'\t\u0002\u0005+:LG\u000fC\u00033\r\u0001\u00071'\u0001\u0004rk>\u0014X/\u001c\t\u0003imr!!N\u001d\u0011\u0005Y\nS\"A\u001c\u000b\u0005a\"\u0012A\u0002\u001fs_>$h(\u0003\u0002;C\u00051\u0001K]3eK\u001aL!\u0001P\u001f\u0003\rM#(/\u001b8h\u0015\tQ\u0014\u0005C\u0003@\r\u0001\u00071'A\u0006sKBd\u0017nY1uS>t\u0007\u0006\u0002\u0004B\u001b:\u0003\"AQ&\u000e\u0003\rS!\u0001R#\u0002\rA\f'/Y7t\u0015\t1u)A\u0004kkBLG/\u001a:\u000b\u0005!K\u0015!\u00026v]&$(\"\u0001&\u0002\u0007=\u0014x-\u0003\u0002M\u0007\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u0002\u001f\u0006A3\u0010Z5ta2\f\u0017PT1nKvt\u0013/^8sk6l4\u0010M?/e\u0016\u0004H.[2bi&|g.P>2{\"\"a!U,Y!\t\u0011V+D\u0001T\u0015\t!6)\u0001\u0005qe>4\u0018\u000eZ3s\u0013\t16K\u0001\u0007NKRDw\u000eZ*pkJ\u001cW-A\u0003wC2,X\rL\u0001ZC\u0005Q\u0016\u0001L!mYN+\b\u000f]8si\u0016$\u0017+^8sk6\fe\u000e\u001a*fa2L7-\u0019;j_:\u001cu.\u001c2j]\u0006$\u0018n\u001c8t\u00035\"Xm\u001d;FeJ|'o\u00165f]\u0012+G.\u001a;j]\u001e\u0014VmY8sIN<\u0016\u000e\u001e5J]Z\fG.\u001b3PM\u001a\u001cX\r\u001e\u000b\u0004]us\u0006\"\u0002\u001a\b\u0001\u0004\u0019\u0004\"B \b\u0001\u0004\u0019\u0004\u0006B\u0004B\u001b:CCaB)XC2\n\u0011,\u0001\u0017uKN$XI\u001d:pe^CWM\u001c#fY\u0016$\u0018N\\4SK\u000e|'\u000fZ:XSRD\u0017J\u001c<bY&$Gk\u001c9jGR\u0019a\u0006Z3\t\u000bIB\u0001\u0019A\u001a\t\u000b}B\u0001\u0019A\u001a)\t!\tUJ\u0014\u0015\u0005\u0011E;\u0006\u000eL\u0001Z\u0003e\u0019'/Z1uKR{\u0007/[2B]\u0012\u001cVM\u001c3SK\u000e|'\u000fZ:\u0016\u0003-\u0004B\u0001\t7oQ%\u0011Q.\t\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005=,X\"\u00019\u000b\u0005E\u0014\u0018AB2p[6|gN\u0003\u0002\u0014g*\u0011A/S\u0001\u0007CB\f7\r[3\n\u0005Y\u0004(A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001,GJ,\u0017\r^3EK2,G/\u001a*fG>\u0014Hm\u001d*fcV,7\u000f\u001e$peR{\u0007/[2QCJ$\u0018\u000e^5p]R!\u0011p`A\u0002!\tQX0D\u0001|\u0015\ta\b/\u0001\u0005sKF,Xm\u001d;t\u0013\tq8P\u0001\u000bEK2,G/\u001a*fG>\u0014Hm\u001d*fcV,7\u000f\u001e\u0005\u0007\u0003\u0003Q\u0001\u0019\u00018\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\"1\u0011Q\u0001\u0006A\u0002!\nab\u001c4gg\u0016$Hk\u001c#fY\u0016$X-\u0001\rtK:$G)\u001a7fi\u0016\u0014VmY8sIN\u0014V-];fgR$B!a\u0003\u0002\u0012A\u0019!0!\u0004\n\u0007\u0005=1PA\u000bEK2,G/\u001a*fG>\u0014Hm\u001d*fgB|gn]3\t\r\u0005M1\u00021\u0001z\u0003\u001d\u0011X-];fgR$b!a\u0003\u0002\u0018\u0005e\u0001BBA\n\u0019\u0001\u0007\u0011\u0010\u0003\u0004\u0002\u001c1\u0001\r\u0001K\u0001\tY\u0016\fG-\u001a:JI\u0006Y\u0001O]8ek\u000e,G)\u0019;b)\u0019\t\t#a\u0011\u0002NA1\u00111EA\u0017\u0003gqA!!\n\u0002*9\u0019a'a\n\n\u0003\tJ1!a\u000b\"\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\f\u00022\t\u00191+Z9\u000b\u0007\u0005-\u0012\u0005\u0005\u0003\u00026\u0005}RBAA\u001c\u0015\u0011\tI$a\u000f\u0002\u0011A\u0014x\u000eZ;dKJT1!!\u0010s\u0003\u001d\u0019G.[3oiNLA!!\u0011\u00028\tq!+Z2pe\u0012lU\r^1eCR\f\u0007bBA#\u001b\u0001\u0007\u0011qI\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogB)\u00111EA%]&!\u00111JA\u0019\u0005!IE/\u001a:bE2,\u0007BBA(\u001b\u0001\u0007\u0001&A\fok6lUm]:bO\u0016\u001c\b+\u001a:QCJ$\u0018\u000e^5p]\u0006qb/\u00197jI\u0006$X\rT8h'R\f'\u000f^(gMN,GOR8s)>\u0004\u0018n\u0019\u000b\u0006]\u0005U\u0013q\u000b\u0005\u0007\u0003\u0003q\u0001\u0019\u00018\t\r\u0005ec\u00021\u0001 \u0003M)\u0007\u0010]3di\u0016$7\u000b^1si>3gm]3u\u0001")
public class DeleteRecordsRequestTest
extends BaseRequestTest {
    private final long TIMEOUT_MS;
    private final int MESSAGES_PRODUCED_PER_PARTITION;

    private long TIMEOUT_MS() {
        return this.TIMEOUT_MS;
    }

    private int MESSAGES_PRODUCED_PER_PARTITION() {
        return this.MESSAGES_PRODUCED_PER_PARTITION;
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinations"})
    public void testDeleteRecordsHappyCase(String quorum, String replication) {
        void var5_5;
        void var4_4;
        block3: {
            Tuple2<TopicPartition, Object> tuple2;
            block2: {
                tuple2 = this.createTopicAndSendRecords();
                if (tuple2 == null) break block2;
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                int leaderId = tuple2._2$mcI$sp();
                if (topicPartition != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        int offsetToDelete = Math.max(this.MESSAGES_PRODUCED_PER_PARTITION() - 8, 0);
        DeleteRecordsRequest request = this.createDeleteRecordsRequestForTopicPartition((TopicPartition)var4_4, offsetToDelete);
        DeleteRecordsResponseData.DeleteRecordsPartitionResult partitionResult = this.sendDeleteRecordsRequest(request, (int)var5_5).data().topics().find(var4_4.topic()).partitions().find(var4_4.partition());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionResult.errorCode(), (String)new StringBuilder(32).append("Unexpected error code received: ").append(Errors.forCode((short)partitionResult.errorCode()).name()).toString());
        Assertions.assertEquals((long)offsetToDelete, (long)partitionResult.lowWatermark(), (String)new StringBuilder(34).append("Unexpected lowWatermark received: ").append(partitionResult.lowWatermark()).toString());
        this.validateLogStartOffsetForTopic((TopicPartition)var4_4, offsetToDelete);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinations"})
    public void testErrorWhenDeletingRecordsWithInvalidOffset(String quorum, String replication) {
        void var5_5;
        void var4_4;
        block3: {
            Tuple2<TopicPartition, Object> tuple2;
            block2: {
                tuple2 = this.createTopicAndSendRecords();
                if (tuple2 == null) break block2;
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                int leaderId = tuple2._2$mcI$sp();
                if (topicPartition != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        int offsetToDelete = this.MESSAGES_PRODUCED_PER_PARTITION() + 5;
        DeleteRecordsRequest request = this.createDeleteRecordsRequestForTopicPartition((TopicPartition)var4_4, offsetToDelete);
        DeleteRecordsResponseData.DeleteRecordsPartitionResult partitionResult = this.sendDeleteRecordsRequest(request, (int)var5_5).data().topics().find(var4_4.topic()).partitions().find(var4_4.partition());
        Assertions.assertEquals((short)Errors.OFFSET_OUT_OF_RANGE.code(), (short)partitionResult.errorCode(), (String)new StringBuilder(32).append("Unexpected error code received: ").append(Errors.forCode((short)partitionResult.errorCode()).name()).toString());
        Assertions.assertEquals((long)-1L, (long)partitionResult.lowWatermark());
        this.validateLogStartOffsetForTopic((TopicPartition)var4_4, 0L);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinations"})
    public void testErrorWhenDeletingRecordsWithInvalidTopic(String quorum, String replication) {
        TopicPartition invalidTopicPartition = new TopicPartition("invalid-topic", 0);
        int offsetToDelete = 1;
        DeleteRecordsRequest request = this.createDeleteRecordsRequestForTopicPartition(invalidTopicPartition, offsetToDelete);
        DeleteRecordsResponseData.DeleteRecordsPartitionResult partitionResult = this.sendDeleteRecordsRequest(request).data().topics().find(invalidTopicPartition.topic()).partitions().find(invalidTopicPartition.partition());
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)partitionResult.errorCode(), (String)new StringBuilder(32).append("Unexpected error code received: ").append(Errors.forCode((short)partitionResult.errorCode()).name()).toString());
        Assertions.assertEquals((long)-1L, (long)partitionResult.lowWatermark());
    }

    private Tuple2<TopicPartition, Object> createTopicAndSendRecords() {
        String topic1 = "topic-1";
        TopicPartition topicPartition = new TopicPartition(topic1, 0);
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        Map<Object, Object> partitionToLeader = this.createTopic(topic1, x$3, 3, x$4, x$5, x$6);
        this.maybeWaitUntilReplicasInPushMode(topicPartition);
        Assertions.assertTrue((boolean)partitionToLeader.contains((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())), (String)"Topic creation did not succeed.");
        this.produceData((Iterable<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), this.MESSAGES_PRODUCED_PER_PARTITION());
        return new Tuple2((Object)topicPartition, partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
    }

    private DeleteRecordsRequest createDeleteRecordsRequestForTopicPartition(TopicPartition topicPartition, int offsetToDelete) {
        DeleteRecordsRequestData requestData = new DeleteRecordsRequestData().setTopics(Collections.singletonList(new DeleteRecordsRequestData.DeleteRecordsTopic().setName(topicPartition.topic()).setPartitions(Collections.singletonList(new DeleteRecordsRequestData.DeleteRecordsPartition().setOffset((long)offsetToDelete).setPartitionIndex(topicPartition.partition()))))).setTimeoutMs((int)this.TIMEOUT_MS());
        return (DeleteRecordsRequest)new DeleteRecordsRequest.Builder(requestData).build();
    }

    private DeleteRecordsResponse sendDeleteRecordsRequest(DeleteRecordsRequest request) {
        return (DeleteRecordsResponse)this.connectAndReceive((AbstractRequest)request, this.anySocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DeleteRecordsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private DeleteRecordsResponse sendDeleteRecordsRequest(DeleteRecordsRequest request, int leaderId) {
        return (DeleteRecordsResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DeleteRecordsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private Seq<RecordMetadata> produceData(Iterable<TopicPartition> topicPartitions, int numMessagesPerPartition) {
        KafkaProducer producer = this.createProducer(new StringSerializer(), new StringSerializer(), this.createProducer$default$3());
        Seq sendfutureList = (Seq)((Seq)topicPartitions.toSeq().flatMap((Function1 & Serializable)tp -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessagesPerPartition).map((Function1 & Serializable)messageIndex -> DeleteRecordsRequestTest.$anonfun$produceData$2(tp, BoxesRunTime.unboxToInt((Object)messageIndex))))).map((Function1 & Serializable)x$1 -> producer.send(x$1));
        producer.flush();
        Seq recordMetadataList = (Seq)sendfutureList.map((Function1 & Serializable)x$3 -> (RecordMetadata)x$3.get(10L, TimeUnit.SECONDS));
        recordMetadataList.foreach((Function1 & Serializable)recordMetadata -> {
            DeleteRecordsRequestTest.$anonfun$produceData$5(recordMetadata);
            return BoxedUnit.UNIT;
        });
        return recordMetadataList;
    }

    private void validateLogStartOffsetForTopic(TopicPartition topicPartition, long expectedStartOffset) {
        Option logForTopicPartition = ((IterableOps)this.brokers().flatMap((Function1 & Serializable)x$4 -> {
            LogManager qual$1 = x$4.replicaManager().logManager();
            boolean x$2 = qual$1.getLog$default$2();
            return qual$1.getLog(topicPartition, x$2);
        })).headOption();
        Assertions.assertTrue((boolean)logForTopicPartition.isDefined());
        Assertions.assertEquals((long)expectedStartOffset, (long)((AbstractLog)logForTopicPartition.get()).logStartOffset());
    }

    public static final /* synthetic */ ProducerRecord $anonfun$produceData$2(TopicPartition tp$1, int messageIndex) {
        String suffix = new StringBuilder(1).append(tp$1).append("-").append(messageIndex).toString();
        return new ProducerRecord(tp$1.topic(), Predef$.MODULE$.int2Integer(tp$1.partition()), (Object)new StringBuilder(4).append("key ").append(suffix).toString(), (Object)new StringBuilder(6).append("value ").append(suffix).toString());
    }

    public static final /* synthetic */ void $anonfun$produceData$5(RecordMetadata recordMetadata) {
        Assertions.assertTrue((recordMetadata.offset() >= 0L ? 1 : 0) != 0, (String)new StringBuilder(15).append("Invalid offset ").append(recordMetadata).toString());
    }

    public DeleteRecordsRequestTest() {
        this.TIMEOUT_MS = 15000L;
        this.MESSAGES_PRODUCED_PER_PARTITION = 10;
    }
}

