/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import kafka.network.SocketServer;
import kafka.security.authorizer.AclEntry$;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Implicits;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.message.DescribeClusterRequestData;
import org.apache.kafka.common.message.DescribeClusterResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeClusterRequest;
import org.apache.kafka.common.requests.DescribeClusterResponse;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005%d\u0001\u0002\u0007\u000e\u0001IAQa\u0006\u0001\u0005\u0002aAQA\u0007\u0001\u0005BmAqA\r\u0001C\u0002\u0013\u00051\u0007\u0003\u0004A\u0001\u0001\u0006I\u0001\u000e\u0005\u0006\u0003\u0002!\tE\u0011\u0005\u0006\u000b\u0002!\tE\u0012\u0005\u00063\u0002!\tA\u0017\u0005\u0006}\u0002!\ta \u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u0011\u001d\t9\u0002\u0001C\u0005\u00033A\u0011\"!\u0015\u0001#\u0003%I!a\u0015\u00035\u0011+7o\u0019:jE\u0016\u001cE.^:uKJ\u0014V-];fgR$Vm\u001d;\u000b\u00059y\u0011AB:feZ,'OC\u0001\u0011\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\n\u0011\u0005Q)R\"A\u0007\n\u0005Yi!a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005I\u0002C\u0001\u000b\u0001\u00035iw\u000eZ5gs\u000e{gNZ5hgR\u0011AD\t\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0005+:LG\u000fC\u0003$\u0005\u0001\u0007A%A\u0003qe>\u00048\u000fE\u0002&Q)j\u0011A\n\u0006\u0003Oy\t!bY8mY\u0016\u001cG/[8o\u0013\tIcEA\u0002TKF\u0004\"a\u000b\u0019\u000e\u00031R!!\f\u0018\u0002\tU$\u0018\u000e\u001c\u0006\u0002_\u0005!!.\u0019<b\u0013\t\tDF\u0001\u0006Qe>\u0004XM\u001d;jKN\f!B\u0011:pW\u0016\u0014H+Y4t+\u0005!\u0004\u0003B\u001b9uij\u0011A\u000e\u0006\u0003o\u0019\n\u0011\"[7nkR\f'\r\\3\n\u0005e2$aA'baB\u00111HP\u0007\u0002y)\u0011QHL\u0001\u0005Y\u0006tw-\u0003\u0002@y\t11\u000b\u001e:j]\u001e\f1B\u0011:pW\u0016\u0014H+Y4tA\u00059\"M]8lKJ\u0004&o\u001c9feRLxJ^3se&$Wm\u001d\u000b\u00039\rCQ\u0001R\u0003A\u0002)\n!\u0002\u001d:pa\u0016\u0014H/[3t\u0003\u0015\u0019X\r^+q)\tar\tC\u0003I\r\u0001\u0007\u0011*\u0001\u0005uKN$\u0018J\u001c4p!\tQ5+D\u0001L\u0015\taU*A\u0002ba&T!AT(\u0002\u000f),\b/\u001b;fe*\u0011\u0001+U\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002%\u0006\u0019qN]4\n\u0005Q[%\u0001\u0003+fgRLeNZ8)\u0005\u00191\u0006C\u0001&X\u0013\tA6J\u0001\u0006CK\u001a|'/Z#bG\"\fa\b^3ti\u0012+7o\u0019:jE\u0016\u001cE.^:uKJ\u0014V-];fgRLen\u00197vI&twm\u00117vgR,'/Q;uQ>\u0014\u0018N_3e\u001fB,'/\u0019;j_:\u001cHC\u0001\u000f\\\u0011\u0015av\u00011\u0001^\u0003\u0019\tXo\u001c:v[B\u0011a,\u001a\b\u0003?\u000e\u0004\"\u0001\u0019\u0010\u000e\u0003\u0005T!AY\t\u0002\rq\u0012xn\u001c;?\u0013\t!g$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u007f\u0019T!\u0001\u001a\u0010)\t\u001dAgn\u001c\t\u0003S2l\u0011A\u001b\u0006\u0003W6\u000ba\u0001]1sC6\u001c\u0018BA7k\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0005]\u0006lW-I\u0001q\u0003\tZH-[:qY\u0006Lh*Y7f{:Z\u0018M]4v[\u0016tGo],ji\"t\u0015-\\3t{\"\"qA\u001d=z!\t\u0019h/D\u0001u\u0015\t)(.\u0001\u0005qe>4\u0018\u000eZ3s\u0013\t9HOA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0003ur\f\u0013a_\u0001\u0003u.\f\u0013!`\u0001\u0006WJ\fg\r^\u0001?i\u0016\u001cH\u000fR3tGJL'-Z\"mkN$XM\u001d*fcV,7\u000f^#yG2,H-\u001b8h\u00072,8\u000f^3s\u0003V$\bn\u001c:ju\u0016$w\n]3sCRLwN\\:\u0015\u0007q\t\t\u0001C\u0003]\u0011\u0001\u0007Q\f\u000b\u0003\tQ:|\u0007&\u0002\u0005sq\u0006\u001dAF\u0001>}\u0003i!Xm\u001d;EKN\u001c'/\u001b2f\u00072,8\u000f^3s%\u0016\fX/Z:u)\ra\u0012Q\u0002\u0005\b\u0003\u001fI\u0001\u0019AA\t\u0003\tJgn\u00197vI\u0016\u001cE.^:uKJ\fU\u000f\u001e5pe&TX\rZ(qKJ\fG/[8ogB\u0019Q$a\u0005\n\u0007\u0005UaDA\u0004C_>dW-\u00198\u00025M,g\u000e\u001e#fg\u000e\u0014\u0018NY3DYV\u001cH/\u001a:SKF,Xm\u001d;\u0015\r\u0005m\u0011\u0011GA\u001e!\u0011\ti\"!\f\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\t\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0005\u0003K\t9#\u0001\u0004d_6lwN\u001c\u0006\u0004!\u0005%\"bAA\u0016#\u00061\u0011\r]1dQ\u0016LA!a\f\u0002 \t9B)Z:de&\u0014Wm\u00117vgR,'OU3ta>t7/\u001a\u0005\b\u0003gQ\u0001\u0019AA\u001b\u0003\u001d\u0011X-];fgR\u0004B!!\b\u00028%!\u0011\u0011HA\u0010\u0005Y!Um]2sS\n,7\t\\;ti\u0016\u0014(+Z9vKN$\b\"CA\u001f\u0015A\u0005\t\u0019AA \u0003-!Wm\u001d;j]\u0006$\u0018n\u001c8\u0011\u000bu\t\t%!\u0012\n\u0007\u0005\rcD\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u000f\ni%\u0004\u0002\u0002J)\u0019\u00111J\b\u0002\u000f9,Go^8sW&!\u0011qJA%\u00051\u0019vnY6fiN+'O^3s\u0003\u0011\u001aXM\u001c;EKN\u001c'/\u001b2f\u00072,8\u000f^3s%\u0016\fX/Z:uI\u0011,g-Y;mi\u0012\u0012TCAA+U\u0011\ty$a\u0016,\u0005\u0005e\u0003\u0003BA.\u0003Kj!!!\u0018\u000b\t\u0005}\u0013\u0011M\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0019\u001f\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003O\niFA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class DescribeClusterRequestTest
extends BaseRequestTest {
    private final scala.collection.immutable.Map<String, String> BrokerTags = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"bar")}));

    @Override
    public void modifyConfigs(Seq<Properties> props) {
        props.foreach((Function1 & Serializable)prop -> prop.setProperty(new StringBuilder(4).append(KafkaConfig$.MODULE$.BrokerTagsProp()).append(".foo").toString(), "bar"));
        super.modifyConfigs(props);
    }

    public scala.collection.immutable.Map<String, String> BrokerTags() {
        return this.BrokerTags;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.setProperty(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), "2");
        properties.setProperty(KafkaConfig$.MODULE$.RackProp(), new StringBuilder(5).append("rack/").append(properties.getProperty(KafkaConfig$.MODULE$.BrokerIdProp())).toString());
        properties.putAll((java.util.Map<?, ?>)CollectionConverters$.MODULE$.MapHasAsJava((Map)this.BrokerTags().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String name = (String)x0$1._1();
                String value = (String)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(1).append(KafkaConfig$.MODULE$.BrokerTagsProp()).append(".").append(name).toString()), (Object)value);
            }
            throw new MatchError(null);
        })).asJava());
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.doSetup(testInfo, false);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeClusterRequestIncludingClusterAuthorizedOperations(String quorum) {
        this.testDescribeClusterRequest(true);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeClusterRequestExcludingClusterAuthorizedOperations(String quorum) {
        this.testDescribeClusterRequest(false);
    }

    public void testDescribeClusterRequest(boolean includeClusterAuthorizedOperations) {
        scala.collection.immutable.Set expectedBrokers = ((IterableOnceOps)this.brokers().map((Function1 & Serializable)server -> {
            DescribeClusterResponseData.TagKeyValueCollection tags = new DescribeClusterResponseData.TagKeyValueCollection();
            if (!this.isKRaftTest()) {
                this.BrokerTags().foreachEntry((arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(name, value) -> BoxesRunTime.boxToBoolean((boolean)tags.add((ImplicitLinkedHashCollection.Element)new DescribeClusterResponseData.TagKeyValue().setName(name).setValue(value))), arg_0, arg_1));
            }
            return new DescribeClusterResponseData.DescribeClusterBroker().setBrokerId(server.config().brokerId()).setHost("localhost").setPort(server.socketServer().boundPort(this.listenerName())).setRack((String)server.config().rack().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setTags(tags);
        })).toSet();
        IntRef expectedControllerId = IntRef.create((int)0);
        if (!this.isKRaftTest()) {
            expectedControllerId.elem = ((KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DescribeClusterRequestTest.$anonfun$testDescribeClusterRequest$3(x$1)))).last()).config().brokerId();
        }
        String expectedClusterId = ((KafkaBroker)this.brokers().last()).clusterId();
        int expectedClusterAuthorizedOperations = includeClusterAuthorizedOperations ? Utils.to32BitField((java.util.Set)CollectionConverters$.MODULE$.SetHasAsJava((Set)AclEntry$.MODULE$.supportedOperations(ResourceType.CLUSTER).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToByte((byte)x$2.code()))).asJava()) : Integer.MIN_VALUE;
        this.ensureConsistentKRaftMetadata();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ApiKeys.DESCRIBE_CLUSTER.oldestVersion()), (int)ApiKeys.DESCRIBE_CLUSTER.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> {
            DescribeClusterRequest describeClusterRequest = new DescribeClusterRequest.Builder(new DescribeClusterRequestData().setIncludeClusterAuthorizedOperations(includeClusterAuthorizedOperations)).build((short)version);
            DescribeClusterResponse describeClusterResponse = this.sentDescribeClusterRequest(describeClusterRequest, (Option<SocketServer>)None$.MODULE$);
            if (this.isKRaftTest()) {
                Assertions.assertTrue((boolean)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), this.brokerCount()).contains(describeClusterResponse.data().controllerId()));
            } else {
                Assertions.assertEquals((int)expectedControllerId$1.elem, (int)describeClusterResponse.data().controllerId());
            }
            Assertions.assertEquals((Object)expectedClusterId, (Object)describeClusterResponse.data().clusterId());
            Assertions.assertEquals((int)expectedClusterAuthorizedOperations, (int)describeClusterResponse.data().clusterAuthorizedOperations());
            Assertions.assertEquals((Object)expectedBrokers, (Object)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)describeClusterResponse.data().brokers()).asScala().toSet());
        });
    }

    private DescribeClusterResponse sentDescribeClusterRequest(DescribeClusterRequest request, Option<SocketServer> destination) {
        return (DescribeClusterResponse)this.connectAndReceive((AbstractRequest)request, (SocketServer)destination.getOrElse((Function0 & Serializable)() -> this.anySocketServer()), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeClusterResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private Option<SocketServer> sentDescribeClusterRequest$default$2() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClusterRequest$3(KafkaServer x$1) {
        return x$1.kafkaController().isActive();
    }
}

