/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.FileStore;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kafka.server.BrokerBackpressureConfig;
import kafka.server.BrokerBackpressureConfig$;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.Defaults$;
import kafka.server.DiskThrottleListenerManager;
import kafka.server.DiskUsageBasedThrottleListener;
import kafka.server.DiskUsageBasedThrottler;
import kafka.server.DiskUsageBasedThrottlerTest$;
import kafka.server.DiskUsageBasedThrottlingConfig;
import kafka.server.DiskUsageBasedThrottlingConfig$;
import kafka.server.QuotaType;
import kafka.utils.Logging;
import kafka.utils.TestUtils;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t]d\u0001B\u001e=\u0001\u0005CQ\u0001\u0013\u0001\u0005\u0002%Cq\u0001\u0014\u0001C\u0002\u0013%Q\n\u0003\u0004R\u0001\u0001\u0006IA\u0014\u0005\b%\u0002\u0011\r\u0011\"\u0003N\u0011\u0019\u0019\u0006\u0001)A\u0005\u001d\"9A\u000b\u0001b\u0001\n\u0013i\u0005BB+\u0001A\u0003%a\nC\u0004W\u0001\t\u0007I\u0011B,\t\r!\u0004\u0001\u0015!\u0003Y\u0011\u001dI\u0007A1A\u0005\n5CaA\u001b\u0001!\u0002\u0013q\u0005bB6\u0001\u0005\u0004%I!\u0014\u0005\u0007Y\u0002\u0001\u000b\u0011\u0002(\t\u000f5\u0004!\u0019!C\u0005]\"9\u0011\u0011\u0001\u0001!\u0002\u0013y\u0007\"CA\u0002\u0001\t\u0007I\u0011BA\u0003\u0011!\ti\u0001\u0001Q\u0001\n\u0005\u001d\u0001\"CA\b\u0001\t\u0007I\u0011BA\t\u0011!\tY\u0003\u0001Q\u0001\n\u0005M\u0001\"CA\u0017\u0001\t\u0007I\u0011BA\u0018\u0011!\t)\u000f\u0001Q\u0001\n\u0005E\u0002bCAt\u0001\u0001\u0007\t\u0019!C\u0005\u0003SD1\"!<\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002p\"Y\u0011Q\u001f\u0001A\u0002\u0003\u0005\u000b\u0015BAv\u0011\u001d\t9\u0010\u0001C\u0001\u0003\u0007CqAa\u0004\u0001\t\u0003\t\u0019\tC\u0004\u0003\u001a\u0001!\t!a!\t\u000f\t\r\u0002\u0001\"\u0001\u0002\u0004\"9!q\u0005\u0001\u0005\u0002\u0005\r\u0005b\u0002B\u0016\u0001\u0011\u0005\u00111\u0011\u0005\b\u0005_\u0001A\u0011AAB\u0011\u001d\u0011\u0019\u0004\u0001C\u0001\u0003\u0007CqAa\u000e\u0001\t\u0003\t\u0019\tC\u0004\u0003<\u0001!\t!a!\t\u000f\t}\u0002\u0001\"\u0001\u0002\u0004\"9!1\t\u0001\u0005\u0002\u0005\r\u0005b\u0002B$\u0001\u0011\u0005\u00111\u0011\u0005\b\u0005\u0017\u0002A\u0011AAB\u0011\u001d\u0011y\u0005\u0001C\u0001\u0003\u0007CqAa\u0015\u0001\t\u0003\t\u0019\tC\u0004\u0003X\u0001!\t!a!\t\u000f\tm\u0003\u0001\"\u0001\u0002\u0004\"9!q\f\u0001\u0005\n\t\u0005\u0004\"\u0003B9\u0001E\u0005I\u0011\u0002B:\u000f\u001d\t)\u0004\u0010E\u0001\u0003o1aa\u000f\u001f\t\u0002\u0005e\u0002B\u0002%/\t\u0003\tYD\u0002\u0004\u0002>9\u0002\u0011q\b\u0005\u0007\u0011B\"\t!a\u0012\t\u0015\u00055\u0003G1A\u0005Rq\ny\u0005\u0003\u0005\u0002XA\u0002\u000b\u0011BA)\u0011%\tI\u0006\rb\u0001\n\u0003\tY\u0006\u0003\u0005\u0002rA\u0002\u000b\u0011BA/\u0011\u001d\t\u0019\b\rC!\u0003kBq!!!1\t\u0003\n\u0019\tC\u0004\u0002\u0006:\"\t!a\"\t\u0013\u0005\u001dg&%A\u0005\u0002\u0005%\u0007\"CAp]E\u0005I\u0011AAq\u0005m!\u0015n]6Vg\u0006<WMQ1tK\u0012$\u0006N]8ui2,'\u000fV3ti*\u0011QHP\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003}\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0005B\u00111IR\u0007\u0002\t*\tQ)A\u0003tG\u0006d\u0017-\u0003\u0002H\t\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001&\u0011\u0005-\u0003Q\"\u0001\u001f\u0002\u0015QD'o\\;hQB,H/F\u0001O!\t\u0019u*\u0003\u0002Q\t\n!Aj\u001c8h\u0003-!\bN]8vO\"\u0004X\u000f\u001e\u0011\u0002\u0013QD'/Z:i_2$\u0017A\u0003;ie\u0016\u001c\bn\u001c7eA\u0005iA.\u0019:hK\u001aKG.Z*ju\u0016\fa\u0002\\1sO\u00164\u0015\u000e\\3TSj,\u0007%A\u0004m_\u001e$\u0015N]:\u0016\u0003a\u00032!\u00170a\u001b\u0005Q&BA.]\u0003%IW.\\;uC\ndWM\u0003\u0002^\t\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005}S&aA*fcB\u0011\u0011MZ\u0007\u0002E*\u00111\rZ\u0001\u0005Y\u0006twMC\u0001f\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0014'AB*ue&tw-\u0001\u0005m_\u001e$\u0015N]:!\u0003E!WMZ1vYR$v\u000e^1m\u0005f$Xm]\u0001\u0013I\u00164\u0017-\u001e7u)>$\u0018\r\u001c\"zi\u0016\u001c\b%\u0001\nj]&$\u0018.\u00197Vg\u0006\u0014G.\u001a\"zi\u0016\u001c\u0018aE5oSRL\u0017\r\\+tC\ndWMQ=uKN\u0004\u0013A\u00034jY\u0016\u001cFo\u001c:fgV\tq\u000eE\u0002Z=B\u0004\"!]?\u000f\u0005IThBA:y\u001d\t!x/D\u0001v\u0015\t1\b)\u0001\u0004=e>|GOP\u0005\u0002\u007f%\u0011\u0011PP\u0001\u0006kRLGn]\u0005\u0003wr\f\u0011\u0002V3tiV#\u0018\u000e\\:\u000b\u0005et\u0014B\u0001@\u0000\u0005Y!U\r^3s[&t\u0017n\u001d;jG\u001aKG.Z*u_J,'BA>}\u0003-1\u0017\u000e\\3Ti>\u0014Xm\u001d\u0011\u0002\r\r|gNZ5h+\t\t9\u0001E\u0002L\u0003\u0013I1!a\u0003=\u0005y!\u0015n]6Vg\u0006<WMQ1tK\u0012$\u0006N]8ui2LgnZ\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0002\u00115|7m\u001b+j[\u0016,\"!a\u0005\u0011\t\u0005U\u0011qE\u0007\u0003\u0003/Q1!_A\r\u0015\u0011\tY\"!\b\u0002\r\r|W.\\8o\u0015\ry\u0014q\u0004\u0006\u0005\u0003C\t\u0019#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003K\t1a\u001c:h\u0013\u0011\tI#a\u0006\u0003\u00115{7m\u001b+j[\u0016\f\u0011\"\\8dWRKW.\u001a\u0011\u0002\u00111L7\u000f^3oKJ,\"!!\r\u0011\u0007\u0005M\u0002G\u0004\u0002L[\u0005YB)[:l+N\fw-\u001a\"bg\u0016$G\u000b\u001b:piRdWM\u001d+fgR\u0004\"a\u0013\u0018\u0014\u00059\u0012ECAA\u001c\u0005\u0019\"Vm\u001d;bE2,G)[:l+N\fw-\u001a\"bg\u0016$G\u000b\u001b:piRdW\rT5ti\u0016tWM]\n\u0005a\t\u000b\t\u0005E\u0002L\u0003\u0007J1!!\u0012=\u0005y!\u0015n]6Vg\u0006<WMQ1tK\u0012$\u0006N]8ui2,G*[:uK:,'\u000f\u0006\u0002\u0002JA\u0019\u00111\n\u0019\u000e\u00039\n\u0011\"];pi\u0006$\u0016\u0010]3\u0016\u0005\u0005E\u0003cA&\u0002T%\u0019\u0011Q\u000b\u001f\u0003\u0013E+x\u000e^1UsB,\u0017AC9v_R\fG+\u001f9fA\u000591m\\;oi\u0016\u0014XCAA/!\u0011\ty&!\u001c\u000e\u0005\u0005\u0005$\u0002BA2\u0003K\na!\u0019;p[&\u001c'\u0002BA4\u0003S\n!bY8oGV\u0014(/\u001a8u\u0015\r\tY\u0007Z\u0001\u0005kRLG.\u0003\u0003\u0002p\u0005\u0005$AC!u_6L7\rT8oO\u0006A1m\\;oi\u0016\u0014\b%\u0001\niC:$G.\u001a#jg.\u001c\u0006/Y2f\u0019><H\u0003BA<\u0003{\u00022aQA=\u0013\r\tY\b\u0012\u0002\u0005+:LG\u000f\u0003\u0004\u0002\u0000Y\u0002\rAT\u0001\u0019G\u0006\u0004\b/\u001a3Rk>$\u0018-\u00138CsR,7\u000fU3s'\u0016\u001c\u0017\u0001\u00075b]\u0012dW\rR5tWN\u0003\u0018mY3SK\u000e|g/\u001a:fIR\u0011\u0011qO\u0001\rO\u0016$H\u000b\u001b:piRdWM\u001d\u000b\u000b\u0003\u0013\u000by)!%\u0002\u001a\u0006u\u0006cA&\u0002\f&\u0019\u0011Q\u0012\u001f\u0003/\u0011K7o[+tC\u001e,')Y:fIRC'o\u001c;uY\u0016\u0014\b\"CA\u0002qA\u0005\t\u0019AA\u0004\u0011\u001d\ty\u0001\u000fa\u0001\u0003'\u0003B!!\u0006\u0002\u0016&!\u0011qSA\f\u0005\u0011!\u0016.\\3\t\u000f\u0005m\u0005\b1\u0001\u0002\u001e\u0006qQn\\2l\r&dWm\u0015;pe\u0016\u001c\bCBAP\u0003S\u000biK\u0004\u0003\u0002\"\u0006\u0015fb\u0001;\u0002$&\tQ)C\u0002\u0002(\u0012\u000bq\u0001]1dW\u0006<W-C\u0002`\u0003WS1!a*E!\u0011\ty+!/\u000e\u0005\u0005E&\u0002BAZ\u0003k\u000bAAZ5mK*\u0019\u0011q\u00173\u0002\u00079Lw.\u0003\u0003\u0002<\u0006E&!\u0003$jY\u0016\u001cFo\u001c:f\u0011%\ty\f\u000fI\u0001\u0002\u0004\t\t-A\u0006mSN$XM\\3s\u001fB$\b#B\"\u0002D\u0006\u0005\u0013bAAc\t\n1q\n\u001d;j_:\facZ3u)\"\u0014x\u000e\u001e;mKJ$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0017TC!a\u0002\u0002N.\u0012\u0011q\u001a\t\u0005\u0003#\fY.\u0004\u0002\u0002T*!\u0011Q[Al\u0003%)hn\u00195fG.,GMC\u0002\u0002Z\u0012\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\ti.a5\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\fhKR$\u0006N]8ui2,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\t\u0019O\u000b\u0003\u0002B\u00065\u0017!\u00037jgR,g.\u001a:!\u00031!\bN]8ui2,'o\u00149u+\t\tY\u000fE\u0003D\u0003\u0007\fI)\u0001\tuQJ|G\u000f\u001e7fe>\u0003Ho\u0018\u0013fcR!\u0011qOAy\u0011%\t\u0019pFA\u0001\u0002\u0004\tY/A\u0002yIE\nQ\u0002\u001e5s_R$H.\u001a:PaR\u0004\u0013!B:fiV\u0004\bfA\r\u0002|B!\u0011Q B\u0006\u001b\t\tyP\u0003\u0003\u0003\u0002\t\r\u0011aA1qS*!!Q\u0001B\u0004\u0003\u001dQW\u000f]5uKJTAA!\u0003\u0002$\u0005)!.\u001e8ji&!!QBA\u0000\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fZ8x]\"\u001a!Da\u0005\u0011\t\u0005u(QC\u0005\u0005\u0005/\tyPA\u0005BMR,'/R1dQ\u0006\tB/Z:u\t\u00164\u0017-\u001e7u\u0007>tg-[4)\u0007m\u0011i\u0002\u0005\u0003\u0002~\n}\u0011\u0002\u0002B\u0011\u0003\u007f\u0014A\u0001V3ti\u0006qB/Z:u\u0007>tg-[4SK*,7\r^:JY2,w-\u00197WC2,Xm\u001d\u0015\u00049\tu\u0011a\b;fgR\u001cuN\u001c4jOJ+'.Z2ug:+w-\u0019;jm\u00164\u0016\r\\;fg\"\u001aQD!\b\u0002CQ,7\u000f^#naRLHj\\4ESJ\u001cH)[:bE2,G\u000b\u001b:piRd\u0017N\\4)\u0007y\u0011i\"\u0001\fuKN$H*[:uK:,'OU3hSN$XM]3eQ\ry\"QD\u0001\u0017i\u0016\u001cH\u000fS1oI2,G)[:l'B\f7-\u001a'po\"\u001a\u0001E!\b\u00021Q,7\u000f^\"baZ\u000bG.^3t\u001f:d\u0015n\u001d;f]\u0016\u00148\u000fK\u0002\"\u0005;\tA\u0004^3ti\"\u000bg\u000e\u001a7f\t&\u001c8n\u00159bG\u0016\u0014VmY8wKJ,G\rK\u0002#\u0005;\ta\u0003^3ti6Kg\u000eR5tWV\u001b\u0018M\u00197f\u0005f$Xm\u001d\u0015\u0004G\tu\u0011!\u0006;fgRl\u0015N\u001c#jg.$v\u000e^1m\u0005f$Xm\u001d\u0015\u0004I\tu\u0011a\u0005;fgR\u0014\u0015m]5d)\"\u0014x\u000e\u001e;mS:<\u0007fA\u0013\u0003\u001e\u00059C/Z:u)\"\u0014x.^4iaV$\u0018j]+qI\u0006$X\r\u001a#ve&tw\r\u00165s_R$H.\u001b8hQ\r1#QD\u0001\u001ai\u0016\u001cH/\u00128bE2,g\t\\1h\u0013N\u0014Vm\u001d9fGR,G\rK\u0002(\u0005;\t1\u0003^3tiRKW.Z%t%\u0016\u001c\b/Z2uK\u0012D3\u0001\u000bB\u000f\u0003Y\"Xm\u001d;ESN\\G\u000b\u001b:piRd\u0017N\\4Jg&sG-\u001a9f]\u0012,g\u000e\u001e$s_6\u0004&o\u001c3vG\u0016\u0014\u0015mY6qe\u0016\u001c8/\u001e:fQ\rI#QD\u0001\u001bi\u0016\u001cH/\u00118z\u0019&\u001cH/\u001a8fe&\u001bH\u000b\u001b:piRdW\r\u001a\u0015\u0004U\tu\u0011\u0001F<ji\"d\u0015M]4f\r&dWm\u0016:jiR,g\u000e\u0006\u0004\u0002x\t\r$Q\u000e\u0005\b\u0005KZ\u0003\u0019\u0001B4\u0003\u0015IgN\\3s!\u0019\u0019%\u0011\u000e(\u0002x%\u0019!1\u000e#\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0002\u0003B8WA\u0005\t\u0019\u0001(\u0002\u0011\u0019LG.Z*ju\u0016\fad^5uQ2\u000b'oZ3GS2,wK]5ui\u0016tG\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\tU$f\u0001(\u0002N\u0002")
public class DiskUsageBasedThrottlerTest {
    private final long throughput;
    private final long threshold;
    private final long largeFileSize;
    private final scala.collection.immutable.Seq<String> logDirs = new .colon.colon((Object)"/some/fileA", (List)new .colon.colon((Object)"/some/fileB", (List)Nil$.MODULE$));
    private final long defaultTotalBytes;
    private final long initialUsableBytes;
    private final scala.collection.immutable.Seq<TestUtils.DeterministicFileStore> kafka$server$DiskUsageBasedThrottlerTest$$fileStores = new .colon.colon((Object)new TestUtils.DeterministicFileStore(this.defaultTotalBytes(), this.initialUsableBytes()), (List)new .colon.colon((Object)new TestUtils.DeterministicFileStore(this.defaultTotalBytes(), this.initialUsableBytes()), (List)Nil$.MODULE$));
    private final DiskUsageBasedThrottlingConfig config = DiskUsageBasedThrottlingConfig$.MODULE$.apply(this.threshold(), this.throughput(), this.logDirs(), true, 500L, 1.5, false);
    private final MockTime kafka$server$DiskUsageBasedThrottlerTest$$mockTime = new MockTime();
    private final TestableDiskUsageBasedThrottleListener kafka$server$DiskUsageBasedThrottlerTest$$listener = new TestableDiskUsageBasedThrottleListener();
    private Option<DiskUsageBasedThrottler> throttlerOpt;

    public static Option<DiskUsageBasedThrottleListener> getThrottler$default$4() {
        return None$.MODULE$;
    }

    public static DiskUsageBasedThrottlingConfig getThrottler$default$1() {
        return DiskUsageBasedThrottlerTest$.MODULE$.getThrottler$default$1();
    }

    public static DiskUsageBasedThrottler getThrottler(DiskUsageBasedThrottlingConfig config, Time mockTime, scala.collection.immutable.Seq<FileStore> mockFileStores, Option<DiskUsageBasedThrottleListener> listenerOpt) {
        return new DiskUsageBasedThrottler(config, mockTime, mockFileStores, listenerOpt){
            private final DiskThrottleListenerManager listenerManager;
            private volatile DiskUsageBasedThrottlingConfig kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig;
            private AtomicLong kafka$server$DiskUsageBasedThrottler$$lastCheckedTime;
            private KafkaMetricsGroup kafka$server$DiskUsageBasedThrottler$$metricsGroup;
            private volatile Seq<FileStore> kafka$server$DiskUsageBasedThrottler$$fileStores;
            private volatile long producerThrottleRate;
            private volatile long kafka$server$DiskUsageBasedThrottler$$clusterLinkThrottleRate;
            private volatile long followerThrottleRate;
            private Logger logger;
            private String logIdent;
            private volatile boolean bitmap$0;
            private final DiskUsageBasedThrottlingConfig config$1;
            private final Time mockTime$1;
            private final scala.collection.immutable.Seq mockFileStores$1;

            public void createDiskThrottlerMetrics() {
                DiskUsageBasedThrottler.createDiskThrottlerMetrics$((DiskUsageBasedThrottler)this);
            }

            public void removeDiskThrottlerMetrics() {
                DiskUsageBasedThrottler.removeDiskThrottlerMetrics$((DiskUsageBasedThrottler)this);
            }

            public void updateDiskThrottlingConfig(DiskUsageBasedThrottlingConfig newConfig) {
                DiskUsageBasedThrottler.updateDiskThrottlingConfig$((DiskUsageBasedThrottler)this, (DiskUsageBasedThrottlingConfig)newConfig);
            }

            public boolean diskThrottlingEnabledInConfig(DiskUsageBasedThrottlingConfig config) {
                return DiskUsageBasedThrottler.diskThrottlingEnabledInConfig$((DiskUsageBasedThrottler)this, (DiskUsageBasedThrottlingConfig)config);
            }

            public long minDiskTotalBytes() {
                return DiskUsageBasedThrottler.minDiskTotalBytes$((DiskUsageBasedThrottler)this);
            }

            public long minDiskUsableBytes() {
                return DiskUsageBasedThrottler.minDiskUsableBytes$((DiskUsageBasedThrottler)this);
            }

            public void checkAndUpdateQuotaOnDiskUsage(long timeMs) {
                DiskUsageBasedThrottler.checkAndUpdateQuotaOnDiskUsage$((DiskUsageBasedThrottler)this, (long)timeMs);
            }

            public void initThrottler() {
                DiskUsageBasedThrottler.initThrottler$((DiskUsageBasedThrottler)this);
            }

            public DiskUsageBasedThrottlingConfig getCurrentDiskThrottlingConfig() {
                return DiskUsageBasedThrottler.getCurrentDiskThrottlingConfig$((DiskUsageBasedThrottler)this);
            }

            public String loggerName() {
                return Logging.loggerName$((Logging)this);
            }

            public String msgWithLogIdent(String msg) {
                return Logging.msgWithLogIdent$((Logging)this, (String)msg);
            }

            public void trace(Function0<String> msg) {
                Logging.trace$((Logging)this, msg);
            }

            public void trace(Function0<String> msg, Function0<Throwable> e) {
                Logging.trace$((Logging)this, msg, e);
            }

            public boolean isDebugEnabled() {
                return Logging.isDebugEnabled$((Logging)this);
            }

            public boolean isTraceEnabled() {
                return Logging.isTraceEnabled$((Logging)this);
            }

            public void debug(Function0<String> msg) {
                Logging.debug$((Logging)this, msg);
            }

            public void debug(Function0<String> msg, Function0<Throwable> e) {
                Logging.debug$((Logging)this, msg, e);
            }

            public void info(Function0<String> msg) {
                Logging.info$((Logging)this, msg);
            }

            public void info(Function0<String> msg, Function0<Throwable> e) {
                Logging.info$((Logging)this, msg, e);
            }

            public void warn(Function0<String> msg) {
                Logging.warn$((Logging)this, msg);
            }

            public void warn(Function0<String> msg, Function0<Throwable> e) {
                Logging.warn$((Logging)this, msg, e);
            }

            public void error(Function0<String> msg) {
                Logging.error$((Logging)this, msg);
            }

            public void error(Function0<String> msg, Function0<Throwable> e) {
                Logging.error$((Logging)this, msg, e);
            }

            public void fatal(Function0<String> msg) {
                Logging.fatal$((Logging)this, msg);
            }

            public void fatal(Function0<String> msg, Function0<Throwable> e) {
                Logging.fatal$((Logging)this, msg, e);
            }

            public DiskUsageBasedThrottlingConfig kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig() {
                return this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig;
            }

            public void kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig_$eq(DiskUsageBasedThrottlingConfig x$1) {
                this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig = x$1;
            }

            public AtomicLong kafka$server$DiskUsageBasedThrottler$$lastCheckedTime() {
                return this.kafka$server$DiskUsageBasedThrottler$$lastCheckedTime;
            }

            public KafkaMetricsGroup kafka$server$DiskUsageBasedThrottler$$metricsGroup() {
                return this.kafka$server$DiskUsageBasedThrottler$$metricsGroup;
            }

            public Seq<FileStore> kafka$server$DiskUsageBasedThrottler$$fileStores() {
                return this.kafka$server$DiskUsageBasedThrottler$$fileStores;
            }

            public void kafka$server$DiskUsageBasedThrottler$$fileStores_$eq(Seq<FileStore> x$1) {
                this.kafka$server$DiskUsageBasedThrottler$$fileStores = x$1;
            }

            public long producerThrottleRate() {
                return this.producerThrottleRate;
            }

            public void producerThrottleRate_$eq(long x$1) {
                this.producerThrottleRate = x$1;
            }

            public long kafka$server$DiskUsageBasedThrottler$$clusterLinkThrottleRate() {
                return this.kafka$server$DiskUsageBasedThrottler$$clusterLinkThrottleRate;
            }

            public void kafka$server$DiskUsageBasedThrottler$$clusterLinkThrottleRate_$eq(long x$1) {
                this.kafka$server$DiskUsageBasedThrottler$$clusterLinkThrottleRate = x$1;
            }

            public long followerThrottleRate() {
                return this.followerThrottleRate;
            }

            public void followerThrottleRate_$eq(long x$1) {
                this.followerThrottleRate = x$1;
            }

            public final void kafka$server$DiskUsageBasedThrottler$_setter_$kafka$server$DiskUsageBasedThrottler$$lastCheckedTime_$eq(AtomicLong x$1) {
                this.kafka$server$DiskUsageBasedThrottler$$lastCheckedTime = x$1;
            }

            public final void kafka$server$DiskUsageBasedThrottler$_setter_$kafka$server$DiskUsageBasedThrottler$$metricsGroup_$eq(KafkaMetricsGroup x$1) {
                this.kafka$server$DiskUsageBasedThrottler$$metricsGroup = x$1;
            }

            public void kafka$server$DiskUsageBasedThrottler$_setter_$listenerManager_$eq(DiskThrottleListenerManager x$1) {
            }

            private Logger logger$lzycompute() {
                synchronized (this) {
                    if (!this.bitmap$0) {
                        this.logger = Logging.logger$((Logging)this);
                        this.bitmap$0 = true;
                    }
                }
                return this.logger;
            }

            public Logger logger() {
                if (!this.bitmap$0) {
                    return this.logger$lzycompute();
                }
                return this.logger;
            }

            public String logIdent() {
                return this.logIdent;
            }

            public void logIdent_$eq(String x$1) {
                this.logIdent = x$1;
            }

            public DiskUsageBasedThrottlingConfig diskThrottlingConfig() {
                return this.config$1;
            }

            public Time time() {
                return this.mockTime$1;
            }

            public Seq<FileStore> getFileStores() {
                return this.mockFileStores$1;
            }

            public DiskThrottleListenerManager listenerManager() {
                return this.listenerManager;
            }

            public static final /* synthetic */ void $anonfun$listenerManager$1(DiskThrottleListenerManager manager$1, DiskUsageBasedThrottleListener listener) {
                manager$1.registerListener(listener);
            }
            {
                this.config$1 = config$1;
                this.mockTime$1 = mockTime$1;
                this.mockFileStores$1 = mockFileStores$1;
                DiskUsageBasedThrottler.$init$((DiskUsageBasedThrottler)this);
                DiskThrottleListenerManager manager = new DiskThrottleListenerManager(null){
                    private ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> kafka$server$DiskThrottleListenerManager$$listeners;

                    public void registerListener(DiskUsageBasedThrottleListener listener) {
                        DiskThrottleListenerManager.registerListener$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public void deRegisterListener(DiskUsageBasedThrottleListener listener) {
                        DiskThrottleListenerManager.deRegisterListener$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public Set<DiskUsageBasedThrottleListener> getListeners() {
                        return DiskThrottleListenerManager.getListeners$((DiskThrottleListenerManager)this);
                    }

                    public boolean anyListenerIsThrottled() {
                        return DiskThrottleListenerManager.anyListenerIsThrottled$((DiskThrottleListenerManager)this);
                    }

                    public boolean diskThrottlingActive(DiskUsageBasedThrottleListener listener) {
                        return DiskThrottleListenerManager.diskThrottlingActive$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> kafka$server$DiskThrottleListenerManager$$listeners() {
                        return this.kafka$server$DiskThrottleListenerManager$$listeners;
                    }

                    public final void kafka$server$DiskThrottleListenerManager$_setter_$kafka$server$DiskThrottleListenerManager$$listeners_$eq(ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> x$1) {
                        this.kafka$server$DiskThrottleListenerManager$$listeners = x$1;
                    }
                    {
                        DiskThrottleListenerManager.$init$((DiskThrottleListenerManager)this);
                        Statics.releaseFence();
                    }
                };
                listenerOpt$1.foreach((Function1 & Serializable)listener -> {
                    $anon$4.$anonfun$listenerManager$1(manager, listener);
                    return BoxedUnit.UNIT;
                });
                this.listenerManager = manager;
                Statics.releaseFence();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$listenerManager$1$adapted(kafka.server.DiskThrottleListenerManager kafka.server.DiskUsageBasedThrottleListener )}, serializedLambda);
            }
        };
    }

    private long throughput() {
        return this.throughput;
    }

    private long threshold() {
        return this.threshold;
    }

    private long largeFileSize() {
        return this.largeFileSize;
    }

    private scala.collection.immutable.Seq<String> logDirs() {
        return this.logDirs;
    }

    private long defaultTotalBytes() {
        return this.defaultTotalBytes;
    }

    private long initialUsableBytes() {
        return this.initialUsableBytes;
    }

    public scala.collection.immutable.Seq<TestUtils.DeterministicFileStore> kafka$server$DiskUsageBasedThrottlerTest$$fileStores() {
        return this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores;
    }

    private DiskUsageBasedThrottlingConfig config() {
        return this.config;
    }

    public MockTime kafka$server$DiskUsageBasedThrottlerTest$$mockTime() {
        return this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime;
    }

    public TestableDiskUsageBasedThrottleListener kafka$server$DiskUsageBasedThrottlerTest$$listener() {
        return this.kafka$server$DiskUsageBasedThrottlerTest$$listener;
    }

    private Option<DiskUsageBasedThrottler> throttlerOpt() {
        return this.throttlerOpt;
    }

    private void throttlerOpt_$eq(Option<DiskUsageBasedThrottler> x$1) {
        this.throttlerOpt = x$1;
    }

    @BeforeEach
    public void setup() {
        this.throttlerOpt_$eq((Option<DiskUsageBasedThrottler>)None$.MODULE$);
    }

    @AfterEach
    public void teardown() {
        this.throttlerOpt().foreach((Function1 & Serializable)x$2 -> {
            DiskUsageBasedThrottlerTest.$anonfun$teardown$1(this, x$2);
            return BoxedUnit.UNIT;
        });
        this.throttlerOpt().foreach((Function1 & Serializable)x$3 -> {
            x$3.removeDiskThrottlerMetrics();
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDefaultConfig() {
        DiskUsageBasedThrottlingConfig defaultConfig = DiskUsageBasedThrottlingConfig$.MODULE$.apply(0x500000000L, 131072L, (Seq)Seq$.MODULE$.empty(), false, DiskUsageBasedThrottlingConfig$.MODULE$.DefaultDiskCheckFrequencyMs(), 1.5, false);
        Assertions.assertFalse((boolean)defaultConfig.enableDiskBasedThrottling());
        Assertions.assertEquals((long)0x500000000L, (long)defaultConfig.freeDiskThresholdBytes());
        Assertions.assertEquals((long)131072L, (long)defaultConfig.throttledProduceThroughput());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)defaultConfig.logDirs());
    }

    @Test
    public void testConfigRejectsIllegalValues() {
        DiskUsageBasedThrottlingConfig configWithIllegalValues = DiskUsageBasedThrottlingConfig$.MODULE$.apply(10L, 42L, (Seq)Seq$.MODULE$.empty(), false, DiskUsageBasedThrottlingConfig$.MODULE$.DefaultDiskCheckFrequencyMs(), 1.5, false);
        Assertions.assertEquals((long)DiskUsageBasedThrottlingConfig$.MODULE$.MinDiskThresholdBytes(), (long)configWithIllegalValues.freeDiskThresholdBytes());
        Assertions.assertEquals((long)DiskUsageBasedThrottlingConfig$.MODULE$.MinThroughputBytesPerSec(), (long)configWithIllegalValues.throttledProduceThroughput());
    }

    @Test
    public void testConfigRejectsNegativeValues() {
        DiskUsageBasedThrottlingConfig configWithIllegalValues = DiskUsageBasedThrottlingConfig$.MODULE$.apply(-10L, -42L, (Seq)Seq$.MODULE$.empty(), false, DiskUsageBasedThrottlingConfig$.MODULE$.DefaultDiskCheckFrequencyMs(), 1.5, false);
        Assertions.assertEquals((long)DiskUsageBasedThrottlingConfig$.MODULE$.MinDiskThresholdBytes(), (long)configWithIllegalValues.freeDiskThresholdBytes());
        Assertions.assertEquals((long)DiskUsageBasedThrottlingConfig$.MODULE$.MinThroughputBytesPerSec(), (long)configWithIllegalValues.throttledProduceThroughput());
    }

    @Test
    public void testEmptyLogDirsDisableThrottling() {
        scala.collection.immutable.Seq x$1 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        long x$3 = 0x500000000L;
        long x$4 = 131072L;
        DiskUsageBasedThrottlingConfig$ apply$default$5_this = DiskUsageBasedThrottlingConfig$.MODULE$;
        Object var12_4 = null;
        long x$5 = apply$default$5_this.DefaultDiskCheckFrequencyMs();
        double x$6 = 1.5;
        boolean x$7 = false;
        DiskUsageBasedThrottlingConfig configWithEmptyLogDirs = DiskUsageBasedThrottlingConfig$.MODULE$.apply(x$3, x$4, (Seq)x$1, true, x$5, x$6, x$7);
        Assertions.assertFalse((boolean)configWithEmptyLogDirs.enableDiskBasedThrottling());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)configWithEmptyLogDirs.logDirs());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListenerRegistered() {
        void getThrottler_listenerOpt;
        void getThrottler_mockFileStores;
        void getThrottler_mockTime;
        TestableDiskUsageBasedThrottleListener newListener = new TestableDiskUsageBasedThrottleListener();
        None$ none$ = None$.MODULE$;
        scala.collection.immutable.Seq<TestUtils.DeterministicFileStore> seq = this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores();
        MockTime mockTime = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime();
        DiskUsageBasedThrottlingConfig getThrottler_config = this.config();
        Object var3_5 = null;
        mockTime = null;
        seq = null;
        none$ = null;
        DiskUsageBasedThrottler throttler = new /* invalid duplicate definition of identical inner class */;
        throttler.listenerManager().registerListener((DiskUsageBasedThrottleListener)newListener);
        Assertions.assertTrue((boolean)throttler.listenerManager().getListeners().contains((Object)newListener));
        throttler.listenerManager().deRegisterListener((DiskUsageBasedThrottleListener)newListener);
        Assertions.assertFalse((boolean)throttler.listenerManager().getListeners().contains((Object)newListener));
    }

    @Test
    public void testHandleDiskSpaceLow() {
        this.kafka$server$DiskUsageBasedThrottlerTest$$listener().handleDiskSpaceLow(this.throughput());
        Assertions.assertEquals((long)this.throughput(), (long)this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCapValuesOnListeners() {
        void getThrottler_listenerOpt;
        void getThrottler_mockFileStores;
        void getThrottler_mockTime;
        TestableDiskUsageBasedThrottleListener produceListener = new TestableDiskUsageBasedThrottleListener();
        TestableDiskUsageBasedThrottleListener followerListener = new TestableDiskUsageBasedThrottleListener(null){
            private final QuotaType quotaType;

            public QuotaType quotaType() {
                return this.quotaType;
            }
            {
                this.quotaType = QuotaType.FollowerReplication$.MODULE$;
            }
        };
        None$ none$ = None$.MODULE$;
        scala.collection.immutable.Seq<TestUtils.DeterministicFileStore> seq = this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores();
        MockTime mockTime = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime();
        DiskUsageBasedThrottlingConfig getThrottler_config = this.config();
        Object var7_6 = null;
        mockTime = null;
        seq = null;
        none$ = null;
        DiskUsageBasedThrottler throttler = new /* invalid duplicate definition of identical inner class */;
        throttler.listenerManager().registerListener((DiskUsageBasedThrottleListener)produceListener);
        throttler.listenerManager().registerListener((DiskUsageBasedThrottleListener)followerListener);
        Predef$.MODULE$.println((Object)throttler.listenerManager().getListeners());
        DiskUsageBasedThrottler.createDiskThrottlerMetrics$((DiskUsageBasedThrottler)throttler);
        this.throttlerOpt_$eq((Option<DiskUsageBasedThrottler>)new Some((Object)throttler));
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        TestUtils.DeterministicFileStore withLargeFileWritten_fileStore = (TestUtils.DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testCapValuesOnListeners$1(this, throttler, produceListener, followerListener, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
        Object var6_9 = null;
        throttler.listenerManager().deRegisterListener((DiskUsageBasedThrottleListener)produceListener);
        throttler.listenerManager().deRegisterListener((DiskUsageBasedThrottleListener)followerListener);
    }

    @Test
    public void testHandleDiskSpaceRecovered() {
        this.kafka$server$DiskUsageBasedThrottlerTest$$listener().handleDiskSpaceRecovered();
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMinDiskUsableBytes() {
        void getThrottler_listenerOpt;
        void getThrottler_mockFileStores;
        void getThrottler_mockTime;
        None$ none$ = None$.MODULE$;
        scala.collection.immutable.Seq<TestUtils.DeterministicFileStore> seq = this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores();
        MockTime mockTime = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime();
        DiskUsageBasedThrottlingConfig getThrottler_config = this.config();
        Object var7_4 = null;
        mockTime = null;
        seq = null;
        none$ = null;
        DiskUsageBasedThrottler throttler = new /* invalid duplicate definition of identical inner class */;
        long previousUsableSpaceBytes = DiskUsageBasedThrottler.minDiskUsableBytes$((DiskUsageBasedThrottler)throttler);
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        TestUtils.DeterministicFileStore withLargeFileWritten_fileStore = (TestUtils.DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testMinDiskUsableBytes$1(this, throttler, previousUsableSpaceBytes, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMinDiskTotalBytes() {
        void getThrottler_listenerOpt;
        void getThrottler_mockFileStores;
        void getThrottler_mockTime;
        None$ none$ = None$.MODULE$;
        scala.collection.immutable.Seq<TestUtils.DeterministicFileStore> seq = this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores();
        MockTime mockTime = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime();
        DiskUsageBasedThrottlingConfig getThrottler_config = this.config();
        Object var7_4 = null;
        mockTime = null;
        seq = null;
        none$ = null;
        DiskUsageBasedThrottler throttler = new /* invalid duplicate definition of identical inner class */;
        long existingTotalBytes = DiskUsageBasedThrottler.minDiskTotalBytes$((DiskUsageBasedThrottler)throttler);
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        TestUtils.DeterministicFileStore withLargeFileWritten_fileStore = (TestUtils.DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testMinDiskTotalBytes$1(throttler, existingTotalBytes, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBasicThrottling() {
        void getThrottler_listenerOpt;
        void getThrottler_mockFileStores;
        void getThrottler_mockTime;
        long threshold = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.getUsableSpace()))).min((Ordering)Ordering.Long$.MODULE$)) - this.largeFileSize() + 1L;
        Some some = new Some((Object)this.kafka$server$DiskUsageBasedThrottlerTest$$listener());
        scala.collection.immutable.Seq<TestUtils.DeterministicFileStore> seq = this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores();
        MockTime mockTime = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime();
        DiskUsageBasedThrottlingConfig getThrottler_config = this.config().copy(threshold, this.config().copy$default$2(), this.config().copy$default$3(), this.config().copy$default$4(), this.config().copy$default$5(), this.config().copy$default$6(), this.config().copy$default$7());
        Object var7_5 = null;
        mockTime = null;
        seq = null;
        some = null;
        DiskUsageBasedThrottler throttler = new /* invalid duplicate definition of identical inner class */;
        DiskUsageBasedThrottler.createDiskThrottlerMetrics$((DiskUsageBasedThrottler)throttler);
        this.throttlerOpt_$eq((Option<DiskUsageBasedThrottler>)new Some((Object)throttler));
        long checkAndUpdateQuotaOnDiskUsage_timeMs = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds();
        DiskUsageBasedThrottler.checkAndUpdateQuotaOnDiskUsage$((DiskUsageBasedThrottler)throttler, (long)checkAndUpdateQuotaOnDiskUsage_timeMs);
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertFalse((boolean)throttler.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)0L, (long)throttler.producerThrottleRate());
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        TestUtils.DeterministicFileStore withLargeFileWritten_fileStore = (TestUtils.DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testBasicThrottling$2(this, throttler, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
        Object var6_9 = null;
        long checkAndUpdateQuotaOnDiskUsage_timeMs2 = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds();
        DiskUsageBasedThrottler.checkAndUpdateQuotaOnDiskUsage$((DiskUsageBasedThrottler)throttler, (long)checkAndUpdateQuotaOnDiskUsage_timeMs2);
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertFalse((boolean)throttler.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)0L, (long)throttler.producerThrottleRate());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testThroughputIsUpdatedDuringThrottling() {
        void getThrottler_listenerOpt;
        void getThrottler_mockFileStores;
        void getThrottler_mockTime;
        long threshold = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.getUsableSpace()))).min((Ordering)Ordering.Long$.MODULE$)) - this.largeFileSize() + 1L;
        Some some = new Some((Object)this.kafka$server$DiskUsageBasedThrottlerTest$$listener());
        scala.collection.immutable.Seq<TestUtils.DeterministicFileStore> seq = this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores();
        MockTime mockTime = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime();
        DiskUsageBasedThrottlingConfig getThrottler_config = this.config().copy(threshold, this.config().copy$default$2(), this.config().copy$default$3(), this.config().copy$default$4(), this.config().copy$default$5(), this.config().copy$default$6(), this.config().copy$default$7());
        Object var7_5 = null;
        mockTime = null;
        seq = null;
        some = null;
        DiskUsageBasedThrottler throttler = new /* invalid duplicate definition of identical inner class */;
        DiskUsageBasedThrottler.createDiskThrottlerMetrics$((DiskUsageBasedThrottler)throttler);
        this.throttlerOpt_$eq((Option<DiskUsageBasedThrottler>)new Some((Object)throttler));
        long checkAndUpdateQuotaOnDiskUsage_timeMs = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds();
        DiskUsageBasedThrottler.checkAndUpdateQuotaOnDiskUsage$((DiskUsageBasedThrottler)throttler, (long)checkAndUpdateQuotaOnDiskUsage_timeMs);
        Assertions.assertFalse((boolean)throttler.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)0L, (long)throttler.producerThrottleRate());
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        TestUtils.DeterministicFileStore withLargeFileWritten_fileStore = (TestUtils.DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testThroughputIsUpdatedDuringThrottling$2(this, throttler, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testEnableFlagIsRespected() {
        void getThrottler_listenerOpt;
        void getThrottler_mockFileStores;
        void getThrottler_mockTime;
        long threshold = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.getUsableSpace()))).min((Ordering)Ordering.Long$.MODULE$)) - this.largeFileSize() + 1L;
        long x$3 = this.config().copy$default$2();
        Seq x$4 = this.config().copy$default$3();
        long x$5 = this.config().copy$default$5();
        double x$6 = this.config().copy$default$6();
        boolean x$7 = this.config().copy$default$7();
        None$ none$ = None$.MODULE$;
        scala.collection.immutable.Seq<TestUtils.DeterministicFileStore> seq = this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores();
        MockTime mockTime = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime();
        DiskUsageBasedThrottlingConfig getThrottler_config = this.config().copy(threshold, x$3, x$4, false, x$5, x$6, x$7);
        Object var15_10 = null;
        mockTime = null;
        seq = null;
        none$ = null;
        DiskUsageBasedThrottler throttler = new /* invalid duplicate definition of identical inner class */;
        DiskUsageBasedThrottler.createDiskThrottlerMetrics$((DiskUsageBasedThrottler)throttler);
        this.throttlerOpt_$eq((Option<DiskUsageBasedThrottler>)new Some((Object)throttler));
        long checkAndUpdateQuotaOnDiskUsage_timeMs = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds();
        DiskUsageBasedThrottler.checkAndUpdateQuotaOnDiskUsage$((DiskUsageBasedThrottler)throttler, (long)checkAndUpdateQuotaOnDiskUsage_timeMs);
        Assertions.assertFalse((boolean)throttler.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)0L, (long)throttler.producerThrottleRate());
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        TestUtils.DeterministicFileStore withLargeFileWritten_fileStore = (TestUtils.DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testEnableFlagIsRespected$2(this, throttler, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTimeIsRespected() {
        void getThrottler_listenerOpt;
        void getThrottler_mockFileStores;
        void getThrottler_mockTime;
        long threshold = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.getUsableSpace()))).min((Ordering)Ordering.Long$.MODULE$)) - this.largeFileSize() + 1L;
        long x$3 = this.config().copy$default$2();
        Seq x$4 = this.config().copy$default$3();
        boolean x$5 = this.config().copy$default$4();
        double x$6 = this.config().copy$default$6();
        boolean x$7 = this.config().copy$default$7();
        Some some = new Some((Object)this.kafka$server$DiskUsageBasedThrottlerTest$$listener());
        scala.collection.immutable.Seq<TestUtils.DeterministicFileStore> seq = this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores();
        MockTime mockTime = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime();
        DiskUsageBasedThrottlingConfig getThrottler_config = this.config().copy(threshold, x$3, x$4, x$5, 1000L, x$6, x$7);
        Object var14_10 = null;
        mockTime = null;
        seq = null;
        some = null;
        DiskUsageBasedThrottler throttler = new /* invalid duplicate definition of identical inner class */;
        DiskUsageBasedThrottler.createDiskThrottlerMetrics$((DiskUsageBasedThrottler)throttler);
        this.throttlerOpt_$eq((Option<DiskUsageBasedThrottler>)new Some((Object)throttler));
        long checkAndUpdateQuotaOnDiskUsage_timeMs = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds();
        DiskUsageBasedThrottler.checkAndUpdateQuotaOnDiskUsage$((DiskUsageBasedThrottler)throttler, (long)checkAndUpdateQuotaOnDiskUsage_timeMs);
        Assertions.assertFalse((boolean)throttler.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)0L, (long)throttler.producerThrottleRate());
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        TestUtils.DeterministicFileStore withLargeFileWritten_fileStore = (TestUtils.DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testTimeIsRespected$2(this, throttler, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
    }

    @Test
    public void testDiskThrottlingIsIndependentFromProduceBackpressure() {
        BrokerBackpressureConfig x$1 = new BrokerBackpressureConfig(false, BrokerBackpressureConfig$.MODULE$.DefaultBackpressureCheckFrequencyMs(), (Seq)Nil$.MODULE$, Double.MAX_VALUE, (double)Predef$.MODULE$.Long2long(ConfluentConfigs.BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_DEFAULT), "p95");
        DiskUsageBasedThrottlingConfig x$2 = this.config();
        int x$3 = Defaults$.MODULE$.DefaultNumQuotaSamples();
        int x$4 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        double x$5 = 9.223372036854776E18;
        long x$6 = 0L;
        int x$7 = 0;
        long x$8 = Long.MAX_VALUE;
        ClientQuotaManagerConfig quotaManagerConfig = new ClientQuotaManagerConfig(x$3, x$4, x$1, x$2, x$5, x$6, x$7, x$8);
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this, quotaManagerConfig){
            private final DiskThrottleListenerManager listenerManager;
            private final /* synthetic */ DiskUsageBasedThrottlerTest $outer;

            public Seq<FileStore> getFileStores() {
                return this.$outer.kafka$server$DiskUsageBasedThrottlerTest$$fileStores();
            }

            public DiskThrottleListenerManager listenerManager() {
                return this.listenerManager;
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(quotaManagerConfig$1, new Metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)$outer.kafka$server$DiskUsageBasedThrottlerTest$$mockTime(), "someThread", (Option)None$.MODULE$, (Option)None$.MODULE$);
                DiskThrottleListenerManager manager = new DiskThrottleListenerManager(null){
                    private ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> kafka$server$DiskThrottleListenerManager$$listeners;

                    public void registerListener(DiskUsageBasedThrottleListener listener) {
                        DiskThrottleListenerManager.registerListener$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public void deRegisterListener(DiskUsageBasedThrottleListener listener) {
                        DiskThrottleListenerManager.deRegisterListener$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public Set<DiskUsageBasedThrottleListener> getListeners() {
                        return DiskThrottleListenerManager.getListeners$((DiskThrottleListenerManager)this);
                    }

                    public boolean anyListenerIsThrottled() {
                        return DiskThrottleListenerManager.anyListenerIsThrottled$((DiskThrottleListenerManager)this);
                    }

                    public boolean diskThrottlingActive(DiskUsageBasedThrottleListener listener) {
                        return DiskThrottleListenerManager.diskThrottlingActive$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> kafka$server$DiskThrottleListenerManager$$listeners() {
                        return this.kafka$server$DiskThrottleListenerManager$$listeners;
                    }

                    public final void kafka$server$DiskThrottleListenerManager$_setter_$kafka$server$DiskThrottleListenerManager$$listeners_$eq(ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> x$1) {
                        this.kafka$server$DiskThrottleListenerManager$$listeners = x$1;
                    }
                    {
                        DiskThrottleListenerManager.$init$((DiskThrottleListenerManager)this);
                        Statics.releaseFence();
                    }
                };
                TestableDiskUsageBasedThrottleListener registerListener_listener = $outer.kafka$server$DiskUsageBasedThrottlerTest$$listener();
                DiskThrottleListenerManager.registerListener$((DiskThrottleListenerManager)manager, (DiskUsageBasedThrottleListener)registerListener_listener);
                this.listenerManager = var3_3;
            }
        };
        clientQuotaManager.createDiskThrottlerMetrics();
        this.throttlerOpt_$eq((Option<DiskUsageBasedThrottler>)new Some((Object)clientQuotaManager));
        clientQuotaManager.listenerManager().registerListener((DiskUsageBasedThrottleListener)clientQuotaManager);
        clientQuotaManager.updateBrokerQuotaLimit(this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertFalse((boolean)clientQuotaManager.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertEquals((long)0L, (long)clientQuotaManager.producerThrottleRate());
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        TestUtils.DeterministicFileStore withLargeFileWritten_fileStore = (TestUtils.DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testDiskThrottlingIsIndependentFromProduceBackpressure$1(this, clientQuotaManager, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
        Object var16_12 = null;
        clientQuotaManager.updateBrokerQuotaLimit(this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertFalse((boolean)clientQuotaManager.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        clientQuotaManager.listenerManager().deRegisterListener((DiskUsageBasedThrottleListener)clientQuotaManager);
        Assertions.assertEquals((long)0L, (long)clientQuotaManager.producerThrottleRate());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAnyListenerIsThrottled() {
        void getThrottler_listenerOpt;
        void getThrottler_mockFileStores;
        void getThrottler_mockTime;
        long threshold = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToLong((long)x$15.getUsableSpace()))).min((Ordering)Ordering.Long$.MODULE$)) - this.largeFileSize() + 1L;
        Some some = new Some((Object)this.kafka$server$DiskUsageBasedThrottlerTest$$listener());
        scala.collection.immutable.Seq<TestUtils.DeterministicFileStore> seq = this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores();
        MockTime mockTime = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime();
        DiskUsageBasedThrottlingConfig getThrottler_config = this.config().copy(threshold, this.config().copy$default$2(), this.config().copy$default$3(), this.config().copy$default$4(), this.config().copy$default$5(), this.config().copy$default$6(), this.config().copy$default$7());
        Object var7_5 = null;
        mockTime = null;
        seq = null;
        some = null;
        DiskUsageBasedThrottler throttler = new /* invalid duplicate definition of identical inner class */;
        long checkAndUpdateQuotaOnDiskUsage_timeMs = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds();
        DiskUsageBasedThrottler.checkAndUpdateQuotaOnDiskUsage$((DiskUsageBasedThrottler)throttler, (long)checkAndUpdateQuotaOnDiskUsage_timeMs);
        Assertions.assertFalse((boolean)throttler.listenerManager().anyListenerIsThrottled());
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        TestUtils.DeterministicFileStore withLargeFileWritten_fileStore = (TestUtils.DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testAnyListenerIsThrottled$2(this, throttler, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
        Object var6_9 = null;
        long checkAndUpdateQuotaOnDiskUsage_timeMs2 = this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds();
        DiskUsageBasedThrottler.checkAndUpdateQuotaOnDiskUsage$((DiskUsageBasedThrottler)throttler, (long)checkAndUpdateQuotaOnDiskUsage_timeMs2);
        Assertions.assertFalse((boolean)throttler.listenerManager().anyListenerIsThrottled());
    }

    private void withLargeFileWritten(Function1<Object, BoxedUnit> inner, long fileSize) {
        TestUtils.DeterministicFileStore fileStore = (TestUtils.DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        fileStore.writeLargeFile(fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        inner.apply$mcVJ$sp(fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        fileStore.deleteLargeFile(fileSize);
    }

    private long withLargeFileWritten$default$2() {
        return this.largeFileSize();
    }

    public static final /* synthetic */ void $anonfun$teardown$1(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler x$2) {
        x$2.listenerManager().deRegisterListener((DiskUsageBasedThrottleListener)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener());
    }

    public static final /* synthetic */ void $anonfun$testCapValuesOnListeners$1(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler throttler$1, TestableDiskUsageBasedThrottleListener produceListener$1, TestableDiskUsageBasedThrottleListener followerListener$1, long x$4) {
        throttler$1.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)$this.throughput(), (long)produceListener$1.counter().get());
        Assertions.assertEquals((long)$this.throughput(), (long)throttler$1.producerThrottleRate());
        Assertions.assertEquals((long)(2L * $this.throughput()), (long)followerListener$1.counter().get());
        Assertions.assertEquals((long)(2L * $this.throughput()), (long)throttler$1.followerThrottleRate());
    }

    public static final /* synthetic */ void $anonfun$testMinDiskUsableBytes$1(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler throttler$2, long previousUsableSpaceBytes$1, long fileSize) {
        long currentUsableBytes = throttler$2.minDiskUsableBytes();
        Assertions.assertEquals((long)(previousUsableSpaceBytes$1 - fileSize), (long)currentUsableBytes);
        Assertions.assertEquals((long)previousUsableSpaceBytes$1, (long)((TestUtils.DeterministicFileStore)$this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().apply(1)).getUsableSpace());
    }

    public static final /* synthetic */ void $anonfun$testMinDiskTotalBytes$1(DiskUsageBasedThrottler throttler$3, long existingTotalBytes$1, long x$5) {
        long currentTotalBytes = throttler$3.minDiskTotalBytes();
        Assertions.assertEquals((long)existingTotalBytes$1, (long)currentTotalBytes);
    }

    public static final /* synthetic */ void $anonfun$testBasicThrottling$2(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler throttler$4, long x$7) {
        throttler$4.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)$this.throughput(), (long)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertEquals((long)$this.throughput(), (long)BoxesRunTime.unboxToLong((Object)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().lastSignalledQuotaOptRef().get().get()));
        Assertions.assertTrue((boolean)throttler$4.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)$this.throughput(), (long)throttler$4.producerThrottleRate());
    }

    public static final /* synthetic */ void $anonfun$testThroughputIsUpdatedDuringThrottling$2(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler throttler$5, long x$9) {
        throttler$5.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)$this.throughput(), (long)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertEquals((long)$this.throughput(), (long)BoxesRunTime.unboxToLong((Object)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().lastSignalledQuotaOptRef().get().get()));
        Assertions.assertTrue((boolean)throttler$5.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)$this.throughput(), (long)throttler$5.producerThrottleRate());
        long updatedThroughput = 10L * $this.throughput();
        DiskUsageBasedThrottlingConfig qual$1 = throttler$5.getCurrentDiskThrottlingConfig();
        long x$2 = qual$1.copy$default$1();
        Seq x$3 = qual$1.copy$default$3();
        boolean x$4 = qual$1.copy$default$4();
        long x$5 = qual$1.copy$default$5();
        double x$6 = qual$1.copy$default$6();
        boolean x$7 = qual$1.copy$default$7();
        DiskUsageBasedThrottlingConfig updatedConfig = qual$1.copy(x$2, updatedThroughput, x$3, x$4, x$5, x$6, x$7);
        $this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        throttler$5.updateDiskThrottlingConfig(updatedConfig);
        throttler$5.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)updatedThroughput, (long)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertEquals((long)updatedThroughput, (long)BoxesRunTime.unboxToLong((Object)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().lastSignalledQuotaOptRef().get().get()));
        Assertions.assertTrue((boolean)throttler$5.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)updatedThroughput, (long)throttler$5.producerThrottleRate());
    }

    public static final /* synthetic */ void $anonfun$testEnableFlagIsRespected$2(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler throttler$6, long x$11) {
        throttler$6.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertFalse((boolean)throttler$6.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)0L, (long)throttler$6.producerThrottleRate());
    }

    public static final /* synthetic */ void $anonfun$testTimeIsRespected$2(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler throttler$7, long x$13) {
        throttler$7.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertFalse((boolean)throttler$7.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)0L, (long)throttler$7.producerThrottleRate());
        $this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(500L);
        throttler$7.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)$this.throughput(), (long)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertEquals((long)$this.throughput(), (long)BoxesRunTime.unboxToLong((Object)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().lastSignalledQuotaOptRef().get().get()));
        Assertions.assertEquals((long)$this.throughput(), (long)throttler$7.producerThrottleRate());
    }

    public static final /* synthetic */ void $anonfun$testDiskThrottlingIsIndependentFromProduceBackpressure$1(DiskUsageBasedThrottlerTest $this, ClientQuotaManager clientQuotaManager$1, long x$14) {
        clientQuotaManager$1.updateBrokerQuotaLimit($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)$this.throughput(), (long)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertEquals((long)$this.throughput(), (long)BoxesRunTime.unboxToLong((Object)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().lastSignalledQuotaOptRef().get().get()));
        Assertions.assertEquals((long)$this.throughput(), (long)clientQuotaManager$1.producerThrottleRate());
    }

    public static final /* synthetic */ void $anonfun$testAnyListenerIsThrottled$2(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler throttler$8, long x$16) {
        throttler$8.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertTrue((boolean)throttler$8.listenerManager().anyListenerIsThrottled());
    }

    public DiskUsageBasedThrottlerTest() {
        this.throughput = 65536L;
        this.threshold = 0x140000000L;
        this.largeFileSize = 0x300000000L;
        this.defaultTotalBytes = 0x500000000L;
        this.initialUsableBytes = 0x3C0000000L;
    }

    public static class TestableDiskUsageBasedThrottleListener
    implements DiskUsageBasedThrottleListener {
        private final QuotaType quotaType;
        private final AtomicLong counter;
        private AtomicReference<Option<Object>> lastSignalledQuotaOptRef;

        public AtomicReference<Option<Object>> lastSignalledQuotaOptRef() {
            return this.lastSignalledQuotaOptRef;
        }

        public void kafka$server$DiskUsageBasedThrottleListener$_setter_$lastSignalledQuotaOptRef_$eq(AtomicReference<Option<Object>> x$1) {
            this.lastSignalledQuotaOptRef = x$1;
        }

        public QuotaType quotaType() {
            return this.quotaType;
        }

        public AtomicLong counter() {
            return this.counter;
        }

        public void handleDiskSpaceLow(long cappedQuotaInBytesPerSec) {
            this.counter().set(cappedQuotaInBytesPerSec);
        }

        public void handleDiskSpaceRecovered() {
            this.counter().set(Long.MAX_VALUE);
        }

        public TestableDiskUsageBasedThrottleListener() {
            DiskUsageBasedThrottleListener.$init$((DiskUsageBasedThrottleListener)this);
            this.quotaType = QuotaType.Produce$.MODULE$;
            this.counter = new AtomicLong(Long.MAX_VALUE);
            Statics.releaseFence();
        }
    }
}

