/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.network.ConnectionQuota;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigHandler;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaFactory;
import kafka.server.ZkConfigManager;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.record.BrokerCompressionType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Timeout(value=100L)
@ScalaSignature(bytes="\u0006\u0005\tMa\u0001B\r\u001b\u0001}AQA\n\u0001\u0005\u0002\u001dBQA\u000b\u0001\u0005\u0002-BQ!\u000f\u0001\u0005\u0002iBQ!\u001b\u0001\u0005\u0002)DQa\u001c\u0001\u0005\u0002ADQ!\u001e\u0001\u0005\nYDq!!\t\u0001\t\u0003\t\u0019\u0003C\u0004\u0002.\u0001!\t!a\f\t\u000f\u0005e\u0002\u0001\"\u0001\u0002<!9\u0011Q\t\u0001\u0005\u0002\u0005\u001d\u0003bBA)\u0001\u0011\u0005\u00111\u000b\u0005\b\u0003;\u0002A\u0011AA0\u0011\u001d\tI\u0007\u0001C\u0001\u0003WBq!!\u001e\u0001\t\u0003\t9\bC\u0004\u0002\u0002\u0002!\t!a!\t\u000f\u00055\u0005\u0001\"\u0001\u0002\u0010\"9\u0011\u0011\u0014\u0001\u0005\u0002\u0005m\u0005bBAS\u0001\u0011\u0005\u0011q\u0015\u0005\b\u0003c\u0003A\u0011AAZ\u0011\u001d\ti\f\u0001C\u0001\u0003\u007fCq!!3\u0001\t\u0003\tY\rC\u0004\u0002V\u0002!\t!a6\t\u000f\u0005\u0005\b\u0001\"\u0001\u0002d\"9\u0011Q\u001e\u0001\u0005\n\u0005=(a\u0006#z]\u0006l\u0017nY\"p]\u001aLwm\u00115b]\u001e,G+Z:u\u0015\tYB$\u0001\u0004tKJ4XM\u001d\u0006\u0002;\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001!!\t\tC%D\u0001#\u0015\t\u0019C$A\u0006j]R,wM]1uS>t\u0017BA\u0013#\u0005YY\u0015MZ6b'\u0016\u0014h/\u001a:UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001)!\tI\u0003!D\u0001\u001b\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cX#\u0001\u0017\u0011\u00075\"d'D\u0001/\u0015\ty\u0003'A\u0005j[6,H/\u00192mK*\u0011\u0011GM\u0001\u000bG>dG.Z2uS>t'\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Ur#\u0001\u0002'jgR\u0004\"!K\u001c\n\u0005aR\"aC&bM.\f7i\u001c8gS\u001e\f\u0001\u0003^3ti\u000e{gNZ5h\u0007\"\fgnZ3\u0015\u0005mz\u0004C\u0001\u001f>\u001b\u0005\u0011\u0014B\u0001 3\u0005\u0011)f.\u001b;\t\u000b\u0001\u001b\u0001\u0019A!\u0002\rE,xN];n!\t\u0011\u0015J\u0004\u0002D\u000fB\u0011AIM\u0007\u0002\u000b*\u0011aIH\u0001\u0007yI|w\u000e\u001e \n\u0005!\u0013\u0014A\u0002)sK\u0012,g-\u0003\u0002K\u0017\n11\u000b\u001e:j]\u001eT!\u0001\u0013\u001a)\t\ri\u0015L\u0017\t\u0003\u001d^k\u0011a\u0014\u0006\u0003!F\u000ba\u0001]1sC6\u001c(B\u0001*T\u0003\u001dQW\u000f]5uKJT!\u0001V+\u0002\u000b),h.\u001b;\u000b\u0003Y\u000b1a\u001c:h\u0013\tAvJA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fAA\\1nK\u0006\n1,\u0001\u0012|I&\u001c\b\u000f\\1z\u001d\u0006lW- \u0018|CJ<W/\\3oiN<\u0016\u000e\u001e5OC6,7/ \u0015\u0005\u0007u\u001bG\r\u0005\u0002_C6\tqL\u0003\u0002a\u001f\u0006A\u0001O]8wS\u0012,'/\u0003\u0002c?\nYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONd#!Z4\"\u0003\u0019\f!A_6\"\u0003!\fQa\u001b:bMR\fA\u0004^3ti\u0012Kh.Y7jGR{\u0007/[2D_:4\u0017nZ\"iC:<W\r\u0006\u0002<W\")\u0001\t\u0002a\u0001\u0003\"\"A!T-[Q\u0011!Ql\u00198-\u0005\u0015<\u0017A\b;fgRlUm]:bO\u00164uN]7biZ+'o]5p]\u000eC\u0017M\\4f)\tY\u0014\u000fC\u0003A\u000b\u0001\u0007\u0011\t\u000b\u0003\u0006\u001bfS\u0006\u0006B\u0003^GRd\u0013!Z\u0001\u0016i\u0016\u001cH/U;pi\u0006\u001cuN\u001c4jO\u000eC\u0017M\\4f)\u0019Yt/!\u0003\u0002\u001e!)\u0001P\u0002a\u0001s\u00061QM\u001c;jif\u00042A_A\u0003\u001b\u0005Y(B\u0001?~\u0003\u0015\tXo\u001c;b\u0015\tqx0\u0001\u0004d_6lwN\u001c\u0006\u0004;\u0005\u0005!bAA\u0002+\u00061\u0011\r]1dQ\u0016L1!a\u0002|\u0005E\u0019E.[3oiF+x\u000e^1F]RLG/\u001f\u0005\b\u0003\u00171\u0001\u0019AA\u0007\u0003\u0011)8/\u001a:\u0011\t\u0005=\u0011\u0011D\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u0005!\u0011-\u001e;i\u0015\r\t9\"`\u0001\tg\u0016\u001cWO]5us&!\u00111DA\t\u00059Y\u0015MZ6b!JLgnY5qC2Da!a\b\u0007\u0001\u0004\t\u0015\u0001C2mS\u0016tG/\u00133\u0002;Q,7\u000f^\"mS\u0016tG/\u00133Rk>$\u0018mQ8oM&<7\t[1oO\u0016$2aOA\u0013\u0011\u0015\u0001u\u00011\u0001BQ\u00119Q*\u0017.)\u000b\u001di6-a\u000b-\u0005\u0015<\u0017!\u0007;fgR,6/\u001a:Rk>$\u0018mQ8oM&<7\t[1oO\u0016$2aOA\u0019\u0011\u0015\u0001\u0005\u00021\u0001BQ\u0011AQ*\u0017.)\u000b!i6-a\u000e-\u0005\u0015<\u0017a\u0007;fgR,6/\u001a:DY&,g\u000e^%e#V|G/Y\"iC:<W\rF\u0002<\u0003{AQ\u0001Q\u0005A\u0002\u0005CC!C'Z5\"*\u0011\"X2\u0002D1\u0012QmZ\u0001%i\u0016\u001cH\u000fR3gCVdGo\u00117jK:$\u0018\nZ)v_R\f7i\u001c8gS\u001e\u001c\u0005.\u00198hKR\u00191(!\u0013\t\u000b\u0001S\u0001\u0019A!)\t)i\u0015L\u0017\u0015\u0006\u0015u\u001b\u0017q\n\u0017\u0003K\u001e\f\u0001\u0005^3ti\u0012+g-Y;miV\u001bXM])v_R\f7i\u001c8gS\u001e\u001c\u0005.\u00198hKR\u00191(!\u0016\t\u000b\u0001[\u0001\u0019A!)\t-i\u0015L\u0017\u0015\u0006\u0017u\u001b\u00171\f\u0017\u0003K\u001e\f\u0001\u0006^3ti\u0012+g-Y;miV\u001bXM]\"mS\u0016tG/\u00133Rk>$\u0018mQ8oM&<7\t[1oO\u0016$2aOA1\u0011\u0015\u0001E\u00021\u0001BQ\u0011aQ*\u0017.)\u000b1i6-a\u001a-\u0005\u0015<\u0017a\u0006;fgR\fVo\u001c;b\u0013:LG/[1mSj\fG/[8o)\rY\u0014Q\u000e\u0005\u0006\u00016\u0001\r!\u0011\u0015\u0005\u001b5K&\fK\u0003\u000e;\u000e\f\u0019\bL\u0001f\u0003e!Xm\u001d;JaF+x\u000e^1J]&$\u0018.\u00197ju\u0006$\u0018n\u001c8\u0015\u0007m\nI\bC\u0003A\u001d\u0001\u0007\u0011\t\u000b\u0003\u000f\u001bfS\u0006&\u0002\b^G\u0006}DFA3h\u0003u!Xm\u001d;UK:\fg\u000e^)v_R\f\u0017J\\5uS\u0006d\u0017N_1uS>tGcA\u001e\u0002\u0006\")\u0001i\u0004a\u0001\u0003\"\"q\"T-[Q\u0015yQlYAFY\t)w-A\fuKN$\u0018\n])v_R\f7i\u001c8gS\u001e\u001c\u0005.\u00198hKR\u00191(!%\t\u000b\u0001\u0003\u0002\u0019A!)\tAi\u0015L\u0017\u0015\u0006!u\u001b\u0017q\u0013\u0017\u0003K\u001e\f1\u0004^3tiR+g.\u00198u#V|G/Y\"p]\u001aLwm\u00115b]\u001e,GcA\u001e\u0002\u001e\")\u0001)\u0005a\u0001\u0003\"\"\u0011#T-[Q\u0015\tRlYARY\t)w-\u0001\u0012uKN$8i\u001c8gS\u001e\u001c\u0005.\u00198hK>sgj\u001c8Fq&\u001cH/\u001b8h)>\u0004\u0018n\u0019\u000b\u0004w\u0005%\u0006\"\u0002!\u0013\u0001\u0004\t\u0005\u0006\u0002\nN3jCSAE/d\u0003_c\u0013!Z\u00012i\u0016\u001cHoQ8oM&<7\t[1oO\u0016|eNT8o\u000bbL7\u000f^5oOR{\u0007/[2XSRD\u0017\tZ7j]\u000ec\u0017.\u001a8u)\rY\u0014Q\u0017\u0005\u0006\u0001N\u0001\r!\u0011\u0015\u0005'5K&\fK\u0003\u0014;\u000e\fY\f\f\u0002fO\u00069B/Z:u!J|7-Z:t\u001d>$\u0018NZ5dCRLwN\u001c\u000b\u0004w\u0005\u0005\u0007\"\u0002!\u0015\u0001\u0004\t\u0005\u0006\u0002\u000bN3jCS\u0001F/d\u0003\u000fd\u0013!Z\u0001'i\u0016\u001cH/\u00138de\u0016lWM\u001c;bY\u0006cG/\u001a:EK\u001a\fW\u000f\u001c;U_BL7mQ8oM&<GcA\u001e\u0002N\")\u0001)\u0006a\u0001\u0003\"\"Q#T-[Q\u0015)RlYAjY\t)w-A\u000euKN$\u0018\t\u001c;fe\u0012+g-Y;miR{\u0007/[2D_:4\u0017n\u001a\u000b\u0004w\u0005e\u0007\"\u0002!\u0017\u0001\u0004\t\u0005\u0006\u0002\fN3jCSAF/d\u0003?d#!Z4\u0002QQ,7\u000f^*fO6,g\u000e\u001e#fY\u0016$\u0018n\u001c8UQJ|G\u000f\u001e7fe\u000e{gNZ5h\u0007\"\fgnZ3\u0015\u0007m\n)\u000fC\u0003A/\u0001\u0007\u0011\t\u000b\u0003\u0018\u001bfS\u0006&B\f^G\u0006-H&A3\u0002#\r\u0014X-\u0019;f\u0003\u0012l\u0017N\\\"mS\u0016tG\u000f\u0006\u0002\u0002rB!\u00111_A\u007f\u001b\t\t)P\u0003\u0003\u0002x\u0006e\u0018!B1e[&t'bAA~\u007f\u000691\r\\5f]R\u001c\u0018\u0002BA\u0000\u0003k\u0014Q!\u00113nS:Ds\u0001\u0001B\u0002\u0005\u001f\u0011\t\u0002\u0005\u0003\u0003\u0006\t-QB\u0001B\u0004\u0015\r\u0011I!U\u0001\u0004CBL\u0017\u0002\u0002B\u0007\u0005\u000f\u0011q\u0001V5nK>,H/A\u0003wC2,XMH\u0001e\u0001")
public class DynamicConfigChangeTest
extends KafkaServerTestHarness {
    public List<KafkaConfig> generateConfigs() {
        return new .colon.colon((Object)KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnectOrNull(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false)), (List)Nil$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testConfigChange(String quorum) {
        if (!this.isKRaftTest()) {
            Assertions.assertTrue((boolean)((KafkaServer)this.servers().head()).dynamicConfigHandlers().contains((Object)"topics"), (String)"Should contain a ConfigHandler for topics");
        }
        Long oldVal = Predef$.MODULE$.long2Long(100000L);
        Long newVal = Predef$.MODULE$.long2Long(200000L);
        TopicPartition tp = new TopicPartition("test", 0);
        Properties logProps = new Properties();
        logProps.put("flush.messages", oldVal.toString());
        this.createTopic(tp.topic(), 1, 1, logProps, this.createTopic$default$5(), this.createTopic$default$6());
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testConfigChange$1(this, tp, oldVal);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var25_12 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var13_7 = null;
        Object var18_11 = null;
        if (this.isKRaftTest()) {
            try (Admin admin = this.createAdminClient();){
                ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, tp.topic());
                AlterConfigOp op = new AlterConfigOp(new ConfigEntry("flush.messages", newVal.toString()), AlterConfigOp.OpType.SET);
                ConfigResource resource2 = new ConfigResource(ConfigResource.Type.BROKER, "");
                AlterConfigOp op2 = new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.LogFlushIntervalMsProp(), newVal.toString()), AlterConfigOp.OpType.SET);
                admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource2), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)op2, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all().get();
            }
        } else {
            Properties newProps = new Properties();
            newProps.setProperty("flush.messages", newVal.toString());
            this.adminZkClient().changeTopicConfig(tp.topic(), newProps);
        }
        long l3 = 10000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        long l4 = 1L;
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testConfigChange$2(this, newVal, tp);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                    Object var26_25 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l4);
                l4 += package$.MODULE$.min(l4, 1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDynamicTopicConfigChange(String quorum) {
        TopicPartition tp = new TopicPartition("test", 0);
        int oldSegmentSize = 1000;
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Integer.toString(oldSegmentSize));
        this.createTopic(tp.topic(), 1, 1, logProps, this.createTopic$default$5(), this.createTopic$default$6());
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDynamicTopicConfigChange$1(this, tp, oldSegmentSize);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var26_11 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var14_6 = null;
        Object var19_10 = null;
        int newSegmentSize = 2000;
        if (this.isKRaftTest()) {
            try (Admin admin = this.createAdminClient();){
                ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, tp.topic());
                AlterConfigOp op = new AlterConfigOp(new ConfigEntry("segment.bytes", Integer.toString(newSegmentSize)), AlterConfigOp.OpType.SET);
                admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all().get();
            }
        } else {
            Properties newProps = new Properties();
            newProps.put("segment.bytes", Integer.toString(newSegmentSize));
            this.adminZkClient().changeTopicConfig(tp.topic(), newProps);
        }
        LogManager qual$2 = ((KafkaBroker)this.brokers().head()).logManager();
        boolean x$4 = qual$2.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$2.getLog(tp, x$4).get();
        long l3 = 10000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        long l4 = 1L;
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDynamicTopicConfigChange$2(newSegmentSize, log);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                    Object var27_27 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l4);
                l4 += package$.MODULE$.min(l4, 1000L);
                continue;
            }
            break;
        }
        Object var20_22 = null;
        Object var25_26 = null;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> TestUtils$.MODULE$.produceMessage(this.brokers(), tp.topic(), Integer.toString(i), (Long)null, 30000, 20000));
        Assertions.assertTrue((boolean)log.localLogSegments().stream().allMatch(x$1 -> x$1.size() > 1000), (String)"Log segment size change not applied");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testMessageFormatVersionChange(String quorum) {
        TopicPartition tp = new TopicPartition("test", 0);
        Properties logProps = new Properties();
        logProps.put("message.format.version", "0.10.2");
        this.createTopic(tp.topic(), 1, 1, logProps, this.createTopic$default$5(), this.createTopic$default$6());
        KafkaServer server = (KafkaServer)this.servers().head();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConfigChangeTest.$anonfun$testMessageFormatVersionChange$1(server, tp)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Topic metadata propagation failed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        LogManager qual$2 = server.logManager();
        boolean x$4 = qual$2.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$2.getLog(tp, x$4).get();
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_0_IV1, (Object)log.config().messageFormatVersion);
        Assertions.assertEquals((Object)RecordVersion.V2, (Object)log.config().recordVersion());
        BrokerCompressionType compressionType = BrokerCompressionType.LZ4;
        logProps.put("message.format.version", "0.11.0");
        logProps.put("compression.type", compressionType.name);
        this.adminZkClient().changeTopicConfig(tp.topic(), logProps);
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConfigChangeTest.$anonfun$testMessageFormatVersionChange$3(server, tp, compressionType)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Topic config change propagation failed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_0_IV1, (Object)log.config().messageFormatVersion);
        Assertions.assertEquals((Object)RecordVersion.V2, (Object)log.config().recordVersion());
    }

    /*
     * WARNING - void declaration
     */
    private void testQuotaConfigChange(ClientQuotaEntity entity, KafkaPrincipal user, String clientId) {
        try (Admin admin = this.createAdminClient();){
            java.util.List<ClientQuotaAlteration> alterations = Arrays.asList(new ClientQuotaAlteration(entity, Arrays.asList(new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(1000.0)), new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(2000.0)))));
            admin.alterClientQuotas(alterations).all().get();
            QuotaFactory.QuotaManagers quotaManagers = ((KafkaBroker)this.brokers().head()).dataPlaneRequestProcessor().quotas();
            long l = 10000L;
            TestUtils$ retry_this = TestUtils$.MODULE$;
            long l2 = 1L;
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    DynamicConfigChangeTest.$anonfun$testQuotaConfigChange$1(quotaManagers, user, clientId);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                        Object var25_13 = null;
                        retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(l2);
                    l2 += package$.MODULE$.min(l2, 1000L);
                    continue;
                }
                break;
            }
            Object var13_8 = null;
            Object var18_12 = null;
            double defaultProducerQuota = Long.MAX_VALUE;
            double defaultConsumerQuota = Long.MAX_VALUE;
            java.util.List<ClientQuotaAlteration> removals = Arrays.asList(new ClientQuotaAlteration(entity, Arrays.asList(new ClientQuotaAlteration.Op("producer_byte_rate", null), new ClientQuotaAlteration.Op("consumer_byte_rate", null))));
            admin.alterClientQuotas(removals).all().get();
            long l3 = 10000L;
            TestUtils$ retry_this2 = TestUtils$.MODULE$;
            long l4 = 1L;
            long retry_startTime2 = System.currentTimeMillis();
            while (true) {
                try {
                    DynamicConfigChangeTest.$anonfun$testQuotaConfigChange$2(quotaManagers, user, clientId, defaultProducerQuota, defaultConsumerQuota);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this2.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                        Object var26_23 = null;
                        retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(l4);
                    l4 += package$.MODULE$.min(l4, 1000L);
                    continue;
                }
                break;
            }
            Object var19_18 = null;
            Object var24_22 = null;
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testClientIdQuotaConfigChange(String quorum) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("client-id", "testClient");
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testUserQuotaConfigChange(String quorum) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("user", "ANONYMOUS");
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testUserClientIdQuotaChange(String quorum) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("user", "ANONYMOUS");
        m.put("client-id", "testClient");
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDefaultClientIdQuotaConfigChange(String quorum) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("client-id", null);
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDefaultUserQuotaConfigChange(String quorum) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("user", null);
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDefaultUserClientIdQuotaConfigChange(String quorum) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("user", null);
        m.put("client-id", null);
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testQuotaInitialization(String quorum) {
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties clientIdProps = new Properties();
        server.shutdown();
        clientIdProps.put("producer_byte_rate", "1000");
        clientIdProps.put("consumer_byte_rate", "2000");
        Properties userProps = new Properties();
        userProps.put("producer_byte_rate", "10000");
        userProps.put("consumer_byte_rate", "20000");
        Properties userClientIdProps = new Properties();
        userClientIdProps.put("producer_byte_rate", "100000");
        userClientIdProps.put("consumer_byte_rate", "200000");
        this.adminZkClient().changeClientIdConfig("overriddenClientId", clientIdProps);
        AdminZkClient qual$1 = this.adminZkClient();
        boolean x$3 = qual$1.changeUserOrUserClientIdConfig$default$3();
        qual$1.changeUserOrUserClientIdConfig("overriddenUser", userProps, x$3);
        AdminZkClient qual$2 = this.adminZkClient();
        boolean x$6 = qual$2.changeUserOrUserClientIdConfig$default$3();
        qual$2.changeUserOrUserClientIdConfig("ANONYMOUS/clients/overriddenUserClientId", userClientIdProps, x$6);
        this.zkClient().getChildren(ConfigEntityChangeNotificationZNode$.MODULE$.path()).foreach((Function1 & Serializable)p -> {
            DynamicConfigChangeTest.$anonfun$testQuotaInitialization$1(this, p);
            return BoxedUnit.UNIT;
        });
        server.startup();
        QuotaFactory.QuotaManagers quotaManagers = server.dataPlaneRequestProcessor().quotas();
        double upperBound_upperBound = 1000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound, true), (Object)quotaManagers.produce().quota("someuser", "overriddenClientId"));
        double upperBound_upperBound2 = 2000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound2, true), (Object)quotaManagers.fetch().quota("someuser", "overriddenClientId"));
        double upperBound_upperBound3 = 10000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound3, true), (Object)quotaManagers.produce().quota("overriddenUser", "someclientId"));
        double upperBound_upperBound4 = 20000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound4, true), (Object)quotaManagers.fetch().quota("overriddenUser", "someclientId"));
        double upperBound_upperBound5 = 100000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound5, true), (Object)quotaManagers.produce().quota("ANONYMOUS", "overriddenUserClientId"));
        double upperBound_upperBound6 = 200000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound6, true), (Object)quotaManagers.fetch().quota("ANONYMOUS", "overriddenUserClientId"));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testIpQuotaInitialization(String quorum) {
        KafkaBroker broker = (KafkaBroker)this.brokers().head();
        if (this.isKRaftTest()) {
            try (Admin admin = this.createAdminClient();){
                java.util.List<ClientQuotaAlteration> alterations = Arrays.asList(new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", null)), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(20.0)))), new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", "1.2.3.4")), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(10.0)))));
                admin.alterClientQuotas(alterations).all().get();
            }
        } else {
            broker.shutdown();
            Properties ipDefaultProps = new Properties();
            ipDefaultProps.put("connection_creation_rate", "20.0");
            this.adminZkClient().changeIpConfig(ConfigEntityName$.MODULE$.Default(), ipDefaultProps);
            Properties ipOverrideProps = new Properties();
            ipOverrideProps.put("connection_creation_rate", "10.0");
            this.adminZkClient().changeIpConfig("1.2.3.4", ipOverrideProps);
            this.zkClient().getChildren(ConfigEntityChangeNotificationZNode$.MODULE$.path()).foreach((Function1 & Serializable)p -> {
                DynamicConfigChangeTest.$anonfun$testIpQuotaInitialization$1(this, p);
                return BoxedUnit.UNIT;
            });
            broker.startup();
        }
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testIpQuotaInitialization$2(broker);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var14_13 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTenantQuotaInitialization(String quorum) {
        KafkaBroker broker = (KafkaBroker)this.brokers().head();
        if (this.isKRaftTest()) {
            try (Admin admin = this.createAdminClient();){
                java.util.List<ClientQuotaAlteration> alterations = Arrays.asList(new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("confluent-tenant", null)), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(20.0)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("connection_creation_count", Predef$.MODULE$.double2Double(200.0)), (List)Nil$.MODULE$))).asJava()), new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("confluent-tenant", "lkc-1234")), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(10.0)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("connection_creation_count", Predef$.MODULE$.double2Double(100.0)), (List)Nil$.MODULE$))).asJava()));
                admin.alterClientQuotas(alterations).all().get();
            }
        } else {
            broker.shutdown();
            Properties tenantDefaultProps = new Properties();
            tenantDefaultProps.put("connection_creation_rate", "20.0");
            tenantDefaultProps.put("connection_creation_count", "200");
            this.adminZkClient().changeTenantConfig(ConfigEntityName$.MODULE$.Default(), tenantDefaultProps);
            Properties tenantOverrideProps = new Properties();
            tenantOverrideProps.put("connection_creation_rate", "10.0");
            tenantOverrideProps.put("connection_creation_count", "100");
            this.adminZkClient().changeTenantConfig("lkc-1234", tenantOverrideProps);
            this.zkClient().getChildren(ConfigEntityChangeNotificationZNode$.MODULE$.path()).foreach((Function1 & Serializable)p -> {
                DynamicConfigChangeTest.$anonfun$testTenantQuotaInitialization$1(this, p);
                return BoxedUnit.UNIT;
            });
            broker.startup();
        }
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testTenantQuotaInitialization$2(broker);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var14_13 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testIpQuotaConfigChange(String quorum) {
        try (Admin admin = this.createAdminClient();){
            java.util.List<ClientQuotaAlteration> alterations = Arrays.asList(new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", null)), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(20.0)))), new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", "1.2.3.4")), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(10.0)))));
            admin.alterClientQuotas(alterations).all().get();
            InetAddress overrideQuotaIp = InetAddress.getByName("1.2.3.4");
            this.verifyConnectionQuota$1(overrideQuotaIp, 10.0);
            InetAddress defaultQuotaIp = InetAddress.getByName("2.3.4.5");
            this.verifyConnectionQuota$1(defaultQuotaIp, 20.0);
            java.util.List<ClientQuotaAlteration> deletions1 = Arrays.asList(new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", "1.2.3.4")), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", null))));
            admin.alterClientQuotas(deletions1).all().get();
            this.verifyConnectionQuota$1(overrideQuotaIp, 20.0);
            java.util.List<ClientQuotaAlteration> deletions2 = Arrays.asList(new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", null)), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", null))));
            admin.alterClientQuotas(deletions2).all().get();
            this.verifyConnectionQuota$1(overrideQuotaIp, Double.MAX_VALUE);
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTenantQuotaConfigChange(String quorum) {
        try (Admin admin = this.createAdminClient();){
            new .colon.colon((Object)"fakeapikey1234", (List)new .colon.colon((Object)"lkc-1234", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)tenantId -> {
                DynamicConfigChangeTest.$anonfun$testTenantQuotaConfigChange$1(this, admin, tenantId);
                return BoxedUnit.UNIT;
            });
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testConfigChangeOnNonExistingTopic(String quorum) {
        String topic = TestUtils$.MODULE$.tempTopic();
        Properties logProps = new Properties();
        logProps.put("flush.messages", Predef$.MODULE$.int2Integer(10000));
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.adminZkClient().changeTopicConfig(topic, logProps));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testConfigChangeOnNonExistingTopicWithAdminClient(String quorum) {
        String topic = TestUtils$.MODULE$.tempTopic();
        try (Admin admin = this.createAdminClient();){
            try {
                ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
                AlterConfigOp op = new AlterConfigOp(new ConfigEntry("flush.messages", "10000"), AlterConfigOp.OpType.SET);
                admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all().get();
                Assertions.fail((String)"Should fail with UnknownTopicOrPartitionException for topic doesn't exist");
            }
            catch (ExecutionException executionException) {
                Assertions.assertTrue((boolean)(executionException.getCause() instanceof UnknownTopicOrPartitionException));
            }
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testProcessNotification(String quorum) {
        new Properties().put("a.b", "10");
        ConfigHandler handler = (ConfigHandler)Mockito.mock(ConfigHandler.class);
        ZkConfigManager configManager = new ZkConfigManager(this.zkClient(), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topics"), (Object)handler)})));
        configManager.ConfigChangedNotificationHandler().processNotification("not json".getBytes(StandardCharsets.UTF_8));
        ObjectRef jsonMap = ObjectRef.create((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"x"), (Object)BoxesRunTime.boxToInteger((int)2))}))));
        Assertions.assertThrows(Throwable.class, () -> configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)jsonMap$1.elem).asJava())));
        jsonMap.elem = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)"garbage"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_name"), (Object)"x")}));
        Assertions.assertThrows(Throwable.class, () -> configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)jsonMap$1.elem).asJava())));
        jsonMap.elem = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)"topics")}));
        Assertions.assertThrows(Throwable.class, () -> configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)jsonMap$1.elem).asJava())));
        jsonMap.elem = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)"topics"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_name"), (Object)"x")}));
        configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)jsonMap.elem).asJava()));
        ((ConfigHandler)Mockito.verify((Object)handler)).processConfigChanges(ArgumentMatchers.anyString(), (Properties)ArgumentMatchers.any());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testIncrementalAlterDefaultTopicConfig(String quorum) {
        try (Admin admin = this.createAdminClient();){
            ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, "");
            AlterConfigOp op = new AlterConfigOp(new ConfigEntry("flush.messages", "200000"), AlterConfigOp.OpType.SET);
            KafkaFuture future = admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all();
            TestUtils$.MODULE$.assertFutureExceptionTypeEquals((Future<?>)future, (Class<? extends Throwable>)InvalidRequestException.class, (Option<String>)None$.MODULE$);
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterDefaultTopicConfig(String quorum) {
        try (Admin admin = this.createAdminClient();){
            ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, "");
            Config config = new Config(Collections.singleton(new ConfigEntry("flush.messages", "200000")));
            KafkaFuture future = admin.alterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)config)}))).asJava()).all();
            TestUtils$.MODULE$.assertFutureExceptionTypeEquals((Future<?>)future, (Class<? extends Throwable>)InvalidRequestException.class, (Option<String>)None$.MODULE$);
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testSegmentDeletionThrottlerConfigChange(String quorum) {
        long newDiskFreeHeadroomBytes = 0x3200000000L;
        this.adminZkClient().changeBrokerConfig((Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)), CoreUtils$.MODULE$.propsWith((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)KafkaConfig$.MODULE$.LogDeletionThrottlerDiskFreeHeadroomBytesProp(), (Object)Long.toString(newDiskFreeHeadroomBytes))})));
        this.servers().foreach((Function1 & Serializable)server -> {
            DynamicConfigChangeTest.$anonfun$testSegmentDeletionThrottlerConfigChange$1(newDiskFreeHeadroomBytes, server);
            return BoxedUnit.UNIT;
        });
    }

    private Admin createAdminClient() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        return Admin.create((Properties)props);
    }

    public static final /* synthetic */ void $anonfun$testConfigChange$1(DynamicConfigChangeTest $this, TopicPartition tp$1, Long oldVal$1) {
        LogManager qual$1 = ((KafkaBroker)$this.brokers().head()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Option logOpt = qual$1.getLog(tp$1, x$2);
        Assertions.assertTrue((boolean)logOpt.isDefined());
        Assertions.assertEquals((Long)oldVal$1, (long)((AbstractLog)logOpt.get()).config().flushInterval);
    }

    public static final /* synthetic */ void $anonfun$testConfigChange$2(DynamicConfigChangeTest $this, Long newVal$1, TopicPartition tp$1) {
        LogManager qual$2 = ((KafkaBroker)$this.brokers().head()).logManager();
        boolean x$4 = qual$2.getLog$default$2();
        Assertions.assertEquals((Long)newVal$1, (long)((AbstractLog)qual$2.getLog((TopicPartition)tp$1, (boolean)x$4).get()).config().flushInterval);
    }

    public static final /* synthetic */ void $anonfun$testDynamicTopicConfigChange$1(DynamicConfigChangeTest $this, TopicPartition tp$2, int oldSegmentSize$1) {
        LogManager qual$1 = ((KafkaBroker)$this.brokers().head()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Option logOpt = qual$1.getLog(tp$2, x$2);
        Assertions.assertTrue((boolean)logOpt.isDefined());
        Assertions.assertEquals((int)oldSegmentSize$1, (int)((AbstractLog)logOpt.get()).config().segmentSize);
    }

    public static final /* synthetic */ void $anonfun$testDynamicTopicConfigChange$2(int newSegmentSize$1, AbstractLog log$1) {
        Assertions.assertEquals((int)newSegmentSize$1, (int)log$1.config().segmentSize);
    }

    public static final /* synthetic */ boolean $anonfun$testMessageFormatVersionChange$1(KafkaServer server$1, TopicPartition tp$3) {
        LogManager qual$1 = server$1.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(tp$3, x$2).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testMessageFormatVersionChange$2() {
        return "Topic metadata propagation failed";
    }

    public static final /* synthetic */ boolean $anonfun$testMessageFormatVersionChange$3(KafkaServer server$1, TopicPartition tp$3, BrokerCompressionType compressionType$1) {
        LogManager qual$3 = server$1.logManager();
        boolean x$6 = qual$3.getLog$default$2();
        BrokerCompressionType brokerCompressionType = ((AbstractLog)qual$3.getLog((TopicPartition)tp$3, (boolean)x$6).get()).config().compressionType;
        return !(brokerCompressionType != null ? !brokerCompressionType.equals(compressionType$1) : compressionType$1 != null);
    }

    public static final /* synthetic */ String $anonfun$testMessageFormatVersionChange$4() {
        return "Topic config change propagation failed";
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigChange$1(QuotaFactory.QuotaManagers quotaManagers$1, KafkaPrincipal user$1, String clientId$1) {
        Quota overrideProducerQuota = quotaManagers$1.produce().quota(user$1, clientId$1);
        Quota overrideConsumerQuota = quotaManagers$1.fetch().quota(user$1, clientId$1);
        double upperBound_upperBound = 1000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound, true), (Object)overrideProducerQuota, (String)new StringBuilder(59).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have overridden producer quota of 1000").toString());
        double upperBound_upperBound2 = 2000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound2, true), (Object)overrideConsumerQuota, (String)new StringBuilder(59).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have overridden consumer quota of 2000").toString());
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigChange$2(QuotaFactory.QuotaManagers quotaManagers$1, KafkaPrincipal user$1, String clientId$1, double defaultProducerQuota$1, double defaultConsumerQuota$1) {
        Quota producerQuota = quotaManagers$1.produce().quota(user$1, clientId$1);
        Quota consumerQuota = quotaManagers$1.fetch().quota(user$1, clientId$1);
        Assertions.assertEquals((Object)new Quota(defaultProducerQuota$1, true), (Object)producerQuota, (String)new StringBuilder(50).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have reset producer quota to ").append(defaultProducerQuota$1).toString());
        Assertions.assertEquals((Object)new Quota(defaultConsumerQuota$1, true), (Object)consumerQuota, (String)new StringBuilder(50).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have reset consumer quota to ").append(defaultConsumerQuota$1).toString());
    }

    public static final /* synthetic */ void $anonfun$testQuotaInitialization$1(DynamicConfigChangeTest $this, String p) {
        KafkaZkClient qual$3 = $this.zkClient();
        String x$7 = new StringBuilder(1).append(ConfigEntityChangeNotificationZNode$.MODULE$.path()).append("/").append(p).toString();
        int x$8 = qual$3.deletePath$default$2();
        boolean x$9 = qual$3.deletePath$default$3();
        qual$3.deletePath(x$7, x$8, x$9);
    }

    public static final /* synthetic */ void $anonfun$testIpQuotaInitialization$1(DynamicConfigChangeTest $this, String p) {
        KafkaZkClient qual$1 = $this.zkClient();
        String x$1 = new StringBuilder(1).append(ConfigEntityChangeNotificationZNode$.MODULE$.path()).append("/").append(p).toString();
        int x$2 = qual$1.deletePath$default$2();
        boolean x$3 = qual$1.deletePath$default$3();
        qual$1.deletePath(x$1, x$2, x$3);
    }

    public static final /* synthetic */ void $anonfun$testIpQuotaInitialization$2(KafkaBroker broker$1) {
        ConnectionQuota ipConnectionQuota = broker$1.socketServer().connectionQuotas().ipConnectionQuota();
        Assertions.assertEquals((double)10.0, (double)ipConnectionQuota.maxConnectionRate((Object)InetAddress.getByName("1.2.3.4")));
        Assertions.assertEquals((double)20.0, (double)ipConnectionQuota.maxConnectionRate((Object)InetAddress.getByName("2.4.6.8")));
    }

    public static final /* synthetic */ void $anonfun$testTenantQuotaInitialization$1(DynamicConfigChangeTest $this, String p) {
        KafkaZkClient qual$1 = $this.zkClient();
        String x$1 = new StringBuilder(1).append(ConfigEntityChangeNotificationZNode$.MODULE$.path()).append("/").append(p).toString();
        int x$2 = qual$1.deletePath$default$2();
        boolean x$3 = qual$1.deletePath$default$3();
        qual$1.deletePath(x$1, x$2, x$3);
    }

    public static final /* synthetic */ void $anonfun$testTenantQuotaInitialization$2(KafkaBroker broker$2) {
        ConnectionQuota tenantConnectionQuota = broker$2.socketServer().connectionQuotas().tenantConnectionQuota();
        Assertions.assertEquals((double)10.0, (double)tenantConnectionQuota.maxConnectionRate((Object)"lkc-1234"));
        Assertions.assertEquals((int)100, (int)tenantConnectionQuota.maxConnections((Object)"lkc-1234"));
        Assertions.assertEquals((double)20.0, (double)tenantConnectionQuota.maxConnectionRate((Object)"lkc-2468"));
        Assertions.assertEquals((int)200, (int)tenantConnectionQuota.maxConnections((Object)"lkc-2468"));
    }

    public static final /* synthetic */ void $anonfun$testIpQuotaConfigChange$1(ConnectionQuota ipConnectionQuota$1, InetAddress ip$1, double expectedQuota$1) {
        double quota = ipConnectionQuota$1.maxConnectionRate((Object)ip$1);
        Assertions.assertEquals((double)expectedQuota$1, (double)quota, (String)new StringBuilder(24).append("Unexpected quota for IP ").append(ip$1).toString());
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyConnectionQuota$1(InetAddress ip, double expectedQuota) {
        ConnectionQuota ipConnectionQuota = ((KafkaBroker)this.brokers().head()).socketServer().connectionQuotas().ipConnectionQuota();
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testIpQuotaConfigChange$1(ipConnectionQuota, ip, expectedQuota);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var11_9 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testTenantQuotaConfigChange$2(ConnectionQuota tenantConnectionQuota$1, String tenant$1, double expectedQuota$2) {
        double quota = tenantConnectionQuota$1.maxConnectionRate((Object)tenant$1);
        Assertions.assertEquals((double)expectedQuota$2, (double)quota, (String)new StringBuilder(28).append("Unexpected quota for tenant ").append(tenant$1).toString());
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyConnectionQuota$2(String tenant, double expectedQuota) {
        ConnectionQuota tenantConnectionQuota = ((KafkaBroker)this.brokers().head()).socketServer().connectionQuotas().tenantConnectionQuota();
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testTenantQuotaConfigChange$2(tenantConnectionQuota, tenant, expectedQuota);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var11_9 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testTenantQuotaConfigChange$1(DynamicConfigChangeTest $this, Admin admin$1, String tenantId) {
        java.util.List<ClientQuotaAlteration> alterations = Arrays.asList(new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("confluent-tenant", null)), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(20.0)))), new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("confluent-tenant", tenantId)), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(10.0)))));
        admin$1.alterClientQuotas(alterations).all().get();
        $this.verifyConnectionQuota$2(tenantId, 10.0);
        String defaultQuotaTenant = "lkc-2345";
        $this.verifyConnectionQuota$2(defaultQuotaTenant, 20.0);
        java.util.List<ClientQuotaAlteration> deletions1 = Arrays.asList(new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("confluent-tenant", tenantId)), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", null))));
        admin$1.alterClientQuotas(deletions1).all().get();
        $this.verifyConnectionQuota$2(tenantId, 20.0);
        java.util.List<ClientQuotaAlteration> deletions2 = Arrays.asList(new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("confluent-tenant", null)), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", null))));
        admin$1.alterClientQuotas(deletions2).all().get();
        $this.verifyConnectionQuota$2(tenantId, Double.MAX_VALUE);
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentDeletionThrottlerConfigChange$2(KafkaServer server$2, long newDiskFreeHeadroomBytes$1) {
        return server$2.logManager().segmentDeletionThrottlerConfig().diskFreeThresholdBytes() == newDiskFreeHeadroomBytes$1;
    }

    public static final /* synthetic */ String $anonfun$testSegmentDeletionThrottlerConfigChange$3() {
        return new StringBuilder(19).append(KafkaConfig$.MODULE$.LogDeletionThrottlerDiskFreeHeadroomBytesProp()).append(" propagation failed").toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testSegmentDeletionThrottlerConfigChange$1(long newDiskFreeHeadroomBytes$1, KafkaServer server) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConfigChangeTest.$anonfun$testSegmentDeletionThrottlerConfigChange$2(server, newDiskFreeHeadroomBytes$1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConfigChangeTest.$anonfun$testSegmentDeletionThrottlerConfigChange$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }
}

