/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Optional;
import java.util.Properties;
import kafka.network.ConnectionQuotas;
import kafka.server.Constants$;
import kafka.server.IpConfigHandler;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.server.TenantConfigHandler;
import kafka.server.TopicConfigHandler;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AuthorizerConfig;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005a2A!\u0003\u0006\u0001\u001f!)a\u0003\u0001C\u0001/!)!\u0004\u0001C\u00017!)A\u0006\u0001C\u00017!)a\u0006\u0001C\u00017!)\u0001\u0007\u0001C\u00017!)!\u0007\u0001C\u00017!)A\u0007\u0001C\u00017!)a\u0007\u0001C\u00017\tYB)\u001f8b[&\u001c7i\u001c8gS\u001e\u001c\u0005.\u00198hKVs\u0017\u000e\u001e+fgRT!a\u0003\u0007\u0002\rM,'O^3s\u0015\u0005i\u0011!B6bM.\f7\u0001A\n\u0003\u0001A\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u0019!\tI\u0002!D\u0001\u000b\u0003\u0001\"Xm\u001d;Ja\"\u000bg\u000e\u001a7feVs'/Z:pYZ\f'\r\\3BI\u0012\u0014Xm]:\u0015\u0003q\u0001\"!E\u000f\n\u0005y\u0011\"\u0001B+oSRD#A\u0001\u0011\u0011\u0005\u0005RS\"\u0001\u0012\u000b\u0005\r\"\u0013aA1qS*\u0011QEJ\u0001\bUV\u0004\u0018\u000e^3s\u0015\t9\u0003&A\u0003kk:LGOC\u0001*\u0003\ry'oZ\u0005\u0003W\t\u0012A\u0001V3ti\u0006\tB/Z:u)\u0016t\u0017M\u001c;IC:$G.\u001a:)\u0005\r\u0001\u0013!J:i_VdG\rU1sg\u0016\u0014V\r\u001d7jG\u0006$\u0018n\u001c8Rk>$\u0018\r\u0015:pa\u0016\u0014H/[3tQ\t!\u0001%A\u0017tQ>,H\u000e\u001a)beN,w+\u001b7eG\u0006\u0014HMU3qY&\u001c\u0017\r^5p]F+x\u000e^1Qe>\u0004XM\u001d;jKND#!\u0002\u0011\u0002[MDw.\u001e7e!\u0006\u00148/\u001a*fO\u0006\u0014H\r\\3tg>3w\u000b[5uKN\u0004\u0018mY3Be>,h\u000e\u001a,bYV,7\u000f\u000b\u0002\u0007A\u0005I3\u000f[8vY\u0012\u0004\u0016M]:f\u001d>tWMU3qY&\u001c\u0017\r^5p]F+x\u000e^1Qe>\u0004XM\u001d;jKND#a\u0002\u0011\u0002AMDw.\u001e7e!\u0006\u00148/\u001a*fa2L7-\u0019;j_:\fVo\u001c;b%\u0016\u001cX\r\u001e\u0015\u0003\u0011\u0001\u0002")
public class DynamicConfigChangeUnitTest {
    @Test
    public void testIpHandlerUnresolvableAddress() {
        IpConfigHandler configHandler = new IpConfigHandler(null);
        Properties props = new Properties();
        props.put("connection_creation_rate", "1");
        Assertions.assertThrows(IllegalArgumentException.class, () -> configHandler.processConfigChanges("illegal-hostname", props));
    }

    @Test
    public void testTenantHandler() {
        Metrics metrics = new Metrics();
        ProducerStateManagerConfig producerStateManagerConfig = new ProducerStateManagerConfig(0, true);
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var28_11 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var29_14 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var30_17 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 0, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        props.put("connection_creation_rate", "1");
        props.put("producer_id_expiration_ms", "5");
        props.put("connection_creation_count", "10");
        props.put("acl_count", "300");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        AuthorizerConfig authConfig = new AuthorizerConfig();
        ConnectionQuotas connectionQuotas = new ConnectionQuotas(config, (Time)new MockTime(), metrics);
        TenantConfigHandler configHandler = new TenantConfigHandler(connectionQuotas, producerStateManagerConfig, (Option)new Some((Object)authConfig));
        String tenantId = "lkc-abcd";
        configHandler.processConfigChanges(tenantId, props);
        Assertions.assertEquals((int)5, (int)producerStateManagerConfig.producerIdExpirationMs(Optional.of(tenantId)));
        Assertions.assertEquals((int)10, (int)connectionQuotas.tenantConnectionQuota().maxConnections((Object)tenantId));
        Assertions.assertEquals((double)1.0, (double)connectionQuotas.tenantConnectionQuota().maxConnectionRate((Object)tenantId));
        Assertions.assertEquals((int)300, (int)authConfig.maxAcls(tenantId));
        Assertions.assertEquals((int)authConfig.defaultMaxAcls(), (int)authConfig.maxAcls("lkc-xyz"));
    }

    @Test
    public void shouldParseReplicationQuotaProperties() {
        TopicConfigHandler configHandler = new TopicConfigHandler((ReplicaManager)Mockito.mock(ReplicaManager.class), null, null, null);
        Properties props = new Properties();
        props.put("leader.replication.throttled.replicas", "0:101,0:102,1:101,1:102");
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)configHandler.parseThrottledPartitions(props, 102, "leader.replication.throttled.replicas"));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)configHandler.parseThrottledPartitions(props, 103, "leader.replication.throttled.replicas"));
    }

    @Test
    public void shouldParseWildcardReplicationQuotaProperties() {
        TopicConfigHandler configHandler = new TopicConfigHandler((ReplicaManager)Mockito.mock(ReplicaManager.class), null, null, null);
        Properties props = new Properties();
        props.put("leader.replication.throttled.replicas", "*");
        Seq result = configHandler.parseThrottledPartitions(props, 102, "leader.replication.throttled.replicas");
        Assertions.assertEquals((Object)Constants$.MODULE$.AllReplicas(), (Object)result);
    }

    @Test
    public void shouldParseRegardlessOfWhitespaceAroundValues() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null, null);
        Assertions.assertEquals((Object)Constants$.MODULE$.AllReplicas(), (Object)DynamicConfigChangeUnitTest.parse$1(configHandler, "* "));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)DynamicConfigChangeUnitTest.parse$1(configHandler, " "));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{6})), (Object)DynamicConfigChangeUnitTest.parse$1(configHandler, "6:102"));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{6})), (Object)DynamicConfigChangeUnitTest.parse$1(configHandler, "6:102 "));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{6})), (Object)DynamicConfigChangeUnitTest.parse$1(configHandler, " 6:102"));
    }

    @Test
    public void shouldParseNoneReplicationQuotaProperties() {
        TopicConfigHandler configHandler = new TopicConfigHandler((ReplicaManager)Mockito.mock(ReplicaManager.class), null, null, null);
        Properties props = new Properties();
        props.put("leader.replication.throttled.replicas", "none");
        Seq result = configHandler.parseThrottledPartitions(props, 102, "leader.replication.throttled.replicas");
        Assertions.assertEquals((Object)Constants$.MODULE$.NoReplicas(), (Object)result);
    }

    @Test
    public void shouldParseReplicationQuotaReset() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null, null);
        Properties props = new Properties();
        props.put("follower.replication.throttled.replicas", "");
        Seq result = configHandler.parseThrottledPartitions(props, 102, "follower.replication.throttled.replicas");
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)result);
    }

    private static final Seq parse$1(TopicConfigHandler configHandler, String value) {
        return configHandler.parseThrottledPartitions(CoreUtils$.MODULE$.propsWith("leader.replication.throttled.replicas", value), 102, "leader.replication.throttled.replicas");
    }
}

