/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Properties;
import kafka.server.DynamicQuotaPublishingRequestThread;
import kafka.server.DynamicQuotaReportingRequestThread;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.message.PublishQuotaTargetRequestData;
import org.apache.kafka.common.message.ReportQuotaConsumptionRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.PublishQuotaTargetRequest;
import org.apache.kafka.common.requests.ReportQuotaConsumptionRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.RequestAndCompletionHandler;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005]f\u0001B\u0011#\u0001\u001dBQA\f\u0001\u0005\u0002=BqA\r\u0001C\u0002\u0013%1\u0007\u0003\u00048\u0001\u0001\u0006I\u0001\u000e\u0005\bq\u0001\u0011\r\u0011\"\u0003:\u0011\u0019)\u0005\u0001)A\u0005u!9a\t\u0001b\u0001\n\u00139\u0005BB(\u0001A\u0003%\u0001\nC\u0004Q\u0001\t\u0007I\u0011B)\t\ra\u0003\u0001\u0015!\u0003S\u0011\u001dI\u0006A1A\u0005\niCaA\u0018\u0001!\u0002\u0013Y\u0006bB0\u0001\u0005\u0004%I\u0001\u0019\u0005\u0007O\u0002\u0001\u000b\u0011B1\t\u000f!\u0004!\u0019!C\u0005S\"1q\u000e\u0001Q\u0001\n)Dq\u0001\u001d\u0001C\u0002\u0013%\u0011\u000f\u0003\u0004v\u0001\u0001\u0006IA\u001d\u0005\bm\u0002\u0011\r\u0011\"\u0003x\u0011\u0019Y\b\u0001)A\u0005q\")A\u0010\u0001C\u0005{\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0001bBA\u0012\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003O\u0001A\u0011AA\u0003\u0011\u001d\tY\u0003\u0001C\u0005\u0003[Aq!!\u001f\u0001\t\u0003\t)\u0001C\u0004\u0002~\u0001!\t!!\u0002\t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002\u0006!9\u0011Q\u0011\u0001\u0005\u0002\u0005\u0015\u0001bBAE\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003\u001b\u0003A\u0011AA\u0003\u0011\u001d\t\t\n\u0001C\u0005\u0003'Cq!!(\u0001\t\u0013\tyJ\u0001\u0010Es:\fW.[2Rk>$\u0018m\u00115b]:,G.T1oC\u001e,'\u000fV3ti*\u00111\u0005J\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001QA\u0011\u0011\u0006L\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0019\u0011\u0005E\u0002Q\"\u0001\u0012\u0002\u001b5,G/\u00193bi\u0006\u001c\u0015m\u00195f+\u0005!\u0004CA\u00196\u0013\t1$EA\u0007NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u0001\u000f[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3!\u00035qW\r^<pe.\u001cE.[3oiV\t!\b\u0005\u0002<\u00076\tAH\u0003\u0002>}\u000591\r\\5f]R\u001c(BA\u0013@\u0015\t\u0001\u0015)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0005\u0006\u0019qN]4\n\u0005\u0011c$!\u0004(fi^|'o[\"mS\u0016tG/\u0001\boKR<xN]6DY&,g\u000e\u001e\u0011\u0002\u001d-\fgm[1TG\",G-\u001e7feV\t\u0001\n\u0005\u0002J\u001b6\t!J\u0003\u0002L\u0019\u0006!Q\u000f^5m\u0015\t\u0019c(\u0003\u0002O\u0015\nq1*\u00194lCN\u001b\u0007.\u001a3vY\u0016\u0014\u0018aD6bM.\f7k\u00195fIVdWM\u001d\u0011\u0002\u000f\t\u0014xn[3scU\t!\u000b\u0005\u0002T-6\tAK\u0003\u0002V}\u000511m\\7n_:L!a\u0016+\u0003\t9{G-Z\u0001\tEJ|7.\u001a:2A\u0005A!M]8lKJLE-F\u0001\\!\tIC,\u0003\u0002^U\t\u0019\u0011J\u001c;\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0013\u0001\u0002;j[\u0016,\u0012!\u0019\t\u0003E\u0016l\u0011a\u0019\u0006\u0003IR\u000bQ!\u001e;jYNL!AZ2\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\nq!\\3ue&\u001c7/F\u0001k!\tYW.D\u0001m\u0015\tAG+\u0003\u0002oY\n9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002-I,\u0007o\u001c:uS:<'+Z9vKN$H\u000b\u001b:fC\u0012,\u0012A\u001d\t\u0003cML!\u0001\u001e\u0012\u0003E\u0011Kh.Y7jGF+x\u000e^1SKB|'\u000f^5oOJ+\u0017/^3tiRC'/Z1e\u0003]\u0011X\r]8si&twMU3rk\u0016\u001cH\u000f\u00165sK\u0006$\u0007%A\fqk\nd\u0017n\u001d5j]\u001e\u0014V-];fgR$\u0006N]3bIV\t\u0001\u0010\u0005\u00022s&\u0011!P\t\u0002$\tft\u0017-\\5d#V|G/\u0019)vE2L7\u000f[5oOJ+\u0017/^3tiRC'/Z1e\u0003a\u0001XO\u00197jg\"Lgn\u001a*fcV,7\u000f\u001e+ie\u0016\fG\rI\u0001\u0007G>tg-[4\u0016\u0003y\u0004\"!M@\n\u0007\u0005\u0005!EA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!\f;fgR<UM\\3sCR,W)\u001c9us6\u000b\u0007o\u00165f]:{'+Z9vKN$8oT;ugR\fg\u000eZ5oOR\u0011\u0011q\u0001\t\u0004S\u0005%\u0011bAA\u0006U\t!QK\\5uQ\r)\u0012q\u0002\t\u0005\u0003#\ty\"\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003\r\t\u0007/\u001b\u0006\u0005\u00033\tY\"A\u0004kkBLG/\u001a:\u000b\u0007\u0005u\u0011)A\u0003kk:LG/\u0003\u0003\u0002\"\u0005M!\u0001\u0002+fgR\f\u0011\u0006^3ti\u001e+g.\u001a:bi\u0016,e\u000e\u001e:z/&$\bn\\;u\u0003\u000e$\u0018N^3D_>\u0014H-\u001b8bi>\u0014\bf\u0001\f\u0002\u0010\u0005QB/Z:u\u000f\u0016tWM]1uK>sWMU3q_J$XI\u001c;ss\"\u001aq#a\u0004\u0002\u001f\r\u0014X-\u0019;f\u000b:$(/\u001f#bi\u0006$B\"a\f\u0002D\u0005u\u0013\u0011MA3\u0003_\u0002B!!\r\u0002>9!\u00111GA\u001d\u001b\t\t)DC\u0002\u00028Q\u000bq!\\3tg\u0006<W-\u0003\u0003\u0002<\u0005U\u0012!\t*fa>\u0014H/U;pi\u0006\u001cuN\\:v[B$\u0018n\u001c8SKF,Xm\u001d;ECR\f\u0017\u0002BA \u0003\u0003\u0012\u0011\"\u00128uef$\u0015\r^1\u000b\t\u0005m\u0012Q\u0007\u0005\b\u0003\u000bB\u0002\u0019AA$\u0003))g\u000e^5usRK\b/\u001a\t\u0005\u0003\u0013\n9F\u0004\u0003\u0002L\u0005M\u0003cAA'U5\u0011\u0011q\n\u0006\u0004\u0003#2\u0013A\u0002\u001fs_>$h(C\u0002\u0002V)\na\u0001\u0015:fI\u00164\u0017\u0002BA-\u00037\u0012aa\u0015;sS:<'bAA+U!9\u0011q\f\rA\u0002\u0005\u001d\u0013AC3oi&$\u0018PT1nK\"9\u00111\r\rA\u0002\u0005\u001d\u0013!C9v_R\fG+\u001f9f\u0011\u001d\t9\u0007\u0007a\u0001\u0003S\nQ!^:bO\u0016\u00042!KA6\u0013\r\tiG\u000b\u0002\u0007\t>,(\r\\3\t\u000f\u0005E\u0004\u00041\u0001\u0002t\u0005IA\u000f\u001b:piRdW\r\u001a\t\u0004S\u0005U\u0014bAA<U\t9!i\\8mK\u0006t\u0017!\f;fgR<UM\\3sCR,Gk^8SKB|'\u000f^#oiJLx+\u001b;i'\u0006lWmQ8pe\u0012Lg.\u0019;pe\"\u001a\u0011$a\u0004\u0002oQ,7\u000f^$f]\u0016\u0014\u0018\r^3Nk2$\u0018\u000e\u001d7f%\u0016\u0004xN\u001d;F]R\u0014\u0018pV5uQ\u0012KgMZ3sK:$8i\\8sI&t\u0017\r^8sQ\rQ\u0012qB\u0001\u001ci\u0016\u001cHoR3oKJ\fG/Z(oKB+(\r\\5tQ\u0016sGO]=)\u0007m\ty!A\u0015uKN$x)\u001a8fe\u0006$X\rV<p!V\u0014G.[:i\u000b:$(/_,ji\"\u001c\u0016-\\3Ce>\\WM\u001d\u0015\u00049\u0005=\u0011a\f;fgR<UM\\3sCR,Gk^8Qk\nd\u0017n\u001d5F]R\u0014\u0018pV5uQ\u0012KgMZ3sK:$(I]8lKJ\u001c\bfA\u000f\u0002\u0010\u0005!D/Z:u\u000f\u0016tWM]1uK6+H\u000e^5qY\u0016\u0004VO\u00197jg\",e\u000e\u001e:z/&$\b\u000eR5gM\u0016\u0014XM\u001c;Ce>\\WM]:)\u0007y\ty!A\u0012hK:,'/\u0019;f\u001bB+(\r\\5tQ\u0016sGO]5fg^KG\u000f\u001b(Ce>\\WM]:\u0015\r\u0005\u001d\u0011QSAM\u0011\u0019\t9j\ba\u00017\u0006Qa.^7F]R\u0014\u0018.Z:\t\r\u0005mu\u00041\u0001\\\u0003)qW/\u001c\"s_.,'o]\u0001\u001cGJ,\u0017\r^3Qk\nd\u0017n\u001d5Rk>$\u0018-\u00128uef$\u0015\r^1\u0015\u0015\u0005\u0005\u0016QVAX\u0003c\u000b\u0019\f\u0005\u0003\u0002$\u0006%f\u0002BA\u001a\u0003KKA!a*\u00026\u0005i\u0002+\u001e2mSND\u0017+^8uCR\u000b'oZ3u%\u0016\fX/Z:u\t\u0006$\u0018-\u0003\u0003\u0002@\u0005-&\u0002BAT\u0003kAq!!\u0012!\u0001\u0004\t9\u0005C\u0004\u0002`\u0001\u0002\r!a\u0012\t\u000f\u0005\r\u0004\u00051\u0001\u0002H!9\u0011Q\u0017\u0011A\u0002\u0005%\u0014!B9v_R\f\u0007")
public class DynamicQuotaChannelManagerTest {
    private final MetadataCache metadataCache = (MetadataCache)EasyMock.createNiceMock(MetadataCache.class);
    private final NetworkClient networkClient = (NetworkClient)EasyMock.createNiceMock(NetworkClient.class);
    private final KafkaScheduler kafkaScheduler = (KafkaScheduler)EasyMock.createNiceMock(KafkaScheduler.class);
    private final Node broker1 = new Node(1, "host", 10);
    private final int brokerId;
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final DynamicQuotaReportingRequestThread reportingRequestThread = new DynamicQuotaReportingRequestThread(this.config(), this.metrics(), this.metadataCache(), this.networkClient(), this.kafkaScheduler(), (Time)this.time());
    private final DynamicQuotaPublishingRequestThread publishingRequestThread = new DynamicQuotaPublishingRequestThread(this.config(), this.metrics(), this.metadataCache(), this.networkClient(), this.kafkaScheduler(), (Time)this.time());

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private NetworkClient networkClient() {
        return this.networkClient;
    }

    private KafkaScheduler kafkaScheduler() {
        return this.kafkaScheduler;
    }

    private Node broker1() {
        return this.broker1;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private MockTime time() {
        return this.time;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private DynamicQuotaReportingRequestThread reportingRequestThread() {
        return this.reportingRequestThread;
    }

    private DynamicQuotaPublishingRequestThread publishingRequestThread() {
        return this.publishingRequestThread;
    }

    private KafkaConfig config() {
        return KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "localhost:2181", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
    }

    @Test
    public void testGenerateEmptyMapWhenNoRequestsOutstanding() {
        Assertions.assertTrue((boolean)this.reportingRequestThread().generateRequests().isEmpty());
        Assertions.assertTrue((boolean)this.publishingRequestThread().generateRequests().isEmpty());
    }

    @Test
    public void testGenerateEntryWithoutActiveCoordinator() {
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.anyObject(), EasyMock.anyInt(), (ListenerName)EasyMock.anyObject())).andReturn((Object)None$.MODULE$).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.metadataCache()});
        ReportQuotaConsumptionRequestData.EntryData entryData = this.createEntryData("type", "name", "type1", 1.0, false);
        this.reportingRequestThread().addEntryForNode((Object)entryData);
        Assertions.assertTrue((boolean)this.reportingRequestThread().generateRequests().isEmpty());
    }

    @Test
    public void testGenerateOneReportEntry() {
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.anyObject(), EasyMock.anyInt(), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker1())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.metadataCache()});
        ReportQuotaConsumptionRequestData.EntryData entryData = this.createEntryData("type", "name", "type1", 1.0, false);
        this.reportingRequestThread().addEntryForNode((Object)entryData);
        Iterable requests = CollectionConverters$.MODULE$.CollectionHasAsScala(this.reportingRequestThread().generateRequests()).asScala();
        Assertions.assertEquals((int)1, (int)requests.size());
        Assertions.assertEquals((Object)this.broker1(), (Object)((RequestAndCompletionHandler)requests.head()).destination);
        ReportQuotaConsumptionRequestData data = new ReportQuotaConsumptionRequestData();
        data.setEntries(Arrays.asList(entryData));
        data.setBrokerId(this.brokerId());
        Assertions.assertEquals((Object)((ReportQuotaConsumptionRequest)new ReportQuotaConsumptionRequest.Builder(data).build()), (Object)((ReportQuotaConsumptionRequest.Builder)((RequestAndCompletionHandler)requests.head()).request).build());
        Assertions.assertTrue((boolean)this.reportingRequestThread().generateRequests().isEmpty());
    }

    private ReportQuotaConsumptionRequestData.EntryData createEntryData(String entityType, String entityName, String quotaType, double usage, boolean throttled) {
        ReportQuotaConsumptionRequestData.EntryData entryData = new ReportQuotaConsumptionRequestData.EntryData();
        entryData.entity().add(new ReportQuotaConsumptionRequestData.EntityData().setEntityType(entityType).setEntityName(entityName));
        entryData.consumptions().add(new ReportQuotaConsumptionRequestData.ConsumptionData().setQuotaType(quotaType).setUsage(usage).setThrottled(throttled));
        return entryData;
    }

    @Test
    public void testGenerateTwoReportEntryWithSameCoordinator() {
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.anyObject(), EasyMock.anyInt(), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker1())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.metadataCache()});
        ReportQuotaConsumptionRequestData.EntryData entryData1 = this.createEntryData("entityType1", "entityName1", "quotaType1", 1.0, false);
        ReportQuotaConsumptionRequestData.EntryData entryData2 = this.createEntryData("entityType2", "entityName2", "quotaType2", 2.0, true);
        this.reportingRequestThread().addEntryForNode((Object)entryData1);
        this.reportingRequestThread().addEntryForNode((Object)entryData2);
        Iterable requests = CollectionConverters$.MODULE$.CollectionHasAsScala(this.reportingRequestThread().generateRequests()).asScala();
        Assertions.assertEquals((int)1, (int)requests.size());
        Assertions.assertEquals((Object)this.broker1(), (Object)((RequestAndCompletionHandler)requests.head()).destination);
        ReportQuotaConsumptionRequestData data = new ReportQuotaConsumptionRequestData();
        data.setEntries(Arrays.asList(entryData1, entryData2));
        data.setBrokerId(this.brokerId());
        Assertions.assertEquals((Object)((ReportQuotaConsumptionRequest)new ReportQuotaConsumptionRequest.Builder(data).build()), (Object)((ReportQuotaConsumptionRequest.Builder)((RequestAndCompletionHandler)requests.head()).request).build());
        Assertions.assertTrue((boolean)this.reportingRequestThread().generateRequests().isEmpty());
    }

    @Test
    public void testGenerateMultipleReportEntryWithDifferentCoordinator() {
        Node broker2 = new Node(2, "host2", 10);
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.anyObject(), EasyMock.anyInt(), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker1())).times(2);
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.anyObject(), EasyMock.anyInt(), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)broker2)).times(2);
        EasyMock.replay((Object[])new Object[]{this.metadataCache()});
        ReportQuotaConsumptionRequestData.EntryData entryData1 = this.createEntryData("entityType", "entityName", "quotaType1", 1.0, false);
        ReportQuotaConsumptionRequestData.EntryData entryData2 = this.createEntryData("entityType", "entityName", "quotaType1", 3.0, true);
        this.reportingRequestThread().addEntryForNode((Object)entryData1);
        this.reportingRequestThread().addEntryForNode((Object)entryData2);
        ReportQuotaConsumptionRequestData.EntryData entryData3 = this.createEntryData("entityType", "entityName2", "quotaType2", 4.0, false);
        ReportQuotaConsumptionRequestData.EntryData entryData4 = this.createEntryData("entityType", "entityName3", "quotaType2", 5.0, true);
        this.reportingRequestThread().addEntryForNode((Object)entryData3);
        this.reportingRequestThread().addEntryForNode((Object)entryData4);
        Iterable requests = CollectionConverters$.MODULE$.CollectionHasAsScala(this.reportingRequestThread().generateRequests()).asScala();
        Assertions.assertEquals((int)2, (int)requests.size());
        Assertions.assertEquals((Object)((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[]{this.broker1(), broker2}))), (Object)((IterableOnceOps)requests.map((Function1 & Serializable)requestHandler -> requestHandler.destination)).toSet());
        ReportQuotaConsumptionRequestData data = new ReportQuotaConsumptionRequestData();
        data.setEntries(Arrays.asList(entryData1, entryData2));
        data.setBrokerId(this.brokerId());
        ReportQuotaConsumptionRequest expectedBroker1Request = (ReportQuotaConsumptionRequest)new ReportQuotaConsumptionRequest.Builder(data).build();
        ReportQuotaConsumptionRequestData data2 = new ReportQuotaConsumptionRequestData();
        data2.setEntries(Arrays.asList(entryData3, entryData4));
        data2.setBrokerId(this.brokerId());
        ReportQuotaConsumptionRequest expectedBroker2Request = (ReportQuotaConsumptionRequest)new ReportQuotaConsumptionRequest.Builder(data2).build();
        Assertions.assertEquals((Object)((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ReportQuotaConsumptionRequest[]{expectedBroker1Request, expectedBroker2Request}))), (Object)((IterableOnceOps)requests.map((Function1 & Serializable)requestHandler -> (ReportQuotaConsumptionRequest)((ReportQuotaConsumptionRequest.Builder)requestHandler.request).build())).toSet());
        Assertions.assertTrue((boolean)this.reportingRequestThread().generateRequests().isEmpty());
    }

    @Test
    public void testGenerateOnePublishEntry() {
        this.generateMPublishEntriesWithNBrokers(1, 1);
    }

    @Test
    public void testGenerateTwoPublishEntryWithSameBroker() {
        this.generateMPublishEntriesWithNBrokers(2, 1);
    }

    @Test
    public void testGenerateTwoPublishEntryWithDifferentBrokers() {
        this.generateMPublishEntriesWithNBrokers(2, 2);
    }

    @Test
    public void testGenerateMultiplePublishEntryWithDifferentBrokers() {
        this.generateMPublishEntriesWithNBrokers(3, 2);
    }

    private void generateMPublishEntriesWithNBrokers(int numEntries, int numBrokers) {
        ArrayBuffer nodes = new ArrayBuffer();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numBrokers).foreach((Function1 & Serializable)i -> DynamicQuotaChannelManagerTest.$anonfun$generateMPublishEntriesWithNBrokers$1(this, nodes, numEntries, numBrokers, BoxesRunTime.unboxToInt((Object)i)));
        EasyMock.replay((Object[])new Object[]{this.metadataCache()});
        Map entryDataMap = ((Map)Map$.MODULE$.empty()).withDefaultValue(ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numEntries).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
            int brokerId = (j - 1) % numBrokers + 1;
            PublishQuotaTargetRequestData.EntryData entry = this.createPublishQuotaEntryData("entityType", new StringBuilder(10).append("entityName").append(brokerId).toString(), new StringBuilder(9).append("quotaType").append(j).toString(), j);
            entryDataMap.update((Object)BoxesRunTime.boxToInteger((int)brokerId), ((SeqOps)entryDataMap.apply((Object)BoxesRunTime.boxToInteger((int)brokerId))).$plus$colon((Object)entry));
            this.publishingRequestThread().addEntryForNode((Object)entry, (Option)new Some(nodes.apply(brokerId - 1)));
        });
        Iterable requests = CollectionConverters$.MODULE$.CollectionHasAsScala(this.publishingRequestThread().generateRequests()).asScala();
        Assertions.assertEquals((int)numBrokers, (int)requests.size());
        Assertions.assertEquals((Object)nodes, (Object)requests.map((Function1 & Serializable)requestHandler -> requestHandler.destination));
        ObjectRef expectedRequests = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        entryDataMap.foreach((Function1 & Serializable)x0$1 -> {
            DynamicQuotaChannelManagerTest.$anonfun$generateMPublishEntriesWithNBrokers$4(expectedRequests, x0$1);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)((scala.collection.immutable.Set)expectedRequests.elem), (Object)((IterableOnceOps)requests.map((Function1 & Serializable)requestHandler -> (PublishQuotaTargetRequest)((PublishQuotaTargetRequest.Builder)requestHandler.request).build())).toSet());
        Assertions.assertTrue((boolean)this.publishingRequestThread().generateRequests().isEmpty());
    }

    private PublishQuotaTargetRequestData.EntryData createPublishQuotaEntryData(String entityType, String entityName, String quotaType, double quota) {
        PublishQuotaTargetRequestData.EntryData entryData = new PublishQuotaTargetRequestData.EntryData();
        entryData.entity().add(new PublishQuotaTargetRequestData.EntityData().setEntityType(entityType).setEntityName(entityName));
        entryData.quotas().add(new PublishQuotaTargetRequestData.QuotaData().setQuotaType(quotaType).setQuota(quota));
        return entryData;
    }

    public static final /* synthetic */ IExpectationSetters $anonfun$generateMPublishEntriesWithNBrokers$1(DynamicQuotaChannelManagerTest $this, ArrayBuffer nodes$1, int numEntries$1, int numBrokers$1, int i) {
        Node node = new Node(i, new StringBuilder(4).append("host").append(i).toString(), 10);
        nodes$1.$plus$eq((Object)node);
        return EasyMock.expect((Object)$this.metadataCache().getAliveBrokerNode(i, $this.config().interBrokerListenerName())).andReturn((Object)new Some((Object)node)).times(numEntries$1 / numBrokers$1 + numEntries$1 % numBrokers$1);
    }

    public static final /* synthetic */ void $anonfun$generateMPublishEntriesWithNBrokers$4(ObjectRef expectedRequests$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ListBuffer entryData = (ListBuffer)x0$1._2();
            PublishQuotaTargetRequestData data = new PublishQuotaTargetRequestData().setEntries(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)entryData.reverse()).asJava());
            PublishQuotaTargetRequest expectedBrokerIRequest = (PublishQuotaTargetRequest)new PublishQuotaTargetRequest.Builder(data).build();
            expectedRequests$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)expectedRequests$1.elem).$plus((Object)expectedBrokerIRequest);
            return;
        }
        throw new MatchError(null);
    }

    public DynamicQuotaChannelManagerTest() {
        this.brokerId = 1;
        this.reportingRequestThread().started_$eq(true);
        this.publishingRequestThread().started_$eq(true);
    }
}

