/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.net.Socket;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.server.BaseFetchRequestTest;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.RangeAssignor;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dc\u0001\u0002\n\u0014\u0001aAQ!\b\u0001\u0005\u0002yAq\u0001\t\u0001C\u0002\u0013\u0005\u0011\u0005\u0003\u0004)\u0001\u0001\u0006IA\t\u0005\bS\u0001\u0011\r\u0011\"\u0001\"\u0011\u0019Q\u0003\u0001)A\u0005E!91\u0006\u0001b\u0001\n\u0003a\u0003BB\u001b\u0001A\u0003%Q\u0006C\u00047\u0001\t\u0007I\u0011A\u0011\t\r]\u0002\u0001\u0015!\u0003#\u0011\u001dA\u0004A1A\u0005\u0002\u0005Ba!\u000f\u0001!\u0002\u0013\u0011\u0003\"\u0002\u001e\u0001\t\u0003Y\u0004\"\u0002\"\u0001\t\u0003\u001a\u0005\"B'\u0001\t\u0003q\u0005bBA\u0004\u0001\u0011\u0005\u0011\u0011\u0002\u0005\b\u0003O\u0001A\u0011AA\u0015\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003k\u0011\u0001ER3uG\"4%o\\7G_2dwn^3s\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u0011A#F\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003Y\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00013A\u0011!dG\u0007\u0002'%\u0011Ad\u0005\u0002\u0015\u0005\u0006\u001cXMR3uG\"\u0014V-];fgR$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u000e\u0001\u0003!qW/\u001c(pI\u0016\u001cX#\u0001\u0012\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\u0007%sG/A\u0005ok6tu\u000eZ3tA\u0005Aa.^7QCJ$8/A\u0005ok6\u0004\u0016M\u001d;tA\u0005)Ao\u001c9jGV\tQ\u0006\u0005\u0002/g5\tqF\u0003\u00021c\u0005!A.\u00198h\u0015\u0005\u0011\u0014\u0001\u00026bm\u0006L!\u0001N\u0018\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005qA.Z1eKJ\u0014%o\\6fe&#\u0017a\u00047fC\u0012,'O\u0011:pW\u0016\u0014\u0018\n\u001a\u0011\u0002!\u0019|G\u000e\\8xKJ\u0014%o\\6fe&#\u0017!\u00054pY2|w/\u001a:Ce>\\WM]%eA\u0005yqN^3se&$\u0017N\\4Qe>\u00048/F\u0001=!\ti\u0004)D\u0001?\u0015\ty\u0014'\u0001\u0003vi&d\u0017BA!?\u0005)\u0001&o\u001c9feRLWm]\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgV\tA\tE\u0002F\u0011*k\u0011A\u0012\u0006\u0003\u000f\u0012\n!bY8mY\u0016\u001cG/[8o\u0013\tIeIA\u0002TKF\u0004\"AG&\n\u00051\u001b\"aC&bM.\f7i\u001c8gS\u001e\fq\u0006^3ti\u001a{G\u000e\\8xKJ\u001cu.\u001c9mKR,G)\u001a7bs\u0016$g)\u001a;dQ\u0016\u001cxJ\u001c*fa2L7-\u0019;j_:$2a\u0014*_!\t\u0019\u0003+\u0003\u0002RI\t!QK\\5u\u0011\u0015\u0019f\u00021\u0001U\u0003\u0019\tXo\u001c:v[B\u0011Q\u000b\u0018\b\u0003-j\u0003\"a\u0016\u0013\u000e\u0003aS!!W\f\u0002\rq\u0012xn\u001c;?\u0013\tYF%\u0001\u0004Qe\u0016$WMZ\u0005\u0003iuS!a\u0017\u0013\t\u000b}s\u0001\u0019\u0001+\u0002\u001fI,\u0007\u000f\\5dCRLwN\\'pI\u0016DCAD1n]B\u0011!m[\u0007\u0002G*\u0011A-Z\u0001\u0007a\u0006\u0014\u0018-\\:\u000b\u0005\u0019<\u0017a\u00026va&$XM\u001d\u0006\u0003Q&\fQA[;oSRT\u0011A[\u0001\u0004_J<\u0017B\u00017d\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0005]\u0006lW-I\u0001p\u0003!ZH-[:qY\u0006Lh*Y7f{:\nXo\u001c:v[vZ\b' \u0018sKBd\u0017nY1uS>tWh_\u0019~Q\u0011q\u0011o\u001e=\u0011\u0005I,X\"A:\u000b\u0005Q\u001c\u0017\u0001\u00039s_ZLG-\u001a:\n\u0005Y\u001c(\u0001D'fi\"|GmU8ve\u000e,\u0017!\u0002<bYV,G&A=\"\u0003i\fA&\u00117m'V\u0004\bo\u001c:uK\u0012\fVo\u001c:v[\u0006sGMU3qY&\u001c\u0017\r^5p]\u000e{WNY5oCRLwN\\:)\u000b9ax/!\u0002\u0011\u0007u\f\t!D\u0001\u007f\u0015\tyX-A\u0002ba&L1!a\u0001\u007f\u0005\u001d!\u0016.\\3pkRt\u0012aD\u0001:i\u0016\u001cHOR3uG\"4%o\\7MK\u0006$WM],iS2,\u0007K]3gKJ\u0014X\r\u001a*fC\u0012\u0014V\r\u001d7jG\u0006L5/\u00168bm\u0006LG.\u00192mKR\u0019q*a\u0003\t\u000bM{\u0001\u0019\u0001+)\u000b=\tW.a\u0004\"\u0005\u0005E\u0011AI>eSN\u0004H.Y=OC6,WPL>be\u001e,X.\u001a8ug^KG\u000f\u001b(b[\u0016\u001cX\u0010K\u0004\u0010\u0003+\tY\"!\b\u0011\u0007I\f9\"C\u0002\u0002\u001aM\u00141BV1mk\u0016\u001cv.\u001e:dK\u000691\u000f\u001e:j]\u001e\u001cH\u0006BA\u0010\u0003G\t#!!\t\u0002\u0005i\\\u0017EAA\u0013\u0003\u0015Y'/\u00194u\u0003u!Xm\u001d;GKR\u001c\u0007N\u0012:p[\u001a{G\u000e\\8xKJ<\u0016\u000e\u001e5S_2dGcA(\u0002,!)1\u000b\u0005a\u0001)\"*\u0001#Y7\u0002\u0010!:\u0001#!\u0006\u0002\u001c\u0005EB\u0006BA\u0010\u0003G\t!\u0004^3tiJ\u000b7m[!xCJ,'+\u00198hK\u0006\u001b8/[4o_J$2aTA\u001c\u0011\u0015\u0019\u0016\u00031\u0001UQ\r\t\u00121\b\t\u0004{\u0006u\u0012bAA }\nAA)[:bE2,G\rK\u0003\u0012C6\fy\u0001K\u0004\u0012\u0003+\tY\"!\u0012-\t\u0005}\u00111\u0005")
public class FetchFromFollowerIntegrationTest
extends BaseFetchRequestTest {
    private final int numNodes;
    private final int numParts;
    private final String topic;
    private final int leaderBrokerId;
    private final int followerBrokerId;

    public int numNodes() {
        return this.numNodes;
    }

    public int numParts() {
        return this.numParts;
    }

    public String topic() {
        return this.topic;
    }

    public int leaderBrokerId() {
        return this.leaderBrokerId;
    }

    public int followerBrokerId() {
        return this.followerBrokerId;
    }

    public Properties overridingProps() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.NumPartitionsProp(), Integer.toString(this.numParts()));
        props.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), Integer.toString(this.numNodes()));
        props.put(KafkaConfig$.MODULE$.UnstableMetadataVersionsEnableProp(), "true");
        props.put(KafkaConfig$.MODULE$.UnstableApiVersionsEnableProp(), "true");
        this.maybeEnablePushReplication(props);
        return props;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$12 = this.numNodes();
        String x$2 = this.zkConnectOrNull();
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        boolean x$11 = false;
        boolean x$122 = false;
        Map x$13 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        int x$14 = 1;
        boolean x$15 = false;
        int x$16 = 1;
        short x$17 = 1;
        int x$18 = 0;
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$12, x$2, false, x$5, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$122, (Map<Object, String>)x$13, x$14, x$15, x$16, x$17, x$18, true).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinations"})
    @Timeout(value=15L)
    public void testFollowerCompleteDelayedFetchesOnReplication(String quorum, String replicationMode) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$22 = this.topic();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        scala.collection.immutable.Map x$5 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.leaderBrokerId(), this.followerBrokerId()})))}));
        int x$6 = 1;
        int x$7 = 1;
        Properties x$8 = new Properties();
        scala.collection.immutable.Map<Object, Object> partitionLeaders = TestUtils$.MODULE$.createTopicWithAdmin(admin, x$22, x$3, x$4, x$6, x$7, (Map<Object, Seq<Object>>)x$5, x$8);
        TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), new TopicPartition(this.topic(), 0), 15000L);
        Assertions.assertTrue((boolean)partitionLeaders.values().forall((Function1)(JFunction1.mcZI.sp & Serializable)x$2 -> x$2 == this.leaderBrokerId()));
        short version = ApiKeys.FETCH.latestVersion();
        TopicPartition topicPartition = new TopicPartition(this.topic(), 0);
        scala.collection.immutable.Map offsetMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)0L))}));
        this.maybeWaitUntilReplicasInPushMode(topicPartition);
        FetchRequest fetchRequest = this.createConsumerFetchRequest(1000, 1000, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)offsetMap, version, 20000, 1, this.createConsumerFetchRequest$default$8());
        try (Socket socket = this.connect(this.brokerSocketServer(this.followerBrokerId()), this.connect$default$2());){
            this.send((AbstractRequest)fetchRequest, socket, this.send$default$3(), this.send$default$4());
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.topic(), 1, -1);
            FetchResponse response = (FetchResponse)this.receive(socket, ApiKeys.FETCH, version, ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
            Assertions.assertEquals((Object)Errors.NONE, (Object)response.error());
            Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.NONE), (Object)BoxesRunTime.boxToInteger((int)2))}))).asJava(), (Object)response.errorCounts());
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchFromLeaderWhilePreferredReadReplicaIsUnavailable(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.topic();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        scala.collection.immutable.Map x$5 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.leaderBrokerId(), this.followerBrokerId()})))}));
        int x$6 = 1;
        int x$7 = 1;
        Properties x$8 = new Properties();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$6, x$7, (Map<Object, Seq<Object>>)x$5, x$8);
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.topic(), 10, -1);
        Assertions.assertEquals((int)1, (int)this.getPreferredReplica(this.topic(), this.leaderBrokerId(), this.followerBrokerId()));
        ((KafkaBroker)this.brokers().apply(this.followerBrokerId())).shutdown();
        TopicPartition topicPartition = new TopicPartition(this.topic(), 0);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!FetchFromFollowerIntegrationTest.$anonfun$testFetchFromLeaderWhilePreferredReadReplicaIsUnavailable$1(this, topicPartition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"follower is still reachable.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)-1, (int)this.getPreferredReplica(this.topic(), this.leaderBrokerId(), this.followerBrokerId()));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchFromFollowerWithRoll(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.topic();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        scala.collection.immutable.Map x$5 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.leaderBrokerId(), this.followerBrokerId()})))}));
        int x$6 = 1;
        int x$7 = 1;
        Properties x$8 = new Properties();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$6, x$7, (Map<Object, Seq<Object>>)x$5, x$8);
        Properties consumerProps = new Properties();
        consumerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        consumerProps.put("group.id", "test-group");
        consumerProps.put("auto.offset.reset", "earliest");
        consumerProps.put("client.rack", Integer.toString(this.followerBrokerId()));
        try (KafkaConsumer consumer = new KafkaConsumer(consumerProps, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());){
            consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!FetchFromFollowerIntegrationTest.$anonfun$testFetchFromFollowerWithRoll$1(this)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Preferred replica is not set");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.topic(), 1, -1);
            TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, 15000L);
            ((KafkaBroker)this.brokers().apply(this.followerBrokerId())).shutdown();
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.topic(), 1, -1);
            TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, 15000L);
            ((KafkaBroker)this.brokers().apply(this.followerBrokerId())).startup();
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!FetchFromFollowerIntegrationTest.$anonfun$testFetchFromFollowerWithRoll$3(this)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"Preferred replica is not set");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.topic(), 1, -1);
            TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, 15000L);
        }
    }

    @Disabled
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testRackAwareRangeAssignor(String quorum) {
        List partitionList = this.brokers().indices().toList();
        String topicWithAllPartitionsOnAllRacks = "topicWithAllPartitionsOnAllRacks";
        this.createTopic(topicWithAllPartitionsOnAllRacks, this.brokers().size(), this.brokers().size(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        String topicWithSingleRackPartitions = "topicWithSingleRackPartitions";
        this.createTopicWithAssignment(topicWithSingleRackPartitions, (Map<Object, Seq<Object>>)partitionList.map((Function1 & Serializable)i -> FetchFromFollowerIntegrationTest.$anonfun$testRackAwareRangeAssignor$1(this, BoxesRunTime.unboxToInt((Object)i))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), this.createTopicWithAssignment$default$3());
        this.consumerConfig().setProperty("partition.assignment.strategy", RangeAssignor.class.getName());
        Buffer consumers = (Buffer)this.brokers().map((Function1 & Serializable)server -> {
            this.consumerConfig().setProperty("auto.offset.reset", "earliest");
            this.consumerConfig().setProperty("client.rack", (String)server.config().rack().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            this.consumerConfig().setProperty("group.instance.id", new StringBuilder(9).append("instance-").append(server.config().brokerId()).toString());
            this.consumerConfig().setProperty("metadata.max.age.ms", "1000");
            return this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        });
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        ExecutorService executor = Executors.newFixedThreadPool(consumers.size());
        try {
            consumers.foreach((Function1 & Serializable)x$3 -> {
                x$3.subscribe(Collections.singleton(topicWithSingleRackPartitions));
                return BoxedUnit.UNIT;
            });
            FetchFromFollowerIntegrationTest.verifyAssignments$1(partitionList.reverse(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicWithSingleRackPartitions}), consumers, executor, producer);
            consumers.foreach((Function1 & Serializable)x$4 -> {
                x$4.subscribe(Collections.singleton(topicWithAllPartitionsOnAllRacks));
                return BoxedUnit.UNIT;
            });
            FetchFromFollowerIntegrationTest.verifyAssignments$1(partitionList, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicWithAllPartitionsOnAllRacks}), consumers, executor, producer);
            consumers.foreach((Function1 & Serializable)x$5 -> {
                x$5.subscribe((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicWithSingleRackPartitions, topicWithAllPartitionsOnAllRacks}))).asJava());
                return BoxedUnit.UNIT;
            });
            FetchFromFollowerIntegrationTest.verifyAssignments$1(partitionList.reverse(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicWithAllPartitionsOnAllRacks, topicWithSingleRackPartitions}), consumers, executor, producer);
            Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
            HashMap reassignments = new HashMap();
            partitionList.foreach((Function1 & Serializable)p -> FetchFromFollowerIntegrationTest.$anonfun$testRackAwareRangeAssignor$18(reassignments, topicWithSingleRackPartitions, BoxesRunTime.unboxToInt((Object)p)));
            admin.alterPartitionReassignments(reassignments).all().get(30L, TimeUnit.SECONDS);
            FetchFromFollowerIntegrationTest.verifyAssignments$1(partitionList, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicWithAllPartitionsOnAllRacks, topicWithSingleRackPartitions}), consumers, executor, producer);
        }
        finally {
            executor.shutdownNow();
        }
    }

    public static final /* synthetic */ boolean $anonfun$testFetchFromLeaderWhilePreferredReadReplicaIsUnavailable$1(FetchFromFollowerIntegrationTest $this, TopicPartition topicPartition$1) {
        return !((KafkaBroker)$this.brokers().apply($this.leaderBrokerId())).metadataCache().getPartitionReplicaEndpoints(topicPartition$1, $this.listenerName()).contains((Object)BoxesRunTime.boxToInteger((int)$this.followerBrokerId()));
    }

    public static final /* synthetic */ String $anonfun$testFetchFromLeaderWhilePreferredReadReplicaIsUnavailable$2() {
        return "follower is still reachable.";
    }

    public static final /* synthetic */ boolean $anonfun$testFetchFromFollowerWithRoll$1(FetchFromFollowerIntegrationTest $this) {
        return $this.getPreferredReplica($this.topic(), $this.leaderBrokerId(), $this.followerBrokerId()) == 1;
    }

    public static final /* synthetic */ String $anonfun$testFetchFromFollowerWithRoll$2() {
        return "Preferred replica is not set";
    }

    public static final /* synthetic */ boolean $anonfun$testFetchFromFollowerWithRoll$3(FetchFromFollowerIntegrationTest $this) {
        return $this.getPreferredReplica($this.topic(), $this.leaderBrokerId(), $this.followerBrokerId()) == 1;
    }

    public static final /* synthetic */ String $anonfun$testFetchFromFollowerWithRoll$4() {
        return "Preferred replica is not set";
    }

    public static final /* synthetic */ Tuple2 $anonfun$testRackAwareRangeAssignor$1(FetchFromFollowerIntegrationTest $this, int i) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.brokers().size() - i - 1})));
    }

    public static final /* synthetic */ scala.collection.immutable.Set $anonfun$testRackAwareRangeAssignor$3(scala.collection.immutable.Seq topics$1, int p) {
        return ((IterableOnceOps)topics$1.map((Function1 & Serializable)topic -> new TopicPartition(topic, p))).toSet();
    }

    public static final /* synthetic */ boolean $anonfun$testRackAwareRangeAssignor$7(Consumer consumer$1, scala.collection.immutable.Set expectedAssignment$1) {
        java.util.Set set = consumer$1.assignment();
        java.util.Set set2 = CollectionConverters$.MODULE$.SetHasAsJava((Set)expectedAssignment$1).asJava();
        return !(set != null ? !((Object)set).equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testRackAwareRangeAssignor$8(scala.collection.immutable.Set expectedAssignment$1, Consumer consumer$1) {
        return new StringBuilder(73).append("Timed out while awaiting expected assignment ").append(expectedAssignment$1).append(". The current assignment is ").append(consumer$1.assignment()).toString();
    }

    public static final /* synthetic */ void $anonfun$testRackAwareRangeAssignor$9(Future future) {
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt(future.get(30L, TimeUnit.SECONDS)));
    }

    public static final /* synthetic */ void $anonfun$testRackAwareRangeAssignor$13(List assignments$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            Future future = (Future)x0$3._1();
            int i = x0$3._2$mcI$sp();
            Seq records = (Seq)future.get(30L, TimeUnit.SECONDS);
            Assertions.assertEquals((Object)assignments$1.apply(i), (Object)((IterableOnceOps)records.map((Function1 & Serializable)r -> new TopicPartition(r.topic(), r.partition()))).toSet());
            return;
        }
        throw new MatchError(null);
    }

    private static final void verifyAssignments$1(List partitionOrder, scala.collection.immutable.Seq topics, Buffer consumers$1, ExecutorService executor$1, KafkaProducer producer$1) {
        List assignments = partitionOrder.map((Function1 & Serializable)p -> FetchFromFollowerIntegrationTest.$anonfun$testRackAwareRangeAssignor$3(topics, BoxesRunTime.unboxToInt((Object)p)));
        ((Buffer)((IterableOps)consumers$1.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Consumer consumer = (Consumer)x0$1._1();
                int i = x0$1._2$mcI$sp();
                return executor$1.submit(() -> {
                    scala.collection.immutable.Set expectedAssignment = (scala.collection.immutable.Set)assignments.apply(i);
                    long pollUntilTrue_waitTimeMs = 30000L;
                    long pollUntilTrue_waitUntilTrue_pause = 0L;
                    long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
                    while (true) {
                        consumer.poll(Duration.ofMillis(100L));
                        if (FetchFromFollowerIntegrationTest.$anonfun$testRackAwareRangeAssignor$7(consumer, expectedAssignment)) break;
                        if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                            Assertions.fail((String)FetchFromFollowerIntegrationTest.$anonfun$testRackAwareRangeAssignor$8(expectedAssignment, consumer));
                        }
                        Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(pollUntilTrue_waitTimeMs), pollUntilTrue_waitUntilTrue_pause));
                    }
                }, BoxesRunTime.boxToInteger((int)0));
            }
            throw new MatchError(null);
        })).foreach((Function1 & Serializable)future -> {
            FetchFromFollowerIntegrationTest.$anonfun$testRackAwareRangeAssignor$9(future);
            return BoxedUnit.UNIT;
        });
        ((List)assignments.flatten(Predef$.MODULE$.$conforms())).foreach((Function1 & Serializable)tp -> producer$1.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), (Object)new StringBuilder(4).append("key-").append(tp).toString().getBytes(), (Object)new StringBuilder(6).append("value-").append(tp).toString().getBytes())));
        ((IterableOnceOps)((Buffer)((IterableOps)consumers$1.zipWithIndex()).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                Consumer consumer = (Consumer)x0$2._1();
                int i = x0$2._2$mcI$sp();
                return executor$1.submit(() -> TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, ((IterableOnceOps)assignments.apply(i)).size(), 30000L));
            }
            throw new MatchError(null);
        })).zipWithIndex()).foreach((Function1 & Serializable)x0$3 -> {
            FetchFromFollowerIntegrationTest.$anonfun$testRackAwareRangeAssignor$13(assignments, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Optional $anonfun$testRackAwareRangeAssignor$18(HashMap reassignments$1, String topicWithSingleRackPartitions$1, int p) {
        NewPartitionReassignment newAssignment = new NewPartitionReassignment(Collections.singletonList(Predef$.MODULE$.int2Integer(p)));
        return reassignments$1.put(new TopicPartition(topicWithSingleRackPartitions$1, p), Optional.of(newAssignment));
    }

    public FetchFromFollowerIntegrationTest() {
        this.numNodes = 2;
        this.numParts = 1;
        this.topic = "test-fetch-from-follower";
        this.leaderBrokerId = 0;
        this.followerBrokerId = 1;
    }
}

