/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.Socket;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.server.BaseFetchRequestTest;
import kafka.server.FetchRequestTest$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.record.BrokerCompressionType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005\t\u0005a\u0001B\r\u001b\u0001}AQ\u0001\n\u0001\u0005\u0002\u0015BQa\n\u0001\u0005\u0002!BQ!\u0017\u0001\u0005\u0002iCQa\u0018\u0001\u0005\u0002\u0001DQ!\u001a\u0001\u0005\u0002\u0019DQa\u001b\u0001\u0005\u00021DQ!\u001d\u0001\u0005\nIDQ\u0001\u001f\u0001\u0005\u0002eDQA \u0001\u0005\u0002}Dq!!\u0003\u0001\t\u0013\tY\u0001C\u0004\u0002\u0010\u0001!\t!!\u0005\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e!9\u0011q\u0005\u0001\u0005\n\u0005%\u0002bBA\u0017\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0003\u007f\u0001A\u0011BA!\u0011\u001d\tI\u0007\u0001C\u0001\u0003WBq!!\u001e\u0001\t\u0003\t9\bC\u0004\u0002\u0002\u0002!\t!a!\t\u000f\u00055\u0005\u0001\"\u0001\u0002\u0010\"9\u0011\u0011\u0014\u0001\u0005\u0002\u0005=\u0002bBAO\u0001\u0011\u0005\u0011q\u0014\u0005\b\u0003S\u0003A\u0011AAV\u0011\u001d\t)\f\u0001C\u0005\u0003oC\u0011\"!;\u0001#\u0003%I!a;\u0003!\u0019+Go\u00195SKF,Xm\u001d;UKN$(BA\u000e\u001d\u0003\u0019\u0019XM\u001d<fe*\tQ$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0001\u0003CA\u0011#\u001b\u0005Q\u0012BA\u0012\u001b\u0005Q\u0011\u0015m]3GKR\u001c\u0007NU3rk\u0016\u001cH\u000fV3ti\u00061A(\u001b8jiz\"\u0012A\n\t\u0003C\u0001\ta\u0006^3ti\n\u0013xn[3s%\u0016\u001c\b/Z2ugB\u000b'\u000f^5uS>t7o\u0014:eKJ\fe\u000eZ*ju\u0016d\u0015.\\5ugR\u0011\u0011f\f\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0005+:LG\u000fC\u00031\u0005\u0001\u0007\u0011'\u0001\u0004rk>\u0014X/\u001c\t\u0003eer!aM\u001c\u0011\u0005QZS\"A\u001b\u000b\u0005Yr\u0012A\u0002\u001fs_>$h(\u0003\u00029W\u00051\u0001K]3eK\u001aL!AO\u001e\u0003\rM#(/\u001b8h\u0015\tA4\u0006\u000b\u0003\u0003{%S\u0005C\u0001 H\u001b\u0005y$B\u0001!B\u0003\u0019\u0001\u0018M]1ng*\u0011!iQ\u0001\bUV\u0004\u0018\u000e^3s\u0015\t!U)A\u0003kk:LGOC\u0001G\u0003\ry'oZ\u0005\u0003\u0011~\u0012\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u0003-\u000b!e\u001f3jgBd\u0017-\u001f(b[\u0016lhf_1sOVlWM\u001c;t/&$\bNT1nKNl\b\u0006\u0002\u0002N'R\u0003\"AT)\u000e\u0003=S!\u0001U \u0002\u0011A\u0014xN^5eKJL!AU(\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\t)v+I\u0001W\u0003\tQ8.I\u0001Y\u0003\u0015Y'/\u00194u\u0003\r\"Xm\u001d;GKR\u001c\u0007NU3rk\u0016\u001cHO\u0016\u001bXSRD'+Z1e\u0007>lW.\u001b;uK\u0012$\"!K.\t\u000bA\u001a\u0001\u0019A\u0019)\t\ri\u0014J\u0013\u0015\u0005\u00075\u001bf\f\f\u0002V/\u0006aB/Z:u\r\u0016$8\r\u001b*fcV,7\u000f\u001e+p\u001d>t'+\u001a9mS\u000e\fGCA\u0015b\u0011\u0015\u0001D\u00011\u00012Q\u0011!Q(\u0013&)\t\u0011i5\u000b\u001a\u0017\u0003+^\u000ba\u0004^3ti2\u000b7\u000f\u001e$fi\u000eDW\rZ#q_\u000eDg+\u00197jI\u0006$\u0018n\u001c8\u0015\u0005%:\u0007\"\u0002\u0019\u0006\u0001\u0004\t\u0004\u0006B\u0003>\u0013*CC!B'TU2\u0012QkV\u0001\"i\u0016\u001cH\u000fT1ti\u001a+Go\u00195fI\u0016\u0003xn\u00195WC2LG-\u0019;j_:4\u0016G\r\u000b\u0003S5DQ\u0001\r\u0004A\u0002EBCAB\u001fJ\u0015\"\"a!T*qY\t)v+A\u0010dQ\u0016\u001c7\u000eT1ti\u001a+Go\u00195fI\u0016\u0003xn\u00195WC2LG-\u0019;j_:$\"!K:\t\u000bQ<\u0001\u0019A;\u0002\u000fY,'o]5p]B\u0011!F^\u0005\u0003o.\u0012Qa\u00155peR\f!\u0004^3ti\u000e+(O]3oi\u0016\u0003xn\u00195WC2LG-\u0019;j_:$\"!\u000b>\t\u000bAB\u0001\u0019A\u0019)\t!i\u0014J\u0013\u0015\u0005\u00115\u001bV\u0010\f\u0002V/\u0006iB/Z:u\u0007V\u0014(/\u001a8u\u000bB|7\r\u001b,bY&$\u0017\r^5p]Z\u000b$\u0007F\u0002*\u0003\u0003AQ\u0001M\u0005A\u0002EBC!C\u001fJ\u0015\"*\u0011\"T*\u0002\b1\u0012QkV\u0001\u001cG\",7m[\"veJ,g\u000e^#q_\u000eDg+\u00197jI\u0006$\u0018n\u001c8\u0015\u0007%\ni\u0001C\u0003u\u0015\u0001\u0007Q/A\u0013uKN$X\t]8dQZ\u000bG.\u001b3bi&|gnV5uQ&tg)\u001a;dQN+7o]5p]R\u0019\u0011&a\u0005\t\u000bAZ\u0001\u0019A\u0019)\t-i\u0014J\u0013\u0015\u0006\u00175\u001b\u0016\u0011\u0004\u0017\u0003+^\u000b\u0001\u0006^3ti\u0016\u0003xn\u00195WC2LG-\u0019;j_:<\u0016\u000e\u001e5j]\u001a+Go\u00195TKN\u001c\u0018n\u001c8WcI\"2!KA\u0010\u0011\u0015\u0001D\u00021\u00012Q\u0011aQ(\u0013&)\u000b1i5+!\n-\u0005U;\u0016AJ2iK\u000e\\W\t]8dQZ\u000bG.\u001b3bi&|gnV5uQ&tg)\u001a;dQN+7o]5p]R\u0019\u0011&a\u000b\t\u000bQl\u0001\u0019A;\u0002\u0003R,7\u000f\u001e$fi\u000eD'+Z9vKN$H)\u001e:j]\u001e\u0004\u0016M\u001d;ji&|gNU3d_Z,'/_!gi\u0016\u0014XK\\2mK\u0006tG*Z1eKJ,E.Z2uS>tG#A\u0015)\u00079\t\u0019\u0004\u0005\u0003\u00026\u0005mRBAA\u001c\u0015\r\tI$Q\u0001\u0004CBL\u0017\u0002BA\u001f\u0003o\u0011A\u0001V3ti\u0006Ab/\u001a:jMf4U\r^2i'\u0016\u001c8/[8o\u000bJ\u0014xN]:\u0015\u0013%\n\u0019%!\u0017\u0002d\u0005\u001d\u0004bBA#\u001f\u0001\u0007\u0011qI\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\u0011\tI%!\u0016\u000e\u0005\u0005-#\u0002BA'\u0003\u001f\naaY8n[>t'bA\u000f\u0002R)\u0019\u00111K#\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\t9&a\u0013\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"9\u00111L\bA\u0002\u0005u\u0013a\u00037fC\u0012,'/\u00129pG\"\u00042AKA0\u0013\r\t\tg\u000b\u0002\u0004\u0013:$\bbBA3\u001f\u0001\u0007\u0011QL\u0001\u0014I\u0016\u001cH/\u001b8bi&|gN\u0011:pW\u0016\u0014\u0018\n\u001a\u0005\u0006i>\u0001\r!^\u0001(i\u0016\u001cH\u000fR8x]\u000e{gN^3sg&|gnV5uQ\u000e{gN\\3di&|gNR1jYV\u0014X\rF\u0002*\u0003[BQ\u0001\r\tA\u0002EBC\u0001E\u001fJ\u0015\"*\u0001#T*\u0002t1\u0012QkV\u00017i\u0016\u001cH\u000fR8x]\u000e{gN^3sg&|gN\u0012:p[\n\u000bGo\u00195fIR{WK\u001c2bi\u000eDW\r\u001a*fgB,7\r^:PM\u001a\u001cX\r\u001e\u000b\u0004S\u0005e\u0004\"\u0002\u0019\u0012\u0001\u0004\t\u0004\u0006B\t>\u0013*CS!E'T\u0003\u007fb#!V,\u0002eQ,7\u000f^\"sK\u0006$X-\u00138de\u0016lWM\u001c;bY\u001a+Go\u00195XSRD\u0007+\u0019:uSRLwN\\:J]\u0016\u0013(o\u001c:WcI\"2!KAC\u0011\u0015\u0001$\u00031\u00012Q\u0011\u0011R(\u0013&)\u000bIi5+a#-\u0005U;\u0016A\t;fgR4U\r^2i/&$\b\u000eU1si&$\u0018n\u001c8t/&$\b.\u00133FeJ|'\u000fF\u0002*\u0003#CQ\u0001M\nA\u0002EBCaE\u001fJ\u0015\"*1#T*\u0002\u00182\u0012QkV\u0001\u0018i\u0016\u001cH\u000fU1si&$\u0018n\u001c8ECR\fW)];bYND3\u0001FA\u001a\u0003]!Xm\u001d;['R$7i\\7qe\u0016\u001c8/\u001a3U_BL7\rF\u0002*\u0003CCQ\u0001M\u000bA\u0002EBC!F\u001fJ\u0015\"*Q#T*\u0002(2\u0012QkV\u0001\u001ai\u0016\u001cHOW*uI\u000e{W\u000e\u001d:fgN,GMU3d_J$7\u000fF\u0002*\u0003[CQ\u0001\r\fA\u0002EBCAF\u001fJ\u0015\"*a#T*\u000242\u0012QkV\u0001\u0013G\",7m\u001b$fi\u000eD'+Z:q_:\u001cX\rF\u0007*\u0003s\u000bI-!7\u0002^\u0006\u0005\u0018Q\u001d\u0005\b\u0003w;\u0002\u0019AA_\u0003I)\u0007\u0010]3di\u0016$\u0007+\u0019:uSRLwN\\:\u0011\r\u0005}\u0016QYA$\u001b\t\t\tMC\u0002\u0002D.\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9-!1\u0003\u0007M+\u0017\u000fC\u0004\u0002L^\u0001\r!!4\u0002\u001b\u0019,Go\u00195SKN\u0004xN\\:f!\u0011\ty-!6\u000e\u0005\u0005E'\u0002BAj\u0003\u0017\n\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003/\f\tNA\u0007GKR\u001c\u0007NU3ta>t7/\u001a\u0005\b\u00037<\u0002\u0019AA/\u0003Ei\u0017\r\u001f)beRLG/[8o\u0005f$Xm\u001d\u0005\b\u0003?<\u0002\u0019AA/\u0003Ai\u0017\r\u001f*fgB|gn]3CsR,7\u000fC\u0004\u0002d^\u0001\r!!\u0018\u0002/9,X.T3tg\u0006<Wm\u001d)feB\u000b'\u000f^5uS>t\u0007\u0002CAt/A\u0005\t\u0019A;\u0002\u001fI,7\u000f]8og\u00164VM]:j_:\fAd\u00195fG.4U\r^2i%\u0016\u001c\bo\u001c8tK\u0012\"WMZ1vYR$c'\u0006\u0002\u0002n*\u001aQ/a<,\u0005\u0005E\b\u0003BAz\u0003{l!!!>\u000b\t\u0005]\u0018\u0011`\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a?,\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u007f\f)PA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class FetchRequestTest
extends BaseFetchRequestTest {
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testBrokerRespectsPartitionsOrderAndSizeLimits(String quorum) {
        this.initProducer();
        int messagesPerPartition = 9;
        int maxResponseBytes = 800;
        int maxPartitionBytes = 190;
        scala.collection.immutable.Map<TopicPartition, Object> topicPartitionToLeader = this.createTopics(5, 6, this.createTopics$default$3());
        Random random = new Random(0);
        Set topicPartitions = topicPartitionToLeader.keySet();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$1 -> x$1.swap())).asJava();
        this.produceData((Iterable<TopicPartition>)topicPartitions, messagesPerPartition);
        int leaderId = ((KafkaBroker)this.brokers().head()).config().brokerId();
        Vector partitionsForLeader = (Vector)topicPartitionToLeader.toVector().collect((PartialFunction)new Serializable(null, leaderId){
            private static final long serialVersionUID = 0L;
            private final int leaderId$1;

            public final <A1 extends Tuple2<TopicPartition, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 != null) {
                    TopicPartition tp = (TopicPartition)x1._1();
                    if (x1._2$mcI$sp() == this.leaderId$1) {
                        return (B1)tp;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<TopicPartition, Object> x1) {
                return x1 != null && x1._2$mcI$sp() == this.leaderId$1;
            }
            {
                this.leaderId$1 = leaderId$1;
            }
        });
        Vector partitionsWithLargeMessages = partitionsForLeader.takeRight(2);
        TopicPartition partitionWithLargeMessage1 = (TopicPartition)partitionsWithLargeMessages.head();
        TopicPartition partitionWithLargeMessage2 = (TopicPartition)partitionsWithLargeMessages.apply(1);
        this.producer().send(new ProducerRecord(partitionWithLargeMessage1.topic(), Predef$.MODULE$.int2Integer(partitionWithLargeMessage1.partition()), (Object)"larger than partition limit", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
        this.producer().send(new ProducerRecord(partitionWithLargeMessage2.topic(), Predef$.MODULE$.int2Integer(partitionWithLargeMessage2.partition()), (Object)"larger than response limit", (Object)new String(new byte[maxResponseBytes + 1]))).get();
        Vector partitionsWithoutLargeMessages = (Vector)partitionsForLeader.filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)partitionsWithLargeMessages.contains(elem)));
        Vector shuffledTopicPartitions1 = (Vector)((IterableOps)random.shuffle((IterableOnce)partitionsWithoutLargeMessages, BuildFrom$.MODULE$.buildFromIterableOps())).$plus$plus((IterableOnce)partitionsWithLargeMessages);
        FetchRequest fetchRequest1 = this.createConsumerFetchRequest$1((Seq)shuffledTopicPartitions1, FetchRequestTest.createConsumerFetchRequest$default$2$1(), ApiKeys.FETCH.latestVersion(), maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse1 = this.sendFetchRequest(leaderId, fetchRequest1);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions1, fetchResponse1, maxPartitionBytes, maxResponseBytes, messagesPerPartition, ApiKeys.FETCH.latestVersion());
        scala.collection.immutable.Map x$3 = FetchRequestTest.createConsumerFetchRequest$default$2$1();
        FetchRequest fetchRequest1V12 = this.createConsumerFetchRequest$1((Seq)shuffledTopicPartitions1, x$3, (short)12, maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse1V12 = this.sendFetchRequest(leaderId, fetchRequest1V12);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions1, fetchResponse1V12, maxPartitionBytes, maxResponseBytes, messagesPerPartition, (short)12);
        Vector shuffledTopicPartitions2 = (Vector)((IterableOps)random.shuffle((IterableOnce)partitionsWithoutLargeMessages, BuildFrom$.MODULE$.buildFromIterableOps())).$plus$plus((IterableOnce)partitionsWithLargeMessages);
        FetchRequest fetchRequest2 = this.createConsumerFetchRequest$1((Seq)shuffledTopicPartitions2, FetchRequestTest.createConsumerFetchRequest$default$2$1(), ApiKeys.FETCH.latestVersion(), maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse2 = this.sendFetchRequest(leaderId, fetchRequest2);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions2, fetchResponse2, maxPartitionBytes, maxResponseBytes, messagesPerPartition, ApiKeys.FETCH.latestVersion());
        scala.collection.immutable.Map x$6 = FetchRequestTest.createConsumerFetchRequest$default$2$1();
        FetchRequest fetchRequest2V12 = this.createConsumerFetchRequest$1((Seq)shuffledTopicPartitions2, x$6, (short)12, maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse2V12 = this.sendFetchRequest(leaderId, fetchRequest2V12);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions2, fetchResponse2V12, maxPartitionBytes, maxResponseBytes, messagesPerPartition, (short)12);
        Seq shuffledTopicPartitions3 = (Seq)new .colon.colon((Object)partitionWithLargeMessage1, (List)new .colon.colon((Object)partitionWithLargeMessage2, (List)Nil$.MODULE$)).$plus$plus((IterableOnce)random.shuffle((IterableOnce)partitionsWithoutLargeMessages, BuildFrom$.MODULE$.buildFromIterableOps()));
        FetchRequest fetchRequest3 = this.createConsumerFetchRequest$1(shuffledTopicPartitions3, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage1), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))})), ApiKeys.FETCH.latestVersion(), maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse3 = this.sendFetchRequest(leaderId, fetchRequest3);
        FetchRequest fetchRequest3V12 = this.createConsumerFetchRequest$1(shuffledTopicPartitions3, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage1), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))})), (short)12, maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse3V12 = this.sendFetchRequest(leaderId, fetchRequest3V12);
        this.evaluateResponse3$1(fetchResponse3, ApiKeys.FETCH.latestVersion(), topicNames, shuffledTopicPartitions3, maxResponseBytes, partitionWithLargeMessage1, maxPartitionBytes);
        this.evaluateResponse3$1(fetchResponse3V12, (short)12, topicNames, shuffledTopicPartitions3, maxResponseBytes, partitionWithLargeMessage1, maxPartitionBytes);
        Seq shuffledTopicPartitions4 = (Seq)new .colon.colon((Object)partitionWithLargeMessage2, (List)new .colon.colon((Object)partitionWithLargeMessage1, (List)Nil$.MODULE$)).$plus$plus((IterableOnce)random.shuffle((IterableOnce)partitionsWithoutLargeMessages, BuildFrom$.MODULE$.buildFromIterableOps()));
        FetchRequest fetchRequest4 = this.createConsumerFetchRequest$1(shuffledTopicPartitions4, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage2), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))})), ApiKeys.FETCH.latestVersion(), maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse4 = this.sendFetchRequest(leaderId, fetchRequest4);
        FetchRequest fetchRequest4V12 = this.createConsumerFetchRequest$1(shuffledTopicPartitions4, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage2), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))})), (short)12, maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse4V12 = this.sendFetchRequest(leaderId, fetchRequest4V12);
        this.evaluateResponse4$1(fetchResponse4, ApiKeys.FETCH.latestVersion(), topicNames, shuffledTopicPartitions4, partitionWithLargeMessage2, maxResponseBytes);
        this.evaluateResponse4$1(fetchResponse4V12, (short)12, topicNames, shuffledTopicPartitions4, partitionWithLargeMessage2, maxResponseBytes);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchRequestV4WithReadCommitted(String quorum) {
        void var4_4;
        this.initProducer();
        int maxPartitionBytes = 200;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int n = tuple2._2$mcI$sp();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$7 -> x$7.swap())).asJava();
        this.producer().send(new ProducerRecord(var4_4.topic(), Predef$.MODULE$.int2Integer(var4_4.partition()), (Object)"key", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((short)4, (int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)new .colon.colon((Object)var4_4, (List)Nil$.MODULE$), this.createPartitionMap$default$3(), this.createPartitionMap$default$4())).isolationLevel(IsolationLevel.READ_COMMITTED).build((short)4);
        FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)this.sendFetchRequest(n, fetchRequest).responseData(topicNames, (short)4).get(var4_4);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData.errorCode());
        Assertions.assertTrue((partitionData.lastStableOffset() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.records(partitionData).map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.sizeInBytes()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0 ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchRequestToNonReplica(String quorum) {
        String topic = "topic";
        int partition = 0;
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        scala.collection.immutable.Map<Object, Object> partitionToLeader = this.createTopic(topic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$9 -> x$9.swap())).asJava();
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        Option nonReplicaOpt = this.brokers().find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)FetchRequestTest.$anonfun$testFetchRequestToNonReplica$2(leader, x$10)));
        Assertions.assertTrue((boolean)nonReplicaOpt.isDefined());
        int nonReplicaId = ((KafkaBroker)nonReplicaOpt.get()).config().brokerId();
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((short)ApiKeys.FETCH.latestVersion(), (int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(1024, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), this.createPartitionMap$default$3(), this.createPartitionMap$default$4())).build();
        FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)this.sendFetchRequest(nonReplicaId, fetchRequest).responseData(topicNames, ApiKeys.FETCH.latestVersion()).get(topicPartition);
        Assertions.assertEquals((short)Errors.NOT_LEADER_OR_FOLLOWER.code(), (short)partitionData.errorCode());
        FetchRequest oldFetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((short)12, (int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(1024, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), this.createPartitionMap$default$3(), this.createPartitionMap$default$4())).build();
        FetchResponseData.PartitionData oldPartitionData = (FetchResponseData.PartitionData)this.sendFetchRequest(nonReplicaId, oldFetchRequest).responseData(topicNames, (short)12).get(topicPartition);
        Assertions.assertEquals((short)Errors.NOT_LEADER_OR_FOLLOWER.code(), (short)oldPartitionData.errorCode());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testLastFetchedEpochValidation(String quorum) {
        this.checkLastFetchedEpochValidation(ApiKeys.FETCH.latestVersion());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testLastFetchedEpochValidationV12(String quorum) {
        this.checkLastFetchedEpochValidation((short)12);
    }

    private void checkLastFetchedEpochValidation(short version) {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        scala.collection.immutable.Map<Object, Object> partitionToLeader = this.createTopic(topic, x$3, 3, x$4, x$5, x$6);
        TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), topicPartition, 15000L);
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        int firstLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(firstLeaderId, topicPartition, (Iterable<KafkaBroker>)this.brokers());
        this.initProducer();
        long firstEpochEndOffset = ((RecordMetadata)this.produceData((Iterable<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), 100).lastOption().get()).offset() + 1L;
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange(this.brokers(), topicPartition, firstLeaderId, 15000L);
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaBroker>)this.brokers());
        long secondEpochEndOffset = ((RecordMetadata)this.produceData((Iterable<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), 100).lastOption().get()).offset() + 1L;
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$11 -> x$11.swap())).asJava();
        long fetchOffset = secondEpochEndOffset + (secondEpochEndOffset - firstEpochEndOffset) / 2L;
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitionMap.put(topicPartition, new FetchRequest.PartitionData(topicIds.getOrDefault(topic, Uuid.ZERO_UUID), fetchOffset, 0L, 1024, Optional.empty(), Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), Optional.of(Predef$.MODULE$.int2Integer(firstLeaderEpoch))));
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((short)version, (int)0, (int)1, partitionMap).build();
        FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)this.sendFetchRequest(secondLeaderId, fetchRequest).responseData(topicNames, version).get(topicPartition);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData.errorCode());
        Assertions.assertEquals((long)0L, (long)FetchResponse.recordsSize((FetchResponseData.PartitionData)partitionData));
        Assertions.assertTrue((boolean)FetchResponse.isDivergingEpoch((FetchResponseData.PartitionData)partitionData));
        FetchResponseData.EpochEndOffset divergingEpoch = partitionData.divergingEpoch();
        Assertions.assertEquals((int)firstLeaderEpoch, (int)divergingEpoch.epoch());
        Assertions.assertEquals((long)firstEpochEndOffset, (long)divergingEpoch.endOffset());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCurrentEpochValidation(String quorum) {
        this.checkCurrentEpochValidation(ApiKeys.FETCH.latestVersion());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCurrentEpochValidationV12(String quorum) {
        this.checkCurrentEpochValidation((short)12);
    }

    private void checkCurrentEpochValidation(short version) {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(topic, x$3, 3, x$4, x$5, x$6).apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange(this.brokers(), topicPartition, firstLeaderId, 15000L);
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaBroker>)this.brokers());
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.empty(), topicPartition, topic, version);
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition, topic, version);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition, topic, version);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition, topic, version);
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaBroker>)this.brokers());
        this.assertResponseErrorForEpoch$1(Errors.NONE, followerId, Optional.empty(), topicPartition, topic, version);
        this.assertResponseErrorForEpoch$1(Errors.NONE, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition, topic, version);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition, topic, version);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition, topic, version);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testEpochValidationWithinFetchSession(String quorum) {
        this.checkEpochValidationWithinFetchSession(ApiKeys.FETCH.latestVersion());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testEpochValidationWithinFetchSessionV12(String quorum) {
        this.checkEpochValidationWithinFetchSession((short)12);
    }

    private void checkEpochValidationWithinFetchSession(short version) {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(topic, x$3, 3, x$4, x$5, x$6).apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange(this.brokers(), topicPartition, firstLeaderId, 15000L);
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaBroker>)this.brokers());
        this.verifyFetchSessionErrors(topicPartition, secondLeaderEpoch, secondLeaderId, version);
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaBroker>)this.brokers());
        this.verifyFetchSessionErrors(topicPartition, secondLeaderEpoch, followerId, version);
    }

    @Test
    public void testFetchRequestDuringPartitionRecoveryAfterUncleanLeaderElection() {
        String topic = "topic";
        TopicPartition partition = new TopicPartition(topic, 0);
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 2, (Seq<KafkaBroker>)this.servers(), new Properties());
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicNames()).asJava();
        Set replicas = this.zkClient().getReplicasForPartition(partition).toSet();
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition.partition())));
        int follower = BoxesRunTime.unboxToInt((Object)replicas.find((Function1)(JFunction1.mcZI.sp & Serializable)x$13 -> x$13 != leader).get());
        int nonReplica = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.servers().map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToInteger((int)FetchRequestTest.$anonfun$testFetchRequestDuringPartitionRecoveryAfterUncleanLeaderElection$2(x$14)))).find((Function1)(JFunction1.mcZI.sp & Serializable)x$15 -> !replicas.contains((Object)BoxesRunTime.boxToInteger((int)x$15))).get());
        TestUtils$.MODULE$.generateAndProduceMessages(this.servers(), topic, 1024, -1);
        TestUtils$.MODULE$.forceOverrideLeaderRecoveryState(((KafkaServer)this.servers().find((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)FetchRequestTest.$anonfun$testFetchRequestDuringPartitionRecoveryAfterUncleanLeaderElection$4(leader, x$16))).get()).replicaManager().getPartitionOrException(partition), LeaderRecoveryState.RECOVERED);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ApiKeys.FETCH.oldestVersion()), (int)ApiKeys.FETCH.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)ver -> {
            this.createFetchRequestsAndValidateResponses$1((short)ver, leader, Errors.NONE, Errors.NONE, partition, topicIds, topicNames, follower);
            Errors consumerError = ver >= 11 ? Errors.NONE : Errors.NOT_LEADER_OR_FOLLOWER;
            this.createFetchRequestsAndValidateResponses$1((short)ver, follower, consumerError, Errors.NOT_LEADER_OR_FOLLOWER, partition, topicIds, topicNames, follower);
            this.createFetchRequestsAndValidateResponses$1((short)ver, nonReplica, Errors.NOT_LEADER_OR_FOLLOWER, Errors.NOT_LEADER_OR_FOLLOWER, partition, topicIds, topicNames, follower);
        });
        TestUtils$.MODULE$.forceOverrideLeaderRecoveryState(((KafkaServer)this.servers().find((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)FetchRequestTest.$anonfun$testFetchRequestDuringPartitionRecoveryAfterUncleanLeaderElection$6(leader, x$17))).get()).replicaManager().getPartitionOrException(partition), LeaderRecoveryState.RECOVERING);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ApiKeys.FETCH.oldestVersion()), (int)ApiKeys.FETCH.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)ver -> {
            this.createFetchRequestsAndValidateResponses$1((short)ver, leader, Errors.NOT_LEADER_OR_FOLLOWER, Errors.NOT_LEADER_OR_FOLLOWER, partition, topicIds, topicNames, follower);
            Errors consumerError = ver >= 11 ? Errors.NONE : Errors.NOT_LEADER_OR_FOLLOWER;
            this.createFetchRequestsAndValidateResponses$1((short)ver, follower, consumerError, Errors.NOT_LEADER_OR_FOLLOWER, partition, topicIds, topicNames, follower);
            this.createFetchRequestsAndValidateResponses$1((short)ver, nonReplica, Errors.NOT_LEADER_OR_FOLLOWER, Errors.NOT_LEADER_OR_FOLLOWER, partition, topicIds, topicNames, follower);
        });
        TestUtils$.MODULE$.forceOverrideLeaderRecoveryState(((KafkaServer)this.servers().find((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)FetchRequestTest.$anonfun$testFetchRequestDuringPartitionRecoveryAfterUncleanLeaderElection$8(leader, x$18))).get()).replicaManager().getPartitionOrException(partition), LeaderRecoveryState.RECOVERED);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ApiKeys.FETCH.oldestVersion()), (int)ApiKeys.FETCH.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)ver -> {
            this.createFetchRequestsAndValidateResponses$1((short)ver, leader, Errors.NONE, Errors.NONE, partition, topicIds, topicNames, follower);
            Errors consumerError = ver >= 11 ? Errors.NONE : Errors.NOT_LEADER_OR_FOLLOWER;
            this.createFetchRequestsAndValidateResponses$1((short)ver, follower, consumerError, Errors.NOT_LEADER_OR_FOLLOWER, partition, topicIds, topicNames, follower);
            this.createFetchRequestsAndValidateResponses$1((short)ver, nonReplica, Errors.NOT_LEADER_OR_FOLLOWER, Errors.NOT_LEADER_OR_FOLLOWER, partition, topicIds, topicNames, follower);
        });
    }

    private void verifyFetchSessionErrors(TopicPartition topicPartition, int leaderEpoch, int destinationBrokerId, short version) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$19 -> x$19.swap())).asJava();
        partitionMap.put(topicPartition, new FetchRequest.PartitionData(topicIds.getOrDefault(topicPartition.topic(), Uuid.ZERO_UUID), 0L, 0L, 1024, Optional.empty(), Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), Optional.empty()));
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((short)version, (int)0, (int)1, partitionMap).metadata(FetchMetadata.INITIAL).build();
        int sessionId = this.sendFetchRequest(destinationBrokerId, fetchRequest).sessionId();
        this.assertResponseErrorForEpoch$2(Errors.FENCED_LEADER_EPOCH, 1, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), topicPartition, topicIds, version, sessionId, destinationBrokerId, topicNames);
        this.assertResponseErrorForEpoch$2(Errors.UNKNOWN_LEADER_EPOCH, 2, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), topicPartition, topicIds, version, sessionId, destinationBrokerId, topicNames);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDownConversionWithConnectionFailure(String quorum) {
        IndexedSeq indexedSeq;
        void var3_3;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int n = tuple2._2$mcI$sp();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$21 -> x$21.swap())).asJava();
        int msgValueLen = 100000;
        int batchSize = 4 * msgValueLen;
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        StringSerializer x$5 = new StringSerializer();
        ByteArraySerializer x$6 = new ByteArraySerializer();
        int x$7 = -1;
        long x$8 = 60000L;
        long x$9 = 0x100000L;
        int x$10 = Integer.MAX_VALUE;
        String x$11 = "none";
        int x$12 = 20000;
        SecurityProtocol x$13 = SecurityProtocol.PLAINTEXT;
        None$ x$14 = None$.MODULE$;
        None$ x$15 = None$.MODULE$;
        boolean x$16 = false;
        byte[] bytes = new byte[msgValueLen];
        try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$1, x$7, x$8, x$9, x$10, Integer.MAX_VALUE, Integer.MAX_VALUE, batchSize, x$11, x$12, x$13, (Option<File>)x$14, (Option<Properties>)x$15, x$5, x$6, x$16);){
            indexedSeq = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 1000).map(arg_0 -> FetchRequestTest.$anonfun$testDownConversionWithConnectionFailure$2$adapted(producer, (TopicPartition)var3_3, bytes, arg_0));
        }
        indexedSeq.foreach((Function1 & Serializable)x$23 -> (RecordMetadata)x$23.get());
        short version = (short)1;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 15).foreach(arg_0 -> FetchRequestTest.$anonfun$testDownConversionWithConnectionFailure$4$adapted(this, version, msgValueLen, (TopicPartition)var3_3, n, batchSize, arg_0));
        FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)((FetchResponse)this.fetch$1(version, batchSize, false, (TopicPartition)var3_3, n, batchSize).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("No fetch response");
        })).responseData(topicNames, version).get(var3_3);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData.errorCode());
        Buffer batches = CollectionConverters$.MODULE$.IterableHasAsScala(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData).batches()).asScala().toBuffer();
        Assertions.assertEquals((int)3, (int)batches.size());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDownConversionFromBatchedToUnbatchedRespectsOffset(String quorum) {
        void var19_17;
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        StringSerializer x$3 = new StringSerializer();
        StringSerializer x$4 = new StringSerializer();
        int x$7 = -1;
        long x$8 = 60000L;
        long x$9 = 0x100000L;
        int x$10 = 16384;
        String x$11 = "none";
        int x$12 = 20000;
        SecurityProtocol x$13 = SecurityProtocol.PLAINTEXT;
        None$ x$14 = None$.MODULE$;
        None$ x$15 = None$.MODULE$;
        boolean x$16 = false;
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$1, x$7, x$8, x$9, 5, 60000, 30000, x$10, x$11, x$12, x$13, (Option<File>)x$14, (Option<Properties>)x$15, x$3, x$4, x$16));
        scala.collection.immutable.Map topicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.format.version"), (Object)MetadataVersion.IBP_0_11_0_IV2.version())}));
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, (scala.collection.immutable.Map<String, String>)topicConfig).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int n = tuple2._2$mcI$sp();
        String topic = var19_17.topic();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$26 -> x$26.swap())).asJava();
        IndexedSeq firstBatchFutures = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)i -> FetchRequestTest.$anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$2(this, topic, BoxesRunTime.unboxToInt((Object)i)));
        this.producer().flush();
        IndexedSeq secondBatchFutures = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(10), 25).map((Function1 & Serializable)i -> FetchRequestTest.$anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$3(this, topic, BoxesRunTime.unboxToInt((Object)i)));
        this.producer().flush();
        firstBatchFutures.foreach((Function1 & Serializable)x$27 -> (RecordMetadata)x$27.get());
        secondBatchFutures.foreach((Function1 & Serializable)x$28 -> (RecordMetadata)x$28.get());
        this.check$1(3L, (short)1, 3L, 22, (byte)0, (TopicPartition)var19_17, n, topicNames);
        this.check$1(15L, (short)1, 15L, 10, (byte)0, (TopicPartition)var19_17, n, topicNames);
        this.check$1(3L, (short)3, 3L, 22, (byte)1, (TopicPartition)var19_17, n, topicNames);
        this.check$1(15L, (short)3, 15L, 10, (byte)1, (TopicPartition)var19_17, n, topicNames);
        this.check$1(3L, (short)4, 0L, 2, (byte)2, (TopicPartition)var19_17, n, topicNames);
        this.check$1(15L, (short)4, 10L, 1, (byte)2, (TopicPartition)var19_17, n, topicNames);
        this.check$1(10L, (short)4, 10L, 1, (byte)2, (TopicPartition)var19_17, n, topicNames);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateIncrementalFetchWithPartitionsInErrorV12(String quorum) {
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        java.util.Map topicNames = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$)).asJava();
        this.createTopicWithAssignment("foo", (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2})))}))), this.createTopicWithAssignment$default$3());
        TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), foo0, 15000L);
        TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), foo1, 15000L);
        TopicPartition bar0 = new TopicPartition("bar", 0);
        FetchRequest req1 = this.createConsumerFetchRequest$2((Seq)new .colon.colon((Object)foo0, (List)new .colon.colon((Object)foo1, (List)new .colon.colon((Object)bar0, (List)Nil$.MODULE$))), FetchMetadata.INITIAL, (Seq)Nil$.MODULE$);
        FetchResponse resp1 = this.sendFetchRequest(0, req1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() > 0 ? 1 : 0) != 0, (String)"Expected the broker to create a new incremental fetch session");
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Test created an incremental fetch session ").append(resp1.sessionId()).toString());
        LinkedHashMap responseData1 = resp1.responseData(topicNames, (short)12);
        Assertions.assertTrue((boolean)responseData1.containsKey(foo0));
        Assertions.assertTrue((boolean)responseData1.containsKey(foo1));
        Assertions.assertTrue((boolean)responseData1.containsKey(bar0));
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((FetchResponseData.PartitionData)responseData1.get(foo0)).errorCode());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((FetchResponseData.PartitionData)responseData1.get(foo1)).errorCode());
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)((FetchResponseData.PartitionData)responseData1.get(bar0)).errorCode());
        FetchRequest req2 = this.createConsumerFetchRequest$2((Seq)Nil$.MODULE$, new FetchMetadata(resp1.sessionId(), 1), (Seq)Nil$.MODULE$);
        FetchResponse resp2 = this.sendFetchRequest(0, req2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp2.sessionId(), (String)"Expected the broker to continue the incremental fetch session");
        LinkedHashMap responseData2 = resp2.responseData(topicNames, (short)12);
        Assertions.assertFalse((boolean)responseData2.containsKey(foo0));
        Assertions.assertFalse((boolean)responseData2.containsKey(foo1));
        Assertions.assertTrue((boolean)responseData2.containsKey(bar0));
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)((FetchResponseData.PartitionData)responseData2.get(bar0)).errorCode());
        this.createTopicWithAssignment("bar", (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.createTopicWithAssignment$default$3());
        TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), bar0, 15000L);
        FetchRequest req3 = this.createConsumerFetchRequest$2((Seq)Nil$.MODULE$, new FetchMetadata(resp1.sessionId(), 2), (Seq)Nil$.MODULE$);
        FetchResponse resp3 = this.sendFetchRequest(0, req3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp3.error());
        LinkedHashMap responseData3 = resp3.responseData(topicNames, (short)12);
        Assertions.assertFalse((boolean)responseData3.containsKey(foo0));
        Assertions.assertFalse((boolean)responseData3.containsKey(foo1));
        Assertions.assertTrue((boolean)responseData3.containsKey(bar0));
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((FetchResponseData.PartitionData)responseData3.get(bar0)).errorCode());
        FetchRequest req4 = this.createConsumerFetchRequest$2((Seq)Nil$.MODULE$, new FetchMetadata(resp1.sessionId(), 3), (Seq)Nil$.MODULE$);
        FetchResponse resp4 = this.sendFetchRequest(0, req4);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp4.error());
        LinkedHashMap responseData4 = resp4.responseData(topicNames, (short)12);
        Assertions.assertFalse((boolean)responseData4.containsKey(foo0));
        Assertions.assertFalse((boolean)responseData4.containsKey(foo1));
        Assertions.assertFalse((boolean)responseData4.containsKey(bar0));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchWithPartitionsWithIdError(String quorum) {
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        this.createTopicWithAssignment("foo", (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2})))}))), this.createTopicWithAssignment$default$3());
        TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), foo0, 15000L);
        TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), foo1, 15000L);
        scala.collection.immutable.Map topicIdsWithUnknown = (scala.collection.immutable.Map)this.getTopicIds().$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)Uuid.randomUuid())})));
        TopicPartition bar0 = new TopicPartition("bar", 0);
        FetchRequest req1 = FetchRequestTest.createConsumerFetchRequest$3(FetchRequestTest.createPartitionMap$1(Integer.MAX_VALUE, (Seq)new .colon.colon((Object)foo0, (List)new .colon.colon((Object)foo1, (List)new .colon.colon((Object)bar0, (List)Nil$.MODULE$))), Predef$.MODULE$.Map().empty(), topicIdsWithUnknown), FetchMetadata.INITIAL, (Seq)Nil$.MODULE$);
        FetchResponse resp1 = this.sendFetchRequest(0, req1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        java.util.Map topicNames1 = CollectionConverters$.MODULE$.MapHasAsJava((Map)topicIdsWithUnknown.map((Function1 & Serializable)x$29 -> x$29.swap())).asJava();
        LinkedHashMap responseData1 = resp1.responseData(topicNames1, ApiKeys.FETCH.latestVersion());
        Assertions.assertTrue((boolean)responseData1.containsKey(foo0));
        Assertions.assertTrue((boolean)responseData1.containsKey(foo1));
        Assertions.assertTrue((boolean)responseData1.containsKey(bar0));
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((FetchResponseData.PartitionData)responseData1.get(foo0)).errorCode());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((FetchResponseData.PartitionData)responseData1.get(foo1)).errorCode());
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_ID.code(), (short)((FetchResponseData.PartitionData)responseData1.get(bar0)).errorCode());
    }

    @Test
    public void testPartitionDataEquals() {
        Uuid topicId = Uuid.randomUuid();
        Assertions.assertEquals((Object)new FetchRequest.PartitionData(topicId, 300L, 0L, 300, Optional.of(Predef$.MODULE$.long2Long(0L)), Optional.of(Predef$.MODULE$.int2Integer(300)), Optional.of(Predef$.MODULE$.int2Integer(1))), (Object)new FetchRequest.PartitionData(topicId, 300L, 0L, 300, Optional.of(Predef$.MODULE$.long2Long(0L)), Optional.of(Predef$.MODULE$.int2Integer(300)), Optional.of(Predef$.MODULE$.int2Integer(1))));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testZStdCompressedTopic(String quorum) {
        void var4_4;
        scala.collection.immutable.Map topicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compression.type"), (Object)BrokerCompressionType.ZSTD.name)}));
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, (scala.collection.immutable.Map<String, String>)topicConfig).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int n = tuple2._2$mcI$sp();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$31 -> x$31.swap())).asJava();
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        StringSerializer x$2 = new StringSerializer();
        StringSerializer x$3 = new StringSerializer();
        int x$4 = -1;
        long x$5 = 60000L;
        long x$6 = 0x100000L;
        int x$7 = Integer.MAX_VALUE;
        int x$8 = 30000;
        int x$9 = 0;
        int x$10 = 16384;
        String x$11 = "none";
        int x$12 = 20000;
        SecurityProtocol x$13 = SecurityProtocol.PLAINTEXT;
        None$ x$14 = None$.MODULE$;
        None$ x$15 = None$.MODULE$;
        boolean x$16 = false;
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, (Option<File>)x$14, (Option<Properties>)x$15, x$2, x$3, x$16));
        this.producer().send(new ProducerRecord(var4_4.topic(), Predef$.MODULE$.int2Integer(var4_4.partition()), (Object)"key1", (Object)"value1")).get();
        this.producer().send(new ProducerRecord(var4_4.topic(), Predef$.MODULE$.int2Integer(var4_4.partition()), (Object)"key2", (Object)"value2")).get();
        this.producer().send(new ProducerRecord(var4_4.topic(), Predef$.MODULE$.int2Integer(var4_4.partition()), (Object)"key3", (Object)"value3")).get();
        this.producer().close();
        FetchRequest req0 = (FetchRequest)new FetchRequest.Builder(0, 9, -1, -1L, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var4_4, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty(), this.createPartitionMap$default$4())).setMaxBytes(800).build();
        FetchResponseData.PartitionData data0 = (FetchResponseData.PartitionData)this.sendFetchRequest(n, req0).responseData(topicNames, (short)9).get(var4_4);
        Assertions.assertEquals((short)Errors.UNSUPPORTED_COMPRESSION_TYPE.code(), (short)data0.errorCode());
        FetchRequest req1 = (FetchRequest)new FetchRequest.Builder(0, 10, -1, -1L, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var4_4, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty(), this.createPartitionMap$default$4())).setMaxBytes(800).build();
        FetchResponseData.PartitionData data1 = (FetchResponseData.PartitionData)this.sendFetchRequest(n, req1).responseData(topicNames, (short)10).get(var4_4);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)data1.errorCode());
        Assertions.assertEquals((int)3, (int)this.records(data1).size());
        FetchRequest req2 = (FetchRequest)new FetchRequest.Builder(ApiKeys.FETCH.latestVersion(), ApiKeys.FETCH.latestVersion(), -1, -1L, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var4_4, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty(), this.createPartitionMap$default$4())).setMaxBytes(800).build();
        FetchResponseData.PartitionData data2 = (FetchResponseData.PartitionData)this.sendFetchRequest(n, req2).responseData(topicNames, ApiKeys.FETCH.latestVersion()).get(var4_4);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)data2.errorCode());
        Assertions.assertEquals((int)3, (int)this.records(data2).size());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testZStdCompressedRecords(String quorum) {
        void var4_4;
        scala.collection.immutable.Map topicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compression.type"), (Object)BrokerCompressionType.PRODUCER.name)}));
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, (scala.collection.immutable.Map<String, String>)topicConfig).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int n = tuple2._2$mcI$sp();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$33 -> x$33.swap())).asJava();
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        String x$2 = CompressionType.GZIP.name;
        StringSerializer x$3 = new StringSerializer();
        StringSerializer x$4 = new StringSerializer();
        int x$5 = -1;
        long x$6 = 60000L;
        long x$7 = 0x100000L;
        int x$8 = Integer.MAX_VALUE;
        int x$9 = 30000;
        int x$10 = 0;
        int x$11 = 16384;
        int x$12 = 20000;
        SecurityProtocol x$13 = SecurityProtocol.PLAINTEXT;
        None$ x$14 = None$.MODULE$;
        None$ x$15 = None$.MODULE$;
        boolean x$16 = false;
        KafkaProducer producer1 = TestUtils$.MODULE$.createProducer(x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$2, x$12, x$13, (Option<File>)x$14, (Option<Properties>)x$15, x$3, x$4, x$16);
        producer1.send(new ProducerRecord(var4_4.topic(), Predef$.MODULE$.int2Integer(var4_4.partition()), (Object)"key1", (Object)"value1")).get();
        producer1.close();
        String x$17 = this.bootstrapServers(this.bootstrapServers$default$1());
        String x$18 = CompressionType.ZSTD.name;
        StringSerializer x$19 = new StringSerializer();
        StringSerializer x$20 = new StringSerializer();
        int x$21 = -1;
        long x$22 = 60000L;
        long x$23 = 0x100000L;
        int x$24 = Integer.MAX_VALUE;
        int x$25 = 30000;
        int x$26 = 0;
        int x$27 = 16384;
        int x$28 = 20000;
        SecurityProtocol x$29 = SecurityProtocol.PLAINTEXT;
        None$ x$30 = None$.MODULE$;
        None$ x$31 = None$.MODULE$;
        boolean x$32 = false;
        KafkaProducer producer2 = TestUtils$.MODULE$.createProducer(x$17, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$18, x$28, x$29, (Option<File>)x$30, (Option<Properties>)x$31, x$19, x$20, x$32);
        producer2.send(new ProducerRecord(var4_4.topic(), Predef$.MODULE$.int2Integer(var4_4.partition()), (Object)"key2", (Object)"value2")).get();
        producer2.send(new ProducerRecord(var4_4.topic(), Predef$.MODULE$.int2Integer(var4_4.partition()), (Object)"key3", (Object)"value3")).get();
        producer2.close();
        FetchRequest req0 = (FetchRequest)new FetchRequest.Builder(0, 1, -1, -1L, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var4_4, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty(), this.createPartitionMap$default$4())).setMaxBytes(800).build();
        FetchResponseData.PartitionData data0 = (FetchResponseData.PartitionData)this.sendFetchRequest(n, req0).responseData(topicNames, (short)1).get(var4_4);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)data0.errorCode());
        Assertions.assertEquals((int)1, (int)this.records(data0).size());
        FetchRequest req1 = (FetchRequest)new FetchRequest.Builder(0, 1, -1, -1L, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var4_4, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)var4_4), (Object)BoxesRunTime.boxToLong((long)1L))}))), this.createPartitionMap$default$4())).setMaxBytes(800).build();
        FetchResponseData.PartitionData data1 = (FetchResponseData.PartitionData)this.sendFetchRequest(n, req1).responseData(topicNames, (short)1).get(var4_4);
        Assertions.assertEquals((short)Errors.UNSUPPORTED_COMPRESSION_TYPE.code(), (short)data1.errorCode());
        FetchRequest req2 = (FetchRequest)new FetchRequest.Builder(2, 3, -1, -1L, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var4_4, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty(), this.createPartitionMap$default$4())).setMaxBytes(800).build();
        FetchResponseData.PartitionData data2 = (FetchResponseData.PartitionData)this.sendFetchRequest(n, req2).responseData(topicNames, (short)3).get(var4_4);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)data2.errorCode());
        Assertions.assertEquals((int)1, (int)this.records(data2).size());
        FetchRequest req3 = (FetchRequest)new FetchRequest.Builder(0, 1, -1, -1L, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var4_4, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)var4_4), (Object)BoxesRunTime.boxToLong((long)1L))}))), this.createPartitionMap$default$4())).setMaxBytes(800).build();
        FetchResponseData.PartitionData data3 = (FetchResponseData.PartitionData)this.sendFetchRequest(n, req3).responseData(topicNames, (short)1).get(var4_4);
        Assertions.assertEquals((short)Errors.UNSUPPORTED_COMPRESSION_TYPE.code(), (short)data3.errorCode());
        FetchRequest req4 = (FetchRequest)new FetchRequest.Builder(0, 10, -1, -1L, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var4_4, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty(), this.createPartitionMap$default$4())).setMaxBytes(800).build();
        FetchResponseData.PartitionData data4 = (FetchResponseData.PartitionData)this.sendFetchRequest(n, req4).responseData(topicNames, (short)10).get(var4_4);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)data4.errorCode());
        Assertions.assertEquals((int)3, (int)this.records(data4).size());
        FetchRequest req5 = (FetchRequest)new FetchRequest.Builder(0, ApiKeys.FETCH.latestVersion(), -1, -1L, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var4_4, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty(), this.createPartitionMap$default$4())).setMaxBytes(800).build();
        FetchResponseData.PartitionData data5 = (FetchResponseData.PartitionData)this.sendFetchRequest(n, req5).responseData(topicNames, ApiKeys.FETCH.latestVersion()).get(var4_4);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)data5.errorCode());
        Assertions.assertEquals((int)3, (int)this.records(data5).size());
    }

    private void checkFetchResponse(Seq<TopicPartition> expectedPartitions, FetchResponse fetchResponse, int maxPartitionBytes, int maxResponseBytes, int numMessagesPerPartition, short responseVersion) {
        java.util.Map topicNames = CollectionConverters$.MODULE$.MapHasAsJava((Map)this.getTopicIds().map((Function1 & Serializable)x$34 -> x$34.swap())).asJava();
        LinkedHashMap responseData = fetchResponse.responseData(topicNames, responseVersion);
        Assertions.assertEquals(expectedPartitions, (Object)CollectionConverters$.MODULE$.SetHasAsScala(responseData.keySet()).asScala().toSeq());
        BooleanRef emptyResponseSeen = BooleanRef.create((boolean)false);
        IntRef responseSize = IntRef.create((int)0);
        IntRef responseBufferSize = IntRef.create((int)0);
        expectedPartitions.foreach((Function1 & Serializable)tp -> {
            FetchRequestTest.$anonfun$checkFetchResponse$2(responseData, responseBufferSize, numMessagesPerPartition, responseSize, emptyResponseSeen, maxPartitionBytes, tp);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)(maxResponseBytes - maxResponseBytes % maxPartitionBytes), (int)responseBufferSize.elem);
        Assertions.assertTrue((responseSize.elem <= maxResponseBytes ? 1 : 0) != 0);
    }

    private short checkFetchResponse$default$6() {
        return ApiKeys.FETCH.latestVersion();
    }

    private final FetchRequest createConsumerFetchRequest$1(Seq topicPartitions, scala.collection.immutable.Map offsetMap, short version, int maxResponseBytes$1, int maxPartitionBytes$1) {
        return this.createConsumerFetchRequest(maxResponseBytes$1, maxPartitionBytes$1, (Seq<TopicPartition>)topicPartitions, (scala.collection.immutable.Map<TopicPartition, Object>)offsetMap, version, this.createConsumerFetchRequest$default$6(), this.createConsumerFetchRequest$default$7(), this.createConsumerFetchRequest$default$8());
    }

    private static final scala.collection.immutable.Map createConsumerFetchRequest$default$2$1() {
        return Predef$.MODULE$.Map().empty();
    }

    private static final short createConsumerFetchRequest$default$3$1() {
        return ApiKeys.FETCH.latestVersion();
    }

    public static final /* synthetic */ int $anonfun$testBrokerRespectsPartitionsOrderAndSizeLimits$3(FetchRequestTest $this, FetchResponseData.PartitionData partitionData) {
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)$this.records(partitionData).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.sizeInBytes()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    private final void evaluateResponse3$1(FetchResponse response, short version, java.util.Map topicNames$1, Seq shuffledTopicPartitions3$1, int maxResponseBytes$1, TopicPartition partitionWithLargeMessage1$1, int maxPartitionBytes$1) {
        LinkedHashMap responseData = response.responseData(topicNames$1, version);
        Assertions.assertEquals((Object)shuffledTopicPartitions3$1, (Object)CollectionConverters$.MODULE$.SetHasAsScala(responseData.keySet()).asScala().toSeq());
        Assertions.assertTrue((BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)responseData).asScala().values().map((Function1 & Serializable)partitionData -> BoxesRunTime.boxToInteger((int)FetchRequestTest.$anonfun$testBrokerRespectsPartitionsOrderAndSizeLimits$3(this, partitionData)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) <= maxResponseBytes$1 ? 1 : 0) != 0);
        FetchResponseData.PartitionData partitionData2 = (FetchResponseData.PartitionData)responseData.get(partitionWithLargeMessage1$1);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData2.errorCode());
        Assertions.assertTrue((partitionData2.highWatermark() > 0L ? 1 : 0) != 0);
        int size3 = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.records(partitionData2).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.sizeInBytes()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((size3 <= maxResponseBytes$1 ? 1 : 0) != 0, (String)new StringBuilder(29).append("Expected ").append(size3).append(" to be smaller than ").append(maxResponseBytes$1).toString());
        Assertions.assertTrue((size3 > maxPartitionBytes$1 ? 1 : 0) != 0, (String)new StringBuilder(28).append("Expected ").append(size3).append(" to be larger than ").append(maxPartitionBytes$1).toString());
        Assertions.assertTrue((maxPartitionBytes$1 < partitionData2.records().sizeInBytes() ? 1 : 0) != 0);
    }

    private static final short evaluateResponse3$default$2$1() {
        return ApiKeys.FETCH.latestVersion();
    }

    private final void evaluateResponse4$1(FetchResponse response, short version, java.util.Map topicNames$1, Seq shuffledTopicPartitions4$1, TopicPartition partitionWithLargeMessage2$1, int maxResponseBytes$1) {
        LinkedHashMap responseData = response.responseData(topicNames$1, version);
        Assertions.assertEquals((Object)shuffledTopicPartitions4$1, (Object)CollectionConverters$.MODULE$.SetHasAsScala(responseData.keySet()).asScala().toSeq());
        scala.collection.immutable.Seq nonEmptyPartitions = (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)responseData).asScala().toSeq().collect((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;

            public final <A1 extends Tuple2<TopicPartition, FetchResponseData.PartitionData>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 != null) {
                    TopicPartition tp = (TopicPartition)x1._1();
                    FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)x1._2();
                    if (BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.$outer.records(partitionData).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)$anonfun$2.$anonfun$applyOrElse$1(x$4)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0) {
                        return (B1)tp;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<TopicPartition, FetchResponseData.PartitionData> x1) {
                FetchResponseData.PartitionData partitionData;
                return x1 != null && BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.$outer.records(partitionData = (FetchResponseData.PartitionData)x1._2()).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)$anonfun$2.$anonfun$isDefinedAt$1(x$4)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0;
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$1(Record x$4) {
                return x$4.sizeInBytes();
            }

            public static final /* synthetic */ int $anonfun$isDefinedAt$1(Record x$4) {
                return x$4.sizeInBytes();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.kafka.common.record.Record ), $anonfun$isDefinedAt$1$adapted(org.apache.kafka.common.record.Record )}, serializedLambda);
            }
        });
        Assertions.assertEquals((Object)new .colon.colon((Object)partitionWithLargeMessage2$1, (List)Nil$.MODULE$), (Object)nonEmptyPartitions);
        FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)responseData.get(partitionWithLargeMessage2$1);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData.errorCode());
        Assertions.assertTrue((partitionData.highWatermark() > 0L ? 1 : 0) != 0);
        int size4 = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.records(partitionData).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.sizeInBytes()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((size4 > maxResponseBytes$1 ? 1 : 0) != 0, (String)new StringBuilder(28).append("Expected ").append(size4).append(" to be larger than ").append(maxResponseBytes$1).toString());
        Assertions.assertTrue((maxResponseBytes$1 < partitionData.records().sizeInBytes() ? 1 : 0) != 0);
    }

    private static final short evaluateResponse4$default$2$1() {
        return ApiKeys.FETCH.latestVersion();
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRequestToNonReplica$2(int leader$1, KafkaBroker x$10) {
        return x$10.config().brokerId() != leader$1;
    }

    private final void assertResponseErrorForEpoch$1(Errors error, int brokerId, Optional leaderEpoch, TopicPartition topicPartition$1, String topic$1, short version$1) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$12 -> x$12.swap())).asJava();
        partitionMap.put(topicPartition$1, new FetchRequest.PartitionData(topicIds.getOrDefault(topic$1, Uuid.ZERO_UUID), 0L, 0L, 1024, Optional.empty(), leaderEpoch, Optional.empty()));
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((short)version$1, (int)0, (int)1, partitionMap).build();
        FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)this.sendFetchRequest(brokerId, fetchRequest).responseData(topicNames, version$1).get(topicPartition$1);
        Assertions.assertEquals((short)error.code(), (short)partitionData.errorCode());
    }

    public static final /* synthetic */ int $anonfun$testFetchRequestDuringPartitionRecoveryAfterUncleanLeaderElection$2(KafkaServer x$14) {
        return x$14.config().brokerId();
    }

    /*
     * WARNING - void declaration
     */
    private final void createFetchRequestsAndValidateResponses$1(short ver, int brokerId, Errors consumerError, Errors replicaError, TopicPartition partition$1, java.util.Map topicIds$1, java.util.Map topicNames$2, int follower$1) {
        void forReplica_minBytes;
        void forReplica_maxWait;
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitionMap.put(partition$1, new FetchRequest.PartitionData((Uuid)topicIds$1.get(partition$1.topic()), 0L, 0L, 1024, Optional.empty(), Optional.of(Predef$.MODULE$.int2Integer(0)), Optional.empty()));
        FetchRequest consumerFetchRequest = FetchRequest.Builder.forConsumer((short)ver, (int)0, (int)0, partitionMap).build(ver);
        FetchResponseData.PartitionData consumerResponsePartitionData = (FetchResponseData.PartitionData)this.sendFetchRequest(brokerId, consumerFetchRequest).responseData(topicNames$2, ver).get(partition$1);
        Assertions.assertEquals((Object)consumerError, (Object)Errors.forCode((short)consumerResponsePartitionData.errorCode()), (String)new StringBuilder(68).append("Unexpected error in response to fetch request by consumer (version ").append(ver).append(")").toString());
        int n = 1024;
        boolean bl = false;
        long forReplica_replicaEpoch = 1L;
        FetchRequest replicaFetchRequest = new FetchRequest.Builder(ver, ver, follower$1, forReplica_replicaEpoch, (int)forReplica_maxWait, (int)forReplica_minBytes, partitionMap).build(ver);
        FetchResponseData.PartitionData replicaResponsePartitionData = (FetchResponseData.PartitionData)this.sendFetchRequest(brokerId, replicaFetchRequest).responseData(topicNames$2, ver).get(partition$1);
        Assertions.assertEquals((Object)replicaError, (Object)Errors.forCode((short)replicaResponsePartitionData.errorCode()), (String)new StringBuilder(67).append("Unexpected error in response to fetch request by replica (version ").append(ver).append(")").toString());
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRequestDuringPartitionRecoveryAfterUncleanLeaderElection$4(int leader$2, KafkaServer x$16) {
        return x$16.config().brokerId() == leader$2;
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRequestDuringPartitionRecoveryAfterUncleanLeaderElection$6(int leader$2, KafkaServer x$17) {
        return x$17.config().brokerId() == leader$2;
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRequestDuringPartitionRecoveryAfterUncleanLeaderElection$8(int leader$2, KafkaServer x$18) {
        return x$18.config().brokerId() == leader$2;
    }

    private final void assertResponseErrorForEpoch$2(Errors expectedError, int sessionFetchEpoch, Optional leaderEpoch, TopicPartition topicPartition$2, java.util.Map topicIds$2, short version$2, int sessionId$1, int destinationBrokerId$1, java.util.Map topicNames$3) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitionMap.put(topicPartition$2, new FetchRequest.PartitionData(topicIds$2.getOrDefault(topicPartition$2.topic(), Uuid.ZERO_UUID), 0L, 0L, 1024, Optional.empty(), leaderEpoch, Optional.empty()));
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((short)version$2, (int)0, (int)1, partitionMap).metadata(new FetchMetadata(sessionId$1, sessionFetchEpoch)).build();
        FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)this.sendFetchRequest(destinationBrokerId$1, fetchRequest).responseData(topicNames$3, version$2).get(topicPartition$2);
        Assertions.assertEquals((short)expectedError.code(), (short)partitionData.errorCode());
    }

    private final Option fetch$1(short version, int maxPartitionBytes, boolean closeAfterPartialResponse, TopicPartition topicPartition$3, int leaderId$2, int batchSize$1) {
        Some some;
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((short)version, (int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition$3, (List)Nil$.MODULE$), this.createPartitionMap$default$3(), this.createPartitionMap$default$4())).build(version);
        try (Socket socket = this.connect(this.brokerSocketServer(leaderId$2), this.connect$default$2());){
            this.send((AbstractRequest)fetchRequest, socket, this.send$default$3(), this.send$default$4());
            if (closeAfterPartialResponse) {
                int size = new DataInputStream(socket.getInputStream()).readInt();
                Assertions.assertTrue((size > maxPartitionBytes - batchSize$1 ? 1 : 0) != 0, (String)new StringBuilder(56).append("Fetch size too small ").append(size).append(", broker may have run out of memory").toString());
                some = None$.MODULE$;
            } else {
                some = new Some(this.receive(socket, ApiKeys.FETCH, version, ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl())));
            }
        }
        return some;
    }

    public static final /* synthetic */ Future $anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$2(FetchRequestTest $this, String topic$2, int i) {
        return $this.producer().send(new ProducerRecord(topic$2, (Object)new StringBuilder(4).append("key-").append(i).toString(), (Object)new StringBuilder(6).append("value-").append(i).toString()));
    }

    public static final /* synthetic */ Future $anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$3(FetchRequestTest $this, String topic$2, int i) {
        return $this.producer().send(new ProducerRecord(topic$2, (Object)new StringBuilder(4).append("key-").append(i).toString(), (Object)new StringBuilder(6).append("value-").append(i).toString()));
    }

    private final void check$1(long fetchOffset, short requestVersion, long expectedOffset, int expectedNumBatches, byte expectedMagic, TopicPartition topicPartition$4, int leaderId$3, java.util.Map topicNames$4) {
        int batchesReceived;
        Buffer batches;
        long currentFetchOffset = fetchOffset;
        long currentExpectedOffset = expectedOffset;
        for (batchesReceived = 0; batchesReceived < expectedNumBatches; batchesReceived += batches.size()) {
            FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((short)requestVersion, (int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(Integer.MAX_VALUE, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition$4, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition$4), (Object)BoxesRunTime.boxToLong((long)currentFetchOffset))}))), this.createPartitionMap$default$4())).build(requestVersion);
            FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)this.sendFetchRequest(leaderId$3, fetchRequest).responseData(topicNames$4, requestVersion).get(topicPartition$4);
            Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData.errorCode());
            Assertions.assertTrue((partitionData.highWatermark() > 0L ? 1 : 0) != 0);
            batches = CollectionConverters$.MODULE$.IterableHasAsScala(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData).batches()).asScala().toBuffer();
            RecordBatch batch = (RecordBatch)batches.head();
            Assertions.assertEquals((byte)expectedMagic, (byte)batch.magic());
            Assertions.assertEquals((long)currentExpectedOffset, (long)batch.baseOffset());
            currentFetchOffset = ((RecordBatch)batches.last()).lastOffset() + 1L;
            currentExpectedOffset += ((RecordBatch)batches.last()).lastOffset() - ((RecordBatch)batches.head()).baseOffset() + 1L;
        }
        Assertions.assertEquals((int)expectedNumBatches, (int)batchesReceived);
    }

    private final FetchRequest createConsumerFetchRequest$2(Seq topicPartitions, FetchMetadata metadata, Seq toForget) {
        return (FetchRequest)FetchRequest.Builder.forConsumer((short)12, (int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(Integer.MAX_VALUE, (Seq<TopicPartition>)topicPartitions, (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty(), this.createPartitionMap$default$4())).removed(CollectionConverters$.MODULE$.SeqHasAsJava(toForget).asJava()).metadata(metadata).build();
    }

    private static final FetchRequest createConsumerFetchRequest$3(LinkedHashMap fetchData, FetchMetadata metadata, Seq toForget) {
        return (FetchRequest)FetchRequest.Builder.forConsumer((short)ApiKeys.FETCH.latestVersion(), (int)Integer.MAX_VALUE, (int)0, (java.util.Map)fetchData).removed(CollectionConverters$.MODULE$.SeqHasAsJava(toForget).asJava()).metadata(metadata).build();
    }

    private static final LinkedHashMap createPartitionMap$1(int maxPartitionBytes, Seq topicPartitions, scala.collection.immutable.Map offsetMap, scala.collection.immutable.Map topicIdsWithUnknown$1) {
        LinkedHashMap partitionMap = new LinkedHashMap();
        topicPartitions.foreach((Function1 & Serializable)tp -> partitionMap.put(tp, new FetchRequest.PartitionData((Uuid)topicIdsWithUnknown$1.getOrElse((Object)tp.topic(), (Function0 & Serializable)() -> Uuid.ZERO_UUID), BoxesRunTime.unboxToLong((Object)offsetMap.getOrElse(tp, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)), 0L, maxPartitionBytes, Optional.empty(), Optional.empty(), Optional.empty())));
        return partitionMap;
    }

    public static final /* synthetic */ void $anonfun$checkFetchResponse$2(LinkedHashMap responseData$1, IntRef responseBufferSize$1, int numMessagesPerPartition$1, IntRef responseSize$1, BooleanRef emptyResponseSeen$1, int maxPartitionBytes$3, TopicPartition tp) {
        FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)responseData$1.get(tp);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData.errorCode());
        Assertions.assertTrue((partitionData.highWatermark() > 0L ? 1 : 0) != 0);
        Records records = FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData);
        responseBufferSize$1.elem += records.sizeInBytes();
        Buffer batches = CollectionConverters$.MODULE$.IterableHasAsScala(records.batches()).asScala().toBuffer();
        Assertions.assertTrue((batches.size() < numMessagesPerPartition$1 ? 1 : 0) != 0);
        int batchesSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)batches.map((Function1 & Serializable)x$35 -> BoxesRunTime.boxToInteger((int)x$35.sizeInBytes()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        responseSize$1.elem += batchesSize;
        if (batchesSize == 0 && !emptyResponseSeen$1.elem) {
            Assertions.assertEquals((int)0, (int)records.sizeInBytes());
            emptyResponseSeen$1.elem = true;
            return;
        }
        if (batchesSize != 0 && !emptyResponseSeen$1.elem) {
            Assertions.assertTrue((batchesSize <= maxPartitionBytes$3 ? 1 : 0) != 0);
            Assertions.assertEquals((int)maxPartitionBytes$3, (int)records.sizeInBytes());
            return;
        }
        if (batchesSize != 0 && emptyResponseSeen$1.elem) {
            Assertions.fail((String)new StringBuilder(53).append("Expected partition with size 0, but found ").append(tp).append(" with size ").append(batchesSize).toString());
            return;
        }
        if (records.sizeInBytes() != 0 && emptyResponseSeen$1.elem) {
            Assertions.fail((String)new StringBuilder(60).append("Expected partition buffer with size 0, but found ").append(tp).append(" with size ").append(records.sizeInBytes()).toString());
            return;
        }
    }

    public static final /* synthetic */ Future $anonfun$testDownConversionWithConnectionFailure$2$adapted(KafkaProducer producer$1, TopicPartition topicPartition$3, byte[] bytes$1, Object x$22) {
        return producer$1.send(new ProducerRecord(topicPartition$3.topic(), Predef$.MODULE$.int2Integer(topicPartition$3.partition()), (Object)"key", (Object)bytes$1));
    }

    public static final /* synthetic */ Option $anonfun$testDownConversionWithConnectionFailure$4$adapted(FetchRequestTest $this, short version$3, int msgValueLen$1, TopicPartition topicPartition$3, int leaderId$2, int batchSize$1, Object x$24) {
        return $this.fetch$1(version$3, msgValueLen$1 * 1000, true, topicPartition$3, leaderId$2, batchSize$1);
    }
}

