/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.stream.Stream;
import kafka.cluster.DefaultPartitionListener;
import kafka.server.FetchContext;
import kafka.server.FetchManager;
import kafka.server.FetchSession;
import kafka.server.FetchSessionCache;
import kafka.server.FetchSessionTest$;
import kafka.server.FullFetchContext;
import kafka.server.IncrementalFetchContext;
import kafka.server.IncrementalPartitionFetchMetadata;
import kafka.server.PartitionFetchMetadata;
import kafka.server.ReplicaManager;
import kafka.server.SessionErrorContext;
import kafka.server.SessionlessFetchContext;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Timeout(value=120L)
@ScalaSignature(bytes="\u0006\u0005\r=f\u0001B!C\u0001\u001dCQA\u0014\u0001\u0005\u0002=CQA\u0015\u0001\u0005\u0002MCQ\u0001\u001a\u0001\u0005\u0002\u0015DQa\u001d\u0001\u0005\nQDQA \u0001\u0005\u0002MCa!!\u0001\u0001\t\u0003\u0019\u0006BBA\u0003\u0001\u0011\u00051\u000b\u0003\u0004\u0002\n\u0001!\ta\u0015\u0005\u0007\u0003\u001b\u0001A\u0011A*\t\r\u0005E\u0001\u0001\"\u0001T\u0011%\t)\u0002\u0001b\u0001\n\u0013\t9\u0002\u0003\u0005\u0002<\u0001\u0001\u000b\u0011BA\r\u0011\u001d\ti\u0004\u0001C\u0001\u0003\u007fA\u0011\"!$\u0001#\u0003%\t!a$\t\u000f\u0005\u0015\u0006\u0001\"\u0001\u0002(\"1\u0011\u0011\u0017\u0001\u0005\u0002MCa!!.\u0001\t\u0003\u0019\u0006BBA]\u0001\u0011\u00051\u000bC\u0004\u0002>\u0002!I!a0\t\r\u0005u\b\u0001\"\u0001T\u0011\u001d\u0011\t\u0001\u0001C\u0001\u0005\u0007AaA!\f\u0001\t\u0003\u0019\u0006B\u0002B\u0019\u0001\u0011\u00051\u000b\u0003\u0004\u00036\u0001!\ta\u0015\u0005\u0007\u0005s\u0001A\u0011A*\t\r\tu\u0002\u0001\"\u0001T\u0011\u001d\u0011\t\u0005\u0001C\u0005\u0005\u0007BqA!\u0015\u0001\t\u0013\u0011\u0019\u0006\u0003\u0004\u0003Z\u0001!\ta\u0015\u0005\b\u0005;\u0002A\u0011\u0001B0\u0011\u0019\u0011Y\b\u0001C\u0001'\"1!q\u0010\u0001\u0005\u0002MCaAa!\u0001\t\u0003\u0019\u0006B\u0002BD\u0001\u0011\u00051\u000b\u0003\u0004\u0003\f\u0002!\ta\u0015\u0005\u0007\u0005\u001f\u0003A\u0011A*\t\u000f\tM\u0005\u0001\"\u0003\u0003\u0016\"1!q\u0016\u0001\u0005\u0002MCaAa-\u0001\t\u0003\u0019\u0006b\u0002B\\\u0001\u0011%!\u0011\u0018\u0005\n\u0005o\u0004\u0011\u0013!C\u0005\u0005sD\u0011B!@\u0001#\u0003%IA!?\t\u0013\t}\b!%A\u0005\n\r\u0005\u0001\"CB\u0003\u0001E\u0005I\u0011BB\u0004\u0011\u001d\u0019Y\u0001\u0001C\u0005\u0007\u001bA\u0011b!\f\u0001#\u0003%Iaa\f\t\u0013\rM\u0002!%A\u0005\n\te\b\"CB\u001b\u0001E\u0005I\u0011\u0002B}\u0011%\u00199\u0004AI\u0001\n\u0013\u0011I\u0010C\u0004\u0004:\u0001!Iaa\u000f\t\u0013\r=\u0003!%A\u0005\n\rE\u0003\"CB+\u0001E\u0005I\u0011BB,\u0011\u001d\u0019Y\u0006\u0001C\u0005\u0007;B\u0011b!\u001d\u0001#\u0003%Iaa\f\t\u0013\rM\u0004!%A\u0005\n\te\b\"CB;\u0001E\u0005I\u0011\u0002B}\u0011%\u00199\bAI\u0001\n\u0013\u0011I\u0010C\u0005\u0004z\u0001\t\n\u0011\"\u0003\u00040!911\u0010\u0001\u0005\n\ru\u0004\"CBD\u0001E\u0005I\u0011BB)\u000f\u001d\u0019\u0019J\u0011E\u0001\u0007+3a!\u0011\"\t\u0002\r]\u0005B\u0002(?\t\u0003\u0019I\nC\u0004\u0003zy\"\taa'\u0003!\u0019+Go\u00195TKN\u001c\u0018n\u001c8UKN$(BA\"E\u0003\u0019\u0019XM\u001d<fe*\tQ)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0005CA%M\u001b\u0005Q%\"A&\u0002\u000bM\u001c\u0017\r\\1\n\u00055S%AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002!B\u0011\u0011\u000bA\u0007\u0002\u0005\u0006\u0001B/Z:u\u001d\u0016<8+Z:tS>t\u0017\n\u001a\u000b\u0002)B\u0011\u0011*V\u0005\u0003-*\u0013A!\u00168ji\"\u0012!\u0001\u0017\t\u00033\nl\u0011A\u0017\u0006\u00037r\u000b1!\u00199j\u0015\tif,A\u0004kkBLG/\u001a:\u000b\u0005}\u0003\u0017!\u00026v]&$(\"A1\u0002\u0007=\u0014x-\u0003\u0002d5\n!A+Z:u\u0003M\t7o]3si\u000e\u000b7\r[3D_:$\u0018-\u001b8t)\r!fm\u001b\u0005\u0006O\u000e\u0001\r\u0001[\u0001\u0006G\u0006\u001c\u0007.\u001a\t\u0003#&L!A\u001b\"\u0003#\u0019+Go\u00195TKN\u001c\u0018n\u001c8DC\u000eDW\rC\u0003m\u0007\u0001\u0007Q.\u0001\u0006tKN\u001c\u0018n\u001c8JIN\u00042!\u00138q\u0013\ty'J\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002\"!S9\n\u0005IT%aA%oi\u0006YA-^7ns\u000e\u0013X-\u0019;f)\t)H\u0010\u0005\u0002ws:\u0011\u0011k^\u0005\u0003q\n\u000bABR3uG\"\u001cVm]:j_:L!A_>\u0003\u0013\r\u000b5\tS#`\u001b\u0006\u0003&B\u0001=C\u0011\u0015iH\u00011\u0001q\u0003\u0011\u0019\u0018N_3\u0002!Q,7\u000f^*fgNLwN\\\"bG\",\u0007FA\u0003Y\u0003\u001d\"Xm\u001d;TKN\u001c\u0018n\u001c8DC\u000eDWm\u00117pg\u0016\u001cVm]:j_:<\u0006.\u001a8SK6|g/\u001a3)\u0005\u0019A\u0016!\b;fgR\u001cVm]:j_:\u001c\u0015m\u00195f\u000bZL7\r^5p]J+H.Z:)\u0005\u001dA\u0016a\u0007;fgR\u001c\u0016-\\3TSj,7+Z:tS>tWI^5di&|g\u000e\u000b\u0002\t1\u0006yB/Z:u\u0003\u000e$\u0018N^3TKN\u001c\u0018n\u001c8Fm&\u001cG/[8og6+G/\u001a:)\u0005%A\u0016\u0001\u0007;fgR\u0014Vm]5{K\u000e\u000b7\r[3e'\u0016\u001c8/[8og\"\u0012!\u0002W\u0001\u0010\u000b6\u0003F+W0Q\u0003J#v\fT%T)V\u0011\u0011\u0011\u0004\t\u0007\u00037\t)#!\u000b\u000e\u0005\u0005u!\u0002BA\u0010\u0003C\tA!\u001e;jY*\u0011\u00111E\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002(\u0005u!\u0001\u0002'jgR\u0004B!a\u000b\u000285\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$\u0001\u0004d_6lwN\u001c\u0006\u0004\u000b\u0006M\"bAA\u001bA\u00061\u0011\r]1dQ\u0016LA!!\u000f\u0002.\t\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\\\u0001\u0011\u000b6\u0003F+W0Q\u0003J#v\fT%T)\u0002\nQb\u0019:fCR,'+Z9vKN$H\u0003DA!\u0003\u001b\n9&!\u001e\u0002z\u0005\r\u0005\u0003BA\"\u0003\u0013j!!!\u0012\u000b\t\u0005\u001d\u0013QF\u0001\te\u0016\fX/Z:ug&!\u00111JA#\u000511U\r^2i%\u0016\fX/Z:u\u0011\u001d\ty%\u0004a\u0001\u0003#\n\u0001\"\\3uC\u0012\fG/\u0019\t\u0005\u0003\u0007\n\u0019&\u0003\u0003\u0002V\u0005\u0015#!\u0004$fi\u000eDW*\u001a;bI\u0006$\u0018\rC\u0004\u0002Z5\u0001\r!a\u0017\u0002\u0013\u0019,Go\u00195ECR\f\u0007\u0003CA\u000e\u0003;\n\t'a\u001a\n\t\u0005}\u0013Q\u0004\u0002\u0004\u001b\u0006\u0004\b\u0003BA\u0016\u0003GJA!!\u001a\u0002.\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0003BA5\u0003_rA!a\u0011\u0002l%!\u0011QNA#\u000311U\r^2i%\u0016\fX/Z:u\u0013\u0011\t\t(a\u001d\u0003\u001bA\u000b'\u000f^5uS>tG)\u0019;b\u0015\u0011\ti'!\u0012\t\u000f\u0005]T\u00021\u0001\u0002\u001a\u0005AAo\u001c$pe\u001e,G\u000fC\u0004\u0002|5\u0001\r!! \u0002\u001d%\u001chI]8n\r>dGn\\<feB\u0019\u0011*a \n\u0007\u0005\u0005%JA\u0004C_>dW-\u00198\t\u0013\u0005\u0015U\u0002%AA\u0002\u0005\u001d\u0015a\u0002<feNLwN\u001c\t\u0004\u0013\u0006%\u0015bAAF\u0015\n)1\u000b[8si\u000692M]3bi\u0016\u0014V-];fgR$C-\u001a4bk2$H%N\u000b\u0003\u0003#SC!a\"\u0002\u0014.\u0012\u0011Q\u0013\t\u0005\u0003/\u000b\t+\u0004\u0002\u0002\u001a*!\u00111TAO\u0003%)hn\u00195fG.,GMC\u0002\u0002 *\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019+!'\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u000fde\u0016\fG/\u001a*fcV,7\u000f^,ji\"|W\u000f\u001e+pa&\u001c\u0017\nZ:\u0015\u0015\u0005\u0005\u0013\u0011VAV\u0003[\u000by\u000bC\u0004\u0002P=\u0001\r!!\u0015\t\u000f\u0005es\u00021\u0001\u0002\\!9\u0011qO\bA\u0002\u0005e\u0001bBA>\u001f\u0001\u0007\u0011QP\u0001\u0016i\u0016\u001cHoQ1dQ\u0016$G*Z1eKJ,\u0005o\\2iQ\t\u0001\u0002,\u0001\u0010uKN$8)Y2iK\u0012\u0014V\r\u001d7jG\u0006$\u0018n\u001c8TKN\u001c\u0018n\u001c8JI\"\u0012\u0011\u0003W\u0001\u0015i\u0016\u001cH\u000fT1ti\u001a+Go\u00195fI\u0016\u0003xn\u00195)\u0005IA\u0016!G1tg\u0016\u0014H\u000fU1si&$\u0018n\u001c8t\u0013:\u001cuN\u001c;fqR$r\u0001VAa\u0003#\f\u0019\u0010C\u0004\u0002DN\u0001\r!!2\u0002)\u0015D\b/Z2uK\u00124U\r^2i%\u0016\fX/Z:u!\u0011\t9-!4\u000e\u0005\u0005%'\u0002BAf\u0003[\tq!\\3tg\u0006<W-\u0003\u0003\u0002P\u0006%'\u0001\u0005$fi\u000eD'+Z9vKN$H)\u0019;b\u0011\u001d\t\u0019n\u0005a\u0001\u0003+\f!\u0002^8qS\u000et\u0015-\\3t!!\tY\"!\u0018\u0002X\u0006u\u0007\u0003BA\u0016\u00033LA!a7\u0002.\t!Q+^5e!\u0011\ty.!<\u000f\t\u0005\u0005\u0018\u0011\u001e\t\u0004\u0003GTUBAAs\u0015\r\t9OR\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005-(*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003_\f\tP\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003WT\u0005bBA{'\u0001\u0007\u0011q_\u0001\bG>tG/\u001a=u!\r\t\u0016\u0011`\u0005\u0004\u0003w\u0014%\u0001\u0004$fi\u000eD7i\u001c8uKb$\u0018!\u0005;fgR4U\r^2i%\u0016\fX/Z:ug\"\u0012A\u0003W\u0001\u001ci\u0016\u001cH/\u00138de\u0016lWM\u001c;bY\u001a+Go\u00195TKN\u001c\u0018n\u001c8\u0015\u0007Q\u0013)\u0001C\u0004\u0003\bU\u0001\r!! \u0002\u0019U\u001cXm\u001d+pa&\u001c\u0017\nZ:)\u0007U\u0011Y\u0001\u0005\u0003\u0003\u000e\tMQB\u0001B\b\u0015\r\u0011\t\u0002X\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\tU!q\u0002\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\bfB\u000b\u0003\u001a\t\u0015\"q\u0005\t\u0005\u00057\u0011\t#\u0004\u0002\u0003\u001e)!!q\u0004B\b\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018\u0002\u0002B\u0012\u0005;\u00111BV1mk\u0016\u001cv.\u001e:dK\u0006A!m\\8mK\u0006t7\u000f\f\u0003\u0003*\t-\u0012$A\u0001\u001a\u0003\u0001\ta\u0006^3ti\u001a+Go\u00195TKN\u001c\u0018n\u001c8XSRDWK\\6o_^t\u0017\nZ(mIJ+\u0017/^3tiZ+'o]5p]\"\u0012a\u0003W\u0001\u001ei\u0016\u001cHOR3uG\"\u001cVm]:j_:<\u0016\u000e\u001e5V].twn\u001e8JI\"\u0012q\u0003W\u0001;i\u0016\u001cH/\u00138de\u0016lWM\u001c;bY\u001a+Go\u00195TKN\u001c\u0018n\u001c8XSRD\u0017\nZ:XQ\u0016t7+Z:tS>tGi\\3t\u001d>$Xk]3JIND#\u0001\u0007-\u0002oQ,7\u000f^%oGJ,W.\u001a8uC24U\r^2i'\u0016\u001c8/[8o/&$\bn\\;u\u0013\u0012\u001cx\u000b[3o'\u0016\u001c8/[8o+N,7/\u00133tQ\tI\u0002,\u0001\u0015uKN$h)\u001a;dQN+7o]5p]V\u0003H-\u0019;f)>\u0004\u0018nY%eg\n\u0013xn[3s'&$W\r\u000b\u0002\u001b1\u0006yan\\#se>\u0014(+Z:q_:\u001cX-\u0006\u0002\u0003FA!!q\tB'\u001d\u0011\t9M!\u0013\n\t\t-\u0013\u0011Z\u0001\u0012\r\u0016$8\r\u001b*fgB|gn]3ECR\f\u0017\u0002BA9\u0005\u001fRAAa\u0013\u0002J\u0006iQM\u001d:peJ+7\u000f]8og\u0016$BA!\u0012\u0003V!9!q\u000b\u000fA\u0002\u0005\u001d\u0015!C3se>\u00148i\u001c3f\u0003q!Xm\u001d;SKN|GN^3V].twn\u001e8QCJ$\u0018\u000e^5p]ND#!\b-\u0002-Q,7\u000f\u001e+p\r>\u0014x-\u001a;QCJ$\u0018\u000e^5p]N$R\u0001\u0016B1\u0005KBqAa\u0019\u001f\u0001\u0004\ti(A\tg_>\u001cF/\u0019:ugJ+7o\u001c7wK\u0012DqAa\u001a\u001f\u0001\u0004\ti(A\bg_>,e\u000eZ:SKN|GN^3eQ\rq\"1\u0002\u0015\b=\t5$1\u000fB;!\u0011\u0011YBa\u001c\n\t\tE$Q\u0004\u0002\r\u001b\u0016$\bn\u001c3T_V\u00148-Z\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0005o\n#A!\u001f\u0002'%$Wk]1hK\u000e{WNY5oCRLwN\\:\u0002CQ,7\u000f^+qI\u0006$X-\u00118e\u000f\u0016tWM]1uKJ+7\u000f]8og\u0016$\u0015\r^1)\u0005}A\u0016A\u0007;fgR4U\r^2i'\u0016\u001c8/[8o\u000bb\u0004\u0018N]1uS>t\u0007F\u0001\u0011Y\u0003u!Xm\u001d;Qe&4\u0018\u000e\\3hK\u0012\u001cVm]:j_:D\u0015M\u001c3mS:<\u0007FA\u0011Y\u0003a!Xm\u001d;[KJ|7+\u001b>f\r\u0016$8\r[*fgNLwN\u001c\u0015\u0003Ea\u000b!\u0003^3ti\u0012Kg/\u001a:hS:<W\t]8dQ\"\u00121\u0005W\u0001+i\u0016\u001cH\u000fR3qe&|'/\u001b;ju\u0016\u001c\b+\u0019:uSRLwN\\:XSRD'+Z2pe\u0012\u001cxJ\u001c7zQ\t!\u0003,A\u000bbgN,'\u000f\u001e)beRLG/[8og>\u0013H-\u001a:\u0015\u000bQ\u00139J!'\t\u000f\u0005UX\u00051\u0001\u0002x\"9!1T\u0013A\u0002\tu\u0015A\u00039beRLG/[8ogB1!q\u0014BU\u0003SqAA!)\u0003&:!\u00111\u001dBR\u0013\u0005Y\u0015b\u0001BT\u0015\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002BV\u0005[\u00131aU3r\u0015\r\u00119KS\u0001\u0012i\u0016\u001cHoU3tg&|g.\u00169eCR,\u0007F\u0001\u0014Y\u0003A!Xm\u001d;TKN\u001c\u0018n\u001c8DY>\u001cX\r\u000b\u0002(1\u0006\u0001R.Y6f\r\u0016$8\r\u001b*fcV,7\u000f\u001e\u000b\u000b\u0003\u000b\u0014YLa0\u0003D\n-\b\u0002\u0003B_QA\u0005\t\u0019\u00019\u0002\u0013M,7o]5p]&#\u0007\u0002\u0003BaQA\u0005\t\u0019\u00019\u0002\u0019M,7o]5p]\u0016\u0003xn\u00195\t\u0013\t\u0015\u0007\u0006%AA\u0002\t\u001d\u0017A\u0002;pa&\u001c7\u000f\u0005\u0004\u0003 \n%&\u0011\u001a\t\u0005\u0005\u0017\u0014)O\u0004\u0003\u0003N\n\u0005h\u0002\u0002Bh\u0005?tAA!5\u0003^:!!1\u001bBn\u001d\u0011\u0011)N!7\u000f\t\u0005\r(q[\u0005\u0002C&\u0019\u0011Q\u00071\n\u0007\u0015\u000b\u0019$\u0003\u0003\u00020\u0005E\u0012\u0002BAf\u0003[IAAa9\u0002J\u0006\u0001b)\u001a;dQJ+\u0017/^3ti\u0012\u000bG/Y\u0005\u0005\u0005O\u0014IO\u0001\u0006GKR\u001c\u0007\u000eV8qS\u000eTAAa9\u0002J\"I!Q\u001e\u0015\u0011\u0002\u0003\u0007!q^\u0001\u0010M>\u0014xm\u001c;uK:$v\u000e]5dgB1!q\u0014BU\u0005c\u0004BAa3\u0003t&!!Q\u001fBu\u000591uN]4piR,g\u000eV8qS\u000e\f!$\\1lK\u001a+Go\u00195SKF,Xm\u001d;%I\u00164\u0017-\u001e7uIE*\"Aa?+\u0007A\f\u0019*\u0001\u000enC.,g)\u001a;dQJ+\u0017/^3ti\u0012\"WMZ1vYR$#'\u0001\u000enC.,g)\u001a;dQJ+\u0017/^3ti\u0012\"WMZ1vYR$3'\u0006\u0002\u0004\u0004)\"!qYAJ\u0003ii\u0017m[3GKR\u001c\u0007NU3rk\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019IA\u000b\u0003\u0003p\u0006M\u0015aF7bW\u00164U\r^2i)>\u0004\u0018n\u0019)beRLG/[8o)9\u0011Ima\u0004\u0004\u0014\ru1\u0011EB\u0013\u0007SAqa!\u0005.\u0001\u0004\tI#\u0001\tu_BL7-\u00133QCJ$\u0018\u000e^5p]\"91QC\u0017A\u0002\r]\u0011a\u00034fi\u000eDwJ\u001a4tKR\u00042!SB\r\u0013\r\u0019YB\u0013\u0002\u0005\u0019>tw\rC\u0005\u0004 5\u0002\n\u00111\u0001\u0004\u0018\u0005qAn\\4Ti\u0006\u0014Ho\u00144gg\u0016$\b\u0002CB\u0012[A\u0005\t\u0019\u00019\u0002\u00115\f\u0007PQ=uKND\u0001ba\n.!\u0003\u0005\r\u0001]\u0001\u0013GV\u0014(/\u001a8u\u0019\u0016\fG-\u001a:Fa>\u001c\u0007\u000e\u0003\u0005\u0004,5\u0002\n\u00111\u0001q\u0003Aa\u0017m\u001d;GKR\u001c\u0007.\u001a3Fa>\u001c\u0007.A\u0011nC.,g)\u001a;dQR{\u0007/[2QCJ$\u0018\u000e^5p]\u0012\"WMZ1vYR$3'\u0006\u0002\u00042)\"1qCAJ\u0003\u0005j\u0017m[3GKR\u001c\u0007\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\n3fM\u0006,H\u000e\u001e\u00135\u0003\u0005j\u0017m[3GKR\u001c\u0007\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\n3fM\u0006,H\u000e\u001e\u00136\u0003\u0005j\u0017m[3GKR\u001c\u0007\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\n3fM\u0006,H\u000e\u001e\u00137\u00039i\u0017m[3GKR\u001c\u0007\u000eV8qS\u000e$\u0002B!3\u0004>\r\u00053Q\t\u0005\n\u0007\u007f\u0011\u0004\u0013!a\u0001\u0003;\fQ\u0001^8qS\u000eD\u0011ba\u00113!\u0003\u0005\r!a6\u0002\u000fQ|\u0007/[2JI\"9!1\u0014\u001aA\u0002\r\u001d\u0003C\u0002BP\u0005S\u001bI\u0005\u0005\u0003\u0003L\u000e-\u0013\u0002BB'\u0005S\u0014aBR3uG\"\u0004\u0016M\u001d;ji&|g.\u0001\rnC.,g)\u001a;dQR{\u0007/[2%I\u00164\u0017-\u001e7uIE*\"aa\u0015+\t\u0005u\u00171S\u0001\u0019[\u0006\\WMR3uG\"$v\u000e]5dI\u0011,g-Y;mi\u0012\u0012TCAB-U\u0011\t9.a%\u0002%5\f7.\u001a$fi\u000eD\u0007+\u0019:uSRLwN\u001c\u000b\u0011\u0007\u0013\u001ayfa\u0019\u0004f\r\u001d4\u0011NB6\u0007[Baa!\u00196\u0001\u0004\u0001\u0018!\u00039beRLG/[8o\u0011\u001d\u0019)\"\u000ea\u0001\u0007/A\u0011ba\b6!\u0003\u0005\raa\u0006\t\u0011\r\rR\u0007%AA\u0002AD\u0001ba\n6!\u0003\u0005\r\u0001\u001d\u0005\t\u0007W)\u0004\u0013!a\u0001a\"I1qN\u001b\u0011\u0002\u0003\u00071qC\u0001\u0015e\u0016\u0004H.[2bi&|gnU3tg&|g.\u00133\u000295\f7.\u001a$fi\u000eD\u0007+\u0019:uSRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%g\u0005aR.Y6f\r\u0016$8\r\u001b)beRLG/[8oI\u0011,g-Y;mi\u0012\"\u0014\u0001H7bW\u00164U\r^2i!\u0006\u0014H/\u001b;j_:$C-\u001a4bk2$H%N\u0001\u001d[\u0006\\WMR3uG\"\u0004\u0016M\u001d;ji&|g\u000e\n3fM\u0006,H\u000e\u001e\u00137\u0003qi\u0017m[3GKR\u001c\u0007\u000eU1si&$\u0018n\u001c8%I\u00164\u0017-\u001e7uI]\n!#\\1lK\u001a{'oZ8ui\u0016tGk\u001c9jGRA!\u0011_B@\u0007\u0003\u001b\u0019\tC\u0005\u0004@m\u0002\n\u00111\u0001\u0002^\"911I\u001eA\u0002\u0005]\u0007b\u0002BNw\u0001\u00071Q\u0011\t\u0006\u0005?\u0013I\u000b]\u0001\u001d[\u0006\\WMR8sO>$H/\u001a8U_BL7\r\n3fM\u0006,H\u000e\u001e\u00132Q\u001d\u000111\u0012B:\u0007#\u00032!WBG\u0013\r\u0019yI\u0017\u0002\b)&lWm\\;u=\u0005A\u0018\u0001\u0005$fi\u000eD7+Z:tS>tG+Z:u!\t\tfh\u0005\u0002?\u0011R\u00111QS\u000b\u0003\u0007;\u0003baa(\u0004&\u000e%VBABQ\u0015\u0011\u0019\u0019+!\b\u0002\rM$(/Z1n\u0013\u0011\u00199k!)\u0003\rM#(/Z1n!\u0011\u0011Yba+\n\t\r5&Q\u0004\u0002\n\u0003J<W/\\3oiN\u0004")
public class FetchSessionTest {
    private final java.util.List<TopicIdPartition> EMPTY_PART_LIST = Collections.unmodifiableList(new ArrayList());

    public static Stream<Arguments> idUsageCombinations() {
        return FetchSessionTest$.MODULE$.idUsageCombinations();
    }

    @Test
    public void testNewSessionId() {
        FetchSessionCache cache = new FetchSessionCache(3, 100L);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 10000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> Assertions.assertTrue((cache.newSessionId() > 0 ? 1 : 0) != 0));
    }

    public void assertCacheContains(FetchSessionCache cache, scala.collection.immutable.Seq<Object> sessionIds) {
        IntRef i = IntRef.create((int)0);
        sessionIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable)sessionId -> {
            ++i$1.elem;
            Assertions.assertTrue((boolean)cache.get(sessionId).isDefined(), (String)new StringBuilder(26).append("Missing session ").append(i$1.elem).append(" out of ").append(sessionIds.size()).append("(").append(sessionId).append(")").toString());
        });
        Assertions.assertEquals((int)sessionIds.size(), (int)cache.size());
    }

    private ImplicitLinkedHashCollection<IncrementalPartitionFetchMetadata> dummyCreate(int size) {
        ImplicitLinkedHashCollection cacheMap = new ImplicitLinkedHashCollection(size);
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        topicIds.put("test", Uuid.randomUuid());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), size).foreach((Function1)(JFunction1.mcZI.sp & Serializable)i -> cacheMap.add((ImplicitLinkedHashCollection.Element)new IncrementalPartitionFetchMetadata("test", (Uuid)topicIds.get("test"), i)));
        return cacheMap;
    }

    @Test
    public void testSessionCache() {
        FetchSessionCache cache = new FetchSessionCache(3, 100L);
        Assertions.assertEquals((int)0, (int)cache.size());
        int id1 = cache.maybeCreateSession(0L, false, 10, true, (Function0 & Serializable)() -> this.dummyCreate(10));
        int id2 = cache.maybeCreateSession(10L, false, 20, true, (Function0 & Serializable)() -> this.dummyCreate(20));
        int id3 = cache.maybeCreateSession(20L, false, 30, true, (Function0 & Serializable)() -> this.dummyCreate(30));
        Assertions.assertEquals((int)0, (int)cache.maybeCreateSession(30L, false, 40, true, (Function0 & Serializable)() -> this.dummyCreate(40)));
        Assertions.assertEquals((int)0, (int)cache.maybeCreateSession(40L, false, 5, true, (Function0 & Serializable)() -> this.dummyCreate(5)));
        this.assertCacheContains(cache, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id1, id2, id3}));
        cache.touch((FetchSession)cache.get(id1).get(), 200L);
        int id4 = cache.maybeCreateSession(210L, false, 11, true, (Function0 & Serializable)() -> this.dummyCreate(11));
        this.assertCacheContains(cache, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id1, id3, id4}));
        cache.touch((FetchSession)cache.get(id1).get(), 400L);
        cache.touch((FetchSession)cache.get(id3).get(), 390L);
        cache.touch((FetchSession)cache.get(id4).get(), 400L);
        int id5 = cache.maybeCreateSession(410L, false, 50, true, (Function0 & Serializable)() -> this.dummyCreate(50));
        this.assertCacheContains(cache, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id3, id4, id5}));
        Assertions.assertEquals((int)0, (int)cache.maybeCreateSession(410L, false, 5, true, (Function0 & Serializable)() -> this.dummyCreate(5)));
        int id6 = cache.maybeCreateSession(410L, true, 5, true, (Function0 & Serializable)() -> this.dummyCreate(5));
        this.assertCacheContains(cache, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id3, id5, id6}));
    }

    @Test
    public void testSessionCacheCloseSessionWhenRemoved() {
        FetchSessionCache cache = new FetchSessionCache(3, 100L);
        ImplicitLinkedHashCollection cacheMap = new ImplicitLinkedHashCollection();
        IncrementalPartitionFetchMetadata partition1 = (IncrementalPartitionFetchMetadata)Mockito.spy((Object)new IncrementalPartitionFetchMetadata("foo", Uuid.randomUuid(), 0));
        cacheMap.add((ImplicitLinkedHashCollection.Element)partition1);
        IncrementalPartitionFetchMetadata partition2 = (IncrementalPartitionFetchMetadata)Mockito.spy((Object)new IncrementalPartitionFetchMetadata("bar", Uuid.randomUuid(), 0));
        cacheMap.add((ImplicitLinkedHashCollection.Element)partition2);
        int sessionId = cache.maybeCreateSession(0L, false, 10, true, (Function0 & Serializable)() -> cacheMap);
        Assertions.assertTrue((boolean)cache.get(sessionId).isDefined());
        Assertions.assertTrue((boolean)cache.remove(sessionId).isDefined());
        ((IncrementalPartitionFetchMetadata)Mockito.verify((Object)partition1)).close();
        ((IncrementalPartitionFetchMetadata)Mockito.verify((Object)partition2)).close();
    }

    @Test
    public void testSessionCacheEvictionRules() {
        FetchSessionCache cache = new FetchSessionCache(3, 100L);
        int id1 = cache.maybeCreateSession(0L, false, 20, true, (Function0 & Serializable)() -> this.dummyCreate(20));
        int id2 = cache.maybeCreateSession(0L, false, 10, true, (Function0 & Serializable)() -> this.dummyCreate(10));
        int id3 = cache.maybeCreateSession(0L, false, 30, true, (Function0 & Serializable)() -> this.dummyCreate(30));
        cache.touch((FetchSession)cache.get(id1).get(), 101L);
        cache.touch((FetchSession)cache.get(id2).get(), 101L);
        cache.touch((FetchSession)cache.get(id3).get(), 101L);
        int id4 = cache.maybeCreateSession(102L, false, 31, true, (Function0 & Serializable)() -> this.dummyCreate(31));
        this.assertCacheContains(cache, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id1, id3, id4}));
        cache.touch((FetchSession)cache.get(id1).get(), 102L);
        cache.touch((FetchSession)cache.get(id3).get(), 102L);
        int id5 = cache.maybeCreateSession(203L, false, 9, true, (Function0 & Serializable)() -> this.dummyCreate(9));
        this.assertCacheContains(cache, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id1, id3, id5}));
        int id6 = cache.maybeCreateSession(204L, true, 10, true, (Function0 & Serializable)() -> this.dummyCreate(10));
        this.assertCacheContains(cache, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id3, id5, id6}));
        int id7 = cache.maybeCreateSession(204L, true, 20, true, (Function0 & Serializable)() -> this.dummyCreate(20));
        this.assertCacheContains(cache, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id5, id6, id7}));
        int id8 = cache.maybeCreateSession(204L, true, 30, true, (Function0 & Serializable)() -> this.dummyCreate(30));
        this.assertCacheContains(cache, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id6, id7, id8}));
        Assertions.assertEquals((int)0, (int)cache.maybeCreateSession(40L, false, 40, true, (Function0 & Serializable)() -> this.dummyCreate(40)));
        cache.touch((FetchSession)cache.get(id6).get(), 205L);
        cache.touch((FetchSession)cache.get(id8).get(), 305L);
        int id9 = cache.maybeCreateSession(305L, false, 5, true, (Function0 & Serializable)() -> this.dummyCreate(5));
        this.assertCacheContains(cache, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id6, id8, id9}));
        cache.touch((FetchSession)cache.get(id6).get(), 305L);
        int id10 = cache.maybeCreateSession(305L, true, 5, true, (Function0 & Serializable)() -> this.dummyCreate(5));
        this.assertCacheContains(cache, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id6, id8, id10}));
        Assertions.assertEquals((int)0, (int)cache.maybeCreateSession(306L, true, 6, true, (Function0 & Serializable)() -> this.dummyCreate(6)));
        cache.touch((FetchSession)cache.get(id6).get(), 406L);
        cache.touch((FetchSession)cache.get(id8).get(), 406L);
        cache.touch((FetchSession)cache.get(id10).get(), 406L);
        int id11 = cache.maybeCreateSession(407L, true, 40, true, (Function0 & Serializable)() -> this.dummyCreate(40));
        this.assertCacheContains(cache, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id6, id8, id11}));
        cache.touch((FetchSession)cache.get(id6).get(), 407L);
        int id12 = cache.maybeCreateSession(508L, true, 50, true, (Function0 & Serializable)() -> this.dummyCreate(50));
        this.assertCacheContains(cache, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id6, id11, id12}));
    }

    @Test
    public void testSameSizeSessionEviction() {
        FetchSessionCache privilegedCache = new FetchSessionCache(2, 100L);
        int id1 = privilegedCache.maybeCreateSession(0L, true, 10, true, (Function0 & Serializable)() -> this.dummyCreate(10));
        int id2 = privilegedCache.maybeCreateSession(0L, true, 20, true, (Function0 & Serializable)() -> this.dummyCreate(20));
        FetchSessionCache unprivilegedCache = new FetchSessionCache(2, 100L);
        int id3 = unprivilegedCache.maybeCreateSession(0L, false, 10, true, (Function0 & Serializable)() -> this.dummyCreate(10));
        int id4 = unprivilegedCache.maybeCreateSession(0L, false, 20, true, (Function0 & Serializable)() -> this.dummyCreate(20));
        Assertions.assertEquals((int)0, (int)privilegedCache.maybeCreateSession(99L, true, 10, true, (Function0 & Serializable)() -> this.dummyCreate(10)));
        Assertions.assertEquals((int)0, (int)unprivilegedCache.maybeCreateSession(99L, false, 10, true, (Function0 & Serializable)() -> this.dummyCreate(10)));
        privilegedCache.touch((FetchSession)privilegedCache.get(id1).get(), 101L);
        privilegedCache.touch((FetchSession)privilegedCache.get(id2).get(), 101L);
        Assertions.assertEquals((int)0, (int)privilegedCache.maybeCreateSession(102L, true, 10, true, (Function0 & Serializable)() -> this.dummyCreate(10)));
        unprivilegedCache.touch((FetchSession)unprivilegedCache.get(id3).get(), 101L);
        unprivilegedCache.touch((FetchSession)unprivilegedCache.get(id4).get(), 101L);
        Assertions.assertEquals((int)0, (int)unprivilegedCache.maybeCreateSession(102L, false, 10, true, (Function0 & Serializable)() -> this.dummyCreate(10)));
        FetchSessionCache privilegedCache2 = new FetchSessionCache(2, 100L);
        int id5 = privilegedCache2.maybeCreateSession(0L, true, 10, true, (Function0 & Serializable)() -> this.dummyCreate(10));
        int id6 = privilegedCache2.maybeCreateSession(0L, true, 20, true, (Function0 & Serializable)() -> this.dummyCreate(20));
        FetchSessionCache unprivilegedCache2 = new FetchSessionCache(2, 100L);
        int id7 = unprivilegedCache2.maybeCreateSession(0L, false, 10, true, (Function0 & Serializable)() -> this.dummyCreate(10));
        int id8 = unprivilegedCache2.maybeCreateSession(0L, false, 20, true, (Function0 & Serializable)() -> this.dummyCreate(20));
        privilegedCache2.touch((FetchSession)privilegedCache2.get(id5).get(), 98L);
        privilegedCache2.touch((FetchSession)privilegedCache2.get(id6).get(), 98L);
        Assertions.assertEquals((int)0, (int)privilegedCache2.maybeCreateSession(99L, true, 10, true, (Function0 & Serializable)() -> this.dummyCreate(10)));
        Assertions.assertEquals((int)0, (int)privilegedCache2.maybeCreateSession(101L, true, 10, true, (Function0 & Serializable)() -> this.dummyCreate(10)));
        unprivilegedCache2.touch((FetchSession)unprivilegedCache2.get(id7).get(), 98L);
        unprivilegedCache2.touch((FetchSession)unprivilegedCache2.get(id8).get(), 98L);
        Assertions.assertEquals((int)0, (int)unprivilegedCache2.maybeCreateSession(99L, false, 10, true, (Function0 & Serializable)() -> this.dummyCreate(10)));
        Assertions.assertEquals((int)0, (int)unprivilegedCache2.maybeCreateSession(101L, false, 10, true, (Function0 & Serializable)() -> this.dummyCreate(10)));
    }

    @Test
    public void testActiveSessionEvictionsMeter() {
        FetchSessionCache cache = new FetchSessionCache(2, 100L);
        Assertions.assertEquals((long)0L, (long)cache.activeSessionEvictionsMeter().count());
        int id1 = cache.maybeCreateSession(0L, false, 2, true, (Function0 & Serializable)() -> this.dummyCreate(2));
        this.assertCacheContains(cache, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id1}));
        FetchSession session1 = (FetchSession)cache.get(id1).get();
        Assertions.assertEquals((long)0L, (long)cache.activeSessionEvictionsMeter().count());
        int id2 = cache.maybeCreateSession(0L, false, 4, true, (Function0 & Serializable)() -> this.dummyCreate(4));
        FetchSession session2 = (FetchSession)cache.get(id2).get();
        this.assertCacheContains(cache, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id1, id2}));
        Assertions.assertEquals((long)0L, (long)cache.activeSessionEvictionsMeter().count());
        cache.touch(session1, 200L);
        cache.touch(session2, 200L);
        int id3 = cache.maybeCreateSession(301L, false, 2, true, (Function0 & Serializable)() -> this.dummyCreate(2));
        FetchSession session3 = (FetchSession)cache.get(id3).get();
        this.assertCacheContains(cache, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id2, id3}));
        Assertions.assertEquals((long)1L, (long)cache.evictionsMeter().count());
        Assertions.assertEquals((long)0L, (long)cache.activeSessionEvictionsMeter().count());
        cache.touch(session2, 402L);
        cache.touch(session3, 402L);
        int id4 = cache.maybeCreateSession(402L, false, 5, true, (Function0 & Serializable)() -> this.dummyCreate(5));
        this.assertCacheContains(cache, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id2, id4}));
        Assertions.assertEquals((long)2L, (long)cache.evictionsMeter().count());
        Assertions.assertEquals((long)1L, (long)cache.activeSessionEvictionsMeter().count());
    }

    @Test
    public void testResizeCachedSessions() {
        FetchSessionCache cache = new FetchSessionCache(2, 100L);
        Assertions.assertEquals((long)0L, (long)cache.totalPartitions());
        Assertions.assertEquals((int)0, (int)cache.size());
        Assertions.assertEquals((long)0L, (long)cache.evictionsMeter().count());
        int id1 = cache.maybeCreateSession(0L, false, 2, true, (Function0 & Serializable)() -> this.dummyCreate(2));
        Assertions.assertTrue((id1 > 0 ? 1 : 0) != 0);
        this.assertCacheContains(cache, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id1}));
        FetchSession session1 = (FetchSession)cache.get(id1).get();
        Assertions.assertEquals((int)2, (int)session1.size());
        Assertions.assertEquals((long)2L, (long)cache.totalPartitions());
        Assertions.assertEquals((int)1, (int)cache.size());
        Assertions.assertEquals((long)0L, (long)cache.evictionsMeter().count());
        int id2 = cache.maybeCreateSession(0L, false, 4, true, (Function0 & Serializable)() -> this.dummyCreate(4));
        FetchSession session2 = (FetchSession)cache.get(id2).get();
        Assertions.assertTrue((id2 > 0 ? 1 : 0) != 0);
        this.assertCacheContains(cache, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id1, id2}));
        Assertions.assertEquals((long)6L, (long)cache.totalPartitions());
        Assertions.assertEquals((int)2, (int)cache.size());
        Assertions.assertEquals((long)0L, (long)cache.evictionsMeter().count());
        cache.touch(session1, 200L);
        cache.touch(session2, 200L);
        int id3 = cache.maybeCreateSession(200L, false, 5, true, (Function0 & Serializable)() -> this.dummyCreate(5));
        Assertions.assertTrue((id3 > 0 ? 1 : 0) != 0);
        this.assertCacheContains(cache, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id2, id3}));
        Assertions.assertEquals((long)9L, (long)cache.totalPartitions());
        Assertions.assertEquals((int)2, (int)cache.size());
        Assertions.assertEquals((long)1L, (long)cache.evictionsMeter().count());
        cache.remove(id3);
        this.assertCacheContains(cache, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id2}));
        Assertions.assertEquals((int)1, (int)cache.size());
        Assertions.assertEquals((long)1L, (long)cache.evictionsMeter().count());
        Assertions.assertEquals((long)4L, (long)cache.totalPartitions());
        java.util.Iterator iter = session2.partitionMap().iterator();
        iter.next();
        iter.remove();
        Assertions.assertEquals((int)3, (int)session2.size());
        Assertions.assertEquals((int)4, (int)session2.cachedSize());
        cache.touch(session2, session2.lastUsedMs());
        Assertions.assertEquals((long)3L, (long)cache.totalPartitions());
    }

    private java.util.List<TopicIdPartition> EMPTY_PART_LIST() {
        return this.EMPTY_PART_LIST;
    }

    public FetchRequest createRequest(FetchMetadata metadata, java.util.Map<TopicPartition, FetchRequest.PartitionData> fetchData, java.util.List<TopicIdPartition> toForget, boolean isFromFollower, short version) {
        return (FetchRequest)new FetchRequest.Builder(version, version, isFromFollower ? 1 : -1, isFromFollower ? 1L : -1L, 0, 0, fetchData).metadata(metadata).removed(toForget).build();
    }

    public short createRequest$default$5() {
        return ApiKeys.FETCH.latestVersion();
    }

    public FetchRequest createRequestWithoutTopicIds(FetchMetadata metadata, java.util.Map<TopicPartition, FetchRequest.PartitionData> fetchData, java.util.List<TopicIdPartition> toForget, boolean isFromFollower) {
        return (FetchRequest)new FetchRequest.Builder(12, 12, isFromFollower ? 1 : -1, isFromFollower ? 1L : -1L, 0, 0, fetchData).metadata(metadata).removed(toForget).build();
    }

    @Test
    public void testCachedLeaderEpoch() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)Uuid.randomUuid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)Uuid.randomUuid())}))).asJava();
        TopicIdPartition foo0 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 0));
        TopicIdPartition foo1 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 1));
        TopicIdPartition bar1 = new TopicIdPartition((Uuid)topicIds.get("bar"), new TopicPartition("bar", 1));
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$2 -> x$2.swap())).asJava();
        short version = ApiKeys.FETCH.latestVersion();
        Uuid x$8 = foo0.topicId();
        int x$1 = foo1.partition();
        long x$4 = 0L;
        int x$5 = 100;
        int x$6 = -1;
        long x$7 = -1L;
        .colon.colon x$9 = new .colon.colon((Object)this.makeFetchPartition(foo0.partition(), 0L, 0L, 100, -1, -1, -1L), (List)new .colon.colon((Object)this.makeFetchPartition(x$1, 10L, x$4, x$5, 1, x$6, x$7), (List)Nil$.MODULE$));
        String x$10 = "";
        Uuid x$18 = bar1.topicId();
        int x$11 = bar1.partition();
        long x$14 = 0L;
        int x$15 = 100;
        int x$16 = -1;
        long x$17 = -1L;
        .colon.colon x$19 = new .colon.colon((Object)this.makeFetchPartition(x$11, 10L, x$14, x$15, 2, x$16, x$17), (List)Nil$.MODULE$);
        String x$20 = "";
        .colon.colon x$21 = new .colon.colon((Object)this.makeFetchTopic(x$10, x$8, (scala.collection.immutable.Seq<FetchRequestData.FetchPartition>)x$9), (List)new .colon.colon((Object)this.makeFetchTopic(x$20, x$18, (scala.collection.immutable.Seq<FetchRequestData.FetchPartition>)x$19), (List)Nil$.MODULE$));
        int x$22 = 0;
        int x$23 = 0;
        scala.collection.immutable.Seq<FetchRequestData.ForgottenTopic> x$24 = this.makeFetchRequest$default$4();
        FetchRequestData fetchRequest1 = this.makeFetchRequest(x$22, x$23, (scala.collection.immutable.Seq<FetchRequestData.FetchTopic>)x$21, x$24);
        FetchContext context1 = fetchManager.newContext(version, fetchRequest1, false, topicNames);
        scala.collection.immutable.Map epochs1 = FetchSessionTest.cachedLeaderEpochs$1(context1);
        Assertions.assertEquals(Optional.empty(), (Object)epochs1.apply((Object)foo0));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)1)), (Object)epochs1.apply((Object)foo1));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)2)), (Object)epochs1.apply((Object)bar1));
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> response = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        response.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(foo0.partition()).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        response.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(foo1.partition()).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        response.put(bar1, new FetchResponseData.PartitionData().setPartitionIndex(bar1.partition()).setHighWatermark(5L).setLastStableOffset(5L).setLogStartOffset(5L));
        int sessionId = context1.updateAndGenerateResponseData(response).sessionId();
        FetchRequestData fetchRequest2 = this.makeFetchRequest(sessionId, 1, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4());
        FetchContext context2 = fetchManager.newContext(version, fetchRequest2, false, topicNames);
        scala.collection.immutable.Map epochs2 = FetchSessionTest.cachedLeaderEpochs$1(context2);
        Assertions.assertEquals(Optional.empty(), (Object)epochs2.apply((Object)foo0));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)1)), (Object)epochs2.apply((Object)foo1));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)2)), (Object)epochs2.apply((Object)bar1));
        context2.updateAndGenerateResponseData(response).sessionId();
        Uuid x$32 = foo0.topicId();
        int x$25 = foo0.partition();
        long x$28 = 0L;
        int x$29 = 100;
        int x$30 = -1;
        long x$31 = -1L;
        .colon.colon x$33 = new .colon.colon((Object)this.makeFetchPartition(x$25, 0L, x$28, x$29, 6, x$30, x$31), (List)new .colon.colon((Object)this.makeFetchPartition(foo1.partition(), 10L, 0L, 100, -1, -1, -1L), (List)Nil$.MODULE$));
        String x$34 = "";
        Uuid x$42 = (Uuid)topicIds.get(bar1.topic());
        int x$35 = bar1.partition();
        long x$38 = 0L;
        int x$39 = 100;
        int x$40 = -1;
        long x$41 = -1L;
        .colon.colon x$43 = new .colon.colon((Object)this.makeFetchPartition(x$35, 10L, x$38, x$39, 3, x$40, x$41), (List)Nil$.MODULE$);
        String x$44 = "";
        FetchRequestData fetchRequest3 = this.makeFetchRequest(sessionId, 2, (scala.collection.immutable.Seq<FetchRequestData.FetchTopic>)new .colon.colon((Object)this.makeFetchTopic(x$34, x$32, (scala.collection.immutable.Seq<FetchRequestData.FetchPartition>)x$33), (List)new .colon.colon((Object)this.makeFetchTopic(x$44, x$42, (scala.collection.immutable.Seq<FetchRequestData.FetchPartition>)x$43), (List)Nil$.MODULE$)), this.makeFetchRequest$default$4());
        scala.collection.immutable.Map epochs3 = FetchSessionTest.cachedLeaderEpochs$1(fetchManager.newContext(version, fetchRequest3, false, topicNames));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)6)), (Object)epochs3.apply((Object)foo0));
        Assertions.assertEquals(Optional.empty(), (Object)epochs3.apply((Object)foo1));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)3)), (Object)epochs3.apply((Object)bar1));
    }

    @Test
    public void testCachedReplicationSessionId() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)Uuid.randomUuid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)Uuid.randomUuid())}))).asJava();
        TopicIdPartition foo0 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 0));
        TopicIdPartition foo1 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 1));
        TopicIdPartition bar1 = new TopicIdPartition((Uuid)topicIds.get("bar"), new TopicPartition("bar", 1));
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$3 -> x$3.swap())).asJava();
        short version = ApiKeys.FETCH.latestVersion();
        Uuid x$8 = foo0.topicId();
        int x$1 = foo1.partition();
        long x$4 = 0L;
        int x$5 = 100;
        int x$6 = -1;
        int x$7 = -1;
        .colon.colon x$9 = new .colon.colon((Object)this.makeFetchPartition(foo0.partition(), 0L, 0L, 100, -1, -1, -1L), (List)new .colon.colon((Object)this.makeFetchPartition(x$1, 10L, x$4, x$5, x$6, x$7, 1L), (List)Nil$.MODULE$));
        String x$10 = "";
        Uuid x$18 = bar1.topicId();
        int x$11 = bar1.partition();
        long x$14 = 0L;
        int x$15 = 100;
        int x$16 = -1;
        int x$17 = -1;
        .colon.colon x$19 = new .colon.colon((Object)this.makeFetchPartition(x$11, 10L, x$14, x$15, x$16, x$17, 2L), (List)Nil$.MODULE$);
        String x$20 = "";
        .colon.colon x$21 = new .colon.colon((Object)this.makeFetchTopic(x$10, x$8, (scala.collection.immutable.Seq<FetchRequestData.FetchPartition>)x$9), (List)new .colon.colon((Object)this.makeFetchTopic(x$20, x$18, (scala.collection.immutable.Seq<FetchRequestData.FetchPartition>)x$19), (List)Nil$.MODULE$));
        int x$22 = 0;
        int x$23 = 0;
        scala.collection.immutable.Seq<FetchRequestData.ForgottenTopic> x$24 = this.makeFetchRequest$default$4();
        FetchRequestData fetchRequest1 = this.makeFetchRequest(x$22, x$23, (scala.collection.immutable.Seq<FetchRequestData.FetchTopic>)x$21, x$24);
        FetchContext context1 = fetchManager.newContext(version, fetchRequest1, true, topicNames);
        scala.collection.immutable.Map replicationSessions1 = FetchSessionTest.cachedReplicationSessionId$1(context1);
        Assertions.assertEquals((long)-1L, (long)BoxesRunTime.unboxToLong((Object)replicationSessions1.apply((Object)foo0)));
        Assertions.assertEquals((long)1L, (long)BoxesRunTime.unboxToLong((Object)replicationSessions1.apply((Object)foo1)));
        Assertions.assertEquals((long)2L, (long)BoxesRunTime.unboxToLong((Object)replicationSessions1.apply((Object)bar1)));
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> response = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        response.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(foo0.partition()).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        response.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(foo1.partition()).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        response.put(bar1, new FetchResponseData.PartitionData().setPartitionIndex(bar1.partition()).setHighWatermark(5L).setLastStableOffset(5L).setLogStartOffset(5L));
        int sessionId = context1.updateAndGenerateResponseData(response).sessionId();
        FetchRequestData fetchRequest2 = this.makeFetchRequest(sessionId, 1, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4());
        FetchContext context2 = fetchManager.newContext(version, fetchRequest2, true, topicNames);
        scala.collection.immutable.Map replicationSessions2 = FetchSessionTest.cachedReplicationSessionId$1(context2);
        Assertions.assertEquals((long)-1L, (long)BoxesRunTime.unboxToLong((Object)replicationSessions2.apply((Object)foo0)));
        Assertions.assertEquals((long)1L, (long)BoxesRunTime.unboxToLong((Object)replicationSessions2.apply((Object)foo1)));
        Assertions.assertEquals((long)2L, (long)BoxesRunTime.unboxToLong((Object)replicationSessions2.apply((Object)bar1)));
        context2.updateAndGenerateResponseData(response).sessionId();
        Uuid x$32 = foo0.topicId();
        int x$25 = foo0.partition();
        long x$28 = 0L;
        int x$29 = 100;
        int x$30 = -1;
        int x$31 = -1;
        .colon.colon x$33 = new .colon.colon((Object)this.makeFetchPartition(x$25, 0L, x$28, x$29, x$30, x$31, 6L), (List)new .colon.colon((Object)this.makeFetchPartition(foo1.partition(), 10L, 0L, 100, -1, -1, -1L), (List)Nil$.MODULE$));
        String x$34 = "";
        Uuid x$42 = (Uuid)topicIds.get(bar1.topic());
        int x$35 = bar1.partition();
        long x$38 = 0L;
        int x$39 = 100;
        int x$40 = -1;
        int x$41 = -1;
        .colon.colon x$43 = new .colon.colon((Object)this.makeFetchPartition(x$35, 10L, x$38, x$39, x$40, x$41, 3L), (List)Nil$.MODULE$);
        String x$44 = "";
        FetchRequestData fetchRequest3 = this.makeFetchRequest(sessionId, 2, (scala.collection.immutable.Seq<FetchRequestData.FetchTopic>)new .colon.colon((Object)this.makeFetchTopic(x$34, x$32, (scala.collection.immutable.Seq<FetchRequestData.FetchPartition>)x$33), (List)new .colon.colon((Object)this.makeFetchTopic(x$44, x$42, (scala.collection.immutable.Seq<FetchRequestData.FetchPartition>)x$43), (List)Nil$.MODULE$)), this.makeFetchRequest$default$4());
        scala.collection.immutable.Map replicationSessions3 = FetchSessionTest.cachedReplicationSessionId$1(fetchManager.newContext(version, fetchRequest3, true, topicNames));
        Assertions.assertEquals((long)6L, (long)BoxesRunTime.unboxToLong((Object)replicationSessions3.apply((Object)foo0)));
        Assertions.assertEquals((long)-1L, (long)BoxesRunTime.unboxToLong((Object)replicationSessions3.apply((Object)foo1)));
        Assertions.assertEquals((long)3L, (long)BoxesRunTime.unboxToLong((Object)replicationSessions3.apply((Object)bar1)));
    }

    @Test
    public void testLastFetchedEpoch() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)Uuid.randomUuid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)Uuid.randomUuid())}))).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$4 -> x$4.swap())).asJava();
        TopicIdPartition foo0 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 0));
        TopicIdPartition foo1 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 1));
        TopicIdPartition bar1 = new TopicIdPartition((Uuid)topicIds.get("bar"), new TopicPartition("bar", 1));
        short version = ApiKeys.FETCH.latestVersion();
        Uuid x$8 = foo0.topicId();
        int x$1 = foo1.partition();
        long x$42 = 0L;
        int x$5 = 100;
        int x$6 = -1;
        long x$7 = -1L;
        .colon.colon x$9 = new .colon.colon((Object)this.makeFetchPartition(foo0.partition(), 0L, 0L, 100, -1, -1, -1L), (List)new .colon.colon((Object)this.makeFetchPartition(x$1, 10L, x$42, x$5, 1, x$6, x$7), (List)Nil$.MODULE$));
        String x$10 = this.makeFetchTopic$default$1();
        Uuid x$18 = bar1.topicId();
        int x$11 = bar1.partition();
        long x$15 = this.makeFetchPartition$default$3();
        int x$16 = this.makeFetchPartition$default$4();
        long x$17 = this.makeFetchPartition$default$7();
        .colon.colon x$19 = new .colon.colon((Object)this.makeFetchPartition(x$11, 10L, x$15, x$16, 2, 1, x$17), (List)Nil$.MODULE$);
        String x$20 = this.makeFetchTopic$default$1();
        .colon.colon x$21 = new .colon.colon((Object)this.makeFetchTopic(x$10, x$8, (scala.collection.immutable.Seq<FetchRequestData.FetchPartition>)x$9), (List)new .colon.colon((Object)this.makeFetchTopic(x$20, x$18, (scala.collection.immutable.Seq<FetchRequestData.FetchPartition>)x$19), (List)Nil$.MODULE$));
        int x$22 = this.makeFetchRequest$default$1();
        int x$23 = this.makeFetchRequest$default$2();
        scala.collection.immutable.Seq<FetchRequestData.ForgottenTopic> x$24 = this.makeFetchRequest$default$4();
        FetchRequestData fetchRequest1 = this.makeFetchRequest(x$22, x$23, (scala.collection.immutable.Seq<FetchRequestData.FetchTopic>)x$21, x$24);
        FetchContext context1 = fetchManager.newContext(version, fetchRequest1, false, topicNames);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), Optional.of(BoxesRunTime.boxToInteger((int)1))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar1), Optional.of(BoxesRunTime.boxToInteger((int)2)))})), (Object)FetchSessionTest.cachedLeaderEpochs$2(context1));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar1), Optional.of(BoxesRunTime.boxToInteger((int)1)))})), (Object)FetchSessionTest.cachedLastFetchedEpochs$1(context1));
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> response = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        response.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(foo0.partition()).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        response.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(foo1.partition()).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        response.put(bar1, new FetchResponseData.PartitionData().setPartitionIndex(bar1.partition()).setHighWatermark(5L).setLastStableOffset(5L).setLogStartOffset(5L));
        int sessionId = context1.updateAndGenerateResponseData(response).sessionId();
        FetchRequestData fetchRequest2 = this.makeFetchRequest(sessionId, 1, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4());
        FetchContext context2 = fetchManager.newContext(version, fetchRequest2, false, topicNames);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), Optional.of(BoxesRunTime.boxToInteger((int)1))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar1), Optional.of(BoxesRunTime.boxToInteger((int)2)))})), (Object)FetchSessionTest.cachedLeaderEpochs$2(context2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar1), Optional.of(BoxesRunTime.boxToInteger((int)1)))})), (Object)FetchSessionTest.cachedLastFetchedEpochs$1(context2));
        context2.updateAndGenerateResponseData(response).sessionId();
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestData3 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        requestData3.put(foo0.topicPartition(), new FetchRequest.PartitionData(foo0.topicId(), 0L, 0L, 100, Optional.empty(), Optional.of(Predef$.MODULE$.int2Integer(6)), Optional.of(Predef$.MODULE$.int2Integer(5))));
        requestData3.put(foo1.topicPartition(), new FetchRequest.PartitionData(foo1.topicId(), 10L, 0L, 100, Optional.empty(), Optional.empty(), Optional.empty()));
        requestData3.put(bar1.topicPartition(), new FetchRequest.PartitionData(bar1.topicId(), 10L, 0L, 100, Optional.empty(), Optional.of(Predef$.MODULE$.int2Integer(3)), Optional.of(Predef$.MODULE$.int2Integer(3))));
        Uuid x$32 = foo0.topicId();
        int x$25 = foo0.partition();
        long x$29 = this.makeFetchPartition$default$3();
        int x$30 = this.makeFetchPartition$default$4();
        long x$31 = this.makeFetchPartition$default$7();
        .colon.colon x$33 = new .colon.colon((Object)this.makeFetchPartition(x$25, 0L, x$29, x$30, 6, 5, x$31), (List)new .colon.colon((Object)this.makeFetchPartition(foo1.partition(), 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6(), this.makeFetchPartition$default$7()), (List)Nil$.MODULE$));
        String x$34 = this.makeFetchTopic$default$1();
        Uuid x$422 = bar1.topicId();
        int x$35 = bar1.partition();
        long x$39 = this.makeFetchPartition$default$3();
        int x$40 = this.makeFetchPartition$default$4();
        long x$41 = this.makeFetchPartition$default$7();
        .colon.colon x$43 = new .colon.colon((Object)this.makeFetchPartition(x$35, 10L, x$39, x$40, 3, 3, x$41), (List)Nil$.MODULE$);
        String x$44 = this.makeFetchTopic$default$1();
        FetchRequestData fetchRequest3 = this.makeFetchRequest(sessionId, 2, (scala.collection.immutable.Seq<FetchRequestData.FetchTopic>)new .colon.colon((Object)this.makeFetchTopic(x$34, x$32, (scala.collection.immutable.Seq<FetchRequestData.FetchPartition>)x$33), (List)new .colon.colon((Object)this.makeFetchTopic(x$44, x$422, (scala.collection.immutable.Seq<FetchRequestData.FetchPartition>)x$43), (List)Nil$.MODULE$)), this.makeFetchRequest$default$4());
        FetchContext context3 = fetchManager.newContext(version, fetchRequest3, false, topicNames);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), Optional.of(BoxesRunTime.boxToInteger((int)6))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar1), Optional.of(BoxesRunTime.boxToInteger((int)3)))})), (Object)FetchSessionTest.cachedLeaderEpochs$2(context3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), Optional.of(BoxesRunTime.boxToInteger((int)5))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar1), Optional.of(BoxesRunTime.boxToInteger((int)3)))})), (Object)FetchSessionTest.cachedLastFetchedEpochs$1(context2));
    }

    private void assertPartitionsInContext(FetchRequestData expectedFetchRequest, java.util.Map<Uuid, String> topicNames, FetchContext context) {
        Iterator iterator = ((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(expectedFetchRequest.topics()).asScala().flatMap((Function1 & Serializable)topic -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(topic.partitions()).asScala().map((Function1 & Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicIdPartition(topic.topicId(), partition.partition(), (String)topicNames.get(topic.topicId()))), partition)))).iterator();
        context.foreachPartition((Function2 & Serializable)(topicPartition, data) -> {
            FetchSessionTest.$anonfun$assertPartitionsInContext$3(iterator, topicNames, topicPartition, data);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testFetchRequests() {
        FetchResponse resp8;
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        java.util.Map topicNames = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"bar")}))).asJava();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicNames).asScala().map((Function1 & Serializable)x$6 -> x$6.swap())).asJava();
        TopicIdPartition foo0 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 0));
        TopicIdPartition foo1 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 1));
        TopicIdPartition bar0 = new TopicIdPartition((Uuid)topicIds.get("bar"), new TopicPartition("bar", 0));
        TopicIdPartition bar1 = new TopicIdPartition((Uuid)topicIds.get("bar"), new TopicPartition("bar", 1));
        short version = ApiKeys.FETCH.latestVersion();
        int x$2 = 0;
        scala.collection.immutable.Seq<FetchRequestData.FetchTopic> x$3 = this.makeFetchRequest$default$3();
        scala.collection.immutable.Seq<FetchRequestData.ForgottenTopic> x$4 = this.makeFetchRequest$default$4();
        FetchRequestData fetchRequest1 = this.makeFetchRequest(x$2, -1, x$3, x$4);
        FetchContext context = fetchManager.newContext(version, fetchRequest1, true, topicNames);
        Assertions.assertEquals(SessionlessFetchContext.class, context.getClass());
        Uuid x$5 = (Uuid)topicIds.get("foo");
        .colon.colon x$62 = new .colon.colon((Object)this.makeFetchPartition(0, 0L, 0L, 100, -1, -1, -1L), (List)new .colon.colon((Object)this.makeFetchPartition(1, 10L, 0L, 100, -1, -1, -1L), (List)Nil$.MODULE$));
        String x$7 = "";
        .colon.colon x$8 = new .colon.colon((Object)this.makeFetchTopic(x$7, x$5, (scala.collection.immutable.Seq<FetchRequestData.FetchPartition>)x$62), (List)Nil$.MODULE$);
        int x$9 = 0;
        int x$10 = 0;
        scala.collection.immutable.Seq<FetchRequestData.ForgottenTopic> x$11 = this.makeFetchRequest$default$4();
        FetchRequestData fetchRequest2 = this.makeFetchRequest(x$9, x$10, (scala.collection.immutable.Seq<FetchRequestData.FetchTopic>)x$8, x$11);
        FetchContext context2 = fetchManager.newContext(version, fetchRequest2, false, topicNames);
        Assertions.assertEquals(FullFetchContext.class, context2.getClass());
        this.assertPartitionsInContext(fetchRequest2, topicNames, context2);
        Assertions.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(foo0).get()));
        Assertions.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(foo1).get()));
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData2 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData2.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData2.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertTrue((resp2.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)CollectionConverters$.MODULE$.MapHasAsScala(respData2).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicIdPartition tp = (TopicIdPartition)x0$1._1();
                FetchResponseData.PartitionData data = (FetchResponseData.PartitionData)x0$1._2();
                return new Tuple2((Object)tp.topicPartition(), (Object)data);
            }
            throw new MatchError(null);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava(), (Object)resp2.responseData(topicNames, version));
        FetchContext context3 = fetchManager.newContext(version, this.makeFetchRequest(resp2.sessionId(), 5, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4()), false, topicNames);
        Assertions.assertEquals(SessionErrorContext.class, context3.getClass());
        Assertions.assertEquals((Object)Errors.INVALID_FETCH_SESSION_EPOCH, (Object)context3.updateAndGenerateResponseData(respData2).error());
        fetchRequest2.setSessionId(resp2.sessionId() + 1).setSessionEpoch(1);
        FetchContext context4 = fetchManager.newContext(version, this.makeFetchRequest(resp2.sessionId() + 1, 1, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4()), false, topicNames);
        Assertions.assertEquals(SessionErrorContext.class, context4.getClass());
        Assertions.assertEquals((Object)Errors.FETCH_SESSION_ID_NOT_FOUND, (Object)context4.updateAndGenerateResponseData(respData2).error());
        FetchRequestData fetchRequest3 = this.makeFetchRequest(resp2.sessionId(), 1, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4());
        FetchContext context5 = fetchManager.newContext(version, fetchRequest3, false, topicNames);
        Assertions.assertEquals(IncrementalFetchContext.class, context5.getClass());
        this.assertPartitionsInContext(fetchRequest2, topicNames, context5);
        Assertions.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context5.getFetchOffset(foo1).get()));
        Assertions.assertEquals(IncrementalFetchContext.class, context5.getClass());
        Iterator reqData5Iter = ((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo0, foo1}))).iterator();
        context5.foreachPartition((Function2 & Serializable)(topicIdPart, data) -> {
            FetchSessionTest.$anonfun$testFetchRequests$3(reqData5Iter, topicIdPart, data);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context5.getFetchOffset(foo1).get()));
        FetchResponse resp5 = context5.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp5.error());
        Assertions.assertEquals((int)resp2.sessionId(), (int)resp5.sessionId());
        Assertions.assertEquals((int)0, (int)resp5.responseData(topicNames, version).size());
        FetchContext context6 = fetchManager.newContext(version, this.makeFetchRequest(resp2.sessionId(), 5, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4()), false, topicNames);
        Assertions.assertEquals(SessionErrorContext.class, context6.getClass());
        Assertions.assertEquals((Object)Errors.INVALID_FETCH_SESSION_EPOCH, (Object)context6.updateAndGenerateResponseData(respData2).error());
        FetchResponse resp7 = fetchManager.newContext(version, this.makeFetchRequest(resp2.sessionId(), 2, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4()), false, topicNames).getThrottledResponse(100);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp7.error());
        Assertions.assertEquals((int)resp2.sessionId(), (int)resp7.sessionId());
        Assertions.assertEquals((int)100, (int)resp7.throttleTimeMs());
        int prevSessionId = resp5.sessionId();
        do {
            Uuid x$12 = (Uuid)topicIds.get("bar");
            .colon.colon x$13 = new .colon.colon((Object)this.makeFetchPartition(0, 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6(), this.makeFetchPartition$default$7()), (List)new .colon.colon((Object)this.makeFetchPartition(1, 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6(), this.makeFetchPartition$default$7()), (List)Nil$.MODULE$));
            String x$14 = this.makeFetchTopic$default$1();
            FetchRequestData fetchRequest8 = this.makeFetchRequest(prevSessionId, -1, (scala.collection.immutable.Seq<FetchRequestData.FetchTopic>)new .colon.colon((Object)this.makeFetchTopic(x$14, x$12, (scala.collection.immutable.Seq<FetchRequestData.FetchPartition>)x$13), (List)Nil$.MODULE$), this.makeFetchRequest$default$4());
            FetchContext context8 = fetchManager.newContext(version, fetchRequest8, false, topicNames);
            Assertions.assertEquals(SessionlessFetchContext.class, context8.getClass());
            Assertions.assertEquals((int)0, (int)cache.size());
            LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData8 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
            respData8.put(bar0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
            respData8.put(bar1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
            resp8 = context8.updateAndGenerateResponseData(respData8);
            Assertions.assertEquals((Object)Errors.NONE, (Object)resp8.error());
        } while (resp8.sessionId() == prevSessionId);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testIncrementalFetchSession(boolean usesTopicIds) {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        java.util.Map topicNames = usesTopicIds ? CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"bar")}))).asJava() : CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$)).asJava();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicNames).asScala().map((Function1 & Serializable)x$7 -> x$7.swap())).asJava();
        short version = usesTopicIds ? ApiKeys.FETCH.latestVersion() : (short)12;
        Uuid fooId = topicIds.getOrDefault("foo", Uuid.ZERO_UUID);
        Uuid barId = topicIds.getOrDefault("bar", Uuid.ZERO_UUID);
        TopicIdPartition foo0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        TopicIdPartition foo1 = new TopicIdPartition(fooId, new TopicPartition("foo", 1));
        TopicIdPartition bar0 = new TopicIdPartition(barId, new TopicPartition("bar", 0));
        TopicIdPartition bar2 = new TopicIdPartition(barId, new TopicPartition("bar", 2));
        .colon.colon x$1 = new .colon.colon((Object)this.makeFetchTopic("foo", fooId, (scala.collection.immutable.Seq<FetchRequestData.FetchPartition>)new .colon.colon((Object)this.makeFetchPartition(foo0.partition(), 0L, 0L, 100, -1, -1, -1L), (List)new .colon.colon((Object)this.makeFetchPartition(foo1.partition(), 10L, 0L, 100, -1, -1, -1L), (List)Nil$.MODULE$))), (List)Nil$.MODULE$);
        int x$2 = 0;
        int x$3 = 0;
        scala.collection.immutable.Seq<FetchRequestData.ForgottenTopic> x$4 = this.makeFetchRequest$default$4();
        FetchRequestData fetchRequest0 = this.makeFetchRequest(x$2, x$3, (scala.collection.immutable.Seq<FetchRequestData.FetchTopic>)x$1, x$4);
        FetchContext context1 = fetchManager.newContext(version, fetchRequest0, false, topicNames);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData1.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)resp1.responseData(topicNames, version).size());
        FetchRequestData fetchRequest2 = this.makeFetchRequest(resp1.sessionId(), 1, (scala.collection.immutable.Seq<FetchRequestData.FetchTopic>)new .colon.colon((Object)this.makeFetchTopicPartition(bar0, 15L, 0L, 100, -1, -1), (List)Nil$.MODULE$), (scala.collection.immutable.Seq<FetchRequestData.ForgottenTopic>)new .colon.colon((Object)this.makeForgottenTopic("foo", fooId, (scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{foo0.partition()})))), (List)Nil$.MODULE$));
        FetchContext context2 = fetchManager.newContext(version, fetchRequest2, false, topicNames);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        Iterator reqData2Iter = ((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo1, bar0}))).iterator();
        context2.foreachPartition((Function2 & Serializable)(topicPart, x$8) -> {
            FetchSessionTest.$anonfun$testIncrementalFetchSession$2(reqData2Iter, topicPart, x$8);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)None$.MODULE$, (Object)context2.getFetchOffset(foo0));
        Assertions.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(foo1).get()));
        Assertions.assertEquals((long)15L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(bar0).get()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)context2.getFetchOffset(bar2));
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData2 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData2.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(foo1.partition()).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        respData2.put(bar0, new FetchResponseData.PartitionData().setPartitionIndex(bar0.partition()).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertEquals((int)1, (int)resp2.responseData(topicNames, version).size());
        Assertions.assertTrue((resp2.sessionId() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFetchSessionWithUnknownIdOldRequestVersion() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        java.util.Map topicNames = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"bar")}))).asJava();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicNames).asScala().map((Function1 & Serializable)x$9 -> x$9.swap())).asJava();
        TopicIdPartition foo0 = new TopicIdPartition(Uuid.ZERO_UUID, new TopicPartition("foo", 0));
        TopicIdPartition foo1 = new TopicIdPartition(Uuid.ZERO_UUID, new TopicPartition("foo", 1));
        short version = (short)12;
        String x$1 = foo0.topic();
        .colon.colon x$2 = new .colon.colon((Object)this.makeFetchPartition(foo0.partition(), 0L, 0L, 100, -1, -1, -1L), (List)new .colon.colon((Object)this.makeFetchPartition(foo1.partition(), 0L, 0L, 100, -1, -1, -1L), (List)Nil$.MODULE$));
        Uuid x$3 = Uuid.ZERO_UUID;
        .colon.colon x$4 = new .colon.colon((Object)this.makeFetchTopic(x$1, x$3, (scala.collection.immutable.Seq<FetchRequestData.FetchPartition>)x$2), (List)Nil$.MODULE$);
        int x$5 = 0;
        int x$6 = 0;
        scala.collection.immutable.Seq<FetchRequestData.ForgottenTopic> x$7 = this.makeFetchRequest$default$4();
        FetchRequestData fetchRequest1 = this.makeFetchRequest(x$5, x$6, (scala.collection.immutable.Seq<FetchRequestData.FetchTopic>)x$4, x$7);
        java.util.Map topicNamesOnlyBar = Collections.singletonMap(topicIds.get("bar"), "bar");
        FetchContext context1 = fetchManager.newContext(version, fetchRequest1, false, topicNamesOnlyBar);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData1.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)resp1.responseData(topicNames, version).size());
        resp1.responseData(topicNames, version).forEach((tp, resp) -> Assertions.assertEquals((short)Errors.NONE.code(), (short)resp.errorCode(), (String)new StringBuilder(62).append("Unexpected response from TopicPartition: ").append(tp).append(". ").append("Expected ").append(Errors.NONE.code()).append(" but got ").append(resp.errorCode()).append(".").toString()));
    }

    @Test
    public void testFetchSessionWithUnknownId() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        Uuid fooId = Uuid.randomUuid();
        Uuid barId = Uuid.randomUuid();
        Uuid zarId = Uuid.randomUuid();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fooId), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)barId), (Object)"bar"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)zarId), (Object)"zar")}))).asJava();
        TopicIdPartition foo0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        TopicIdPartition foo1 = new TopicIdPartition(fooId, new TopicPartition("foo", 1));
        TopicIdPartition zar0 = new TopicIdPartition(zarId, new TopicPartition("zar", 0));
        TopicIdPartition emptyFoo0 = new TopicIdPartition(fooId, new TopicPartition(null, 0));
        TopicIdPartition emptyFoo1 = new TopicIdPartition(fooId, new TopicPartition(null, 1));
        TopicIdPartition emptyZar0 = new TopicIdPartition(zarId, new TopicPartition(null, 0));
        short version = ApiKeys.FETCH.latestVersion();
        Uuid x$1 = foo0.topicId();
        .colon.colon x$2 = new .colon.colon((Object)this.makeFetchPartition(foo0.partition(), 0L, 0L, 100, -1, -1, -1L), (List)new .colon.colon((Object)this.makeFetchPartition(foo1.partition(), 10L, 0L, 100, -1, -1, -1L), (List)Nil$.MODULE$));
        String x$3 = "";
        Uuid x$4 = zar0.topicId();
        .colon.colon x$5 = new .colon.colon((Object)this.makeFetchPartition(zar0.partition(), 0L, 0L, 100, -1, -1, -1L), (List)Nil$.MODULE$);
        String x$6 = "";
        .colon.colon x$7 = new .colon.colon((Object)this.makeFetchTopic(x$3, x$1, (scala.collection.immutable.Seq<FetchRequestData.FetchPartition>)x$2), (List)new .colon.colon((Object)this.makeFetchTopic(x$6, x$4, (scala.collection.immutable.Seq<FetchRequestData.FetchPartition>)x$5), (List)Nil$.MODULE$));
        int x$8 = 0;
        int x$9 = 0;
        scala.collection.immutable.Seq<FetchRequestData.ForgottenTopic> x$10 = this.makeFetchRequest$default$4();
        FetchRequestData fetchRequest1 = this.makeFetchRequest(x$8, x$9, (scala.collection.immutable.Seq<FetchRequestData.FetchTopic>)x$7, x$10);
        java.util.Map<Uuid, String> topicNamesOnlyBar = Collections.singletonMap(barId, "bar");
        FetchContext context1 = fetchManager.newContext(version, fetchRequest1, false, topicNamesOnlyBar);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        this.assertPartitionsOrder(context1, (scala.collection.immutable.Seq<TopicIdPartition>)new .colon.colon((Object)emptyFoo0, (List)new .colon.colon((Object)emptyFoo1, (List)new .colon.colon((Object)emptyZar0, (List)Nil$.MODULE$))));
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(emptyFoo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setErrorCode(Errors.UNKNOWN_TOPIC_ID.code()));
        respData1.put(emptyFoo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setErrorCode(Errors.UNKNOWN_TOPIC_ID.code()));
        respData1.put(emptyZar0, new FetchResponseData.PartitionData().setPartitionIndex(1).setErrorCode(Errors.UNKNOWN_TOPIC_ID.code()));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_TOPIC_ID.code())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_TOPIC_ID.code())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)zar0.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_TOPIC_ID.code()))})), (Object)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)resp1.responseData(topicNames, version)).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                FetchResponseData.PartitionData resp = (FetchResponseData.PartitionData)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToShort((short)resp.errorCode()));
            }
            throw new MatchError(null);
        }));
        java.util.Map topicNamesNoZar = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fooId), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)barId), (Object)"bar")}))).asJava();
        FetchRequestData fetchRequest2 = this.makeFetchRequest(resp1.sessionId(), 1, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4());
        FetchContext context2 = fetchManager.newContext(ApiKeys.FETCH.latestVersion(), fetchRequest2, false, topicNamesNoZar);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        this.assertPartitionsOrder(context2, (scala.collection.immutable.Seq<TopicIdPartition>)new .colon.colon((Object)foo0, (List)new .colon.colon((Object)foo1, (List)new .colon.colon((Object)emptyZar0, (List)Nil$.MODULE$))));
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData2 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData2.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData2.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        respData2.put(emptyZar0, new FetchResponseData.PartitionData().setPartitionIndex(1).setErrorCode(Errors.UNKNOWN_TOPIC_ID.code()));
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertTrue((resp2.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)3, (int)resp2.responseData(topicNames, version).size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.NONE.code())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.NONE.code())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)zar0.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_TOPIC_ID.code()))})), (Object)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)resp2.responseData(topicNames, version)).asScala().map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                TopicPartition tp = (TopicPartition)x0$2._1();
                FetchResponseData.PartitionData resp = (FetchResponseData.PartitionData)x0$2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToShort((short)resp.errorCode()));
            }
            throw new MatchError(null);
        }));
    }

    @Test
    public void testIncrementalFetchSessionWithIdsWhenSessionDoesNotUseIds() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        HashMap<Uuid, String> topicNames = new HashMap<Uuid, String>();
        TopicIdPartition foo0 = new TopicIdPartition(Uuid.ZERO_UUID, new TopicPartition("foo", 0));
        .colon.colon x$1 = new .colon.colon((Object)this.makeFetchTopic("foo", Uuid.ZERO_UUID, (scala.collection.immutable.Seq<FetchRequestData.FetchPartition>)new .colon.colon((Object)this.makeFetchPartition(foo0.partition(), 0L, 0L, 100, -1, -1, -1L), (List)Nil$.MODULE$)), (List)Nil$.MODULE$);
        int x$2 = 0;
        int x$3 = 0;
        scala.collection.immutable.Seq<FetchRequestData.ForgottenTopic> x$4 = this.makeFetchRequest$default$4();
        FetchRequestData fetchRequest1 = this.makeFetchRequest(x$2, x$3, (scala.collection.immutable.Seq<FetchRequestData.FetchTopic>)x$1, x$4);
        FetchContext context1 = fetchManager.newContext((short)12, fetchRequest1, false, topicNames);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Uuid fooId = Uuid.randomUuid();
        topicNames.put(fooId, "foo");
        FetchRequestData fetchRequest2 = this.makeFetchRequest(resp1.sessionId(), 1, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4());
        FetchContext context2 = fetchManager.newContext(ApiKeys.FETCH.latestVersion(), fetchRequest2, false, topicNames);
        Assertions.assertEquals(SessionErrorContext.class, context2.getClass());
        LinkedHashMap respData2 = new LinkedHashMap();
        Assertions.assertEquals((Object)Errors.FETCH_SESSION_TOPIC_ID_ERROR, (Object)context2.updateAndGenerateResponseData(respData2).error());
    }

    @Test
    public void testIncrementalFetchSessionWithoutIdsWhenSessionUsesIds() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        Uuid fooId = Uuid.randomUuid();
        HashMap<Uuid, String> topicNames = new HashMap<Uuid, String>();
        topicNames.put(fooId, "foo");
        TopicIdPartition foo0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        short version = ApiKeys.FETCH.latestVersion();
        .colon.colon x$2 = new .colon.colon((Object)this.makeFetchPartition(foo0.partition(), 0L, 0L, 100, -1, -1, -1L), (List)Nil$.MODULE$);
        String x$3 = "";
        .colon.colon x$4 = new .colon.colon((Object)this.makeFetchTopic(x$3, fooId, (scala.collection.immutable.Seq<FetchRequestData.FetchPartition>)x$2), (List)Nil$.MODULE$);
        int x$5 = 0;
        int x$6 = 0;
        scala.collection.immutable.Seq<FetchRequestData.ForgottenTopic> x$7 = this.makeFetchRequest$default$4();
        FetchRequestData fetchRequest1 = this.makeFetchRequest(x$5, x$6, (scala.collection.immutable.Seq<FetchRequestData.FetchTopic>)x$4, x$7);
        FetchContext context1 = fetchManager.newContext(version, fetchRequest1, false, topicNames);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        topicNames.remove(fooId);
        Uuid newFooId = Uuid.randomUuid();
        topicNames.put(newFooId, "foo");
        FetchRequestData fetchRequest2 = this.makeFetchRequest(resp1.sessionId(), 1, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4());
        FetchContext context2 = fetchManager.newContext((short)12, fetchRequest2, false, topicNames);
        Assertions.assertEquals(SessionErrorContext.class, context2.getClass());
        LinkedHashMap respData2 = new LinkedHashMap();
        Assertions.assertEquals((Object)Errors.FETCH_SESSION_TOPIC_ID_ERROR, (Object)context2.updateAndGenerateResponseData(respData2).error());
    }

    @Test
    public void testFetchSessionUpdateTopicIdsBrokerSide() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        java.util.Map topicNames = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"bar")}))).asJava();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicNames).asScala().map((Function1 & Serializable)x$10 -> x$10.swap())).asJava();
        TopicIdPartition foo0 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 0));
        TopicIdPartition bar1 = new TopicIdPartition((Uuid)topicIds.get("bar"), new TopicPartition("bar", 1));
        short version = ApiKeys.FETCH.latestVersion();
        Uuid x$1 = (Uuid)topicIds.get(foo0.topic());
        .colon.colon x$2 = new .colon.colon((Object)this.makeFetchPartition(foo0.partition(), 0L, 0L, 100, -1, -1, -1L), (List)Nil$.MODULE$);
        String x$3 = "";
        Uuid x$4 = (Uuid)topicIds.get(bar1.topic());
        .colon.colon x$5 = new .colon.colon((Object)this.makeFetchPartition(bar1.partition(), 0L, 0L, 100, -1, -1, -1L), (List)Nil$.MODULE$);
        String x$6 = "";
        .colon.colon x$7 = new .colon.colon((Object)this.makeFetchTopic(x$3, x$1, (scala.collection.immutable.Seq<FetchRequestData.FetchPartition>)x$2), (List)new .colon.colon((Object)this.makeFetchTopic(x$6, x$4, (scala.collection.immutable.Seq<FetchRequestData.FetchPartition>)x$5), (List)Nil$.MODULE$));
        int x$8 = 0;
        int x$9 = 0;
        scala.collection.immutable.Seq<FetchRequestData.ForgottenTopic> x$102 = this.makeFetchRequest$default$4();
        FetchRequestData fetchRequest1 = this.makeFetchRequest(x$8, x$9, (scala.collection.immutable.Seq<FetchRequestData.FetchTopic>)x$7, x$102);
        FetchContext context1 = fetchManager.newContext(version, fetchRequest1, false, topicNames);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(bar1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        respData1.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(-1L).setLastStableOffset(-1L).setLogStartOffset(-1L).setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)resp1.responseData(topicNames, version).size());
        FetchRequestData fetchRequest2 = this.makeFetchRequest(resp1.sessionId(), 1, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4());
        java.util.Map topicNamesFooChanged = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicIds.get("bar")), (Object)"bar"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"foo")}))).asJava();
        FetchContext context2 = fetchManager.newContext(version, fetchRequest2, false, topicNamesFooChanged);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData2 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData2.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(-1L).setLastStableOffset(-1L).setLogStartOffset(-1L).setErrorCode(Errors.INCONSISTENT_TOPIC_ID.code()));
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertTrue((resp2.sessionId() > 0 ? 1 : 0) != 0);
        LinkedHashMap responseData2 = resp2.responseData(topicNames, version);
        Assertions.assertEquals((short)Errors.INCONSISTENT_TOPIC_ID.code(), (short)((FetchResponseData.PartitionData)responseData2.get(foo0.topicPartition())).errorCode());
    }

    private FetchResponseData.PartitionData noErrorResponse() {
        return new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L);
    }

    private FetchResponseData.PartitionData errorResponse(short errorCode) {
        return new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(-1L).setLastStableOffset(-1L).setLogStartOffset(-1L).setErrorCode(errorCode);
    }

    @Test
    public void testResolveUnknownPartitions() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        TopicIdPartition foo = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        TopicIdPartition bar = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("bar", 0));
        TopicIdPartition zar = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("zar", 0));
        TopicIdPartition fooUnresolved = new TopicIdPartition(foo.topicId(), new TopicPartition(null, foo.partition()));
        TopicIdPartition barUnresolved = new TopicIdPartition(bar.topicId(), new TopicPartition(null, bar.partition()));
        TopicIdPartition zarUnresolved = new TopicIdPartition(zar.topicId(), new TopicPartition(null, zar.partition()));
        FetchContext context1 = this.newContext$1(FetchMetadata.INITIAL, (scala.collection.immutable.Seq)new .colon.colon((Object)foo, (List)new .colon.colon((Object)bar, (List)new .colon.colon((Object)zar, (List)Nil$.MODULE$))), Predef$.MODULE$.Map().empty(), fetchManager);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        this.assertPartitionsOrder(context1, (scala.collection.immutable.Seq<TopicIdPartition>)new .colon.colon((Object)fooUnresolved, (List)new .colon.colon((Object)barUnresolved, (List)new .colon.colon((Object)zarUnresolved, (List)Nil$.MODULE$))));
        int sessionId = this.updateAndGenerateResponseData$1(context1);
        FetchContext context2 = this.newContext$1(new FetchMetadata(sessionId, 1), (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty(), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo.topicId()), (Object)foo.topic())})), fetchManager);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        this.assertPartitionsOrder(context2, (scala.collection.immutable.Seq<TopicIdPartition>)new .colon.colon((Object)foo, (List)new .colon.colon((Object)barUnresolved, (List)new .colon.colon((Object)zarUnresolved, (List)Nil$.MODULE$))));
        this.updateAndGenerateResponseData$1(context2);
        FetchContext context3 = this.newContext$1(new FetchMetadata(sessionId, 2), (scala.collection.immutable.Seq)new .colon.colon((Object)bar, (List)Nil$.MODULE$), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo.topicId()), (Object)foo.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar.topicId()), (Object)bar.topic())})), fetchManager);
        Assertions.assertEquals(IncrementalFetchContext.class, context3.getClass());
        this.assertPartitionsOrder(context3, (scala.collection.immutable.Seq<TopicIdPartition>)new .colon.colon((Object)foo, (List)new .colon.colon((Object)bar, (List)new .colon.colon((Object)zarUnresolved, (List)Nil$.MODULE$))));
        this.updateAndGenerateResponseData$1(context3);
        FetchContext context4 = this.newContext$1(new FetchMetadata(sessionId, 3), (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty(), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo.topicId()), (Object)foo.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar.topicId()), (Object)bar.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)zar.topicId()), (Object)zar.topic())})), fetchManager);
        Assertions.assertEquals(IncrementalFetchContext.class, context4.getClass());
        this.assertPartitionsOrder(context4, (scala.collection.immutable.Seq<TopicIdPartition>)new .colon.colon((Object)foo, (List)new .colon.colon((Object)bar, (List)new .colon.colon((Object)zar, (List)Nil$.MODULE$))));
        this.updateAndGenerateResponseData$1(context4);
        FetchContext context5 = this.newContext$1(new FetchMetadata(sessionId, 4), (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty(), Predef$.MODULE$.Map().empty(), fetchManager);
        Assertions.assertEquals(IncrementalFetchContext.class, context5.getClass());
        this.assertPartitionsOrder(context4, (scala.collection.immutable.Seq<TopicIdPartition>)new .colon.colon((Object)foo, (List)new .colon.colon((Object)bar, (List)new .colon.colon((Object)zar, (List)Nil$.MODULE$))));
    }

    @ParameterizedTest
    @MethodSource(value={"idUsageCombinations"})
    public void testToForgetPartitions(boolean fooStartsResolved, boolean fooEndsResolved) {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        TopicIdPartition foo = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        TopicIdPartition bar = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("bar", 0));
        TopicIdPartition fooUnresolved = new TopicIdPartition(foo.topicId(), new TopicPartition(null, foo.partition()));
        TopicIdPartition barUnresolved = new TopicIdPartition(bar.topicId(), new TopicPartition(null, bar.partition()));
        scala.collection.immutable.Map context1Names = fooStartsResolved ? (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo.topicId()), (Object)foo.topic())})) : Predef$.MODULE$.Map().empty();
        TopicIdPartition fooContext1 = fooStartsResolved ? foo : fooUnresolved;
        FetchContext context1 = this.newContext$2(FetchMetadata.INITIAL, (scala.collection.immutable.Seq)new .colon.colon((Object)fooContext1, (List)new .colon.colon((Object)bar, (List)Nil$.MODULE$)), (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty(), context1Names, fetchManager);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        this.assertPartitionsOrder(context1, (scala.collection.immutable.Seq<TopicIdPartition>)new .colon.colon((Object)fooContext1, (List)new .colon.colon((Object)barUnresolved, (List)Nil$.MODULE$)));
        int sessionId = this.updateAndGenerateResponseData$2(context1);
        scala.collection.immutable.Map context2Names = fooEndsResolved ? (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo.topicId()), (Object)foo.topic())})) : Predef$.MODULE$.Map().empty();
        TopicIdPartition fooContext2 = fooEndsResolved ? foo : fooUnresolved;
        FetchContext context2 = this.newContext$2(new FetchMetadata(sessionId, 1), (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty(), (scala.collection.immutable.Seq)new .colon.colon((Object)fooContext2, (List)Nil$.MODULE$), context2Names, fetchManager);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        this.assertPartitionsOrder(context2, (scala.collection.immutable.Seq<TopicIdPartition>)new .colon.colon((Object)barUnresolved, (List)Nil$.MODULE$));
        this.updateAndGenerateResponseData$2(context2);
        FetchContext context3 = this.newContext$2(new FetchMetadata(sessionId, 2), (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty(), (scala.collection.immutable.Seq)new .colon.colon((Object)bar, (List)Nil$.MODULE$), Predef$.MODULE$.Map().empty(), fetchManager);
        Assertions.assertEquals(SessionlessFetchContext.class, context3.getClass());
        this.assertPartitionsOrder(context3, (scala.collection.immutable.Seq<TopicIdPartition>)Nil$.MODULE$);
    }

    @Test
    public void testUpdateAndGenerateResponseData() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        TopicIdPartition foo = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        TopicIdPartition bar = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("bar", 0));
        scala.collection.immutable.Map receivingBrokerTopicNames = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo.topicId()), (Object)foo.topic())}));
        scala.collection.immutable.Map sendingTopicNames = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo.topicId()), (Object)foo.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar.topicId()), (Object)bar.topic())}));
        FetchContext context1 = this.newContext$3(FetchMetadata.LEGACY, (scala.collection.immutable.Seq)new .colon.colon((Object)foo, (List)new .colon.colon((Object)bar, (List)Nil$.MODULE$)), receivingBrokerTopicNames, fetchManager);
        Assertions.assertEquals(SessionlessFetchContext.class, context1.getClass());
        FetchSessionTest.checkResponseData$1(this.updateAndGenerateResponseData$3(context1), foo, bar, sendingTopicNames);
        FetchContext context2 = this.newContext$3(FetchMetadata.INITIAL, (scala.collection.immutable.Seq)new .colon.colon((Object)foo, (List)new .colon.colon((Object)bar, (List)Nil$.MODULE$)), receivingBrokerTopicNames, fetchManager);
        Assertions.assertEquals(FullFetchContext.class, context2.getClass());
        FetchResponse response2 = this.updateAndGenerateResponseData$3(context2);
        int sessionId = response2.sessionId();
        FetchSessionTest.checkResponseData$1(response2, foo, bar, sendingTopicNames);
        FetchContext context3 = this.newContext$3(new FetchMetadata(sessionId, 1), (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty(), receivingBrokerTopicNames, fetchManager);
        Assertions.assertEquals(IncrementalFetchContext.class, context3.getClass());
        FetchSessionTest.checkResponseData$1(this.updateAndGenerateResponseData$3(context3), foo, bar, sendingTopicNames);
        FetchContext context4 = this.newContext$3(new FetchMetadata(sessionId, 1), (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty(), receivingBrokerTopicNames, fetchManager);
        Assertions.assertEquals(SessionErrorContext.class, context4.getClass());
        Assertions.assertEquals(Collections.emptyList(), (Object)this.updateAndGenerateResponseData$3(context4).data().responses());
    }

    @Test
    public void testFetchSessionExpiration() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(2, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        Uuid fooId = Uuid.randomUuid();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fooId), (Object)"foo")}))).asJava();
        TopicIdPartition foo0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        TopicIdPartition foo1 = new TopicIdPartition(fooId, new TopicPartition("foo", 1));
        short version = ApiKeys.FETCH.latestVersion();
        .colon.colon x$2 = new .colon.colon((Object)this.makeFetchPartition(0, 0L, 0L, 100, -1, -1, -1L), (List)new .colon.colon((Object)this.makeFetchPartition(1, 10L, 0L, 100, -1, -1, -1L), (List)Nil$.MODULE$));
        String x$3 = "";
        .colon.colon x$4 = new .colon.colon((Object)this.makeFetchTopic(x$3, fooId, (scala.collection.immutable.Seq<FetchRequestData.FetchPartition>)x$2), (List)Nil$.MODULE$);
        int x$5 = 0;
        int x$6 = 0;
        scala.collection.immutable.Seq<FetchRequestData.ForgottenTopic> x$7 = this.makeFetchRequest$default$4();
        FetchRequestData session1req = this.makeFetchRequest(x$5, x$6, (scala.collection.immutable.Seq<FetchRequestData.FetchTopic>)x$4, x$7);
        FetchContext session1context1 = fetchManager.newContext(version, session1req, false, topicNames);
        Assertions.assertEquals(FullFetchContext.class, session1context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData1.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session1resp = session1context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session1resp.error());
        Assertions.assertTrue((session1resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session1resp.responseData(topicNames, version).size());
        Assertions.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        time.sleep(500L);
        .colon.colon x$9 = new .colon.colon((Object)this.makeFetchPartition(0, 0L, 0L, 100, -1, -1, -1L), (List)new .colon.colon((Object)this.makeFetchPartition(1, 10L, 0L, 100, -1, -1, -1L), (List)Nil$.MODULE$));
        String x$10 = "";
        .colon.colon x$11 = new .colon.colon((Object)this.makeFetchTopic(x$10, fooId, (scala.collection.immutable.Seq<FetchRequestData.FetchPartition>)x$9), (List)Nil$.MODULE$);
        int x$12 = 0;
        int x$13 = 0;
        scala.collection.immutable.Seq<FetchRequestData.ForgottenTopic> x$14 = this.makeFetchRequest$default$4();
        FetchRequestData session2req = this.makeFetchRequest(x$12, x$13, (scala.collection.immutable.Seq<FetchRequestData.FetchTopic>)x$11, x$14);
        FetchContext session2context = fetchManager.newContext(version, session2req, false, topicNames);
        Assertions.assertEquals(FullFetchContext.class, session2context.getClass());
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> session2RespData = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        session2RespData.put(foo0.topicPartition(), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        session2RespData.put(foo1.topicPartition(), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session2resp = session2context.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session2resp.error());
        Assertions.assertTrue((session2resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session2resp.responseData(topicNames, version).size());
        Assertions.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        Assertions.assertTrue((boolean)cache.get(session2resp.sessionId()).isDefined());
        time.sleep(500L);
        FetchContext context1v2 = fetchManager.newContext(version, this.makeFetchRequest(session1resp.sessionId(), 1, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4()), false, topicNames);
        Assertions.assertEquals(IncrementalFetchContext.class, context1v2.getClass());
        time.sleep(501L);
        .colon.colon x$16 = new .colon.colon((Object)this.makeFetchPartition(0, 0L, 0L, 100, -1, -1, -1L), (List)new .colon.colon((Object)this.makeFetchPartition(1, 10L, 0L, 100, -1, this.makeFetchPartition$default$6(), this.makeFetchPartition$default$7()), (List)Nil$.MODULE$));
        String x$17 = this.makeFetchTopic$default$1();
        .colon.colon x$18 = new .colon.colon((Object)this.makeFetchTopic(x$17, fooId, (scala.collection.immutable.Seq<FetchRequestData.FetchPartition>)x$16), (List)Nil$.MODULE$);
        int x$19 = this.makeFetchRequest$default$1();
        int x$20 = this.makeFetchRequest$default$2();
        scala.collection.immutable.Seq<FetchRequestData.ForgottenTopic> x$21 = this.makeFetchRequest$default$4();
        FetchRequestData session3req = this.makeFetchRequest(x$19, x$20, (scala.collection.immutable.Seq<FetchRequestData.FetchTopic>)x$18, x$21);
        FetchContext session3context = fetchManager.newContext(version, session3req, false, topicNames);
        Assertions.assertEquals(FullFetchContext.class, session3context.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData3 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData3.put(new TopicIdPartition(fooId, new TopicPartition("foo", 0)), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData3.put(new TopicIdPartition(fooId, new TopicPartition("foo", 1)), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session3resp = session3context.updateAndGenerateResponseData(respData3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session3resp.error());
        Assertions.assertTrue((session3resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session3resp.responseData(topicNames, version).size());
        Assertions.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        Assertions.assertFalse((boolean)cache.get(session2resp.sessionId()).isDefined(), (String)"session 2 should have been evicted by latest session, as session 1 was used more recently");
        Assertions.assertTrue((boolean)cache.get(session3resp.sessionId()).isDefined());
    }

    @Test
    public void testPrivilegedSessionHandling() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(2, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        Uuid fooId = Uuid.randomUuid();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fooId), (Object)"foo")}))).asJava();
        TopicIdPartition foo0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        TopicIdPartition foo1 = new TopicIdPartition(fooId, new TopicPartition("foo", 1));
        short version = ApiKeys.FETCH.latestVersion();
        .colon.colon x$2 = new .colon.colon((Object)this.makeFetchPartition(0, 0L, 0L, 100, -1, this.makeFetchPartition$default$6(), this.makeFetchPartition$default$7()), (List)new .colon.colon((Object)this.makeFetchPartition(1, 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6(), this.makeFetchPartition$default$7()), (List)Nil$.MODULE$));
        String x$3 = this.makeFetchTopic$default$1();
        .colon.colon x$4 = new .colon.colon((Object)this.makeFetchTopic(x$3, fooId, (scala.collection.immutable.Seq<FetchRequestData.FetchPartition>)x$2), (List)Nil$.MODULE$);
        int x$5 = this.makeFetchRequest$default$1();
        int x$6 = this.makeFetchRequest$default$2();
        scala.collection.immutable.Seq<FetchRequestData.ForgottenTopic> x$7 = this.makeFetchRequest$default$4();
        FetchRequestData session1req = this.makeFetchRequest(x$5, x$6, (scala.collection.immutable.Seq<FetchRequestData.FetchTopic>)x$4, x$7);
        FetchContext session1context = fetchManager.newContext(version, session1req, true, topicNames);
        Assertions.assertEquals(FullFetchContext.class, session1context.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData1.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session1resp = session1context.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session1resp.error());
        Assertions.assertTrue((session1resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session1resp.responseData(topicNames, version).size());
        Assertions.assertEquals((int)1, (int)cache.size());
        time.sleep(500L);
        .colon.colon x$9 = new .colon.colon((Object)this.makeFetchPartition(0, 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6(), this.makeFetchPartition$default$7()), (List)new .colon.colon((Object)this.makeFetchPartition(1, 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6(), this.makeFetchPartition$default$7()), (List)Nil$.MODULE$));
        String x$10 = this.makeFetchTopic$default$1();
        .colon.colon x$11 = new .colon.colon((Object)this.makeFetchTopic(x$10, fooId, (scala.collection.immutable.Seq<FetchRequestData.FetchPartition>)x$9), (List)Nil$.MODULE$);
        int x$12 = this.makeFetchRequest$default$1();
        int x$13 = this.makeFetchRequest$default$2();
        scala.collection.immutable.Seq<FetchRequestData.ForgottenTopic> x$14 = this.makeFetchRequest$default$4();
        FetchRequestData session2req = this.makeFetchRequest(x$12, x$13, (scala.collection.immutable.Seq<FetchRequestData.FetchTopic>)x$11, x$14);
        FetchContext session2context = fetchManager.newContext(version, session2req, false, topicNames);
        Assertions.assertEquals(FullFetchContext.class, session2context.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> session2RespData = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        session2RespData.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        session2RespData.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session2resp = session2context.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session2resp.error());
        Assertions.assertTrue((session2resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session2resp.responseData(topicNames, version).size());
        Assertions.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        Assertions.assertTrue((boolean)cache.get(session2resp.sessionId()).isDefined());
        Assertions.assertEquals((int)2, (int)cache.size());
        time.sleep(500L);
        .colon.colon x$16 = new .colon.colon((Object)this.makeFetchPartition(0, 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6(), this.makeFetchPartition$default$7()), (List)new .colon.colon((Object)this.makeFetchPartition(1, 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6(), this.makeFetchPartition$default$7()), (List)Nil$.MODULE$));
        String x$17 = this.makeFetchTopic$default$1();
        .colon.colon x$18 = new .colon.colon((Object)this.makeFetchTopic(x$17, fooId, (scala.collection.immutable.Seq<FetchRequestData.FetchPartition>)x$16), (List)Nil$.MODULE$);
        int x$19 = this.makeFetchRequest$default$1();
        int x$20 = this.makeFetchRequest$default$2();
        scala.collection.immutable.Seq<FetchRequestData.ForgottenTopic> x$21 = this.makeFetchRequest$default$4();
        FetchRequestData session3req = this.makeFetchRequest(x$19, x$20, (scala.collection.immutable.Seq<FetchRequestData.FetchTopic>)x$18, x$21);
        FetchContext session3context = fetchManager.newContext(version, session3req, true, topicNames);
        Assertions.assertEquals(FullFetchContext.class, session3context.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData3 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData3.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData3.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session3resp = session3context.updateAndGenerateResponseData(respData3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session3resp.error());
        Assertions.assertTrue((session3resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session3resp.responseData(topicNames, version).size());
        Assertions.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        Assertions.assertFalse((boolean)cache.get(session2resp.sessionId()).isDefined(), (String)"session 2 should have been evicted by session 3");
        Assertions.assertTrue((boolean)cache.get(session3resp.sessionId()).isDefined());
        Assertions.assertEquals((int)2, (int)cache.size());
        time.sleep(501L);
        .colon.colon x$23 = new .colon.colon((Object)this.makeFetchPartition(0, 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6(), this.makeFetchPartition$default$7()), (List)new .colon.colon((Object)this.makeFetchPartition(1, 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6(), this.makeFetchPartition$default$7()), (List)Nil$.MODULE$));
        String x$24 = this.makeFetchTopic$default$1();
        .colon.colon x$25 = new .colon.colon((Object)this.makeFetchTopic(x$24, fooId, (scala.collection.immutable.Seq<FetchRequestData.FetchPartition>)x$23), (List)Nil$.MODULE$);
        int x$26 = this.makeFetchRequest$default$1();
        int x$27 = this.makeFetchRequest$default$2();
        scala.collection.immutable.Seq<FetchRequestData.ForgottenTopic> x$28 = this.makeFetchRequest$default$4();
        FetchRequestData session4req = this.makeFetchRequest(x$26, x$27, (scala.collection.immutable.Seq<FetchRequestData.FetchTopic>)x$25, x$28);
        FetchContext session4context = fetchManager.newContext(version, session4req, true, topicNames);
        Assertions.assertEquals(FullFetchContext.class, session4context.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData4 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData4.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData4.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session4resp = session3context.updateAndGenerateResponseData(respData4);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session4resp.error());
        Assertions.assertTrue((session4resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session4resp.responseData(topicNames, version).size());
        Assertions.assertFalse((boolean)cache.get(session1resp.sessionId()).isDefined(), (String)"session 1 should have been evicted by session 4 even though it is privileged as it has hit eviction time");
        Assertions.assertTrue((boolean)cache.get(session3resp.sessionId()).isDefined());
        Assertions.assertTrue((boolean)cache.get(session4resp.sessionId()).isDefined());
        Assertions.assertEquals((int)2, (int)cache.size());
    }

    @Test
    public void testZeroSizeFetchSession() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        Uuid fooId = Uuid.randomUuid();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fooId), (Object)"foo")}))).asJava();
        TopicIdPartition foo0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        TopicIdPartition foo1 = new TopicIdPartition(fooId, new TopicPartition("foo", 1));
        short version = ApiKeys.FETCH.latestVersion();
        .colon.colon x$2 = new .colon.colon((Object)this.makeFetchPartition(0, 0L, 0L, 100, -1, -1, -1L), (List)new .colon.colon((Object)this.makeFetchPartition(1, 10L, 0L, 100, -1, -1, -1L), (List)Nil$.MODULE$));
        String x$3 = "";
        .colon.colon x$4 = new .colon.colon((Object)this.makeFetchTopic(x$3, fooId, (scala.collection.immutable.Seq<FetchRequestData.FetchPartition>)x$2), (List)Nil$.MODULE$);
        int x$5 = 0;
        int x$6 = 0;
        scala.collection.immutable.Seq<FetchRequestData.ForgottenTopic> x$7 = this.makeFetchRequest$default$4();
        FetchRequestData reqData1 = this.makeFetchRequest(x$5, x$6, (scala.collection.immutable.Seq<FetchRequestData.FetchTopic>)x$4, x$7);
        FetchContext context1 = fetchManager.newContext(version, reqData1, false, topicNames);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData1.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)resp1.responseData(topicNames, version).size());
        int x$11 = resp1.sessionId();
        scala.collection.immutable.Seq x$9 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}));
        String x$10 = "";
        .colon.colon x$13 = new .colon.colon((Object)this.makeForgottenTopic(x$10, fooId, (scala.collection.immutable.Seq<Object>)x$9), (List)Nil$.MODULE$);
        scala.collection.immutable.Seq<FetchRequestData.FetchTopic> x$14 = this.makeFetchRequest$default$3();
        FetchRequestData reqData2 = this.makeFetchRequest(x$11, 1, x$14, (scala.collection.immutable.Seq<FetchRequestData.ForgottenTopic>)x$13);
        FetchContext context2 = fetchManager.newContext(version, reqData2, false, topicNames);
        Assertions.assertEquals(SessionlessFetchContext.class, context2.getClass());
        LinkedHashMap respData2 = new LinkedHashMap();
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((int)0, (int)resp2.sessionId());
        Assertions.assertTrue((boolean)resp2.responseData(topicNames, version).isEmpty());
        Assertions.assertEquals((int)0, (int)cache.size());
    }

    @Test
    public void testDivergingEpoch() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        java.util.Map topicNames = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"bar")}))).asJava();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicNames).asScala().map((Function1 & Serializable)x$14 -> x$14.swap())).asJava();
        TopicIdPartition tp1 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 1));
        TopicIdPartition tp2 = new TopicIdPartition((Uuid)topicIds.get("bar"), new TopicPartition("bar", 2));
        short version = ApiKeys.FETCH.latestVersion();
        long x$5 = 0L;
        int x$6 = 100;
        long x$11 = 0L;
        int x$12 = 100;
        .colon.colon x$13 = new .colon.colon((Object)this.makeFetchTopicPartition(tp1, 0L, x$5, x$6, 5, 4), (List)new .colon.colon((Object)this.makeFetchTopicPartition(tp2, 0L, x$11, x$12, 5, 4), (List)Nil$.MODULE$));
        int x$142 = 0;
        int x$15 = 0;
        scala.collection.immutable.Seq<FetchRequestData.ForgottenTopic> x$16 = this.makeFetchRequest$default$4();
        FetchRequestData reqData = this.makeFetchRequest(x$142, x$15, (scala.collection.immutable.Seq<FetchRequestData.FetchTopic>)x$13, x$16);
        FetchContext context1 = fetchManager.newContext(version, reqData, false, topicNames);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(tp1.partition()).setHighWatermark(105L).setLastStableOffset(105L).setLogStartOffset(0L));
        FetchResponseData.EpochEndOffset divergingEpoch = new FetchResponseData.EpochEndOffset().setEpoch(3).setEndOffset(90L);
        respData.put(tp2, new FetchResponseData.PartitionData().setPartitionIndex(tp2.partition()).setHighWatermark(105L).setLastStableOffset(105L).setLogStartOffset(0L).setDivergingEpoch(divergingEpoch));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertNotEquals((int)0, (int)resp1.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{tp1.topicPartition(), tp2.topicPartition()}), resp1.responseData(topicNames, version).keySet());
        FetchContext context2 = fetchManager.newContext(version, this.makeFetchRequest(resp1.sessionId(), 1, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4()), false, topicNames);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp2.sessionId());
        Assertions.assertEquals(Collections.singleton(tp2.topicPartition()), resp2.responseData(topicNames, version).keySet());
        respData.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(tp1.partition()).setHighWatermark(105L).setLastStableOffset(105L).setLogStartOffset(0L).setDivergingEpoch(divergingEpoch));
        FetchResponse resp3 = context2.updateAndGenerateResponseData(respData);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp3.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp3.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{tp1.topicPartition(), tp2.topicPartition()}), resp3.responseData(topicNames, version).keySet());
        respData.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(tp1.partition()).setHighWatermark(110L).setLastStableOffset(110L).setLogStartOffset(0L));
        FetchResponse resp4 = context2.updateAndGenerateResponseData(respData);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp4.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp4.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{tp1.topicPartition(), tp2.topicPartition()}), resp4.responseData(topicNames, version).keySet());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeprioritizesPartitionsWithRecordsOnly() {
        void withRecords_records;
        void withRecords_timestampType;
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)Uuid.randomUuid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)Uuid.randomUuid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zar"), (Object)Uuid.randomUuid())}))).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$15 -> x$15.swap())).asJava();
        TopicIdPartition foo1 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 1));
        TopicIdPartition bar2 = new TopicIdPartition((Uuid)topicIds.get("bar"), new TopicPartition("bar", 2));
        TopicIdPartition zar3 = new TopicIdPartition((Uuid)topicIds.get("zar"), new TopicPartition("zar", 3));
        short version = ApiKeys.FETCH.latestVersion();
        long x$5 = 0L;
        int x$6 = 100;
        long x$11 = 0L;
        int x$12 = 100;
        long x$17 = 0L;
        int x$18 = 100;
        .colon.colon x$19 = new .colon.colon((Object)this.makeFetchTopicPartition(foo1, 0L, x$5, x$6, 5, 4), (List)new .colon.colon((Object)this.makeFetchTopicPartition(bar2, 0L, x$11, x$12, 5, 4), (List)new .colon.colon((Object)this.makeFetchTopicPartition(zar3, 0L, x$17, x$18, 5, 4), (List)Nil$.MODULE$)));
        int x$20 = 0;
        int x$21 = 0;
        scala.collection.immutable.Seq<FetchRequestData.ForgottenTopic> x$22 = this.makeFetchRequest$default$4();
        FetchRequestData reqData = this.makeFetchRequest(x$20, x$21, (scala.collection.immutable.Seq<FetchRequestData.FetchTopic>)x$19, x$22);
        FetchContext context1 = fetchManager.newContext(version, reqData, false, topicNames);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(foo1.partition()).setHighWatermark(50L).setLastStableOffset(50L).setLogStartOffset(0L));
        respData1.put(bar2, new FetchResponseData.PartitionData().setPartitionIndex(bar2.partition()).setHighWatermark(50L).setLastStableOffset(50L).setLogStartOffset(0L));
        respData1.put(zar3, new FetchResponseData.PartitionData().setPartitionIndex(zar3.partition()).setHighWatermark(50L).setLastStableOffset(50L).setLogStartOffset(0L));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertNotEquals((int)0, (int)resp1.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{foo1.topicPartition(), bar2.topicPartition(), zar3.topicPartition()}), resp1.responseData(topicNames, version).keySet());
        FetchContext context2 = fetchManager.newContext(version, this.makeFetchRequest(resp1.sessionId(), 1, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4()), false, topicNames);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        this.assertPartitionsOrder(context2, (scala.collection.immutable.Seq<TopicIdPartition>)new .colon.colon((Object)foo1, (List)new .colon.colon((Object)bar2, (List)new .colon.colon((Object)zar3, (List)Nil$.MODULE$))));
        LinkedHashMap respData2 = new LinkedHashMap();
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp2.sessionId());
        Assertions.assertEquals(Collections.emptySet(), resp2.responseData(topicNames, version).keySet());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData3 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData3.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(foo1.partition()).setHighWatermark(60L).setLastStableOffset(50L).setLogStartOffset(0L));
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(100L, null)};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var32_29 = null;
        simpleRecordArray = null;
        respData3.put(bar2, new FetchResponseData.PartitionData().setPartitionIndex(bar2.partition()).setHighWatermark(60L).setLastStableOffset(50L).setLogStartOffset(0L).setRecords((BaseRecords)MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records)));
        respData3.put(zar3, new FetchResponseData.PartitionData().setPartitionIndex(zar3.partition()).setHighWatermark(50L).setLastStableOffset(50L).setLogStartOffset(0L));
        FetchResponse resp3 = context2.updateAndGenerateResponseData(respData3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp3.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp3.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{foo1.topicPartition(), bar2.topicPartition()}), resp3.responseData(topicNames, version).keySet());
        this.assertPartitionsOrder(context2, (scala.collection.immutable.Seq<TopicIdPartition>)new .colon.colon((Object)foo1, (List)new .colon.colon((Object)zar3, (List)new .colon.colon((Object)bar2, (List)Nil$.MODULE$))));
    }

    private void assertPartitionsOrder(FetchContext context, scala.collection.immutable.Seq<TopicIdPartition> partitions) {
        ArrayBuffer partitionsInContext = ArrayBuffer$.MODULE$.empty();
        context.foreachPartition((Function2 & Serializable)(tp, x$16) -> {
            partitionsInContext.$plus$eq((Object)tp);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals(partitions, (Object)partitionsInContext.toSeq());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSessionUpdate() {
        void var35_35;
        void var34_34;
        void var33_33;
        void var24_24;
        void var23_23;
        void var22_22;
        void var15_15;
        void var14_14;
        void var13_13;
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.defaultPartitionListener((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)new DefaultPartitionListener(false));
        FetchSession session = new FetchSession(0, false, new ImplicitLinkedHashCollection(), true, 0L, 0L, 0);
        TopicIdPartition foo0 = new TopicIdPartition(Uuid.randomUuid(), 0, "foo");
        TopicIdPartition bar1 = new TopicIdPartition(Uuid.randomUuid(), 1, "bar");
        TopicIdPartition zar2 = new TopicIdPartition(Uuid.randomUuid(), 2, "zar");
        java.util.Map topicNames = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0.topicId()), (Object)foo0.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar1.topicId()), (Object)bar1.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)zar2.topicId()), (Object)zar2.topic())}))).asJava();
        boolean fetchRequestUsesTopicIds = true;
        .colon.colon x$1 = new .colon.colon((Object)this.makeFetchTopicPartition(foo0, 10L, 1L, 100, -1, -1), (List)new .colon.colon((Object)this.makeFetchTopicPartition(bar1, 20L, 2L, 200, -1, -1), (List)Nil$.MODULE$));
        int x$2 = 0;
        int x$3 = 0;
        scala.collection.immutable.Seq<FetchRequestData.ForgottenTopic> x$4 = this.makeFetchRequest$default$4();
        Tuple3 tuple3 = session.update(fetchRequestUsesTopicIds, this.makeFetchRequest(x$2, x$3, (scala.collection.immutable.Seq<FetchRequestData.FetchTopic>)x$1, x$4), topicNames);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        ArrayList added1 = (ArrayList)tuple3._1();
        ArrayList updated1 = (ArrayList)tuple3._2();
        ArrayList removed1 = (ArrayList)tuple3._3();
        FetchSessionTest.maybeRegisterListeners$1(session, replicaManager);
        Assertions.assertEquals((int)2, (int)session.size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo0, bar1})), (Object)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)var13_13).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)var14_14).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)var15_15).asScala().toSet());
        FetchSessionTest.assertPartitionState$1(foo0, 10L, 1L, 100, Optional.empty(), Optional.empty(), session);
        IncrementalPartitionFetchMetadata bar1Metadata = FetchSessionTest.assertPartitionState$1(bar1, 20L, 2L, 200, Optional.empty(), Optional.empty(), session);
        .colon.colon x$5 = new .colon.colon((Object)this.makeFetchTopicPartition(foo0, 30L, 3L, 300, 2, 1), (List)new .colon.colon((Object)this.makeFetchTopicPartition(zar2, 50L, 5L, 500, -1, -1), (List)Nil$.MODULE$));
        int x$6 = 0;
        int x$7 = 0;
        scala.collection.immutable.Seq<FetchRequestData.ForgottenTopic> x$8 = this.makeFetchRequest$default$4();
        Tuple3 tuple32 = session.update(fetchRequestUsesTopicIds, this.makeFetchRequest(x$6, x$7, (scala.collection.immutable.Seq<FetchRequestData.FetchTopic>)x$5, x$8), topicNames);
        if (tuple32 == null) {
            throw new MatchError(null);
        }
        ArrayList added2 = (ArrayList)tuple32._1();
        ArrayList updated2 = (ArrayList)tuple32._2();
        ArrayList removed2 = (ArrayList)tuple32._3();
        FetchSessionTest.maybeRegisterListeners$1(session, replicaManager);
        Assertions.assertEquals((int)3, (int)session.size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{zar2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)var22_22).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)var23_23).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)var24_24).asScala().toSet());
        FetchSessionTest.assertPartitionState$1(foo0, 30L, 3L, 300, Optional.of(Predef$.MODULE$.int2Integer(2)), Optional.of(Predef$.MODULE$.int2Integer(1)), session);
        FetchSessionTest.assertPartitionState$1(bar1, 20L, 2L, 200, Optional.empty(), Optional.empty(), session);
        FetchSessionTest.assertPartitionState$1(zar2, 50L, 5L, 500, Optional.empty(), Optional.empty(), session);
        .colon.colon x$12 = new .colon.colon((Object)this.makeFetchTopicPartition(zar2, 100L, 55L, 100, -1, this.makeFetchTopicPartition$default$6()), (List)Nil$.MODULE$);
        Uuid x$9 = bar1.topicId();
        scala.collection.immutable.Seq x$10 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{bar1.partition()}));
        String x$11 = this.makeForgottenTopic$default$1();
        .colon.colon x$13 = new .colon.colon((Object)this.makeForgottenTopic(x$11, x$9, (scala.collection.immutable.Seq<Object>)x$10), (List)Nil$.MODULE$);
        int x$14 = this.makeFetchRequest$default$1();
        int x$15 = this.makeFetchRequest$default$2();
        Tuple3 tuple33 = session.update(fetchRequestUsesTopicIds, this.makeFetchRequest(x$14, x$15, (scala.collection.immutable.Seq<FetchRequestData.FetchTopic>)x$12, (scala.collection.immutable.Seq<FetchRequestData.ForgottenTopic>)x$13), topicNames);
        if (tuple33 == null) {
            throw new MatchError(null);
        }
        ArrayList added3 = (ArrayList)tuple33._1();
        ArrayList updated3 = (ArrayList)tuple33._2();
        ArrayList removed3 = (ArrayList)tuple33._3();
        FetchSessionTest.maybeRegisterListeners$1(session, replicaManager);
        Assertions.assertEquals((int)2, (int)session.size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)var33_33).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{zar2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)var34_34).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{bar1})), (Object)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)var35_35).asScala().toSet());
        FetchSessionTest.assertPartitionState$1(foo0, 30L, 3L, 300, Optional.of(Predef$.MODULE$.int2Integer(2)), Optional.of(Predef$.MODULE$.int2Integer(1)), session);
        FetchSessionTest.assertPartitionRemoved$1(bar1, session);
        FetchSessionTest.assertPartitionState$1(zar2, 100L, 55L, 100, Optional.empty(), Optional.empty(), session);
        ((ReplicaManager)Mockito.verify((Object)replicaManager)).defaultPartitionListener(foo0.topicPartition());
        ((ReplicaManager)Mockito.verify((Object)replicaManager)).defaultPartitionListener(bar1.topicPartition());
        ((ReplicaManager)Mockito.verify((Object)replicaManager)).defaultPartitionListener(zar2.topicPartition());
        Assertions.assertNull((Object)bar1Metadata.defaultPartitionListener());
    }

    @Test
    public void testSessionClose() {
        ImplicitLinkedHashCollection cacheMap = new ImplicitLinkedHashCollection();
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        IncrementalPartitionFetchMetadata partition1 = (IncrementalPartitionFetchMetadata)Mockito.spy((Object)new IncrementalPartitionFetchMetadata("foo", Uuid.randomUuid(), 0));
        cacheMap.add((ImplicitLinkedHashCollection.Element)partition1);
        topicIds.put(partition1.topic(), partition1.topicId());
        IncrementalPartitionFetchMetadata partition2 = (IncrementalPartitionFetchMetadata)Mockito.spy((Object)new IncrementalPartitionFetchMetadata("bar", Uuid.randomUuid(), 0));
        cacheMap.add((ImplicitLinkedHashCollection.Element)partition2);
        topicIds.put(partition2.topic(), partition2.topicId());
        new FetchSession(0, false, cacheMap, true, 0L, 0L, 0).close();
        ((IncrementalPartitionFetchMetadata)Mockito.verify((Object)partition1)).close();
        ((IncrementalPartitionFetchMetadata)Mockito.verify((Object)partition2)).close();
    }

    private FetchRequestData makeFetchRequest(int sessionId, int sessionEpoch, scala.collection.immutable.Seq<FetchRequestData.FetchTopic> topics, scala.collection.immutable.Seq<FetchRequestData.ForgottenTopic> forgottenTopics) {
        return new FetchRequestData().setSessionId(sessionId).setSessionEpoch(sessionEpoch).setTopics(CollectionConverters$.MODULE$.SeqHasAsJava(topics).asJava()).setForgottenTopicsData(CollectionConverters$.MODULE$.SeqHasAsJava(forgottenTopics).asJava());
    }

    private int makeFetchRequest$default$1() {
        return 0;
    }

    private int makeFetchRequest$default$2() {
        return 0;
    }

    private scala.collection.immutable.Seq<FetchRequestData.FetchTopic> makeFetchRequest$default$3() {
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    }

    private scala.collection.immutable.Seq<FetchRequestData.ForgottenTopic> makeFetchRequest$default$4() {
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    }

    private FetchRequestData.FetchTopic makeFetchTopicPartition(TopicIdPartition topicIdPartition, long fetchOffset, long logStartOffset, int maxBytes, int currentLeaderEpoch, int lastFetchedEpoch) {
        return this.makeFetchTopic(topicIdPartition.topic(), topicIdPartition.topicId(), (scala.collection.immutable.Seq<FetchRequestData.FetchPartition>)new .colon.colon((Object)this.makeFetchPartition(topicIdPartition.partition(), fetchOffset, logStartOffset, maxBytes, currentLeaderEpoch, lastFetchedEpoch, -1L), (List)Nil$.MODULE$));
    }

    private FetchRequestData.FetchTopic makeFetchTopic(String topic, Uuid topicId, scala.collection.immutable.Seq<FetchRequestData.FetchPartition> partitions) {
        return new FetchRequestData.FetchTopic().setTopic(topic).setTopicId(topicId).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava(partitions).asJava());
    }

    private long makeFetchTopicPartition$default$3() {
        return 0L;
    }

    private int makeFetchTopicPartition$default$4() {
        return 100;
    }

    private int makeFetchTopicPartition$default$5() {
        return -1;
    }

    private int makeFetchTopicPartition$default$6() {
        return -1;
    }

    private String makeFetchTopic$default$1() {
        return "";
    }

    private Uuid makeFetchTopic$default$2() {
        return Uuid.ZERO_UUID;
    }

    private FetchRequestData.FetchPartition makeFetchPartition(int partition, long fetchOffset, long logStartOffset, int maxBytes, int currentLeaderEpoch, int lastFetchedEpoch, long replicationSessionId) {
        return new FetchRequestData.FetchPartition().setPartition(partition).setFetchOffset(fetchOffset).setLogStartOffset(logStartOffset).setPartitionMaxBytes(maxBytes).setCurrentLeaderEpoch(currentLeaderEpoch).setLastFetchedEpoch(lastFetchedEpoch).setReplicationSessionId(replicationSessionId);
    }

    private long makeFetchPartition$default$3() {
        return 0L;
    }

    private int makeFetchPartition$default$4() {
        return 100;
    }

    private int makeFetchPartition$default$5() {
        return -1;
    }

    private int makeFetchPartition$default$6() {
        return -1;
    }

    private long makeFetchPartition$default$7() {
        return -1L;
    }

    private FetchRequestData.ForgottenTopic makeForgottenTopic(String topic, Uuid topicId, scala.collection.immutable.Seq<Object> partitions) {
        return new FetchRequestData.ForgottenTopic().setTopic(topic).setTopicId(topicId).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitions.map((Function1 & Serializable)x -> FetchSessionTest.$anonfun$makeForgottenTopic$1(BoxesRunTime.unboxToInt((Object)x)))).asJava());
    }

    private String makeForgottenTopic$default$1() {
        return "";
    }

    private static final scala.collection.immutable.Map cachedLeaderEpochs$1(FetchContext context) {
        Builder mapBuilder = Predef$.MODULE$.Map().newBuilder();
        context.foreachPartition((Function2 & Serializable)(tp, data) -> {
            mapBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)data.currentLeaderEpoch()));
            return BoxedUnit.UNIT;
        });
        return (scala.collection.immutable.Map)mapBuilder.result();
    }

    private static final scala.collection.immutable.Map cachedReplicationSessionId$1(FetchContext context) {
        Builder mapBuilder = Predef$.MODULE$.Map().newBuilder();
        context.foreachPartition((Function2 & Serializable)(tp, data) -> {
            mapBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)data.replicationSessionId())));
            return BoxedUnit.UNIT;
        });
        return (scala.collection.immutable.Map)mapBuilder.result();
    }

    private static final scala.collection.immutable.Map cachedLeaderEpochs$2(FetchContext context) {
        Builder mapBuilder = Predef$.MODULE$.Map().newBuilder();
        context.foreachPartition((Function2 & Serializable)(tp, data) -> {
            mapBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)data.currentLeaderEpoch()));
            return BoxedUnit.UNIT;
        });
        return (scala.collection.immutable.Map)mapBuilder.result();
    }

    private static final scala.collection.immutable.Map cachedLastFetchedEpochs$1(FetchContext context) {
        Builder mapBuilder = Predef$.MODULE$.Map().newBuilder();
        context.foreachPartition((Function2 & Serializable)(tp, data) -> {
            mapBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)data.lastFetchedEpoch()));
            return BoxedUnit.UNIT;
        });
        return (scala.collection.immutable.Map)mapBuilder.result();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$assertPartitionsInContext$3(Iterator iterator$1, java.util.Map topicNames$1, TopicIdPartition topicPartition, PartitionFetchMetadata data) {
        void var6_6;
        void var5_5;
        Assertions.assertTrue((boolean)iterator$1.hasNext());
        Tuple2 tuple2 = (Tuple2)iterator$1.next();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicIdPartition expectedTopicPartition = (TopicIdPartition)tuple2._1();
        FetchRequestData.FetchPartition expectedPartition = (FetchRequestData.FetchPartition)tuple2._2();
        Assertions.assertEquals((Object)var5_5, (Object)topicPartition);
        Assertions.assertEquals((Object)var5_5.topic(), topicNames$1.get(data.topicId()));
        Assertions.assertEquals((long)var6_6.fetchOffset(), (long)data.fetchOffset());
        Assertions.assertEquals((long)var6_6.logStartOffset(), (long)data.startOffset());
        Assertions.assertEquals((int)var6_6.partitionMaxBytes(), (int)data.maxBytes());
        Assertions.assertEquals((Object)RequestUtils.getLeaderEpoch((int)var6_6.currentLeaderEpoch()), (Object)data.currentLeaderEpoch());
        Assertions.assertEquals((Object)RequestUtils.getLeaderEpoch((int)var6_6.lastFetchedEpoch()), (Object)data.lastFetchedEpoch());
    }

    public static final /* synthetic */ void $anonfun$testFetchRequests$3(Iterator reqData5Iter$1, TopicIdPartition topicIdPart, PartitionFetchMetadata data) {
        TopicIdPartition tidp = (TopicIdPartition)reqData5Iter$1.next();
        Assertions.assertEquals((Object)tidp.topicPartition(), (Object)topicIdPart.topicPartition());
        Assertions.assertEquals((Object)tidp.topicId(), (Object)topicIdPart.topicId());
    }

    public static final /* synthetic */ void $anonfun$testIncrementalFetchSession$2(Iterator reqData2Iter$1, TopicIdPartition topicPart, PartitionFetchMetadata x$8) {
        Assertions.assertEquals((Object)reqData2Iter$1.next(), (Object)topicPart);
    }

    private final FetchContext newContext$1(FetchMetadata metadata, scala.collection.immutable.Seq partitions, scala.collection.immutable.Map topicNames, FetchManager fetchManager$1) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> data = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitions.foreach((Function1 & Serializable)topicIdPartition -> data.put(topicIdPartition.topicPartition(), new FetchRequest.PartitionData(topicIdPartition.topicId(), 0L, 0L, 100, Optional.empty(), Optional.empty(), Optional.empty())));
        FetchRequest fetchRequest = this.createRequest(metadata, data, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        return fetchManager$1.newContext(fetchRequest.version(), fetchRequest.data(), fetchRequest.isFromFollower(), CollectionConverters$.MODULE$.MapHasAsJava((Map)topicNames).asJava());
    }

    private final int updateAndGenerateResponseData$1(FetchContext context) {
        LinkedHashMap data = new LinkedHashMap();
        context.foreachPartition((Function2 & Serializable)(topicIdPartition, x$11) -> {
            data.put(topicIdPartition, topicIdPartition.topic() == null ? this.errorResponse(Errors.UNKNOWN_TOPIC_ID.code()) : this.noErrorResponse());
            return BoxedUnit.UNIT;
        });
        return context.updateAndGenerateResponseData(data).sessionId();
    }

    private final FetchContext newContext$2(FetchMetadata metadata, scala.collection.immutable.Seq partitions, scala.collection.immutable.Seq toForget, scala.collection.immutable.Map topicNames, FetchManager fetchManager$2) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> data = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitions.foreach((Function1 & Serializable)topicIdPartition -> data.put(topicIdPartition.topicPartition(), new FetchRequest.PartitionData(topicIdPartition.topicId(), 0L, 0L, 100, Optional.empty(), Optional.empty(), Optional.empty())));
        FetchRequest fetchRequest = this.createRequest(metadata, data, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)toForget.toList()).asJava(), false, this.createRequest$default$5());
        return fetchManager$2.newContext(fetchRequest.version(), fetchRequest.data(), fetchRequest.isFromFollower(), CollectionConverters$.MODULE$.MapHasAsJava((Map)topicNames).asJava());
    }

    private final int updateAndGenerateResponseData$2(FetchContext context) {
        LinkedHashMap data = new LinkedHashMap();
        context.foreachPartition((Function2 & Serializable)(topicIdPartition, x$12) -> {
            data.put(topicIdPartition, topicIdPartition.topic() == null ? this.errorResponse(Errors.UNKNOWN_TOPIC_ID.code()) : this.noErrorResponse());
            return BoxedUnit.UNIT;
        });
        return context.updateAndGenerateResponseData(data).sessionId();
    }

    private final FetchContext newContext$3(FetchMetadata metadata, scala.collection.immutable.Seq partitions, scala.collection.immutable.Map topicNames, FetchManager fetchManager$3) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> data = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitions.foreach((Function1 & Serializable)topicIdPartition -> data.put(topicIdPartition.topicPartition(), new FetchRequest.PartitionData(topicIdPartition.topicId(), 0L, 0L, 100, Optional.empty(), Optional.empty(), Optional.empty())));
        FetchRequest fetchRequest = this.createRequest(metadata, data, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        return fetchManager$3.newContext(fetchRequest.version(), fetchRequest.data(), fetchRequest.isFromFollower(), CollectionConverters$.MODULE$.MapHasAsJava((Map)topicNames).asJava());
    }

    private final FetchResponse updateAndGenerateResponseData$3(FetchContext context) {
        LinkedHashMap data = new LinkedHashMap();
        context.foreachPartition((Function2 & Serializable)(topicIdPartition, x$13) -> {
            data.put(topicIdPartition, topicIdPartition.topic() == null ? this.errorResponse(Errors.UNKNOWN_TOPIC_ID.code()) : this.errorResponse(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()));
            return BoxedUnit.UNIT;
        });
        return context.updateAndGenerateResponseData(data);
    }

    private static final void checkResponseData$1(FetchResponse response, TopicIdPartition foo$1, TopicIdPartition bar$1, scala.collection.immutable.Map sendingTopicNames$1) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo$1.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar$1.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_TOPIC_ID.code()))})), (Object)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)response.responseData(CollectionConverters$.MODULE$.MapHasAsJava((Map)sendingTopicNames$1).asJava(), ApiKeys.FETCH.latestVersion())).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                FetchResponseData.PartitionData resp = (FetchResponseData.PartitionData)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToShort((short)resp.errorCode()));
            }
            throw new MatchError(null);
        }));
    }

    private static final IncrementalPartitionFetchMetadata assertPartitionState$1(TopicIdPartition tp, long fetchOffset, long startOffset, int maxBytes, Optional currentLeaderEpoch, Optional lastFetchedEpoch, FetchSession session$1) {
        IncrementalPartitionFetchMetadata partitionMetadata = (IncrementalPartitionFetchMetadata)session$1.partitionMap().find((ImplicitLinkedHashCollection.Element)new IncrementalPartitionFetchMetadata(tp.topic(), tp.topicId(), tp.partition()));
        Assertions.assertNotNull((Object)partitionMetadata, (String)new StringBuilder(23).append("Metadata of ").append(tp).append(" not found.").toString());
        Assertions.assertEquals((long)fetchOffset, (long)partitionMetadata.fetchOffset());
        Assertions.assertEquals((long)startOffset, (long)partitionMetadata.startOffset());
        Assertions.assertEquals((int)maxBytes, (int)partitionMetadata.maxBytes());
        Assertions.assertEquals((Object)currentLeaderEpoch, (Object)partitionMetadata.currentLeaderEpoch());
        Assertions.assertEquals((Object)lastFetchedEpoch, (Object)partitionMetadata.lastFetchedEpoch());
        return partitionMetadata;
    }

    private static final void assertPartitionRemoved$1(TopicIdPartition tp, FetchSession session$1) {
        Assertions.assertNull((Object)((IncrementalPartitionFetchMetadata)session$1.partitionMap().find((ImplicitLinkedHashCollection.Element)new IncrementalPartitionFetchMetadata(tp.topic(), tp.topicId(), tp.partition()))), (String)new StringBuilder(25).append("Metadata of ").append(tp).append(" not deleted.").toString());
    }

    private static final void maybeRegisterListeners$1(FetchSession session$1, ReplicaManager replicaManager$1) {
        session$1.partitionMap().forEach(partitionMetadata -> partitionMetadata.maybeRegisterAsListener(0, replicaManager$1));
    }

    public static final /* synthetic */ Integer $anonfun$makeForgottenTopic$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }
}

