/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.server.BrokerFeatures;
import kafka.server.BrokerFeatures$;
import kafka.server.metadata.FeatureCacheUpdateException;
import kafka.server.metadata.ZkMetadataCache;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.server.common.Features;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005Q3A\u0001C\u0005\u0001\u001d!)Q\u0003\u0001C\u0001-!)\u0011\u0004\u0001C\u00015!)1\u0006\u0001C\u0001Y!)A\n\u0001C\u00015!)a\n\u0001C\u00015!)\u0001\u000b\u0001C\u00015!)!\u000b\u0001C\u00015\tIb)\u001b8bY&TX\r\u001a$fCR,(/Z\"bG\",G+Z:u\u0015\tQ1\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0019\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0010!\t\u00012#D\u0001\u0012\u0015\u0005\u0011\u0012!B:dC2\f\u0017B\u0001\u000b\u0012\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u0006\t\u00031\u0001i\u0011!C\u0001\ni\u0016\u001cH/R7qif$\u0012a\u0007\t\u0003!qI!!H\t\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005}\u0001\"\u0001I\u0015\u000e\u0003\u0005R!AI\u0012\u0002\u0007\u0005\u0004\u0018N\u0003\u0002%K\u00059!.\u001e9ji\u0016\u0014(B\u0001\u0014(\u0003\u0015QWO\\5u\u0015\u0005A\u0013aA8sO&\u0011!&\t\u0002\u0005)\u0016\u001cH/\u0001\u0004bg*\u000bg/\u0019\u000b\u0003[\u0019\u0003BAL\u001a6\u00016\tqF\u0003\u00021c\u0005!Q\u000f^5m\u0015\u0005\u0011\u0014\u0001\u00026bm\u0006L!\u0001N\u0018\u0003\u00075\u000b\u0007\u000f\u0005\u00027{9\u0011qg\u000f\t\u0003qEi\u0011!\u000f\u0006\u0003u5\ta\u0001\u0010:p_Rt\u0014B\u0001\u001f\u0012\u0003\u0019\u0001&/\u001a3fM&\u0011ah\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005q\n\u0002CA!E\u001b\u0005\u0011%BA\"2\u0003\u0011a\u0017M\\4\n\u0005\u0015\u0013%!B*i_J$\b\"B$\u0004\u0001\u0004A\u0015!B5oaV$\b\u0003\u0002\u001cJk)K!\u0001N \u0011\u0005AY\u0015BA#\u0012\u0003!\"Xm\u001d;Va\u0012\fG/Z(s)\"\u0014xn\u001e$bS2,G\rR;f)>LeN^1mS\u0012,\u0005o\\2iQ\t!q$A\u0016uKN$X\u000b\u001d3bi\u0016|%\u000f\u00165s_^4\u0015-\u001b7fI\u0012+X\rV8J]Z\fG.\u001b3GK\u0006$XO]3tQ\t)q$\u0001\ruKN$X\u000b\u001d3bi\u0016|%\u000f\u00165s_^\u001cVoY2fgND#AB\u0010\u0002\u0013Q,7\u000f^\"mK\u0006\u0014\bFA\u0004 \u0001")
public class FinalizedFeatureCacheTest {
    @Test
    public void testEmpty() {
        Assertions.assertTrue((boolean)new ZkMetadataCache(1, MetadataVersion.IBP_2_8_IV1, BrokerFeatures$.MODULE$.createDefault(true), (Seq)Seq$.MODULE$.empty(), false, false).getFeatureOption().isEmpty());
    }

    public java.util.Map<String, Short> asJava(scala.collection.immutable.Map<String, Object> input) {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)input.map((Function1 & Serializable)kv -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(kv._1()), (Object)((Short)kv._2())))).asJava();
    }

    @Test
    public void testUpdateOrThrowFailedDueToInvalidEpoch() {
        scala.collection.immutable.Map supportedFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)new SupportedVersionRange(1, 4))}));
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault(true);
        brokerFeatures.setSupportedFeatures(org.apache.kafka.common.feature.Features.supportedFeatures((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)supportedFeatures).asJava()));
        scala.collection.immutable.Map finalizedFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)BoxesRunTime.boxToShort((short)4))}));
        ZkMetadataCache cache = new ZkMetadataCache(1, MetadataVersion.IBP_2_8_IV1, brokerFeatures, (Seq)Seq$.MODULE$.empty(), false, false);
        cache.updateFeaturesOrThrow(finalizedFeatures, 10L);
        Assertions.assertTrue((boolean)cache.getFeatureOption().isDefined());
        Assertions.assertEquals(this.asJava((scala.collection.immutable.Map<String, Object>)finalizedFeatures), (Object)((Features)cache.getFeatureOption().get()).finalizedFeatures());
        Assertions.assertEquals((long)10L, (long)((Features)cache.getFeatureOption().get()).finalizedFeaturesEpoch());
        Assertions.assertThrows(FeatureCacheUpdateException.class, () -> cache.updateFeaturesOrThrow(finalizedFeatures, 9L));
        Assertions.assertTrue((boolean)cache.getFeatureOption().isDefined());
        Assertions.assertEquals(this.asJava((scala.collection.immutable.Map<String, Object>)finalizedFeatures), (Object)((Features)cache.getFeatureOption().get()).finalizedFeatures());
        Assertions.assertEquals((long)10L, (long)((Features)cache.getFeatureOption().get()).finalizedFeaturesEpoch());
    }

    @Test
    public void testUpdateOrThrowFailedDueToInvalidFeatures() {
        scala.collection.immutable.Map supportedFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)new SupportedVersionRange(1, 1))}));
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault(true);
        brokerFeatures.setSupportedFeatures(org.apache.kafka.common.feature.Features.supportedFeatures((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)supportedFeatures).asJava()));
        scala.collection.immutable.Map finalizedFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)BoxesRunTime.boxToShort((short)2))}));
        ZkMetadataCache cache = new ZkMetadataCache(1, MetadataVersion.IBP_2_8_IV1, brokerFeatures, (Seq)Seq$.MODULE$.empty(), false, false);
        Assertions.assertThrows(FeatureCacheUpdateException.class, () -> cache.updateFeaturesOrThrow(finalizedFeatures, 12L));
        Assertions.assertTrue((boolean)cache.getFeatureOption().isEmpty());
    }

    @Test
    public void testUpdateOrThrowSuccess() {
        scala.collection.immutable.Map supportedFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)new SupportedVersionRange(1, 4))}));
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault(true);
        brokerFeatures.setSupportedFeatures(org.apache.kafka.common.feature.Features.supportedFeatures((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)supportedFeatures).asJava()));
        scala.collection.immutable.Map finalizedFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)BoxesRunTime.boxToShort((short)3))}));
        ZkMetadataCache cache = new ZkMetadataCache(1, MetadataVersion.IBP_2_8_IV1, brokerFeatures, (Seq)Seq$.MODULE$.empty(), false, false);
        cache.updateFeaturesOrThrow(finalizedFeatures, 12L);
        Assertions.assertTrue((boolean)cache.getFeatureOption().isDefined());
        Assertions.assertEquals(this.asJava((scala.collection.immutable.Map<String, Object>)finalizedFeatures), (Object)((Features)cache.getFeatureOption().get()).finalizedFeatures());
        Assertions.assertEquals((long)12L, (long)((Features)cache.getFeatureOption().get()).finalizedFeaturesEpoch());
    }

    @Test
    public void testClear() {
        scala.collection.immutable.Map supportedFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)new SupportedVersionRange(1, 4))}));
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault(true);
        brokerFeatures.setSupportedFeatures(org.apache.kafka.common.feature.Features.supportedFeatures((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)supportedFeatures).asJava()));
        scala.collection.immutable.Map finalizedFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)BoxesRunTime.boxToShort((short)3))}));
        ZkMetadataCache cache = new ZkMetadataCache(1, MetadataVersion.IBP_2_8_IV1, brokerFeatures, (Seq)Seq$.MODULE$.empty(), false, false);
        cache.updateFeaturesOrThrow(finalizedFeatures, 12L);
        Assertions.assertTrue((boolean)cache.getFeatureOption().isDefined());
        Assertions.assertEquals(this.asJava((scala.collection.immutable.Map<String, Object>)finalizedFeatures), (Object)((Features)cache.getFeatureOption().get()).finalizedFeatures());
        Assertions.assertEquals((long)12L, (long)((Features)cache.getFeatureOption().get()).finalizedFeaturesEpoch());
        cache.clearFeatures();
        Assertions.assertTrue((boolean)cache.getFeatureOption().isEmpty());
    }
}

