/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.telemetry.api.events.NoOpEventEmitter;
import io.opentelemetry.context.Context;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import kafka.network.RequestChannel;
import kafka.server.ControllerInformation;
import kafka.server.ControllerNodeProvider;
import kafka.server.ForwardingManager;
import kafka.server.ForwardingManagerImpl;
import kafka.server.MockNodeToControllerChannelManager;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.EnvelopeResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestLogFilter;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.server.audit.NoOpAuditLogProvider;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t}a\u0001B\u0012%\u0001%BQ\u0001\r\u0001\u0005\u0002EBq\u0001\u000e\u0001C\u0002\u0013%Q\u0007\u0003\u0004C\u0001\u0001\u0006IA\u000e\u0005\b\u0007\u0002\u0011\r\u0011\"\u0003E\u0011\u0019Y\u0005\u0001)A\u0005\u000b\"9A\n\u0001b\u0001\n\u0013i\u0005BB)\u0001A\u0003%a\nC\u0004S\u0001\t\u0007I\u0011B*\t\r]\u0003\u0001\u0015!\u0003U\u0011\u001dA\u0006A1A\u0005\neCa!\u0018\u0001!\u0002\u0013Q\u0006b\u00020\u0001\u0005\u0004%Ia\u0018\u0005\u0007U\u0002\u0001\u000b\u0011\u00021\t\u000b-\u0004A\u0011\u00027\t\u000bA\u0004A\u0011B9\t\u000bU\u0004A\u0011B9\t\u000bY\u0004A\u0011A<\u0007\r\u00055\u0001\u0001AA\b\u0011\u0019\u0001$\u0003\"\u0001\u0002\u0018!I\u0011Q\u0004\nA\u0002\u0013\u0005\u0011q\u0004\u0005\n\u0003O\u0011\u0002\u0019!C\u0001\u0003SA\u0001\"a\f\u0013A\u0003&\u0011\u0011\u0005\u0005\b\u0003s\u0011B\u0011IA\u001e\u0011\u001d\tID\u0005C!\u0003wBaa\u001b\n\u0005B\u0005\u0005\u0007BBAc\u0001\u0011\u0005q\u000f\u0003\u0004\u0002J\u0002!\ta\u001e\u0005\u0007\u0003\u001b\u0004A\u0011A<\t\r\u0005E\u0007\u0001\"\u0001x\u0011\u0019\t)\u000e\u0001C\u0001o\"1\u0011\u0011\u001c\u0001\u0005\u0002]Dq!!8\u0001\t\u0013\ty\u000eC\u0004\u0002^\u0002!I!a?\t\u000f\tU\u0001\u0001\"\u0003\u0003\u0018\t)bi\u001c:xCJ$\u0017N\\4NC:\fw-\u001a:UKN$(BA\u0013'\u0003\u0019\u0019XM\u001d<fe*\tq%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Q\u0003CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002eA\u00111\u0007A\u0007\u0002I\u0005!A/[7f+\u00051\u0004CA\u001cA\u001b\u0005A$BA\u001d;\u0003\u0011)H/\u001b7\u000b\u0005\u0015Z$BA\u0014=\u0015\tid(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u007f\u0005\u0019qN]4\n\u0005\u0005C$\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\r\rd\u0017.\u001a8u+\u0005)\u0005C\u0001$J\u001b\u00059%B\u0001%<\u0003\u001d\u0019G.[3oiNL!AS$\u0003\u00155{7m[\"mS\u0016tG/A\u0004dY&,g\u000e\u001e\u0011\u0002-\r|g\u000e\u001e:pY2,'OT8eKB\u0013xN^5eKJ,\u0012A\u0014\t\u0003g=K!\u0001\u0015\u0013\u0003-\r{g\u000e\u001e:pY2,'OT8eKB\u0013xN^5eKJ\fqcY8oiJ|G\u000e\\3s\u001d>$W\r\u0015:pm&$WM\u001d\u0011\u0002%\t\u0014xn[3s)>\u001cuN\u001c;s_2dWM]\u000b\u0002)B\u00111'V\u0005\u0003-\u0012\u0012!%T8dW:{G-\u001a+p\u0007>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\u0018a\u00052s_.,'\u000fV8D_:$(o\u001c7mKJ\u0004\u0013!\u00054pe^\f'\u000fZ5oO6\u000bg.Y4feV\t!\f\u0005\u000247&\u0011A\f\n\u0002\u0016\r>\u0014x/\u0019:eS:<W*\u00198bO\u0016\u0014\u0018*\u001c9m\u0003I1wN]<be\u0012LgnZ'b]\u0006<WM\u001d\u0011\u0002!A\u0014\u0018N\\2ja\u0006d')^5mI\u0016\u0014X#\u00011\u0011\u0005\u0005DW\"\u00012\u000b\u0005\r$\u0017!D1vi\",g\u000e^5dCR|'O\u0003\u0002fM\u0006A1/Z2ve&$\u0018P\u0003\u0002hw\u000511m\\7n_:L!!\u001b2\u00039\u0011+g-Y;mi.\u000bgm[1Qe&t7-\u001b9bY\n+\u0018\u000e\u001c3fe\u0006\t\u0002O]5oG&\u0004\u0018\r\u001c\"vS2$WM\u001d\u0011\u0002+\r|g\u000e\u001e:pY2,'/\u00119j-\u0016\u00148/[8ogV\tQ\u000e\u0005\u0002G]&\u0011qn\u0012\u0002\u0010\u001d>$W-\u00119j-\u0016\u00148/[8og\u0006q1m\u001c8ue>dG.\u001a:J]\u001a|W#\u0001:\u0011\u0005M\u001a\u0018B\u0001;%\u0005U\u0019uN\u001c;s_2dWM]%oM>\u0014X.\u0019;j_:\f1#Z7qif\u001cuN\u001c;s_2dWM]%oM>\f\u0011\u0005^3tiJ+7\u000f]8og\u0016\u001cuN\u001d:fY\u0006$\u0018n\u001c8JI6K7/\\1uG\"$\u0012\u0001\u001f\t\u0003WeL!A\u001f\u0017\u0003\tUs\u0017\u000e\u001e\u0015\u0003#q\u00042!`A\u0005\u001b\u0005q(bA@\u0002\u0002\u0005\u0019\u0011\r]5\u000b\t\u0005\r\u0011QA\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\t9AP\u0001\u0006UVt\u0017\u000e^\u0005\u0004\u0003\u0017q(\u0001\u0002+fgR\u00141ER8so\u0006\u0014H-\u001b8h\u001b\u0006t\u0017mZ3s\r>\u0014X*\u001e7uSR+g.\u00198u)\u0016\u001cHo\u0005\u0003\u0013U\u0005E\u0001cA\u001a\u0002\u0014%\u0019\u0011Q\u0003\u0013\u0003#\u0019{'o^1sI&tw-T1oC\u001e,'\u000f\u0006\u0002\u0002\u001aA\u0019\u00111\u0004\n\u000e\u0003\u0001\t\u0001C]3tKJL\u0017\r\\5{K\u0012\u0014u\u000eZ=\u0016\u0005\u0005\u0005\u0002cA\u0016\u0002$%\u0019\u0011Q\u0005\u0017\u0003\u000f\t{w\u000e\\3b]\u0006!\"/Z:fe&\fG.\u001b>fI\n{G-_0%KF$2\u0001_A\u0016\u0011%\ti#FA\u0001\u0002\u0004\t\t#A\u0002yIE\n\u0011C]3tKJL\u0017\r\\5{K\u0012\u0014u\u000eZ=!Q\r1\u00121\u0007\t\u0004W\u0005U\u0012bAA\u001cY\tAao\u001c7bi&dW-\u0001\bg_J<\u0018M\u001d3SKF,Xm\u001d;\u0015\u000fa\fi$!\u0016\u0002f!9\u0011qH\fA\u0002\u0005\u0005\u0013aD8sS\u001eLg.\u00197SKF,Xm\u001d;\u0011\t\u0005\r\u0013q\n\b\u0005\u0003\u000b\nY%\u0004\u0002\u0002H)\u0019\u0011\u0011\n\u0014\u0002\u000f9,Go^8sW&!\u0011QJA$\u00039\u0011V-];fgR\u001c\u0005.\u00198oK2LA!!\u0015\u0002T\t9!+Z9vKN$(\u0002BA'\u0003\u000fBq!a\u0016\u0018\u0001\u0004\tI&\u0001\boK^\u0014V-];fgR\u0014u\u000eZ=\u0011\t\u0005m\u0013\u0011M\u0007\u0003\u0003;R1!a\u0018g\u0003!\u0011X-];fgR\u001c\u0018\u0002BA2\u0003;\u0012q\"\u00112tiJ\f7\r\u001e*fcV,7\u000f\u001e\u0005\b\u0003O:\u0002\u0019AA5\u0003A\u0011Xm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000e\u0005\u0004,\u0003W\ny\u0007_\u0005\u0004\u0003[b#!\u0003$v]\u000e$\u0018n\u001c82!\u0015Y\u0013\u0011OA;\u0013\r\t\u0019\b\f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005m\u0013qO\u0005\u0005\u0003s\niF\u0001\tBEN$(/Y2u%\u0016\u001c\bo\u001c8tKRY\u00010! \u0002\b\u0006m\u0015qTA`\u0011\u001d\ty\b\u0007a\u0001\u0003\u0003\u000baB]3rk\u0016\u001cHoQ8oi\u0016DH\u000f\u0005\u0003\u0002\\\u0005\r\u0015\u0002BAC\u0003;\u0012aBU3rk\u0016\u001cHoQ8oi\u0016DH\u000fC\u0004\u0002\nb\u0001\r!a#\u0002#I,\u0017/^3ti\n+hMZ3s\u0007>\u0004\u0018\u0010\u0005\u0003\u0002\u000e\u0006]UBAAH\u0015\u0011\t\t*a%\u0002\u00079LwN\u0003\u0002\u0002\u0016\u0006!!.\u0019<b\u0013\u0011\tI*a$\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000fC\u0004\u0002\u001eb\u0001\r!!\u0017\u0002\u0017I,\u0017/^3ti\n{G-\u001f\u0005\b\u0003CC\u0002\u0019AAR\u0003=\u0011X-];fgR$vn\u0015;sS:<\u0007#B\u0016\u0002&\u0006%\u0016bAATY\tIa)\u001e8di&|g\u000e\r\t\u0005\u0003W\u000bIL\u0004\u0003\u0002.\u0006U\u0006cAAXY5\u0011\u0011\u0011\u0017\u0006\u0004\u0003gC\u0013A\u0002\u001fs_>$h(C\u0002\u000282\na\u0001\u0015:fI\u00164\u0017\u0002BA^\u0003{\u0013aa\u0015;sS:<'bAA\\Y!9\u0011q\r\rA\u0002\u0005%TCAAb!\u0011Y\u0013\u0011O7\u00023Q,7\u000f^'vYRLG+\u001a8b]R4uN]<be\u0012Lgn\u001a\u0015\u00035q\fq\u0003^3tiVs7/\u001e9q_J$X\r\u001a,feNLwN\\:)\u0005ma\u0018A\r;fgR4uN]<be\u0012Lgn\u001a+j[\u0016|W\u000f^,bSRLgn\u001a$pe\u000e{g\u000e\u001e:pY2,'\u000fR5tG>4XM]=)\u0005qa\u0018a\b;fgR4uN]<be\u0012Lgn\u001a+j[\u0016|W\u000f^!gi\u0016\u0014(+\u001a;ss\"\u0012Q\u0004`\u0001(i\u0016\u001cH/\u00168tkB\u0004xN\u001d;fIZ+'o]5p]\u001a\u0013x.\u001c(fi^|'o[\"mS\u0016tG\u000f\u000b\u0002\u001fy\u0006AB/Z:u\r\u0006LG.\u001a3BkRDWM\u001c;jG\u0006$\u0018n\u001c8)\u0005}a\u0018\u0001\u00042vS2$'+Z9vKN$HCBAq\u0003[\f\t\u0010E\u0004,\u0003G\f9/a#\n\u0007\u0005\u0015HF\u0001\u0004UkBdWM\r\t\u0005\u00037\nI/\u0003\u0003\u0002l\u0006u#!\u0004*fcV,7\u000f\u001e%fC\u0012,'\u000fC\u0004\u0002p\u0002\u0002\r!!\u0017\u0002\t\t|G-\u001f\u0005\b\u0003g\u0004\u0003\u0019AA{\u00035\u0019wN\u001d:fY\u0006$\u0018n\u001c8JIB\u00191&a>\n\u0007\u0005eHFA\u0002J]R$\u0002\"!\u0011\u0002~\n\u0005!Q\u0001\u0005\b\u0003\u007f\f\u0003\u0019AAt\u00035\u0011X-];fgRDU-\u00193fe\"9!1A\u0011A\u0002\u0005-\u0015!\u0004:fcV,7\u000f\u001e\"vM\u001a,'\u000fC\u0004\u0003\b\u0005\u0002\rA!\u0003\u0002\u0013A\u0014\u0018N\\2ja\u0006d\u0007\u0003\u0002B\u0006\u0005#i!A!\u0004\u000b\u0007\t=A-\u0001\u0003bkRD\u0017\u0002\u0002B\n\u0005\u001b\u0011abS1gW\u0006\u0004&/\u001b8dSB\fG.\u0001\fuKN$\u0018\t\u001c;fe\u000e{gNZ5h%\u0016\fX/Z:u+\t\u0011I\u0002\u0005\u0003\u0002\\\tm\u0011\u0002\u0002B\u000f\u0003;\u00121#\u00117uKJ\u001cuN\u001c4jON\u0014V-];fgR\u0004")
public class ForwardingManagerTest {
    private final MockTime time = new MockTime();
    private final MockClient client = new MockClient((Time)this.time());
    private final ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
    private final MockNodeToControllerChannelManager brokerToController = new MockNodeToControllerChannelManager(this.client(), this.time(), this.controllerNodeProvider(), this.controllerApiVersions(), 60000, 30000);
    private final ForwardingManagerImpl forwardingManager = new ForwardingManagerImpl((NodeToControllerChannelManager)this.brokerToController());
    private final DefaultKafkaPrincipalBuilder principalBuilder = new DefaultKafkaPrincipalBuilder(null, null);

    private MockTime time() {
        return this.time;
    }

    private MockClient client() {
        return this.client;
    }

    private ControllerNodeProvider controllerNodeProvider() {
        return this.controllerNodeProvider;
    }

    private MockNodeToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    private ForwardingManagerImpl forwardingManager() {
        return this.forwardingManager;
    }

    private DefaultKafkaPrincipalBuilder principalBuilder() {
        return this.principalBuilder;
    }

    private NodeApiVersions controllerApiVersions() {
        ApiVersionsResponseData.ApiVersion envelopeApiVersion = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.ENVELOPE.id).setMinVersion(ApiKeys.ENVELOPE.oldestVersion()).setMaxVersion(ApiKeys.ENVELOPE.latestVersion());
        return NodeApiVersions.create((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)envelopeApiVersion, (List)Nil$.MODULE$)).asJava());
    }

    private ControllerInformation controllerInfo() {
        return new ControllerInformation((Option)new Some((Object)new Node(0, "host", 1234)), new ListenerName(""), SecurityProtocol.PLAINTEXT, "", true);
    }

    private ControllerInformation emptyControllerInfo() {
        return new ControllerInformation((Option)None$.MODULE$, new ListenerName(""), SecurityProtocol.PLAINTEXT, "", true);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testResponseCorrelationIdMismatch() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        RequestChannel.Request request2 = this.buildRequest((RequestHeader)var4_4, (ByteBuffer)var5_5, clientPrincipal);
        ByteBuffer responseBuffer = RequestTestUtils.serializeResponseWithHeader((AbstractResponse)new AlterConfigsResponse(new AlterConfigsResponseData()), (short)var4_4.apiVersion(), (int)(requestCorrelationId + 1));
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        MockClient.RequestMatcher isEnvelopeRequest = request -> request instanceof EnvelopeRequest;
        this.client().prepareResponse(isEnvelopeRequest, (AbstractResponse)new EnvelopeResponse(responseBuffer, Errors.NONE));
        AtomicReference responseOpt = new AtomicReference();
        this.forwardingManager().forwardRequest(request2, (Function1 & Serializable)x$1 -> {
            responseOpt.set(x$1);
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertTrue((boolean)Option$.MODULE$.apply(responseOpt.get()).isDefined());
        AbstractResponse response = (AbstractResponse)((Option)responseOpt.get()).get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.UNKNOWN_SERVER_ERROR), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)response.errorCounts());
    }

    @Test
    public void testMultiTenantForwarding() {
        ForwardingManagerForMultiTenantTest forwardingManager = new ForwardingManagerForMultiTenantTest();
        RequestChannel.Request request = (RequestChannel.Request)Mockito.mock(RequestChannel.Request.class);
        RequestContext context = (RequestContext)Mockito.mock(RequestContext.class);
        MultiTenantPrincipal principal = (MultiTenantPrincipal)Mockito.mock(MultiTenantPrincipal.class);
        Mockito.when((Object)request.context()).thenReturn((Object)context);
        Mockito.when((Object)context.getPrincipal()).thenReturn((Object)principal);
        forwardingManager.forwardRequest(request, (Function1<Option<AbstractResponse>, BoxedUnit>)(Function1 & Serializable)x$2 -> {
            ForwardingManagerTest.$anonfun$testMultiTenantForwarding$1(x$2);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)forwardingManager.reserializedBody());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUnsupportedVersions() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        RequestChannel.Request request2 = this.buildRequest((RequestHeader)var4_4, (ByteBuffer)var5_5, clientPrincipal);
        ByteBuffer responseBuffer = RequestTestUtils.serializeResponseWithHeader((AbstractResponse)new AlterConfigsResponse(new AlterConfigsResponseData()), (short)var4_4.apiVersion(), (int)requestCorrelationId);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        MockClient.RequestMatcher isEnvelopeRequest = request -> request instanceof EnvelopeRequest;
        this.client().prepareResponse(isEnvelopeRequest, (AbstractResponse)new EnvelopeResponse(responseBuffer, Errors.UNSUPPORTED_VERSION));
        AtomicReference responseOpt = new AtomicReference();
        this.forwardingManager().forwardRequest(request2, (Function1 & Serializable)x$1 -> {
            responseOpt.set(x$1);
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertEquals((Object)None$.MODULE$, responseOpt.get());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testForwardingTimeoutWaitingForControllerDiscovery() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        RequestChannel.Request request = this.buildRequest((RequestHeader)var4_4, (ByteBuffer)var5_5, clientPrincipal);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.emptyControllerInfo());
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable)res -> {
            res.foreach((Function1 & Serializable)x$1 -> {
                response$1.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNull(response.get());
        this.time().sleep((long)this.brokerToController().retryTimeoutMs());
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.REQUEST_TIMED_OUT), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testForwardingTimeoutAfterRetry() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        RequestChannel.Request request = this.buildRequest((RequestHeader)var4_4, (ByteBuffer)var5_5, clientPrincipal);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable)res -> {
            res.foreach((Function1 & Serializable)x$1 -> {
                response$2.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNull(response.get());
        this.time().sleep((long)this.brokerToController().retryTimeoutMs());
        this.client().respond(this.testAlterConfigRequest().getErrorResponse(0, (Throwable)Errors.UNKNOWN_SERVER_ERROR.exception()), true);
        this.brokerToController().poll();
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.REQUEST_TIMED_OUT), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUnsupportedVersionFromNetworkClient() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        RequestChannel.Request request = this.buildRequest((RequestHeader)var4_4, (ByteBuffer)var5_5, clientPrincipal);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        this.client().prepareUnsupportedVersionResponse(arg_0 -> ForwardingManagerTest.$anonfun$testUnsupportedVersionFromNetworkClient$1((RequestHeader)var4_4, arg_0));
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable)res -> {
            res.foreach((Function1 & Serializable)x$1 -> {
                response$3.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.UNKNOWN_SERVER_ERROR), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFailedAuthentication() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        RequestChannel.Request request = this.buildRequest((RequestHeader)var4_4, (ByteBuffer)var5_5, clientPrincipal);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        this.client().createPendingAuthenticationError((Node)this.controllerInfo().node().get(), 50L);
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable)res -> {
            res.foreach((Function1 & Serializable)x$1 -> {
                response$4.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.UNKNOWN_SERVER_ERROR), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    private Tuple2<RequestHeader, ByteBuffer> buildRequest(AbstractRequest body, int correlationId) {
        RequestHeader header = new RequestHeader(body.apiKey(), body.version(), "clientId", correlationId);
        ByteBuffer buffer = body.serializeWithHeader(header);
        RequestHeader.parse((ByteBuffer)buffer);
        return new Tuple2((Object)header, (Object)buffer);
    }

    private RequestChannel.Request buildRequest(RequestHeader requestHeader, ByteBuffer requestBuffer, KafkaPrincipal principal) {
        RequestContext requestContext = new RequestContext(requestHeader, "1", InetAddress.getLocalHost(), principal, new ListenerName("client"), SecurityProtocol.SASL_PLAINTEXT, ClientInformation.EMPTY, null, false, Optional.of(this.principalBuilder()));
        return new RequestChannel.Request(1, requestContext, this.time().nanoseconds(), MemoryPool.NONE, requestBuffer, new RequestChannel.Metrics(ApiMessageType.ListenerType.CONTROLLER), (Option)None$.MODULE$, Context.root(), NoOpEventEmitter.INSTANCE, (AuditLogProvider)NoOpAuditLogProvider.INSTANCE, RequestLogFilter.MATCH_NONE, 0L);
    }

    private AlterConfigsRequest testAlterConfigRequest() {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, "foo");
        java.util.List configs = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new AlterConfigsRequest.ConfigEntry("min.insync.replicas", "1"), (List)Nil$.MODULE$)).asJava();
        return (AlterConfigsRequest)new AlterConfigsRequest.Builder(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)configResource), (Object)new AlterConfigsRequest.Config((Collection)configs))}))).asJava(), false).build();
    }

    public static final /* synthetic */ void $anonfun$testMultiTenantForwarding$1(Option x$2) {
    }

    public static final /* synthetic */ boolean $anonfun$testUnsupportedVersionFromNetworkClient$1(RequestHeader requestHeader$1, AbstractRequest req) {
        ApiKeys apiKeys = req.apiKey();
        ApiKeys apiKeys2 = requestHeader$1.apiKey();
        return !(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null);
    }

    public class ForwardingManagerForMultiTenantTest
    implements ForwardingManager {
        private volatile boolean reserializedBody;

        public void forwardRequest(RequestChannel.Request originalRequest, Function1<Option<AbstractResponse>, BoxedUnit> responseCallback) {
            ForwardingManager.forwardRequest$((ForwardingManager)this, (RequestChannel.Request)originalRequest, responseCallback);
        }

        public boolean reserializedBody() {
            return this.reserializedBody;
        }

        public void reserializedBody_$eq(boolean x$1) {
            this.reserializedBody = x$1;
        }

        public void forwardRequest(RequestChannel.Request originalRequest, AbstractRequest newRequestBody, Function1<Option<AbstractResponse>, BoxedUnit> responseCallback) {
            this.reserializedBody_$eq(true);
        }

        public void forwardRequest(RequestContext requestContext, ByteBuffer requestBufferCopy, AbstractRequest requestBody, Function0<String> requestToString, Function1<Option<AbstractResponse>, BoxedUnit> responseCallback) {
            throw new UnsupportedOperationException();
        }

        public Option<NodeApiVersions> controllerApiVersions() {
            return None$.MODULE$;
        }

        public /* synthetic */ ForwardingManagerTest kafka$server$ForwardingManagerTest$ForwardingManagerForMultiTenantTest$$$outer() {
            return ForwardingManagerTest.this;
        }

        public ForwardingManagerForMultiTenantTest() {
            if (ForwardingManagerTest.this == null) {
                throw null;
            }
            this.reserializedBody = false;
        }
    }
}

