/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import kafka.cluster.DefaultPartitionListener;
import kafka.server.FetchSession;
import kafka.server.FetchSessionCache;
import kafka.server.IncrementalPartitionFetchMetadata;
import kafka.server.IncrementalPartitionFetchMetadataTest$;
import kafka.server.ReplicaManager;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Ed\u0001B\u000e\u001d\u0001\u0005BQ\u0001\u000b\u0001\u0005\u0002%Bq\u0001\f\u0001C\u0002\u0013\u0005Q\u0006\u0003\u0004:\u0001\u0001\u0006IA\f\u0005\bu\u0001\u0011\r\u0011\"\u0001<\u0011\u0019y\u0004\u0001)A\u0005y!9\u0001\t\u0001b\u0001\n\u0003\t\u0005BB#\u0001A\u0003%!\tC\u0004G\u0001\t\u0007I\u0011A$\t\r-\u0003\u0001\u0015!\u0003I\u0011\u0015a\u0005\u0001\"\u0001N\u0011\u0015a\u0006\u0001\"\u0001N\u0011\u0015q\u0006\u0001\"\u0001N\u0011\u0015\u0001\u0007\u0001\"\u0001N\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0011\u001d\t\t\u0001\u0001C\u0001\u0003\u0007Aq!a\u0004\u0001\t\u0003\t\t\u0002C\u0004\u0002\u001e\u0001!\t!a\b\t\r\u0005\u001d\u0003\u0001\"\u0001N\u0011\u0019\tY\u0005\u0001C\u0001\u001b\"1\u0011q\n\u0001\u0005\u00025Ca!a\u0015\u0001\t\u0003i\u0005BBA,\u0001\u0011\u0005QjB\u0004\u0002\\qA\t!!\u0018\u0007\rma\u0002\u0012AA0\u0011\u0019A\u0003\u0004\"\u0001\u0002b!1q\u0010\u0007C\u0001\u0003G\u0012Q%\u00138de\u0016lWM\u001c;bYB\u000b'\u000f^5uS>tg)\u001a;dQ6+G/\u00193bi\u0006$Vm\u001d;\u000b\u0005uq\u0012AB:feZ,'OC\u0001 \u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0012\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!\u0006\u0005\u0002,\u00015\tA$\u0001\u0002uaV\ta\u0006\u0005\u00020o5\t\u0001G\u0003\u00022e\u000511m\\7n_:T!aH\u001a\u000b\u0005Q*\u0014AB1qC\u000eDWMC\u00017\u0003\ry'oZ\u0005\u0003qA\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\u0002ua\u0002\nq\u0001^8qS\u000eLE-F\u0001=!\tyS(\u0003\u0002?a\t!Q+^5e\u0003!!x\u000e]5d\u0013\u0012\u0004\u0013!\u00039beRLG/[8o+\u0005\u0011\u0005CA\u0016D\u0013\t!EDA\u0011J]\u000e\u0014X-\\3oi\u0006d\u0007+\u0019:uSRLwN\u001c$fi\u000eDW*\u001a;bI\u0006$\u0018-\u0001\u0006qCJ$\u0018\u000e^5p]\u0002\naB]3qY&\u001c\u0017-T1oC\u001e,'/F\u0001I!\tY\u0013*\u0003\u0002K9\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\u0002!Q,7\u000f^%oSRL\u0017\r\\*uCR,G#\u0001(\u0011\u0005\rz\u0015B\u0001)%\u0005\u0011)f.\u001b;)\u0005)\u0011\u0006CA*[\u001b\u0005!&BA+W\u0003\r\t\u0007/\u001b\u0006\u0003/b\u000bqA[;qSR,'O\u0003\u0002Zk\u0005)!.\u001e8ji&\u00111\f\u0016\u0002\u0005)\u0016\u001cH/A\u000euKN$X*Y=cKJ+w-[:uKJ\f5\u000fT5ti\u0016tWM\u001d\u0015\u0003\u0017I\u000b\u0011\u0002^3ti\u000ecwn]3)\u00051\u0011\u0016a\u0006;fgR,\u0006\u000fZ1uKJ+\u0017/^3tiB\u000b'/Y7tQ\ti!+\u0001\fuKN$\u0018j]\"bk\u001eDG/\u00169G_2dwn^3s)\rqE-\u001b\u0005\u0006K:\u0001\rAZ\u0001\u001bSN\u0004Vo\u001d5SKBd\u0017nY1uS>t7+\u001e9q_J$X\r\u001a\t\u0003G\u001dL!\u0001\u001b\u0013\u0003\u000f\t{w\u000e\\3b]\")!N\u0004a\u0001W\u0006!\"/\u001a9mS\u000e\fG/[8o'\u0016\u001c8/[8o\u0013\u0012\u0004\"a\t7\n\u00055$#\u0001\u0002'p]\u001eD#AD8\u0011\u0005A\u001cX\"A9\u000b\u0005I4\u0016A\u00029be\u0006l7/\u0003\u0002uc\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;)\t91H0 \t\u0003ojl\u0011\u0001\u001f\u0006\u0003sF\f\u0001\u0002\u001d:pm&$WM]\u0005\u0003wb\u0014A\"T3uQ>$7k\\;sG\u0016\fQA^1mk\u0016d\u0013A`\u0011\u0002\u007f\u0006!\u0004/^:i%\u0016\u0004H.[2bi&|gnU;qa>\u0014H/\u001a3B]\u0012\u0014V\r\u001d7jG\u0006$\u0018n\u001c8JI\u000e{WNY5oCRLwN\\:\u0002KQ,7\u000f^%t\u0007\u0006,x\r\u001b;Va\u000e{gn];nKJ<\u0016\u000e\u001e5Ue\u0006t7/Y2uS>tG#\u0002(\u0002\u0006\u0005\u001d\u0001\"B3\u0010\u0001\u00041\u0007\"\u00026\u0010\u0001\u0004Y\u0007FA\bpQ\u0015ya\u000f`A\u0007Y\u0005q\u0018\u0001\u000b;fgRL5oQ1vO\"$X\u000b]\"p]N,X.\u001a:XSRDw.\u001e;Ue\u0006t7/Y2uS>tG#\u0002(\u0002\u0014\u0005U\u0001\"B3\u0011\u0001\u00041\u0007\"\u00026\u0011\u0001\u0004Y\u0007F\u0001\tpQ\u0015\u0001b\u000f`A\u000eY\u0005q\u0018A\u0004;fgRL5oQ1vO\"$X\u000b\u001d\u000b\n\u001d\u0006\u0005\u00121FA\"\u0003\u000bBq!a\t\u0012\u0001\u0004\t)#A\u0005sKBd\u0017nY1JIB\u00191%a\n\n\u0007\u0005%BEA\u0002J]RDq!!\f\u0012\u0001\u0004\ty#A\u0005jg>d\u0017\r^5p]B!\u0011\u0011GA \u001b\t\t\u0019D\u0003\u0003\u00026\u0005]\u0012a\u00017pO*!\u0011\u0011HA\u001e\u0003%Ig\u000e^3s]\u0006d7OC\u0002\u0002>I\nqa\u001d;pe\u0006<W-\u0003\u0003\u0002B\u0005M\"A\u0004$fi\u000eD\u0017j]8mCRLwN\u001c\u0005\u0006KF\u0001\rA\u001a\u0005\u0006UF\u0001\ra[\u0001\u001ci\u0016\u001cH/T1zE\u0016,\u0006\u000fZ1uKJ+7\u000f]8og\u0016$\u0015\r^1)\u0005I\u0011\u0016A\u000e;fgRLen\u0019:f[\u0016tG/\u00197QCJ$\u0018\u000e^5p]\u001a+Go\u00195NKR\fG-\u0019;b\u000bF,\u0018\r\\:B]\u0012D\u0015m\u001d5D_\u0012,\u0007FA\nS\u0003m!Xm\u001d;NCf\u0014WMU3t_24X-\u00168l]><hNT1nK\"\u0012ACU\u0001\u000bi\u0016\u001cH/R9vC2\u001c\bFA\u000bS\u0003e!Xm\u001d;GKR\u001c\u0007nU3tg&|gnQ1dQ\u0016\u001c\u0016N_3)\u0005Y\u0011\u0016!J%oGJ,W.\u001a8uC2\u0004\u0016M\u001d;ji&|gNR3uG\"lU\r^1eCR\fG+Z:u!\tY\u0003d\u0005\u0002\u0019EQ\u0011\u0011QL\u000b\u0003\u0003K\u0002RaIA4\u0003WJ1!!\u001b%\u0005\u0015\t%O]1z!\r9\u0018QN\u0005\u0004\u0003_B(!C!sOVlWM\u001c;t\u0001")
public class IncrementalPartitionFetchMetadataTest {
    private final TopicPartition tp = new TopicPartition("foo", 0);
    private final Uuid topicId = Uuid.randomUuid();
    private final IncrementalPartitionFetchMetadata partition = new IncrementalPartitionFetchMetadata(this.tp().topic(), this.topicId(), this.tp().partition());
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);

    public static Arguments[] pushReplicationSupportedAndReplicationIdCombinations() {
        return IncrementalPartitionFetchMetadataTest$.MODULE$.pushReplicationSupportedAndReplicationIdCombinations();
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public IncrementalPartitionFetchMetadata partition() {
        return this.partition;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    @Test
    public void testInitialState() {
        Assertions.assertEquals((long)-1L, (long)this.partition().fetchOffset());
        Assertions.assertEquals((long)-1L, (long)this.partition().startOffset());
        Assertions.assertEquals((int)-1, (int)this.partition().maxBytes());
        Assertions.assertEquals(Optional.empty(), (Object)this.partition().currentLeaderEpoch());
        Assertions.assertEquals(Optional.empty(), (Object)this.partition().lastFetchedEpoch());
        Assertions.assertFalse((boolean)this.partition().fetchMetadataUpdated());
        Assertions.assertFalse((boolean)this.partition().isCaughtUp(this.partition().isCaughtUp$default$1()));
    }

    @Test
    public void testMaybeRegisterAsListener() {
        Mockito.when((Object)this.replicaManager().defaultPartitionListener(this.tp())).thenReturn((Object)new DefaultPartitionListener(false));
        this.partition().maybeRegisterAsListener(0, this.replicaManager());
        this.partition().maybeRegisterAsListener(0, this.replicaManager());
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager())).defaultPartitionListener(this.tp());
    }

    @Test
    public void testClose() {
        this.partition().close();
        Mockito.when((Object)this.replicaManager().defaultPartitionListener(this.tp())).thenReturn((Object)new DefaultPartitionListener(false));
        this.partition().maybeRegisterAsListener(0, this.replicaManager());
        this.partition().close();
        Assertions.assertNull((Object)this.partition().defaultPartitionListener());
        this.partition().close();
    }

    @Test
    public void testUpdateRequestParams() {
        FetchResponseData.PartitionData fetchResponse = new FetchResponseData.PartitionData();
        FetchRequestData.FetchPartition fetchPartition = new FetchRequestData.FetchPartition().setFetchOffset(-1L).setLogStartOffset(-1L).setPartitionMaxBytes(-1).setCurrentLeaderEpoch(-1).setLastFetchedEpoch(-1).setReplicationSessionId(-1L);
        this.updateAndVerify$1(fetchPartition.duplicate().setFetchOffset(20L), fetchResponse);
        this.updateAndVerify$1(fetchPartition.duplicate().setLogStartOffset(10L), fetchResponse);
        this.updateAndVerify$1(fetchPartition.duplicate().setPartitionMaxBytes(200), fetchResponse);
        this.updateAndVerify$1(fetchPartition.duplicate().setCurrentLeaderEpoch(1), fetchResponse);
        this.updateAndVerify$1(fetchPartition.duplicate().setLastFetchedEpoch(2), fetchResponse);
        this.updateAndVerify$1(fetchPartition.duplicate().setReplicationSessionId(0L), fetchResponse);
    }

    @ParameterizedTest
    @MethodSource(value={"pushReplicationSupportedAndReplicationIdCombinations"})
    public void testIsCaughtUpFollower(boolean isPushReplicationSupported, long replicationSessionId) {
        this.testIsCaughtUp(0, FetchIsolation.LOG_END, isPushReplicationSupported, replicationSessionId);
    }

    @ParameterizedTest
    @MethodSource(value={"pushReplicationSupportedAndReplicationIdCombinations"})
    public void testIsCaughtUpConsumerWithTransaction(boolean isPushReplicationSupported, long replicationSessionId) {
        this.testIsCaughtUp(-1, FetchIsolation.TXN_COMMITTED, isPushReplicationSupported, replicationSessionId);
    }

    @ParameterizedTest
    @MethodSource(value={"pushReplicationSupportedAndReplicationIdCombinations"})
    public void testIsCaughtUpConsumerWithoutTransaction(boolean isPushReplicationSupported, long replicationSessionId) {
        this.testIsCaughtUp(-1, FetchIsolation.HIGH_WATERMARK, isPushReplicationSupported, replicationSessionId);
    }

    public void testIsCaughtUp(int replicaId, FetchIsolation isolation, boolean isPushReplicationSupported, long replicationSessionId) {
        boolean fromConsumer = replicaId == -1;
        boolean pushTransitionSupported = isPushReplicationSupported && replicationSessionId > -1L && replicationSessionId != Long.MAX_VALUE;
        Assertions.assertFalse((boolean)this.partition().isCaughtUp(isolation));
        Mockito.when((Object)this.replicaManager().defaultPartitionListener(this.tp())).thenReturn((Object)new DefaultPartitionListener(isPushReplicationSupported));
        this.partition().maybeRegisterAsListener(replicaId, this.replicaManager());
        DefaultPartitionListener partitionListener = this.partition().defaultPartitionListener();
        partitionListener.onStartOffsetUpdated(this.tp(), 0L);
        partitionListener.onEndOffsetUpdated(this.tp(), 0L);
        partitionListener.onHighWatermarkUpdated(this.tp(), 0L);
        partitionListener.onLastStableOffsetUpdated(this.tp(), 0L);
        partitionListener.onIsrUpdated(this.tp(), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})));
        this.mockFetchRequestResponse$1(0L, 0L, 0L, 0L, false, replicationSessionId, isolation);
        partitionListener.onEndOffsetUpdated(this.tp(), 10L);
        partitionListener.onHighWatermarkUpdated(this.tp(), 10L);
        partitionListener.onLastStableOffsetUpdated(this.tp(), 10L);
        this.mockFetchRequestResponse$1(0L, 0L, 10L, 10L, false, replicationSessionId, isolation);
        if (!fromConsumer) {
            this.mockFetchRequestResponse$1(10L, 0L, 10L, 10L, !pushTransitionSupported, replicationSessionId, isolation);
        } else {
            this.mockFetchRequestResponse$1(10L, 0L, 10L, 10L, true, replicationSessionId, isolation);
        }
        partitionListener.onEndOffsetUpdated(this.tp(), 20L);
        if (fromConsumer) {
            this.mockFetchRequestResponse$1(10L, 0L, 10L, 10L, true, replicationSessionId, isolation);
        } else {
            this.mockFetchRequestResponse$1(10L, 0L, 10L, 10L, false, replicationSessionId, isolation);
        }
        partitionListener.onHighWatermarkUpdated(this.tp(), 20L);
        partitionListener.onLastStableOffsetUpdated(this.tp(), 20L);
        this.mockFetchRequestResponse$1(10L, 0L, 20L, 10L, false, replicationSessionId, isolation);
        if (!fromConsumer) {
            this.mockFetchRequestResponse$1(20L, 0L, 20L, 20L, !pushTransitionSupported, replicationSessionId, isolation);
        } else {
            this.mockFetchRequestResponse$1(20L, 0L, 20L, 20L, true, replicationSessionId, isolation);
        }
        partitionListener.onStartOffsetUpdated(this.tp(), 5L);
        this.mockFetchRequestResponse$1(20L, 5L, 20L, 20L, false, replicationSessionId, isolation);
        partitionListener.onIsrUpdated(this.tp(), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})));
        if (fromConsumer) {
            this.mockFetchRequestResponse$1(20L, 5L, 20L, 20L, true, replicationSessionId, isolation);
        } else {
            this.mockFetchRequestResponse$1(20L, 5L, 20L, 20L, false, replicationSessionId, isolation);
        }
        partitionListener.onIsrUpdated(this.tp(), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})));
        if (!fromConsumer) {
            this.mockFetchRequestResponse$1(20L, 5L, 20L, 20L, !pushTransitionSupported, replicationSessionId, isolation);
        } else {
            this.mockFetchRequestResponse$1(20L, 5L, 20L, 20L, true, replicationSessionId, isolation);
        }
        partitionListener.onFailed(this.tp());
        this.mockFetchRequestResponse$1(20L, 5L, 20L, 20L, false, replicationSessionId, isolation);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaybeUpdateResponseData() {
        void withRecords_timestampType;
        Assertions.assertTrue((boolean)this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(0L), true));
        Assertions.assertFalse((boolean)this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(0L), true));
        SimpleRecord[] withRecords_records = new SimpleRecord[]{new SimpleRecord(100L, null)};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var1_2 = null;
        Object var2_1 = null;
        Assertions.assertTrue((boolean)this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(0L).setRecords((BaseRecords)MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records)), true));
        Assertions.assertTrue((boolean)this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(0L).setPreferredReadReplica(10).setDivergingEpoch(new FetchResponseData.EpochEndOffset().setEpoch(-1)), true));
        Assertions.assertTrue((boolean)this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(0L).setPreferredReadReplica(-1).setDivergingEpoch(new FetchResponseData.EpochEndOffset().setEpoch(10)), true));
        Assertions.assertTrue((boolean)this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(10L), true));
        Assertions.assertTrue((boolean)this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(1L).setHighWatermark(10L), true));
        Assertions.assertTrue((boolean)this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()), true));
        Assertions.assertTrue((boolean)this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(1L).setHighWatermark(10L), true));
        this.partition().currentLeaderEpochUpdated_$eq(true);
        Assertions.assertTrue((boolean)this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(1L).setHighWatermark(10L), true));
        Assertions.assertFalse((boolean)this.partition().currentLeaderEpochUpdated());
        Assertions.assertFalse((boolean)this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(1L).setHighWatermark(10L), true));
    }

    @Test
    public void testIncrementalPartitionFetchMetadataEqualsAndHashCode() {
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic";
        int partition = 0;
        IncrementalPartitionFetchMetadata cachedPartitionWithIdAndName = new IncrementalPartitionFetchMetadata(topicName, topicId, partition);
        IncrementalPartitionFetchMetadata cachedPartitionWithIdAndNoName = new IncrementalPartitionFetchMetadata(null, topicId, partition);
        IncrementalPartitionFetchMetadata cachedPartitionWithDifferentIdAndName = new IncrementalPartitionFetchMetadata(topicName, Uuid.randomUuid(), partition);
        IncrementalPartitionFetchMetadata cachedPartitionWithZeroIdAndName = new IncrementalPartitionFetchMetadata(topicName, Uuid.ZERO_UUID, partition);
        IncrementalPartitionFetchMetadata cachedPartitionWithZeroIdAndOtherName = new IncrementalPartitionFetchMetadata("otherTopic", Uuid.ZERO_UUID, partition);
        Assertions.assertTrue((boolean)cachedPartitionWithIdAndName.elementKeysAreEqual((Object)cachedPartitionWithIdAndNoName));
        Assertions.assertEquals((int)cachedPartitionWithIdAndName.hashCode(), (int)cachedPartitionWithIdAndNoName.hashCode());
        Assertions.assertFalse((boolean)cachedPartitionWithIdAndName.elementKeysAreEqual((Object)cachedPartitionWithDifferentIdAndName));
        Assertions.assertNotEquals((int)cachedPartitionWithIdAndName.hashCode(), (int)cachedPartitionWithDifferentIdAndName.hashCode());
        Assertions.assertFalse((boolean)cachedPartitionWithIdAndName.elementKeysAreEqual((Object)cachedPartitionWithZeroIdAndName));
        Assertions.assertNotEquals((int)cachedPartitionWithIdAndName.hashCode(), (int)cachedPartitionWithZeroIdAndName.hashCode());
        Assertions.assertTrue((boolean)cachedPartitionWithIdAndNoName.elementKeysAreEqual((Object)cachedPartitionWithIdAndName));
        Assertions.assertEquals((int)cachedPartitionWithIdAndNoName.hashCode(), (int)cachedPartitionWithIdAndName.hashCode());
        Assertions.assertFalse((boolean)cachedPartitionWithIdAndNoName.elementKeysAreEqual((Object)cachedPartitionWithDifferentIdAndName));
        Assertions.assertNotEquals((int)cachedPartitionWithIdAndNoName.hashCode(), (int)cachedPartitionWithDifferentIdAndName.hashCode());
        Assertions.assertFalse((boolean)cachedPartitionWithIdAndNoName.elementKeysAreEqual((Object)cachedPartitionWithZeroIdAndName));
        Assertions.assertNotEquals((int)cachedPartitionWithIdAndNoName.hashCode(), (int)cachedPartitionWithZeroIdAndName.hashCode());
        Assertions.assertFalse((boolean)cachedPartitionWithZeroIdAndName.elementKeysAreEqual((Object)cachedPartitionWithZeroIdAndOtherName));
        Assertions.assertNotEquals((int)cachedPartitionWithZeroIdAndName.hashCode(), (int)cachedPartitionWithZeroIdAndOtherName.hashCode());
        Assertions.assertTrue((boolean)cachedPartitionWithZeroIdAndName.elementKeysAreEqual((Object)cachedPartitionWithZeroIdAndName));
        Assertions.assertEquals((int)cachedPartitionWithZeroIdAndName.hashCode(), (int)cachedPartitionWithZeroIdAndName.hashCode());
    }

    @Test
    public void testMaybeResolveUnknownName() {
        IncrementalPartitionFetchMetadata namedPartition = new IncrementalPartitionFetchMetadata("topic", Uuid.randomUuid(), 0);
        IncrementalPartitionFetchMetadata nullNamePartition1 = new IncrementalPartitionFetchMetadata(null, Uuid.randomUuid(), 0);
        IncrementalPartitionFetchMetadata nullNamePartition2 = new IncrementalPartitionFetchMetadata(null, Uuid.randomUuid(), 0);
        java.util.Map topicNames = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)namedPartition.topicId()), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nullNamePartition1.topicId()), (Object)"bar")}))).asJava();
        namedPartition.maybeResolveUnknownName(topicNames);
        Assertions.assertEquals((Object)"topic", (Object)namedPartition.topic());
        nullNamePartition1.maybeResolveUnknownName(topicNames);
        Assertions.assertEquals((Object)"bar", (Object)nullNamePartition1.topic());
        nullNamePartition2.maybeResolveUnknownName(topicNames);
        Assertions.assertEquals(null, (Object)nullNamePartition2.topic());
    }

    @Test
    public void testEquals() {
        Assertions.assertTrue((boolean)this.partition().equals((Object)this.partition()));
        Assertions.assertFalse((boolean)this.partition().equals((Object)new IncrementalPartitionFetchMetadata(this.tp().topic(), this.topicId(), this.tp().partition())));
        Assertions.assertFalse((boolean)this.partition().equals((Object)new IncrementalPartitionFetchMetadata("bar", this.topicId(), 0)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFetchSessionCacheSize() {
        FetchSessionCache cache = new FetchSessionCache(3, 1000L);
        CompletableFuture.runAsync(() -> {
            IncrementalPartitionFetchMetadataTest.createSessions$1(cache, 1, 1000);
            IncrementalPartitionFetchMetadataTest.removeSessions$1(cache, 501, 1000);
        });
        CompletableFuture.runAsync(() -> {
            IncrementalPartitionFetchMetadataTest.createSessions$1(cache, 1001, 2000);
            IncrementalPartitionFetchMetadataTest.removeSessions$1(cache, 1501, 2000);
        });
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!IncrementalPartitionFetchMetadataTest.$anonfun$testFetchSessionCacheSize$5(cache)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)IncrementalPartitionFetchMetadataTest.$anonfun$testFetchSessionCacheSize$6(cache));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)1000L, (long)cache.totalPartitions());
    }

    private final void updateAndVerify$1(FetchRequestData.FetchPartition fetchPartition, FetchResponseData.PartitionData fetchResponse$1) {
        Assertions.assertFalse((boolean)this.partition().fetchMetadataUpdated());
        Optional prevCurrentLeaderEpoch = this.partition().currentLeaderEpoch();
        this.partition().updateRequestParams(fetchPartition);
        Assertions.assertEquals((long)fetchPartition.fetchOffset(), (long)this.partition().fetchOffset());
        Assertions.assertEquals((long)fetchPartition.logStartOffset(), (long)this.partition().startOffset());
        Assertions.assertEquals((int)fetchPartition.partitionMaxBytes(), (int)this.partition().maxBytes());
        Assertions.assertEquals((int)fetchPartition.currentLeaderEpoch(), (Integer)this.partition().currentLeaderEpoch().orElse(Predef$.MODULE$.int2Integer(-1)));
        Assertions.assertEquals((int)fetchPartition.lastFetchedEpoch(), (Integer)this.partition().lastFetchedEpoch().orElse(Predef$.MODULE$.int2Integer(-1)));
        Optional optional = this.partition().currentLeaderEpoch();
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean(((optional == null ? prevCurrentLeaderEpoch != null : !((Object)optional).equals(prevCurrentLeaderEpoch)) ? 1 : 0) != 0), (Object)BoxesRunTime.boxToBoolean((boolean)this.partition().currentLeaderEpochUpdated()));
        Assertions.assertEquals((long)fetchPartition.replicationSessionId(), (long)this.partition().replicationSessionId());
        Assertions.assertTrue((boolean)this.partition().fetchMetadataUpdated());
        this.partition().maybeUpdateResponseData(fetchResponse$1, true);
        Assertions.assertFalse((boolean)this.partition().fetchMetadataUpdated());
        Assertions.assertFalse((boolean)this.partition().currentLeaderEpochUpdated());
    }

    private final void mockFetchRequestResponse$1(long fetchOffset, long logStartOffset, long highWatermark, long lastStableOffset, boolean isCaughtUpResult, long replicationSessionId$1, FetchIsolation isolation$1) {
        this.partition().updateRequestParams(new FetchRequestData.FetchPartition().setFetchOffset(fetchOffset).setLogStartOffset(logStartOffset).setReplicationSessionId(replicationSessionId$1));
        if (isCaughtUpResult) {
            Assertions.assertTrue((boolean)this.partition().isCaughtUp(isolation$1));
        } else {
            Assertions.assertFalse((boolean)this.partition().isCaughtUp(isolation$1));
        }
        this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(logStartOffset).setHighWatermark(highWatermark).setLastStableOffset(lastStableOffset), true);
    }

    private static final FetchSession newSession$1(int id) {
        ImplicitLinkedHashCollection partitionMap = new ImplicitLinkedHashCollection();
        partitionMap.add((ImplicitLinkedHashCollection.Element)new IncrementalPartitionFetchMetadata("topic", Uuid.randomUuid(), 0));
        return new FetchSession(id, false, partitionMap, true, 0L, 0L, 0);
    }

    private static final void createSessions$1(FetchSessionCache cache, int start, int finish) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(start), finish).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> cache.touch(IncrementalPartitionFetchMetadataTest.newSession$1(i), 0L));
    }

    private static final void removeSessions$1(FetchSessionCache cache, int start, int finish) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(start), finish).foreach((Function1 & Serializable)i -> cache.remove((FetchSession)cache.get(BoxesRunTime.unboxToInt((Object)i)).get()));
    }

    public static final /* synthetic */ boolean $anonfun$testFetchSessionCacheSize$5(FetchSessionCache cache$5) {
        return cache$5.size() == 1000;
    }

    public static final /* synthetic */ String $anonfun$testFetchSessionCacheSize$6(FetchSessionCache cache$5) {
        return new StringBuilder(66).append("cache size should match the number of new sessions. current size: ").append(cache$5.size()).toString();
    }
}

