/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.concurrent.atomic.AtomicBoolean;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.server.KafkaServer$;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.InitiateShutdownRequest;
import org.apache.kafka.common.requests.InitiateShutdownResponse;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.$less$colon$less$;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\u0005%b\u0001B\t\u0013\u0001]AQ\u0001\b\u0001\u0005\u0002uAqa\b\u0001C\u0002\u0013\u0005\u0003\u0005\u0003\u0004(\u0001\u0001\u0006I!\t\u0005\nQ\u0001\u0001\r\u00111A\u0005\u0002%B\u0011\"\f\u0001A\u0002\u0003\u0007I\u0011\u0001\u0018\t\u0013Q\u0002\u0001\u0019!A!B\u0013Q\u0003\"C\u001b\u0001\u0001\u0004\u0005\r\u0011\"\u00017\u0011%Q\u0004\u00011AA\u0002\u0013\u00051\bC\u0005>\u0001\u0001\u0007\t\u0011)Q\u0005o!9a\b\u0001b\u0001\n\u0003y\u0004B\u0002'\u0001A\u0003%\u0001\tC\u0003N\u0001\u0011\u0005c\nC\u0003b\u0001\u0011\u0005#\rC\u0003h\u0001\u0011\u0005\u0001\u000eC\u0004\u0002\u001c\u0001!\t!!\b\t\r\u0005\u001d\u0002\u0001\"\u00017\u0005\u0019Je.\u001b;jCR,7\u000b[;uI><hNU3rk\u0016\u001cH/\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003'Q\taa]3sm\u0016\u0014(\"A\u000b\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0007\t\u00033ii\u0011AE\u0005\u00037I\u0011qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\u0001\"!\u0007\u0001\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u000b\u0002CA\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t\u0019\u0011J\u001c;\u0002\u0019\t\u0014xn[3s\u0007>,h\u000e\u001e\u0011\u0002\r\t\u0014xn[3s+\u0005Q\u0003CA\r,\u0013\ta#CA\u0006LC\u001a\\\u0017M\u0011:pW\u0016\u0014\u0018A\u00032s_.,'o\u0018\u0013fcR\u0011qF\r\t\u0003EAJ!!M\u0012\u0003\tUs\u0017\u000e\u001e\u0005\bg\u0015\t\t\u00111\u0001+\u0003\rAH%M\u0001\bEJ|7.\u001a:!\u0003-\u0011'o\\6fe\u0016\u0003xn\u00195\u0016\u0003]\u0002\"A\t\u001d\n\u0005e\u001a#\u0001\u0002'p]\u001e\fqB\u0019:pW\u0016\u0014X\t]8dQ~#S-\u001d\u000b\u0003_qBqa\r\u0005\u0002\u0002\u0003\u0007q'\u0001\u0007ce>\\WM]#q_\u000eD\u0007%\u0001\u0004fq&$X\rZ\u000b\u0002\u0001B\u0011\u0011IS\u0007\u0002\u0005*\u00111\tR\u0001\u0007CR|W.[2\u000b\u0005\u00153\u0015AC2p]\u000e,(O]3oi*\u0011q\tS\u0001\u0005kRLGNC\u0001J\u0003\u0011Q\u0017M^1\n\u0005-\u0013%!D!u_6L7MQ8pY\u0016\fg.A\u0004fq&$X\r\u001a\u0011\u0002\u000bM,G/\u00169\u0015\u0005=z\u0005\"\u0002)\r\u0001\u0004\t\u0016\u0001\u0003;fgRLeNZ8\u0011\u0005I[V\"A*\u000b\u0005Q+\u0016aA1qS*\u0011akV\u0001\bUV\u0004\u0018\u000e^3s\u0015\tA\u0016,A\u0003kk:LGOC\u0001[\u0003\ry'oZ\u0005\u00039N\u0013\u0001\u0002V3ti&sgm\u001c\u0015\u0003\u0019y\u0003\"AU0\n\u0005\u0001\u001c&A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eF\u00010Q\tiA\r\u0005\u0002SK&\u0011am\u0015\u0002\n\u0003\u001a$XM]#bG\"\f1\u0004^3ti&s\u0017\u000e^5bi\u0016\u001c\u0006.\u001e;e_^t'+Z9vKN$HCA\u0018j\u0011\u0015Qg\u00021\u0001l\u0003\u0019\tXo\u001c:v[B\u0011An\u001d\b\u0003[F\u0004\"A\\\u0012\u000e\u0003=T!\u0001\u001d\f\u0002\rq\u0012xn\u001c;?\u0013\t\u00118%\u0001\u0004Qe\u0016$WMZ\u0005\u0003iV\u0014aa\u0015;sS:<'B\u0001:$Q\u0011qq/ @\u0011\u0005a\\X\"A=\u000b\u0005i,\u0016A\u00029be\u0006l7/\u0003\u0002}s\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u0002\u007f\u0006\u00113\u0010Z5ta2\f\u0017PT1nKvt30\u0019:hk6,g\u000e^:XSRDg*Y7fgvDsADA\u0002\u0003\u001f\t\t\u0002\u0005\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tI!_\u0001\taJ|g/\u001b3fe&!\u0011QBA\u0004\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\"\u00111CA\fC\t\t)\"\u0001\u0002{W\u0006\u0012\u0011\u0011D\u0001\u0006WJ\fg\r^\u0001Pi\u0016\u001cH/\u00138ji&\fG/Z*ikR$wn\u001e8SKF,Xm\u001d;SKR,(O\\:Ti\u0006dWM\u0011:pW\u0016\u0014X\t]8dQ\u0016C8-\u001a9uS>t\u0017J\u001a\"s_.,'/\u00129pG\"L5o\u0015;bY\u0016$2aLA\u0010\u0011\u0015Qw\u00021\u0001lQ\u0011yq/ @)\u000f=\t\u0019!a\u0004\u0002&1\"\u00111CA\f\u0003A\u0019H/\u00197f\u0005J|7.\u001a:Fa>\u001c\u0007\u000e")
public class InitiateShutdownRequestIntegrationTest
extends BaseRequestTest {
    private final int brokerCount;
    private KafkaBroker broker;
    private long brokerEpoch;
    private final AtomicBoolean exited = new AtomicBoolean(false);

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    public KafkaBroker broker() {
        return this.broker;
    }

    public void broker_$eq(KafkaBroker x$1) {
        this.broker = x$1;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    public void brokerEpoch_$eq(long x$1) {
        this.brokerEpoch = x$1;
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        Exit.setExitProcedure((x$3, x$4) -> {
            this.exited().set(true);
            throw new Exception();
        });
        this.broker_$eq((KafkaBroker)this.brokers().head());
        this.brokerEpoch_$eq(this.broker().brokerEpoch());
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        Exit.resetExitProcedure();
        KafkaServer$.MODULE$.externalShutdownInitiations().set(0L);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testInitiateShutdownRequest(String quorum) {
        InitiateShutdownRequest shutdownReq = (InitiateShutdownRequest)new InitiateShutdownRequest.Builder(this.brokerEpoch()).build();
        InitiateShutdownResponse shutdownResponse = (InitiateShutdownResponse)this.connectAndReceive((AbstractRequest)shutdownReq, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(InitiateShutdownResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shutdownResponse.data().errorCode());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!InitiateShutdownRequestIntegrationTest.$anonfun$testInitiateShutdownRequest$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Shutdown should have been initiated");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testInitiateShutdownRequestReturnsStaleBrokerEpochExceptionIfBrokerEpochIsStale(String quorum) {
        InitiateShutdownRequest shutdownReq = (InitiateShutdownRequest)new InitiateShutdownRequest.Builder(this.staleBrokerEpoch()).build();
        InitiateShutdownResponse shutdownResponse = (InitiateShutdownResponse)this.connectAndReceive((AbstractRequest)shutdownReq, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(InitiateShutdownResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((short)Errors.STALE_BROKER_EPOCH.code(), (short)shutdownResponse.data().errorCode());
        Assertions.assertFalse((boolean)this.exited().get(), (String)"Shutdown should not have been initiated");
    }

    public long staleBrokerEpoch() {
        long staleEpoch = this.brokerEpoch() - 1L;
        if (staleEpoch == -1L) {
            return staleEpoch - 1L;
        }
        return staleEpoch;
    }

    public static final /* synthetic */ boolean $anonfun$testInitiateShutdownRequest$1(InitiateShutdownRequestIntegrationTest $this) {
        return $this.exited().get();
    }

    public static final /* synthetic */ String $anonfun$testInitiateShutdownRequest$2() {
        return "Shutdown should have been initiated";
    }

    public InitiateShutdownRequestIntegrationTest() {
        this.brokerCount = 1;
    }
}

