/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.ActionQueue;
import kafka.server.AlterPartitionManager;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedActionQueue;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.TierReplicaComponents;
import kafka.server.TierReplicaComponents$;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.admin.BrokerMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.DirectoryEventHandler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.verification.VerificationMode;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00055h\u0001B\u0015+\u0001=BQA\u000e\u0001\u0005\u0002]BqA\u000f\u0001C\u0002\u0013\u00051\b\u0003\u0004@\u0001\u0001\u0006I\u0001\u0010\u0005\b\u0001\u0002\u0011\r\u0011\"\u0001B\u0011\u0019)\u0005\u0001)A\u0005\u0005\"9a\t\u0001b\u0001\n\u0003Y\u0004BB$\u0001A\u0003%A\bC\u0004I\u0001\u0001\u0007I\u0011A\u001e\t\u000f%\u0003\u0001\u0019!C\u0001\u0015\"1\u0001\u000b\u0001Q!\nqBq!\u0015\u0001C\u0002\u0013\u00051\b\u0003\u0004S\u0001\u0001\u0006I\u0001\u0010\u0005\b'\u0002\u0011\r\u0011\"\u0001U\u0011\u0019i\u0006\u0001)A\u0005+\"9a\f\u0001b\u0001\n\u0003y\u0006BB5\u0001A\u0003%\u0001\rC\u0004k\u0001\t\u0007I\u0011A6\t\rI\u0004\u0001\u0015!\u0003m\u0011\u001d\u0019\bA1A\u0005\u0002QDq!!\u0001\u0001A\u0003%Q\u000fC\u0005\u0002\u0004\u0001\u0011\r\u0011\"\u0001\u0002\u0006!A\u0011Q\u0003\u0001!\u0002\u0013\t9\u0001C\u0006\u0002\u0018\u0001\u0001\r\u00111A\u0005\u0002\u0005e\u0001bCA\u001c\u0001\u0001\u0007\t\u0019!C\u0001\u0003sA1\"!\u0010\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u001c!Y\u0011q\b\u0001A\u0002\u0003\u0007I\u0011AA!\u0011-\tI\u0005\u0001a\u0001\u0002\u0004%\t!a\u0013\t\u0017\u0005=\u0003\u00011A\u0001B\u0003&\u00111\t\u0005\f\u0003#\u0002\u0001\u0019!a\u0001\n\u0003\t\u0019\u0006C\u0006\u0002l\u0001\u0001\r\u00111A\u0005\u0002\u00055\u0004bCA9\u0001\u0001\u0007\t\u0011)Q\u0005\u0003+Bq!a\u001d\u0001\t\u0003\t)\bC\u0004\u0002\u000e\u0002!\t!!\u001e\t\u000f\u0005]\u0005\u0001\"\u0001\u0002v!9\u0011\u0011\u0015\u0001\u0005\u0002\u0005U\u0004bBAS\u0001\u0011\u0005\u0011Q\u000f\u0005\b\u0003S\u0003A\u0011AA;\u0011\u001d\ti\u000b\u0001C\u0001\u0003kBq!!-\u0001\t\u0013\t\u0019\fC\u0004\u0002j\u0002!I!a;\u0003#%\u001b(/\u0012=qSJ\fG/[8o)\u0016\u001cHO\u0003\u0002,Y\u000511/\u001a:wKJT\u0011!L\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0007\u0005\u00022i5\t!GC\u00014\u0003\u0015\u00198-\u00197b\u0013\t)$G\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003a\u0002\"!\u000f\u0001\u000e\u0003)\n1CU3qY&\u001c\u0017\rT1h)&lW-T1y\u001bN,\u0012\u0001\u0010\t\u0003cuJ!A\u0010\u001a\u0003\t1{gnZ\u0001\u0015%\u0016\u0004H.[2b\u0019\u0006<G+[7f\u001b\u0006DXj\u001d\u0011\u0002+I+\u0007\u000f\\5dC\u001a+Go\u00195XC&$X*\u0019=NgV\t!\t\u0005\u00022\u0007&\u0011AI\r\u0002\u0004\u0013:$\u0018A\u0006*fa2L7-\u0019$fi\u000eDw+Y5u\u001b\u0006DXj\u001d\u0011\u0002)1+\u0017\rZ3s\u0019><7\u000b^1si>3gm]3u\u0003UaU-\u00193fe2{wm\u0015;beR|eMZ:fi\u0002\n!\u0003T3bI\u0016\u0014Hj\\4F]\u0012|eMZ:fi\u00061B*Z1eKJdunZ#oI>3gm]3u?\u0012*\u0017\u000f\u0006\u0002L\u001dB\u0011\u0011\u0007T\u0005\u0003\u001bJ\u0012A!\u00168ji\"9q*CA\u0001\u0002\u0004a\u0014a\u0001=%c\u0005\u0019B*Z1eKJdunZ#oI>3gm]3uA\u00051B*Z1eKJdun\u001a%jO\"<\u0016\r^3s[\u0006\u00148.A\fMK\u0006$WM\u001d'pO\"Kw\r[,bi\u0016\u0014X.\u0019:lA\u0005yqN^3se&$\u0017N\\4Qe>\u00048/F\u0001V!\t16,D\u0001X\u0015\tA\u0016,\u0001\u0003vi&d'\"\u0001.\u0002\t)\fg/Y\u0005\u00039^\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0003Ayg/\u001a:sS\u0012Lgn\u001a)s_B\u001c\b%A\u0004d_:4\u0017nZ:\u0016\u0003\u0001\u00042!\u00193g\u001b\u0005\u0011'BA23\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003K\n\u00141aU3r!\tIt-\u0003\u0002iU\tY1*\u00194lC\u000e{gNZ5h\u0003!\u0019wN\u001c4jON\u0004\u0013!\u0002;pa&\u001cW#\u00017\u0011\u00055\u0004X\"\u00018\u000b\u0005=L\u0016\u0001\u00027b]\u001eL!!\u001d8\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005!A/[7f+\u0005)\bC\u0001<\u007f\u001b\u00059(B\u0001-y\u0015\tY\u0013P\u0003\u0002.u*\u00111\u0010`\u0001\u0007CB\f7\r[3\u000b\u0003u\f1a\u001c:h\u0013\tyxO\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003\u001diW\r\u001e:jGN,\"!a\u0002\u0011\t\u0005%\u0011\u0011C\u0007\u0003\u0003\u0017QA!a\u0001\u0002\u000e)\u0019\u0011qB=\u0002\r\r|W.\\8o\u0013\u0011\t\u0019\"a\u0003\u0003\u000f5+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%\u0001\u0007rk>$\u0018-T1oC\u001e,'/\u0006\u0002\u0002\u001cA!\u0011QDA\u0019\u001d\u0011\ty\"!\f\u000f\t\u0005\u0005\u00121\u0006\b\u0005\u0003G\tI#\u0004\u0002\u0002&)\u0019\u0011q\u0005\u0018\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0013BA\u0016-\u0013\r\tyCK\u0001\r#V|G/\u0019$bGR|'/_\u0005\u0005\u0003g\t)DA\u0007Rk>$\u0018-T1oC\u001e,'o\u001d\u0006\u0004\u0003_Q\u0013\u0001E9v_R\fW*\u00198bO\u0016\u0014x\fJ3r)\rY\u00151\b\u0005\t\u001fb\t\t\u00111\u0001\u0002\u001c\u0005i\u0011/^8uC6\u000bg.Y4fe\u0002\naB]3qY&\u001c\u0017-T1oC\u001e,'/\u0006\u0002\u0002DA\u0019\u0011(!\u0012\n\u0007\u0005\u001d#F\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002%I,\u0007\u000f\\5dC6\u000bg.Y4fe~#S-\u001d\u000b\u0004\u0017\u00065\u0003\u0002C(\u001c\u0003\u0003\u0005\r!a\u0011\u0002\u001fI,\u0007\u000f\\5dC6\u000bg.Y4fe\u0002\nq\"\u00197uKJL5O]'b]\u0006<WM]\u000b\u0003\u0003+\u0002B!a\u0016\u0002f9!\u0011\u0011LA0\u001d\u0011\t\t#a\u0017\n\u0007\u0005uC&A\u0003vi&d7/\u0003\u0003\u0002b\u0005\r\u0014!\u0003+fgR,F/\u001b7t\u0015\r\ti\u0006L\u0005\u0005\u0003O\nIGA\rN_\u000e\\\u0017\t\u001c;feB\u000b'\u000f^5uS>tW*\u00198bO\u0016\u0014(\u0002BA1\u0003G\n1#\u00197uKJL5O]'b]\u0006<WM]0%KF$2aSA8\u0011!ye$!AA\u0002\u0005U\u0013\u0001E1mi\u0016\u0014\u0018j\u001d:NC:\fw-\u001a:!\u0003\u0015\u0019X\r^+q)\u0005Y\u0005f\u0001\u0011\u0002zA!\u00111PAE\u001b\t\tiH\u0003\u0003\u0002\u0000\u0005\u0005\u0015aA1qS*!\u00111QAC\u0003\u001dQW\u000f]5uKJT1!a\"}\u0003\u0015QWO\\5u\u0013\u0011\tY)! \u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\r\t\u0013\u0011\u0013\t\u0005\u0003w\n\u0019*\u0003\u0003\u0002\u0016\u0006u$!C!gi\u0016\u0014X)Y2i\u0003\t\"Xm\u001d;JgJ,\u0005\u0010]5sCRLwN\u001c$peN#XoY6G_2dwn^3sg\"\u001a!%a'\u0011\t\u0005m\u0014QT\u0005\u0005\u0003?\u000biH\u0001\u0003UKN$\u0018!\n;fgRL5O]#ya&\u0014\u0018\r^5p]&3gj\u001c$fi\u000eD'+Z9vKN$X*\u00193fQ\r\u0019\u00131T\u0001\"i\u0016\u001cH/S:s\u000bb\u0004\u0018N]1uS>tgi\u001c:TY><hi\u001c7m_^,'o\u001d\u0015\u0004I\u0005m\u0015!\n;fgRL5O]#ya&\u0014\u0018\r^5p]\u001a{'oQ1vO\"$X\u000b\u001d$pY2|w/\u001a:tQ\r)\u00131T\u0001<i\u0016\u001cH/S:s\u000bb\u0004\u0018N]1uS>tgi\u001c:DCV<\u0007\u000e^+q\r>dGn\\<feN<\u0006.\u001a8MK\u0006$WM]!qa\u0016tGm\u001d+p\u0019><\u0007f\u0001\u0014\u0002\u001c\u0006\u0001s-\u001a;QCJ$\u0018\u000e^5p]^KG\u000f[!mYJ+\u0007\u000f\\5dCNLe.S:s))\t),!1\u0002R\u0006U\u0017\u0011\u001c\t\u0005\u0003o\u000bi,\u0004\u0002\u0002:*\u0019\u00111\u0018\u0017\u0002\u000f\rdWo\u001d;fe&!\u0011qXA]\u0005%\u0001\u0016M\u001d;ji&|g\u000e\u0003\u0004kO\u0001\u0007\u00111\u0019\t\u0005\u0003\u000b\fiM\u0004\u0003\u0002H\u0006%\u0007cAA\u0012e%\u0019\u00111\u001a\u001a\u0002\rA\u0013X\rZ3g\u0013\r\t\u0018q\u001a\u0006\u0004\u0003\u0017\u0014\u0004BBAjO\u0001\u0007!)A\u0006qCJ$\u0018\u000e^5p]&#\u0007BBAlO\u0001\u0007a-\u0001\u0004d_:4\u0017n\u001a\u0005\b\u00037<\u0003\u0019AAo\u0003!awnY1m\u0019><\u0007\u0003BAp\u0003Kl!!!9\u000b\u0007\u0005\rH&A\u0002m_\u001eLA!a:\u0002b\nY\u0011IY:ue\u0006\u001cG\u000fT8h\u0003\u001dawnZ'pG.,\"!!8")
public class IsrExpirationTest {
    private final long ReplicaLagTimeMaxMs;
    private final int ReplicaFetchWaitMaxMs;
    private final long LeaderLogStartOffset;
    private long LeaderLogEndOffset = 20L;
    private final long LeaderLogHighWatermark;
    private final Properties overridingProps = new Properties();
    private final Seq<KafkaConfig> configs;
    private final String topic;
    private final MockTime time;
    private final Metrics metrics;
    private QuotaFactory.QuotaManagers quotaManager;
    private ReplicaManager replicaManager;
    private TestUtils.MockAlterPartitionManager alterIsrManager;

    public long ReplicaLagTimeMaxMs() {
        return this.ReplicaLagTimeMaxMs;
    }

    public int ReplicaFetchWaitMaxMs() {
        return this.ReplicaFetchWaitMaxMs;
    }

    public long LeaderLogStartOffset() {
        return this.LeaderLogStartOffset;
    }

    public long LeaderLogEndOffset() {
        return this.LeaderLogEndOffset;
    }

    public void LeaderLogEndOffset_$eq(long x$1) {
        this.LeaderLogEndOffset = x$1;
    }

    public long LeaderLogHighWatermark() {
        return this.LeaderLogHighWatermark;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public String topic() {
        return this.topic;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public QuotaFactory.QuotaManagers quotaManager() {
        return this.quotaManager;
    }

    public void quotaManager_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManager = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public TestUtils.MockAlterPartitionManager alterIsrManager() {
        return this.alterIsrManager;
    }

    public void alterIsrManager_$eq(TestUtils.MockAlterPartitionManager x$1) {
        this.alterIsrManager = x$1;
    }

    @BeforeEach
    public void setUp() {
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)logManager.liveLogDirs()).thenReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class))));
        MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        Seq aliveBrokers = (Seq)this.configs().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.brokerId()));
        Mockito.when((Object)metadataCache.getAliveBrokers()).thenReturn(aliveBrokers.map((Function1 & Serializable)id -> IsrExpirationTest.$anonfun$setUp$2(BoxesRunTime.unboxToInt((Object)id))));
        Mockito.when((Object)metadataCache.getBrokerTags(BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()))).thenReturn((Object)Predef$.MODULE$.Map().empty());
        aliveBrokers.foreach((Function1 & Serializable)id -> IsrExpirationTest.$anonfun$setUp$3(metadataCache, BoxesRunTime.unboxToInt((Object)id)));
        this.alterIsrManager_$eq(new TestUtils.MockAlterPartitionManager());
        this.quotaManager_$eq(QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$));
        Metrics x$1 = this.metrics();
        KafkaConfig x$2 = (KafkaConfig)this.configs().head();
        MockTime x$3 = this.time();
        QuotaFactory.QuotaManagers x$6 = this.quotaManager();
        LogDirFailureChannel x$8 = new LogDirFailureChannel(((KafkaConfig)this.configs().head()).logDirs().size());
        TestUtils.MockAlterPartitionManager x$9 = this.alterIsrManager();
        DelayedActionQueue x$10 = new DelayedActionQueue();
        BrokerTopicStats x$11 = new BrokerTopicStats();
        Function0 x$12 = ReplicaManager$.MODULE$.$lessinit$greater$default$12();
        None$ x$13 = None$.MODULE$;
        None$ x$14 = None$.MODULE$;
        None$ x$15 = None$.MODULE$;
        None$ x$16 = None$.MODULE$;
        None$ x$17 = None$.MODULE$;
        None$ x$18 = None$.MODULE$;
        TierReplicaComponents x$19 = TierReplicaComponents$.MODULE$.EMPTY();
        None$ x$20 = None$.MODULE$;
        None$ x$21 = None$.MODULE$;
        None$ x$22 = None$.MODULE$;
        Function0 x$23 = ReplicaManager$.MODULE$.$lessinit$greater$default$23();
        None$ x$24 = None$.MODULE$;
        DirectoryEventHandler x$25 = DirectoryEventHandler.NOOP;
        this.replicaManager_$eq(new ReplicaManager(x$2, x$1, (Time)x$3, null, logManager, x$6, metadataCache, x$8, (AlterPartitionManager)x$9, (ActionQueue)x$10, x$11, x$12, (Option)x$13, (Option)x$14, (Option)x$15, (Option)x$16, (Option)x$17, (Option)x$18, x$19, (Option)x$20, (Option)x$21, (Option)x$22, x$23, (Option)x$24, x$25));
    }

    @AfterEach
    public void tearDown() {
        Option$.MODULE$.apply((Object)this.replicaManager()).foreach((Function1 & Serializable)x$6 -> {
            x$6.shutdown(false);
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply((Object)this.quotaManager()).foreach((Function1 & Serializable)x$7 -> {
            x$7.shutdown();
            return BoxedUnit.UNIT;
        });
        this.metrics().close();
    }

    @Test
    public void testIsrExpirationForStuckFollowers() {
        AbstractLog log = this.logMock();
        Partition partition = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (KafkaConfig)this.configs().head(), log);
        Assertions.assertEquals((Object)((IterableOnceOps)this.configs().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.brokerId()))).toSet(), (Object)partition.inSyncReplicaIds(), (String)"All replicas should be in ISR");
        partition.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.updateFetchStateOrThrow(new LogOffsetMetadata(this.LeaderLogEndOffset() - 1L), 0L, this.time().milliseconds(), this.LeaderLogEndOffset(), 1L, -1L);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"No replica should be out of sync");
        this.time().sleep(this.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"Replica 1 should be out of sync");
        ((AbstractLog)Mockito.verify((Object)log, (VerificationMode)Mockito.atLeastOnce())).logEndOffset();
    }

    @Test
    public void testIsrExpirationIfNoFetchRequestMade() {
        AbstractLog log = this.logMock();
        Partition partition = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (KafkaConfig)this.configs().head(), log);
        Assertions.assertEquals((Object)((IterableOnceOps)this.configs().map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.brokerId()))).toSet(), (Object)partition.inSyncReplicaIds(), (String)"All replicas should be in ISR");
        this.time().sleep(this.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"Replica 1 should be out of sync");
        ((AbstractLog)Mockito.verify((Object)log, (VerificationMode)Mockito.atLeastOnce())).logEndOffset();
    }

    @Test
    public void testIsrExpirationForSlowFollowers() {
        AbstractLog log = this.logMock();
        Partition partition = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (KafkaConfig)this.configs().head(), log);
        Assertions.assertEquals((Object)((IterableOnceOps)this.configs().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.brokerId()))).toSet(), (Object)partition.inSyncReplicaIds(), (String)"All replicas should be in ISR");
        partition.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.updateFetchStateOrThrow(new LogOffsetMetadata(this.LeaderLogEndOffset() - 2L), 0L, this.time().milliseconds(), this.LeaderLogEndOffset(), 1L, -1L);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"No replica should be out of sync");
        this.time().sleep(75L);
        partition.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.updateFetchStateOrThrow(new LogOffsetMetadata(this.LeaderLogEndOffset() - 1L), 0L, this.time().milliseconds(), this.LeaderLogEndOffset(), 1L, -1L);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"No replica should be out of sync");
        this.time().sleep(75L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"Replica 1 should be out of sync");
        partition.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.updateFetchStateOrThrow(new LogOffsetMetadata(this.LeaderLogEndOffset()), 0L, this.time().milliseconds(), this.LeaderLogEndOffset(), 1L, -1L);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"No replica should be out of sync");
        ((AbstractLog)Mockito.verify((Object)log, (VerificationMode)Mockito.atLeastOnce())).logEndOffset();
    }

    @Test
    public void testIsrExpirationForCaughtUpFollowers() {
        AbstractLog log = this.logMock();
        Partition partition = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (KafkaConfig)this.configs().head(), log);
        Assertions.assertEquals((Object)((IterableOnceOps)this.configs().map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.brokerId()))).toSet(), (Object)partition.inSyncReplicaIds(), (String)"All replicas should be in ISR");
        partition.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.updateFetchStateOrThrow(new LogOffsetMetadata(this.LeaderLogEndOffset()), 0L, this.time().milliseconds(), this.LeaderLogEndOffset(), 1L, -1L);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"No replica should be out of sync");
        this.time().sleep(this.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"No replica should be out of sync");
        ((AbstractLog)Mockito.verify((Object)log, (VerificationMode)Mockito.atLeastOnce())).logEndOffset();
    }

    @Test
    public void testIsrExpirationForCaughtUpFollowersWhenLeaderAppendsToLog() {
        AbstractLog log = this.logMock();
        Partition partition = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (KafkaConfig)this.configs().head(), log);
        Assertions.assertEquals((Object)((IterableOnceOps)this.configs().map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.brokerId()))).toSet(), (Object)partition.inSyncReplicaIds(), (String)"All replicas should be in ISR");
        partition.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.updateFetchStateOrThrow(new LogOffsetMetadata(this.LeaderLogEndOffset()), 0L, this.time().milliseconds(), this.LeaderLogEndOffset(), 1L, -1L);
            return BoxedUnit.UNIT;
        });
        this.time().sleep(this.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"No replica should be out of sync");
        this.LeaderLogEndOffset_$eq(this.LeaderLogEndOffset() + 1L);
        partition.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.maybeResetLastCaughtUpTime(this.time().milliseconds(), this.LeaderLogEndOffset());
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"No replica should be out of sync");
        this.time().sleep(this.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"Replica 1 should be out of sync");
        ((AbstractLog)Mockito.verify((Object)log, (VerificationMode)Mockito.atLeastOnce())).logEndOffset();
    }

    private Partition getPartitionWithAllReplicasInIsr(String topic, int partitionId, KafkaConfig config, AbstractLog localLog) {
        int leaderId = config.brokerId();
        TopicPartition tp = new TopicPartition(topic, partitionId);
        Partition partition = this.replicaManager().createPartition(tp);
        partition.setLog(localLog, false);
        OffsetCheckpoints highWatermarkCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
        partition.makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setPartitionIndex(partitionId).setLeader(leaderId).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)((IterableOps)this.configs().map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.brokerId()))).map((Function1 & Serializable)x -> IsrExpirationTest.$anonfun$getPartitionWithAllReplicasInIsr$2(BoxesRunTime.unboxToInt((Object)x)))).toList()).asJava()).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)((IterableOps)this.configs().map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.brokerId()))).map((Function1 & Serializable)x -> IsrExpirationTest.$anonfun$getPartitionWithAllReplicasInIsr$4(BoxesRunTime.unboxToInt((Object)x)))).toList()).asJava()), highWatermarkCheckpoints, (Option)None$.MODULE$, partition.makeLeader$default$4());
        partition.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.updateFetchStateOrThrow(new LogOffsetMetadata(0L), 0L, this.time().milliseconds(), 0L, 1L, -1L);
            return BoxedUnit.UNIT;
        });
        partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)leaderId)));
        return partition;
    }

    private AbstractLog logMock() {
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        LogConfig logConfig = new LogConfig((java.util.Map)new Properties());
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenAnswer(x$15 -> BoxesRunTime.boxToLong((long)this.LeaderLogEndOffset()));
        Mockito.when((Object)log.maybeIncrementHighWatermark((LogOffsetMetadata)ArgumentMatchers.any())).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)this.LeaderLogStartOffset()));
        Mockito.when((Object)log.logEndOffsetMetadata()).thenAnswer(x$16 -> new LogOffsetMetadata(this.LeaderLogEndOffset()));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)this.LeaderLogHighWatermark()));
        Mockito.when((Object)log.config()).thenReturn((Object)logConfig);
        Mockito.when((Object)log.topicId()).thenReturn((Object)None$.MODULE$);
        return log;
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$setUp$2(int id) {
        return new BrokerMetadata(id, Optional.empty());
    }

    public static final /* synthetic */ OngoingStubbing $anonfun$setUp$3(MetadataCache metadataCache$1, int id) {
        return Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)metadataCache$1.hasAliveBroker(id))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public static final /* synthetic */ Integer $anonfun$getPartitionWithAllReplicasInIsr$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$getPartitionWithAllReplicasInIsr$4(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public IsrExpirationTest() {
        this.ReplicaLagTimeMaxMs = 100L;
        this.ReplicaFetchWaitMaxMs = 100;
        this.LeaderLogStartOffset = 0L;
        this.LeaderLogHighWatermark = 20L;
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), Long.toString(this.ReplicaLagTimeMaxMs()));
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), Integer.toString(this.ReplicaFetchWaitMaxMs()));
        this.configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
        this.topic = "foo";
        this.time = new MockTime();
        this.metrics = new Metrics();
    }
}

