/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.rest.BeginShutdownControllerStatus;
import io.confluent.rest.CheckReadyControllerStatus;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.cluster.EndPoint;
import kafka.log.AbstractLog;
import kafka.log.LocalLog$;
import kafka.log.LogManager;
import kafka.network.SocketServer;
import kafka.server.BadAuthorizer;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.DummyClientQuotaCallback;
import kafka.server.DummyClientQuotaCallback$;
import kafka.server.FakeConfigurableAuthorizer;
import kafka.server.FakeConfigurableAuthorizer$;
import kafka.server.HostedPartition;
import kafka.server.IntegrationTestUtils$;
import kafka.server.KRaftClusterTestCreateTopicPolicy;
import kafka.server.KRaftClusterTestTopicReplicaAssignor;
import kafka.server.KRaftClusterTestTopicReplicaAssignor$;
import kafka.server.KRaftClusterTestTopicReplicaAssignorBuilder;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.testkit.BrokerNode;
import kafka.testkit.KafkaClusterTestKit;
import kafka.testkit.TestKitNodes;
import kafka.utils.Logging;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.commons.io.FileUtils;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeMetadataQuorumOptions;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.QuorumInfo;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.UpdateFeaturesOptions;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.DescribeClusterRequestData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.kafka.common.quota.ClientQuotaFilterComponent;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeClusterRequest;
import org.apache.kafka.common.requests.DescribeClusterResponse;
import org.apache.kafka.controller.QuorumController;
import org.apache.kafka.controller.QuorumControllerIntegrationTestUtils;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.BrokerState;
import org.apache.kafka.metadata.MetadataEncryptorFactoryTest;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@Timeout(value=120L)
@Tags(value={@Tag(value="integration"), @Tag(value="bazel:shard_count:4")})
@ScalaSignature(bytes="\u0006\u0005\u0011]b\u0001\u0002\"D\u0001!CQa\u0014\u0001\u0005\u0002ACqa\u0015\u0001C\u0002\u0013\u0005A\u000b\u0003\u0004^\u0001\u0001\u0006I!\u0016\u0005\b=\u0002\u0011\r\u0011\"\u0001U\u0011\u0019y\u0006\u0001)A\u0005+\")\u0001\r\u0001C\u0001C\")\u0001\u000f\u0001C\u0001C\")!\u000f\u0001C\u0001C\")A\u000f\u0001C\u0001C\")a\u000f\u0001C\u0001C\")\u0001\u0010\u0001C\u0001C\")!\u0010\u0001C\u0001C\")A\u0010\u0001C\u0001C\")a\u0010\u0001C\u0001\u007f\"9\u0011q\u0007\u0001\u0005\u0002\u0005e\u0002BBA*\u0001\u0011\u0005\u0011\r\u0003\u0004\u0002X\u0001!\t!\u0019\u0005\u0007\u00037\u0002A\u0011A1\t\r\u0005}\u0003\u0001\"\u0001b\u0011\u001d\tY\u0007\u0001C\u0005\u0003[B\u0011\"a-\u0001#\u0003%I!!.\t\u000f\u0005-\u0007\u0001\"\u0003\u0002N\"9!Q\u0001\u0001\u0005\n\t\u001d\u0001b\u0002B\u0016\u0001\u0011%!Q\u0006\u0005\b\u0005w\u0001A\u0011\u0002B\u001f\u0011\u0019\u0011i\u0005\u0001C\u0001C\"9!\u0011\u000b\u0001\u0005\n\tM\u0003b\u0002B8\u0001\u0011%!\u0011\u000f\u0005\b\u0005#\u0003A\u0011\u0002BJ\u0011\u001d\u0011\t\u000b\u0001C\u0005\u0005GCqAa3\u0001\t\u0013\u0011i\rC\u0005\u0003f\u0002\t\n\u0011\"\u0003\u0003h\"1!1\u001e\u0001\u0005\u0002\u0005DaAa<\u0001\t\u0003\t\u0007b\u0002Bz\u0001\u0011\u0005!Q\u001f\u0005\u0007\u0007\u000f\u0001A\u0011A1\t\u000f\r-\u0001\u0001\"\u0001\u0004\u000e!111\b\u0001\u0005\u0002\u0005Dqaa\u0010\u0001\t\u0013\u0019\t\u0005C\u0004\u0004V\u0001!\taa\u0016\t\u000f\r\u0005\u0004\u0001\"\u0003\u0004d!91\u0011\u000e\u0001\u0005\n\r-\u0004BBB9\u0001\u0011\u0005\u0011\r\u0003\u0004\u0004v\u0001!\t!\u0019\u0005\b\u0007s\u0002A\u0011AB>\u0011\u001d\u0019I\t\u0001C\u0001\u0007\u0017Caaa+\u0001\t\u0003\t\u0007BBBX\u0001\u0011\u0005\u0011\r\u0003\u0004\u00044\u0002!\t!\u0019\u0005\u0007\u0007o\u0003A\u0011A1\t\r\rm\u0006\u0001\"\u0001b\u0011\u0019\u0019y\f\u0001C\u0001C\"111\u0019\u0001\u0005\u0002\u0005Dqaa2\u0001\t\u0003\u0019I\rC\u0004\u0004\\\u0002!\ta!8\t\r\r%\b\u0001\"\u0001b\u0011\u0019\u0019i\u000f\u0001C\u0001C\"11\u0011\u001f\u0001\u0005\u0002\u0005Daa!>\u0001\t\u0003\t\u0007bBB}\u0001\u0011\u000511 \u0005\u0007\t\u000f\u0001A\u0011A1\t\r\u0011-\u0001\u0001\"\u0001b\u0011\u0019!y\u0001\u0001C\u0001C\"1A1\u0003\u0001\u0005\u0002\u0005Da\u0001b\u0006\u0001\t\u0003\t'\u0001E&SC\u001a$8\t\\;ti\u0016\u0014H+Z:u\u0015\t!U)\u0001\u0004tKJ4XM\u001d\u0006\u0002\r\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001J!\tQU*D\u0001L\u0015\u0005a\u0015!B:dC2\f\u0017B\u0001(L\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u0015\t\u0003%\u0002i\u0011aQ\u0001\u0004Y><W#A+\u0011\u0005Y[V\"A,\u000b\u0005aK\u0016!B:mMRR'\"\u0001.\u0002\u0007=\u0014x-\u0003\u0002]/\n1Aj\\4hKJ\fA\u0001\\8hA\u0005!An\\43\u0003\u0015awn\u001a\u001a!\u0003e!Xm\u001d;De\u0016\fG/Z\"mkN$XM]!oI\u000ecwn]3\u0015\u0003\t\u0004\"AS2\n\u0005\u0011\\%\u0001B+oSRD#A\u00024\u0011\u0005\u001dtW\"\u00015\u000b\u0005%T\u0017aA1qS*\u00111\u000e\\\u0001\bUV\u0004\u0018\u000e^3s\u0015\ti\u0017,A\u0003kk:LG/\u0003\u0002pQ\n!A+Z:u\u0003=\"Xm\u001d;NKR\fG-\u0019;b\u0005>|Go\u001d;sCB\u001cVM\u001d<feN4%o\\7D_2|7-\u0019;fI\n\u0013xn[3sQ\t9a-A\u0013uKN$8I]3bi\u0016\u001cE.^:uKJ\fe\u000e\u001a*fgR\f'\u000f\u001e\"s_.,'OT8eK\"\u0012\u0001BZ\u0001*i\u0016\u001cHo\u0011:fCR,7\t\\;ti\u0016\u0014\u0018I\u001c3SKN$\u0018M\u001d;D_:$(o\u001c7mKJtu\u000eZ3)\u0005%1\u0017a\f;fgR\u001c%/Z1uK\u000ecWo\u001d;fe\u0006sGmV1ji\u001a{'O\u0011:pW\u0016\u0014\u0018J\u001c*v]:LgnZ*uCR,\u0007F\u0001\u0006g\u0003%\"Xm\u001d;De\u0016\fG/Z\"mkN$XM]!oI\u000e\u0013X-\u0019;f\u0019&\u001cH\u000fR3mKR,Gk\u001c9jG\"\u00121BZ\u0001(i\u0016\u001cHo\u0011:fCR,7\t\\;ti\u0016\u0014\u0018I\u001c3De\u0016\fG/Z!oI6\u000bg.\u001f+pa&\u001c7\u000f\u000b\u0002\rM\u0006\u0001B/Z:u\u00072LWM\u001c;Rk>$\u0018m\u001d\u0015\u0003\u001b\u0019\f1c]3u\u0007>t7/^7fe\nKH/\u001a*bi\u0016$rAYA\u0001\u00033\ti\u0003C\u0004\u0002\u00049\u0001\r!!\u0002\u0002\u000b\u0005$W.\u001b8\u0011\t\u0005\u001d\u0011QC\u0007\u0003\u0003\u0013QA!a\u0001\u0002\f)!\u0011QBA\b\u0003\u001d\u0019G.[3oiNT1ARA\t\u0015\r\t\u0019\"W\u0001\u0007CB\f7\r[3\n\t\u0005]\u0011\u0011\u0002\u0002\u0006\u0003\u0012l\u0017N\u001c\u0005\b\u00037q\u0001\u0019AA\u000f\u0003\u0019)g\u000e^5usB!\u0011qDA\u0015\u001b\t\t\tC\u0003\u0003\u0002$\u0005\u0015\u0012!B9v_R\f'\u0002BA\u0014\u0003\u001f\taaY8n[>t\u0017\u0002BA\u0016\u0003C\u0011\u0011c\u00117jK:$\u0018+^8uC\u0016sG/\u001b;z\u0011\u001d\tyC\u0004a\u0001\u0003c\tQA^1mk\u0016\u00042ASA\u001a\u0013\r\t)d\u0013\u0002\u0005\u0019>tw-\u0001\u000bhKR\u001cuN\\:v[\u0016\u0014()\u001f;f%\u0006$Xm\u001d\u000b\u0005\u0003w\t\t\u0006\u0005\u0005\u0002>\u0005-\u0013QDA\u0019\u001d\u0011\ty$a\u0012\u0011\u0007\u0005\u00053*\u0004\u0002\u0002D)\u0019\u0011QI$\u0002\rq\u0012xn\u001c;?\u0013\r\tIeS\u0001\u0007!J,G-\u001a4\n\t\u00055\u0013q\n\u0002\u0004\u001b\u0006\u0004(bAA%\u0017\"9\u00111A\bA\u0002\u0005\u0015\u0011a\u0006;fgR$UMZ1vYR\u001cE.[3oiF+x\u000e^1tQ\t\u0001b-A\u0014uKN$8I]3bi\u0016\u001cE.^:uKJ<\u0016\u000e\u001e5BIZ,'\u000f^5tK\u0012\u0004vN\u001d;[KJ|\u0007FA\tg\u0003\r#Xm\u001d;De\u0016\fG/Z\"mkN$XM],ji\"\fEM^3si&\u001cX\r\u001a%pgR\fe\u000e\u001a)peR$\u0015N\u001a4fe\u0016tGO\u0012:p[N{7m[3u'\u0016\u0014h/\u001a:)\u0005I1\u0017a\n;fgR\u001c%/Z1uK\u000ecWo\u001d;fe&sg/\u00197jI6+G/\u00193bi\u00064VM]:j_:D3aEA2!\r9\u0017QM\u0005\u0004\u0003OB'\u0001\u0003#jg\u0006\u0014G.\u001a3)\u0005M1\u0017a\u00063p\u001f:\u001cF/\u0019:uK\u0012\\\u0015MZ6b\u00072,8\u000f^3s)!\ty'a\"\u0002\u0012\u0006UEc\u00012\u0002r!9\u00111\u000f\u000bA\u0002\u0005U\u0014AB1di&|g\u000e\u0005\u0004K\u0003o\nYHY\u0005\u0004\u0003sZ%!\u0003$v]\u000e$\u0018n\u001c82!\u0011\ti(a!\u000e\u0005\u0005}$bAAA\u000b\u00069A/Z:uW&$\u0018\u0002BAC\u0003\u007f\u00121cS1gW\u0006\u001cE.^:uKJ$Vm\u001d;LSRD\u0011\"!#\u0015!\u0003\u0005\r!a#\u0002%9,XnQ8oiJ|G\u000e\\3s\u001d>$Wm\u001d\t\u0004\u0015\u00065\u0015bAAH\u0017\n\u0019\u0011J\u001c;\t\u000f\u0005ME\u00031\u0001\u0002\f\u0006qa.^7Ce>\\WM\u001d(pI\u0016\u001c\bbBAL)\u0001\u0007\u0011\u0011T\u0001\u0018EJ|7.\u001a:Qe>\u0004XM\u001d;z\u001fZ,'O]5eKN\u0004\u0012BSAN\u0003?\u000b)+a+\n\u0007\u0005u5JA\u0005Gk:\u001cG/[8oeA!\u0011QPAQ\u0013\u0011\t\u0019+a \u0003\u0019Q+7\u000f^&ji:{G-Z:\u0011\t\u0005u\u0014qU\u0005\u0005\u0003S\u000byH\u0001\u0006Ce>\\WM\u001d(pI\u0016\u0004\u0002\"!\u0010\u0002L\u00055\u0016Q\u0016\t\u0005\u0003{\ty+\u0003\u0003\u00022\u0006=#AB*ue&tw-A\u0011e_>s7\u000b^1si\u0016$7*\u00194lC\u000ecWo\u001d;fe\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00028*\"\u00111RA]W\t\tY\f\u0005\u0003\u0002>\u0006\u001dWBAA`\u0015\u0011\t\t-a1\u0002\u0013Ut7\r[3dW\u0016$'bAAc\u0017\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005%\u0017q\u0018\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AP:f]\u0012$Um]2sS\n,7\t\\;ti\u0016\u0014(+Z9vKN$Hk\u001c\"pk:$\u0007k\u001c:u+:$\u0018\u000e\\!mY\n\u0013xn[3sgB\u0013x\u000e]1hCR,G\r\u0006\u0004\u0002P\u0006\u0005\u0018\u0011\u001f\u000b\u0005\u0003#\fi\u000e\u0005\u0003\u0002T\u0006eWBAAk\u0015\u0011\t9.!\n\u0002\u0011I,\u0017/^3tiNLA!a7\u0002V\n9B)Z:de&\u0014Wm\u00117vgR,'OU3ta>t7/\u001a\u0005\b\u0003?4\u00029AA>\u0003\u001d\u0019G.^:uKJDq!a9\u0017\u0001\u0004\t)/\u0001\u0007mSN$XM\\3s\u001d\u0006lW\r\u0005\u0003\u0002h\u00065XBAAu\u0015\u0011\tY/!\n\u0002\u000f9,Go^8sW&!\u0011q^Au\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u0011\u001d\t\u0019P\u0006a\u0001\u0003k\f\u0001b^1jiRKW.\u001a\t\u0005\u0003o\u0014\t!\u0004\u0002\u0002z*!\u00111`A\u007f\u0003!!WO]1uS>t'bAA\u0000\u0017\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\t\r\u0011\u0011 \u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u0003U9\u0018-\u001b;G_J\u0014VO\u001c8j]\u001e\u0014%o\\6feN$bA!\u0003\u0003&\t%B\u0003\u0002B\u0006\u0005G\u0001bA!\u0004\u0003\u0018\tua\u0002\u0002B\b\u0005'qA!!\u0011\u0003\u0012%\tA*C\u0002\u0003\u0016-\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0003\u001a\tm!aA*fc*\u0019!QC&\u0011\u0007I\u0013y\"C\u0002\u0003\"\r\u0013AB\u0011:pW\u0016\u00148+\u001a:wKJDq!a8\u0018\u0001\b\tY\bC\u0004\u0003(]\u0001\r!a#\u0002\u000b\r|WO\u001c;\t\u000f\u0005Mx\u00031\u0001\u0002v\u0006Y4/\u001a8e\t\u0016\u001c8M]5cK\u000ecWo\u001d;feJ+\u0017/^3tiR{'i\\;oIB{'\u000f^+oi&d'I]8lKJ\u001c\bK]8qC\u001e\fG/\u001a3\u0015\u0015\u0005E'q\u0006B\u001a\u0005k\u0011I\u0004C\u0004\u00032a\u0001\rA!\b\u0002\u0017\u0011,7\u000f^5oCRLwN\u001c\u0005\b\u0003GD\u0002\u0019AAs\u0011\u001d\u00119\u0004\u0007a\u0001\u0003\u0017\u000b1#\u001a=qK\u000e$X\r\u001a\"s_.,'oQ8v]RDq!a=\u0019\u0001\u0004\t)0A\u0013tK:$G)Z:de&\u0014Wm\u00117vgR,'OU3rk\u0016\u001cH\u000fV8C_VtG\rU8siR1\u0011\u0011\u001bB \u0005\u0017BqA!\r\u001a\u0001\u0004\u0011\t\u0005\u0005\u0003\u0003D\t\u001dSB\u0001B#\u0015\r\tY/R\u0005\u0005\u0005\u0013\u0012)E\u0001\u0007T_\u000e\\W\r^*feZ,'\u000fC\u0004\u0002df\u0001\r!!:\u0002OQ,7\u000f^\"sK\u0006$Xm\u00117vgR,'/\u00118e!\u0016\u0014hm\u001c:n%\u0016\f7o]5h]6,g\u000e\u001e\u0015\u00035\u0019\f1c\u00195fG.\u0014V\r\u001d7jG\u0006l\u0015M\\1hKJ$RA\u0019B+\u0005/Bq!a8\u001c\u0001\u0004\tY\bC\u0004\u0003Zm\u0001\rAa\u0017\u0002\u001f\u0015D\b/Z2uK\u0012Dun\u001d;j]\u001e\u0004bA!\u0004\u0003^\t\u0005\u0014\u0002\u0002B0\u00057\u0011A\u0001T5tiB9!Ja\u0019\u0002\f\n\u001d\u0014b\u0001B3\u0017\n1A+\u001e9mKJ\u0002bA!\u0004\u0003^\t%\u0004c\u0001&\u0003l%\u0019!QN&\u0003\u000f\t{w\u000e\\3b]\u0006YBO]1og2\fG/\u001a)beRLG/[8o\u0013:4w\u000eV8TKF$BAa\u001d\u0003xA1!Q\u0002B\f\u0005k\u0002bA!\u0004\u0003\u0018\u0005-\u0005b\u0002B=9\u0001\u0007!1P\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bC\u0002B?\u0005\u000f\u0013I)\u0004\u0002\u0003\u0000)!!\u0011\u0011BB\u0003\u0011)H/\u001b7\u000b\u0005\t\u0015\u0015\u0001\u00026bm\u0006LAAa\u0018\u0003\u0000A!!1\u0012BG\u001b\t\t)#\u0003\u0003\u0003\u0010\u0006\u0015\"A\u0005+pa&\u001c\u0007+\u0019:uSRLwN\\%oM>\f1c^1ji\u001a{'\u000fV8qS\u000ed\u0015n\u001d;j]\u001e$rA\u0019BK\u0005/\u0013i\nC\u0004\u0002\u0004u\u0001\r!!\u0002\t\u000f\teU\u00041\u0001\u0003\u001c\u0006yQ\r\u001f9fGR,G\r\u0015:fg\u0016tG\u000f\u0005\u0004\u0003\u000e\t]\u0011Q\u0016\u0005\b\u0005?k\u0002\u0019\u0001BN\u00039)\u0007\u0010]3di\u0016$\u0017IY:f]R\f\u0001#\u001b8de\u0016lWM\u001c;bY\u0006cG/\u001a:\u0015\r\t\u0015&Q\u0016BX!\u0019\u0011iAa\u0006\u0003(B!\u00111\u001bBU\u0013\u0011\u0011Y+!6\u0003\u0011\u0005\u0003\u0018.\u0012:s_JDq!a\u0001\u001f\u0001\u0004\t)\u0001C\u0004\u00032z\u0001\rAa-\u0002\u000f\rD\u0017M\\4fgB1!Q\u0002B\f\u0005k\u0003rA\u0013B2\u0005o\u0013\u0019\r\u0005\u0003\u0003:\n}VB\u0001B^\u0015\u0011\u0011i,!\n\u0002\r\r|gNZ5h\u0013\u0011\u0011\tMa/\u0003\u001d\r{gNZ5h%\u0016\u001cx.\u001e:dKB1!Q\u0002B\f\u0005\u000b\u0004B!a\u0002\u0003H&!!\u0011ZA\u0005\u00055\tE\u000e^3s\u0007>tg-[4Pa\u0006ya/\u00197jI\u0006$XmQ8oM&<7\u000f\u0006\u0005\u0003P\nU'q\u001bBq!!\ti$a\u0013\u00038\nE\u0007\u0003\u0003B?\u0005'\fi+!,\n\t\u00055#q\u0010\u0005\b\u0003\u0007y\u0002\u0019AA\u0003\u0011\u001d\u0011In\ba\u0001\u00057\f\u0001\"\u001a=qK\u000e$X\r\u001a\t\t\u0003{\tYEa.\u0003^B1!Q\u0002B\f\u0005?\u0004rA\u0013B2\u0003[\u000bi\u000bC\u0005\u0003d~\u0001\n\u00111\u0001\u0003j\u0005QQ\r\u001f5bkN$\u0018N^3\u00023Y\fG.\u001b3bi\u0016\u001cuN\u001c4jON$C-\u001a4bk2$HeM\u000b\u0003\u0005STCA!\u001b\u0002:\u0006YB/Z:u\u0013:\u001c'/Z7f]R\fG.\u00117uKJ\u001cuN\u001c4jOND#!\t4\u00025Q,7\u000f^*fi2{w\r\u000e6D_:4\u0017nZ;sCRLwN\\:)\u0005\t2\u0017a\u00037fO\u0006\u001c\u00170\u00117uKJ$bA!*\u0003x\ne\bbBA\u0002G\u0001\u0007\u0011Q\u0001\u0005\b\u0005w\u001c\u0003\u0019\u0001B\u007f\u0003%\u0011Xm]8ve\u000e,7\u000f\u0005\u0005\u0002>\u0005-#q\u0017B\u0000!\u0019\u0011iAa\u0006\u0004\u0002A!\u0011qAB\u0002\u0013\u0011\u0019)!!\u0003\u0003\u0017\r{gNZ5h\u000b:$(/_\u0001\u0017i\u0016\u001cH\u000fT3hC\u000eL\u0018\t\u001c;fe\u000e{gNZ5hg\"\u0012AEZ\u0001\u0015i\u0016\u001cHo\u0011:fCR,\u0007+\u0019:uSRLwN\\:\u0015\u0007\t\u001cy\u0001C\u0004\u0004\u0012\u0015\u0002\r!!,\u0002+5,G/\u00193bi\u00064VM]:j_:\u001cFO]5oO\"\u001aQe!\u0006\u0011\t\r]1QD\u0007\u0003\u00073Q1aa\u0007k\u0003\u0019\u0001\u0018M]1ng&!1qDB\r\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f\u001e\u0015\bK\r\r2qFB\u0019!\u0011\u0019)ca\u000b\u000e\u0005\r\u001d\"\u0002BB\u0015\u00073\t\u0001\u0002\u001d:pm&$WM]\u0005\u0005\u0007[\u00199CA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0005\u0007g\u00199$\t\u0002\u00046\u000591GL\u001c.\u0013Z\u0003\u0014EAB\u001d\u0003\u001d\u0019dfN\u0017J-J\n1\u0007^3tiNCw.\u001e7e\u0003B\u0004H._\"sK\u0006$X\rV8qS\u000e\u001c\bk\u001c7jGf$vn\u0011:fCR,\u0007+\u0019:uSRLwN\\:)\u0005\u00192\u0017\u0001D2mkN$XM]%nC\u001e,GCBB\"\u0007\u001f\u001a\t\u0006\u0005\u0003\u0004F\r-SBAB$\u0015\u0011\u0019I%a\u0004\u0002\u000b%l\u0017mZ3\n\t\r53q\t\u0002\r\u00072,8\u000f^3s\u00136\fw-\u001a\u0005\b\u0003?<\u0003\u0019AA>\u0011\u001d\u0019\u0019f\na\u0001\u0003\u0017\u000b\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u0001\u001di\u0016\u001cHoQ8oM2,XM\u001c;SKBd\u0017nY1BgNLwM\\8s)\r\u00117\u0011\f\u0005\b\u0007#A\u0003\u0019AAWQ\rA3Q\u0003\u0015\bQ\r\r2qFB0Y\u0011\u0019\u0019da\u000e\u0002!\t\u0014xn[3s\u0013N,fNZ3oG\u0016$GC\u0002B5\u0007K\u001a9\u0007C\u0004\u0004J%\u0002\raa\u0011\t\u000f\rM\u0013\u00061\u0001\u0002\f\u0006q!M]8lKJL5/\u00112tK:$HC\u0002B5\u0007[\u001ay\u0007C\u0004\u0004J)\u0002\raa\u0011\t\u000f\rM#\u00061\u0001\u0002\f\u0006!B/Z:u+:\u0014XmZ5ti\u0016\u0014(I]8lKJD#a\u000b4\u0002WQ,7\u000f^\"p]\u001adW/\u001a8u'B,7-\u001b4jGR{\u0007/[2WC2LG-\u0019;j_:\u001c\u0005.\u00198hKND#\u0001\f4\u0002#\r\u0014X-\u0019;f\u0003\u0012l\u0017N\\\"mS\u0016tG\u000f\u0006\u0004\u0004~\r\r5Q\u0011\t\u0005\u0003\u000f\u0019y(\u0003\u0003\u0004\u0002\u0006%!AD\"p]\u001adW/\u001a8u\u0003\u0012l\u0017N\u001c\u0005\b\u0003?l\u0003\u0019AA>\u0011\u001d\u00199)\fa\u0001\u0005S\nQ\"^:f\u0007>tGO]8mY\u0016\u0014\u0018A\t;fgR$Um]2sS\n,\u0017+^8sk6\u0014V-];fgR$vN\u0011:pW\u0016\u00148\u000fF\u0003c\u0007\u001b\u001b\t\nC\u0004\u0004\u0010:\u0002\r!a#\u0002\u00159,XN\u0011:pW\u0016\u00148\u000fC\u0004\u0004\b:\u0002\rA!\u001b)\u00079\u001a)\u0002K\u0004/\u0007/\u000byc!(\u0011\t\r\u00152\u0011T\u0005\u0005\u00077\u001b9CA\u0005DgZ\u001cv.\u001e:dK221qTBR\u0007O\u000b#a!)\u0002\u000fQbc-\u00197tK\u0006\u00121QU\u0001\u0007i1\"(/^3\"\u0005\r%\u0016A\u0002\u0019-iJ,X-A\ruKN$X\u000b\u001d3bi\u0016lU\r^1eCR\fg+\u001a:tS>t\u0007FA\u0018g\u00035\"Xm\u001d;BkRDwN]5{KJ4\u0015-\u001b7ve\u00164u.\u001e8e\u0013:\u001cuN\u001c;s_2dWM]*uCJ$X\u000f\u001d\u0015\u0003a\u0019\fq\u0004^3ti\n\u0013xn[3s'\u0016\u001c8/[8o+VLG\r\u0015:pa\u0006<\u0017\r^3eQ\t\td-\u0001!uKN$8I]3bi\u0016\u001cE.^:uKJ\fe\u000eZ\"sK\u0006$X\rV8qS\u000e<\u0016\u000e\u001e5SK6|G/\u001a'pO6\u000bg.Y4fe&s7\u000f^1oi&\fG/[8oQ\t\u0011d-A\tuKN$8K\\1qg\"|GoQ8v]RD#a\r4\u00029Q,7\u000f^'fi\u0006$\u0017\r^1F]\u000e\u0014\u0018\u0010\u001d;pe\u0016s\u0017M\u00197fI\"\u0012AGZ\u0001(i\u0016\u001cHoU5oO2,7i\u001c8ue>dG.\u001a:TS:<G.\u001a\"s_.,'o\u00117vgR,'\u000f\u000b\u00026M\u0006)C/Z:u%\u0016\u001cwN\u001c4jOV\u0014XmQ8oiJ|G\u000e\\3s\u00072LWM\u001c;Rk>$\u0018m\u001d\u000b\u0004E\u000e-\u0007bBBgm\u0001\u0007!\u0011N\u0001\u0013G>l'-\u001b8fI\u000e{g\u000e\u001e:pY2,'\u000fK\u00027\u0007+AsANB\u0012\u0007'\u001c).\u0001\u0005c_>dW-\u00198tY\u0011\u00199n!7\u001a\u0003\u0001I\u0012!A\u0001$i\u0016\u001cHOU3d_:4\u0017nZ;sK\u000e{g\u000e\u001e:pY2,'/Q;uQ>\u0014\u0018N_3s)\r\u00117q\u001c\u0005\b\u0007C<\u0004\u0019\u0001B5\u00031\u0019w.\u001c2j]\u0016$Wj\u001c3fQ\r94Q\u0003\u0015\bo\r\r21[BtY\u0011\u00199n!7\u00027Q,7\u000f^(wKJd\u0017\u0010T1sO\u0016\u001c%/Z1uKR{\u0007/[2tQ\tAd-\u0001\fuKN$H+[7fI>+H\u000fS3beR\u0014W-\u0019;tQ\tId-A\u0011uKN$(+Z4jgR,'/\u001a3D_:$(o\u001c7mKJ,e\u000e\u001a9pS:$8\u000f\u000b\u0002;M\u0006qD/Z:u\t&\u0014Xm\u0019;U_\u000e{g\u000e\u001e:pY2,'oQ8n[Vt\u0017nY1uS>tg)Y5mg>sw\n\u001c3fe6+G/\u00193bi\u00064VM]:j_:D#a\u000f4\u0002?\rDWmY6SK\u0006$\u0017N\\3tg\u0006sGMU8mY\u0006\u0014G.Z*uCR,8\u000fF\u0002c\u0007{Dqaa@=\u0001\u0004!\t!\u0001\u0006d_:$(o\u001c7mKJ\u00042A\u0015C\u0002\u0013\r!)a\u0011\u0002\u0011\u0007>tGO]8mY\u0016\u00148+\u001a:wKJ\f\u0001\b^3tiN#\u0018M\u001d;va^KG\u000f\u001b(p]\u0012+g-Y;mi.\u001buN\u001c;s_2dWM\u001d#z]\u0006l\u0017nY\"p]\u001aLw-\u001e:bi&|g\u000e\u000b\u0002>M\u0006iC/Z:u)>\u0004\u0018n\u0019#fY\u0016$X\rZ!oIJ+7M]3bi\u0016$w\u000b[5mK\n\u0013xn[3s\u0013N$un\u001e8)\u0005y2\u0017A\t;fgR\u0014V\rZ;dK:+XNU3qY&\u001c\u0017MR3uG\",'\u000f\u00165sK\u0006$7\u000f\u000b\u0002@M\u0006qD/Z:u\u0003\n\fg\u000eZ8oK\u00124U\u000f^;sKJ+\u0007\u000f\\5dCJ+7m\u001c<fe\u0016$w,\\1j]J+\u0007\u000f\\5dC&swJ\u001a4mS:,Gj\\4ESJD#\u0001\u00114\u0002{Q,7\u000f^!cC:$wN\\3e\rV$XO]3SKBd\u0017nY1SK\u000e|g/\u001a:fI~k\u0017-\u001b8SKBd\u0017nY1J]>sG.\u001b8f\u0019><G)\u001b:)\u0005\u00053\u0007f\u0002\u0001\u0005\u001e\u0005=B1\u0005\t\u0004O\u0012}\u0011b\u0001C\u0011Q\n9A+[7f_V$h$\u0001=)\u000f\u0001!9#a\f\u0005.A\u0019q\r\"\u000b\n\u0007\u0011-\u0002NA\u0002UC\u001e\f#\u0001b\f\u0002\u0017%tG/Z4sCRLwN\u001c\u0015\b\u0001\u0011\u001d\u0012q\u0006C\u001aC\t!)$A\ncCj,GNO:iCJ$wlY8v]RTD\u0007")
public class KRaftClusterTest {
    private final Logger log = LoggerFactory.getLogger(KRaftClusterTest.class);
    private final Logger log2 = LoggerFactory.getLogger((String)new StringBuilder(1).append(KRaftClusterTest.class.getCanonicalName()).append("2").toString());

    public Logger log() {
        return this.log;
    }

    public Logger log2() {
        return this.log2;
    }

    @Test
    public void testCreateClusterAndClose() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
        }
    }

    @Test
    public void testMetadataBootstrapServersFromColocatedBroker() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            BrokerServer broker = cluster.brokers().values().iterator().next();
            Assertions.assertEquals((int)broker.boundPort(broker.config().interBrokerListenerName()), (Integer)((Integer)((CompletableFuture)broker.sharedServer().interBrokerPortFuture().get()).get(10L, TimeUnit.MINUTES)));
        }
    }

    @Test
    public void testCreateClusterAndRestartBrokerNode() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            BrokerServer broker = cluster.brokers().values().iterator().next();
            broker.shutdown();
            broker.startup();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndRestartControllerNode() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            ControllerServer controller = (ControllerServer)CollectionConverters$.MODULE$.IteratorHasAsScala(cluster.controllers().values().iterator()).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testCreateClusterAndRestartControllerNode$1(x$1))).next();
            int port = controller.socketServer().boundPort(((EndPoint)controller.config().controllerListeners().head()).listenerName());
            controller.shutdown();
            java.util.Map config = controller.sharedServer().controllerConfig().props();
            ((HashMap)config).put(KafkaConfig$.MODULE$.ListenersProp(), new StringBuilder(23).append("CONTROLLER://localhost:").append(port).toString());
            controller.sharedServer().controllerConfig().updateCurrentConfig(new KafkaConfig(config));
            controller.sharedServer().metrics_$eq(new Metrics());
            controller.startup();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndRestartControllerNode$2(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timeout waiting for new controller election");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndWaitForBrokerInRunningState() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndWaitForBrokerInRunningState$1(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Broker never made it to RUNNING state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndWaitForBrokerInRunningState$3(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"RaftManager was not initialized.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Assertions.assertEquals((Object)cluster.nodes().clusterId().toString(), (Object)admin.describeCluster().clusterId().get());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndCreateListDeleteTopic() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(3).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateListDeleteTopic$1(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Broker never made it to RUNNING state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateListDeleteTopic$3(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"RaftManager was not initialized.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                java.util.List<NewTopic> newTopic = Collections.singletonList(new NewTopic("test-topic", 1, (short)3));
                admin.createTopics(newTopic).all().get();
                this.waitForTopicListing(admin, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"test-topic", (List)Nil$.MODULE$), (scala.collection.immutable.Seq<String>)Nil$.MODULE$);
                admin.deleteTopics(Collections.singletonList("test-topic")).all().get();
                this.waitForTopicListing(admin, (scala.collection.immutable.Seq<String>)Nil$.MODULE$, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"test-topic", (List)Nil$.MODULE$));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndCreateAndManyTopics() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(3).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateAndManyTopics$1(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Broker never made it to RUNNING state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateAndManyTopics$3(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"RaftManager was not initialized.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                ArrayList<NewTopic> newTopic = new ArrayList<NewTopic>();
                newTopic.add(new NewTopic("test-topic-1", 2, (short)3));
                newTopic.add(new NewTopic("test-topic-2", 2, (short)3));
                newTopic.add(new NewTopic("test-topic-3", 2, (short)3));
                admin.createTopics(newTopic).all().get();
                this.waitForTopicListing(admin, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"test-topic-1", (List)new .colon.colon((Object)"test-topic-2", (List)new .colon.colon((Object)"test-topic-3", (List)Nil$.MODULE$))), (scala.collection.immutable.Seq<String>)Nil$.MODULE$);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClientQuotas() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testClientQuotas$1(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Broker never made it to RUNNING state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Object var19_19;
                Tuple2 tuple2;
                ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"testkit")}))).asJava());
                ClientQuotaFilter clientQuotaFilter = ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"testkit"), (List)Nil$.MODULE$)).asJava());
                java.util.Map describeResult = KRaftClusterTest.alterThenDescribe$1(entity, (scala.collection.immutable.Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("request_percentage", Predef$.MODULE$.double2Double(0.99)), (List)Nil$.MODULE$), clientQuotaFilter, 1, admin);
                Assertions.assertEquals((double)0.99, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("request_percentage")), (double)1.0E-6);
                describeResult = KRaftClusterTest.alterThenDescribe$1(entity, (scala.collection.immutable.Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("request_percentage", Predef$.MODULE$.double2Double(0.97)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(10000.0)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(10001.0)), (List)Nil$.MODULE$))), clientQuotaFilter, 3, admin);
                Assertions.assertEquals((double)0.97, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("request_percentage")), (double)1.0E-6);
                Assertions.assertEquals((double)10000.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("producer_byte_rate")), (double)1.0E-6);
                Assertions.assertEquals((double)10001.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("consumer_byte_rate")), (double)1.0E-6);
                describeResult = KRaftClusterTest.alterThenDescribe$1(entity, (scala.collection.immutable.Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("request_percentage", Predef$.MODULE$.double2Double(0.95)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", null), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", null), (List)Nil$.MODULE$))), clientQuotaFilter, 1, admin);
                Assertions.assertEquals((double)0.95, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("request_percentage")), (double)1.0E-6);
                KRaftClusterTest.alterThenDescribe$1(entity, (scala.collection.immutable.Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("request_percentage", null), (List)Nil$.MODULE$), clientQuotaFilter, 0, admin);
                describeResult = null;
                describeResult = KRaftClusterTest.alterThenDescribe$1(entity, (scala.collection.immutable.Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(9999.0)), (List)Nil$.MODULE$), clientQuotaFilter, 1, admin);
                Assertions.assertEquals((double)9999.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("producer_byte_rate")), (double)1.0E-6);
                ClientQuotaEntity entity2 = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"testkit"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"some-client")}))).asJava());
                clientQuotaFilter = ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"testkit"), (List)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"client-id", (String)"some-client"), (List)Nil$.MODULE$))).asJava());
                describeResult = KRaftClusterTest.alterThenDescribe$1(entity2, (scala.collection.immutable.Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(9998.0)), (List)Nil$.MODULE$), clientQuotaFilter, 1, admin);
                Assertions.assertEquals((double)9998.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity2)).get("producer_byte_rate")), (double)1.0E-6);
                clientQuotaFilter = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"testkit"), (List)Nil$.MODULE$)).asJava());
                long l2 = 100L;
                long tryUntilNoAssertionError_waitTime = 15000L;
                long tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
                while (true) {
                    void tryUntilNoAssertionError_pause;
                    Right right;
                    try {
                        java.util.Map $anonfun$testClientQuotas$5_results = (java.util.Map)admin.describeClientQuotas(clientQuotaFilter).entities().get();
                        Assertions.assertEquals((int)2, (int)$anonfun$testClientQuotas$5_results.size(), (String)"Broker did not see two client quotas");
                        Assertions.assertEquals((double)9999.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)$anonfun$testClientQuotas$5_results.get(entity)).get("producer_byte_rate")), (double)1.0E-6);
                        Assertions.assertEquals((double)9998.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)$anonfun$testClientQuotas$5_results.get(entity2)).get("producer_byte_rate")), (double)1.0E-6);
                        Object var25_17 = null;
                        BoxedUnit $anonfun$tryUntilNoAssertionError$1_res = BoxedUnit.UNIT;
                        right = scala.package$.MODULE$.Left().apply((Object)$anonfun$tryUntilNoAssertionError$1_res);
                    }
                    catch (AssertionError $anonfun$tryUntilNoAssertionError$1_ae) {
                        right = scala.package$.MODULE$.Right().apply((Object)$anonfun$tryUntilNoAssertionError$1_ae);
                    }
                    Object var23_14 = null;
                    Object var24_15 = null;
                    Right tryUntilNoAssertionError_computeUntilTrue_result = right;
                    if (((Either)tryUntilNoAssertionError_computeUntilTrue_result).isLeft()) {
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                        break;
                    }
                    if (System.currentTimeMillis() > tryUntilNoAssertionError_computeUntilTrue_startTime + tryUntilNoAssertionError_waitTime) {
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                        break;
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(tryUntilNoAssertionError_waitTime), (long)tryUntilNoAssertionError_pause));
                }
                Object var22_13 = null;
                Tuple2 tuple22 = tuple2;
                if (tuple22 == null) {
                    throw new MatchError(null);
                }
                Either tryUntilNoAssertionError_either = (Either)tuple22._1();
                tuple22._2$mcZ$sp();
                if (!(var19_19 instanceof Left)) {
                    if (var19_19 instanceof Right) {
                        throw (AssertionError)((Right)var19_19).value();
                    }
                    throw new MatchError((Object)var19_19);
                }
                ((Left)var19_19).value();
                tuple22 = null;
                var19_19 = null;
            }
        }
    }

    public void setConsumerByteRate(Admin admin, ClientQuotaEntity entity, long value) {
        admin.alterClientQuotas(Collections.singletonList(new ClientQuotaAlteration(entity, Collections.singletonList(new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double((double)value)))))).all().get();
    }

    public scala.collection.immutable.Map<ClientQuotaEntity, Object> getConsumerByteRates(Admin admin) {
        ClientQuotaFilter allFilter = ClientQuotaFilter.contains(Collections.emptyList());
        HashMap results = new HashMap();
        ((java.util.Map)admin.describeClientQuotas(allFilter).entities().get()).forEach((x0$1, x1$1) -> Option$.MODULE$.apply(x1$1.get("consumer_byte_rate")).foreach((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToLong((long)KRaftClusterTest.$anonfun$getConsumerByteRates$2(results, x0$1, x0$2))));
        return CollectionConverters$.MODULE$.MapHasAsScala(results).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDefaultClientQuotas() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testDefaultClientQuotas$1(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Broker never made it to RUNNING state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                ClientQuotaEntity defaultUser = new ClientQuotaEntity(Collections.singletonMap("user", null));
                ClientQuotaEntity bobUser = new ClientQuotaEntity(Collections.singletonMap("user", "bob"));
                long l2 = 30000L;
                TestUtils$ retry_this = TestUtils$.MODULE$;
                long l3 = 1L;
                long retry_startTime = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testDefaultClientQuotas$3(this, admin);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this.logger().underlying().isInfoEnabled()) {
                            String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l3).append(", and then retrying.").toString();
                            Object var31_14 = null;
                            retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                        }
                        Thread.sleep(l3);
                        l3 += package$.MODULE$.min(l3, 1000L);
                        continue;
                    }
                    break;
                }
                Object var13_9 = null;
                Object var18_13 = null;
                this.setConsumerByteRate(admin, defaultUser, 100L);
                long l4 = 30000L;
                TestUtils$ retry_this2 = TestUtils$.MODULE$;
                long l5 = 1L;
                long retry_startTime2 = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testDefaultClientQuotas$4(this, defaultUser, admin);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this2.logger().underlying().isInfoEnabled()) {
                            String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l5).append(", and then retrying.").toString();
                            Object var32_19 = null;
                            retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                        }
                        Thread.sleep(l5);
                        l5 += package$.MODULE$.min(l5, 1000L);
                        continue;
                    }
                    break;
                }
                Object var19_16 = null;
                Object var24_21 = null;
                this.setConsumerByteRate(admin, bobUser, 1000L);
                long l6 = 30000L;
                TestUtils$ retry_this3 = TestUtils$.MODULE$;
                long l7 = 1L;
                long retry_startTime3 = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testDefaultClientQuotas$5(this, defaultUser, bobUser, admin);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime3 > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this3.logger().underlying().isInfoEnabled()) {
                            String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l7).append(", and then retrying.").toString();
                            Object var33_28 = null;
                            retry_this3.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this3, (String)msgWithLogIdent_msg));
                        }
                        Thread.sleep(l7);
                        l7 += package$.MODULE$.min(l7, 1000L);
                        continue;
                    }
                    break;
                }
                Object var25_23 = null;
                Object var30_27 = null;
            }
        }
    }

    @Test
    public void testCreateClusterWithAdvertisedPortZero() {
        Function2 & Serializable brokerPropertyOverrides = (Function2 & Serializable)(nodes, x$4) -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)KafkaConfig$.MODULE$.ListenersProp(), (Object)new StringBuilder(14).append(nodes.externalListenerName().value()).append("://localhost:0").toString()), new Tuple2((Object)KafkaConfig$.MODULE$.AdvertisedListenersProp(), (Object)new StringBuilder(14).append(nodes.externalListenerName().value()).append("://localhost:0").toString())}));
        int x$3 = 1;
        Function1 & Serializable x$42 = (Function1 & Serializable)cluster -> {
            KRaftClusterTest.$anonfun$testCreateClusterWithAdvertisedPortZero$2(this, cluster);
            return BoxedUnit.UNIT;
        };
        this.doOnStartedKafkaCluster(x$3, 3, (Function2<TestKitNodes, BrokerNode, scala.collection.immutable.Map<String, String>>)brokerPropertyOverrides, (Function1<KafkaClusterTestKit, BoxedUnit>)x$42);
    }

    @Test
    public void testCreateClusterWithAdvertisedHostAndPortDifferentFromSocketServer() {
        Function2 & Serializable brokerPropertyOverrides = (Function2 & Serializable)(nodes, broker) -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)KafkaConfig$.MODULE$.ListenersProp(), (Object)new StringBuilder(14).append(nodes.externalListenerName().value()).append("://localhost:0").toString()), new Tuple2((Object)KafkaConfig$.MODULE$.AdvertisedListenersProp(), (Object)new StringBuilder(20).append(nodes.externalListenerName().value()).append("://advertised-host-").append(broker.id()).append(":").append(broker.id() + 100).toString()), new Tuple2((Object)KafkaConfig$.MODULE$.ClusterLinkEnableProp(), (Object)"false")}));
        int x$3 = 1;
        Function1 & Serializable x$4 = (Function1 & Serializable)cluster -> {
            KRaftClusterTest.$anonfun$testCreateClusterWithAdvertisedHostAndPortDifferentFromSocketServer$2(this, cluster);
            return BoxedUnit.UNIT;
        };
        this.doOnStartedKafkaCluster(x$3, 3, (Function2<TestKitNodes, BrokerNode, scala.collection.immutable.Map<String, String>>)brokerPropertyOverrides, (Function1<KafkaClusterTestKit, BoxedUnit>)x$4);
    }

    @Disabled
    @Test
    public void testCreateClusterInvalidMetadataVersion() {
        Assertions.assertEquals((Object)"Bootstrap metadata versions before 3.3-IV0 are not supported. Can't load metadata from testkit", (Object)Assertions.assertThrows(RuntimeException.class, () -> new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_2_7_IV0).setNumBrokerNodes(1).setNumControllerNodes(1).build()).build()).getMessage());
    }

    private void doOnStartedKafkaCluster(int numControllerNodes, int numBrokerNodes, Function2<TestKitNodes, BrokerNode, scala.collection.immutable.Map<String, String>> brokerPropertyOverrides, Function1<KafkaClusterTestKit, BoxedUnit> action) {
        TestKitNodes nodes = new TestKitNodes.Builder().setNumControllerNodes(numControllerNodes).setNumBrokerNodes(numBrokerNodes).build();
        nodes.brokerNodes().values().forEach(broker -> broker.propertyOverrides().putAll(CollectionConverters$.MODULE$.MapHasAsJava((Map)brokerPropertyOverrides.apply((Object)nodes, broker)).asJava()));
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(nodes).build();){
            cluster.format();
            cluster.startup();
            action.apply((Object)cluster);
        }
    }

    private int doOnStartedKafkaCluster$default$1() {
        return 1;
    }

    private DescribeClusterResponse sendDescribeClusterRequestToBoundPortUntilAllBrokersPropagated(ListenerName listenerName, FiniteDuration waitTime, KafkaClusterTestKit cluster) {
        long startTime = System.currentTimeMillis();
        scala.collection.immutable.Seq<BrokerServer> runningBrokerServers = this.waitForRunningBrokers(1, waitTime, cluster);
        FiniteDuration remainingWaitTime = waitTime.$minus(scala.concurrent.duration.package$.MODULE$.pairLongToDuration(new Tuple2((Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startTime)), (Object)TimeUnit.MILLISECONDS)));
        return this.sendDescribeClusterRequestToBoundPortUntilBrokersPropagated((BrokerServer)runningBrokerServers.head(), listenerName, cluster.nodes().brokerNodes().size(), remainingWaitTime);
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Seq<BrokerServer> waitForRunningBrokers(int count, FiniteDuration waitTime, KafkaClusterTestKit cluster) {
        void var5_9;
        Tuple2 tuple2;
        long l = 100L;
        long computeUntilTrue_waitTime = waitTime.toMillis();
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            scala.collection.immutable.Seq computeUntilTrue_result;
            if ((computeUntilTrue_result = KRaftClusterTest.getRunningBrokerServers$1(cluster)).nonEmpty()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var12_7 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Seq runningBrokerServers = (scala.collection.immutable.Seq)tuple22._1();
        Assertions.assertTrue((boolean)tuple22._2$mcZ$sp(), (String)new StringBuilder(82).append("After ").append(waitTime.toMillis()).append(" ms at least ").append(count).append(" broker(s) should be in RUNNING state, ").append("but only ").append(var5_9.size()).append(" broker(s) are.").toString());
        return var5_9;
    }

    /*
     * WARNING - void declaration
     */
    private DescribeClusterResponse sendDescribeClusterRequestToBoundPortUntilBrokersPropagated(BrokerServer destination, ListenerName listenerName, int expectedBrokerCount, FiniteDuration waitTime) {
        void var6_10;
        Tuple2 tuple2;
        long l = 100L;
        long computeUntilTrue_waitTime = waitTime.toMillis();
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            DescribeClusterResponse computeUntilTrue_result;
            if (KRaftClusterTest.$anonfun$sendDescribeClusterRequestToBoundPortUntilBrokersPropagated$2(expectedBrokerCount, computeUntilTrue_result = this.sendDescribeClusterRequestToBoundPort(destination.socketServer(), listenerName))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var13_8 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        DescribeClusterResponse describeClusterResponse = (DescribeClusterResponse)tuple22._1();
        Assertions.assertTrue((boolean)tuple22._2$mcZ$sp(), (String)new StringBuilder(62).append("After ").append(waitTime.toMillis()).append(" ms Broker is only aware of ").append(var6_10.nodes().size()).append(" brokers, ").append("but ").append(expectedBrokerCount).append(" are expected.").toString());
        return var6_10;
    }

    private DescribeClusterResponse sendDescribeClusterRequestToBoundPort(SocketServer destination, ListenerName listenerName) {
        return (DescribeClusterResponse)IntegrationTestUtils$.MODULE$.connectAndReceive(new DescribeClusterRequest.Builder(new DescribeClusterRequestData()).build(), destination, listenerName, ClassTag$.MODULE$.apply(DescribeClusterResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndPerformReassignment() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                HashMap<Integer, java.util.List<Integer>> assignments = new HashMap<Integer, java.util.List<Integer>>();
                assignments.put(Predef$.MODULE$.int2Integer(0), Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)));
                assignments.put(Predef$.MODULE$.int2Integer(1), Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)));
                assignments.put(Predef$.MODULE$.int2Integer(2), Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(0)));
                assignments.put(Predef$.MODULE$.int2Integer(3), Arrays.asList(Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1)));
                admin.createTopics(Collections.singletonList(new NewTopic("foo", assignments))).all().get();
                this.waitForTopicListing(admin, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"foo", (List)Nil$.MODULE$), (scala.collection.immutable.Seq<String>)Nil$.MODULE$);
                Assertions.assertEquals(Collections.emptyMap(), (Object)admin.listPartitionReassignments().reassignments().get());
                HashMap<TopicPartition, Optional<NewPartitionReassignment>> reassignments = new HashMap<TopicPartition, Optional<NewPartitionReassignment>>();
                reassignments.put(new TopicPartition("foo", 0), Optional.of(new NewPartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)))));
                reassignments.put(new TopicPartition("foo", 1), Optional.of(new NewPartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)))));
                reassignments.put(new TopicPartition("foo", 2), Optional.of(new NewPartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)))));
                reassignments.put(new TopicPartition("foo", 3), Optional.of(new NewPartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)))));
                admin.alterPartitionReassignments(reassignments).all().get();
                long l = 100L;
                long waitUntilTrue_waitTimeMs = 15000L;
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!KRaftClusterTest.$anonfun$testCreateClusterAndPerformReassignment$1(admin)) {
                    void waitUntilTrue_pause;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)"The reassignment never completed.");
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
                scala.collection.immutable.Seq<scala.collection.immutable.Seq<Object>> seq = Nil$.MODULE$;
                .colon.colon expectedMapping = new .colon.colon((Object)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 1, 0}))), (List)new .colon.colon((Object)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), (List)new .colon.colon((Object)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3}))), (List)new .colon.colon((Object)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 0, 1}))), (List)Nil$.MODULE$))));
                long l2 = 100L;
                long waitUntilTrue_waitTimeMs2 = 15000L;
                long waitUntilTrue_startTime2 = System.currentTimeMillis();
                while (true) {
                    void waitUntilTrue_pause;
                    boolean bl;
                    java.util.Map $anonfun$testCreateClusterAndPerformReassignment$3_topicInfoMap;
                    if (($anonfun$testCreateClusterAndPerformReassignment$3_topicInfoMap = (java.util.Map)admin.describeTopics(Collections.singleton("foo")).allTopicNames().get()).containsKey("foo")) {
                        seq = this.translatePartitionInfoToSeq(((TopicDescription)$anonfun$testCreateClusterAndPerformReassignment$3_topicInfoMap.get("foo")).partitions());
                        bl = expectedMapping.equals(seq);
                    } else {
                        bl = false;
                    }
                    Object var27_13 = null;
                    if (bl) break;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                        Assertions.fail((String)new StringBuilder(72).append("Timed out waiting for replica assignments for topic foo. ").append("Wanted: ").append(expectedMapping).append(". Got: ").append(seq).toString());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
                }
                long l3 = 60000L;
                TestUtils$ retry_this = TestUtils$.MODULE$;
                long l4 = 1L;
                long retry_startTime = System.currentTimeMillis();
                while (true) {
                    try {
                        this.checkReplicaManager(cluster, (List<Tuple2<Object, List<Object>>>)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, true, false, true}))), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, true, false, true}))), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, true, true, true}))), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)3), scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, false, true, true}))), (List)Nil$.MODULE$)))));
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this.logger().underlying().isInfoEnabled()) {
                            String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                            Object var26_20 = null;
                            retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                        }
                        Thread.sleep(l4);
                        l4 += package$.MODULE$.min(l4, 1000L);
                        continue;
                    }
                    break;
                }
                Object var20_15 = null;
                Object var25_19 = null;
            }
        }
    }

    private void checkReplicaManager(KafkaClusterTestKit cluster, List<Tuple2<Object, List<Object>>> expectedHosting) {
        expectedHosting.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$checkReplicaManager$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$9 -> {
            KRaftClusterTest.$anonfun$checkReplicaManager$2(cluster, x$9);
            return BoxedUnit.UNIT;
        });
    }

    private scala.collection.immutable.Seq<scala.collection.immutable.Seq<Object>> translatePartitionInfoToSeq(java.util.List<TopicPartitionInfo> partitions) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partitions).asScala().map((Function1 & Serializable)partition -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partition.replicas()).asScala().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.id()))).toSeq())).toSeq();
    }

    /*
     * WARNING - void declaration
     */
    private void waitForTopicListing(Admin admin, scala.collection.immutable.Seq<String> expectedPresent, scala.collection.immutable.Seq<String> expectedAbsent) {
        HashSet topicsNotFound = new HashSet();
        expectedPresent.foreach((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)topicsNotFound.add(x$1)));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            ((Iterable)admin.listTopics().names().get()).forEach(name -> topicsNotFound$1.remove(name));
            scala.collection.mutable.Set set = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)admin.listTopics().names().get()).asScala().filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)expectedAbsent$1.contains((Object)x$11)));
            if (topicsNotFound.isEmpty() && set.isEmpty()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)new StringBuilder(49).append("Failed to find topic(s): ").append(CollectionConverters$.MODULE$.SetHasAsScala(topicsNotFound).asScala()).append(" and NOT find topic(s): ").append(set).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private scala.collection.immutable.Seq<ApiError> incrementalAlter(Admin admin, scala.collection.immutable.Seq<Tuple2<ConfigResource, scala.collection.immutable.Seq<AlterConfigOp>>> changes) {
        HashMap configs = new HashMap();
        changes.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                ConfigResource resource = (ConfigResource)x0$1._1();
                scala.collection.immutable.Seq ops = (scala.collection.immutable.Seq)x0$1._2();
                return configs.put(resource, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ops).asJava());
            }
            throw new MatchError(null);
        });
        java.util.Map values = admin.incrementalAlterConfigs(configs).values();
        return (scala.collection.immutable.Seq)changes.map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                ConfigResource resource = (ConfigResource)x0$2._1();
                try {
                    ((KafkaFuture)values.get(resource)).get();
                    return ApiError.NONE;
                }
                catch (ExecutionException executionException) {
                    return ApiError.fromThrowable((Throwable)executionException.getCause());
                }
                catch (Throwable throwable) {
                    return ApiError.fromThrowable((Throwable)throwable);
                }
            }
            throw new MatchError(null);
        });
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Map<ConfigResource, java.util.Map<String, String>> validateConfigs(Admin admin, scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>> expected, boolean exhaustive) {
        scala.collection.mutable.HashMap results = new scala.collection.mutable.HashMap();
        long l = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                KRaftClusterTest.$anonfun$validateConfigs$1(this, admin, expected, results, exhaustive);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var11_11 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var5_6 = null;
        Object var10_10 = null;
        return results.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private boolean validateConfigs$default$3() {
        return false;
    }

    @Test
    public void testIncrementalAlterConfigs() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)Nil$.MODULE$), this.incrementalAlter(admin, (scala.collection.immutable.Seq<Tuple2<ConfigResource, scala.collection.immutable.Seq<AlterConfigOp>>>)new .colon.colon((Object)new Tuple2((Object)new ConfigResource(ConfigResource.Type.BROKER, ""), (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("log.roll.ms", "1234567"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("max.connections.per.ip", "100"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.BROKER, "")), (Object)new .colon.colon((Object)new Tuple2((Object)"log.roll.ms", (Object)"1234567"), (List)new .colon.colon((Object)new Tuple2((Object)"max.connections.per.ip", (Object)"100"), (List)Nil$.MODULE$)))}))), true);
                admin.createTopics(Arrays.asList(new NewTopic("foo", 2, (short)3), new NewTopic("bar", 2, (short)3))).all().get();
                TestUtils$.MODULE$.waitForAllPartitionsMetadata(CollectionConverters$.MODULE$.CollectionHasAsScala(cluster.brokers().values()).asScala().toSeq(), "foo", 2);
                TestUtils$.MODULE$.waitForAllPartitionsMetadata(CollectionConverters$.MODULE$.CollectionHasAsScala(cluster.brokers().values()).asScala().toSeq(), "bar", 2);
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "bar")), (Object)Nil$.MODULE$)}))), false);
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)new .colon.colon((Object)new ApiError(Errors.INVALID_CONFIG, "Unknown topic config name: not.a.real.topic.config"), (List)new .colon.colon((Object)new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION, "The topic 'baz' does not exist."), (List)Nil$.MODULE$))), this.incrementalAlter(admin, (scala.collection.immutable.Seq<Tuple2<ConfigResource, scala.collection.immutable.Seq<AlterConfigOp>>>)new .colon.colon((Object)new Tuple2((Object)new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("segment.jitter.ms", "345"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new Tuple2((Object)new ConfigResource(ConfigResource.Type.TOPIC, "bar"), (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("not.a.real.topic.config", "789"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new Tuple2((Object)new ConfigResource(ConfigResource.Type.TOPIC, "baz"), (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("segment.jitter.ms", "678"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "foo")), (Object)new .colon.colon((Object)new Tuple2((Object)"segment.jitter.ms", (Object)"345"), (List)Nil$.MODULE$))}))), false);
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)Nil$.MODULE$), this.incrementalAlter(admin, (scala.collection.immutable.Seq<Tuple2<ConfigResource, scala.collection.immutable.Seq<AlterConfigOp>>>)new .colon.colon((Object)new Tuple2((Object)new ConfigResource(ConfigResource.Type.BROKER, "2"), (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("max.connections.per.ip", "50"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.BROKER, "2")), (Object)new .colon.colon((Object)new Tuple2((Object)"max.connections.per.ip", (Object)"50"), (List)Nil$.MODULE$))}))), false);
            }
        }
    }

    @Test
    public void testSetLog4jConfigurations() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                new .colon.colon((Object)this.log(), (List)new .colon.colon((Object)this.log2(), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)x$12 -> {
                    x$12.debug("setting log4j");
                    return BoxedUnit.UNIT;
                });
                ConfigResource broker2 = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, "2");
                ConfigResource broker3 = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, "3");
                scala.collection.immutable.Map<ConfigResource, java.util.Map<String, String>> initialLog4j = this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker2), (Object)Nil$.MODULE$)}))), false);
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)new .colon.colon((Object)new ApiError(Errors.INVALID_REQUEST, "APPEND operation is not allowed for the BROKER_LOGGER resource"), (List)Nil$.MODULE$)), this.incrementalAlter(admin, (scala.collection.immutable.Seq<Tuple2<ConfigResource, scala.collection.immutable.Seq<AlterConfigOp>>>)new .colon.colon((Object)new Tuple2((Object)broker2, (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log().getName(), "TRACE"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log2().getName(), "TRACE"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)new Tuple2((Object)broker3, (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log().getName(), "TRACE"), AlterConfigOp.OpType.APPEND), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log2().getName(), "TRACE"), AlterConfigOp.OpType.APPEND), (List)Nil$.MODULE$))), (List)Nil$.MODULE$))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker2), (Object)new .colon.colon((Object)new Tuple2((Object)this.log().getName(), (Object)"TRACE"), (List)new .colon.colon((Object)new Tuple2((Object)this.log2().getName(), (Object)"TRACE"), (List)Nil$.MODULE$)))}))), false);
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)new .colon.colon((Object)new ApiError(Errors.INVALID_REQUEST, "SUBTRACT operation is not allowed for the BROKER_LOGGER resource"), (List)Nil$.MODULE$)), this.incrementalAlter(admin, (scala.collection.immutable.Seq<Tuple2<ConfigResource, scala.collection.immutable.Seq<AlterConfigOp>>>)new .colon.colon((Object)new Tuple2((Object)broker2, (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log().getName(), ""), AlterConfigOp.OpType.DELETE), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log2().getName(), ""), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)new Tuple2((Object)broker3, (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log().getName(), "TRACE"), AlterConfigOp.OpType.SUBTRACT), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log2().getName(), "TRACE"), AlterConfigOp.OpType.SUBTRACT), (List)Nil$.MODULE$))), (List)Nil$.MODULE$))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker2), (Object)new .colon.colon((Object)new Tuple2((Object)this.log().getName(), ((java.util.Map)initialLog4j.apply((Object)broker2)).get(this.log().getName())), (List)new .colon.colon((Object)new Tuple2((Object)this.log2().getName(), ((java.util.Map)initialLog4j.apply((Object)broker2)).get(this.log2().getName())), (List)Nil$.MODULE$)))}))), false);
            }
        }
    }

    public scala.collection.immutable.Seq<ApiError> legacyAlter(Admin admin, scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<ConfigEntry>> resources) {
        HashMap configs = new HashMap();
        resources.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                ConfigResource resource = (ConfigResource)x0$1._1();
                scala.collection.immutable.Seq entries = (scala.collection.immutable.Seq)x0$1._2();
                return configs.put(resource, new Config((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)entries).asJava()));
            }
            throw new MatchError(null);
        });
        java.util.Map values = admin.alterConfigs(configs).values();
        return ((IterableOnceOps)resources.map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                ConfigResource resource = (ConfigResource)x0$2._1();
                try {
                    ((KafkaFuture)values.get(resource)).get();
                    return ApiError.NONE;
                }
                catch (ExecutionException executionException) {
                    return ApiError.fromThrowable((Throwable)executionException.getCause());
                }
                catch (Throwable throwable) {
                    return ApiError.fromThrowable((Throwable)throwable);
                }
            }
            throw new MatchError(null);
        })).toSeq();
    }

    @Test
    public void testLegacyAlterConfigs() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                ConfigResource defaultBroker = new ConfigResource(ConfigResource.Type.BROKER, "");
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)Nil$.MODULE$), this.legacyAlter(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<ConfigEntry>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultBroker), (Object)new .colon.colon((Object)new ConfigEntry("log.roll.ms", "1234567"), (List)new .colon.colon((Object)new ConfigEntry("max.connections.per.ip", "6"), (List)Nil$.MODULE$)))})))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultBroker), (Object)new .colon.colon((Object)new Tuple2((Object)"log.roll.ms", (Object)"1234567"), (List)new .colon.colon((Object)new Tuple2((Object)"max.connections.per.ip", (Object)"6"), (List)Nil$.MODULE$)))}))), true);
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)Nil$.MODULE$), this.legacyAlter(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<ConfigEntry>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultBroker), (Object)new .colon.colon((Object)new ConfigEntry("log.roll.ms", "1234567"), (List)Nil$.MODULE$))})))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultBroker), (Object)new .colon.colon((Object)new Tuple2((Object)"log.roll.ms", (Object)"1234567"), (List)Nil$.MODULE$))}))), true);
                admin.createTopics(Arrays.asList(new NewTopic("foo", 2, (short)3), new NewTopic("bar", 2, (short)3))).all().get();
                TestUtils$.MODULE$.waitForAllPartitionsMetadata(CollectionConverters$.MODULE$.CollectionHasAsScala(cluster.brokers().values()).asScala().toSeq(), "foo", 2);
                TestUtils$.MODULE$.waitForAllPartitionsMetadata(CollectionConverters$.MODULE$.CollectionHasAsScala(cluster.brokers().values()).asScala().toSeq(), "bar", 2);
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)new .colon.colon((Object)new ApiError(Errors.INVALID_CONFIG, "Unknown topic config name: not.a.real.topic.config"), (List)new .colon.colon((Object)new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION, "The topic 'baz' does not exist."), (List)Nil$.MODULE$))), this.legacyAlter(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<ConfigEntry>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "foo")), (Object)new .colon.colon((Object)new ConfigEntry("segment.jitter.ms", "345"), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "bar")), (Object)new .colon.colon((Object)new ConfigEntry("not.a.real.topic.config", "789"), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "baz")), (Object)new .colon.colon((Object)new ConfigEntry("segment.jitter.ms", "678"), (List)Nil$.MODULE$))})))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "foo")), (Object)new .colon.colon((Object)new Tuple2((Object)"segment.jitter.ms", (Object)"345"), (List)Nil$.MODULE$))}))), false);
            }
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"3.7-IV0", "3.7-IV2"})
    public void testCreatePartitions(String metadataVersionString) {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setBootstrapMetadataVersion(MetadataVersion.fromVersionString((String)metadataVersionString)).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                java.util.Map createResults = admin.createTopics(Arrays.asList(new NewTopic("foo", 1, (short)3), new NewTopic("bar", 2, (short)3))).values();
                ((KafkaFuture)createResults.get("foo")).get();
                ((KafkaFuture)createResults.get("bar")).get();
                java.util.Map increaseResults = admin.createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)NewPartitions.increaseTo((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)NewPartitions.increaseTo((int)2))}))).asJava()).values();
                ((KafkaFuture)increaseResults.get("foo")).get();
                Assertions.assertEquals(InvalidPartitionsException.class, Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)increaseResults.get("bar")).get()).getCause().getClass());
            }
        }
    }

    @Test
    public void testShouldApplyCreateTopicsPolicyToCreatePartitions() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).setConfigProp("confluent.apply.create.topic.policy.to.create.partitions", "true").setConfigProp(KafkaConfig$.MODULE$.CreateTopicPolicyClassNameProp(), KRaftClusterTestCreateTopicPolicy.class.getCanonicalName()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                java.util.Map createResults = admin.createTopics(Arrays.asList(new NewTopic("foo", 1, (short)3), new NewTopic("bar", 2, (short)3), new NewTopic("baz", 4, (short)3))).values();
                ((KafkaFuture)createResults.get("foo")).get();
                ((KafkaFuture)createResults.get("bar")).get();
                Assertions.assertEquals(PolicyViolationException.class, Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)createResults.get("baz")).get()).getCause().getClass());
                java.util.Map increaseResults = admin.createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)NewPartitions.increaseTo((int)5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)NewPartitions.increaseTo((int)4))}))).asJava()).values();
                Assertions.assertEquals(PolicyViolationException.class, Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)increaseResults.get("foo")).get()).getCause().getClass());
                ((KafkaFuture)increaseResults.get("bar")).get();
            }
        }
    }

    private ClusterImage clusterImage(KafkaClusterTestKit cluster, int brokerId) {
        return cluster.brokers().get(BoxesRunTime.boxToInteger((int)brokerId)).metadataCache().currentImage().cluster();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"3.7-IV0", "3.7-IV2"})
    public void testConfluentReplicaAssignor(String metadataVersionString) {
        Uuid assignorDataUuid = Uuid.randomUuid();
        KRaftClusterTestTopicReplicaAssignor.Data assignorData = new KRaftClusterTestTopicReplicaAssignor.Data();
        KRaftClusterTestTopicReplicaAssignor$.MODULE$.instanceDataMap().put(assignorDataUuid, assignorData);
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setBootstrapMetadataVersion(MetadataVersion.fromVersionString((String)metadataVersionString)).setNumControllerNodes(3).build()).setConfigProp("confluent.topic.replica.assignor.builder.class", KRaftClusterTestTopicReplicaAssignorBuilder.class.getCanonicalName()).setConfigProp(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false").setConfigProp(KafkaConfig$.MODULE$.BrokerSessionUuidProp(), assignorDataUuid.toString()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                TopicDescription topicDescription;
                admin.createTopics(Arrays.asList(new NewTopic("foo", 2, (short)3), new NewTopic("bar", 4, (short)3))).all().get();
                admin.createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)NewPartitions.increaseTo((int)3))}))).asJava()).all().get();
                long l = 30000L;
                TestUtils$ retry_this = TestUtils$.MODULE$;
                long l2 = 1L;
                long retry_startTime = System.currentTimeMillis();
                while (true) {
                    try {
                        try {
                            topicDescription = (TopicDescription)((KafkaFuture)admin.describeTopics(Arrays.asList("foo")).topicNameValues().get("foo")).get();
                        }
                        catch (Exception $anonfun$testConfluentReplicaAssignor$1_e) {
                            throw new AssertionError($anonfun$testConfluentReplicaAssignor$1_e.getMessage(), $anonfun$testConfluentReplicaAssignor$1_e);
                        }
                        Assertions.assertEquals((int)3, (int)topicDescription.partitions().size());
                        Object var15_14 = null;
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this.logger().underlying().isInfoEnabled()) {
                            String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                            Object var14_15 = null;
                            retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                        }
                        Thread.sleep(l2);
                        l2 += package$.MODULE$.min(l2, 1000L);
                        continue;
                    }
                    break;
                }
                Object var8_7 = null;
                Object var13_11 = null;
                Assertions.assertEquals((Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0, 2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)topicDescription.partitions().get(0)).replicas()).asScala().map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.id())));
                Assertions.assertEquals((Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)topicDescription.partitions().get(1)).replicas()).asScala().map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.id())));
                Assertions.assertEquals((Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0, 2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)topicDescription.partitions().get(2)).replicas()).asScala().map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.id())));
                Assertions.assertEquals((int)2, (int)assignorData.computeAssignmentForNewTopicCalled().get());
                Assertions.assertEquals((int)1, (int)assignorData.computeAssignmentForExistingTopicCalled().get());
            }
        }
    }

    private boolean brokerIsUnfenced(ClusterImage image, int brokerId) {
        Option option = Option$.MODULE$.apply(image.brokers().get(BoxesRunTime.boxToInteger((int)brokerId)));
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            return !((BrokerRegistration)((Some)option).value()).fenced();
        }
        throw new MatchError((Object)option);
    }

    private boolean brokerIsAbsent(ClusterImage image, int brokerId) {
        return Option$.MODULE$.apply(image.brokers().get(BoxesRunTime.boxToInteger((int)brokerId))).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUnregisterBroker() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!this.brokerIsUnfenced(this.clusterImage(cluster, 1), 0)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for broker 0 to be unfenced.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            cluster.brokers().get(BoxesRunTime.boxToInteger((int)0)).shutdown();
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testUnregisterBroker$3(this, cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"Timed out waiting for broker 0 to be fenced.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.unregisterBroker(0);
            }
            long l3 = 100L;
            long waitUntilTrue_waitTimeMs3 = 15000L;
            long waitUntilTrue_startTime3 = System.currentTimeMillis();
            while (!this.brokerIsAbsent(this.clusterImage(cluster, 1), 0)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                    Assertions.fail((String)"Timed out waiting for broker 0 to be fenced.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
            }
        }
    }

    @Test
    public void testConfluentSpecificTopicValidationChanges() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(3).setNumControllerNodes(3).build()).setConfigProp(KafkaConfig$.MODULE$.TierFeatureProp(), "true").setConfigProp(KafkaConfig$.MODULE$.TierEnableProp(), "true").setConfigProp(KafkaConfig$.MODULE$.TierCleanerEnableProp(), "true").setConfigProp(KafkaConfig$.MODULE$.TierBackendProp(), "mock").build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.createTopics(Arrays.asList(new NewTopic("foo", 2, (short)3))).all().get();
                Assertions.assertEquals(InvalidConfigurationException.class, Assertions.assertThrows(ExecutionException.class, () -> admin.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), Collections.singletonList(new AlterConfigOp(new ConfigEntry("cleanup.policy", "compact,delete"), AlterConfigOp.OpType.SET)))).all().get()).getCause().getClass());
            }
        }
    }

    public ConfluentAdmin createAdminClient(KafkaClusterTestKit cluster, boolean useController) {
        Properties props = cluster.newClientPropertiesBuilder().setUsingBootstrapControllers(useController).build();
        props.put("client.id", this.getClass().getName());
        return (ConfluentAdmin)Admin.create((Properties)props);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @CsvSource(value={"4,false", "4,true", "0,true"})
    public void testDescribeQuorumRequestToBrokers(int numBrokers, boolean useController) {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(numBrokers).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            CollectionConverters$.MODULE$.CollectionHasAsScala(cluster.brokers().values()).asScala().foreach((Function1 & Serializable)broker -> {
                KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$1(broker);
                return BoxedUnit.UNIT;
            });
            CollectionConverters$.MODULE$.CollectionHasAsScala(cluster.controllers().values()).asScala().foreach((Function1 & Serializable)controller -> {
                KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$4(controller);
                return BoxedUnit.UNIT;
            });
            try (ConfluentAdmin admin = this.createAdminClient(cluster, useController);){
                void var9_20;
                Tuple2 tuple2;
                void var7_14;
                Tuple2 tuple22;
                long l = 100L;
                long waitUntilTrue_waitTimeMs = 15000L;
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$7(cluster)) {
                    void waitUntilTrue_pause;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)"Timed out waiting for controllers to begin replicating log");
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
                QuorumInfo quorumInfo = (QuorumInfo)admin.describeMetadataQuorum(new DescribeMetadataQuorumOptions()).quorumInfo().get();
                Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsScala(cluster.controllers()).asScala().keySet(), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(quorumInfo.voters()).asScala().map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToInteger((int)x$16.replicaId()))).toSet());
                Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.MapHasAsScala(cluster.controllers()).asScala().keySet().contains((Object)Predef$.MODULE$.int2Integer(quorumInfo.leaderId())), (String)new StringBuilder(35).append("Leader ID ").append(quorumInfo.leaderId()).append(" was not a controller ID.").toString());
                long l2 = 100L;
                long computeUntilTrue_waitTime = 15000L;
                long computeUntilTrue_startTime = System.currentTimeMillis();
                while (true) {
                    void computeUntilTrue_pause;
                    java.util.List computeUntilTrue_result;
                    if (KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$12(computeUntilTrue_result = KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$11(admin))) {
                        tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                        break;
                    }
                    if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                        tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                        break;
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
                }
                Object var24_12 = null;
                Tuple2 tuple23 = tuple22;
                if (tuple23 == null) {
                    throw new MatchError(null);
                }
                java.util.List voters = (java.util.List)tuple23._1();
                Assertions.assertTrue((boolean)tuple23._2$mcZ$sp(), (String)new StringBuilder(111).append("At least one voter did not return the expected state within timeout.").append("The responses gathered for all the voters: ").append(var7_14.toString()).toString());
                long l3 = 100L;
                long computeUntilTrue_waitTime2 = 15000L;
                long computeUntilTrue_startTime2 = System.currentTimeMillis();
                while (true) {
                    void computeUntilTrue_pause;
                    java.util.List computeUntilTrue_result;
                    if (KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$15(cluster, computeUntilTrue_result = KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$14(admin))) {
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                        break;
                    }
                    if (System.currentTimeMillis() > computeUntilTrue_startTime2 + computeUntilTrue_waitTime2) {
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                        break;
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime2), (long)computeUntilTrue_pause));
                }
                Object var31_18 = null;
                Tuple2 tuple24 = tuple2;
                if (tuple24 == null) {
                    throw new MatchError(null);
                }
                java.util.List observers = (java.util.List)tuple24._1();
                Assertions.assertTrue((boolean)tuple24._2$mcZ$sp(), (String)new StringBuilder(117).append("At least one observer did not return the expected state within timeout.").append("The responses gathered for all the observers: ").append(var9_20.toString()).toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUpdateMetadataVersion() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.MINIMUM_BOOTSTRAP_VERSION).setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.updateFeatures(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.metadata.version"), (Object)new FeatureUpdate(MetadataVersion.latestTesting().confluentFeatureLevel(), FeatureUpdate.UpgradeType.UPGRADE))}))).asJava(), new UpdateFeaturesOptions());
            }
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testUpdateMetadataVersion$1(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for metadata version update.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
    }

    @Test
    public void testAuthorizerFailureFoundInControllerStartup() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumControllerNodes(3).build()).setConfigProp("authorizer.class.name", BadAuthorizer.class.getName()).build();){
            cluster.format();
            ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> cluster.startup());
            Assertions.assertEquals((Object)"java.lang.IllegalStateException: test authorizer exception", (Object)exception.getMessage());
            cluster.fatalFaultHandler().setIgnore(true);
        }
    }

    @Test
    public void testBrokerSessionUuidPropagated() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.MINIMUM_BOOTSTRAP_VERSION).setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            BrokerServer broker = cluster.brokers().values().iterator().next();
            Assertions.assertEquals((Object)broker.sharedServer().sharedServerConfig().brokerSessionUuid(), (Object)broker.config().brokerSessionUuid());
            ControllerServer controller = cluster.controllers().values().iterator().next();
            Assertions.assertEquals((Object)controller.sharedServer().sharedServerConfig().brokerSessionUuid(), (Object)controller.config().brokerSessionUuid());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndCreateTopicWithRemoteLogManagerInstantiation() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).setConfigProp("remote.log.storage.system.enable", Boolean.toString(true)).setConfigProp("remote.log.metadata.manager.class.name", "org.apache.kafka.server.log.remote.storage.NoOpRemoteLogMetadataManager").setConfigProp("remote.log.storage.manager.class.name", "org.apache.kafka.server.log.remote.storage.NoOpRemoteStorageManager").build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateTopicWithRemoteLogManagerInstantiation$1(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Broker never made it to RUNNING state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateTopicWithRemoteLogManagerInstantiation$3(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"RaftManager was not initialized.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                java.util.List<NewTopic> newTopic = Collections.singletonList(new NewTopic("test-topic", 1, (short)1));
                admin.createTopics(newTopic).all().get();
                this.waitForTopicListing(admin, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"test-topic", (List)Nil$.MODULE$), (scala.collection.immutable.Seq<String>)Nil$.MODULE$);
                admin.deleteTopics(Collections.singletonList("test-topic")).all().get();
                this.waitForTopicListing(admin, (scala.collection.immutable.Seq<String>)Nil$.MODULE$, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"test-topic", (List)Nil$.MODULE$));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSnapshotCount() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp("metadata.log.max.snapshot.interval.ms", "500").setConfigProp("metadata.max.idle.interval.ms", "50").build();){
            cluster.format();
            cluster.startup();
            Path metaLog = FileSystems.getDefault().getPath(cluster.controllers().get(BoxesRunTime.boxToInteger((int)3000)).config().metadataLogDir(), "__cluster_metadata-0");
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testSnapshotCount$2(metaLog)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Failed to see at least one snapshot");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Thread.sleep(5000L);
            long countAfterTenIntervals = KRaftClusterTest.snapshotCounter$1(metaLog);
            Assertions.assertTrue((countAfterTenIntervals > 1L ? 1 : 0) != 0, (String)new StringBuilder(48).append("Expected to see at least one more snapshot, saw ").append(countAfterTenIntervals).toString());
            Assertions.assertTrue((countAfterTenIntervals < 20L ? 1 : 0) != 0, (String)new StringBuilder(83).append("Did not expect to see more than twice as many snapshots as snapshot intervals, saw ").append(countAfterTenIntervals).toString());
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testSnapshotCount$4(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"Failed to see latestSnapshotGeneratedBytes > 0");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
        }
    }

    @Test
    public void testMetadataEncryptorEnabled() {
        KafkaClusterTestKit.Builder builder = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setBootstrapMetadataVersion(MetadataVersion.latestTesting()).setNumControllerNodes(1).build());
        MetadataEncryptorFactoryTest.TEST_LEGACY_CONFIG.forEach((k, v) -> builder.setConfigProp((String)k, v.toString()));
        try (KafkaClusterTestKit cluster = builder.build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)Nil$.MODULE$), this.incrementalAlter(admin, (scala.collection.immutable.Seq<Tuple2<ConfigResource, scala.collection.immutable.Seq<AlterConfigOp>>>)new .colon.colon((Object)new Tuple2((Object)new ConfigResource(ConfigResource.Type.BROKER, ""), (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("log.roll.ms", "1234567"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("max.connections.per.ip", "100"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.BROKER, "")), (Object)new .colon.colon((Object)new Tuple2((Object)"log.roll.ms", (Object)"1234567"), (List)new .colon.colon((Object)new Tuple2((Object)"max.connections.per.ip", (Object)"100"), (List)Nil$.MODULE$)))}))), true);
            }
        }
    }

    @Test
    public void testSingleControllerSingleBrokerCluster() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.MINIMUM_BOOTSTRAP_VERSION).setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testReconfigureControllerClientQuotas(boolean combinedController) {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setCombined(combinedController).setNumControllerNodes(1).build()).setConfigProp("client.quota.callback.class", DummyClientQuotaCallback.class.getName()).setConfigProp(DummyClientQuotaCallback$.MODULE$.dummyClientQuotaCallbackValueConfigKey(), "0").build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            KRaftClusterTest.assertConfigValue$1(0, cluster);
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), Collections.singletonList(new AlterConfigOp(new ConfigEntry(DummyClientQuotaCallback$.MODULE$.dummyClientQuotaCallbackValueConfigKey(), "1"), AlterConfigOp.OpType.SET)))).all().get();
            }
            KRaftClusterTest.assertConfigValue$1(1, cluster);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testReconfigureControllerAuthorizer(boolean combinedMode) {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setCombined(combinedMode).setNumControllerNodes(1).build()).setConfigProp("authorizer.class.name", FakeConfigurableAuthorizer.class.getName()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            KRaftClusterTest.assertFoobarValue$1(0, cluster);
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), Collections.singletonList(new AlterConfigOp(new ConfigEntry(FakeConfigurableAuthorizer$.MODULE$.foobarConfigKey(), "123"), AlterConfigOp.OpType.SET)))).all().get();
            }
            KRaftClusterTest.assertFoobarValue$1(123, cluster);
        }
    }

    @Test
    public void testOverlyLargeCreateTopics() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                ArrayList newTopics = new ArrayList();
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 10000).foreach((Function1)(JFunction1.mcZI.sp & Serializable)i -> newTopics.add(new NewTopic(new StringBuilder(3).append("foo").append(i).toString(), 100000, (short)1)));
                ExecutionException executionException = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> admin.createTopics((Collection)newTopics).all().get());
                Assertions.assertNotNull((Object)executionException.getCause());
                Assertions.assertEquals(PolicyViolationException.class, executionException.getCause().getClass());
                Assertions.assertEquals((Object)"Unable to perform excessively large batch operation.", (Object)executionException.getCause().getMessage());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTimedOutHeartbeats() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(3).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.BrokerHeartbeatIntervalMsProp(), Integer.toString(10)).setConfigProp(KafkaConfig$.MODULE$.BrokerSessionTimeoutMsProp(), Integer.toString(1000)).build();){
            cluster.format();
            cluster.startup();
            ControllerServer controller = cluster.controllers().values().iterator().next();
            controller.controller().waitForReadyBrokers(3).get();
            long l = 60000L;
            TestUtils$ retry_this = TestUtils$.MODULE$;
            long l2 = 1L;
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    KRaftClusterTest.$anonfun$testTimedOutHeartbeats$1(controller);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                        Object var10_9 = null;
                        retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(l2);
                    l2 += package$.MODULE$.min(l2, 1000L);
                    continue;
                }
                break;
            }
            Object var4_4 = null;
            Object var9_8 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRegisteredControllerEndpoints() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(3).build()).setConfigProp("confluent.internal.rest.server.bind.port", "0").build();){
            cluster.format();
            cluster.startup();
            long l = 60000L;
            TestUtils$ retry_this = TestUtils$.MODULE$;
            long l2 = 1L;
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    KRaftClusterTest.$anonfun$testRegisteredControllerEndpoints$1(this, cluster);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                        Object var9_8 = null;
                        retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(l2);
                    l2 += package$.MODULE$.min(l2, 1000L);
                    continue;
                }
                break;
            }
            Object var3_3 = null;
            Object var8_7 = null;
        }
    }

    @Test
    public void testDirectToControllerCommunicationFailsOnOlderMetadataVersion() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_6_IV2).setNumBrokerNodes(1).setNumControllerNodes(1).build()).setConfigProp("confluent.internal.rest.server.bind.port", "0").build();){
            cluster.format();
            cluster.startup();
            try (Admin admin = Admin.create((Properties)cluster.newClientPropertiesBuilder().setUsingBootstrapControllers(true).build());){
                this.checkReadinessAndRollableStatus(cluster.controllers().values().iterator().next());
                ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> admin.describeCluster().clusterId().get(1L, TimeUnit.MINUTES));
                Assertions.assertNotNull((Object)exception.getCause());
                Assertions.assertEquals(UnsupportedVersionException.class, exception.getCause().getClass());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void checkReadinessAndRollableStatus(ControllerServer controller) {
        long retry_maxWaitMs = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                KRaftClusterTest.$anonfun$checkReadinessAndRollableStatus$1(controller);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var14_8 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
        Object var2_3 = null;
        Object var7_7 = null;
        long l2 = 60000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        long l3 = 1L;
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                KRaftClusterTest.$anonfun$checkReadinessAndRollableStatus$2(controller);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs2;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs2) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l3).append(", and then retrying.").toString();
                    Object var15_14 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l3);
                l3 += package$.MODULE$.min(l3, 1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testStartupWithNonDefaultKControllerDynamicConfiguration() {
        java.util.List<ApiMessageAndVersion> bootstrapRecords = Arrays.asList(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("confluent.metadata.version").setFeatureLevel(MetadataVersion.IBP_3_7_IV0.confluentFeatureLevel()), (short)0), new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("").setName("num.io.threads").setValue("9"), (short)0));
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadata(BootstrapMetadata.fromRecords(bootstrapRecords, (String)"testRecords")).setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            ControllerServer controller = cluster.controllers().values().iterator().next();
            long l = 60000L;
            TestUtils$ retry_this = TestUtils$.MODULE$;
            long l2 = 1L;
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    KRaftClusterTest.$anonfun$testStartupWithNonDefaultKControllerDynamicConfiguration$1(controller);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                        Object var11_10 = null;
                        retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(l2);
                    l2 += package$.MODULE$.min(l2, 1000L);
                    continue;
                }
                break;
            }
            Object var5_5 = null;
            Object var10_9 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicDeletedAndRecreatedWhileBrokerIsDown() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_6_IV2).setNumBrokerNodes(3).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                BrokerServer broker0 = cluster.brokers().get(BoxesRunTime.boxToInteger((int)0));
                BrokerServer broker1 = cluster.brokers().get(BoxesRunTime.boxToInteger((int)1));
                TopicPartition foo0 = new TopicPartition("foo", 0);
                admin.createTopics(Arrays.asList(new NewTopic("foo", 3, (short)3))).all().get();
                long l = 60000L;
                TestUtils$ retry_this = TestUtils$.MODULE$;
                long l2 = 1L;
                long retry_startTime = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testTopicDeletedAndRecreatedWhileBrokerIsDown$1(broker0, foo0);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this.logger().underlying().isInfoEnabled()) {
                            String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                            Object var29_12 = null;
                            retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                        }
                        Thread.sleep(l2);
                        l2 += package$.MODULE$.min(l2, 1000L);
                        continue;
                    }
                    break;
                }
                Object var11_7 = null;
                Object var16_11 = null;
                broker0.shutdown();
                long l3 = 60000L;
                TestUtils$ retry_this2 = TestUtils$.MODULE$;
                long l4 = 1L;
                long retry_startTime2 = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testTopicDeletedAndRecreatedWhileBrokerIsDown$2(broker1);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this2.logger().underlying().isInfoEnabled()) {
                            String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                            Object var30_19 = null;
                            retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                        }
                        Thread.sleep(l4);
                        l4 += package$.MODULE$.min(l4, 1000L);
                        continue;
                    }
                    break;
                }
                Object var17_14 = null;
                Object var22_18 = null;
                LogManager qual$2 = broker0.logManager();
                boolean x$4 = qual$2.getLog$default$2();
                File logDir = ((AbstractLog)qual$2.getLog(foo0, x$4).get()).dir();
                Files.write(new File(logDir, "partition.metadata").toPath(), "version: 0\ntopic_id: AAAAAAAAAAAAA7SrBWaJ7g\n".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                broker0.startup();
                long l5 = 60000L;
                TestUtils$ retry_this3 = TestUtils$.MODULE$;
                long l6 = 1L;
                long retry_startTime3 = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testTopicDeletedAndRecreatedWhileBrokerIsDown$3(broker1);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime3 > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this3.logger().underlying().isInfoEnabled()) {
                            String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l6).append(", and then retrying.").toString();
                            Object var31_29 = null;
                            retry_this3.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this3, (String)msgWithLogIdent_msg));
                        }
                        Thread.sleep(l6);
                        l6 += package$.MODULE$.min(l6, 1000L);
                        continue;
                    }
                    break;
                }
                Object var23_24 = null;
                Object var28_28 = null;
            }
        }
    }

    @Test
    public void testReduceNumReplicaFetcherThreads() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(2).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.ReplicaFetchConnectionsModeProp(), "isolated").setConfigProp(KafkaConfig$.MODULE$.NumReplicaFetchersProp(), "4").build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.createTopics(Collections.singletonList(new NewTopic("foo", 1, (short)2))).all().get();
                admin.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), Collections.singletonList(new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.NumReplicaFetchersProp(), "2"), AlterConfigOp.OpType.SET)))).all().get();
                admin.createTopics(Collections.singletonList(new NewTopic("bar", 1, (short)2))).all().get();
                this.waitForTopicListing(admin, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"bar", (List)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)), (scala.collection.immutable.Seq<String>)Nil$.MODULE$);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAbandonedFutureReplicaRecovered_mainReplicaInOfflineLogDir() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_7_IV2).setBrokerNodes(3, 2).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                BrokerServer broker0 = cluster.brokers().get(BoxesRunTime.boxToInteger((int)0));
                BrokerServer broker1 = cluster.brokers().get(BoxesRunTime.boxToInteger((int)1));
                TopicPartition foo0 = new TopicPartition("foo", 0);
                admin.createTopics(Arrays.asList(new NewTopic("foo", 3, (short)3))).all().get();
                long l = 60000L;
                TestUtils$ retry_this = TestUtils$.MODULE$;
                long l2 = 1L;
                long retry_startTime = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOfflineLogDir$1(broker0, foo0);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this.logger().underlying().isInfoEnabled()) {
                            String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                            Object var28_10 = null;
                            retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                        }
                        Thread.sleep(l2);
                        l2 += package$.MODULE$.min(l2, 1000L);
                        continue;
                    }
                    break;
                }
                Object var10_7 = null;
                Object var15_12 = null;
                broker0.shutdown();
                long l3 = 60000L;
                TestUtils$ retry_this2 = TestUtils$.MODULE$;
                long l4 = 1L;
                long retry_startTime2 = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOfflineLogDir$2(broker1);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this2.logger().underlying().isInfoEnabled()) {
                            String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                            Object var29_19 = null;
                            retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                        }
                        Thread.sleep(l4);
                        l4 += package$.MODULE$.min(l4, 1000L);
                        continue;
                    }
                    break;
                }
                Object var16_14 = null;
                Object var21_18 = null;
                LogManager qual$2 = broker0.logManager();
                boolean x$4 = qual$2.getLog$default$2();
                ((AbstractLog)qual$2.getLog(foo0, x$4).get()).renameDir(LocalLog$.MODULE$.logFutureDirName(foo0), false);
                broker0.startup();
                long l5 = 60000L;
                TestUtils$ retry_this3 = TestUtils$.MODULE$;
                long l6 = 1L;
                long retry_startTime3 = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOfflineLogDir$3(broker1, broker0, foo0);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime3 > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this3.logger().underlying().isInfoEnabled()) {
                            String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l6).append(", and then retrying.").toString();
                            Object var30_28 = null;
                            retry_this3.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this3, (String)msgWithLogIdent_msg));
                        }
                        Thread.sleep(l6);
                        l6 += package$.MODULE$.min(l6, 1000L);
                        continue;
                    }
                    break;
                }
                Object var22_23 = null;
                Object var27_27 = null;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAbandonedFutureReplicaRecovered_mainReplicaInOnlineLogDir() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_7_IV2).setBrokerNodes(3, 2).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                BrokerServer broker0 = cluster.brokers().get(BoxesRunTime.boxToInteger((int)0));
                BrokerServer broker1 = cluster.brokers().get(BoxesRunTime.boxToInteger((int)1));
                TopicPartition foo0 = new TopicPartition("foo", 0);
                admin.createTopics(Arrays.asList(new NewTopic("foo", 3, (short)3))).all().get();
                long l = 60000L;
                TestUtils$ retry_this = TestUtils$.MODULE$;
                long l2 = 1L;
                long retry_startTime = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOnlineLogDir$1(broker0, foo0);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this.logger().underlying().isInfoEnabled()) {
                            String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                            Object var33_10 = null;
                            retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                        }
                        Thread.sleep(l2);
                        l2 += package$.MODULE$.min(l2, 1000L);
                        continue;
                    }
                    break;
                }
                Object var15_7 = null;
                Object var20_12 = null;
                broker0.shutdown();
                long l3 = 60000L;
                TestUtils$ retry_this2 = TestUtils$.MODULE$;
                long l4 = 1L;
                long retry_startTime2 = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOnlineLogDir$2(broker1);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this2.logger().underlying().isInfoEnabled()) {
                            String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                            Object var34_17 = null;
                            retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                        }
                        Thread.sleep(l4);
                        l4 += package$.MODULE$.min(l4, 1000L);
                        continue;
                    }
                    break;
                }
                Object var21_14 = null;
                Object var26_19 = null;
                LogManager qual$2 = broker0.logManager();
                boolean x$4 = qual$2.getLog$default$2();
                AbstractLog log = (AbstractLog)qual$2.getLog(foo0, x$4).get();
                String parentDir = log.parentDir();
                String targetParentDir = (String)((IterableOps)broker0.config().logDirs().filter((Function1 & Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOnlineLogDir$3(parentDir, x$21)))).head();
                File targetDirFile = new File(targetParentDir, log.dir().getName());
                FileUtils.copyDirectory((File)log.dir(), (File)targetDirFile);
                Assertions.assertTrue((boolean)targetDirFile.exists());
                File originalLogFile = log.dir();
                log.renameDir(LocalLog$.MODULE$.logFutureDirName(foo0), false);
                Assertions.assertFalse((boolean)originalLogFile.exists());
                broker0.startup();
                long l5 = 60000L;
                TestUtils$ retry_this3 = TestUtils$.MODULE$;
                long l6 = 1L;
                long retry_startTime3 = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOnlineLogDir$4(broker1, broker0, foo0, targetDirFile, originalLogFile);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime3 > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this3.logger().underlying().isInfoEnabled()) {
                            String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l6).append(", and then retrying.").toString();
                            Object var35_33 = null;
                            retry_this3.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this3, (String)msgWithLogIdent_msg));
                        }
                        Thread.sleep(l6);
                        l6 += package$.MODULE$.min(l6, 1000L);
                        continue;
                    }
                    break;
                }
                Object var27_28 = null;
                Object var32_32 = null;
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndRestartControllerNode$1(ControllerServer x$1) {
        return x$1.controller().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndRestartControllerNode$3(ControllerServer x$2) {
        return x$2.controller().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndRestartControllerNode$2(KafkaClusterTestKit cluster$1) {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(cluster$1.controllers().values().iterator()).asScala().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testCreateClusterAndRestartControllerNode$3(x$2)));
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndRestartControllerNode$4() {
        return "Timeout waiting for new controller election";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndWaitForBrokerInRunningState$1(KafkaClusterTestKit cluster$2) {
        BrokerState brokerState = cluster$2.brokers().get(BoxesRunTime.boxToInteger((int)0)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndWaitForBrokerInRunningState$2() {
        return "Broker never made it to RUNNING state.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndWaitForBrokerInRunningState$3(KafkaClusterTestKit cluster$2) {
        return cluster$2.raftManagers().get(BoxesRunTime.boxToInteger((int)0)).client().leaderAndEpoch().leaderId().isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndWaitForBrokerInRunningState$4() {
        return "RaftManager was not initialized.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateListDeleteTopic$1(KafkaClusterTestKit cluster$3) {
        BrokerState brokerState = cluster$3.brokers().get(BoxesRunTime.boxToInteger((int)0)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateListDeleteTopic$2() {
        return "Broker never made it to RUNNING state.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateListDeleteTopic$3(KafkaClusterTestKit cluster$3) {
        return cluster$3.raftManagers().get(BoxesRunTime.boxToInteger((int)0)).client().leaderAndEpoch().leaderId().isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateListDeleteTopic$4() {
        return "RaftManager was not initialized.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateAndManyTopics$1(KafkaClusterTestKit cluster$4) {
        BrokerState brokerState = cluster$4.brokers().get(BoxesRunTime.boxToInteger((int)0)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateAndManyTopics$2() {
        return "Broker never made it to RUNNING state.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateAndManyTopics$3(KafkaClusterTestKit cluster$4) {
        return cluster$4.raftManagers().get(BoxesRunTime.boxToInteger((int)0)).client().leaderAndEpoch().leaderId().isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateAndManyTopics$4() {
        return "RaftManager was not initialized.";
    }

    public static final /* synthetic */ boolean $anonfun$testClientQuotas$1(KafkaClusterTestKit cluster$5) {
        BrokerState brokerState = cluster$5.brokers().get(BoxesRunTime.boxToInteger((int)0)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testClientQuotas$2() {
        return "Broker never made it to RUNNING state.";
    }

    private static final java.util.Map describeOrFail$1(ClientQuotaFilter filter, Admin admin$1) {
        try {
            return (java.util.Map)admin$1.describeClientQuotas(filter).entities().get();
        }
        catch (Throwable t) {
            return (java.util.Map)Assertions.fail((String)"DescribeClientQuotas request failed", (Throwable)t);
        }
    }

    public static final /* synthetic */ java.util.Map $anonfun$testClientQuotas$3(ClientQuotaFilter filter$1, Admin admin$1) {
        return KRaftClusterTest.describeOrFail$1(filter$1, admin$1);
    }

    public static final /* synthetic */ boolean $anonfun$testClientQuotas$4(ClientQuotaEntity entity$1, int expectCount$1, java.util.Map results) {
        return results.getOrDefault(entity$1, Collections.emptyMap()).size() == expectCount$1;
    }

    /*
     * WARNING - void declaration
     */
    private static final java.util.Map alterThenDescribe$1(ClientQuotaEntity entity, scala.collection.immutable.Seq quotas, ClientQuotaFilter filter, int expectCount, Admin admin$1) {
        void var7_11;
        Tuple2 tuple2;
        try {
            admin$1.alterClientQuotas((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration(entity, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)quotas).asJava()), (List)Nil$.MODULE$)).asJava()).all().get();
        }
        catch (Throwable t) {
            Assertions.fail((String)"AlterClientQuotas request failed", (Throwable)t);
        }
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            java.util.Map computeUntilTrue_result;
            if (KRaftClusterTest.$anonfun$testClientQuotas$4(entity, expectCount, computeUntilTrue_result = KRaftClusterTest.describeOrFail$1(filter, admin$1))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var14_9 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        java.util.Map describeResult = (java.util.Map)tuple22._1();
        Assertions.assertTrue((boolean)tuple22._2$mcZ$sp(), (String)"Broker never saw new client quotas");
        return var7_11;
    }

    public static final /* synthetic */ void $anonfun$testClientQuotas$5(Admin admin$1, ObjectRef filter$2, ClientQuotaEntity entity$2, ClientQuotaEntity entity2$1) {
        java.util.Map results = (java.util.Map)admin$1.describeClientQuotas((ClientQuotaFilter)filter$2.elem).entities().get();
        Assertions.assertEquals((int)2, (int)results.size(), (String)"Broker did not see two client quotas");
        Assertions.assertEquals((double)9999.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)results.get(entity$2)).get("producer_byte_rate")), (double)1.0E-6);
        Assertions.assertEquals((double)9998.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)results.get(entity2$1)).get("producer_byte_rate")), (double)1.0E-6);
    }

    public static final /* synthetic */ long $anonfun$getConsumerByteRates$2(HashMap results$1, ClientQuotaEntity entity$3, Double x0$2) {
        return BoxesRunTime.unboxToLong((Object)results$1.put(entity$3, BoxesRunTime.boxToLong((long)x0$2.longValue())));
    }

    public static final /* synthetic */ boolean $anonfun$testDefaultClientQuotas$1(KafkaClusterTestKit cluster$6) {
        BrokerState brokerState = cluster$6.brokers().get(BoxesRunTime.boxToInteger((int)0)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testDefaultClientQuotas$2() {
        return "Broker never made it to RUNNING state.";
    }

    public static final /* synthetic */ void $anonfun$testDefaultClientQuotas$3(KRaftClusterTest $this, Admin admin$2) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$), $this.getConsumerByteRates(admin$2));
    }

    public static final /* synthetic */ void $anonfun$testDefaultClientQuotas$4(KRaftClusterTest $this, ClientQuotaEntity defaultUser$1, Admin admin$2) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultUser$1), (Object)BoxesRunTime.boxToLong((long)100L))})), $this.getConsumerByteRates(admin$2));
    }

    public static final /* synthetic */ void $anonfun$testDefaultClientQuotas$5(KRaftClusterTest $this, ClientQuotaEntity defaultUser$1, ClientQuotaEntity bobUser$1, Admin admin$2) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultUser$1), (Object)BoxesRunTime.boxToLong((long)100L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bobUser$1), (Object)BoxesRunTime.boxToLong((long)1000L))})), $this.getConsumerByteRates(admin$2));
    }

    public static final /* synthetic */ void $anonfun$testCreateClusterWithAdvertisedPortZero$2(KRaftClusterTest $this, KafkaClusterTestKit cluster) {
        $this.sendDescribeClusterRequestToBoundPortUntilAllBrokersPropagated(cluster.nodes().externalListenerName(), scala.concurrent.duration.package$.MODULE$.pairLongToDuration(new Tuple2((Object)BoxesRunTime.boxToLong((long)15L), (Object)TimeUnit.SECONDS)), cluster).nodes().values().forEach(broker -> {
            Assertions.assertEquals((Object)"localhost", (Object)broker.host(), (String)"Did not advertise configured advertised host");
            Assertions.assertEquals((int)cluster.brokers().get(BoxesRunTime.boxToInteger((int)broker.id())).socketServer().boundPort(cluster.nodes().externalListenerName()), (int)broker.port(), (String)"Did not advertise bound socket port");
        });
    }

    public static final /* synthetic */ void $anonfun$testCreateClusterWithAdvertisedHostAndPortDifferentFromSocketServer$2(KRaftClusterTest $this, KafkaClusterTestKit cluster) {
        $this.sendDescribeClusterRequestToBoundPortUntilAllBrokersPropagated(cluster.nodes().externalListenerName(), scala.concurrent.duration.package$.MODULE$.pairLongToDuration(new Tuple2((Object)BoxesRunTime.boxToLong((long)15L), (Object)TimeUnit.SECONDS)), cluster).nodes().values().forEach(broker -> {
            Assertions.assertEquals((Object)new StringBuilder(16).append("advertised-host-").append(broker.id()).toString(), (Object)broker.host(), (String)"Did not advertise configured advertised host");
            Assertions.assertEquals((int)(broker.id() + 100), (int)broker.port(), (String)"Did not advertise configured advertised port");
        });
    }

    public static final /* synthetic */ boolean $anonfun$waitForRunningBrokers$1(BrokerServer brokerServer) {
        BrokerState brokerState = brokerServer.brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    private static final scala.collection.immutable.Seq getRunningBrokerServers$1(KafkaClusterTestKit cluster$8) {
        return (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.CollectionHasAsScala(cluster$8.brokers().values()).asScala().toSeq().filter((Function1 & Serializable)brokerServer -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$waitForRunningBrokers$1(brokerServer)));
    }

    public static final /* synthetic */ scala.collection.immutable.Seq $anonfun$waitForRunningBrokers$2(KafkaClusterTestKit cluster$8) {
        return KRaftClusterTest.getRunningBrokerServers$1(cluster$8);
    }

    public static final /* synthetic */ boolean $anonfun$sendDescribeClusterRequestToBoundPortUntilBrokersPropagated$2(int expectedBrokerCount$1, DescribeClusterResponse response) {
        return response.nodes().size() == expectedBrokerCount$1;
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndPerformReassignment$1(Admin admin$3) {
        return ((java.util.Map)admin$3.listPartitionReassignments().reassignments().get()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndPerformReassignment$2() {
        return "The reassignment never completed.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndPerformReassignment$3(KRaftClusterTest $this, Admin admin$3, ObjectRef currentMapping$1, scala.collection.immutable.Seq expectedMapping$1) {
        java.util.Map topicInfoMap = (java.util.Map)admin$3.describeTopics(Collections.singleton("foo")).allTopicNames().get();
        if (topicInfoMap.containsKey("foo")) {
            currentMapping$1.elem = $this.translatePartitionInfoToSeq(((TopicDescription)topicInfoMap.get("foo")).partitions());
            return expectedMapping$1.equals((Object)((scala.collection.immutable.Seq)currentMapping$1.elem));
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndPerformReassignment$4(scala.collection.immutable.Seq expectedMapping$1, ObjectRef currentMapping$1) {
        return new StringBuilder(72).append("Timed out waiting for replica assignments for topic foo. ").append("Wanted: ").append(expectedMapping$1).append(". Got: ").append((scala.collection.immutable.Seq)currentMapping$1.elem).toString();
    }

    public static final /* synthetic */ boolean $anonfun$checkReplicaManager$1(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$checkReplicaManager$3(Tuple2 check$ifrefutable$2) {
        return check$ifrefutable$2 != null;
    }

    public static final /* synthetic */ void $anonfun$checkReplicaManager$4(BrokerServer broker$1, Tuple2 x$8) {
        if (x$8 != null) {
            boolean isHosted = x$8._1$mcZ$sp();
            int partitionId = x$8._2$mcI$sp();
            TopicPartition topicPartition = new TopicPartition("foo", partitionId);
            if (isHosted) {
                Assertions.assertNotEquals((Object)HostedPartition.None$.MODULE$, (Object)broker$1.replicaManager().getPartition(topicPartition), (String)new StringBuilder(17).append("topicPartition = ").append(topicPartition).toString());
                return;
            }
            Assertions.assertEquals((Object)HostedPartition.None$.MODULE$, (Object)broker$1.replicaManager().getPartition(topicPartition), (String)new StringBuilder(17).append("topicPartition = ").append(topicPartition).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$checkReplicaManager$2(KafkaClusterTestKit cluster$10, Tuple2 x$9) {
        if (x$9 != null) {
            int brokerId = x$9._1$mcI$sp();
            List partitionsIsHosted = (List)x$9._2();
            BrokerServer broker = cluster$10.brokers().get(BoxesRunTime.boxToInteger((int)brokerId));
            ((IterableOps)partitionsIsHosted.zipWithIndex()).withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$checkReplicaManager$3(check$ifrefutable$2))).foreach((Function1 & Serializable)x$8 -> {
                KRaftClusterTest.$anonfun$checkReplicaManager$4(broker, x$8);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$waitForTopicListing$2(Admin admin$4, HashSet topicsNotFound$1, ObjectRef extraTopics$1, scala.collection.immutable.Seq expectedAbsent$1) {
        ((Iterable)admin$4.listTopics().names().get()).forEach(name -> topicsNotFound$1.remove(name));
        extraTopics$1.elem = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)admin$4.listTopics().names().get()).asScala().filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)expectedAbsent$1.contains((Object)x$11)));
        return topicsNotFound$1.isEmpty() && ((scala.collection.mutable.Set)extraTopics$1.elem).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$waitForTopicListing$5(HashSet topicsNotFound$1, ObjectRef extraTopics$1) {
        return new StringBuilder(49).append("Failed to find topic(s): ").append(CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)topicsNotFound$1).asScala()).append(" and NOT find topic(s): ").append((scala.collection.mutable.Set)extraTopics$1.elem).toString();
    }

    public static final /* synthetic */ void $anonfun$validateConfigs$1(KRaftClusterTest $this, Admin admin$5, scala.collection.immutable.Map expected$1, scala.collection.mutable.HashMap results$2, boolean exhaustive$1) {
        try {
            java.util.Map values = admin$5.describeConfigs((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)expected$1.keySet()).asJava()).values();
            results$2.clear();
            Assertions.assertEquals((Object)expected$1.keySet(), (Object)CollectionConverters$.MODULE$.SetHasAsScala(values.keySet()).asScala());
            expected$1.foreach((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    ConfigResource resource = (ConfigResource)x0$1._1();
                    scala.collection.immutable.Seq pairs = (scala.collection.immutable.Seq)x0$1._2();
                    Config config = (Config)((KafkaFuture)values.get(resource)).get();
                    TreeMap actual = new TreeMap();
                    TreeMap expected = new TreeMap();
                    config.entries().forEach(x0$2 -> {
                        actual.put(x0$2.name(), x0$2.value());
                        if (!exhaustive$1) {
                            expected.put(x0$2.name(), x0$2.value());
                            return;
                        }
                    });
                    pairs.foreach((Function1 & Serializable)x0$3 -> {
                        if (x0$3 != null) {
                            String k = (String)x0$3._1();
                            String v = (String)x0$3._2();
                            return expected.put(k, v);
                        }
                        throw new MatchError(null);
                    });
                    Assertions.assertEquals(expected, actual);
                    return results$2.put((Object)resource, actual);
                }
                throw new MatchError(null);
            });
            return;
        }
        catch (Throwable t) {
            $this.log().warn(new StringBuilder(27).append("Unable to describeConfigs(").append(CollectionConverters$.MODULE$.SetHasAsJava((Set)expected$1.keySet()).asJava()).append(")").toString(), t);
            throw t;
        }
    }

    public static final /* synthetic */ void $anonfun$testConfluentReplicaAssignor$1(ObjectRef result$1, Admin admin$6) {
        try {
            result$1.elem = (TopicDescription)((KafkaFuture)admin$6.describeTopics(Arrays.asList("foo")).topicNameValues().get("foo")).get();
        }
        catch (Exception e) {
            throw new AssertionError(e.getMessage(), e);
        }
        Assertions.assertEquals((int)3, (int)((TopicDescription)result$1.elem).partitions().size());
    }

    public static final /* synthetic */ String $anonfun$testUnregisterBroker$2() {
        return "Timed out waiting for broker 0 to be unfenced.";
    }

    public static final /* synthetic */ boolean $anonfun$testUnregisterBroker$3(KRaftClusterTest $this, KafkaClusterTestKit cluster$11) {
        return !$this.brokerIsUnfenced($this.clusterImage(cluster$11, 1), 0);
    }

    public static final /* synthetic */ String $anonfun$testUnregisterBroker$4() {
        return "Timed out waiting for broker 0 to be fenced.";
    }

    public static final /* synthetic */ String $anonfun$testUnregisterBroker$6() {
        return "Timed out waiting for broker 0 to be fenced.";
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorumRequestToBrokers$2(BrokerServer broker$2) {
        BrokerState brokerState = broker$2.brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testDescribeQuorumRequestToBrokers$3() {
        return "Broker Never started up";
    }

    public static final /* synthetic */ void $anonfun$testDescribeQuorumRequestToBrokers$1(BrokerServer broker) {
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$2(broker)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Broker Never started up");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorumRequestToBrokers$5(ControllerServer controller$1) {
        MetadataVersion metadataVersion = controller$1.featuresPublisher().features().metadataVersion();
        MetadataVersion metadataVersion2 = MetadataVersion.MINIMUM_KRAFT_VERSION;
        return metadataVersion == null ? metadataVersion2 != null : !metadataVersion.equals(metadataVersion2);
    }

    public static final /* synthetic */ String $anonfun$testDescribeQuorumRequestToBrokers$6() {
        return "Controller Never started up";
    }

    public static final /* synthetic */ void $anonfun$testDescribeQuorumRequestToBrokers$4(ControllerServer controller) {
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$5(controller)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Controller Never started up");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorumRequestToBrokers$8(ControllerServer controller) {
        OptionalLong hw = controller.raftManager().client().highWatermark();
        return hw.isPresent() && hw.getAsLong() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorumRequestToBrokers$7(KafkaClusterTestKit cluster$12) {
        return CollectionConverters$.MODULE$.CollectionHasAsScala(cluster$12.controllers().values()).asScala().forall((Function1 & Serializable)controller -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$8(controller)));
    }

    public static final /* synthetic */ String $anonfun$testDescribeQuorumRequestToBrokers$9() {
        return "Timed out waiting for controllers to begin replicating log";
    }

    public static final /* synthetic */ java.util.List $anonfun$testDescribeQuorumRequestToBrokers$11(ConfluentAdmin admin$8) {
        return ((QuorumInfo)admin$8.describeMetadataQuorum(new DescribeMetadataQuorumOptions()).quorumInfo().get()).voters();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorumRequestToBrokers$12(java.util.List voters) {
        return voters.stream().allMatch(voter -> {
            if (voter.logEndOffset() > 0L) {
                OptionalLong optionalLong = voter.lastFetchTimestamp();
                OptionalLong optionalLong2 = OptionalLong.empty();
                if (optionalLong == null ? optionalLong2 != null : !((Object)optionalLong).equals(optionalLong2)) {
                    OptionalLong optionalLong3 = voter.lastCaughtUpTimestamp();
                    OptionalLong optionalLong4 = OptionalLong.empty();
                    if (optionalLong3 == null ? optionalLong4 != null : !((Object)optionalLong3).equals(optionalLong4)) {
                        return true;
                    }
                }
            }
            return false;
        });
    }

    public static final /* synthetic */ java.util.List $anonfun$testDescribeQuorumRequestToBrokers$14(ConfluentAdmin admin$8) {
        return ((QuorumInfo)admin$8.describeMetadataQuorum(new DescribeMetadataQuorumOptions()).quorumInfo().get()).observers();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorumRequestToBrokers$15(KafkaClusterTestKit cluster$12, java.util.List observers) {
        Set set = CollectionConverters$.MODULE$.MapHasAsScala(cluster$12.brokers()).asScala().keySet();
        scala.collection.immutable.Set set2 = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(observers).asScala().map((Function1 & Serializable)x$18 -> BoxesRunTime.boxToInteger((int)x$18.replicaId()))).toSet();
        return !(set != null ? !set.equals(set2) : set2 != null) && observers.stream().allMatch(observer -> {
            if (observer.logEndOffset() > 0L) {
                OptionalLong optionalLong = observer.lastFetchTimestamp();
                OptionalLong optionalLong2 = OptionalLong.empty();
                if (optionalLong == null ? optionalLong2 != null : !((Object)optionalLong).equals(optionalLong2)) {
                    OptionalLong optionalLong3 = observer.lastCaughtUpTimestamp();
                    OptionalLong optionalLong4 = OptionalLong.empty();
                    if (optionalLong3 == null ? optionalLong4 != null : !((Object)optionalLong3).equals(optionalLong4)) {
                        return true;
                    }
                }
            }
            return false;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testUpdateMetadataVersion$1(KafkaClusterTestKit cluster$13) {
        return cluster$13.brokers().get(BoxesRunTime.boxToInteger((int)1)).metadataCache().currentImage().features().metadataVersion().equals((Object)MetadataVersion.latestTesting());
    }

    public static final /* synthetic */ String $anonfun$testUpdateMetadataVersion$2() {
        return "Timed out waiting for metadata version update.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateTopicWithRemoteLogManagerInstantiation$1(KafkaClusterTestKit cluster$15) {
        BrokerState brokerState = cluster$15.brokers().get(BoxesRunTime.boxToInteger((int)0)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateTopicWithRemoteLogManagerInstantiation$2() {
        return "Broker never made it to RUNNING state.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateTopicWithRemoteLogManagerInstantiation$3(KafkaClusterTestKit cluster$15) {
        return cluster$15.raftManagers().get(BoxesRunTime.boxToInteger((int)0)).client().leaderAndEpoch().leaderId().isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateTopicWithRemoteLogManagerInstantiation$4() {
        return "RaftManager was not initialized.";
    }

    private static final long snapshotCounter$1(Path path) {
        return path.toFile().listFiles((x$20, name) -> name.toLowerCase().endsWith("checkpoint")).length;
    }

    public static final /* synthetic */ boolean $anonfun$testSnapshotCount$2(Path metaLog$1) {
        return KRaftClusterTest.snapshotCounter$1(metaLog$1) > 0L;
    }

    public static final /* synthetic */ String $anonfun$testSnapshotCount$3() {
        return "Failed to see at least one snapshot";
    }

    public static final /* synthetic */ boolean $anonfun$testSnapshotCount$4(KafkaClusterTestKit cluster$16) {
        return cluster$16.controllers().values().iterator().next().sharedServer().snapshotEmitter().metrics().latestSnapshotGeneratedBytes() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testSnapshotCount$5() {
        return "Failed to see latestSnapshotGeneratedBytes > 0";
    }

    public static final /* synthetic */ void $anonfun$testReconfigureControllerClientQuotas$1(int expected$3, KafkaClusterTestKit cluster$17) {
        Assertions.assertEquals((int)expected$3, (int)((DummyClientQuotaCallback)cluster$17.controllers().values().iterator().next().quotaManagers().clientQuotaCallback().get()).value());
        Assertions.assertEquals((int)expected$3, (int)((DummyClientQuotaCallback)cluster$17.brokers().values().iterator().next().quotaManagers().clientQuotaCallback().get()).value());
    }

    private static final void assertConfigValue$1(int expected, KafkaClusterTestKit cluster$17) {
        long retry_maxWaitMs = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                KRaftClusterTest.$anonfun$testReconfigureControllerClientQuotas$1(expected, cluster$17);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var8_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testReconfigureControllerAuthorizer$1(int expected$4, KafkaClusterTestKit cluster$18) {
        Assertions.assertEquals((int)expected$4, (int)((FakeConfigurableAuthorizer)cluster$18.controllers().values().iterator().next().authorizer().get()).foobar().get());
        Assertions.assertEquals((int)expected$4, (int)((FakeConfigurableAuthorizer)cluster$18.brokers().values().iterator().next().authorizer().get()).foobar().get());
    }

    private static final void assertFoobarValue$1(int expected, KafkaClusterTestKit cluster$18) {
        long retry_maxWaitMs = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                KRaftClusterTest.$anonfun$testReconfigureControllerAuthorizer$1(expected, cluster$18);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var8_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testTimedOutHeartbeats$1(ControllerServer controller$2) {
        CountDownLatch latch = QuorumControllerIntegrationTestUtils.pause((QuorumController)((QuorumController)controller$2.controller()));
        Thread.sleep(1001L);
        latch.countDown();
        Assertions.assertEquals((int)0, (int)controller$2.sharedServer().controllerServerMetrics().fencedBrokerCount());
        Assertions.assertTrue((controller$2.quorumControllerMetrics().timedOutHeartbeats() > 0L ? 1 : 0) != 0, (String)"Expected timedOutHeartbeats to be greater than 0.");
    }

    public static final /* synthetic */ void $anonfun$testRegisteredControllerEndpoints$1(KRaftClusterTest $this, KafkaClusterTestKit cluster$19) {
        java.util.Map registeredControllers = cluster$19.controllers().values().iterator().next().registrationsPublisher().controllers();
        Assertions.assertEquals((int)3, (int)registeredControllers.size(), (String)"Expected 3 controller registrations");
        registeredControllers.values().forEach(registration -> {
            Assertions.assertNotNull(registration.listeners().get("CONTROLLER"));
            Assertions.assertNotEquals((int)0, (int)((Endpoint)registration.listeners().get("CONTROLLER")).port());
        });
        $this.checkReadinessAndRollableStatus(cluster$19.controllers().values().iterator().next());
    }

    public static final /* synthetic */ void $anonfun$checkReadinessAndRollableStatus$1(ControllerServer controller$3) {
        CheckReadyControllerStatus status = controller$3.internalRestServerHandler().generateReadinessStatus();
        Assertions.assertEquals((Object)"", (Object)status.reason());
        Assertions.assertTrue((boolean)status.ready());
    }

    public static final /* synthetic */ void $anonfun$checkReadinessAndRollableStatus$2(ControllerServer controller$3) {
        BeginShutdownControllerStatus status = controller$3.internalRestServerHandler().generateRollableStatus();
        Assertions.assertEquals((Object)"", (Object)status.reason());
        Assertions.assertTrue((boolean)status.rollable());
    }

    public static final /* synthetic */ void $anonfun$testStartupWithNonDefaultKControllerDynamicConfiguration$1(ControllerServer controller$4) {
        Assertions.assertNotNull((Object)controller$4.controllerApisHandlerPool());
        Assertions.assertEquals((int)9, (int)controller$4.controllerApisHandlerPool().threadPoolSize().get());
    }

    public static final /* synthetic */ void $anonfun$testTopicDeletedAndRecreatedWhileBrokerIsDown$1(BrokerServer broker0$1, TopicPartition foo0$1) {
        LogManager qual$1 = broker0$1.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Assertions.assertTrue((boolean)qual$1.getLog(foo0$1, x$2).isDefined());
    }

    public static final /* synthetic */ void $anonfun$testTopicDeletedAndRecreatedWhileBrokerIsDown$2(BrokerServer broker1$1) {
        Option info = broker1$1.metadataCache().getPartitionInfo("foo", 0);
        Assertions.assertTrue((boolean)info.isDefined());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((UpdateMetadataRequestData.UpdateMetadataPartitionState)info.get()).isr()).asScala().toSet());
    }

    public static final /* synthetic */ void $anonfun$testTopicDeletedAndRecreatedWhileBrokerIsDown$3(BrokerServer broker1$1) {
        Option info = broker1$1.metadataCache().getPartitionInfo("foo", 0);
        Assertions.assertTrue((boolean)info.isDefined());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((UpdateMetadataRequestData.UpdateMetadataPartitionState)info.get()).isr()).asScala().toSet());
    }

    public static final /* synthetic */ void $anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOfflineLogDir$1(BrokerServer broker0$2, TopicPartition foo0$2) {
        LogManager qual$1 = broker0$2.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Assertions.assertTrue((boolean)qual$1.getLog(foo0$2, x$2).isDefined());
    }

    public static final /* synthetic */ void $anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOfflineLogDir$2(BrokerServer broker1$2) {
        Option info = broker1$2.metadataCache().getPartitionInfo("foo", 0);
        Assertions.assertTrue((boolean)info.isDefined());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((UpdateMetadataRequestData.UpdateMetadataPartitionState)info.get()).isr()).asScala().toSet());
    }

    public static final /* synthetic */ void $anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOfflineLogDir$3(BrokerServer broker1$2, BrokerServer broker0$2, TopicPartition foo0$2) {
        Option info = broker1$2.metadataCache().getPartitionInfo("foo", 0);
        Assertions.assertTrue((boolean)info.isDefined());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((UpdateMetadataRequestData.UpdateMetadataPartitionState)info.get()).isr()).asScala().toSet());
        Assertions.assertTrue((boolean)broker0$2.logManager().getLog(foo0$2, true).isEmpty());
    }

    public static final /* synthetic */ void $anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOnlineLogDir$1(BrokerServer broker0$3, TopicPartition foo0$3) {
        LogManager qual$1 = broker0$3.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Assertions.assertTrue((boolean)qual$1.getLog(foo0$3, x$2).isDefined());
    }

    public static final /* synthetic */ void $anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOnlineLogDir$2(BrokerServer broker1$3) {
        Option info = broker1$3.metadataCache().getPartitionInfo("foo", 0);
        Assertions.assertTrue((boolean)info.isDefined());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((UpdateMetadataRequestData.UpdateMetadataPartitionState)info.get()).isr()).asScala().toSet());
    }

    public static final /* synthetic */ boolean $anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOnlineLogDir$3(String parentDir$1, String x$21) {
        String string = x$21;
        return string == null ? parentDir$1 != null : !string.equals(parentDir$1);
    }

    public static final /* synthetic */ void $anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOnlineLogDir$4(BrokerServer broker1$3, BrokerServer broker0$3, TopicPartition foo0$3, File targetDirFile$1, File originalLogFile$1) {
        Option info = broker1$3.metadataCache().getPartitionInfo("foo", 0);
        Assertions.assertTrue((boolean)info.isDefined());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((UpdateMetadataRequestData.UpdateMetadataPartitionState)info.get()).isr()).asScala().toSet());
        Assertions.assertTrue((boolean)broker0$3.logManager().getLog(foo0$3, true).isEmpty());
        Assertions.assertFalse((boolean)targetDirFile$1.exists());
        Assertions.assertTrue((boolean)originalLogFile$1.exists());
    }

    public static final /* synthetic */ Object $anonfun$waitForRunningBrokers$3$adapted(scala.collection.immutable.Seq x$5) {
        return BoxesRunTime.boxToBoolean((boolean)x$5.nonEmpty());
    }

    public static final /* synthetic */ Object $anonfun$sendDescribeClusterRequestToBoundPortUntilBrokersPropagated$2$adapted(int expectedBrokerCount$1, DescribeClusterResponse response) {
        return BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$sendDescribeClusterRequestToBoundPortUntilBrokersPropagated$2(expectedBrokerCount$1, response));
    }

    public static final /* synthetic */ Object $anonfun$testDescribeQuorumRequestToBrokers$12$adapted(java.util.List voters) {
        return BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$12(voters));
    }

    public static final /* synthetic */ Object $anonfun$testDescribeQuorumRequestToBrokers$15$adapted(KafkaClusterTestKit cluster$12, java.util.List observers) {
        return BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$15(cluster$12, observers));
    }

    public static final /* synthetic */ Object $anonfun$testClientQuotas$4$adapted(ClientQuotaEntity entity$1, int expectCount$1, java.util.Map results) {
        return BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testClientQuotas$4(entity$1, expectCount$1, results));
    }
}

