/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.Properties;
import kafka.log.LocalLog$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.bootstrap.BootstrapDirectory;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesEnsemble;
import org.apache.kafka.metadata.properties.MetaPropertiesVersion;
import org.apache.kafka.metadata.properties.PropertiesUtils;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Mb\u0001B\t\u0013\u0001]AQA\b\u0001\u0005\u0002}AqA\t\u0001C\u0002\u0013%1\u0005\u0003\u0004-\u0001\u0001\u0006I\u0001\n\u0005\u0006[\u0001!\tA\f\u0005\u0006\u007f\u0001!\tA\f\u0005\u0006\u0003\u0002!IA\u0011\u0005\ba\u0002\t\n\u0011\"\u0003r\u0011\u0015a\b\u0001\"\u0003~\u0011\u001d\ty\u0001\u0001C\u0005\u0003#Aa!a\u0006\u0001\t\u0003q\u0003BBA\u000e\u0001\u0011\u0005a\u0006\u0003\u0004\u0002 \u0001!\tA\f\u0005\u0007\u0003G\u0001A\u0011\u0001\u0018\t\r\u0005\u001d\u0002\u0001\"\u0001/\u0011\u0019\tY\u0003\u0001C\u0001]!1\u0011q\u0006\u0001\u0005\u00029\u00121cS1gW\u0006\u0014\u0016M\u001a;TKJ4XM\u001d+fgRT!a\u0005\u000b\u0002\rM,'O^3s\u0015\u0005)\u0012!B6bM.\f7\u0001A\n\u0003\u0001a\u0001\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001!!\t\t\u0003!D\u0001\u0013\u0003=\u0019G.^:uKJLEMQ1tKZ\"T#\u0001\u0013\u0011\u0005\u0015RS\"\u0001\u0014\u000b\u0005\u001dB\u0013\u0001\u00027b]\u001eT\u0011!K\u0001\u0005U\u00064\u0018-\u0003\u0002,M\t11\u000b\u001e:j]\u001e\f\u0001c\u00197vgR,'/\u00133CCN,g\u0007\u000e\u0011\u0002AQ,7\u000f^*vG\u000e,7o\u001d4vY2{\u0017\rZ'fi\u0006\u0004&o\u001c9feRLWm\u001d\u000b\u0002_A\u0011\u0011\u0004M\u0005\u0003ci\u0011A!\u00168ji\"\u0012Aa\r\t\u0003iuj\u0011!\u000e\u0006\u0003m]\n1!\u00199j\u0015\tA\u0014(A\u0004kkBLG/\u001a:\u000b\u0005iZ\u0014!\u00026v]&$(\"\u0001\u001f\u0002\u0007=\u0014x-\u0003\u0002?k\t!A+Z:u\u00031\"Xm\u001d;M_\u0006$W*\u001a;b!J|\u0007/\u001a:uS\u0016\u001cx+\u001b;i\u0013:\u001cwN\\:jgR,g\u000e\u001e(pI\u0016LE\r\u000b\u0002\u0006g\u0005A\u0012N\u001c<pW\u0016du.\u00193NKR\f\u0007K]8qKJ$\u0018.Z:\u0015\t\r;F\f\u001a\t\u00053\u00113\u0015+\u0003\u0002F5\t1A+\u001e9mKJ\u0002\"aR(\u000e\u0003!S!!\u0013&\u0002\u0015A\u0014x\u000e]3si&,7O\u0003\u0002L\u0019\u0006AQ.\u001a;bI\u0006$\u0018M\u0003\u0002\u0016\u001b*\u0011ajO\u0001\u0007CB\f7\r[3\n\u0005AC%AF'fi\u0006\u0004&o\u001c9feRLWm]#og\u0016l'\r\\3\u0011\u0005I+V\"A*\u000b\u0005QS\u0015!\u00032p_R\u001cHO]1q\u0013\t16KA\tC_>$8\u000f\u001e:ba6+G/\u00193bi\u0006DQ\u0001\u0017\u0004A\u0002e\u000ba\"\\3uCB\u0013x\u000e]3si&,7\u000f\u0005\u0002H5&\u00111\f\u0013\u0002\u000f\u001b\u0016$\u0018\r\u0015:pa\u0016\u0014H/[3t\u0011\u0015if\u00011\u0001_\u0003A\u0019wN\u001c4jOB\u0013x\u000e]3si&,7\u000f\u0005\u0002`E6\t\u0001M\u0003\u0002bQ\u0005!Q\u000f^5m\u0013\t\u0019\u0007M\u0001\u0006Qe>\u0004XM\u001d;jKNDq!\u001a\u0004\u0011\u0002\u0003\u0007a-A\bnKR\fG-\u0019;b-\u0016\u00148/[8o!\rIr-[\u0005\u0003Qj\u0011aa\u00149uS>t\u0007C\u00016o\u001b\u0005Y'B\u00017n\u0003\u0019\u0019w.\\7p]*\u00111\u0003T\u0005\u0003_.\u0014q\"T3uC\u0012\fG/\u0019,feNLwN\\\u0001#S:4xn[3M_\u0006$W*\u001a;b!J|\u0007/\u001a:uS\u0016\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0003IT#AZ:,\u0003Q\u0004\"!\u001e>\u000e\u0003YT!a\u001e=\u0002\u0013Ut7\r[3dW\u0016$'BA=\u001b\u0003)\tgN\\8uCRLwN\\\u0005\u0003wZ\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003M9(/\u001b;f\u001b\u0016$\u0018\r\u0015:pa\u0016\u0014H/[3t)\u0011yc0!\u0004\t\r}D\u0001\u0019AA\u0001\u0003\u0019awn\u001a#jeB!\u00111AA\u0005\u001b\t\t)AC\u0002\u0002\b!\n!![8\n\t\u0005-\u0011Q\u0001\u0002\u0005\r&dW\rC\u0003Y\u0011\u0001\u0007\u0011,\u0001\fxe&$XMQ8piN$(/\u00199NKR\fG-\u0019;b)\u0015y\u00131CA\u000b\u0011\u0019y\u0018\u00021\u0001\u0002\u0002!)Q-\u0003a\u0001S\u0006\u0019D/Z:u'R\f'\u000f^;q\r\u0006LGn]%g\u001b\u0016$\u0018\r\u0015:pa\u0016\u0014H/[3t\u001b&\u001c8/\u001b8h\u0013:\u001cv.\\3M_\u001e$\u0015N\u001d\u0015\u0003\u0015M\nQ\u0005^3tiN#\u0018M\u001d;va\u001a\u000b\u0017\u000e\\:JM6+G/\u0019'pO\u0012K'/S:PM\u001ad\u0017N\\3)\u0005-\u0019\u0014\u0001\u000b;fgR\u001cF/\u0019:ukB$u.Z:O_R4\u0015-\u001b7JM\u0012\u000bG/\u0019#je&\u001bxJ\u001a4mS:,\u0007F\u0001\u00074\u0003\u001d\"Xm\u001d;Ti\u0006\u0014H/\u001e9GC&d7/\u00134V]\u0016D\b/Z2uK\u0012lU\r^1eCR\fG)\u001b:)\u00055\u0019\u0014\u0001\f;fgRdu.\u00193Qe>\u0004XM\u001d;jKN<\u0016\u000e\u001e5J]\u000e|gn]5ti\u0016tGo\u00117vgR,'/\u00133tQ\tq1'\u0001\fuKN$8JU1giV\u0003H-\u0019;f/&$\b.\u0013\"QQ\ty1'A\ruKN$8JU1giV\u0003H-\u0019;f/&$\bn\\;u\u0013\n\u0003\u0006F\u0001\t4\u0001")
public class KafkaRaftServerTest {
    private final String clusterIdBase64;

    private String clusterIdBase64() {
        return this.clusterIdBase64;
    }

    @Test
    public void testSuccessfulLoadMetaProperties() {
        String clusterId = this.clusterIdBase64();
        int nodeId = 0;
        MetaProperties metaProperties = new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId(clusterId).setNodeId(nodeId).build();
        Properties configProperties = new Properties();
        configProperties.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker,controller");
        configProperties.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(nodeId));
        configProperties.put(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://127.0.0.1:9092,SSL://127.0.0.1:9093");
        configProperties.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId).append("@localhost:9093").toString());
        configProperties.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        configProperties.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        MetaProperties loadedMetaProperties = (MetaProperties)((MetaPropertiesEnsemble)this.invokeLoadMetaProperties(metaProperties, configProperties, this.invokeLoadMetaProperties$default$3())._1()).logDirProps().values().iterator().next();
        Assertions.assertEquals((Object)metaProperties, (Object)new MetaProperties.Builder(loadedMetaProperties).setDirectoryId(Optional.empty()).build());
        Assertions.assertTrue((boolean)loadedMetaProperties.directoryId().isPresent());
    }

    @Test
    public void testLoadMetaPropertiesWithInconsistentNodeId() {
        String clusterId = this.clusterIdBase64();
        int metaNodeId = 1;
        int configNodeId = 0;
        MetaProperties metaProperties = new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId(clusterId).setNodeId(metaNodeId).build();
        Properties configProperties = new Properties();
        configProperties.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
        configProperties.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(configNodeId));
        configProperties.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(configNodeId).append("@localhost:9092").toString());
        configProperties.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "PLAINTEXT");
        Assertions.assertThrows(RuntimeException.class, () -> this.invokeLoadMetaProperties(metaProperties, configProperties, this.invokeLoadMetaProperties$default$3()));
    }

    private Tuple2<MetaPropertiesEnsemble, BootstrapMetadata> invokeLoadMetaProperties(MetaProperties metaProperties, Properties configProperties, Option<MetadataVersion> metadataVersion) {
        Tuple2 tuple2;
        File tempLogDir = TestUtils.tempDirectory(null, null);
        try {
            this.writeMetaProperties(tempLogDir, metaProperties);
            metadataVersion.foreach((Function1 & Serializable)mv -> {
                this.writeBootstrapMetadata(tempLogDir, mv);
                return BoxedUnit.UNIT;
            });
            configProperties.put(KafkaConfig$.MODULE$.LogDirProp(), tempLogDir.getAbsolutePath());
            KafkaConfig config = KafkaConfig$.MODULE$.fromProps(configProperties);
            tuple2 = KafkaRaftServer$.MODULE$.initializeLogDirs(config, MetaPropertiesEnsemble.LOG, "");
        }
        finally {
            Utils.delete((File)tempLogDir, (boolean)false);
        }
        return tuple2;
    }

    private Option<MetadataVersion> invokeLoadMetaProperties$default$3() {
        return new Some((Object)MetadataVersion.latestTesting());
    }

    private void writeMetaProperties(File logDir, MetaProperties metaProperties) {
        File metaPropertiesFile = new File(logDir.getAbsolutePath(), "meta.properties");
        PropertiesUtils.writePropertiesFile((Properties)metaProperties.toProperties(), (String)metaPropertiesFile.getAbsolutePath(), (boolean)false);
    }

    private void writeBootstrapMetadata(File logDir, MetadataVersion metadataVersion) {
        String fromVersion_source = "test";
        Object var3_3 = null;
        new BootstrapDirectory(logDir.toString(), Optional.empty()).writeBinaryFile(BootstrapMetadata.fromVersion((MetadataVersion)metadataVersion, (String)fromVersion_source, (boolean)true));
    }

    @Test
    public void testStartupFailsIfMetaPropertiesMissingInSomeLogDir() {
        String clusterId = this.clusterIdBase64();
        int nodeId = 1;
        File logDir1 = TestUtils.tempDirectory(null, null);
        File logDir2 = TestUtils.tempDirectory(null, null);
        this.writeMetaProperties(logDir1, new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId(clusterId).setNodeId(nodeId).build());
        Properties configProperties = new Properties();
        configProperties.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        configProperties.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(nodeId));
        configProperties.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId + 1).append("@localhost:9092").toString());
        configProperties.put(KafkaConfig$.MODULE$.LogDirProp(), ((IterableOnceOps)new .colon.colon((Object)logDir1, (List)new .colon.colon((Object)logDir2, (List)Nil$.MODULE$)).map((Function1 & Serializable)x$1 -> x$1.getAbsolutePath())).mkString(","));
        configProperties.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        configProperties.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(configProperties);
        Assertions.assertThrows(RuntimeException.class, () -> KafkaRaftServer$.MODULE$.initializeLogDirs(config, MetaPropertiesEnsemble.LOG, ""));
    }

    @Test
    public void testStartupFailsIfMetaLogDirIsOffline() {
        String clusterId = this.clusterIdBase64();
        int nodeId = 1;
        File validDir = TestUtils.tempDirectory(null, null);
        this.writeMetaProperties(validDir, new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId(clusterId).setNodeId(nodeId).build());
        File invalidDir = TestUtils.tempFile((String)"blah");
        Properties configProperties = new Properties();
        configProperties.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        configProperties.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId + 1).append("@localhost:9092").toString());
        configProperties.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(nodeId));
        configProperties.put(KafkaConfig$.MODULE$.MetadataLogDirProp(), invalidDir.getAbsolutePath());
        configProperties.put(KafkaConfig$.MODULE$.LogDirProp(), validDir.getAbsolutePath());
        configProperties.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        configProperties.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(configProperties);
        Assertions.assertThrows(RuntimeException.class, () -> KafkaRaftServer$.MODULE$.initializeLogDirs(config, MetaPropertiesEnsemble.LOG, ""));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testStartupDoesNotFailIfDataDirIsOffline() {
        void var8_8;
        String clusterId = this.clusterIdBase64();
        int nodeId = 1;
        File validDir = TestUtils.tempDirectory(null, null);
        this.writeMetaProperties(validDir, new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId(clusterId).setNodeId(nodeId).build());
        this.writeBootstrapMetadata(validDir, MetadataVersion.latestTesting());
        File invalidDir = TestUtils.tempFile((String)"blah");
        Properties configProperties = new Properties();
        configProperties.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        configProperties.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(nodeId));
        configProperties.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId + 1).append("@localhost:9092").toString());
        configProperties.put(KafkaConfig$.MODULE$.MetadataLogDirProp(), validDir.getAbsolutePath());
        configProperties.put(KafkaConfig$.MODULE$.LogDirProp(), invalidDir.getAbsolutePath());
        configProperties.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        configProperties.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(configProperties);
        Tuple2 tuple2 = KafkaRaftServer$.MODULE$.initializeLogDirs(config, MetaPropertiesEnsemble.LOG, "");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        MetaPropertiesEnsemble metaPropertiesEnsemble = (MetaPropertiesEnsemble)tuple2._1();
        Assertions.assertEquals((int)nodeId, (int)var8_8.nodeId().getAsInt());
        Assertions.assertEquals((Object)invalidDir.getAbsolutePath(), (Object)String.join((CharSequence)", ", var8_8.errorLogDirs()));
    }

    @Test
    public void testStartupFailsIfUnexpectedMetadataDir() {
        int nodeId = 1;
        String clusterId = this.clusterIdBase64();
        File metadataDir = TestUtils.tempDirectory(null, null);
        File dataDir = TestUtils.tempDirectory(null, null);
        new .colon.colon((Object)metadataDir, (List)new .colon.colon((Object)dataDir, (List)Nil$.MODULE$)).foreach((Function1 & Serializable)dir -> {
            this.writeMetaProperties(dir, new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId(clusterId).setNodeId(nodeId).build());
            return BoxedUnit.UNIT;
        });
        TopicPartition logDirName_topicPartition = KafkaRaftServer$.MODULE$.MetadataPartition();
        Object var7_5 = null;
        Files.createDirectory(new File(dataDir, LocalLog$.MODULE$.logDirName(logDirName_topicPartition)).toPath(), new FileAttribute[0]);
        Properties configProperties = new Properties();
        configProperties.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        configProperties.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(nodeId));
        configProperties.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId + 1).append("@localhost:9092").toString());
        configProperties.put(KafkaConfig$.MODULE$.MetadataLogDirProp(), metadataDir.getAbsolutePath());
        configProperties.put(KafkaConfig$.MODULE$.LogDirProp(), dataDir.getAbsolutePath());
        configProperties.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        configProperties.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(configProperties);
        Assertions.assertThrows(KafkaException.class, () -> KafkaRaftServer$.MODULE$.initializeLogDirs(config, MetaPropertiesEnsemble.LOG, ""));
    }

    @Test
    public void testLoadPropertiesWithInconsistentClusterIds() {
        int nodeId = 1;
        File logDir1 = TestUtils.tempDirectory(null, null);
        File logDir2 = TestUtils.tempDirectory(null, null);
        new .colon.colon((Object)logDir1, (List)new .colon.colon((Object)logDir2, (List)Nil$.MODULE$)).foreach((Function1 & Serializable)dir -> {
            this.writeMetaProperties(dir, new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId(Uuid.randomUuid().toString()).setNodeId(nodeId).build());
            return BoxedUnit.UNIT;
        });
        Properties configProperties = new Properties();
        configProperties.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        configProperties.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId + 1).append("@localhost:9092").toString());
        configProperties.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(nodeId));
        configProperties.put(KafkaConfig$.MODULE$.LogDirProp(), ((IterableOnceOps)new .colon.colon((Object)logDir1, (List)new .colon.colon((Object)logDir2, (List)Nil$.MODULE$)).map((Function1 & Serializable)x$2 -> x$2.getAbsolutePath())).mkString(","));
        configProperties.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        configProperties.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(configProperties);
        Assertions.assertThrows(RuntimeException.class, () -> KafkaRaftServer$.MODULE$.initializeLogDirs(config, MetaPropertiesEnsemble.LOG, ""));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testKRaftUpdateWithIBP() {
        void var7_7;
        void var6_6;
        String clusterId = this.clusterIdBase64();
        int nodeId = 0;
        MetaProperties metaProperties = new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId(clusterId).setNodeId(nodeId).setDirectoryId(Uuid.fromString((String)"4jm0e-YRYeB6CCKBvwoS8w")).build();
        Properties configProperties = new Properties();
        configProperties.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker,controller");
        configProperties.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(nodeId));
        configProperties.put(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://127.0.0.1:9092,SSL://127.0.0.1:9093");
        configProperties.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId).append("@localhost:9093").toString());
        configProperties.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        configProperties.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "3.3-IV1");
        Tuple2<MetaPropertiesEnsemble, BootstrapMetadata> tuple2 = this.invokeLoadMetaProperties(metaProperties, configProperties, (Option<MetadataVersion>)None$.MODULE$);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        MetaPropertiesEnsemble metaPropertiesEnsemble = (MetaPropertiesEnsemble)tuple2._1();
        BootstrapMetadata bootstrapMetadata = (BootstrapMetadata)tuple2._2();
        Assertions.assertEquals((Object)metaProperties, var6_6.logDirProps().values().iterator().next());
        Assertions.assertTrue((boolean)var6_6.errorLogDirs().isEmpty());
        Assertions.assertTrue((boolean)var6_6.emptyLogDirs().isEmpty());
        Assertions.assertEquals((Object)var7_7.metadataVersion(), (Object)MetadataVersion.IBP_3_3_IV1);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testKRaftUpdateWithoutIBP() {
        void var8_8;
        void var7_7;
        String clusterId = this.clusterIdBase64();
        int nodeId = 0;
        MetaProperties metaProperties = new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId(clusterId).setNodeId(nodeId).setDirectoryId(Uuid.fromString((String)"4jm0e-YRYeB6CCKBvwoS8w")).build();
        File logDir = TestUtils.tempDirectory(null, null);
        this.writeMetaProperties(logDir, metaProperties);
        Properties configProperties = new Properties();
        configProperties.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker,controller");
        configProperties.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(nodeId));
        configProperties.put(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://127.0.0.1:9092,SSL://127.0.0.1:9093");
        configProperties.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId).append("@localhost:9093").toString());
        configProperties.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        configProperties.put(KafkaConfig$.MODULE$.LogDirProp(), logDir.getAbsolutePath());
        Tuple2<MetaPropertiesEnsemble, BootstrapMetadata> tuple2 = this.invokeLoadMetaProperties(metaProperties, configProperties, (Option<MetadataVersion>)None$.MODULE$);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        MetaPropertiesEnsemble metaPropertiesEnsemble = (MetaPropertiesEnsemble)tuple2._1();
        BootstrapMetadata bootstrapMetadata = (BootstrapMetadata)tuple2._2();
        Assertions.assertEquals((Object)metaProperties, var7_7.logDirProps().values().iterator().next());
        Assertions.assertTrue((boolean)var7_7.errorLogDirs().isEmpty());
        Assertions.assertTrue((boolean)var7_7.emptyLogDirs().isEmpty());
        Assertions.assertEquals((Object)var8_8.metadataVersion(), (Object)MetadataVersion.latestProduction());
    }

    public KafkaRaftServerTest() {
        this.clusterIdBase64 = "H3KKO4NTRPaCWtEmm3vW7A";
    }
}

