/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Meter;
import io.confluent.kafka.availability.ThreadCountersManager;
import io.confluent.kafka.availability.ThreadLocalCounters;
import io.confluent.telemetry.api.events.NoOpEventEmitter;
import io.opentelemetry.context.Context;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.network.RequestChannel;
import kafka.network.RequestChannel$;
import kafka.server.ActionQueue;
import kafka.server.ApiRequestHandler;
import kafka.server.BrokerTopicMetrics;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedActionQueue;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRequestHandler;
import kafka.server.KafkaRequestHandler$;
import kafka.server.KafkaRequestHandlerTest;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.server.RequestLogger;
import kafka.utils.Log4jController$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestLogFilter;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.LogAction;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.server.audit.NoOpAuditLogProvider;
import org.apache.kafka.server.log.remote.storage.RemoteStorageMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t-f\u0001B\u001e=\u0001\u0005CQ\u0001\u0013\u0001\u0005\u0002%Cq\u0001\u0014\u0001C\u0002\u0013\u0005Q\n\u0003\u0004\\\u0001\u0001\u0006IA\u0014\u0005\b9\u0002\u0011\r\u0011\"\u0001^\u0011\u00191\u0007\u0001)A\u0005=\"9q\r\u0001b\u0001\n\u0003A\u0007B\u00027\u0001A\u0003%\u0011\u000eC\u0004n\u0001\t\u0007I\u0011\u00018\t\rU\u0004\u0001\u0015!\u0003p\u0011\u001d1\bA1A\u0005\u00029Daa\u001e\u0001!\u0002\u0013y\u0007b\u0002=\u0001\u0005\u0004%\t!\u001f\u0005\u0007{\u0002\u0001\u000b\u0011\u0002>\t\u000fy\u0004!\u0019!C\u0001s\"1q\u0010\u0001Q\u0001\niDq!!\u0001\u0001\t\u0003\t\u0019\u0001C\u0004\u0002\"\u0001!\t!a\u0001\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002(!9\u0011q\u000b\u0001\u0005\u0002\u0005\r\u0001bBA.\u0001\u0011\u0005\u00111\u0001\u0005\b\u0003?\u0002A\u0011AA\u0002\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003KBq!!\u001f\u0001\t\u0013\tY\bC\u0005\u0002\u0018\u0002\t\n\u0011\"\u0003\u0002\u001a\"I\u0011q\u0016\u0001\u0012\u0002\u0013%\u0011\u0011\u0014\u0005\b\u0003c\u0003A\u0011BAZ\u0011\u001d\ti\r\u0001C\u0005\u0003\u001fDq!!5\u0001\t\u0013\t\u0019\u000eC\u0004\u0002h\u0002!\t!!;\t\u0013\u00055\b!%A\u0005\u0002\u0005=\bbBAz\u0001\u0011\u0005\u0011Q\u001f\u0005\b\u0005\u0003\u0001A\u0011AA\u0002\u0011\u001d\u00119\u0001\u0001C\u0001\u0003\u0007AqA!\u0004\u0001\t\u0003\t\u0019\u0001C\u0004\u0003\u0014\u0001!\t!a\u0001\t\u000f\te\u0001\u0001\"\u0001\u0002\u0004!9!q\u0004\u0001\u0005\u0002\u0005\r\u0001b\u0002B\u0013\u0001\u0011\u0005\u00111\u0001\u0005\b\u0005W\u0001A\u0011AA\u0002\u0011\u001d\u0011\t\u0004\u0001C\u0001\u0003\u0007AqAa\u000e\u0001\t\u0003\t\u0019\u0001C\u0004\u0003>\u0001!\t!a\u0001\t\u000f\t\r\u0003\u0001\"\u0001\u0002\u0004!9!\u0011\n\u0001\u0005\u0002\u0005\r\u0001b\u0002B(\u0001\u0011\u0005\u00111\u0001\u0005\b\u0005+\u0002A\u0011AA\u0002\u0011\u001d\u0011Y\u0006\u0001C\u0001\u0003\u0007AqA!\u0019\u0001\t\u0003\t\u0019\u0001C\u0004\u0003h\u0001!\t!a\u0001\t\u000f\t5\u0004\u0001\"\u0001\u0002\u0004!9!1\u000f\u0001\u0005\u0002\u0005\r\u0001b\u0002B=\u0001\u0011\u0005\u00111\u0001\u0005\b\u0005\u007f\u0002A\u0011\u0001BA\u0011\u001d\u0011i\t\u0001C\u0001\u0003\u0007AqAa%\u0001\t\u0003\t\u0019\u0001C\u0004\u0003\u001a\u0002!\t!a\u0001\t\u000f\t}\u0005\u0001\"\u0001\u0002\u0004!9!Q\u0015\u0001\u0005\u0002\u0005\r!aF&bM.\f'+Z9vKN$\b*\u00198eY\u0016\u0014H+Z:u\u0015\tid(\u0001\u0004tKJ4XM\u001d\u0006\u0002\u007f\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001C!\t\u0019e)D\u0001E\u0015\u0005)\u0015!B:dC2\f\u0017BA$E\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u0013\t\u0003\u0017\u0002i\u0011\u0001P\u0001\u0005i&lW-F\u0001O!\ty\u0015,D\u0001Q\u0015\t\t&+A\u0003vi&d7O\u0003\u0002T)\u000611m\\7n_:T!aP+\u000b\u0005Y;\u0016AB1qC\u000eDWMC\u0001Y\u0003\ry'oZ\u0005\u00035B\u0013\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\u0006aJ|\u0007o]\u000b\u0002=B\u0011q\fZ\u0007\u0002A*\u0011\u0011MY\u0001\u0005kRLGNC\u0001d\u0003\u0011Q\u0017M^1\n\u0005\u0015\u0004'A\u0003)s_B,'\u000f^5fg\u00061\u0001O]8qg\u0002\n\u0001C\u0019:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\u0016\u0003%\u0004\"a\u00136\n\u0005-d$\u0001\u0005\"s_.,'\u000fV8qS\u000e\u001cF/\u0019;t\u0003E\u0011'o\\6feR{\u0007/[2Ti\u0006$8\u000fI\u0001\u0006i>\u0004\u0018nY\u000b\u0002_B\u0011\u0001o]\u0007\u0002c*\u0011!OY\u0001\u0005Y\u0006tw-\u0003\u0002uc\n11\u000b\u001e:j]\u001e\fa\u0001^8qS\u000e\u0004\u0013A\u0002;pa&\u001c''A\u0004u_BL7M\r\u0011\u0002%\t\u0014xn[3s)>\u0004\u0018nY'fiJL7m]\u000b\u0002uB\u00111j_\u0005\u0003yr\u0012!C\u0011:pW\u0016\u0014Hk\u001c9jG6+GO]5dg\u0006\u0019\"M]8lKJ$v\u000e]5d\u001b\u0016$(/[2tA\u0005y\u0011\r\u001c7U_BL7-T3ue&\u001c7/\u0001\tbY2$v\u000e]5d\u001b\u0016$(/[2tA\u0005\u0011B/Z:u\u0007\u0006dGNY1dWRKW.\u001b8h)\t\t)\u0001E\u0002D\u0003\u000fI1!!\u0003E\u0005\u0011)f.\u001b;)\u0007A\ti\u0001\u0005\u0003\u0002\u0010\u0005uQBAA\t\u0015\u0011\t\u0019\"!\u0006\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002\u0018\u0005e\u0011a\u00026va&$XM\u001d\u0006\u0004\u000379\u0016!\u00026v]&$\u0018\u0002BA\u0010\u0003#\u0011A\u0001V3ti\u0006\tB/Z:u\u000b:<\u0017N\\3NKR\u0014\u0018nY:)\u0007E\ti!A\ruKN$H)\u001a4bk2$(+Z9vKN$Hj\\4hS:<G\u0003BA\u0003\u0003SAq!a\u000b\u0013\u0001\u0004\ti#A\u0005tQ>,H\u000e\u001a'pOB\u00191)a\f\n\u0007\u0005EBIA\u0004C_>dW-\u00198)\u0007I\t)\u0004\u0005\u0003\u00028\u0005uRBAA\u001d\u0015\u0011\tY$!\u0006\u0002\rA\f'/Y7t\u0013\u0011\ty$!\u000f\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH\u000fK\u0004\u0013\u0003\u0007\ny%!\u0015\u0011\t\u0005\u0015\u00131J\u0007\u0003\u0003\u000fRA!!\u0013\u0002:\u0005A\u0001O]8wS\u0012,'/\u0003\u0003\u0002N\u0005\u001d#a\u0003,bYV,7k\\;sG\u0016\f\u0001BY8pY\u0016\fgn\u001d\u0017\u0005\u0003'\n)&G\u0001\u00023\u0005\u0001\u0011A\b;fgR\u001c\u0015\r\u001c7cC\u000e\\GK]=D_6\u0004H.\u001a;f\u0003\u000e$\u0018n\u001c8tQ\r\u0019\u0012QB\u0001 i\u0016\u001cH\u000fS1oI2LgnZ\"bY2\u0014\u0017mY6P]:+w\u000f\u00165sK\u0006$\u0007f\u0001\u000b\u0002\u000e\u0005AB/Z:u\u0007\u0006dGNY1dW>s7+Y7f)\"\u0014X-\u00193)\u0007U\ti!\u0001\buKN$Hk\u001c9jGN#\u0018\r^:\u0015\t\u0005\u0015\u0011q\r\u0005\b\u0003S2\u0002\u0019AA\u0017\u0003i\u0019\u0018p\u001d;f[J+Wn\u001c;f'R|'/Y4f\u000b:\f'\r\\3eQ\r1\u0012Q\u0007\u0015\b-\u0005\r\u0013qJA8Y\u0011\t\u0019&!\u0016)\u0007Y\t\u0019\b\u0005\u0003\u0002\u0010\u0005U\u0014\u0002BA<\u0003#\u0011\u0001\u0002R5tC\ndW\rZ\u0001\u0015]\u0016<Xj\\2lK\u0012\\\u0015MZ6b\u0007>tg-[4\u0015\r\u0005u\u00141QAJ!\rY\u0015qP\u0005\u0004\u0003\u0003c$aC&bM.\f7i\u001c8gS\u001eD\u0011\"!\"\u0018!\u0003\u0005\r!a\"\u0002!I,\u0017/^3ti2{wMR5mi\u0016\u0014\b\u0003BAE\u0003\u001fk!!a#\u000b\u0007\u00055%+\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\t\t*a#\u0003!I+\u0017/^3ti2{wMR5mi\u0016\u0014\b\"CAK/A\u0005\t\u0019AAD\u00039\tW\u000fZ5u\u0019><g)\u001b7uKJ\faD\\3x\u001b>\u001c7.\u001a3LC\u001a\\\u0017mQ8oM&<G\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005m%\u0006BAD\u0003;[#!a(\u0011\t\u0005\u0005\u00161V\u0007\u0003\u0003GSA!!*\u0002(\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003S#\u0015AC1o]>$\u0018\r^5p]&!\u0011QVAR\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001f]\u0016<Xj\\2lK\u0012\\\u0015MZ6b\u0007>tg-[4%I\u00164\u0017-\u001e7uII\naB]3dK&4XMU3rk\u0016\u001cH\u000f\u0006\u0003\u00026\u0006%\u0007\u0003BA\\\u0003\u0007tA!!/\u0002@6\u0011\u00111\u0018\u0006\u0004\u0003{s\u0014a\u00028fi^|'o[\u0005\u0005\u0003\u0003\fY,\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\n\t\u0005\u0015\u0017q\u0019\u0002\b%\u0016\fX/Z:u\u0015\u0011\t\t-a/\t\u000f\u0005-'\u00041\u0001\u0002~\u000511m\u001c8gS\u001e\f\u0001CY;jY\u0012$Vm\u001d;SKF,Xm\u001d;\u0015\u0005\u0005U\u0016aC7bW\u0016\u0014V-];fgR$b!!.\u0002V\u0006u\u0007B\u0002'\u001d\u0001\u0004\t9\u000eE\u0002P\u00033L1!a7Q\u0005\u0011!\u0016.\\3\t\u000f\u0005}G\u00041\u0001\u0002b\u00069Q.\u001a;sS\u000e\u001c\b\u0003BA\\\u0003GLA!!:\u0002H\n9Q*\u001a;sS\u000e\u001c\u0018aF:fiV\u0004(I]8lKJ$v\u000e]5d\u001b\u0016$(/[2t)\rQ\u00181\u001e\u0005\n\u0003Sj\u0002\u0013!a\u0001\u0003[\t\u0011e]3ukB\u0014%o\\6feR{\u0007/[2NKR\u0014\u0018nY:%I\u00164\u0017-\u001e7uIE*\"!!=+\t\u00055\u0012QT\u0001\u001fi\u0016\u001cHoU5oOVd\u0017M]\"pafd\u0015m\u001a\"zi\u0016\u001cX*\u001a;sS\u000e$B!!\u0002\u0002x\"9\u0011\u0011N\u0010A\u0002\u00055\u0002fA\u0010\u00026!:q$a\u0011\u0002P\u0005uH\u0006BA*\u0003+B3aHA:\u0003}!Xm\u001d;Nk2$\u0018\u000e\u001d7f\u0007>\u0004\u0018\u0010T1h\u0005f$Xm]'fiJL7m\u001d\u0015\u0004A\u00055\u0001f\u0001\u0011\u0002t\u0005aC/Z:u\u0007>\u0004\u0018\u0010T1h\u0005f$Xm]'fiJL7mV5uQB\u000b'\u000f^5uS>tW\t\u001f9b]NLwN\u001c\u0015\u0004C\u00055\u0001fA\u0011\u0002t\u0005aC/Z:u\u0007>\u0004\u0018\u0010T1h\u0005f$Xm]'fiJL7mV5uQB\u000b'\u000f^5uS>t7\u000b\u001b:j].Lgn\u001a\u0015\u0004E\u00055\u0001f\u0001\u0012\u0002t\u00059D/Z:u\u0007>\u0004\u0018\u0010T1h\u0005f$Xm]'fiJL7mV5uQJ+Wn\u001c<j]\u001etuN\\3ySN$XM\u001c;QCJ$\u0018\u000e^5p]ND3aIA\u0007Q\r\u0019\u00131O\u0001\u001ci\u0016\u001cHoQ8qs2\u000bwMQ=uKNlU\r\u001e:jG\u000ecW-\u0019:)\u0007\u0011\ni\u0001K\u0002%\u0003g\n!\u0005^3ti6+H\u000e^5qY\u0016\u001cu\u000e]=MC\u001e\u001cVmZ7f]R\u001cX*\u001a;sS\u000e\u001c\bfA\u0013\u0002\u000e!\u001aQ%a\u001d\u0002_Q,7\u000f^\"pafd\u0015mZ*fO6,g\u000e^:NKR\u0014\u0018nY,ji\"\u0004\u0016M\u001d;ji&|g.\u0012=qC:\u001c\u0018n\u001c8)\u0007\u0019\ni\u0001K\u0002'\u0003g\nq\u0006^3ti\u000e{\u0007/\u001f'bON+w-\\3oiNlU\r\u001e:jG^KG\u000f\u001b)beRLG/[8o'\"\u0014\u0018N\\6j]\u001eD3aJA\u0007Q\r9\u00131O\u0001;i\u0016\u001cHoQ8qs2\u000bwmU3h[\u0016tGo]'fiJL7mV5uQJ+Wn\u001c<j]\u001etuN\\3ySN$XM\u001c;QCJ$\u0018\u000e^5p]ND3\u0001KA\u0007Q\rA\u00131O\u0001\u001fi\u0016\u001cHoQ8qs2\u000bwmU3h[\u0016tGo]'fiJL7m\u00117fCJD3!KA\u0007Q\rI\u00131O\u0001\"i\u0016\u001cH/T;mi&\u0004H.\u001a#fY\u0016$X\rT1h\u0005f$Xm]'fiJL7m\u001d\u0015\u0004U\u00055\u0001f\u0001\u0016\u0002t\u0005qC/Z:u\t\u0016dW\r^3MC\u001e\u0014\u0015\u0010^3t\u001b\u0016$(/[2XSRD\u0007+\u0019:uSRLwN\\#ya\u0006t7/[8oQ\rY\u0013Q\u0002\u0015\u0004W\u0005M\u0014A\f;fgR$U\r\\3uK2\u000bwMQ=uKNlU\r\u001e:jG^KG\u000f\u001b)beRLG/[8o'\"\u0014\u0018N\\6j]\u001eD3\u0001LA\u0007Q\ra\u00131O\u0001:i\u0016\u001cH\u000fR3mKR,G*Y4CsR,7/T3ue&\u001cw+\u001b;i%\u0016lwN^5oO:{g.\u001a=jgR,g\u000e\u001e)beRLG/[8og\"\u001aQ&!\u0004)\u00075\n\u0019(A\u000fuKN$H)\u001a7fi\u0016d\u0015m\u001a\"zi\u0016\u001cX*\u001a;sS\u000e\u001cE.Z1sQ\rq\u0013Q\u0002\u0015\u0004]\u0005M\u0014\u0001\n;fgRlU\u000f\u001c;ja2,G)\u001a7fi\u0016d\u0015mZ*fO6,g\u000e^:NKR\u0014\u0018nY:)\u0007=\ni\u0001K\u00020\u0003g\n\u0011\u0007^3ti\u0012+G.\u001a;f\u0019\u0006<7+Z4nK:$8/T3ue&\u001cw+\u001b;i!\u0006\u0014H/\u001b;j_:,\u0005\u0010]1og&|g\u000eK\u00021\u0003\u001bA3\u0001MA:\u0003E\"Xm\u001d;EK2,G/\u001a'bON+w-\\3oiNlU\r\u001e:jG^KG\u000f\u001b)beRLG/[8o'\"\u0014\u0018N\\6j]\u001eD3!MA\u0007Q\r\t\u00141O\u0001=i\u0016\u001cH\u000fR3mKR,G*Y4TK\u001elWM\u001c;t\u001b\u0016$(/[2XSRD'+Z7pm&twMT8oKbL7\u000f^3oiB\u000b'\u000f^5uS>t7\u000fK\u00023\u0003\u001bA3AMA:\u0003\u0001\"Xm\u001d;EK2,G/\u001a'bON+w-\\3oiNlU\r\u001e:jG\u000ecW-\u0019:)\u0007M\ni\u0001K\u00024\u0003g\n!\u0004^3tiJ+Wn\u001c;f\u0019><W*\u001a;bI\u0006$\u0018mQ8v]RD3\u0001NA\u0007Q\r!\u00141O\u0001\u001fi\u0016\u001cHoU5oOVd\u0017M\u001d'pONK'0\u001a\"zi\u0016\u001cX*\u001a;sS\u000e$B!!\u0002\u0003\u0004\"9\u0011\u0011N\u001bA\u0002\u00055\u0002fA\u001b\u00026!:Q'a\u0011\u0002P\t%E\u0006BA*\u0003+B3!NA:\u0003}!Xm\u001d;Nk2$\u0018\u000e\u001d7f\u0019><7+\u001b>f\u0005f$Xm]'fiJL7m\u001d\u0015\u0004m\u00055\u0001f\u0001\u001c\u0002t\u0005aC/Z:u\u0019><7+\u001b>f\u0005f$Xm]'fiJL7mV5uQB\u000b'\u000f^5uS>tW\t\u001f9b]NLwN\u001c\u0015\u0004o\u00055\u0001fA\u001c\u0002t\u0005aC/Z:u\u0019><7+\u001b>f\u0005f$Xm]'fiJL7mV5uQB\u000b'\u000f^5uS>t7\u000b\u001b:j].Lgn\u001a\u0015\u0004q\u00055\u0001f\u0001\u001d\u0002t\u00059D/Z:u\u0019><7+\u001b>f\u0005f$Xm]'fiJL7mV5uQJ+Wn\u001c<j]\u001etuN\\3ySN$XM\u001c;QCJ$\u0018\u000e^5p]ND3!OA\u0007Q\rI\u00141O\u0001\u001ci\u0016\u001cH\u000fT8h'&TXMQ=uKNlU\r\u001e:jG\u000ecW-\u0019:)\u0007i\ni\u0001K\u0002;\u0003g\u0002")
public class KafkaRequestHandlerTest {
    private final MockTime time = new MockTime();
    private final Properties props = TestUtils$.MODULE$.createDummyBrokerConfig();
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats(Optional.of(KafkaConfig$.MODULE$.fromProps(this.props())));
    private final String topic;
    private final String topic2;
    private final BrokerTopicMetrics brokerTopicMetrics = this.brokerTopicStats().topicStats(this.topic());
    private final BrokerTopicMetrics allTopicMetrics = this.brokerTopicStats().allTopicsStats();

    public MockTime time() {
        return this.time;
    }

    public Properties props() {
        return this.props;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public String topic() {
        return this.topic;
    }

    public String topic2() {
        return this.topic2;
    }

    public BrokerTopicMetrics brokerTopicMetrics() {
        return this.brokerTopicMetrics;
    }

    public BrokerTopicMetrics allTopicMetrics() {
        return this.allTopicMetrics;
    }

    @Test
    public void testCallbackTiming() {
        MockTime time = new MockTime();
        long startTime = time.nanoseconds();
        RequestChannel.Metrics metrics = new RequestChannel.Metrics(Option$.MODULE$.option2Iterable((Option)None$.MODULE$));
        RequestChannel requestChannel = new RequestChannel(10, "", new Metrics(), (Time)time, metrics, (ActionQueue)new DelayedActionQueue());
        ApiRequestHandler apiHandler = (ApiRequestHandler)Mockito.mock(ApiRequestHandler.class);
        try {
            KafkaRequestHandler handler = new KafkaRequestHandler(0, this.newMockedKafkaConfig(RequestLogFilter.MATCH_NONE, RequestLogFilter.MATCH_NONE), "", 0, (Meter)Mockito.mock(Meter.class), new AtomicInteger(1), requestChannel, apiHandler, (Time)time, "broker");
            RequestChannel.Request request = this.makeRequest((Time)time, metrics);
            requestChannel.sendRequest(request);
            apiHandler.handle((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (RequestLogger)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
            Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$1 -> {
                KafkaRequestHandlerTest.$anonfun$testCallbackTiming$1(time, handler, request, x$1);
                return BoxedUnit.UNIT;
            });
            handler.run();
            Assertions.assertEquals((long)startTime, (long)request.requestDequeueTimeNanos());
            Assertions.assertEquals((long)(startTime + 2000000L), (long)request.apiLocalCompleteTimeNanos());
            Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)(startTime + 2000000L))), (Object)request.callbackRequestDequeueTimeNanos());
            Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)(startTime + 3000000L))), (Object)request.callbackRequestCompleteTimeNanos());
        }
        finally {
            metrics.close();
        }
    }

    @Test
    public void testEngineMetrics() {
        ThreadCountersManager.threadCountersManagerEnabled = true;
        Thread thread = new Thread(() -> {
            ThreadCountersManager.LocalCounters.setThreadType((ThreadLocalCounters.ThreadGroupType)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
            this.receiveRequest(this.newMockedKafkaConfig(RequestLogFilter.MATCH_NONE, RequestLogFilter.MATCH_NONE));
        });
        thread.start();
        thread.join();
        Map threadLocalCountersForAllThreads = ThreadCountersManager.getThreadLocalCounterSnapshotForAllKnownThreads();
        Assertions.assertTrue((boolean)threadLocalCountersForAllThreads.containsKey(thread));
        ((List)threadLocalCountersForAllThreads.get(thread)).forEach(counter -> {
            block7: {
                block6: {
                    ThreadLocalCounters.MetricComponentType metricComponentType;
                    ThreadLocalCounters.MetricComponentType metricComponentType2;
                    block5: {
                        Assertions.assertEquals((Object)counter.threadGroupType, (Object)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
                        metricComponentType2 = counter.metricComponentType;
                        metricComponentType = ThreadLocalCounters.MetricComponentType.ENGINE;
                        if (metricComponentType2 != null) break block5;
                        if (metricComponentType != null) {
                            return;
                        }
                        break block6;
                    }
                    if (!metricComponentType2.equals(metricComponentType)) break block7;
                }
                Assertions.assertEquals((long)1L, (long)counter.numSuccessOps);
                return;
            }
        });
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDefaultRequestLogging(boolean shouldLog) {
        Log4jController$.MODULE$.logLevel(RequestChannel$.MODULE$.RequestLoggerName(), "INFO");
        this.assertRequestLogAction$1(shouldLog ? LogAction.LOGGED : LogAction.NOT_LOGGED, shouldLog);
        Log4jController$.MODULE$.logLevel(RequestChannel$.MODULE$.RequestLoggerName(), "DEBUG");
        this.assertRequestLogAction$1(LogAction.LOGGED, shouldLog);
    }

    @Test
    public void testCallbackTryCompleteActions() {
        IntRef handledCount = IntRef.create((int)0);
        IntRef tryCompleteActionCount = IntRef.create((int)0);
        MockTime time = new MockTime();
        RequestChannel.Metrics metrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
        ApiRequestHandler apiHandler = (ApiRequestHandler)Mockito.mock(ApiRequestHandler.class);
        public class Kafka_server_KafkaRequestHandlerTest$TryCompleteRequestChannel$1
        extends RequestChannel {
            private final IntRef tryCompleteActionCount$1;

            public void tryCompleteActions() {
                super.tryCompleteActions();
                ++this.tryCompleteActionCount$1.elem;
            }

            public Kafka_server_KafkaRequestHandlerTest$TryCompleteRequestChannel$1(KafkaRequestHandlerTest $outer, MockTime time$2, RequestChannel.Metrics metrics$1, IntRef tryCompleteActionCount$1) {
                this.tryCompleteActionCount$1 = tryCompleteActionCount$1;
                super(10, "", new Metrics(), (Time)time$2, metrics$1, (ActionQueue)new DelayedActionQueue());
            }
        }
        Kafka_server_KafkaRequestHandlerTest$TryCompleteRequestChannel$1 requestChannel = new Kafka_server_KafkaRequestHandlerTest$TryCompleteRequestChannel$1(null, time, metrics, tryCompleteActionCount);
        KafkaRequestHandler handler = new KafkaRequestHandler(0, this.newMockedKafkaConfig(RequestLogFilter.MATCH_NONE, RequestLogFilter.MATCH_NONE), "", 0, (Meter)Mockito.mock(Meter.class), new AtomicInteger(1), (RequestChannel)requestChannel, apiHandler, (Time)time, "broker");
        RequestChannel.Request request = this.makeRequest((Time)time, metrics);
        requestChannel.sendRequest(request);
        apiHandler.handle((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (RequestLogger)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$2 -> {
            ++handledCount$1.elem;
            return CompletableFuture.runAsync(() -> KafkaRequestHandlerTest.$anonfun$testCallbackTryCompleteActions$3(KafkaRequestHandler$.MODULE$.wrapAsyncCallback((Function2 & Serializable)(reqLocal, ms) -> {
                handler.stop();
                return BoxedUnit.UNIT;
            }, RequestLocal$.MODULE$.NoCaching())));
        });
        handler.run();
        Assertions.assertEquals((int)1, (int)handledCount.elem);
        Assertions.assertEquals((int)1, (int)tryCompleteActionCount.elem);
    }

    @Test
    public void testHandlingCallbackOnNewThread() {
        MockTime time = new MockTime();
        RequestChannel.Metrics metrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
        ApiRequestHandler apiHandler = (ApiRequestHandler)Mockito.mock(ApiRequestHandler.class);
        RequestChannel requestChannel = new RequestChannel(10, "", new Metrics(), (Time)time, metrics, (ActionQueue)new DelayedActionQueue());
        KafkaRequestHandler handler = new KafkaRequestHandler(0, this.newMockedKafkaConfig(RequestLogFilter.MATCH_NONE, RequestLogFilter.MATCH_NONE), "", 0, (Meter)Mockito.mock(Meter.class), new AtomicInteger(1), requestChannel, apiHandler, (Time)time, "broker");
        RequestLocal originalRequestLocal = (RequestLocal)Mockito.mock(RequestLocal.class);
        IntRef handledCount = IntRef.create((int)0);
        RequestChannel.Request request = this.makeRequest((Time)time, metrics);
        requestChannel.sendRequest(request);
        apiHandler.handle((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (RequestLogger)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$3 -> CompletableFuture.runAsync(() -> KafkaRequestHandlerTest.$anonfun$testHandlingCallbackOnNewThread$3(KafkaRequestHandler$.MODULE$.wrapAsyncCallback((Function2 & Serializable)(reqLocal, ms) -> {
            KafkaRequestHandlerTest.$anonfun$testHandlingCallbackOnNewThread$2(handledCount, handler, reqLocal, BoxesRunTime.unboxToInt((Object)ms));
            return BoxedUnit.UNIT;
        }, originalRequestLocal))));
        handler.run();
        ((RequestLocal)Mockito.verify((Object)originalRequestLocal, (VerificationMode)Mockito.times((int)0))).bufferSupplier();
        Assertions.assertEquals((int)1, (int)handledCount.elem);
    }

    @Test
    public void testCallbackOnSameThread() {
        MockTime time = new MockTime();
        RequestChannel.Metrics metrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
        ApiRequestHandler apiHandler = (ApiRequestHandler)Mockito.mock(ApiRequestHandler.class);
        RequestChannel requestChannel = new RequestChannel(10, "", new Metrics(), (Time)time, metrics, (ActionQueue)new DelayedActionQueue());
        KafkaRequestHandler handler = new KafkaRequestHandler(0, this.newMockedKafkaConfig(RequestLogFilter.MATCH_NONE, RequestLogFilter.MATCH_NONE), "", 0, (Meter)Mockito.mock(Meter.class), new AtomicInteger(1), requestChannel, apiHandler, (Time)time, "broker");
        RequestLocal originalRequestLocal = (RequestLocal)Mockito.mock(RequestLocal.class);
        Mockito.when((Object)originalRequestLocal.bufferSupplier()).thenReturn((Object)BufferSupplier.create());
        IntRef handledCount = IntRef.create((int)0);
        RequestChannel.Request request = this.makeRequest((Time)time, metrics);
        requestChannel.sendRequest(request);
        apiHandler.handle((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (RequestLogger)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$4 -> {
            KafkaRequestHandlerTest.$anonfun$testCallbackOnSameThread$1(handledCount, handler, originalRequestLocal, x$4);
            return BoxedUnit.UNIT;
        });
        handler.run();
        ((RequestLocal)Mockito.verify((Object)originalRequestLocal, (VerificationMode)Mockito.times((int)1))).bufferSupplier();
        Assertions.assertEquals((int)1, (int)handledCount.elem);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @Disabled
    public void testTopicStats(boolean systemRemoteStorageEnabled) {
        Properties props = TestUtils$.MODULE$.createDummyBrokerConfig();
        props.setProperty("remote.log.storage.system.enable", Boolean.toString(systemRemoteStorageEnabled));
        BrokerTopicMetrics brokerTopicMetrics = new BrokerTopicStats(false, Optional.of(KafkaConfig$.MODULE$.fromProps(props))).topicStats(this.topic());
        Set gaugeMetrics = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{RemoteStorageMetrics.REMOTE_LOG_SIZE_COMPUTATION_TIME_METRIC.getName(), RemoteStorageMetrics.REMOTE_COPY_LAG_BYTES_METRIC.getName(), RemoteStorageMetrics.REMOTE_COPY_LAG_SEGMENTS_METRIC.getName(), RemoteStorageMetrics.REMOTE_DELETE_LAG_BYTES_METRIC.getName(), RemoteStorageMetrics.REMOTE_DELETE_LAG_SEGMENTS_METRIC.getName(), RemoteStorageMetrics.REMOTE_LOG_SIZE_COMPUTATION_TIME_METRIC.getName(), RemoteStorageMetrics.REMOTE_LOG_METADATA_COUNT_METRIC.getName(), RemoteStorageMetrics.REMOTE_LOG_SIZE_BYTES_METRIC.getName()}));
        RemoteStorageMetrics.brokerTopicStatsMetrics().forEach(metric -> {
            if (systemRemoteStorageEnabled) {
                if (!gaugeMetrics.contains((Object)metric.getName())) {
                    Assertions.assertTrue((boolean)brokerTopicMetrics.metricMap().contains((Object)metric.getName()), (String)new StringBuilder(23).append("the metric is missing: ").append(metric.getName()).toString());
                    return;
                }
                Assertions.assertFalse((boolean)brokerTopicMetrics.metricMap().contains((Object)metric.getName()), (String)new StringBuilder(30).append("the metric should not appear: ").append(metric.getName()).toString());
                return;
            }
            Assertions.assertFalse((boolean)brokerTopicMetrics.metricMap().contains((Object)metric.getName()));
        });
        gaugeMetrics.foreach((Function1 & Serializable)metricName -> {
            KafkaRequestHandlerTest.$anonfun$testTopicStats$2(systemRemoteStorageEnabled, brokerTopicMetrics, metricName);
            return BoxedUnit.UNIT;
        });
    }

    private KafkaConfig newMockedKafkaConfig(RequestLogFilter requestLogFilter, RequestLogFilter auditLogFilter) {
        KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        Mockito.when((Object)config.newRequestLogFilter()).thenReturn((Object)requestLogFilter);
        Mockito.when((Object)config.newDetailedRequestAuditLogFilter()).thenReturn((Object)auditLogFilter);
        return config;
    }

    private RequestLogFilter newMockedKafkaConfig$default$1() {
        return RequestLogFilter.MATCH_NONE;
    }

    private RequestLogFilter newMockedKafkaConfig$default$2() {
        return RequestLogFilter.MATCH_NONE;
    }

    private RequestChannel.Request receiveRequest(KafkaConfig config) {
        Meter aggregateIdleMeter = (Meter)Mockito.mock(Meter.class);
        RequestChannel requestChannel = (RequestChannel)Mockito.mock(RequestChannel.class);
        ApiRequestHandler apiHandler = (ApiRequestHandler)Mockito.mock(ApiRequestHandler.class);
        KafkaRequestHandler handler = new KafkaRequestHandler(0, config, "cluster", 0, aggregateIdleMeter, new AtomicInteger(1), requestChannel, apiHandler, (Time)this.time(), "broker");
        RequestChannel.Request request = this.buildTestRequest();
        Mockito.when((Object)requestChannel.receiveRequest(0L)).thenReturn((Object)request);
        apiHandler.handle((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (RequestLogger)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> {
            KafkaRequestHandlerTest.$anonfun$receiveRequest$1(invocation);
            return BoxedUnit.UNIT;
        });
        handler.poll(0);
        ((ApiRequestHandler)Mockito.verify((Object)apiHandler)).handle((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (RequestLogger)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        return request;
    }

    private RequestChannel.Request buildTestRequest() {
        RequestHeader requestHeader = new RequestHeader(ApiKeys.METADATA, ApiKeys.METADATA.latestVersion(), "clientId", 1379);
        RequestContext requestContext = new RequestContext(requestHeader, "connectionId", InetAddress.getLoopbackAddress(), KafkaPrincipal.ANONYMOUS, new ListenerName("PLAINTEXT"), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, null, false);
        ByteBuffer buffer = ((MetadataRequest)MetadataRequest.Builder.allTopics().build()).serialize();
        RequestChannel.Metrics requestMetrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
        return new RequestChannel.Request(0, requestContext, this.time().nanoseconds(), MemoryPool.NONE, buffer, requestMetrics, (Option)None$.MODULE$, Context.root(), NoOpEventEmitter.INSTANCE, (AuditLogProvider)NoOpAuditLogProvider.INSTANCE, RequestLogFilter.MATCH_NONE, 0L);
    }

    private RequestChannel.Request makeRequest(Time time, RequestChannel.Metrics metrics) {
        RequestHeader requestHeader = (RequestHeader)Mockito.mock(RequestHeader.class);
        Mockito.when((Object)requestHeader.apiKey()).thenReturn((Object)ApiKeys.API_VERSIONS);
        Mockito.when((Object)BoxesRunTime.boxToShort((short)requestHeader.apiVersion())).thenReturn((Object)BoxesRunTime.boxToShort((short)((short)0)));
        RequestContext context = new RequestContext(requestHeader, "0", (InetAddress)Mockito.mock(InetAddress.class), new KafkaPrincipal("", ""), new ListenerName(""), SecurityProtocol.PLAINTEXT, (ClientInformation)Mockito.mock(ClientInformation.class), null, false);
        return new RequestChannel.Request(0, context, time.nanoseconds(), (MemoryPool)Mockito.mock(MemoryPool.class), ByteBuffer.allocate(0), metrics, (Option)None$.MODULE$, Context.root(), NoOpEventEmitter.INSTANCE, (AuditLogProvider)NoOpAuditLogProvider.INSTANCE, RequestLogFilter.MATCH_NONE, 0L);
    }

    public BrokerTopicMetrics setupBrokerTopicMetrics(boolean systemRemoteStorageEnabled) {
        String topic = "topic";
        Properties props = TestUtils$.MODULE$.createDummyBrokerConfig();
        props.setProperty("remote.log.storage.system.enable", Boolean.toString(systemRemoteStorageEnabled));
        return new BrokerTopicMetrics(Option$.MODULE$.apply((Object)topic), Optional.of(KafkaConfig$.MODULE$.fromProps(props)), false);
    }

    public boolean setupBrokerTopicMetrics$default$1() {
        return true;
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @Disabled
    public void testSingularCopyLagBytesMetric(boolean systemRemoteStorageEnabled) {
        Properties props = TestUtils$.MODULE$.createDummyBrokerConfig();
        props.setProperty("remote.log.storage.system.enable", Boolean.toString(systemRemoteStorageEnabled));
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats(Optional.of(KafkaConfig$.MODULE$.fromProps(props)));
        BrokerTopicMetrics brokerTopicMetrics = brokerTopicStats.topicStats(this.topic());
        if (systemRemoteStorageEnabled) {
            brokerTopicStats.recordRemoteCopyLagBytes(this.topic(), 0, 100L);
            brokerTopicStats.recordRemoteCopyLagBytes(this.topic(), 1, 150L);
            brokerTopicStats.recordRemoteCopyLagBytes(this.topic(), 2, 250L);
            Assertions.assertEquals((long)500L, (long)brokerTopicMetrics.remoteCopyLagBytes());
            Assertions.assertEquals((long)500L, (long)brokerTopicStats.allTopicsStats().remoteCopyLagBytes());
            brokerTopicStats.recordRemoteCopyLagBytes(this.topic2(), 0, 100L);
            Assertions.assertEquals((long)600L, (long)brokerTopicStats.allTopicsStats().remoteCopyLagBytes());
            return;
        }
        Assertions.assertEquals((Object)None$.MODULE$, (Object)brokerTopicMetrics.metricGaugeMap().get((Object)RemoteStorageMetrics.REMOTE_COPY_LAG_BYTES_METRIC.getName()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)brokerTopicStats.allTopicsStats().metricGaugeMap().get((Object)RemoteStorageMetrics.REMOTE_COPY_LAG_BYTES_METRIC.getName()));
    }

    @Test
    @Disabled
    public void testMultipleCopyLagBytesMetrics() {
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 1, 2L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 2, 3L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 0, 4L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 1, 5L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 2, 6L);
        Assertions.assertEquals((long)15L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)15L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic2(), 2, 5L);
        Assertions.assertEquals((long)20L, (long)this.allTopicMetrics().remoteCopyLagBytes());
    }

    @Test
    @Disabled
    public void testCopyLagBytesMetricWithPartitionExpansion() {
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 2, 3L);
        Assertions.assertEquals((long)6L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)6L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic2(), 0, 1L);
        Assertions.assertEquals((long)7L, (long)this.allTopicMetrics().remoteCopyLagBytes());
    }

    @Test
    @Disabled
    public void testCopyLagBytesMetricWithPartitionShrinking() {
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().removeRemoteCopyLagBytes(this.topic(), 1);
        Assertions.assertEquals((long)1L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)1L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic2(), 0, 1L);
        Assertions.assertEquals((long)2L, (long)this.allTopicMetrics().remoteCopyLagBytes());
    }

    @Test
    @Disabled
    public void testCopyLagBytesMetricWithRemovingNonexistentPartitions() {
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().removeRemoteCopyLagBytes(this.topic(), 3);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagBytes());
    }

    @Test
    @Disabled
    public void testCopyLagBytesMetricClear() {
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().close();
        Assertions.assertEquals((long)0L, (long)this.brokerTopicMetrics().remoteCopyLagBytes());
        Assertions.assertEquals((long)0L, (long)this.allTopicMetrics().remoteCopyLagBytes());
        this.brokerTopicStats().recordRemoteCopyLagBytes(this.topic2(), 0, 1L);
        Assertions.assertEquals((long)1L, (long)this.allTopicMetrics().remoteCopyLagBytes());
    }

    @Test
    @Disabled
    public void testMultipleCopyLagSegmentsMetrics() {
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 1, 2L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 2, 3L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 0, 4L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 1, 5L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 2, 6L);
        Assertions.assertEquals((long)15L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)15L, (long)this.allTopicMetrics().remoteCopyLagSegments());
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic2(), 0, 1L);
        Assertions.assertEquals((long)16L, (long)this.allTopicMetrics().remoteCopyLagSegments());
    }

    @Test
    @Disabled
    public void testCopyLagSegmentsMetricWithPartitionExpansion() {
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagSegments());
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 2, 3L);
        Assertions.assertEquals((long)6L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)6L, (long)this.allTopicMetrics().remoteCopyLagSegments());
    }

    @Test
    @Disabled
    public void testCopyLagSegmentsMetricWithPartitionShrinking() {
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagSegments());
        this.brokerTopicStats().removeRemoteCopyLagSegments(this.topic(), 1);
        Assertions.assertEquals((long)1L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)1L, (long)this.allTopicMetrics().remoteCopyLagSegments());
    }

    @Test
    @Disabled
    public void testCopyLagSegmentsMetricWithRemovingNonexistentPartitions() {
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagSegments());
        this.brokerTopicStats().removeRemoteCopyLagSegments(this.topic(), 3);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagSegments());
    }

    @Test
    @Disabled
    public void testCopyLagSegmentsMetricClear() {
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteCopyLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteCopyLagSegments());
        this.brokerTopicStats().close();
        Assertions.assertEquals((long)0L, (long)this.brokerTopicMetrics().remoteCopyLagSegments());
        Assertions.assertEquals((long)0L, (long)this.allTopicMetrics().remoteCopyLagSegments());
    }

    @Test
    @Disabled
    public void testMultipleDeleteLagBytesMetrics() {
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 1, 2L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 2, 3L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 0, 4L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 1, 5L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 2, 6L);
        Assertions.assertEquals((long)15L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)15L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic2(), 0, 1L);
        Assertions.assertEquals((long)16L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
    }

    @Test
    @Disabled
    public void testDeleteLagBytesMetricWithPartitionExpansion() {
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 2, 3L);
        Assertions.assertEquals((long)6L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)6L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
    }

    @Test
    @Disabled
    public void testDeleteLagBytesMetricWithPartitionShrinking() {
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
        this.brokerTopicStats().removeRemoteDeleteLagBytes(this.topic(), 1);
        Assertions.assertEquals((long)1L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)1L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
    }

    @Test
    @Disabled
    public void testDeleteLagBytesMetricWithRemovingNonexistentPartitions() {
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
        this.brokerTopicStats().removeRemoteDeleteLagBytes(this.topic(), 3);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
    }

    @Test
    @Disabled
    public void testDeleteLagBytesMetricClear() {
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
        this.brokerTopicStats().close();
        Assertions.assertEquals((long)0L, (long)this.brokerTopicMetrics().remoteDeleteLagBytes());
        Assertions.assertEquals((long)0L, (long)this.allTopicMetrics().remoteDeleteLagBytes());
    }

    @Test
    @Disabled
    public void testMultipleDeleteLagSegmentsMetrics() {
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 1, 2L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 2, 3L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 0, 4L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 1, 5L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 2, 6L);
        Assertions.assertEquals((long)15L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)15L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic2(), 1, 5L);
        Assertions.assertEquals((long)20L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
    }

    @Test
    @Disabled
    public void testDeleteLagSegmentsMetricWithPartitionExpansion() {
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 2, 3L);
        Assertions.assertEquals((long)6L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)6L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
    }

    @Test
    @Disabled
    public void testDeleteLagSegmentsMetricWithPartitionShrinking() {
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
        this.brokerTopicStats().removeRemoteDeleteLagSegments(this.topic(), 1);
        Assertions.assertEquals((long)1L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)1L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
    }

    @Test
    @Disabled
    public void testDeleteLagSegmentsMetricWithRemovingNonexistentPartitions() {
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
        this.brokerTopicStats().removeRemoteDeleteLagSegments(this.topic(), 3);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
    }

    @Test
    @Disabled
    public void testDeleteLagSegmentsMetricClear() {
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteDeleteLagSegments(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
        this.brokerTopicStats().close();
        Assertions.assertEquals((long)0L, (long)this.brokerTopicMetrics().remoteDeleteLagSegments());
        Assertions.assertEquals((long)0L, (long)this.allTopicMetrics().remoteDeleteLagSegments());
    }

    @Test
    @Disabled
    public void testRemoteLogMetadataCount() {
        Assertions.assertEquals((long)0L, (long)this.brokerTopicMetrics().remoteLogMetadataCount());
        Assertions.assertEquals((long)0L, (long)this.allTopicMetrics().remoteLogMetadataCount());
        this.brokerTopicStats().recordRemoteLogMetadataCount(this.topic(), 0, 1L);
        Assertions.assertEquals((long)1L, (long)this.brokerTopicMetrics().remoteLogMetadataCount());
        Assertions.assertEquals((long)1L, (long)this.allTopicMetrics().remoteLogMetadataCount());
        this.brokerTopicStats().recordRemoteLogMetadataCount(this.topic(), 1, 2L);
        this.brokerTopicStats().recordRemoteLogMetadataCount(this.topic(), 2, 3L);
        Assertions.assertEquals((long)6L, (long)this.brokerTopicMetrics().remoteLogMetadataCount());
        Assertions.assertEquals((long)6L, (long)this.allTopicMetrics().remoteLogMetadataCount());
        this.brokerTopicStats().close();
        Assertions.assertEquals((long)0L, (long)this.brokerTopicMetrics().remoteLogMetadataCount());
        Assertions.assertEquals((long)0L, (long)this.allTopicMetrics().remoteLogMetadataCount());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @Disabled
    public void testSingularLogSizeBytesMetric(boolean systemRemoteStorageEnabled) {
        Properties props = TestUtils$.MODULE$.createDummyBrokerConfig();
        props.setProperty("remote.log.storage.system.enable", Boolean.toString(systemRemoteStorageEnabled));
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats(Optional.of(KafkaConfig$.MODULE$.fromProps(props)));
        BrokerTopicMetrics brokerTopicMetrics = brokerTopicStats.topicStats(this.topic());
        if (systemRemoteStorageEnabled) {
            brokerTopicStats.recordRemoteLogSizeBytes(this.topic(), 0, 100L);
            brokerTopicStats.recordRemoteLogSizeBytes(this.topic(), 1, 150L);
            brokerTopicStats.recordRemoteLogSizeBytes(this.topic(), 2, 250L);
            Assertions.assertEquals((long)500L, (long)brokerTopicMetrics.remoteLogSizeBytes());
            Assertions.assertEquals((long)500L, (long)brokerTopicStats.allTopicsStats().remoteLogSizeBytes());
            brokerTopicStats.recordRemoteLogSizeBytes(this.topic2(), 0, 100L);
            Assertions.assertEquals((long)600L, (long)brokerTopicStats.allTopicsStats().remoteLogSizeBytes());
            return;
        }
        Assertions.assertEquals((Object)None$.MODULE$, (Object)brokerTopicMetrics.metricGaugeMap().get((Object)RemoteStorageMetrics.REMOTE_LOG_SIZE_BYTES_METRIC.getName()));
    }

    @Test
    @Disabled
    public void testMultipleLogSizeBytesMetrics() {
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 1, 2L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 2, 3L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 0, 4L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 1, 5L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 2, 6L);
        Assertions.assertEquals((long)15L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)15L, (long)this.allTopicMetrics().remoteLogSizeBytes());
    }

    @Test
    @Disabled
    public void testLogSizeBytesMetricWithPartitionExpansion() {
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteLogSizeBytes());
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 2, 3L);
        Assertions.assertEquals((long)6L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)6L, (long)this.allTopicMetrics().remoteLogSizeBytes());
    }

    @Test
    @Disabled
    public void testLogSizeBytesMetricWithPartitionShrinking() {
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteLogSizeBytes());
        this.brokerTopicStats().removeRemoteLogSizeBytes(this.topic(), 1);
        Assertions.assertEquals((long)1L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)1L, (long)this.allTopicMetrics().remoteLogSizeBytes());
    }

    @Test
    @Disabled
    public void testLogSizeBytesMetricWithRemovingNonexistentPartitions() {
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteLogSizeBytes());
        this.brokerTopicStats().removeRemoteLogSizeBytes(this.topic(), 3);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteLogSizeBytes());
    }

    @Test
    @Disabled
    public void testLogSizeBytesMetricClear() {
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 0, 1L);
        this.brokerTopicStats().recordRemoteLogSizeBytes(this.topic(), 1, 2L);
        Assertions.assertEquals((long)3L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)3L, (long)this.allTopicMetrics().remoteLogSizeBytes());
        this.brokerTopicStats().close();
        Assertions.assertEquals((long)0L, (long)this.brokerTopicMetrics().remoteLogSizeBytes());
        Assertions.assertEquals((long)0L, (long)this.allTopicMetrics().remoteLogSizeBytes());
    }

    public static final /* synthetic */ void $anonfun$testCallbackTiming$2(MockTime time$1, KafkaRequestHandler handler$1, RequestLocal reqLocal, int ms) {
        time$1.sleep((long)ms);
        handler$1.stop();
    }

    public static final /* synthetic */ void $anonfun$testCallbackTiming$3(Function1 callback$1) {
        callback$1.apply$mcVI$sp(1);
    }

    public static final /* synthetic */ void $anonfun$testCallbackTiming$1(MockTime time$1, KafkaRequestHandler handler$1, RequestChannel.Request request$1, InvocationOnMock x$1) {
        time$1.sleep(2L);
        CompletableFuture.runAsync(() -> KafkaRequestHandlerTest.$anonfun$testCallbackTiming$3(KafkaRequestHandler$.MODULE$.wrapAsyncCallback((Function2 & Serializable)(reqLocal, ms) -> {
            KafkaRequestHandlerTest.$anonfun$testCallbackTiming$2(time$1, handler$1, reqLocal, BoxesRunTime.unboxToInt((Object)ms));
            return BoxedUnit.UNIT;
        }, RequestLocal$.MODULE$.NoCaching())));
        request$1.apiLocalCompleteTimeNanos_$eq(time$1.nanoseconds());
    }

    private final void assertRequestLogAction$1(LogAction expectedLogAction, boolean shouldLog$1) {
        RequestLogFilter requestLogFilter = shouldLog$1 ? RequestLogFilter.MATCH_ALL : RequestLogFilter.MATCH_NONE;
        KafkaConfig config = this.newMockedKafkaConfig(requestLogFilter, RequestLogFilter.MATCH_NONE);
        RequestChannel.Request request = this.receiveRequest(config);
        Assertions.assertEquals((Object)expectedLogAction, (Object)request.logAction());
    }

    public static final /* synthetic */ void $anonfun$testCallbackTryCompleteActions$3(Function1 callback$2) {
        callback$2.apply$mcVI$sp(1);
    }

    public static final /* synthetic */ void $anonfun$testHandlingCallbackOnNewThread$2(IntRef handledCount$2, KafkaRequestHandler handler$3, RequestLocal reqLocal, int ms) {
        reqLocal.bufferSupplier().close();
        ++handledCount$2.elem;
        handler$3.stop();
    }

    public static final /* synthetic */ void $anonfun$testHandlingCallbackOnNewThread$3(Function1 callback$3) {
        callback$3.apply$mcVI$sp(1);
    }

    public static final /* synthetic */ void $anonfun$testCallbackOnSameThread$2(IntRef handledCount$3, KafkaRequestHandler handler$4, RequestLocal reqLocal, int ms) {
        reqLocal.bufferSupplier().close();
        ++handledCount$3.elem;
        handler$4.stop();
    }

    public static final /* synthetic */ void $anonfun$testCallbackOnSameThread$1(IntRef handledCount$3, KafkaRequestHandler handler$4, RequestLocal originalRequestLocal$2, InvocationOnMock x$4) {
        KafkaRequestHandler$.MODULE$.wrapAsyncCallback((Function2 & Serializable)(reqLocal, ms) -> {
            KafkaRequestHandlerTest.$anonfun$testCallbackOnSameThread$2(handledCount$3, handler$4, reqLocal, BoxesRunTime.unboxToInt((Object)ms));
            return BoxedUnit.UNIT;
        }, originalRequestLocal$2).apply$mcVI$sp(1);
    }

    public static final /* synthetic */ void $anonfun$testTopicStats$2(boolean systemRemoteStorageEnabled$1, BrokerTopicMetrics brokerTopicMetrics$1, String metricName) {
        if (systemRemoteStorageEnabled$1) {
            Assertions.assertTrue((boolean)brokerTopicMetrics$1.metricGaugeMap().contains((Object)metricName), (String)new StringBuilder(22).append("The metric is missing:").append(metricName).toString());
            return;
        }
        Assertions.assertFalse((boolean)brokerTopicMetrics$1.metricGaugeMap().contains((Object)metricName), (String)new StringBuilder(25).append("The metric should appear:").append(metricName).toString());
    }

    public static final /* synthetic */ void $anonfun$receiveRequest$1(InvocationOnMock invocation) {
        RequestChannel.Request req = (RequestChannel.Request)invocation.getArgument(0);
        ((RequestLogger)invocation.getArgument(1)).maybeSetRequestLogAction(req);
    }

    public KafkaRequestHandlerTest() {
        this.topic = "topic";
        this.topic2 = "topic2";
    }
}

