/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kafka.server.ControllerServer;
import kafka.server.KafkaConfig$;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.test.junit.ZkClusterInvocationContext;
import kafka.testkit.KafkaClusterTestKit;
import kafka.testkit.TestKitNodes;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Predef$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@Timeout(value=120L)
@Tag(value="integration")
@ExtendWith(value={ClusterTestExtensions.class})
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005b\u0001B\u0003\u0007\u0001-AQA\u0005\u0001\u0005\u0002MAQA\u0006\u0001\u0005\u0002]AQA\u0018\u0001\u0005\u0002}CQ!\u001a\u0001\u0005\u0002\u0019\u0014\u0001eS1gW\u0006\u001cVM\u001d<fe.\u0013\u0016M\u001a;SK\u001eL7\u000f\u001e:bi&|g\u000eV3ti*\u0011q\u0001C\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003%\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u000b\u0011\u0005U\u0001Q\"\u0001\u0004\u00027Q,7\u000f\u001e*fO&\u001cH/\u001a:[W\n\u0013xn[3s\u0013:\\%/\u00194u)\tA2\u0004\u0005\u0002\u000e3%\u0011!D\u0004\u0002\u0005+:LG\u000fC\u0003\u001d\u0005\u0001\u0007Q$A\u0005{W\u000ecWo\u001d;feB\u0011a$I\u0007\u0002?)\u0011\u0001\u0005C\u0001\u0005i\u0016\u001cH/\u0003\u0002#?\ty1\t\\;ti\u0016\u0014\u0018J\\:uC:\u001cW\r\u000b\u0006\u0003I)Z\u0003'\r\u001a4\u0001\u0006\u0003\"!\n\u0015\u000e\u0003\u0019R!aJ\u0010\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002*M\tY1\t\\;ti\u0016\u0014H+Z:u\u0003-\u0019G.^:uKJ$\u0016\u0010]3%\u00031J!!\f\u0018\u0002\u0005i[%BA\u0018'\u0003\u0011!\u0016\u0010]3\u0002\u000f\t\u0014xn[3sgv\t1!A\bnKR\fG-\u0019;b-\u0016\u00148/[8oI\u0005!\u0014BA\u001b7\u0003-I%\tU04?Rz\u0016J\u0016\u0019\u000b\u0005]B\u0014aD'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\u000b\u0005eR\u0014AB2p[6|gN\u0003\u0002\bw)\u0011\u0011\u0002\u0010\u0006\u0003{y\na!\u00199bG\",'\"A \u0002\u0007=\u0014x-\u0001\ttKJ4XM\u001d)s_B,'\u000f^5fg2*!\tT)U3.*1IR$J\u0015B\u0011Q\u0005R\u0005\u0003\u000b\u001a\u0012Qc\u00117vgR,'oQ8oM&<\u0007K]8qKJ$\u00180A\u0002lKf\f\u0013\u0001S\u0001\u001bS:$XM\u001d\u0018ce>\\WM\u001d\u0018mSN$XM\\3s]9\fW.Z\u0001\u0006m\u0006dW/Z\u0011\u0002\u0017\u0006AQ\t\u0017+F%:\u000bEjK\u0003D\r6Ku*I\u0001O\u0003%a\u0017n\u001d;f]\u0016\u00148/I\u0001Q\u00039\u0002F*Q%O)\u0016CFKO\u00180Y>\u001c\u0017\r\u001c5pgRT\u0004\u0007L#Y)\u0016\u0013f*\u0011';_=bwnY1mQ>\u001cHO\u000f\u0019,\u000b\r3%+S(\"\u0003M\u000bA#\u00193wKJ$\u0018n]3e]1L7\u000f^3oKJ\u001c8&B\"G+&;\u0016%\u0001,\u0002=1L7\u000f^3oKJt3/Z2ve&$\u0018P\f9s_R|7m\u001c7/[\u0006\u0004\u0018%\u0001-\u0002M\u0015CF+\u0012*O\u00032S\u0004\u000bT!J\u001dR+\u0005\f\u0016\u0017Q\u0019\u0006Ke\nV#Y)j\u0002F*Q%O)\u0016CFkK\u0003D\rjKE,I\u0001\\\u00031\u001awN\u001c4mk\u0016tGOL2mkN$XM\u001d\u0018mS:\\g&\\3uC\u0012\fG/\u0019\u0018u_BL7ML3oC\ndW-I\u0001^\u0003\u0011!(/^3\u0002QQ,7\u000f\u001e*fgR\f'\u000f^(mI&\u0013\u0007OW6Ce>\\WM]%o\u001b&<'/\u0019;j_:lu\u000eZ3\u0015\u0005a\u0001\u0007\"\u0002\u000f\u0004\u0001\u0004i\u0002\u0006C\u0002%U-\u0002\u0014G\r2%\u0003\rL!\u0001\u001a\u001c\u0002\u0017%\u0013\u0005kX\u001a`g}Ke\u000bM\u0001\u0013g\",H\u000fZ8x]&s7+Z9vK:\u001cW\rF\u0002\u0019O\"DQ\u0001\b\u0003A\u0002uAQ!\u001b\u0003A\u0002)\fAb\u001b:bMR\u001cE.^:uKJ\u0004\"a\u001b8\u000e\u00031T!!\u001c\u0005\u0002\u000fQ,7\u000f^6ji&\u0011q\u000e\u001c\u0002\u0014\u0017\u000647.Y\"mkN$XM\u001d+fgR\\\u0015\u000e\u001e\u0015\u0005\u0001EL5\u0010\u0005\u0002ss6\t1O\u0003\u0002uk\u0006\u0019\u0011\r]5\u000b\u0005Y<\u0018a\u00026va&$XM\u001d\u0006\u0003qz\nQA[;oSRL!A_:\u0003\u000fQKW.Z8viz\t\u0001\u0010K\u0003\u0001{&\u000b\t\u0001\u0005\u0002s}&\u0011qp\u001d\u0002\u0004)\u0006<\u0017EAA\u0002\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8)\r\u0001\t9!SA\n!\u0011\tI!a\u0004\u000e\u0005\u0005-!bAA\u0007g\u0006IQ\r\u001f;f]NLwN\\\u0005\u0005\u0003#\tYA\u0001\u0006FqR,g\u000eZ,ji\"d#!!\u0006$\u0005\u0005]\u0001\u0003BA\r\u0003;i!!a\u0007\u000b\u0005a|\u0012\u0002BA\u0010\u00037\u0011Qc\u00117vgR,'\u000fV3ti\u0016CH/\u001a8tS>t7\u000f")
public class KafkaServerKRaftRegistrationTest {
    @ClusterTest(clusterType=Type.ZK, brokers=3, metadataVersion=MetadataVersion.IBP_3_4_IV0, serverProperties={@ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT"), @ClusterConfigProperty(key="confluent.cluster.link.metadata.topic.enable", value="true")})
    public void testRegisterZkBrokerInKraft(ClusterInstance zkCluster) {
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_4_IV0).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(kraftCluster.controllers().values()).asScala().head()).controller().waitForReadyBrokers(3);
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", kraftCluster.quorumVotersConfig());
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.config().serverProperties().put("confluent.cluster.link.metadata.topic.enable", "true");
            zkCluster.rollingBrokerRestart();
            zkCluster.waitForReadyBrokers();
            try {
                readyFuture.get(30L, TimeUnit.SECONDS);
            }
            catch (TimeoutException timeoutException) {
                Assertions.fail((String)"Did not see 3 brokers within 30 seconds");
            }
            catch (Throwable t) {
                Assertions.fail((String)"Had some other error waiting for brokers", (Throwable)t);
            }
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    @ClusterTest(clusterType=Type.ZK, brokers=3, metadataVersion=MetadataVersion.IBP_3_3_IV0)
    public void testRestartOldIbpZkBrokerInMigrationMode(ClusterInstance zkCluster) {
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_4_IV0).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", kraftCluster.quorumVotersConfig());
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            Assertions.assertThrows(IllegalArgumentException.class, () -> zkCluster.rollingBrokerRestart());
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    public void shutdownInSequence(ClusterInstance zkCluster, KafkaClusterTestKit kraftCluster) {
        zkCluster.brokerIds().forEach(x$1 -> zkCluster.shutdownBroker(Predef$.MODULE$.Integer2int(x$1)));
        kraftCluster.close();
        zkCluster.stop();
    }
}

