/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.server.DefaultAlterPartitionManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.server.QuorumTestHarness;
import kafka.server.ZkAlterPartitionManager;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.BrokerState;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005%b\u0001B\u000b\u0017\u0001mAQ\u0001\t\u0001\u0005\u0002\u0005Bqa\t\u0001C\u0002\u0013\u0005A\u0005\u0003\u00042\u0001\u0001\u0006I!\n\u0005\u0006e\u0001!\te\r\u0005\u0006\u0019\u0002!\t%\u0014\u0005\u0006%\u0002!\t!\u0014\u0005\u0006/\u0002!\t!\u0014\u0005\u00063\u0002!IA\u0017\u0005\u0006W\u0002!\t!\u0014\u0005\u0006[\u0002!\t!\u0014\u0005\u0006_\u0002!\t!\u0014\u0005\u0006c\u0002!\t!\u0014\u0005\u0006g\u0002!\t!\u0014\u0005\u0006k\u0002!\t!\u0014\u0005\u0006o\u0002!\t!\u0014\u0005\u0006s\u0002!\t!\u0014\u0005\u0006w\u0002!\t!\u0014\u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0011\u001d\ty\u0002\u0001C\u0001\u0003CAa!!\n\u0001\t\u0003i%aD&bM.\f7+\u001a:wKJ$Vm\u001d;\u000b\u0005]A\u0012AB:feZ,'OC\u0001\u001a\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u000f\u0011\u0005uqR\"\u0001\f\n\u0005}1\"!E)v_J,X\u000eV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012A\t\t\u0003;\u0001\ta!\u001a=ji\u0016$W#A\u0013\u0011\u0005\u0019zS\"A\u0014\u000b\u0005!J\u0013AB1u_6L7M\u0003\u0002+W\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u00051j\u0013\u0001B;uS2T\u0011AL\u0001\u0005U\u00064\u0018-\u0003\u00021O\ti\u0011\t^8nS\u000e\u0014un\u001c7fC:\fq!\u001a=ji\u0016$\u0007%A\u0003tKR,\u0006\u000f\u0006\u00025uA\u0011Q\u0007O\u0007\u0002m)\tq'A\u0003tG\u0006d\u0017-\u0003\u0002:m\t!QK\\5u\u0011\u0015YD\u00011\u0001=\u0003!!Xm\u001d;J]\u001a|\u0007CA\u001fG\u001b\u0005q$BA A\u0003\r\t\u0007/\u001b\u0006\u0003\u0003\n\u000bqA[;qSR,'O\u0003\u0002D\t\u0006)!.\u001e8ji*\tQ)A\u0002pe\u001eL!a\u0012 \u0003\u0011Q+7\u000f^%oM>D#\u0001B%\u0011\u0005uR\u0015BA&?\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]R\tA\u0007\u000b\u0002\u0006\u001fB\u0011Q\bU\u0005\u0003#z\u0012\u0011\"\u00114uKJ,\u0015m\u00195\u0002\u0019Q,7\u000f^*ikR$wn\u001e8)\u0005\u0019!\u0006CA\u001fV\u0013\t1fH\u0001\u0003UKN$\u0018a\n;fgR$vo\\\"p]N,7-\u001e;jm\u0016\u001c\u0006.\u001e;e_^t7)\u00197m\u000bbLG\u000fV<jG\u0016D#a\u0002+\u0002\u00175,GO]5d-\u0006dW/\u001a\u000b\u00037z\u0003\"!\u000e/\n\u0005u3$\u0001\u0002'p]\u001eDQa\u0018\u0005A\u0002\u0001\fAA\\1nKB\u0011\u0011\r\u001b\b\u0003E\u001a\u0004\"a\u0019\u001c\u000e\u0003\u0011T!!\u001a\u000e\u0002\rq\u0012xn\u001c;?\u0013\t9g'\u0001\u0004Qe\u0016$WMZ\u0005\u0003S*\u0014aa\u0015;sS:<'BA47\u0003!\"Xm\u001d;BYJ,\u0017\rZ=SK\u001eL7\u000f^3sK\u0012\fEM^3si&\u001cX\r\u001a'jgR,g.\u001a:tQ\tIA+\u0001\u000fuKN$H*[:uK:,'\u000fU8si\u0006c'/Z1es&sWk]3)\u0005)!\u0016!\u000b;fgR\u001c%/Z1uKN\u0004&o\u001c9fej[7i\u001c8gS\u001e<\u0006.\u001a8TCNdG)[:bE2,G\r\u000b\u0002\f)\u0006AC/Z:u\u0007J,\u0017\r^3t!J|\u0007/\u001a:[WRc7oQ8oM&<w\u000b[3o\t&\u001c\u0018M\u00197fI\"\u0012A\u0002V\u0001+i\u0016\u001cHo\u0011:fCR,7\u000f\u0015:pa\u0016\u0014(l\u001b+mg\u000e{gNZ5h/&$\b\u000e\u0016:vKZ\u000bG.^3tQ\tiA+\u0001\u001auKN$8I]3bi\u0016\u001c\bK]8qKJT6\u000e\u00167t\u0007>tg-[4XSRDg)\u00197tK\u0006sG\rT5tiZ\u000bG.^3tQ\tqA+\u0001\tuKN$(l[%te6\u000bg.Y4fe\"\u0012q\u0002V\u0001\u0014i\u0016\u001cH/\u00117uKJL5O]'b]\u0006<WM\u001d\u0015\u0003!Q\u000b\u0011\u0005^3tiJ+Wn\u001c;f\u0019><W*\u00198bO\u0016\u0014\u0018J\\:uC:$\u0018.\u0019;j_:D#!E?\u0011\u0005ur\u0018BA@?\u0005!!\u0015n]1cY\u0016$\u0007FA\tU\u00031\u0019'/Z1uKN+'O^3s)!\t9!!\u0004\u0002\u0018\u0005m\u0001cA\u000f\u0002\n%\u0019\u00111\u0002\f\u0003\u0017-\u000bgm[1TKJ4XM\u001d\u0005\b\u0003\u001f\u0011\u0002\u0019AA\t\u0003\u0019qw\u000eZ3JIB\u0019Q'a\u0005\n\u0007\u0005UaGA\u0002J]RDa!!\u0007\u0013\u0001\u0004\u0001\u0017\u0001\u00035pgRt\u0015-\\3\t\u000f\u0005u!\u00031\u0001\u0002\u0012\u0005!\u0001o\u001c:u\u0003y\u0019'/Z1uKN+'O^3s/&$\b\u000eT5ti\u0016tWM](o!>\u0014H\u000f\u0006\u0003\u0002\b\u0005\r\u0002bBA\u000f'\u0001\u0007\u0011\u0011C\u0001\u0016i\u0016\u001cH\u000fT5gK\u000eL8\r\\3TQV$Hm\\<oQ\t!B\u000b")
public class KafkaServerTest
extends QuorumTestHarness {
    private final AtomicBoolean exited = new AtomicBoolean(false);

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        KafkaServer$.MODULE$.externalShutdownInitiations().set(0L);
        Exit.setExitProcedure((x$1, x$2) -> {
            this.exited().set(true);
            throw new Exception();
        });
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        Exit.resetExitProcedure();
        KafkaServer$.MODULE$.externalShutdownInitiations().set(0L);
    }

    @Test
    public void testShutdown() {
        new KafkaServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false)), Time.SYSTEM, (Option)None$.MODULE$, false);
        Assertions.assertFalse((boolean)this.exited().get(), (String)"Exit produce should not have been executed yet");
        KafkaServer$.MODULE$.initiateShutdown().join();
        Assertions.assertTrue((boolean)this.exited().get(), (String)"Exit produce should have been executed");
        Assertions.assertEquals((long)1L, (long)KafkaServer$.MODULE$.externalShutdownInitiations().get());
        Assertions.assertEquals((long)1L, (long)this.metricValue("ExternalShutdownInitiations"));
    }

    @Test
    public void testTwoConsecutiveShutdownCallExitTwice() {
        new KafkaServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false)), Time.SYSTEM, (Option)None$.MODULE$, false);
        Assertions.assertFalse((boolean)this.exited().get(), (String)"Exit produce should not have been executed yet");
        Thread th1 = KafkaServer$.MODULE$.initiateShutdown();
        Thread th2 = KafkaServer$.MODULE$.initiateShutdown();
        th1.join();
        th2.join();
        Assertions.assertTrue((boolean)this.exited().get(), (String)"Exit produce should have been executed");
        Assertions.assertEquals((long)2L, (long)KafkaServer$.MODULE$.externalShutdownInitiations().get());
        Assertions.assertEquals((long)2L, (long)this.metricValue("ExternalShutdownInitiations"));
    }

    private long metricValue(String name) {
        return BoxesRunTime.unboxToLong((Object)((Gauge)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTest.$anonfun$metricValue$1(name, x$3)))).values().headOption().getOrElse((Function0 & Serializable)() -> {
            throw new Exception(new StringBuilder(22).append("Could not find metric ").append(name).toString());
        })).value());
    }

    @Test
    public void testAlreadyRegisteredAdvertisedListeners() {
        KafkaServer server1 = this.createServer(1, "myhost", TestUtils$.MODULE$.RandomPort());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.createServer(2, "myhost", TestUtils$.MODULE$.boundPort((KafkaBroker)server1, SecurityProtocol.PLAINTEXT)));
        KafkaServer server2 = this.createServer(2, "myhost", TestUtils$.MODULE$.RandomPort());
        TestUtils$.MODULE$.shutdownServers(new .colon.colon((Object)server1, (List)new .colon.colon((Object)server2, (List)Nil$.MODULE$)), true);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListenerPortAlreadyInUse() {
        ServerSocket serverSocket = new ServerSocket(0, 0, InetAddress.getLoopbackAddress());
        ObjectRef kafkaServer = ObjectRef.create((Object)None$.MODULE$);
        try {
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!serverSocket.isBound()) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Server socket failed to bind.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertThrows(RuntimeException.class, () -> {
                kafkaServer$1.elem = Option$.MODULE$.apply((Object)this.createServerWithListenerOnPort(serverSocket.getLocalPort()));
            }, (String)"Expected RuntimeException due to address already in use during KafkaServer startup");
        }
        finally {
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> serverSocket.close(), (Logging)this, Level.WARN);
            TestUtils$.MODULE$.shutdownServers(((Option)kafkaServer.elem).toList(), true);
        }
    }

    @Test
    public void testCreatesProperZkConfigWhenSaslDisabled() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), false);
        Assertions.assertEquals((Object)"false", (Object)zkClientConfig.getProperty("zookeeper.sasl.client"));
    }

    @Test
    public void testCreatesProperZkTlsConfigWhenDisabled() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        props.put(KafkaConfig$.MODULE$.ZkSslClientEnableProp(), "false");
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), false);
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)propName -> {
            KafkaServerTest.$anonfun$testCreatesProperZkTlsConfigWhenDisabled$1(zkClientConfig, propName);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreatesProperZkTlsConfigWithTrueValues() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        String someValue = "some_value";
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)kafkaProp -> props.put(kafkaProp, KafkaServerTest.kafkaConfigValueToSet$1(kafkaProp, someValue)));
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), false);
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)kafkaProp -> {
            KafkaServerTest.$anonfun$testCreatesProperZkTlsConfigWithTrueValues$2(zkClientConfig, someValue, kafkaProp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreatesProperZkTlsConfigWithFalseAndListValues() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        String someValue = "some_value";
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)kafkaProp -> props.put(kafkaProp, KafkaServerTest.kafkaConfigValueToSet$2(kafkaProp, someValue)));
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), false);
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)kafkaProp -> {
            KafkaServerTest.$anonfun$testCreatesProperZkTlsConfigWithFalseAndListValues$2(zkClientConfig, someValue, kafkaProp);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkIsrManager() {
        void createServer_createServer_createServer_startup;
        void createServer_time;
        void createServer_config;
        Properties props = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).head();
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "2.7-IV1");
        Time time = Time.SYSTEM;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        boolean bl = true;
        int createServer_createServer_createServer_licenseTopicReplicationFactor = 0;
        Object var6_5 = null;
        Object var3_4 = null;
        kafkaConfig = null;
        time = null;
        KafkaServer server = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_licenseTopicReplicationFactor, (boolean)createServer_createServer_createServer_startup, false);
        if (!(server.replicaManager().alterPartitionManager() instanceof ZkAlterPartitionManager)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Should use ZK for ISR manager in versions before 2.7-IV2");
        }
        server.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterIsrManager() {
        void createServer_createServer_createServer_startup;
        void createServer_time;
        void createServer_config;
        Properties props = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).head();
        MetadataVersion metadataVersion = MetadataVersion.latestTesting();
        if (metadataVersion == null) {
            throw null;
        }
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), metadataVersion.version());
        Time time = Time.SYSTEM;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        boolean bl = true;
        int createServer_createServer_createServer_licenseTopicReplicationFactor = 0;
        Object var6_5 = null;
        Object var3_4 = null;
        kafkaConfig = null;
        time = null;
        KafkaServer server = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_licenseTopicReplicationFactor, (boolean)createServer_createServer_createServer_startup, false);
        if (!(server.replicaManager().alterPartitionManager() instanceof DefaultAlterPartitionManager)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Should use AlterIsr for ISR manager in versions after 2.7-IV2");
        }
        server.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Disabled
    @Test
    public void testRemoteLogManagerInstantiation() {
        void createServer_createServer_createServer_startup;
        void createServer_time;
        void createServer_config;
        Properties props = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).head();
        props.put("remote.log.storage.system.enable", Boolean.toString(true));
        props.put("remote.log.metadata.manager.class.name", "org.apache.kafka.server.log.remote.storage.NoOpRemoteLogMetadataManager");
        props.put("remote.log.storage.manager.class.name", "org.apache.kafka.server.log.remote.storage.NoOpRemoteStorageManager");
        Time time = Time.SYSTEM;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        boolean bl = true;
        int createServer_createServer_createServer_licenseTopicReplicationFactor = 0;
        Object var7_5 = null;
        Object var4_4 = null;
        kafkaConfig = null;
        time = null;
        KafkaServer server = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_licenseTopicReplicationFactor, (boolean)createServer_createServer_createServer_startup, false);
        Option option = server.remoteLogManagerOpt();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"RemoteLogManager should be initialized");
            } else {
                throw new MatchError((Object)option);
            }
        }
        server.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    public KafkaServer createServer(int nodeId, String hostName, int port) {
        void createServer_createServer_createServer_startup;
        void createServer_time;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(nodeId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.AdvertisedListenersProp(), new StringBuilder(13).append("PLAINTEXT://").append(hostName).append(":").append(port).toString());
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        Time time = Time.SYSTEM;
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        boolean bl = true;
        int createServer_createServer_createServer_licenseTopicReplicationFactor = 0;
        return createServer_this.createServer(kafkaConfig, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_licenseTopicReplicationFactor, (boolean)createServer_createServer_createServer_startup, false);
    }

    /*
     * WARNING - void declaration
     */
    public KafkaServer createServerWithListenerOnPort(int port) {
        void createServer_createServer_createServer_startup;
        void createServer_time;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.ListenersProp(), new StringBuilder(22).append("PLAINTEXT://localhost:").append(port).toString());
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        Time time = Time.SYSTEM;
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        boolean bl = true;
        int createServer_createServer_createServer_licenseTopicReplicationFactor = 0;
        return createServer_this.createServer(kafkaConfig, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_licenseTopicReplicationFactor, (boolean)createServer_createServer_createServer_startup, false);
    }

    @Test
    public void testLifecycleShutdown() {
        KafkaServer server = this.createServer(1, "myhost", TestUtils$.MODULE$.RandomPort());
        Assertions.assertEquals((Object)BrokerState.RUNNING, (Object)server.brokerState());
        server.shutdown();
        Assertions.assertFalse((boolean)server.brokerState().isShutdownInitiated());
        server = this.createServer(2, "myhost", TestUtils$.MODULE$.RandomPort());
        server.beginShutdown(server.brokerEpoch());
        Assertions.assertTrue((boolean)server.brokerState().isShutdownInitiated());
        server.shutdown();
    }

    public static final /* synthetic */ boolean $anonfun$metricValue$1(String name$1, Tuple2 x$3) {
        String string = ((MetricName)x$3._1()).getName();
        return !(string != null ? !string.equals(name$1) : name$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testListenerPortAlreadyInUse$1(ServerSocket serverSocket$1) {
        return serverSocket$1.isBound();
    }

    public static final /* synthetic */ String $anonfun$testListenerPortAlreadyInUse$2() {
        return "Server socket failed to bind.";
    }

    public static final /* synthetic */ void $anonfun$testCreatesProperZkTlsConfigWhenDisabled$1(ZKClientConfig zkClientConfig$1, String propName) {
        Assertions.assertNull((Object)zkClientConfig$1.getProperty(propName));
    }

    private static final String kafkaConfigValueToSet$1(String kafkaProp, String someValue$1) {
        boolean bl;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(kafkaProp) : kafkaProp != null)) {
            bl = true;
        } else {
            String string2 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
                bl = true;
            } else {
                String string3 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null);
            }
        }
        if (bl) {
            return "true";
        }
        String string4 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
        if (!(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null)) {
            return "HTTPS";
        }
        return someValue$1;
    }

    private static final String zkClientValueToExpect$1(String kafkaProp, String someValue$1) {
        boolean bl;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(kafkaProp) : kafkaProp != null)) {
            bl = true;
        } else {
            String string2 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
                bl = true;
            } else {
                String string3 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null);
            }
        }
        if (bl) {
            return "true";
        }
        String string4 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
        if (!(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null)) {
            return "true";
        }
        return someValue$1;
    }

    public static final /* synthetic */ void $anonfun$testCreatesProperZkTlsConfigWithTrueValues$2(ZKClientConfig zkClientConfig$2, String someValue$1, String kafkaProp) {
        Assertions.assertEquals((Object)KafkaServerTest.zkClientValueToExpect$1(kafkaProp, someValue$1), (Object)zkClientConfig$2.getProperty((String)KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().apply((Object)kafkaProp)));
    }

    private static final String kafkaConfigValueToSet$2(String kafkaProp, String someValue$2) {
        boolean bl;
        boolean bl2;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(kafkaProp) : kafkaProp != null)) {
            return "true";
        }
        String string2 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
        if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
            bl2 = true;
        } else {
            String string3 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
            bl2 = !(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null);
        }
        if (bl2) {
            return "false";
        }
        String string4 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
        if (!(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null)) {
            return "";
        }
        String string5 = KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp();
        if (!(string5 != null ? !string5.equals(kafkaProp) : kafkaProp != null)) {
            bl = true;
        } else {
            String string6 = KafkaConfig$.MODULE$.ZkSslCipherSuitesProp();
            bl = !(string6 != null ? !string6.equals(kafkaProp) : kafkaProp != null);
        }
        if (bl) {
            return "A,B";
        }
        return someValue$2;
    }

    private static final String zkClientValueToExpect$2(String kafkaProp, String someValue$2) {
        boolean bl;
        boolean bl2;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(kafkaProp) : kafkaProp != null)) {
            return "true";
        }
        String string2 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
        if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
            bl2 = true;
        } else {
            String string3 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
            bl2 = !(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null);
        }
        if (bl2) {
            return "false";
        }
        String string4 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
        if (!(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null)) {
            return "false";
        }
        String string5 = KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp();
        if (!(string5 != null ? !string5.equals(kafkaProp) : kafkaProp != null)) {
            bl = true;
        } else {
            String string6 = KafkaConfig$.MODULE$.ZkSslCipherSuitesProp();
            bl = !(string6 != null ? !string6.equals(kafkaProp) : kafkaProp != null);
        }
        if (bl) {
            return "A,B";
        }
        return someValue$2;
    }

    public static final /* synthetic */ void $anonfun$testCreatesProperZkTlsConfigWithFalseAndListValues$2(ZKClientConfig zkClientConfig$3, String someValue$2, String kafkaProp) {
        Assertions.assertEquals((Object)KafkaServerTest.zkClientValueToExpect$2(kafkaProp, someValue$2), (Object)zkClientConfig$3.getProperty((String)KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().apply((Object)kafkaProp)));
    }
}

