/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import kafka.server.DynamicBrokerConfig;
import kafka.server.KafkaConfig;
import kafka.server.KraftInternalAdmin;
import kafka.server.KraftInternalAdmin$;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.tier.topic.TierTopic;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.server.ControllerRequestCompletionHandler;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005q4AAE\n\u00031!)q\u0004\u0001C\u0001A!91\u0005\u0001b\u0001\n\u0013!\u0003BB\u0017\u0001A\u0003%Q\u0005C\u0004/\u0001\t\u0007I\u0011B\u0018\t\rM\u0002\u0001\u0015!\u00031\u0011\u001d!\u0004A1A\u0005\nUBa!\u000f\u0001!\u0002\u00131\u0004\"\u0002\u001e\u0001\t\u0003Y\u0004\"\u0002'\u0001\t\u0003Y\u0004\"\u0002(\u0001\t\u0003Y\u0004\"\u0002)\u0001\t\u0003Y\u0004\"\u0002*\u0001\t\u0003Y\u0004\"\u0002+\u0001\t\u0003Y\u0004\"\u0002,\u0001\t\u0003Y\u0004\"\u0002-\u0001\t\u0013I\u0006\"\u0002=\u0001\t\u0003Y\u0004\"\u0002>\u0001\t\u0003Y$AF&sC\u001a$\u0018J\u001c;fe:\fG.\u00113nS:$Vm\u001d;\u000b\u0005Q)\u0012AB:feZ,'OC\u0001\u0017\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\r\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0005\u0005\u0002#\u00015\t1#A\u0005u_BL7MT1nKV\tQ\u0005\u0005\u0002'W5\tqE\u0003\u0002)S\u0005!A.\u00198h\u0015\u0005Q\u0013\u0001\u00026bm\u0006L!\u0001L\u0014\u0003\rM#(/\u001b8h\u0003)!x\u000e]5d\u001d\u0006lW\rI\u0001\u001bKb\u0004Xm\u0019;fI:+XNY3s\u001f\u001a\u0004\u0016M\u001d;ji&|gn]\u000b\u0002aA\u0011!$M\u0005\u0003em\u00111!\u00138u\u0003m)\u0007\u0010]3di\u0016$g*^7cKJ|e\rU1si&$\u0018n\u001c8tA\u000511m\u001c8gS\u001e,\u0012A\u000e\t\u0003E]J!\u0001O\n\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\bG>tg-[4!\u0003\u0015\"Xm\u001d;E_:{GoQ1mY\u000e\u0013X-\u0019;f)>\u0004\u0018nY%g)>\u0004\u0018nY#ySN$8\u000fF\u0001=!\tQR(\u0003\u0002?7\t!QK\\5uQ\tA\u0001\t\u0005\u0002B\u00156\t!I\u0003\u0002D\t\u0006\u0019\u0011\r]5\u000b\u0005\u00153\u0015a\u00026va&$XM\u001d\u0006\u0003\u000f\"\u000bQA[;oSRT\u0011!S\u0001\u0004_J<\u0017BA&C\u0005\u0011!Vm\u001d;\u0002\u001fQ,7\u000f\u001e+pa&\u001c7I]3bi\u0016D#!\u0003!\u0002KQ,7\u000f\u001e+f[B|'/\u0019:jYf|U\u000f^(g'ft7-T3uC\u0012\fG/Y\"bG\",\u0007F\u0001\u0006A\u0003i!Xm\u001d;PkR|emU=oG6+G/\u00193bi\u0006\u001c\u0015m\u00195fQ\tY\u0001)\u0001\u000buKN$H+[7f_V$X\t_2faRLwN\u001c\u0015\u0003\u0019\u0001\u000bA\u0003^3tiVs7N\\8x]\u0016C8-\u001a9uS>t\u0007FA\u0007A\u0003Y!Xm\u001d;De\u0016\fG/\u001a+pa&\u001c'+Z9vKN$\bF\u0001\bA\u0003M\u0019'/Z1uKR{\u0007/[2SKN\u0004xN\\:f)\rQV\r\u001d\t\u00037\u000el\u0011\u0001\u0018\u0006\u0003;z\u000b\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0003?\u0002\faaY8n[>t'B\u0001\fb\u0015\t\u0011\u0007*\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003Ir\u0013Ac\u0011:fCR,Gk\u001c9jGN\u0014Vm\u001d9p]N,\u0007\"B\u0012\u0010\u0001\u00041\u0007CA4o\u001d\tAG\u000e\u0005\u0002j75\t!N\u0003\u0002l/\u00051AH]8pizJ!!\\\u000e\u0002\rA\u0013X\rZ3g\u0013\tasN\u0003\u0002n7!)\u0011o\u0004a\u0001e\u0006)QM\u001d:peB\u00111O^\u0007\u0002i*\u0011QOX\u0001\taJ|Go\\2pY&\u0011q\u000f\u001e\u0002\u0007\u000bJ\u0014xN]:\u0002+Q,7\u000f^+qI\u0006$X\rV8qS\u000e\u001cuN\u001c4jO\"\u0012\u0001\u0003Q\u0001*i\u0016\u001cH/\u00169eCR,Gk\u001c9jG\u000e{gNZ5h\u0013\u001a4\u0016\r\\;fg\u0006c'/Z1es6\u000bGo\u00195)\u0005E\u0001\u0005")
public final class KraftInternalAdminTest {
    private final String kafka$server$KraftInternalAdminTest$$topicName;
    private final int expectedNumberOfPartitions;
    private final KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);

    public String kafka$server$KraftInternalAdminTest$$topicName() {
        return this.kafka$server$KraftInternalAdminTest$$topicName;
    }

    private int expectedNumberOfPartitions() {
        return this.expectedNumberOfPartitions;
    }

    private KafkaConfig config() {
        return this.config;
    }

    @Test
    public void testDoNotCallCreateTopicIfTopicExists() {
        int incorrectNumberOfPartitions = this.expectedNumberOfPartitions() + 1;
        NodeToControllerChannelManager channel = (NodeToControllerChannelManager)Mockito.mock(NodeToControllerChannelManager.class);
        KRaftMetadataCache metadataCache = (KRaftMetadataCache)Mockito.mock(KRaftMetadataCache.class);
        KraftInternalAdmin internalAdmin = new KraftInternalAdmin(channel, metadataCache, Integer.MAX_VALUE, () -> this.config());
        Mockito.when((Object)metadataCache.numPartitions(this.kafka$server$KraftInternalAdminTest$$topicName())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)this.expectedNumberOfPartitions())));
        Assertions.assertEquals((int)this.expectedNumberOfPartitions(), (int)internalAdmin.ensureTopic(this.kafka$server$KraftInternalAdminTest$$topicName(), incorrectNumberOfPartitions, (short)1, new Properties()));
        ((NodeToControllerChannelManager)Mockito.verify((Object)channel, (VerificationMode)Mockito.never())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
    }

    @Test
    public void testTopicCreate() {
        NodeToControllerChannelManager channel = (NodeToControllerChannelManager)Mockito.mock(NodeToControllerChannelManager.class);
        KRaftMetadataCache metadataCache = (KRaftMetadataCache)Mockito.mock(KRaftMetadataCache.class);
        KraftInternalAdmin internalAdmin = new KraftInternalAdmin(channel, metadataCache, Integer.MAX_VALUE, () -> this.config());
        Mockito.when((Object)metadataCache.numPartitions(this.kafka$server$KraftInternalAdminTest$$topicName())).thenReturn((Object)None$.MODULE$);
        channel.sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(this){
            private final /* synthetic */ KraftInternalAdminTest $outer;

            public void answer(InvocationOnMock invocation) {
                ControllerRequestCompletionHandler handler = (ControllerRequestCompletionHandler)invocation.getArgument(1);
                ClientResponse response = (ClientResponse)Mockito.mock(ClientResponse.class);
                Mockito.when((Object)response.responseBody()).thenReturn((Object)this.$outer.kafka$server$KraftInternalAdminTest$$createTopicResponse(this.$outer.kafka$server$KraftInternalAdminTest$$topicName(), Errors.NONE));
                Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)response.hasResponse())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
                handler.onComplete(response);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assertions.assertEquals((int)this.expectedNumberOfPartitions(), (int)internalAdmin.ensureTopic(this.kafka$server$KraftInternalAdminTest$$topicName(), this.expectedNumberOfPartitions(), (short)1, new Properties()));
        ((NodeToControllerChannelManager)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
    }

    @Test
    public void testTemporarilyOutOfSyncMetadataCache() {
        NodeToControllerChannelManager channel = (NodeToControllerChannelManager)Mockito.mock(NodeToControllerChannelManager.class);
        KRaftMetadataCache metadataCache = (KRaftMetadataCache)Mockito.mock(KRaftMetadataCache.class);
        KraftInternalAdmin internalAdmin = new KraftInternalAdmin(channel, metadataCache, Integer.MAX_VALUE, () -> this.config());
        Mockito.when((Object)metadataCache.numPartitions(this.kafka$server$KraftInternalAdminTest$$topicName())).thenReturn((Object)None$.MODULE$).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)this.expectedNumberOfPartitions())));
        channel.sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(this){
            private final /* synthetic */ KraftInternalAdminTest $outer;

            public void answer(InvocationOnMock invocation) {
                ControllerRequestCompletionHandler handler = (ControllerRequestCompletionHandler)invocation.getArgument(1);
                ClientResponse response = (ClientResponse)Mockito.mock(ClientResponse.class);
                Mockito.when((Object)response.responseBody()).thenReturn((Object)this.$outer.kafka$server$KraftInternalAdminTest$$createTopicResponse(this.$outer.kafka$server$KraftInternalAdminTest$$topicName(), Errors.TOPIC_ALREADY_EXISTS));
                Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)response.hasResponse())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
                handler.onComplete(response);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assertions.assertEquals((int)this.expectedNumberOfPartitions(), (int)internalAdmin.ensureTopic(this.kafka$server$KraftInternalAdminTest$$topicName(), this.expectedNumberOfPartitions(), (short)1, new Properties()));
        ((NodeToControllerChannelManager)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
    }

    @Test
    public void testOutOfSyncMetadataCache() {
        NodeToControllerChannelManager channel = (NodeToControllerChannelManager)Mockito.mock(NodeToControllerChannelManager.class);
        KRaftMetadataCache metadataCache = (KRaftMetadataCache)Mockito.mock(KRaftMetadataCache.class);
        KraftInternalAdmin internalAdmin = new KraftInternalAdmin(channel, metadataCache, Integer.MAX_VALUE, () -> this.config());
        Mockito.when((Object)metadataCache.numPartitions(this.kafka$server$KraftInternalAdminTest$$topicName())).thenReturn((Object)None$.MODULE$);
        channel.sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(this){
            private final /* synthetic */ KraftInternalAdminTest $outer;

            public void answer(InvocationOnMock invocation) {
                ControllerRequestCompletionHandler handler = (ControllerRequestCompletionHandler)invocation.getArgument(1);
                ClientResponse response = (ClientResponse)Mockito.mock(ClientResponse.class);
                Mockito.when((Object)response.responseBody()).thenReturn((Object)this.$outer.kafka$server$KraftInternalAdminTest$$createTopicResponse(this.$outer.kafka$server$KraftInternalAdminTest$$topicName(), Errors.TOPIC_ALREADY_EXISTS));
                Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)response.hasResponse())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
                handler.onComplete(response);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> internalAdmin.ensureTopic(this.kafka$server$KraftInternalAdminTest$$topicName(), this.expectedNumberOfPartitions(), (short)1, new Properties()));
        ((NodeToControllerChannelManager)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
    }

    @Test
    public void testTimeoutException() {
        NodeToControllerChannelManager channel = (NodeToControllerChannelManager)Mockito.mock(NodeToControllerChannelManager.class);
        KRaftMetadataCache metadataCache = (KRaftMetadataCache)Mockito.mock(KRaftMetadataCache.class);
        KraftInternalAdmin internalAdmin = new KraftInternalAdmin(channel, metadataCache, Integer.MAX_VALUE, () -> this.config());
        Mockito.when((Object)metadataCache.numPartitions(this.kafka$server$KraftInternalAdminTest$$topicName())).thenReturn((Object)None$.MODULE$);
        channel.sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(null){

            public void answer(InvocationOnMock invocation) {
                ((ControllerRequestCompletionHandler)invocation.getArgument(1)).onTimeout();
            }
        });
        Assertions.assertThrows(TimeoutException.class, () -> internalAdmin.ensureTopic(this.kafka$server$KraftInternalAdminTest$$topicName(), this.expectedNumberOfPartitions(), (short)1, new Properties()));
    }

    @Test
    public void testUnknownException() {
        NodeToControllerChannelManager channel = (NodeToControllerChannelManager)Mockito.mock(NodeToControllerChannelManager.class);
        KRaftMetadataCache metadataCache = (KRaftMetadataCache)Mockito.mock(KRaftMetadataCache.class);
        KraftInternalAdmin internalAdmin = new KraftInternalAdmin(channel, metadataCache, Integer.MAX_VALUE, () -> this.config());
        Mockito.when((Object)metadataCache.numPartitions(this.kafka$server$KraftInternalAdminTest$$topicName())).thenReturn((Object)None$.MODULE$);
        channel.sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(this){
            private final /* synthetic */ KraftInternalAdminTest $outer;

            public void answer(InvocationOnMock invocation) {
                ControllerRequestCompletionHandler handler = (ControllerRequestCompletionHandler)invocation.getArgument(1);
                ClientResponse response = (ClientResponse)Mockito.mock(ClientResponse.class);
                Mockito.when((Object)response.responseBody()).thenReturn((Object)this.$outer.kafka$server$KraftInternalAdminTest$$createTopicResponse(this.$outer.kafka$server$KraftInternalAdminTest$$topicName(), Errors.NOT_CONTROLLER));
                Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)response.hasResponse())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
                handler.onComplete(response);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assertions.assertThrows(NotControllerException.class, () -> internalAdmin.ensureTopic(this.kafka$server$KraftInternalAdminTest$$topicName(), this.expectedNumberOfPartitions(), (short)1, new Properties()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateTopicRequest() {
        void var2_2;
        short expectedReplicationFactor = 3;
        Properties properties = new Properties();
        properties.put("cleanup.policy", "delete");
        properties.put("retention.ms", "1234");
        properties.put("retention.bytes", "43");
        properties.put("unclean.leader.election.enable", "false");
        int timeoutMs = 5000;
        CreateTopicsRequest request = (CreateTopicsRequest)KraftInternalAdmin$.MODULE$.createTopicRequest(this.kafka$server$KraftInternalAdminTest$$topicName(), this.expectedNumberOfPartitions(), expectedReplicationFactor, (Properties)var2_2, timeoutMs).build();
        Assertions.assertEquals((int)timeoutMs, (int)request.data().timeoutMs());
        Assertions.assertEquals((int)1, (int)request.data().topics().size());
        CreateTopicsRequestData.CreatableTopic creatableTopic = (CreateTopicsRequestData.CreatableTopic)request.data().topics().valuesList().get(0);
        Assertions.assertEquals((Object)this.kafka$server$KraftInternalAdminTest$$topicName(), (Object)creatableTopic.name());
        Assertions.assertEquals((int)this.expectedNumberOfPartitions(), (int)creatableTopic.numPartitions());
        Assertions.assertEquals((short)expectedReplicationFactor, (short)creatableTopic.replicationFactor());
        Assertions.assertEquals((int)var2_2.size(), (int)creatableTopic.configs().size());
        CollectionConverters$.MODULE$.PropertiesHasAsScala((Properties)var2_2).asScala().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)KraftInternalAdminTest.$anonfun$testCreateTopicRequest$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> {
            KraftInternalAdminTest.$anonfun$testCreateTopicRequest$2(creatableTopic, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public CreateTopicsResponse kafka$server$KraftInternalAdminTest$$createTopicResponse(String topicName, Errors error) {
        CreateTopicsResponseData.CreatableTopicResultCollection topics = new CreateTopicsResponseData.CreatableTopicResultCollection(1);
        topics.add((ImplicitLinkedHashCollection.Element)new CreateTopicsResponseData.CreatableTopicResult().setName(topicName).setErrorCode(error.code()).setErrorMessage(error.message()));
        CreateTopicsResponseData data = new CreateTopicsResponseData().setTopics(topics);
        return new CreateTopicsResponse(data);
    }

    @Test
    public void testUpdateTopicConfig() {
        Properties existingConfigs = TierTopic.topicConfig();
        existingConfigs.put("unclean.leader.election.enable", "true");
        NodeToControllerChannelManager channel = (NodeToControllerChannelManager)Mockito.mock(NodeToControllerChannelManager.class);
        KRaftMetadataCache metadataCache = (KRaftMetadataCache)Mockito.mock(KRaftMetadataCache.class);
        KraftInternalAdmin internalAdmin = new KraftInternalAdmin(channel, metadataCache, Integer.MAX_VALUE, () -> this.config());
        ArrayList<IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse> responses = new ArrayList<IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse>();
        responses.add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName(this.kafka$server$KraftInternalAdminTest$$topicName()).setErrorCode(Errors.NONE.code()).setErrorMessage(""));
        IncrementalAlterConfigsResponse incrementalAlterConfigsResponse = new IncrementalAlterConfigsResponse(new IncrementalAlterConfigsResponseData().setResponses(responses));
        channel.sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(null, incrementalAlterConfigsResponse){
            private final IncrementalAlterConfigsResponse incrementalAlterConfigsResponse$1;

            public void answer(InvocationOnMock invocation) {
                ControllerRequestCompletionHandler handler = (ControllerRequestCompletionHandler)invocation.getArgument(1);
                ClientResponse clientResponse = (ClientResponse)Mockito.mock(ClientResponse.class);
                Mockito.when((Object)clientResponse.authenticationException()).thenReturn(null);
                Mockito.when((Object)clientResponse.versionMismatch()).thenReturn(null);
                Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)clientResponse.hasResponse())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
                Mockito.when((Object)clientResponse.responseBody()).thenReturn((Object)this.incrementalAlterConfigsResponse$1);
                handler.onComplete(clientResponse);
            }
            {
                this.incrementalAlterConfigsResponse$1 = incrementalAlterConfigsResponse$1;
            }
        });
        Mockito.when((Object)metadataCache.getTopicId(this.kafka$server$KraftInternalAdminTest$$topicName())).thenReturn((Object)Uuid.randomUuid());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)metadataCache.contains(this.kafka$server$KraftInternalAdminTest$$topicName()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)metadataCache.topicConfig(this.kafka$server$KraftInternalAdminTest$$topicName())).thenReturn((Object)existingConfigs);
        Mockito.when((Object)this.config().extractLogConfigMap()).thenReturn(new HashMap());
        DynamicBrokerConfig dynamicBrokerConfig = (DynamicBrokerConfig)Mockito.mock(DynamicBrokerConfig.class);
        Mockito.when((Object)this.config().dynamicConfig()).thenReturn((Object)dynamicBrokerConfig);
        Mockito.when((Object)dynamicBrokerConfig.currentDynamicBrokerConfigs()).thenReturn((Object)Predef$.MODULE$.Map().empty());
        Mockito.when((Object)dynamicBrokerConfig.currentDynamicDefaultConfigs()).thenReturn((Object)Predef$.MODULE$.Map().empty());
        Mockito.when((Object)dynamicBrokerConfig.staticBrokerConfigs()).thenReturn(Map$.MODULE$.empty());
        Mockito.when((Object)dynamicBrokerConfig.staticDefaultConfigs()).thenReturn(Map$.MODULE$.empty());
        internalAdmin.updateTopicConfig(this.kafka$server$KraftInternalAdminTest$$topicName(), TierTopic.topicConfig());
        ((ConfigRepository)Mockito.verify((Object)metadataCache, (VerificationMode)Mockito.times((int)1))).topicConfig(this.kafka$server$KraftInternalAdminTest$$topicName());
        ((NodeToControllerChannelManager)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
    }

    @Test
    public void testUpdateTopicConfigIfValuesAlreadyMatch() {
        Properties existingConfigs = TierTopic.topicConfig();
        NodeToControllerChannelManager channel = (NodeToControllerChannelManager)Mockito.mock(NodeToControllerChannelManager.class);
        KRaftMetadataCache metadataCache = (KRaftMetadataCache)Mockito.mock(KRaftMetadataCache.class);
        KraftInternalAdmin internalAdmin = new KraftInternalAdmin(channel, metadataCache, Integer.MAX_VALUE, () -> this.config());
        Mockito.when((Object)metadataCache.getTopicId(this.kafka$server$KraftInternalAdminTest$$topicName())).thenReturn((Object)Uuid.randomUuid());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)metadataCache.contains(this.kafka$server$KraftInternalAdminTest$$topicName()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)metadataCache.topicConfig(this.kafka$server$KraftInternalAdminTest$$topicName())).thenReturn((Object)existingConfigs);
        Mockito.when((Object)this.config().extractLogConfigMap()).thenReturn(new HashMap());
        DynamicBrokerConfig dynamicBrokerConfig = (DynamicBrokerConfig)Mockito.mock(DynamicBrokerConfig.class);
        Mockito.when((Object)this.config().dynamicConfig()).thenReturn((Object)dynamicBrokerConfig);
        Mockito.when((Object)dynamicBrokerConfig.currentDynamicBrokerConfigs()).thenReturn((Object)Predef$.MODULE$.Map().empty());
        Mockito.when((Object)dynamicBrokerConfig.currentDynamicDefaultConfigs()).thenReturn((Object)Predef$.MODULE$.Map().empty());
        Mockito.when((Object)dynamicBrokerConfig.staticBrokerConfigs()).thenReturn(Map$.MODULE$.empty());
        Mockito.when((Object)dynamicBrokerConfig.staticDefaultConfigs()).thenReturn(Map$.MODULE$.empty());
        internalAdmin.updateTopicConfig(this.kafka$server$KraftInternalAdminTest$$topicName(), TierTopic.topicConfig());
        ((ConfigRepository)Mockito.verify((Object)metadataCache, (VerificationMode)Mockito.times((int)1))).topicConfig(this.kafka$server$KraftInternalAdminTest$$topicName());
        ((NodeToControllerChannelManager)Mockito.verify((Object)channel, (VerificationMode)Mockito.never())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
    }

    public static final /* synthetic */ boolean $anonfun$testCreateTopicRequest$1(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$testCreateTopicRequest$2(CreateTopicsRequestData.CreatableTopic creatableTopic$1, Tuple2 x$1) {
        if (x$1 != null) {
            String key = (String)x$1._1();
            Assertions.assertEquals((Object)((String)x$1._2()), (Object)creatableTopic$1.configs().find(key).value());
            return;
        }
        throw new MatchError(null);
    }

    public KraftInternalAdminTest() {
        this.kafka$server$KraftInternalAdminTest$$topicName = "topicName";
        this.expectedNumberOfPartitions = 10;
    }
}

