/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.server.GroupCoordinatorBaseRequestTest;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.classic.ClassicGroupState;
import org.apache.kafka.coordinator.group.consumer.ConsumerGroup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Timeout(value=120L)
@ExtendWith(value={ClusterTestExtensions.class})
@ClusterTestDefaults(clusterType=Type.KRAFT, brokers=1)
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\u0005Ma\u0001B\u0004\t\u00015A\u0001B\u0005\u0001\u0003\u0002\u0003\u0006Ia\u0005\u0005\u00063\u0001!\tA\u0007\u0005\u0006;\u0001!\tA\b\u0005\u0006\u0011\u0002!\tA\b\u0005\u0006\u0017\u0002!\tA\b\u0005\u0006/\u0002!I\u0001\u0017\u0002\u0016\u0019&\u001cHo\u0012:pkB\u001c(+Z9vKN$H+Z:u\u0015\tI!\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0017\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u000f!\ty\u0001#D\u0001\t\u0013\t\t\u0002BA\u0010He>,\boQ8pe\u0012Lg.\u0019;pe\n\u000b7/\u001a*fcV,7\u000f\u001e+fgR\fqa\u00197vgR,'\u000f\u0005\u0002\u0015/5\tQC\u0003\u0002\u0017\u0015\u0005!A/Z:u\u0013\tARCA\bDYV\u001cH/\u001a:J]N$\u0018M\\2f\u0003\u0019a\u0014N\\5u}Q\u00111\u0004\b\t\u0003\u001f\u0001AQA\u0005\u0002A\u0002M\t\u0001\t^3ti2K7\u000f^$s_V\u00048oV5uQ:+woQ8ogVlWM]$s_V\u0004\bK]8u_\u000e|G.\u00118e\u001d\u0016<xI]8va\u000e{wN\u001d3j]\u0006$xN\u001d\u000b\u0002?A\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t!QK\\5uQ\u0011\u0019a\u0005L\u0017\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%*\u0012AC1o]>$\u0018\r^5p]&\u00111\u0006\u000b\u0002\f\u00072,8\u000f^3s)\u0016\u001cH/\u0001\ttKJ4XM\u001d)s_B,'\u000f^5fg2*a\u0006O\u001fA\u000b.*qFM\u001a6mA\u0011q\u0005M\u0005\u0003c!\u0012Qc\u00117vgR,'oQ8oM&<\u0007K]8qKJ$\u00180A\u0002lKf\f\u0013\u0001N\u0001\u001dOJ|W\u000f\u001d\u0018d_>\u0014H-\u001b8bi>\u0014hF\\3x]\u0015t\u0017M\u00197f\u0003\u00151\u0018\r\\;fC\u00059\u0014\u0001\u0002;sk\u0016\\Sa\f\u001a:km\n\u0013AO\u0001&OJ|W\u000f\u001d\u0018d_:\u001cX/\\3s]5\f\u0007PL:fgNLwN\u001c\u0018uS6,w.\u001e;/[N\f\u0013\u0001P\u0001\u0007mA\u0002\u0004\u0007\r\u0019,\u000b=\u0012d(N\u001e\"\u0003}\n\u0011e\u001a:pkBt3m\u001c8tk6,'OL:fgNLwN\u001c\u0018uS6,w.\u001e;/[N\\Sa\f\u001aBk\r\u000b\u0013AQ\u0001\u001d_\u001a47/\u001a;t]Q|\u0007/[2/]Vlg\u0006]1si&$\u0018n\u001c8tC\u0005!\u0015!A\u0019,\u000b=\u0012d)N\"\"\u0003\u001d\u000b\u0001e\u001c4gg\u0016$8O\f;pa&\u001cgF]3qY&\u001c\u0017\r^5p]:2\u0017m\u0019;pe\u0006\u0001E/Z:u\u0019&\u001cHo\u0012:pkB\u001cx+\u001b;i\u001f2$7i\u001c8tk6,'o\u0012:pkB\u0004&o\u001c;pG>d\u0017I\u001c3OK^<%o\\;q\u0007>|'\u000fZ5oCR|'\u000f\u000b\u0003\u0005M1REf\u0001\u0018A\u000b\u0006\u0001E/Z:u\u0019&\u001cHo\u0012:pkB\u001cx+\u001b;i\u001f2$7i\u001c8tk6,'o\u0012:pkB\u0004&o\u001c;pG>d\u0017I\u001c3PY\u0012<%o\\;q\u0007>|'\u000fZ5oCR|'\u000f\u000b\u0004\u0006M5sEfU\u0001\fG2,8\u000f^3s)f\u0004X\rJ\u0001P\u0013\t\u0001\u0016+A\u0002B\u00192S!A\u0015\u0015\u0002\tQK\b/\u001a\u0017\u0004)\u0002+5&B\u00183gU*\u0016%\u0001,\u0002\u000b\u0019\fGn]3\u0002\u001dQ,7\u000f\u001e'jgR<%o\\;qgR\u0011q$\u0017\u0005\u00065\u001a\u0001\raW\u0001\u000fkN,g*Z<Qe>$xnY8m!\t\u0001C,\u0003\u0002^C\t9!i\\8mK\u0006t\u0007\u0006\u0002\u0001`k-\u0004\"\u0001Y5\u000e\u0003\u0005T!AY2\u0002\u0007\u0005\u0004\u0018N\u0003\u0002eK\u00069!.\u001e9ji\u0016\u0014(B\u00014h\u0003\u0015QWO\\5u\u0015\u0005A\u0017aA8sO&\u0011!.\u0019\u0002\b)&lWm\\;u=\u0005A\b\u0006\u0002\u0001nkM\u0004\"A\\9\u000e\u0003=T!\u0001]1\u0002\u0013\u0015DH/\u001a8tS>t\u0017B\u0001:p\u0005))\u0005\u0010^3oI^KG\u000f\u001b\u0017\u0002i\u000e\nQ\u000f\u0005\u0002wq6\tqO\u0003\u0002g+%\u0011\u0011p\u001e\u0002\u0016\u00072,8\u000f^3s)\u0016\u001cH/\u0012=uK:\u001c\u0018n\u001c8tQ!\u000110\u0014@\u0002\u0004\u0005\u0015\u0001CA\u0014}\u0013\ti\bFA\nDYV\u001cH/\u001a:UKN$H)\u001a4bk2$8\u000fJ\u0001\u0000\u0013\r\t\t!U\u0001\u0006\u0017J\u000be\tV\u0001\bEJ|7.\u001a:t;\u0005\t\u0001F\u0002\u0001\u0002\nU\ny\u0001E\u0002a\u0003\u0017I1!!\u0004b\u0005\r!\u0016mZ\u0011\u0003\u0003#\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]\u0002")
public class ListGroupsRequestTest
extends GroupCoordinatorBaseRequestTest {
    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.new.enable", value="true"), @ClusterConfigProperty(key="group.consumer.max.session.timeout.ms", value="600000"), @ClusterConfigProperty(key="group.consumer.session.timeout.ms", value="600000"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")})
    public void testListGroupsWithNewConsumerGroupProtocolAndNewGroupCoordinator() {
        this.testListGroups(true);
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.new.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")})
    public void testListGroupsWithOldConsumerGroupProtocolAndNewGroupCoordinator() {
        this.testListGroups(false);
    }

    @ClusterTest(clusterType=Type.ALL, serverProperties={@ClusterConfigProperty(key="group.coordinator.new.enable", value="false"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")})
    public void testListGroupsWithOldConsumerGroupProtocolAndOldGroupCoordinator() {
        this.testListGroups(false);
    }

    private void testListGroups(boolean useNewProtocol) {
        if (!this.isNewGroupCoordinatorEnabled() && useNewProtocol) {
            Assertions.fail((String)"Cannot use the new protocol with the old group coordinator.");
        }
        this.createOffsetsTopic();
        this.createTopic("foo", 3);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ApiKeys.LIST_GROUPS.oldestVersion()), (int)ApiKeys.LIST_GROUPS.latestVersion(this.isUnstableApiEnabled())).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> {
            void var9_9;
            void var4_4;
            void var12_12;
            Tuple2<String, Object> tuple2 = this.joinDynamicConsumerGroupWithOldProtocol("grp-1", this.joinDynamicConsumerGroupWithOldProtocol$default$2(), this.joinDynamicConsumerGroupWithOldProtocol$default$3(), this.joinDynamicConsumerGroupWithOldProtocol$default$4());
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            String memberId1InGroup1 = (String)tuple2._1();
            ListGroupsResponseData.ListedGroup response1 = new ListGroupsResponseData.ListedGroup().setGroupId("grp-1").setProtocolType("consumer").setGroupState(version >= 4 ? ClassicGroupState.STABLE.toString() : "").setGroupType(version >= 5 ? Group.GroupType.CLASSIC.toString() : "");
            byte[] x$3 = this.joinDynamicConsumerGroupWithOldProtocol$default$2();
            byte[] x$4 = this.joinDynamicConsumerGroupWithOldProtocol$default$3();
            Tuple2<String, Object> tuple22 = this.joinDynamicConsumerGroupWithOldProtocol("grp-2", x$3, x$4, false);
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            String memberId1InGroup2 = (String)tuple22._1();
            ListGroupsResponseData.ListedGroup response2 = new ListGroupsResponseData.ListedGroup().setGroupId("grp-2").setProtocolType("consumer").setGroupState(version >= 4 ? ClassicGroupState.COMPLETING_REBALANCE.toString() : "").setGroupType(version >= 5 ? Group.GroupType.CLASSIC.toString() : "");
            Tuple2<String, Object> tuple23 = this.joinDynamicConsumerGroupWithOldProtocol("grp-3", this.joinDynamicConsumerGroupWithOldProtocol$default$2(), this.joinDynamicConsumerGroupWithOldProtocol$default$3(), this.joinDynamicConsumerGroupWithOldProtocol$default$4());
            if (tuple23 == null) {
                throw new MatchError(null);
            }
            String memberId1InGroup3 = (String)tuple23._1();
            this.leaveGroup("grp-3", (String)var12_12, false, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
            ListGroupsResponseData.ListedGroup response3 = new ListGroupsResponseData.ListedGroup().setGroupId("grp-3").setProtocolType("consumer").setGroupState(version >= 4 ? ClassicGroupState.EMPTY.toString() : "").setGroupType(version >= 5 ? Group.GroupType.CLASSIC.toString() : "");
            String memberId1InGroup4 = null;
            ListGroupsResponseData.ListedGroup response4 = null;
            String memberId1InGroup5 = null;
            String memberId2InGroup5 = null;
            ListGroupsResponseData.ListedGroup response5 = null;
            ListGroupsResponseData.ListedGroup response6 = null;
            if (useNewProtocol) {
                memberId1InGroup4 = (String)this.joinConsumerGroup("grp-4", true)._1();
                response4 = new ListGroupsResponseData.ListedGroup().setGroupId("grp-4").setProtocolType("consumer").setGroupState(version >= 4 ? ConsumerGroup.ConsumerGroupState.STABLE.toString() : "").setGroupType(version >= 5 ? Group.GroupType.CONSUMER.toString() : "");
                memberId1InGroup5 = (String)this.joinConsumerGroup("grp-5", true)._1();
                memberId2InGroup5 = (String)this.joinConsumerGroup("grp-5", true)._1();
                response5 = new ListGroupsResponseData.ListedGroup().setGroupId("grp-5").setProtocolType("consumer").setGroupState(version >= 4 ? ConsumerGroup.ConsumerGroupState.RECONCILING.toString() : "").setGroupType(version >= 5 ? Group.GroupType.CONSUMER.toString() : "");
                String memberId1InGroup6 = (String)this.joinConsumerGroup("grp-6", true)._1();
                this.leaveGroup("grp-6", memberId1InGroup6, true, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
                response6 = new ListGroupsResponseData.ListedGroup().setGroupId("grp-6").setProtocolType("consumer").setGroupState(version >= 4 ? ConsumerGroup.ConsumerGroupState.EMPTY.toString() : "").setGroupType(version >= 5 ? Group.GroupType.CONSUMER.toString() : "");
            }
            Assertions.assertEquals((Object)(useNewProtocol ? new .colon.colon((Object)response1, (List)new .colon.colon((Object)response2, (List)new .colon.colon((Object)response3, (List)new .colon.colon(response4, (List)new .colon.colon(response5, (List)new .colon.colon(response6, (List)Nil$.MODULE$)))))).toSet() : new .colon.colon((Object)response1, (List)new .colon.colon((Object)response2, (List)new .colon.colon((Object)response3, (List)Nil$.MODULE$))).toSet()), (Object)this.listGroups((List<String>)package$.MODULE$.List().empty(), (List<String>)package$.MODULE$.List().empty(), (short)version).toSet());
            if (version >= 4) {
                Assertions.assertEquals((Object)(useNewProtocol ? new .colon.colon((Object)response4, (List)new .colon.colon((Object)response1, (List)Nil$.MODULE$)) : new .colon.colon((Object)response1, (List)Nil$.MODULE$)), this.listGroups((List<String>)new .colon.colon((Object)ConsumerGroup.ConsumerGroupState.STABLE.toString(), (List)Nil$.MODULE$), (List<String>)package$.MODULE$.List().empty(), (short)version));
                Assertions.assertEquals((Object)(useNewProtocol ? new .colon.colon((Object)response2, (List)new .colon.colon((Object)response5, (List)Nil$.MODULE$)).toSet() : new .colon.colon((Object)response2, (List)Nil$.MODULE$).toSet()), (Object)this.listGroups((List<String>)new .colon.colon((Object)ClassicGroupState.COMPLETING_REBALANCE.toString(), (List)new .colon.colon((Object)ConsumerGroup.ConsumerGroupState.RECONCILING.toString(), (List)Nil$.MODULE$)), (List<String>)package$.MODULE$.List().empty(), (short)version).toSet());
                Assertions.assertEquals((Object)(useNewProtocol ? new .colon.colon((Object)response4, (List)new .colon.colon((Object)response1, (List)new .colon.colon((Object)response3, (List)new .colon.colon((Object)response6, (List)Nil$.MODULE$)))).toSet() : new .colon.colon((Object)response1, (List)new .colon.colon((Object)response3, (List)Nil$.MODULE$)).toSet()), (Object)this.listGroups((List<String>)new .colon.colon((Object)ClassicGroupState.STABLE.toString(), (List)new .colon.colon((Object)ClassicGroupState.EMPTY.toString(), (List)new .colon.colon((Object)ConsumerGroup.ConsumerGroupState.EMPTY.toString(), (List)Nil$.MODULE$))), (List<String>)package$.MODULE$.List().empty(), (short)version).toSet());
                Assertions.assertEquals((Object)package$.MODULE$.List().empty(), this.listGroups((List<String>)new .colon.colon((Object)ConsumerGroup.ConsumerGroupState.ASSIGNING.toString(), (List)Nil$.MODULE$), (List<String>)package$.MODULE$.List().empty(), (short)version));
            }
            if (version >= 5) {
                Assertions.assertEquals((Object)(useNewProtocol ? new .colon.colon((Object)response4, (List)Nil$.MODULE$) : package$.MODULE$.List().empty()), this.listGroups((List<String>)new .colon.colon((Object)ConsumerGroup.ConsumerGroupState.STABLE.toString(), (List)Nil$.MODULE$), (List<String>)new .colon.colon((Object)Group.GroupType.CONSUMER.toString(), (List)Nil$.MODULE$), (short)version));
                Assertions.assertEquals((Object)(useNewProtocol ? new .colon.colon((Object)response4, (List)new .colon.colon((Object)response5, (List)new .colon.colon(response6, (List)Nil$.MODULE$))).toSet() : Predef$.MODULE$.Set().empty()), (Object)this.listGroups((List<String>)package$.MODULE$.List().empty(), (List<String>)new .colon.colon((Object)Group.GroupType.CONSUMER.toString(), (List)Nil$.MODULE$), (short)version).toSet());
                Assertions.assertEquals((Object)new .colon.colon((Object)response1, (List)new .colon.colon((Object)response2, (List)new .colon.colon((Object)response3, (List)Nil$.MODULE$))).toSet(), (Object)this.listGroups((List<String>)package$.MODULE$.List().empty(), (List<String>)new .colon.colon((Object)Group.GroupType.CLASSIC.toString(), (List)Nil$.MODULE$), (short)version).toSet());
            }
            this.leaveGroup("grp-1", (String)var4_4, false, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
            this.leaveGroup("grp-2", (String)var9_9, false, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
            if (useNewProtocol) {
                this.leaveGroup("grp-4", memberId1InGroup4, true, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
                this.leaveGroup("grp-5", memberId1InGroup5, true, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
                this.leaveGroup("grp-5", memberId2InGroup5, true, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
            }
            this.deleteGroups((List<String>)(useNewProtocol ? new .colon.colon((Object)"grp-1", (List)new .colon.colon((Object)"grp-2", (List)new .colon.colon((Object)"grp-3", (List)new .colon.colon((Object)"grp-4", (List)new .colon.colon((Object)"grp-5", (List)new .colon.colon((Object)"grp-6", (List)Nil$.MODULE$)))))) : new .colon.colon((Object)"grp-1", (List)new .colon.colon((Object)"grp-2", (List)new .colon.colon((Object)"grp-3", (List)Nil$.MODULE$)))), (List<Errors>)(useNewProtocol ? (List)package$.MODULE$.List().fill(6, (Function0 & Serializable)() -> Errors.NONE) : (List)package$.MODULE$.List().fill(3, (Function0 & Serializable)() -> Errors.NONE)), ApiKeys.DELETE_GROUPS.latestVersion(this.isUnstableApiEnabled()));
            Assertions.assertEquals((Object)package$.MODULE$.List().empty(), this.listGroups((List<String>)package$.MODULE$.List().empty(), (List<String>)package$.MODULE$.List().empty(), (short)version));
        });
    }

    public ListGroupsRequestTest(ClusterInstance cluster) {
        super(cluster);
    }
}

