/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Me\u0001\u0002\u000b\u0016\u0001iAQa\b\u0001\u0005\u0002\u0001BqA\t\u0001C\u0002\u0013\u00051\u0005\u0003\u0004-\u0001\u0001\u0006I\u0001\n\u0005\b[\u0001\u0011\r\u0011\"\u0001/\u0011\u0019Q\u0004\u0001)A\u0005_!)1\b\u0001C\u0001y!)a\n\u0001C\u0001y!)\u0001\u000b\u0001C\u0001y!)!\u000b\u0001C\u0001'\")A\u000e\u0001C\u0001y!)a\u000e\u0001C\u0001y!1\u0001\u000f\u0001Q\u0005\nED\u0001\"!\u000b\u0001A\u0013%\u00111\u0006\u0005\t\u0003s\u0001\u0001\u0015\"\u0003\u0002<!1\u0011\u0011\n\u0001\u0005\u0002qBa!!\u0014\u0001\t\u0003a\u0004bBA)\u0001\u0011%\u00111\u000b\u0005\u0007a\u0002!I!!\u001b\t\u000f\u0005]\u0004\u0001\"\u0001\u0002z\t1B*[:u\u001f\u001a47/\u001a;t%\u0016\fX/Z:u)\u0016\u001cHO\u0003\u0002\u0017/\u000511/\u001a:wKJT\u0011\u0001G\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\u0004\u0005\u0002\u001d;5\tQ#\u0003\u0002\u001f+\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002CA\u0011A\u0004A\u0001\u0006i>\u0004\u0018nY\u000b\u0002IA\u0011QEK\u0007\u0002M)\u0011q\u0005K\u0001\u0005Y\u0006twMC\u0001*\u0003\u0011Q\u0017M^1\n\u0005-2#AB*ue&tw-\u0001\u0004u_BL7\rI\u0001\na\u0006\u0014H/\u001b;j_:,\u0012a\f\t\u0003aaj\u0011!\r\u0006\u0003eM\naaY8n[>t'B\u0001\r5\u0015\t)d'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002o\u0005\u0019qN]4\n\u0005e\n$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0004\u0013a\u000b;fgRd\u0015n\u001d;PM\u001a\u001cX\r^:SKF,Xm\u001d;G_JtuN\u001c+jKJ,G\rU1si&$\u0018n\u001c8\u0015\u0003u\u0002\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u0012A!\u00168ji\"\u0012a\u0001\u0012\t\u0003\u000b2k\u0011A\u0012\u0006\u0003\u000f\"\u000b1!\u00199j\u0015\tI%*A\u0004kkBLG/\u001a:\u000b\u0005-3\u0014!\u00026v]&$\u0018BA'G\u0005\u0011!Vm\u001d;\u00023Q,7\u000f\u001e'jgR|eMZ:fiN,%O]8s\u0007>$Wm\u001d\u0015\u0003\u000f\u0011\u000b\u0001\u0006^3ti2K7\u000f^(gMN,Go]'bqRKW.Z*uC6\u0004x\n\u001c3fgR4VM]:j_:D#\u0001\u0003#\u00027\u0005\u001c8/\u001a:u%\u0016\u001c\bo\u001c8tK\u0016\u0013(o\u001c:G_J,\u0005o\\2i)\u0011iD\u000bX1\t\u000bUK\u0001\u0019\u0001,\u0002\u000b\u0015\u0014(o\u001c:\u0011\u0005]SV\"\u0001-\u000b\u0005e\u000b\u0014\u0001\u00039s_R|7m\u001c7\n\u0005mC&AB#se>\u00148\u000fC\u0003^\u0013\u0001\u0007a,\u0001\u0005ce>\\WM]%e!\tqt,\u0003\u0002a\u007f\t\u0019\u0011J\u001c;\t\u000b\tL\u0001\u0019A2\u0002%\r,(O]3oi2+\u0017\rZ3s\u000bB|7\r\u001b\t\u0004I\u001eLW\"A3\u000b\u0005\u0019D\u0013\u0001B;uS2L!\u0001[3\u0003\u0011=\u0003H/[8oC2\u0004\"!\n6\n\u0005-4#aB%oi\u0016<WM]\u0001Hi\u0016\u001cH\u000fT5ti>3gm]3ugJ+\u0017/^3ti\u0012+(/\u001b8h!\u0006\u0014H/\u001b;j_:\u0014VmY8wKJL\u0018I\u001a;feVs7\r\\3b]2+\u0017\rZ3s\u000b2,7\r^5p]\"\u0012!\u0002R\u0001\u001bi\u0016\u001cHoQ;se\u0016tG/\u00129pG\"4\u0016\r\\5eCRLwN\u001c\u0015\u0003\u0017\u0011\u000b1b]3oIJ+\u0017/^3tiR9!/!\u0005\u0002\u0016\u0005}\u0001cA:\u0002\f9\u0019A/!\u0002\u000f\u0007U\f\tA\u0004\u0002w\u007f:\u0011qO \b\u0003qvt!!\u001f?\u000e\u0003iT!a_\r\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0014BA\u001b7\u0013\tAB'\u0003\u00023g%\u0019\u00111A\u0019\u0002\u000f5,7o]1hK&!\u0011qAA\u0005\u0003]a\u0015n\u001d;PM\u001a\u001cX\r^:SKN\u0004xN\\:f\t\u0006$\u0018MC\u0002\u0002\u0004EJA!!\u0004\u0002\u0010\taB*[:u\u001f\u001a47/\u001a;t!\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9p]N,'\u0002BA\u0004\u0003\u0013Aa!a\u0005\r\u0001\u0004q\u0016\u0001C:feZ,'/\u00133\t\u000f\u0005]A\u00021\u0001\u0002\u001a\u0005IA/[7fgR\fW\u000e\u001d\t\u0004}\u0005m\u0011bAA\u000f\u007f\t!Aj\u001c8h\u0011\u001d\t\t\u0003\u0004a\u0001\u0003G\tqA^3sg&|g\u000eE\u0002?\u0003KI1!a\n@\u0005\u0015\u0019\u0006n\u001c:u\u0003M1W\r^2i\u001f\u001a47/\u001a;B]\u0012,\u0005o\\2i)!\ti#a\r\u00026\u0005]\u0002C\u0002 \u00020\u0005ea,C\u0002\u00022}\u0012a\u0001V;qY\u0016\u0014\u0004BBA\n\u001b\u0001\u0007a\fC\u0004\u0002\u00185\u0001\r!!\u0007\t\u000f\u0005\u0005R\u00021\u0001\u0002$\u0005ab-\u001a;dQ>3gm]3u\u0003:$W\t]8dQ^KG\u000f[#se>\u0014H\u0003CA\u001f\u0003\u0007\n)%a\u0012\u0011\u0011y\ny$!\u0007_\u0003GI1!!\u0011@\u0005\u0019!V\u000f\u001d7fg!1\u00111\u0003\bA\u0002yCq!a\u0006\u000f\u0001\u0004\tI\u0002C\u0004\u0002\"9\u0001\r!a\t\u0002?Q,7\u000f\u001e*fgB|gn]3J]\u000edW\u000fZ3t\u0019\u0016\fG-\u001a:Fa>\u001c\u0007\u000e\u000b\u0002\u0010\t\u0006)D/Z:u%\u0016\u001c\bo\u001c8tK\u0012+g-Y;mi>3gm]3u\u0003:$G*Z1eKJ,\u0005o\\2i\r>\u0014\u0018\t\u001c7WKJ\u001c\u0018n\u001c8tQ\t\u0001B)A\nbgN,'\u000f\u001e*fgB|gn]3FeJ|'\u000fF\u0004>\u0003+\n9&!\u0017\t\u000bU\u000b\u0002\u0019\u0001,\t\u000bu\u000b\u0002\u0019\u00010\t\u000f\u0005m\u0013\u00031\u0001\u0002^\u00059!/Z9vKN$\b\u0003BA0\u0003Kj!!!\u0019\u000b\u0007\u0005\r\u0014'\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\t9'!\u0019\u0003%1K7\u000f^(gMN,Go\u001d*fcV,7\u000f\u001e\u000b\u0007\u0003W\n\t(!\u001e\u0011\t\u0005}\u0013QN\u0005\u0005\u0003_\n\tGA\nMSN$xJ\u001a4tKR\u001c(+Z:q_:\u001cX\r\u0003\u0004\u0002tI\u0001\rAX\u0001\tY\u0016\fG-\u001a:JI\"9\u00111\f\nA\u0002\u0005u\u0013aC2sK\u0006$X\rV8qS\u000e$b!a\u001f\u0002\f\u0006=\u0005CBA?\u0003\u000bsfL\u0004\u0003\u0002\u0000\u0005\u0005\u0005CA=@\u0013\r\t\u0019iP\u0001\u0007!J,G-\u001a4\n\t\u0005\u001d\u0015\u0011\u0012\u0002\u0004\u001b\u0006\u0004(bAAB\u007f!1\u0011QR\nA\u0002y\u000bQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\bBBAI'\u0001\u0007a,A\tsKBd\u0017nY1uS>tg)Y2u_J\u0004")
public class ListOffsetsRequestTest
extends BaseRequestTest {
    private final String topic;
    private final TopicPartition partition = new TopicPartition(this.topic(), 0);

    public String topic() {
        return this.topic;
    }

    public TopicPartition partition() {
        return this.partition;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListOffsetsRequestForNonTieredPartition() {
        String topicName = "test-topic";
        Properties props = new Properties();
        props.put("segment.bytes", "16384");
        props.put("retention.bytes", "-1");
        Map<Object, Object> partitionToLeaderMap = this.createTopic(topicName, 1, 1, props, this.createTopic$default$5(), this.createTopic$default$6());
        int numMessages = 3000;
        TestUtils$.MODULE$.generateAndProduceMessages(this.servers().toSeq(), topicName, numMessages, -1);
        TopicPartition topicPartition = new TopicPartition(topicName, 0);
        int leaderId = BoxesRunTime.unboxToInt((Object)partitionToLeaderMap.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        LogManager qual$1 = ((KafkaServer)this.serverForId(leaderId).get()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$1.getLog(topicPartition, x$2).get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 180000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ListOffsetsRequestTest.$anonfun$testListOffsetsRequestForNonTieredPartition$1(log, numMessages)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timeout waiting for all records to be produced");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.makeListOffsetsRequestAndValidateResponse(topicPartition, -1L, leaderId, log, (short)0);
        log.maybeIncrementHighWatermark(new LogOffsetMetadata(log.logStartOffset() + 100L));
        log.maybeIncrementLogStartOffset(log.logStartOffset() + 100L, LogStartOffsetIncrementReason.LeaderOffsetIncremented);
        this.makeListOffsetsRequestAndValidateResponse(topicPartition, -1L, leaderId, log, (short)0);
        this.makeListOffsetsRequestAndValidateResponse(topicPartition, -2L, leaderId, log, (short)0);
    }

    @Test
    public void testListOffsetsErrorCodes() {
        java.util.List targetTimes = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(this.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(this.partition().partition()).setTimestamp(-2L).setCurrentLeaderEpoch(0), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava();
        ListOffsetsRequest consumerRequest = (ListOffsetsRequest)ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false).setTargetTimes(targetTimes).build();
        ListOffsetsRequest replicaRequest = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)((KafkaServer)this.servers().head()).config().brokerId()).setTargetTimes(targetTimes).build();
        ListOffsetsRequest debugReplicaRequest = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)-2).setTargetTimes(targetTimes).build();
        int randomBrokerId = ((KafkaServer)this.servers().head()).config().brokerId();
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, consumerRequest);
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, replicaRequest);
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, debugReplicaRequest);
        Map<Object, Object> partitionToLeader = this.createTopic(1, 2);
        Set replicas = this.zkClient().getReplicasForPartition(this.partition()).toSet();
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)this.partition().partition())));
        int follower = BoxesRunTime.unboxToInt((Object)replicas.find((Function1)(JFunction1.mcZI.sp & Serializable)x$1 -> x$1 != leader).get());
        int nonReplica = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.servers().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)ListOffsetsRequestTest.$anonfun$testListOffsetsErrorCodes$2(x$2)))).find((Function1)(JFunction1.mcZI.sp & Serializable)x$3 -> !replicas.contains((Object)BoxesRunTime.boxToInteger((int)x$3))).get());
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, follower, consumerRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, follower, replicaRequest);
        this.assertResponseError(Errors.NONE, follower, debugReplicaRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, consumerRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, replicaRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, debugReplicaRequest);
    }

    @Test
    public void testListOffsetsMaxTimeStampOldestVersion() {
        ListOffsetsRequest.Builder consumerRequestBuilder = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false);
        ListOffsetsRequest.Builder maxTimestampRequestBuilder = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)true);
        Assertions.assertEquals((short)((short)0), (short)consumerRequestBuilder.oldestAllowedVersion());
        Assertions.assertEquals((short)((short)7), (short)maxTimestampRequestBuilder.oldestAllowedVersion());
    }

    public void assertResponseErrorForEpoch(Errors error, int brokerId, Optional<Integer> currentLeaderEpoch) {
        ListOffsetsRequestData.ListOffsetsPartition listOffsetPartition = new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(this.partition().partition()).setTimestamp(-2L);
        if (currentLeaderEpoch.isPresent()) {
            listOffsetPartition.setCurrentLeaderEpoch(Predef$.MODULE$.Integer2int(currentLeaderEpoch.get()));
        }
        java.util.List targetTimes = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(this.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)listOffsetPartition, (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava();
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false).setTargetTimes(targetTimes).build();
        this.assertResponseError(error, brokerId, request);
    }

    @Test
    public void testListOffsetsRequestDuringPartitionRecoveryAfterUncleanLeaderElection() {
        String topic = "topic";
        TopicPartition partition = new TopicPartition(topic, 0);
        Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 2, (Seq<KafkaBroker>)this.servers(), new Properties());
        Set replicas = this.zkClient().getReplicasForPartition(partition).toSet();
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition.partition())));
        int follower = BoxesRunTime.unboxToInt((Object)replicas.find((Function1)(JFunction1.mcZI.sp & Serializable)x$4 -> x$4 != leader).get());
        int nonReplica = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.servers().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)ListOffsetsRequestTest.$anonfun$testListOffsetsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$2(x$5)))).find((Function1)(JFunction1.mcZI.sp & Serializable)x$6 -> !replicas.contains((Object)BoxesRunTime.boxToInteger((int)x$6))).get());
        TestUtils$.MODULE$.forceOverrideLeaderRecoveryState(((KafkaServer)this.servers().find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTest.$anonfun$testListOffsetsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$5(leader, x$7))).get()).replicaManager().getPartitionOrException(partition), LeaderRecoveryState.RECOVERED);
        this.sendListOffsetsRequestAndValidateResponse$1(Errors.NONE, Errors.NONE, leader, topic, partition);
        this.sendListOffsetsRequestAndValidateResponse$1(Errors.NOT_LEADER_OR_FOLLOWER, Errors.NONE, follower, topic, partition);
        this.sendListOffsetsRequestAndValidateResponse$1(Errors.NOT_LEADER_OR_FOLLOWER, Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, topic, partition);
        TestUtils$.MODULE$.forceOverrideLeaderRecoveryState(((KafkaServer)this.servers().find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTest.$anonfun$testListOffsetsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$6(leader, x$8))).get()).replicaManager().getPartitionOrException(partition), LeaderRecoveryState.RECOVERING);
        this.sendListOffsetsRequestAndValidateResponse$1(Errors.NOT_LEADER_OR_FOLLOWER, Errors.NOT_LEADER_OR_FOLLOWER, leader, topic, partition);
        this.sendListOffsetsRequestAndValidateResponse$1(Errors.NOT_LEADER_OR_FOLLOWER, Errors.NONE, follower, topic, partition);
        this.sendListOffsetsRequestAndValidateResponse$1(Errors.NOT_LEADER_OR_FOLLOWER, Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, topic, partition);
        TestUtils$.MODULE$.forceOverrideLeaderRecoveryState(((KafkaServer)this.servers().find((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTest.$anonfun$testListOffsetsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$7(leader, x$9))).get()).replicaManager().getPartitionOrException(partition), LeaderRecoveryState.RECOVERED);
        this.sendListOffsetsRequestAndValidateResponse$1(Errors.NONE, Errors.NONE, leader, topic, partition);
        this.sendListOffsetsRequestAndValidateResponse$1(Errors.NOT_LEADER_OR_FOLLOWER, Errors.NONE, follower, topic, partition);
        this.sendListOffsetsRequestAndValidateResponse$1(Errors.NOT_LEADER_OR_FOLLOWER, Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, topic, partition);
    }

    @Test
    public void testCurrentEpochValidation() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(1, 3).apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange(this.servers(), topicPartition, firstLeaderId, 15000L);
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaBroker>)this.servers());
        this.assertResponseErrorForEpoch(Errors.NONE, secondLeaderId, Optional.empty());
        this.assertResponseErrorForEpoch(Errors.NONE, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)));
        this.assertResponseErrorForEpoch(Errors.FENCED_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)));
        this.assertResponseErrorForEpoch(Errors.UNKNOWN_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)));
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaBroker>)this.servers());
        this.assertResponseErrorForEpoch(Errors.NOT_LEADER_OR_FOLLOWER, followerId, Optional.empty());
        this.assertResponseErrorForEpoch(Errors.NOT_LEADER_OR_FOLLOWER, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)));
        this.assertResponseErrorForEpoch(Errors.UNKNOWN_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)));
        this.assertResponseErrorForEpoch(Errors.FENCED_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)));
    }

    private ListOffsetsResponseData.ListOffsetsPartitionResponse sendRequest(int serverId, long timestamp, short version) {
        java.util.List targetTimes = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(this.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(this.partition().partition()).setTimestamp(timestamp), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava();
        ListOffsetsRequest.Builder builder = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false).setTargetTimes(targetTimes);
        ListOffsetsRequest request = version == -1 ? (ListOffsetsRequest)builder.build() : builder.build(version);
        return (ListOffsetsResponseData.ListOffsetsPartitionResponse)CollectionConverters$.MODULE$.ListHasAsScala(((ListOffsetsResponseData.ListOffsetsTopicResponse)CollectionConverters$.MODULE$.ListHasAsScala(this.sendRequest(serverId, request).topics()).asScala().find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTest.$anonfun$sendRequest$1(this, x$10))).get()).partitions()).asScala().find((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTest.$anonfun$sendRequest$2(this, x$11))).get();
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<Object, Object> fetchOffsetAndEpoch(int serverId, long timestamp, short version) {
        void var8_6;
        void var6_5;
        Tuple3<Object, Object, Object> tuple3 = this.fetchOffsetAndEpochWithError(serverId, timestamp, version);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        long offset = BoxesRunTime.unboxToLong((Object)tuple3._1());
        int leaderEpoch = BoxesRunTime.unboxToInt((Object)tuple3._2());
        return new Tuple2.mcJI.sp((long)var6_5, (int)var8_6);
    }

    private Tuple3<Object, Object, Object> fetchOffsetAndEpochWithError(int serverId, long timestamp, short version) {
        ListOffsetsResponseData.ListOffsetsPartitionResponse partitionData = this.sendRequest(serverId, timestamp, version);
        if (version == 0) {
            if (partitionData.oldStyleOffsets().isEmpty()) {
                return new Tuple3((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToInteger((int)partitionData.leaderEpoch()), (Object)BoxesRunTime.boxToShort((short)partitionData.errorCode()));
            }
            return new Tuple3((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long((Long)CollectionConverters$.MODULE$.ListHasAsScala(partitionData.oldStyleOffsets()).asScala().head())), (Object)BoxesRunTime.boxToInteger((int)partitionData.leaderEpoch()), (Object)BoxesRunTime.boxToShort((short)partitionData.errorCode()));
        }
        return new Tuple3((Object)BoxesRunTime.boxToLong((long)partitionData.offset()), (Object)BoxesRunTime.boxToInteger((int)partitionData.leaderEpoch()), (Object)BoxesRunTime.boxToShort((short)partitionData.errorCode()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testResponseIncludesLeaderEpoch() {
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(1, 3).apply((Object)BoxesRunTime.boxToInteger((int)this.partition().partition())));
        TestUtils$.MODULE$.generateAndProduceMessages(this.servers(), this.topic(), 9, -1);
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "test-10", Predef$.MODULE$.long2Long(System.currentTimeMillis() + 10L), 30000, 20000);
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -4L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(9L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -3L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -10000L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -10001L, (short)-1));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange(this.servers(), this.partition(), firstLeaderId, 15000L);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ListOffsetsRequestTest.$anonfun$testResponseIncludesLeaderEpoch$1(this, secondLeaderId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"the second leader does not sync to follower");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, this.partition(), (Iterable<KafkaBroker>)this.servers());
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(secondLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(secondLeaderId, -4L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(secondLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(secondLeaderId, -2L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(secondLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(secondLeaderId, -2L, (short)-1));
        Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)10L), (Object)BoxesRunTime.boxToInteger((int)secondLeaderEpoch), (Object)BoxesRunTime.boxToShort((short)Errors.NONE.code())), this.fetchOffsetAndEpochWithError(secondLeaderId, -1L, (short)-1));
        Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)9L), (Object)BoxesRunTime.boxToInteger((int)secondLeaderEpoch), (Object)BoxesRunTime.boxToShort((short)Errors.NONE.code())), this.fetchOffsetAndEpochWithError(secondLeaderId, -3L, (short)-1));
    }

    @Test
    public void testResponseDefaultOffsetAndLeaderEpochForAllVersions() {
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(1, 3).apply((Object)BoxesRunTime.boxToInteger((int)this.partition().partition())));
        TestUtils$.MODULE$.generateAndProduceMessages(this.servers(), this.topic(), 9, -1);
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "test-10", Predef$.MODULE$.long2Long(System.currentTimeMillis() + 10L), 30000, 20000);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ApiKeys.LIST_OFFSETS.oldestVersion()), (int)ApiKeys.LIST_OFFSETS.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> {
            if (version == 0) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(-1L, -1), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -4L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                return;
            }
            if (version >= 1 && version <= 3) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -4L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                return;
            }
            if (version >= 4 && version <= 6) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -4L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                return;
            }
            if (version >= 7) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -4L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(9L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -3L, (short)version));
                return;
            }
        });
    }

    private void assertResponseError(Errors error, int brokerId, ListOffsetsRequest request) {
        ListOffsetsResponse response = this.sendRequest(brokerId, request);
        Assertions.assertEquals((int)request.topics().size(), (int)response.topics().size());
        CollectionConverters$.MODULE$.ListHasAsScala(response.topics()).asScala().foreach((Function1 & Serializable)topic -> {
            ListOffsetsRequestTest.$anonfun$assertResponseError$1(error, topic);
            return BoxedUnit.UNIT;
        });
    }

    private ListOffsetsResponse sendRequest(int leaderId, ListOffsetsRequest request) {
        return (ListOffsetsResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ListOffsetsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    public Map<Object, Object> createTopic(int numPartitions, int replicationFactor) {
        return TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), numPartitions, replicationFactor, (Seq<KafkaBroker>)this.servers(), new Properties());
    }

    public static final /* synthetic */ boolean $anonfun$testListOffsetsRequestForNonTieredPartition$1(AbstractLog log$1, int numMessages$1) {
        return log$1.logEndOffset() == (long)numMessages$1;
    }

    public static final /* synthetic */ String $anonfun$testListOffsetsRequestForNonTieredPartition$2() {
        return "Timeout waiting for all records to be produced";
    }

    public static final /* synthetic */ int $anonfun$testListOffsetsErrorCodes$2(KafkaServer x$2) {
        return x$2.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testListOffsetsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$2(KafkaServer x$5) {
        return x$5.config().brokerId();
    }

    private final void sendListOffsetsRequestAndValidateResponse$1(Errors error, Errors debugRequestError, int brokerId, String topic$1, TopicPartition partition$1) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ApiKeys.LIST_OFFSETS.oldestVersion()), (int)ApiKeys.LIST_OFFSETS.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)ver -> {
            int currentLeaderEpoch = ver >= 4 ? 0 : -1;
            java.util.List targetTimes = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(topic$1).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(partition$1.partition()).setTimestamp(-2L).setCurrentLeaderEpoch(currentLeaderEpoch), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava();
            ListOffsetsRequest consumerRequest = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false).setTargetTimes(targetTimes).build((short)ver);
            this.assertResponseError(error, brokerId, consumerRequest);
            ListOffsetsRequest replicaRequest = ListOffsetsRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)((KafkaServer)this.servers().head()).config().brokerId()).setTargetTimes(targetTimes).build((short)ver);
            this.assertResponseError(error, brokerId, replicaRequest);
            ListOffsetsRequest debugReplicaRequest = ListOffsetsRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)-2).setTargetTimes(targetTimes).build((short)ver);
            this.assertResponseError(debugRequestError, brokerId, debugReplicaRequest);
        });
    }

    public static final /* synthetic */ boolean $anonfun$testListOffsetsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$5(int leader$2, KafkaServer x$7) {
        return x$7.config().brokerId() == leader$2;
    }

    public static final /* synthetic */ boolean $anonfun$testListOffsetsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$6(int leader$2, KafkaServer x$8) {
        return x$8.config().brokerId() == leader$2;
    }

    public static final /* synthetic */ boolean $anonfun$testListOffsetsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$7(int leader$2, KafkaServer x$9) {
        return x$9.config().brokerId() == leader$2;
    }

    public static final /* synthetic */ boolean $anonfun$sendRequest$1(ListOffsetsRequestTest $this, ListOffsetsResponseData.ListOffsetsTopicResponse x$10) {
        String string = x$10.name();
        String string2 = $this.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$sendRequest$2(ListOffsetsRequestTest $this, ListOffsetsResponseData.ListOffsetsPartitionResponse x$11) {
        return x$11.partitionIndex() == $this.partition().partition();
    }

    public static final /* synthetic */ boolean $anonfun$testResponseIncludesLeaderEpoch$1(ListOffsetsRequestTest $this, int secondLeaderId$1) {
        return $this.sendRequest(secondLeaderId$1, -1L, (short)-1).errorCode() != Errors.OFFSET_NOT_AVAILABLE.code();
    }

    public static final /* synthetic */ String $anonfun$testResponseIncludesLeaderEpoch$2() {
        return "the second leader does not sync to follower";
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$2(Errors error$2, ListOffsetsResponseData.ListOffsetsPartitionResponse partition) {
        Assertions.assertEquals((short)error$2.code(), (short)partition.errorCode());
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$1(Errors error$2, ListOffsetsResponseData.ListOffsetsTopicResponse topic) {
        CollectionConverters$.MODULE$.ListHasAsScala(topic.partitions()).asScala().foreach((Function1 & Serializable)partition -> {
            ListOffsetsRequestTest.$anonfun$assertResponseError$2(error$2, partition);
            return BoxedUnit.UNIT;
        });
    }

    public ListOffsetsRequestTest() {
        this.topic = "topic";
    }
}

