/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005a4AAB\u0004\u0001\u0019!)\u0011\u0003\u0001C\u0001%!)A\u0003\u0001C!+!)a\u0005\u0001C\u0001O!)!\u000b\u0001C\u0001'\")\u0001\f\u0001C\u00013\n)C*[:u\u001f\u001a47/\u001a;t%\u0016\fX/Z:u)&,'/\u001a3QCJ$\u0018\u000e^5p]R+7\u000f\u001e\u0006\u0003\u0011%\taa]3sm\u0016\u0014(\"\u0001\u0006\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0004\t\u0003\u001d=i\u0011aB\u0005\u0003!\u001d\u0011qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0001\"A\u0004\u0001\u0002/\t\u0014xn[3s!J|\u0007/\u001a:us>3XM\u001d:jI\u0016\u001cHC\u0001\f\u001d!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u0011)f.\u001b;\t\u000bu\u0011\u0001\u0019\u0001\u0010\u0002\u0015A\u0014x\u000e]3si&,7\u000f\u0005\u0002 I5\t\u0001E\u0003\u0002\"E\u0005!Q\u000f^5m\u0015\u0005\u0019\u0013\u0001\u00026bm\u0006L!!\n\u0011\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\u0015uKN$H*[:u\u001f\u001a47/\u001a;t%\u0016\fX/Z:u\r>\u0014H+[3sK\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0002\u0017Q!)\u0011f\u0001a\u0001U\u00051\u0011/^8sk6\u0004\"a\u000b\u001a\u000f\u00051\u0002\u0004CA\u0017\u0019\u001b\u0005q#BA\u0018\f\u0003\u0019a$o\\8u}%\u0011\u0011\u0007G\u0001\u0007!J,G-\u001a4\n\u0005M\"$AB*ue&twM\u0003\u000221!\"1A\u000e\"D!\t9\u0004)D\u00019\u0015\tI$(\u0001\u0004qCJ\fWn\u001d\u0006\u0003wq\nqA[;qSR,'O\u0003\u0002>}\u0005)!.\u001e8ji*\tq(A\u0002pe\u001eL!!\u0011\u001d\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017%\u0001#\u0002Em$\u0017n\u001d9mCft\u0015-\\3~]m\f'oZ;nK:$8oV5uQ:\u000bW.Z:~Q\u0011\u0019a\tT'\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%C\u0014\u0001\u00039s_ZLG-\u001a:\n\u0005-C%a\u0003,bYV,7k\\;sG\u0016\fqa\u001d;sS:<7\u000f\f\u0002O!\u0006\nq*\u0001\u0002{W\u0006\n\u0011+A\u0003le\u00064G/A\u0015uKN$H*[:u\u001f\u001a4Wm\u001d;t%\u0016\fX/Z:u%\u0016$XO\u001d8t%\u0016\u001cHo\u001c:f!>Lg\u000e\u001e\u000b\u0003-QCQ!\u000b\u0003A\u0002)BC\u0001\u0002\u001cC\u0007\"\"AA\u0012'XY\tq\u0005+\u0001\fgKR\u001c\u0007n\u00144gg\u0016$8OR8s%\u0016\u0004H.[2b)\u0019QVM\u001b7ogB\u00111lY\u0007\u00029*\u0011QLX\u0001\te\u0016\fX/Z:ug*\u0011q\fY\u0001\u0007G>lWn\u001c8\u000b\u0005)\t'B\u00012?\u0003\u0019\t\u0007/Y2iK&\u0011A\r\u0018\u0002\u0014\u0019&\u001cHo\u00144gg\u0016$8OU3ta>t7/\u001a\u0005\u0006M\u0016\u0001\raZ\u0001\tEJ|7.\u001a:JIB\u0011q\u0003[\u0005\u0003Sb\u00111!\u00138u\u0011\u0015YW\u00011\u0001+\u0003%!x\u000e]5d\u001d\u0006lW\rC\u0003n\u000b\u0001\u0007q-A\u0005qCJ$\u0018\u000e^5p]\")q.\u0002a\u0001a\u0006IA/[7fgR\fW\u000e\u001d\t\u0003/EL!A\u001d\r\u0003\t1{gn\u001a\u0005\u0006i\u0016\u0001\r!^\u0001\bm\u0016\u00148/[8o!\t9b/\u0003\u0002x1\t)1\u000b[8si\u0002")
public class ListOffsetsRequestTieredPartitionTest
extends BaseRequestTest {
    @Override
    public void brokerPropertyOverrides(Properties properties) {
        this.serverConfig().stringPropertyNames().forEach(key -> properties.put(key, this.serverConfig().get(key)));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testListOffsetsRequestForTieredPartition(String quorum) {
        String topicName = "tiered-topic";
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "16384");
        props.put("confluent.tier.local.hotset.bytes", "16384");
        props.put("confluent.tier.local.hotset.ms", "-1");
        props.put("retention.bytes", "-1");
        TopicPartition topicPartition = new TopicPartition(topicName, 0);
        Map<Object, Object> partitionToLeaderMap = this.createTopic(topicName, 1, 1, props, this.createTopic$default$5(), this.createTopic$default$6());
        this.waitUntilLogCreatedOnBrokers(topicPartition);
        int numMessages = 3000;
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), topicName, numMessages, -1);
        int leaderId = BoxesRunTime.unboxToInt((Object)partitionToLeaderMap.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        LogManager qual$1 = this.brokerWithId(leaderId).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$1.getLog(topicPartition, x$2).get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 180000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ListOffsetsRequestTieredPartitionTest.$anonfun$testListOffsetsRequestForTieredPartition$1(log, numMessages)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timeout waiting for some segments to tier and be deleted from local disk");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.makeListOffsetsRequestAndValidateResponse(topicPartition, -1L, leaderId, log, (short)0);
        log.maybeIncrementHighWatermark(new LogOffsetMetadata(log.logStartOffset() + 100L));
        log.maybeIncrementLogStartOffset(log.logStartOffset() + 100L, LogStartOffsetIncrementReason.SegmentDeletion);
        this.makeListOffsetsRequestAndValidateResponse(topicPartition, -1L, leaderId, log, (short)0);
        this.makeListOffsetsRequestAndValidateResponse(topicPartition, -2L, leaderId, log, (short)0);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testListOffestsRequestReturnsRestorePoint(String quorum) {
        String topicName = "test-topic";
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "16384");
        props.put("confluent.tier.local.hotset.bytes", "1");
        props.put("confluent.tier.local.hotset.ms", "1");
        props.put("retention.bytes", "-1");
        TopicPartition topicPartition = new TopicPartition(topicName, 0);
        Map<Object, Object> partitionToLeaderMap = this.createTopic(topicName, 1, 1, props, this.createTopic$default$5(), this.createTopic$default$6());
        this.waitUntilLogCreatedOnBrokers(topicPartition);
        int numMessages = 3000;
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), topicName, numMessages, -1);
        int leaderId = BoxesRunTime.unboxToInt((Object)partitionToLeaderMap.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 180000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ListOffsetsRequestTieredPartitionTest.$anonfun$testListOffestsRequestReturnsRestorePoint$1(this, numMessages, leaderId, topicPartition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timeout waiting for the HWM to advance");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 180000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ListOffsetsRequestTieredPartitionTest.$anonfun$testListOffestsRequestReturnsRestorePoint$3(this, leaderId, topicPartition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Timeout waiting for all segments to tier");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 180000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!ListOffsetsRequestTieredPartitionTest.$anonfun$testListOffestsRequestReturnsRestorePoint$7(this, leaderId, topicPartition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Timeout waiting for all tiered segments to be deleted from the local log");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        ListOffsetsResponse latestVersionResponse = this.fetchOffsetsForReplica(leaderId, topicName, 0, -10000L, ApiKeys.LIST_OFFSETS.latestVersion());
        ListOffsetsResponseData.ListOffsetsPartitionResponse partitionResponse = (ListOffsetsResponseData.ListOffsetsPartitionResponse)CollectionConverters$.MODULE$.ListHasAsScala(((ListOffsetsResponseData.ListOffsetsTopicResponse)CollectionConverters$.MODULE$.ListHasAsScala(latestVersionResponse.topics()).asScala().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTieredPartitionTest.$anonfun$testListOffestsRequestReturnsRestorePoint$9(topicName, x$2))).get()).partitions()).asScala().find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTieredPartitionTest.$anonfun$testListOffestsRequestReturnsRestorePoint$10(x$3))).get();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionResponse.errorCode());
        Assertions.assertEquals((long)this.leaderLog$1(leaderId, topicPartition).activeSegment().baseOffset(), (long)partitionResponse.offset());
        Assertions.assertEquals((Object)CoreUtils$.MODULE$.toKafkaUUID((UUID)this.leaderLog$1(leaderId, topicPartition).tieredLogSegments().toList().lastOption().map((Function1 & Serializable)x$4 -> x$4.metadata().objectId()).get()), (Object)partitionResponse.followerRestorePointObjectId());
        Assertions.assertEquals((int)-1, (int)partitionResponse.followerRestorePointEpoch());
        ListOffsetsResponse oldStyleResponse = this.fetchOffsetsForReplica(leaderId, topicName, 0, -10000L, (short)5);
        ListOffsetsResponseData.ListOffsetsPartitionResponse oldStylePartitionResponse = (ListOffsetsResponseData.ListOffsetsPartitionResponse)CollectionConverters$.MODULE$.ListHasAsScala(((ListOffsetsResponseData.ListOffsetsTopicResponse)CollectionConverters$.MODULE$.ListHasAsScala(oldStyleResponse.topics()).asScala().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTieredPartitionTest.$anonfun$testListOffestsRequestReturnsRestorePoint$12(topicName, x$5))).get()).partitions()).asScala().find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTieredPartitionTest.$anonfun$testListOffestsRequestReturnsRestorePoint$13(x$6))).get();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)oldStylePartitionResponse.errorCode());
        Assertions.assertEquals((long)this.leaderLog$1(leaderId, topicPartition).activeSegment().baseOffset(), (long)oldStylePartitionResponse.offset());
        Assertions.assertEquals((Object)Uuid.ZERO_UUID, (Object)oldStylePartitionResponse.followerRestorePointObjectId());
    }

    public ListOffsetsResponse fetchOffsetsForReplica(int brokerId, String topicName, int partition, long timestamp, short version) {
        ListOffsetsRequestData.ListOffsetsPartition partitionRequest = new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(partition).setTimestamp(timestamp).setCurrentLeaderEpoch(0);
        ListOffsetsRequestData.ListOffsetsTopic topicRequest = new ListOffsetsRequestData.ListOffsetsTopic().setName(topicName).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)partitionRequest, (List)Nil$.MODULE$)).asJava());
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)version, (int)brokerId).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicRequest, (List)Nil$.MODULE$)).asJava()).build();
        return (ListOffsetsResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(brokerId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ListOffsetsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    public static final /* synthetic */ boolean $anonfun$testListOffsetsRequestForTieredPartition$1(AbstractLog log$1, int numMessages$1) {
        return log$1.logEndOffset() == (long)numMessages$1 && log$1.tieredLogSegments().nonEmpty() && log$1.localLogSegments().size() < log$1.numberOfSegments();
    }

    public static final /* synthetic */ String $anonfun$testListOffsetsRequestForTieredPartition$2() {
        return "Timeout waiting for some segments to tier and be deleted from local disk";
    }

    private final AbstractLog leaderLog$1(int leaderId$1, TopicPartition topicPartition$1) {
        LogManager qual$1 = this.brokerWithId(leaderId$1).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        return (AbstractLog)qual$1.getLog(topicPartition$1, x$2).get();
    }

    public static final /* synthetic */ boolean $anonfun$testListOffestsRequestReturnsRestorePoint$1(ListOffsetsRequestTieredPartitionTest $this, int numMessages$2, int leaderId$1, TopicPartition topicPartition$1) {
        return $this.leaderLog$1(leaderId$1, topicPartition$1).highWatermark() >= (long)numMessages$2;
    }

    public static final /* synthetic */ String $anonfun$testListOffestsRequestReturnsRestorePoint$2() {
        return "Timeout waiting for the HWM to advance";
    }

    public static final /* synthetic */ boolean $anonfun$testListOffestsRequestReturnsRestorePoint$3(ListOffsetsRequestTieredPartitionTest $this, int leaderId$1, TopicPartition topicPartition$1) {
        long activeSegmentBaseOffset = $this.leaderLog$1(leaderId$1, topicPartition$1).activeSegment().baseOffset();
        return BoxesRunTime.equals((Object)$this.leaderLog$1(leaderId$1, topicPartition$1).tieredLogSegments().toList().lastOption().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.nextOffset())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0), (Object)BoxesRunTime.boxToLong((long)activeSegmentBaseOffset));
    }

    public static final /* synthetic */ String $anonfun$testListOffestsRequestReturnsRestorePoint$6() {
        return "Timeout waiting for all segments to tier";
    }

    public static final /* synthetic */ boolean $anonfun$testListOffestsRequestReturnsRestorePoint$7(ListOffsetsRequestTieredPartitionTest $this, int leaderId$1, TopicPartition topicPartition$1) {
        $this.leaderLog$1(leaderId$1, topicPartition$1).deleteOldSegments(Integer.MAX_VALUE);
        return $this.leaderLog$1(leaderId$1, topicPartition$1).localLogStartOffset() == $this.leaderLog$1(leaderId$1, topicPartition$1).activeSegment().baseOffset();
    }

    public static final /* synthetic */ String $anonfun$testListOffestsRequestReturnsRestorePoint$8() {
        return "Timeout waiting for all tiered segments to be deleted from the local log";
    }

    public static final /* synthetic */ boolean $anonfun$testListOffestsRequestReturnsRestorePoint$9(String topicName$1, ListOffsetsResponseData.ListOffsetsTopicResponse x$2) {
        String string = x$2.name();
        return !(string != null ? !string.equals(topicName$1) : topicName$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testListOffestsRequestReturnsRestorePoint$10(ListOffsetsResponseData.ListOffsetsPartitionResponse x$3) {
        return x$3.partitionIndex() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testListOffestsRequestReturnsRestorePoint$12(String topicName$1, ListOffsetsResponseData.ListOffsetsTopicResponse x$5) {
        String string = x$5.name();
        return !(string != null ? !string.equals(topicName$1) : topicName$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testListOffestsRequestReturnsRestorePoint$13(ListOffsetsResponseData.ListOffsetsPartitionResponse x$6) {
        return x$6.partitionIndex() == 0;
    }

    public ListOffsetsRequestTieredPartitionTest() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierEnableProp(), "false");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), "mybucket");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "5");
    }
}

