/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.LogManager;
import kafka.log.MergedLog;
import kafka.log.TierLogComponents$;
import kafka.server.ActionQueue;
import kafka.server.AlterPartitionManager;
import kafka.server.BrokerFeatures;
import kafka.server.BrokerFeatures$;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedActionQueue;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LeaderEndPoint;
import kafka.server.LocalLeaderEndPoint;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaQuota;
import kafka.server.TierReplicaComponents;
import kafka.server.TierReplicaComponents$;
import kafka.server.checkpoints.LazyOffsetCheckpoints;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.DirectoryEventHandler;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tud\u0001\u0002\u0017.\u0001IBQa\u0010\u0001\u0005\u0002\u0001Cqa\u0011\u0001C\u0002\u0013\u0005A\t\u0003\u0004R\u0001\u0001\u0006I!\u0012\u0005\b%\u0002\u0011\r\u0011\"\u0001T\u0011\u0019Q\u0006\u0001)A\u0005)\"91\f\u0001b\u0001\n\u0003a\u0006BB3\u0001A\u0003%Q\fC\u0004g\u0001\t\u0007I\u0011A4\t\r-\u0004\u0001\u0015!\u0003i\u0011\u001da\u0007A1A\u0005\u00025Da\u0001\u001e\u0001!\u0002\u0013q\u0007\"C;\u0001\u0001\u0004\u0005\r\u0011\"\u0001w\u0011%Q\b\u00011AA\u0002\u0013\u00051\u0010\u0003\u0006\u0002\u0004\u0001\u0001\r\u0011!Q!\n]D1\"!\u0002\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\b!Y\u0011q\u0002\u0001A\u0002\u0003\u0007I\u0011AA\t\u0011-\t)\u0002\u0001a\u0001\u0002\u0003\u0006K!!\u0003\t\u0017\u0005]\u0001\u00011AA\u0002\u0013\u0005\u0011\u0011\u0004\u0005\f\u0003o\u0001\u0001\u0019!a\u0001\n\u0003\tI\u0004C\u0006\u0002>\u0001\u0001\r\u0011!Q!\n\u0005m\u0001bBA \u0001\u0011\u0005\u0011\u0011\t\u0005\b\u00033\u0002A\u0011AA!\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003\u0003Bq!!\u001c\u0001\t\u0003\t\t\u0005C\u0004\u0002r\u0001!\t!!\u0011\t\u000f\u0005U\u0004\u0001\"\u0001\u0002B\u00191\u0011\u0011\u0010\u0001\u0005\u0003wBaaP\u000e\u0005\u0002\u0005}\u0004\"CAN7\u0001\u0007I\u0011BAO\u0011%\t)k\u0007a\u0001\n\u0013\t9\u000b\u0003\u0005\u0002,n\u0001\u000b\u0015BAP\u0011%\tik\u0007a\u0001\n\u0013\ty\u000bC\u0005\u0002:n\u0001\r\u0011\"\u0003\u0002<\"A\u0011qX\u000e!B\u0013\t\t\fC\u0004\u0002Bn!\t!a1\t\u000f\u0005-7\u0004\"\u0001\u0002N\"9\u0011\u0011[\u000e\u0005\u0002\u0005M\u0007bBAl\u0001\u0011%\u0011\u0011\u001c\u0005\b\u0003c\u0004A\u0011BAz\u0011%\u0011\t\u0006AI\u0001\n\u0013\u0011\u0019\u0006C\u0005\u0003j\u0001\t\n\u0011\"\u0003\u0003l!9!q\u000e\u0001\u0005\n\tE\u0004b\u0002B\u0011\u0001\u0011%!1\u0010\u0002\u0018\u0019>\u001c\u0017\r\u001c'fC\u0012,'/\u00128e!>Lg\u000e\u001e+fgRT!AL\u0018\u0002\rM,'O^3s\u0015\u0005\u0001\u0014!B6bM.\f7\u0001A\n\u0004\u0001MJ\u0004C\u0001\u001b8\u001b\u0005)$\"\u0001\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005a*$AB!osJ+g\r\u0005\u0002;{5\t1H\u0003\u0002=_\u0005)Q\u000f^5mg&\u0011ah\u000f\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t\u0011\t\u0005\u0002C\u00015\tQ&\u0001\u0003uS6,W#A#\u0011\u0005\u0019{U\"A$\u000b\u0005!K\u0015\u0001B;uS2T!A\f&\u000b\u0005AZ%B\u0001'N\u0003\u0019\t\u0007/Y2iK*\ta*A\u0002pe\u001eL!\u0001U$\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\nq\u0001^8qS\u000eLE-F\u0001U!\t)\u0006,D\u0001W\u0015\t9&*\u0001\u0004d_6lwN\\\u0005\u00033Z\u0013A!V;jI\u0006AAo\u001c9jG&#\u0007%A\u0003u_BL7-F\u0001^!\tq6-D\u0001`\u0015\t\u0001\u0017-\u0001\u0003mC:<'\"\u00012\u0002\t)\fg/Y\u0005\u0003I~\u0013aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0003!\u0004\"!V5\n\u0005)4&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA\u0005a1o\\;sG\u0016\u0014%o\\6feV\ta\u000e\u0005\u0002pe6\t\u0001O\u0003\u0002r_\u000591\r\\;ti\u0016\u0014\u0018BA:q\u00059\u0011%o\\6fe\u0016sG\rU8j]R\fQb]8ve\u000e,'I]8lKJ\u0004\u0013A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0002oB\u0011!\t_\u0005\u0003s6\u0012aBU3qY&\u001c\u0017-T1oC\u001e,'/\u0001\nsKBd\u0017nY1NC:\fw-\u001a:`I\u0015\fHC\u0001?\u0000!\t!T0\u0003\u0002\u007fk\t!QK\\5u\u0011!\t\t!DA\u0001\u0002\u00049\u0018a\u0001=%c\u0005y!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b%\u0001\u0005f]\u0012\u0004v.\u001b8u+\t\tI\u0001E\u0002C\u0003\u0017I1!!\u0004.\u00059aU-\u00193fe\u0016sG\rU8j]R\fA\"\u001a8e!>Lg\u000e^0%KF$2\u0001`A\n\u0011%\t\t\u0001EA\u0001\u0002\u0004\tI!A\u0005f]\u0012\u0004v.\u001b8uA\u0005a\u0011/^8uC6\u000bg.Y4feV\u0011\u00111\u0004\t\u0005\u0003;\t\tD\u0004\u0003\u0002 \u00055b\u0002BA\u0011\u0003WqA!a\t\u0002*5\u0011\u0011Q\u0005\u0006\u0004\u0003O\t\u0014A\u0002\u001fs_>$h(C\u00011\u0013\tqs&C\u0002\u000205\nA\"U;pi\u00064\u0015m\u0019;pefLA!a\r\u00026\ti\u0011+^8uC6\u000bg.Y4feNT1!a\f.\u0003A\tXo\u001c;b\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000fF\u0002}\u0003wA\u0011\"!\u0001\u0014\u0003\u0003\u0005\r!a\u0007\u0002\u001bE,x\u000e^1NC:\fw-\u001a:!\u0003\u0015\u0019X\r^+q)\u0005a\bfA\u000b\u0002FA!\u0011qIA+\u001b\t\tIE\u0003\u0003\u0002L\u00055\u0013aA1qS*!\u0011qJA)\u0003\u001dQW\u000f]5uKJT1!a\u0015N\u0003\u0015QWO\\5u\u0013\u0011\t9&!\u0013\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\r1\u0012Q\f\t\u0005\u0003\u000f\ny&\u0003\u0003\u0002b\u0005%#!C!gi\u0016\u0014X)Y2i\u0003U!Xm\u001d;GKR\u001c\u0007\u000eT1uKN$xJ\u001a4tKRD3aFA4!\u0011\t9%!\u001b\n\t\u0005-\u0014\u0011\n\u0002\u0005)\u0016\u001cH/A\fuKN$h)\u001a;dQ\u0016\u000b'\u000f\\5fgR|eMZ:fi\"\u001a\u0001$a\u001a\u0002=Q,7\u000f\u001e$fi\u000eDW*\u0019;fe&\fG.\u001b>bi&|g\u000eV1sO\u0016$\bfA\r\u0002h\u0005AB/Z:u\r\u0016$8\r[#q_\u000eDWI\u001c3PM\u001a\u001cX\r^:)\u0007i\t9G\u0001\bDC2d'-Y2l%\u0016\u001cX\u000f\u001c;\u0016\t\u0005u\u0014\u0011R\n\u00037M\"\"!!!\u0011\u000b\u0005\r5$!\"\u000e\u0003\u0001\u0001B!a\"\u0002\n2\u0001AaBAF7\t\u0007\u0011Q\u0012\u0002\u0002)F!\u0011qRAK!\r!\u0014\u0011S\u0005\u0004\u0003'+$a\u0002(pi\"Lgn\u001a\t\u0004i\u0005]\u0015bAAMk\t\u0019\u0011I\\=\u0002\u000bY\fG.^3\u0016\u0005\u0005}\u0005#\u0002\u001b\u0002\"\u0006\u0015\u0015bAARk\t1q\n\u001d;j_:\f\u0011B^1mk\u0016|F%Z9\u0015\u0007q\fI\u000bC\u0005\u0002\u0002y\t\t\u00111\u0001\u0002 \u00061a/\u00197vK\u0002\n1AZ;o+\t\t\t\fE\u00035\u0003C\u000b\u0019\f\u0005\u00045\u0003k\u000b)\t`\u0005\u0004\u0003o+$!\u0003$v]\u000e$\u0018n\u001c82\u0003\u001d1WO\\0%KF$2\u0001`A_\u0011%\t\t!IA\u0001\u0002\u0004\t\t,\u0001\u0003gk:\u0004\u0013\u0001\u00035bg\u001aK'/\u001a3\u0016\u0005\u0005\u0015\u0007c\u0001\u001b\u0002H&\u0019\u0011\u0011Z\u001b\u0003\u000f\t{w\u000e\\3b]\u0006!a-\u001b:f)\ra\u0018q\u001a\u0005\b\u00037#\u0003\u0019AAC\u0003\u0019ygNR5sKR!\u0011\u0011QAk\u0011\u001d\ti+\na\u0001\u0003g\u000b\u0001DY;jY\u0012dU-\u00193fe\u0006sG-S:s%\u0016\fX/Z:u)\u0011\tY.a:\u0011\t\u0005u\u00171]\u0007\u0003\u0003?T1!!9W\u0003!\u0011X-];fgR\u001c\u0018\u0002BAs\u0003?\u00141\u0003T3bI\u0016\u0014\u0018I\u001c3JgJ\u0014V-];fgRDq!!;'\u0001\u0004\tY/A\u0006mK\u0006$WM]#q_\u000eD\u0007c\u0001\u001b\u0002n&\u0019\u0011q^\u001b\u0003\u0007%sG/A\u0007baB,g\u000e\u001a*fG>\u0014Hm\u001d\u000b\r\u0003k\u0014IBa\u0007\u0003 \t=\"q\t\t\u0006\u0003\u0007[\u0012q\u001f\t\u0005\u0003s\u0014\u0019B\u0004\u0003\u0002|\n=a\u0002BA\u007f\u0005\u001bqA!a@\u0003\f9!!\u0011\u0001B\u0005\u001d\u0011\u0011\u0019Aa\u0002\u000f\t\u0005\r\"QA\u0005\u0002\u001d&\u0011A*T\u0005\u0003a-K!a\u0016&\n\u0007\u0005\u0005h+\u0003\u0003\u0003\u0012\u0005}\u0017a\u0004)s_\u0012,8-\u001a*fgB|gn]3\n\t\tU!q\u0003\u0002\u0012!\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9p]N,'\u0002\u0002B\t\u0003?DQ!^\u0014A\u0002]DaA!\b(\u0001\u0004A\u0017!\u00039beRLG/[8o\u0011\u001d\u0011\tc\na\u0001\u0005G\tqA]3d_J$7\u000f\u0005\u0003\u0003&\t-RB\u0001B\u0014\u0015\r\u0011ICV\u0001\u0007e\u0016\u001cwN\u001d3\n\t\t5\"q\u0005\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\u0013\tEr\u0005%AA\u0002\tM\u0012AB8sS\u001eLg\u000e\u0005\u0003\u00036\t\rSB\u0001B\u001c\u0015\u0011\u0011IDa\u000f\u0002\u00071|wM\u0003\u0003\u0003>\t}\u0012!C5oi\u0016\u0014h.\u00197t\u0015\r\u0011\tES\u0001\bgR|'/Y4f\u0013\u0011\u0011)Ea\u000e\u0003\u0019\u0005\u0003\b/\u001a8e\u001fJLw-\u001b8\t\u0013\t%s\u0005%AA\u0002\t-\u0013\u0001\u0004:fcVL'/\u001a3BG.\u001c\bc\u0001\u001b\u0003N%\u0019!qJ\u001b\u0003\u000bMCwN\u001d;\u0002/\u0005\u0004\b/\u001a8e%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\"TC\u0001B+U\u0011\u0011\u0019Da\u0016,\u0005\te\u0003\u0003\u0002B.\u0005Kj!A!\u0018\u000b\t\t}#\u0011M\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u00196\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005O\u0012iFA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fq#\u00199qK:$'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\t5$\u0006\u0002B&\u0005/\nAA\\8eKR!!1\u000fB=!\r)&QO\u0005\u0004\u0005o2&\u0001\u0002(pI\u0016Da!!\u0002+\u0001\u0004qWC\u0001B\u0012\u0001")
public class LocalLeaderEndPointTest
implements Logging {
    private final MockTime time = new MockTime();
    private final Uuid topicId = Uuid.randomUuid();
    private final String topic;
    private final TopicPartition topicPartition = new TopicPartition(this.topic(), 5);
    private final BrokerEndPoint sourceBroker = new BrokerEndPoint(0, "localhost", 9092);
    private ReplicaManager replicaManager;
    private LeaderEndPoint endPoint;
    private QuotaFactory.QuotaManagers quotaManager;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public MockTime time() {
        return this.time;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public String topic() {
        return this.topic;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public BrokerEndPoint sourceBroker() {
        return this.sourceBroker;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public LeaderEndPoint endPoint() {
        return this.endPoint;
    }

    public void endPoint_$eq(LeaderEndPoint x$1) {
        this.endPoint = x$1;
    }

    public QuotaFactory.QuotaManagers quotaManager() {
        return this.quotaManager;
    }

    public void quotaManager_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManager = x$1;
    }

    /*
     * WARNING - void declaration
     */
    @BeforeEach
    public void setUp() {
        void zkMetadataCache_zkMigrationEnabled;
        void zkMetadataCache_isMultiTenant;
        void zkMetadataCache_kraftControllerNodes;
        void zkMetadataCache_brokerFeatures;
        void zkMetadataCache_metadataVersion;
        int x$1 = this.sourceBroker().id();
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = this.sourceBroker().port();
        boolean x$42 = true;
        boolean x$52 = true;
        None$ x$62 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var56_11 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var57_14 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var58_17 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$42, x$52, x$3, (Option<SecurityProtocol>)x$62, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable)x$4 -> new File((String)x$4))), TestUtils$.MODULE$.createLogManager$default$2(), new MockConfigRepository(), new CleanerConfig(false), TestUtils$.MODULE$.defaultMockTime(), new Metrics(), null, MetadataVersion.latestTesting(), false, TierLogComponents$.MODULE$.EMPTY(), 4, false, (Option<MergedLog>)None$.MODULE$, TestUtils$.MODULE$.createLogManager$default$14(), false);
        AlterPartitionManager alterPartitionManager = (AlterPartitionManager)Mockito.mock(AlterPartitionManager.class);
        Metrics metrics = new Metrics();
        this.quotaManager_$eq(QuotaFactory$.MODULE$.instantiate(config, metrics, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$));
        MockTime x$24 = this.time();
        MockScheduler x$25 = new MockScheduler((Time)this.time());
        QuotaFactory.QuotaManagers x$27 = this.quotaManager();
        boolean bl = false;
        boolean bl2 = false;
        Seq seq = (Seq)Seq$.MODULE$.empty();
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createEmpty();
        MetadataVersion metadataVersion = config.interBrokerProtocolVersion();
        int zkMetadataCache_brokerId = config.brokerId();
        metadataVersion = null;
        brokerFeatures = null;
        seq = null;
        ZkMetadataCache x$28 = new ZkMetadataCache(zkMetadataCache_brokerId, (MetadataVersion)zkMetadataCache_metadataVersion, (BrokerFeatures)zkMetadataCache_brokerFeatures, (Seq)zkMetadataCache_kraftControllerNodes, (boolean)zkMetadataCache_isMultiTenant, (boolean)zkMetadataCache_zkMigrationEnabled);
        LogDirFailureChannel x$29 = new LogDirFailureChannel(config.logDirs().size());
        DelayedActionQueue x$31 = new DelayedActionQueue();
        BrokerTopicStats x$32 = new BrokerTopicStats();
        Function0 x$33 = ReplicaManager$.MODULE$.$lessinit$greater$default$12();
        None$ x$34 = None$.MODULE$;
        None$ x$35 = None$.MODULE$;
        None$ x$36 = None$.MODULE$;
        None$ x$37 = None$.MODULE$;
        None$ x$38 = None$.MODULE$;
        None$ x$39 = None$.MODULE$;
        TierReplicaComponents x$40 = TierReplicaComponents$.MODULE$.EMPTY();
        None$ x$41 = None$.MODULE$;
        None$ x$422 = None$.MODULE$;
        None$ x$43 = None$.MODULE$;
        Function0 x$44 = ReplicaManager$.MODULE$.$lessinit$greater$default$23();
        None$ x$45 = None$.MODULE$;
        DirectoryEventHandler x$46 = DirectoryEventHandler.NOOP;
        this.replicaManager_$eq(new ReplicaManager(config, metrics, (Time)x$24, (Scheduler)x$25, mockLogMgr, x$27, (MetadataCache)x$28, x$29, alterPartitionManager, (ActionQueue)x$31, x$32, x$33, (Option)x$34, (Option)x$35, (Option)x$36, (Option)x$37, (Option)x$38, (Option)x$39, x$40, (Option)x$41, (Option)x$422, (Option)x$43, x$44, (Option)x$45, x$46));
        Partition partition = this.replicaManager().createPartition(this.topicPartition());
        partition.createLogIfNotExists(false, false, (OffsetCheckpoints)new LazyOffsetCheckpoints(this.replicaManager().highWatermarkCheckpoints()), (Option)None$.MODULE$, partition.createLogIfNotExists$default$5());
        LeaderAndIsrRequest leaderAndIsrRequest = this.buildLeaderAndIsrRequest(0);
        this.replicaManager().becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2 & Serializable)(x$5, x$6) -> {
            LocalLeaderEndPointTest.$anonfun$setUp$2(x$5, x$6);
            return BoxedUnit.UNIT;
        });
        this.replicaManager().getPartitionOrException(this.topicPartition()).localLogOrException();
        this.endPoint_$eq((LeaderEndPoint)new LocalLeaderEndPoint(this.sourceBroker(), config, this.replicaManager(), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$));
    }

    @AfterEach
    public void tearDown() {
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> this.replicaManager().shutdown(false), (Logging)this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> this.quotaManager().shutdown(), (Logging)this, Level.WARN);
    }

    @Test
    public void testFetchLatestOffset() {
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchLatestOffset$1(response);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(3L, 0), (Object)this.endPoint().fetchLatestOffset(this.topicPartition(), 0));
        LeaderAndIsrRequest leaderAndIsrRequest = this.buildLeaderAndIsrRequest(4);
        this.replicaManager().becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2 & Serializable)(x$7, x$8) -> {
            LocalLeaderEndPointTest.$anonfun$testFetchLatestOffset$2(x$7, x$8);
            return BoxedUnit.UNIT;
        });
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchLatestOffset$3(response);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(6L, 4), (Object)this.endPoint().fetchLatestOffset(this.topicPartition(), 7));
    }

    @Test
    public void testFetchEarliestOffset() {
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestOffset$1(response);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(0L, 0), (Object)this.endPoint().fetchEarliestOffset(this.topicPartition(), 0));
        LeaderAndIsrRequest leaderAndIsrRequest = this.buildLeaderAndIsrRequest(4);
        this.replicaManager().becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2 & Serializable)(x$9, x$10) -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestOffset$2(x$9, x$10);
            return BoxedUnit.UNIT;
        });
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestOffset$3(response);
            return BoxedUnit.UNIT;
        });
        this.replicaManager().deleteRecords(1000L, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)3L))})), (Function1 & Serializable)x$11 -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestOffset$4(x$11);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(3L, 4), (Object)this.endPoint().fetchEarliestOffset(this.topicPartition(), 7));
    }

    @Test
    public void testFetchMaterializationTarget() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.endPoint().fetchTierMaterializationTarget(this.topicPartition(), 1));
    }

    @Test
    public void testFetchEpochEndOffsets() {
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEpochEndOffsets$1(response);
            return BoxedUnit.UNIT;
        });
        Map result = this.endPoint().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.topicPartition().partition()).setLeaderEpoch(0))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(0).setEndOffset(3L))}))), (Object)result);
        LeaderAndIsrRequest leaderAndIsrRequest = this.buildLeaderAndIsrRequest(4);
        this.replicaManager().becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2 & Serializable)(x$12, x$13) -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEpochEndOffsets$2(x$12, x$13);
            return BoxedUnit.UNIT;
        });
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), AppendOrigin.CLIENT, (short)-1).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEpochEndOffsets$3(response);
            return BoxedUnit.UNIT;
        });
        result = this.endPoint().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.topicPartition().partition()).setLeaderEpoch(4))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(4).setEndOffset(6L))}))), (Object)result);
        result = this.endPoint().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.topicPartition().partition()).setLeaderEpoch(3))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(0).setEndOffset(3L))}))), (Object)result);
        result = this.endPoint().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.topicPartition().partition()).setLeaderEpoch(5))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(-1).setEndOffset(-1L))}))), (Object)result);
    }

    private LeaderAndIsrRequest buildLeaderAndIsrRequest(int leaderEpoch) {
        java.util.List brokerList = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.sourceBroker().id()), (List)Nil$.MODULE$)).asJava();
        java.util.Map<String, Uuid> topicIds = Collections.singletonMap(this.topic(), this.topicId());
        return (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, 0L, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(this.topicPartition().partition()).setControllerEpoch(0).setLeader(this.sourceBroker().id()).setLeaderEpoch(leaderEpoch).setIsr(brokerList).setPartitionEpoch(0).setReplicas(brokerList).setIsNew(false), (List)Nil$.MODULE$)).asJava(), topicIds, true, (Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[]{this.node(this.sourceBroker())}))).asJava(), false).build();
    }

    private CallbackResult<ProduceResponse.PartitionResponse> appendRecords(ReplicaManager replicaManager, TopicPartition partition, MemoryRecords records, AppendOrigin origin, short requiredAcks) {
        CallbackResult<ProduceResponse.PartitionResponse> result = new CallbackResult<ProduceResponse.PartitionResponse>();
        replicaManager.appendRecords(1000L, requiredAcks, false, origin, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)records)})), (Function1 & Serializable)responses -> {
            LocalLeaderEndPointTest.appendCallback$1(responses, partition, result);
            return BoxedUnit.UNIT;
        }, replicaManager.appendRecords$default$7(), replicaManager.appendRecords$default$8(), replicaManager.appendRecords$default$9(), replicaManager.appendRecords$default$10(), replicaManager.appendRecords$default$11(), replicaManager.appendRecords$default$12());
        return result;
    }

    private AppendOrigin appendRecords$default$4() {
        return AppendOrigin.CLIENT;
    }

    private short appendRecords$default$5() {
        return -1;
    }

    private Node node(BrokerEndPoint endPoint) {
        return new Node(endPoint.id(), endPoint.host(), endPoint.port());
    }

    /*
     * WARNING - void declaration
     */
    private MemoryRecords records() {
        void withRecords_timestampType;
        SimpleRecord[] withRecords_records = new SimpleRecord[]{new SimpleRecord("first message".getBytes()), new SimpleRecord("second message".getBytes()), new SimpleRecord("third message".getBytes())};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        return MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
    }

    public static final /* synthetic */ void $anonfun$setUp$2(Iterable x$5, Iterable x$6) {
    }

    public static final /* synthetic */ void $anonfun$testFetchLatestOffset$1(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchLatestOffset$2(Iterable x$7, Iterable x$8) {
    }

    public static final /* synthetic */ void $anonfun$testFetchLatestOffset$3(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestOffset$1(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestOffset$2(Iterable x$9, Iterable x$10) {
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestOffset$3(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestOffset$4(Map x$11) {
    }

    public static final /* synthetic */ void $anonfun$testFetchEpochEndOffsets$1(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEpochEndOffsets$2(Iterable x$12, Iterable x$13) {
    }

    public static final /* synthetic */ void $anonfun$testFetchEpochEndOffsets$3(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    private static final void appendCallback$1(Map responses, TopicPartition partition$1, CallbackResult result$1) {
        Option response = responses.get((Object)partition$1);
        Assertions.assertTrue((boolean)response.isDefined());
        result$1.fire(response.get());
    }

    public LocalLeaderEndPointTest() {
        this.topic = "test";
    }

    private class CallbackResult<T> {
        private Option<T> value;
        private Option<Function1<T, BoxedUnit>> fun;

        private Option<T> value() {
            return this.value;
        }

        private void value_$eq(Option<T> x$1) {
            this.value = x$1;
        }

        private Option<Function1<T, BoxedUnit>> fun() {
            return this.fun;
        }

        private void fun_$eq(Option<Function1<T, BoxedUnit>> x$1) {
            this.fun = x$1;
        }

        public boolean hasFired() {
            return this.value().isDefined();
        }

        public void fire(T value) {
            this.value_$eq((Option<T>)new Some(value));
            this.fun().foreach((Function1 & Serializable)f -> {
                f.apply(value);
                return BoxedUnit.UNIT;
            });
        }

        public CallbackResult<T> onFire(Function1<T, BoxedUnit> fun) {
            this.fun_$eq((Option<Function1<T, BoxedUnit>>)new Some(fun));
            if (this.hasFired()) {
                this.fire(this.value().get());
            }
            return this;
        }

        public /* synthetic */ LocalLeaderEndPointTest kafka$server$LocalLeaderEndPointTest$CallbackResult$$$outer() {
            return LocalLeaderEndPointTest.this;
        }

        public CallbackResult() {
            if (LocalLeaderEndPointTest.this == null) {
                throw null;
            }
            this.value = None$.MODULE$;
            this.fun = None$.MODULE$;
        }
    }
}

