/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.tier.TierUnfetchedTimestampAndOffset;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.FetchedTimestampAndOffset;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.storage.internals.log.MaybeResolvedTimestampAndOffset;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Timeout(value=300L)
@Tag(value="bazel:shard_count:2")
@ScalaSignature(bytes="\u0006\u0005\t]e\u0001\u0002\f\u0018\u0001qAQ!\t\u0001\u0005\u0002\tBQ\u0001\n\u0001\u0005B\u0015BQ\u0001\f\u0001\u0005R5BQa\u000f\u0001\u0005\u0002qBQ!\u001d\u0001\u0005\u0002IDQ!\u001f\u0001\u0005\u0002iDq!!\u0001\u0001\t\u0003\t\u0019\u0001C\u0004\u0002\u0010\u0001!\t!!\u0005\t\u000f\u0005u\u0001\u0001\"\u0001\u0002 !9\u00111\u0006\u0001\u0005\u0002\u00055\u0002bBA\u001d\u0001\u0011\u0005\u00111\b\u0005\b\u0003\u001b\u0002A\u0011AA(\u0011\u001d\ti\u0006\u0001C\u0001\u0003?Bq!a\u001b\u0001\t\u0003\ti\u0007C\u0004\u0002z\u0001!I!a\u001f\t\u000f\u0005\r\u0005\u0001\"\u0003\u0002\u0006\"9\u0011q\u0015\u0001\u0005\n\u0005%\u0006bBA]\u0001\u0011%\u00111\u0018\u0005\b\u0005\u001b\u0001A\u0011\u0002B\b\u0011\u001d\u0011Y\u0004\u0001C\u0005\u0005{AqAa\u0015\u0001\t\u0013\u0011)FA\u0007M_\u001e|eMZ:fiR+7\u000f\u001e\u0006\u00031e\taa]3sm\u0016\u0014(\"\u0001\u000e\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\b\t\u0003=}i\u0011aF\u0005\u0003A]\u0011qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r\u0002\"A\b\u0001\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u000b\u0002MA\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t\u0019\u0011J\u001c;\u0002/\t\u0014xn[3s!J|\u0007/\u001a:us>3XM\u001d:jI\u0016\u001cHC\u0001\u00182!\t9s&\u0003\u00021Q\t!QK\\5u\u0011\u0015\u00114\u00011\u00014\u0003\u0015\u0001(o\u001c9t!\t!\u0014(D\u00016\u0015\t1t'\u0001\u0003vi&d'\"\u0001\u001d\u0002\t)\fg/Y\u0005\u0003uU\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0003u!Xm\u001d;HKR|eMZ:fiN4uN]+oW:|wO\u001c+pa&\u001cGc\u0001\u0018>\u0015\")a\b\u0002a\u0001\u007f\u00051\u0011/^8sk6\u0004\"\u0001Q$\u000f\u0005\u0005+\u0005C\u0001\")\u001b\u0005\u0019%B\u0001#\u001c\u0003\u0019a$o\\8u}%\u0011a\tK\u0001\u0007!J,G-\u001a4\n\u0005!K%AB*ue&twM\u0003\u0002GQ!)1\n\u0002a\u0001\u007f\u0005Y!/\u001a9mS\u000e\fG/[8oQ\u0019!Q\nU)T)B\u0011qET\u0005\u0003\u001f\"\u0012!\u0002Z3qe\u0016\u001c\u0017\r^3e\u0003\u001diWm]:bO\u0016\f\u0013AU\u0001\u0016\u0019&\u001cHo\u00144gg\u0016$8OU3rk\u0016\u001cH\u000f\t,1\u0003\u0015\u0019\u0018N\\2fC\u0005)\u0016\u0001\u0001\u0015\u0005\t]\u001bG\r\u0005\u0002YC6\t\u0011L\u0003\u0002[7\u00061\u0001/\u0019:b[NT!\u0001X/\u0002\u000f),\b/\u001b;fe*\u0011alX\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002A\u0006\u0019qN]4\n\u0005\tL&!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\u0005)\u0017\u0001K>eSN\u0004H.Y=OC6,WPL9v_J,X.P>1{:\u0012X\r\u001d7jG\u0006$\u0018n\u001c8>wFj\b\u0006\u0002\u0003h[:\u0004\"\u0001[6\u000e\u0003%T!A[-\u0002\u0011A\u0014xN^5eKJL!\u0001\\5\u0003\u00195+G\u000f[8e'>,(oY3\u0002\u000bY\fG.^3-\u0003=\f\u0013\u0001]\u0001-\u00032d7+\u001e9q_J$X\rZ)v_J,X.\u00118e%\u0016\u0004H.[2bi&|gnQ8nE&t\u0017\r^5p]N\f\u0001\u0005^3ti\u001e+Go\u00144gg\u0016$8/\u00114uKJ$U\r\\3uKJ+7m\u001c:egR\u0019af\u001d;\t\u000by*\u0001\u0019A \t\u000b-+\u0001\u0019A )\r\u0015i\u0005+U*UQ\u0011)qk\u00193)\t\u00159W\u000e\u001f\u0017\u0002_\u00061D/Z:u\r\u0016$8\r[(gMN,GOQ=US6,7\u000f^1na\u001a{'/T1y)&lWm\u001d;b[B\fe\r^3s)J,hnY1uKR\u0019af\u001f?\t\u000by2\u0001\u0019A \t\u000b-3\u0001\u0019A )\t\u001996\r\u001a\u0015\u0005\r\u001dlw\u0010L\u0001p\u0003\u0001#Xm\u001d;GKR\u001c\u0007n\u00144gg\u0016$()\u001f+j[\u0016\u001cH/Y7q\r>\u0014X*\u0019=US6,7\u000f^1na^KG\u000f[+o_J$WM]3e)&lWm\u001d;b[B\u001cH#\u0002\u0018\u0002\u0006\u0005\u001d\u0001\"\u0002 \b\u0001\u0004y\u0004\"B&\b\u0001\u0004y\u0004\u0006B\u0004XG\u0012DSaB4n\u0003\u001ba\u0013a\\\u0001\u001fi\u0016\u001cHoR3u\u001f\u001a47/\u001a;t\u0005\u00164wN]3MCR,7\u000f\u001e+j[\u0016$RALA\n\u0003+AQA\u0010\u0005A\u0002}BQa\u0013\u0005A\u0002}BC\u0001C,dI\"*\u0001bZ7\u0002\u001c1\nq.A\fuKN$X)\u001c9us2{wm]$fi>3gm]3ugR)a&!\t\u0002$!)a(\u0003a\u0001\u007f!)1*\u0003a\u0001\u007f!\"\u0011bV2eQ\u0015Iq-\\A\u0015Y\u0005y\u0017!\u000e;fgR4U\r^2i\u001f\u001a47/\u001a;CsRKW.Z:uC6\u0004hi\u001c:NCb$\u0016.\\3ti\u0006l\u0007oV5uQ\u0016k\u0007\u000f^=M_\u001e$RALA\u0018\u0003cAQA\u0010\u0006A\u0002}BQa\u0013\u0006A\u0002}BCAC,dI\"*!bZ7\u000281\nq.A\fuKN$x)\u001a;PM\u001a\u001cX\r^:CK\u001a|'/\u001a(poR)a&!\u0010\u0002@!)ah\u0003a\u0001\u007f!)1j\u0003a\u0001\u007f!:1\"\u0014)\u0002DM#\u0016EAA#\u0003aaWmZ1ds\u001a+Go\u00195PM\u001a\u001cX\r^:CK\u001a|'/\u001a\u0015\u0005\u0017]\u001bG\rK\u0003\fO6\fY\u0005L\u0001p\u0003\u0001\"Xm\u001d;HKR|eMZ:fiN\u0014UMZ8sK\u0016\u000b'\u000f\\5fgR$\u0016.\\3\u0015\u000b9\n\t&a\u0015\t\u000byb\u0001\u0019A \t\u000b-c\u0001\u0019A )\u000f1i\u0005+a\u0011T)\"\"AbV2eQ\u0015aq-\\A.Y\u0005y\u0017!\f;fgR4U\r^2i\u001f\u001a47/\u001a;t\u0005\u00164wN]3XSRD7\t[1oO&twmU3h[\u0016tGoU5{KR)a&!\u0019\u0002d!)a(\u0004a\u0001\u007f!)1*\u0004a\u0001\u007f!\"QbV2eQ\u0015iq-\\A5Y\u0005y\u0017A\u000b;fgR4U\r^2i\u001f\u001a47/\u001a;t\u0005\u00164wN]3XSRD7\t[1oO&twmU3h[\u0016tGo\u001d\u000b\u0006]\u0005=\u0014\u0011\u000f\u0005\u0006}9\u0001\ra\u0010\u0005\u0006\u0017:\u0001\ra\u0010\u0015\u0005\u001d]\u001bG\rK\u0003\u000fO6\f9\bL\u0001p\u0003\u0019\u0011'o\\6feV\u0011\u0011Q\u0010\t\u0004=\u0005}\u0014bAAA/\tY1*\u00194lC\n\u0013xn[3s\u0003Y\u0019XM\u001c3MSN$xJ\u001a4tKR\u001c(+Z9vKN$H\u0003BAD\u0003;\u0003B!!#\u0002\u001a6\u0011\u00111\u0012\u0006\u0005\u0003\u001b\u000by)\u0001\u0005sKF,Xm\u001d;t\u0015\u0011\t\t*a%\u0002\r\r|W.\\8o\u0015\rQ\u0012Q\u0013\u0006\u0004\u0003/{\u0016AB1qC\u000eDW-\u0003\u0003\u0002\u001c\u0006-%a\u0005'jgR|eMZ:fiN\u0014Vm\u001d9p]N,\u0007bBAP!\u0001\u0007\u0011\u0011U\u0001\be\u0016\fX/Z:u!\u0011\tI)a)\n\t\u0005\u0015\u00161\u0012\u0002\u0013\u0019&\u001cHo\u00144gg\u0016$8OU3rk\u0016\u001cH/\u0001\ttK:$g)\u001a;dQJ+\u0017/^3tiR!\u00111VAY!\u0011\tI)!,\n\t\u0005=\u00161\u0012\u0002\u000e\r\u0016$8\r\u001b*fgB|gn]3\t\u000f\u0005}\u0015\u00031\u0001\u00024B!\u0011\u0011RA[\u0013\u0011\t9,a#\u0003\u0019\u0019+Go\u00195SKF,Xm\u001d;\u0002!\t,\u0018\u000e\u001c3UCJ<W\r\u001e+j[\u0016\u001cH\u0003CA_\u0003g\fyP!\u0003\u0011\r\u0005}\u0016\u0011ZAh\u001d\u0011\t\t-!2\u000f\u0007\t\u000b\u0019-C\u0001*\u0013\r\t9\rK\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY-!4\u0003\t1K7\u000f\u001e\u0006\u0004\u0003\u000fD\u0003\u0003BAi\u0003[tA!a5\u0002h:!\u0011Q[As\u001d\u0011\t9.a9\u000f\t\u0005e\u0017\u0011\u001d\b\u0005\u00037\fyND\u0002C\u0003;L\u0011\u0001Y\u0005\u0004\u0003/{\u0016b\u0001\u000e\u0002\u0016&!\u0011\u0011SAJ\u0013\r\u0001\u0016qR\u0005\u0005\u0003S\fY/\u0001\fMSN$xJ\u001a4tKR\u001c(+Z9vKN$H)\u0019;b\u0015\r\u0001\u0016qR\u0005\u0005\u0003_\f\tP\u0001\tMSN$xJ\u001a4tKR\u001cHk\u001c9jG*!\u0011\u0011^Av\u0011\u001d\t)P\u0005a\u0001\u0003o\f!\u0001\u001e9\u0011\t\u0005e\u00181`\u0007\u0003\u0003\u001fKA!!@\u0002\u0010\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007b\u0002B\u0001%\u0001\u0007!1A\u0001\ni&lWm\u001d;b[B\u00042a\nB\u0003\u0013\r\u00119\u0001\u000b\u0002\u0005\u0019>tw\r\u0003\u0004\u0003\fI\u0001\rAJ\u0001\u000e[\u0006Dh*^7PM\u001a\u001cX\r^:\u0002\u001b\u0019Lg\u000e\u001a)beRLG/[8o)\u0019\u0011\tBa\b\u0003:A!!1\u0003B\r\u001d\u0011\t\u0019N!\u0006\n\t\t]\u00111^\u0001\u0018\u0019&\u001cHo\u00144gg\u0016$8OU3ta>t7/\u001a#bi\u0006LAAa\u0007\u0003\u001e\taB*[:u\u001f\u001a47/\u001a;t!\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9p]N,'\u0002\u0002B\f\u0003WDqA!\t\u0014\u0001\u0004\u0011\u0019#\u0001\u0004u_BL7m\u001d\t\u0007\u0005K\u0011yCa\r\u000e\u0005\t\u001d\"\u0002\u0002B\u0015\u0005W\tq!\\;uC\ndWMC\u0002\u0003.!\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\tDa\n\u0003\r\t+hMZ3s!\u0011\u0011\u0019B!\u000e\n\t\t]\"Q\u0004\u0002\u0019\u0019&\u001cHo\u00144gg\u0016$8\u000fV8qS\u000e\u0014Vm\u001d9p]N,\u0007bBA{'\u0001\u0007\u0011q_\u0001\u0015GJ,\u0017\r^3U_BL7-\u00118e\u000f\u0016$Hj\\4\u0015\r\t}\"1\nB(!\u0011\u0011\tEa\u0012\u000e\u0005\t\r#b\u0001B#3\u0005\u0019An\\4\n\t\t%#1\t\u0002\f\u0003\n\u001cHO]1di2{w\r\u0003\u0004\u0003NQ\u0001\raP\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u0005#\"\u0002\u0019AA|\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\f\u0001$Y:tKJ$H+[7fgR\fW\u000e]!oI>3gm]3u)\u001dq#q\u000bB:\u0005oBqA!\u0017\u0016\u0001\u0004\u0011Y&\u0001\nuS6,7\u000f^1na\u0006sGm\u00144gg\u0016$\b#B\u0014\u0003^\t\u0005\u0014b\u0001B0Q\t1q\n\u001d;j_:\u0004BAa\u0019\u0003p5\u0011!Q\r\u0006\u0005\u0005\u000b\u00129G\u0003\u0003\u0003j\t-\u0014!C5oi\u0016\u0014h.\u00197t\u0015\u0011\u0011i'a%\u0002\u000fM$xN]1hK&!!\u0011\u000fB3\u0005}i\u0015-\u001f2f%\u0016\u001cx\u000e\u001c<fIRKW.Z:uC6\u0004\u0018I\u001c3PM\u001a\u001cX\r\u001e\u0005\b\u0005k*\u0002\u0019\u0001B\u0002\u0003E)\u0007\u0010]3di\u0016$G+[7fgR\fW\u000e\u001d\u0005\b\u0005s*\u0002\u0019\u0001B\u0002\u00039)\u0007\u0010]3di\u0016$wJ\u001a4tKRDc\u0001\u0001B?[\n%\u0005\u0003\u0002B@\u0005\u000bk!A!!\u000b\u0007\t\r5,A\u0002ba&LAAa\"\u0003\u0002\n9A+[7f_V$hDA\u0001-Q\u0019\u0001!QR7\u0003\u0014B!!q\u0010BH\u0013\u0011\u0011\tJ!!\u0003\u0007Q\u000bw-\t\u0002\u0003\u0016\u0006\u0019\"-\u0019>fYj\u001a\b.\u0019:e?\u000e|WO\u001c;;e\u0001")
public class LogOffsetTest
extends BaseRequestTest {
    @Override
    public int brokerCount() {
        return 1;
    }

    @Override
    public void brokerPropertyOverrides(Properties props) {
        props.put("log.flush.interval.messages", "1");
        props.put("num.partitions", "20");
        props.put("log.retention.hours", "10");
        props.put("log.retention.check.interval.ms", Integer.toString(300000));
        props.put("log.segment.bytes", "140");
        this.maybeEnablePushReplication(props);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinations"})
    public void testGetOffsetsForUnknownTopic(String quorum, String replication) {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        ListOffsetsRequest request = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -1L, 10)).asJava()).build((short)0);
        ListOffsetsResponse response = this.sendListOffsetsRequest(request);
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(response.topics()).asScala(), topicPartition).errorCode());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinations"})
    public void testGetOffsetsAfterDeleteRecords(String quorum, String replication) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        AbstractLog log = this.createTopicAndGetLog(topic, topicPartition);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$1 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6()));
        log.flush(false);
        log.updateHighWatermark(log.logEndOffset());
        log.maybeIncrementLogStartOffset(3L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        log.deleteOldSegments();
        Seq offsets = log.legacyFetchOffsetsBefore(-1L, 15);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)offsets);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.broker())) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Leader should be elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -1L, 15)).asJava()).build();
        Buffer consumerOffsets = CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)consumerOffsets);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinations"})
    public void testFetchOffsetByTimestampForMaxTimestampAfterTruncate(String quorum, String replication) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        AbstractLog log = this.createTopicAndGetLog(topic, topicPartition);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)timestamp -> LogOffsetTest.$anonfun$testFetchOffsetByTimestampForMaxTimestampAfterTruncate$1(log, BoxesRunTime.unboxToInt((Object)timestamp)));
        log.flush(false);
        log.updateHighWatermark(log.logEndOffset());
        Option firstOffset = log.fetchOffsetByTimestamp(-3L);
        this.assertTimestampAndOffset((Option<MaybeResolvedTimestampAndOffset>)firstOffset, 19L, 19L);
        log.truncateTo(0L);
        Option secondOffset = log.fetchOffsetByTimestamp(-3L);
        this.assertTimestampAndOffset((Option<MaybeResolvedTimestampAndOffset>)secondOffset, -1L, 0L);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinations"})
    public void testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps(String quorum, String replication) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        AbstractLog log = this.createTopicAndGetLog(topic, topicPartition);
        ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L, 1L, 2L, 3L, 4L, 6L, 5L}))).foreach((Function1 & Serializable)timestamp -> LogOffsetTest.$anonfun$testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps$1(log, BoxesRunTime.unboxToLong((Object)timestamp)));
        log.flush(false);
        log.updateHighWatermark(log.logEndOffset());
        Option maxTimestampOffset = log.fetchOffsetByTimestamp(-3L);
        Assertions.assertEquals((long)7L, (long)log.logEndOffset());
        this.assertTimestampAndOffset((Option<MaybeResolvedTimestampAndOffset>)maxTimestampOffset, 6L, 5L);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinations"})
    public void testGetOffsetsBeforeLatestTime(String quorum, String replication) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        AbstractLog log = this.createTopicAndGetLog(topic, topicPartition);
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds((Seq<String>)new .colon.colon((Object)"kafka-", (List)Nil$.MODULE$))).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$2 -> x$2.swap())).asJava();
        Uuid topicId = (Uuid)topicIds.get(topic);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$3 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6()));
        log.flush(false);
        Seq offsets = log.legacyFetchOffsetsBefore(-1L, 15);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, 0, this.broker())) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Leader should be elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -1L, 15)).asJava()).build();
        Buffer consumerOffsets = CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((short)ApiKeys.FETCH.latestVersion(), (int)0, (int)1, (java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new FetchRequest.PartitionData(topicId, Predef$.MODULE$.Long2long((Long)consumerOffsets.head()), -1L, 307200, Optional.empty(), Optional.empty(), Optional.empty()))}))).asJava()).build();
        Assertions.assertFalse((boolean)FetchResponse.recordsOrFail((FetchResponseData.PartitionData)((FetchResponseData.PartitionData)this.sendFetchRequest(fetchRequest).responseData(topicNames, ApiKeys.FETCH.latestVersion()).get(topicPartition))).batches().iterator().hasNext());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinations"})
    public void testEmptyLogsGetOffsets(String quorum, String replication) {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(10));
        String topicPartitionPath = new StringBuilder(2).append(TestUtils.tempDirectory(null, null).getAbsolutePath()).append("/").append(topic).append("-").append(topicPartition.partition()).toString();
        new File(topicPartitionPath).mkdir();
        this.createTopic(topic, 1, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        BooleanRef offsetChanged = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 14).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> {
            TopicPartition topicPartition = new TopicPartition(topic, 0);
            ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -2L, 1)).asJava()).build();
            if (BoxesRunTime.equals((Object)CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala().head(), (Object)BoxesRunTime.boxToInteger((int)1))) {
                offsetChanged$1.elem = true;
                return;
            }
        });
        Assertions.assertFalse((boolean)offsetChanged.elem);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinations"})
    public void testFetchOffsetByTimestampForMaxTimestampWithEmptyLog(String quorum, String replication) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        AbstractLog log = this.createTopicAndGetLog(topic, topicPartition);
        log.updateHighWatermark(log.logEndOffset());
        Option maxTimestampOffset = log.fetchOffsetByTimestamp(-3L);
        Assertions.assertEquals((long)0L, (long)log.logEndOffset());
        this.assertTimestampAndOffset((Option<MaybeResolvedTimestampAndOffset>)maxTimestampOffset, -1L, 0L);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinations"})
    public void testGetOffsetsBeforeNow(String quorum, String replication) {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        LogManager logManager = this.broker().logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = logManager.getOrCreateLog$default$2();
        boolean x$4 = logManager.getOrCreateLog$default$3();
        Option x$52 = logManager.getOrCreateLog$default$5();
        AbstractLog log = logManager.getOrCreateLog(topicPartition, x$3, x$4, (Option)x$2, x$52);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$5 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6()));
        log.flush(false);
        long now = Time.SYSTEM.milliseconds() + 30000L;
        Seq offsets = log.legacyFetchOffsetsBefore(now, 15);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.broker())) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Leader should be elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, now, 15)).asJava()).build();
        Buffer consumerOffsets = CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinations"})
    public void testGetOffsetsBeforeEarliestTime(String quorum, String replication) {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        LogManager logManager = this.broker().logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = logManager.getOrCreateLog$default$2();
        boolean x$4 = logManager.getOrCreateLog$default$3();
        Option x$5 = logManager.getOrCreateLog$default$5();
        AbstractLog log = logManager.getOrCreateLog(topicPartition, x$3, x$4, (Option)x$2, x$5);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$6 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6()));
        log.flush(false);
        package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{-2L, -4L})).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)timestamp -> {
            Seq offsets = log.legacyFetchOffsetsBefore(timestamp, 10);
            Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L})), (Object)offsets);
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.broker())) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Leader should be elected");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, timestamp, 10)).asJava()).build();
            Buffer consumerOffsets = CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
            Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L})), (Object)consumerOffsets);
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinations"})
    public void testFetchOffsetsBeforeWithChangingSegmentSize(String quorum, String replication) {
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        LogSegment logSegment = (LogSegment)Mockito.mock(LogSegment.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)logSegment.size())).thenAnswer((Answer)new Answer<Object>(null){
            private final AtomicInteger value;

            public int answer(InvocationOnMock invocation) {
                return this.value.getAndIncrement();
            }
            {
                this.value = new AtomicInteger(0);
            }
        });
        java.util.List logSegments = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)logSegment, (List)Nil$.MODULE$)).asJava();
        Mockito.when((Object)log.localLogSegments()).thenReturn((Object)logSegments);
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinations"})
    public void testFetchOffsetsBeforeWithChangingSegments(String quorum, String replication) {
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        LogSegment logSegment = (LogSegment)Mockito.mock(LogSegment.class);
        Mockito.when((Object)log.localLogSegments()).thenReturn((Object)new AbstractCollection<LogSegment>(null, logSegment){
            private final LogSegment logSegment$1;

            public int size() {
                return 2;
            }

            public Iterator<LogSegment> iterator() {
                return Arrays.asList(this.logSegment$1).iterator();
            }
            {
                this.logSegment$1 = logSegment$1;
            }
        });
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    private KafkaBroker broker() {
        return (KafkaBroker)this.brokers().head();
    }

    private ListOffsetsResponse sendListOffsetsRequest(ListOffsetsRequest request) {
        return (ListOffsetsResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ListOffsetsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private FetchResponse sendFetchRequest(FetchRequest request) {
        return (FetchResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private List<ListOffsetsRequestData.ListOffsetsTopic> buildTargetTimes(TopicPartition tp, long timestamp, int maxNumOffsets) {
        return new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(tp.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(tp.partition()).setTimestamp(timestamp).setMaxNumOffsets(maxNumOffsets), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
    }

    private ListOffsetsResponseData.ListOffsetsPartitionResponse findPartition(Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse> topics, TopicPartition tp) {
        return (ListOffsetsResponseData.ListOffsetsPartitionResponse)CollectionConverters$.MODULE$.ListHasAsScala(((ListOffsetsResponseData.ListOffsetsTopicResponse)topics.find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$findPartition$1(tp, x$7))).get()).partitions()).asScala().find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$findPartition$2(tp, x$8))).get();
    }

    /*
     * WARNING - void declaration
     */
    private AbstractLog createTopicAndGetLog(String topic, TopicPartition topicPartition) {
        this.createTopic(topic, 1, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        LogManager logManager = this.broker().logManager();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogOffsetTest.$anonfun$createTopicAndGetLog$1(logManager, topicPartition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Log for partition [topic,0] should be created");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return (AbstractLog)logManager.getLog(topicPartition, logManager.getLog$default$2()).get();
    }

    private void assertTimestampAndOffset(Option<MaybeResolvedTimestampAndOffset> timestampAndOffset, long expectedTimestamp, long expectedOffset) {
        MaybeResolvedTimestampAndOffset maybeResolvedTimestampAndOffset = (MaybeResolvedTimestampAndOffset)timestampAndOffset.get();
        if (maybeResolvedTimestampAndOffset instanceof FetchedTimestampAndOffset) {
            FetchedTimestampAndOffset fetchedTimestampAndOffset = (FetchedTimestampAndOffset)maybeResolvedTimestampAndOffset;
            Assertions.assertEquals((long)expectedOffset, (long)fetchedTimestampAndOffset.offset());
            Assertions.assertEquals((long)expectedTimestamp, (long)fetchedTimestampAndOffset.timestamp());
            return;
        }
        if (maybeResolvedTimestampAndOffset instanceof TierUnfetchedTimestampAndOffset) {
            throw new AssertionError((Object)"unexpected ListOffset result from the tier portion of the log");
        }
        throw new AssertionError((Object)"unexpected ListOffset result from max timestamp query");
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsAfterDeleteRecords$3() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testFetchOffsetByTimestampForMaxTimestampAfterTruncate$1(AbstractLog log$2, int timestamp) {
        byte[] x$1 = Integer.toString(42).getBytes();
        long x$2 = timestamp;
        CompressionType x$4 = CompressionType.NONE;
        byte x$5 = 2;
        return log$2.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, null, x$4, x$2, x$5), 0, log$2.appendAsLeader$default$3(), log$2.appendAsLeader$default$4(), log$2.appendAsLeader$default$5(), log$2.appendAsLeader$default$6());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps$1(AbstractLog log$3, long timestamp) {
        byte[] x$1 = Integer.toString(42).getBytes();
        CompressionType x$4 = CompressionType.NONE;
        byte x$5 = 2;
        return log$3.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, null, x$4, timestamp, x$5), 0, log$3.appendAsLeader$default$3(), log$3.appendAsLeader$default$4(), log$3.appendAsLeader$default$5(), log$3.appendAsLeader$default$6());
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeLatestTime$4() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeNow$3() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeEarliestTime$4() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ boolean $anonfun$findPartition$1(TopicPartition tp$1, ListOffsetsResponseData.ListOffsetsTopicResponse x$7) {
        String string = x$7.name();
        String string2 = tp$1.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findPartition$2(TopicPartition tp$1, ListOffsetsResponseData.ListOffsetsPartitionResponse x$8) {
        return x$8.partitionIndex() == tp$1.partition();
    }

    public static final /* synthetic */ boolean $anonfun$createTopicAndGetLog$1(LogManager logManager$1, TopicPartition topicPartition$4) {
        return logManager$1.getLog(topicPartition$4, logManager$1.getLog$default$2()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$createTopicAndGetLog$2() {
        return "Log for partition [topic,0] should be created";
    }
}

