/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Stream;
import kafka.api.LeaderAndIsr$;
import kafka.common.TenantHelpers;
import kafka.server.BrokerFeatures;
import kafka.server.BrokerFeatures$;
import kafka.server.MetadataCache;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.ZkMetadataCache;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metadata.CellRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.RemoveTopicRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;

public final class MetadataCacheTest$ {
    public static final MetadataCacheTest$ MODULE$ = new MetadataCacheTest$();

    /*
     * WARNING - void declaration
     */
    public Stream<MetadataCache> zkCacheProvider() {
        void zkMetadataCache_zkMigrationEnabled;
        void zkMetadataCache_isMultiTenant;
        void zkMetadataCache_kraftControllerNodes;
        void zkMetadataCache_brokerFeatures;
        boolean bl = false;
        boolean bl2 = false;
        Seq seq = (Seq)Seq$.MODULE$.empty();
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createEmpty();
        MetadataVersion zkMetadataCache_metadataVersion = MetadataVersion.latestTesting();
        int zkMetadataCache_brokerId = 1;
        Object var2_5 = null;
        brokerFeatures = null;
        seq = null;
        return Stream.of(new ZkMetadataCache(zkMetadataCache_brokerId, zkMetadataCache_metadataVersion, (BrokerFeatures)zkMetadataCache_brokerFeatures, (Seq)zkMetadataCache_kraftControllerNodes, (boolean)zkMetadataCache_isMultiTenant, (boolean)zkMetadataCache_zkMigrationEnabled));
    }

    /*
     * WARNING - void declaration
     */
    public Stream<MetadataCache> cacheProvider() {
        void zkMetadataCache_zkMigrationEnabled;
        void zkMetadataCache_isMultiTenant;
        void zkMetadataCache_kraftControllerNodes;
        void zkMetadataCache_brokerFeatures;
        MetadataCache[] metadataCacheArray = new MetadataCache[2];
        boolean bl = false;
        boolean bl2 = false;
        Seq seq = (Seq)Seq$.MODULE$.empty();
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createEmpty();
        MetadataVersion zkMetadataCache_metadataVersion = MetadataVersion.latestTesting();
        int zkMetadataCache_brokerId = 1;
        Object var2_5 = null;
        brokerFeatures = null;
        seq = null;
        metadataCacheArray[0] = new ZkMetadataCache(zkMetadataCache_brokerId, zkMetadataCache_metadataVersion, (BrokerFeatures)zkMetadataCache_brokerFeatures, (Seq)zkMetadataCache_kraftControllerNodes, (boolean)zkMetadataCache_isMultiTenant, (boolean)zkMetadataCache_zkMigrationEnabled);
        int kRaftMetadataCache_brokerId = 1;
        metadataCacheArray[1] = new KRaftMetadataCache(kRaftMetadataCache_brokerId);
        return Stream.of(metadataCacheArray);
    }

    /*
     * WARNING - void declaration
     */
    public Stream<MetadataCache> multiTenantCacheProvider() {
        void zkMetadataCache_isMultiTenant;
        MetadataCache[] metadataCacheArray = new MetadataCache[2];
        MetadataVersion x$2 = MetadataVersion.latestTesting();
        BrokerFeatures x$4 = BrokerFeatures$.MODULE$.createEmpty();
        Seq x$5 = (Seq)Seq$.MODULE$.empty();
        boolean x$6 = false;
        boolean bl = true;
        int zkMetadataCache_brokerId = 1;
        metadataCacheArray[0] = new ZkMetadataCache(zkMetadataCache_brokerId, x$2, x$4, x$5, (boolean)zkMetadataCache_isMultiTenant, x$6);
        int kRaftMetadataCache_brokerId = 1;
        metadataCacheArray[1] = new KRaftMetadataCache(kRaftMetadataCache_brokerId);
        return Stream.of(metadataCacheArray);
    }

    public void updateCache(MetadataCache cache, UpdateMetadataRequest request, Seq<ApiMessage> records) {
        if (cache instanceof ZkMetadataCache) {
            ((ZkMetadataCache)cache).updateMetadata(0, request);
            return;
        }
        if (cache instanceof KRaftMetadataCache) {
            KRaftMetadataCache kRaftMetadataCache = (KRaftMetadataCache)cache;
            MetadataImage image = kRaftMetadataCache.currentImage();
            MetadataImage partialImage = new MetadataImage(new MetadataProvenance(100L, 10, 1000L), image.features(), ClusterImage.EMPTY, image.topics(), image.configs(), image.clientQuotas(), image.producerIds(), image.acls(), image.clusterLinks(), image.brokerReplicaExclusions(), image.cells(), image.tenants(), image.scram(), image.delegationTokens(), (MetadataEncryptor)NoOpMetadataEncryptor.INSTANCE);
            MetadataDelta delta = new MetadataDelta.Builder().setImage(partialImage).setNameToTenantCallback(TenantHelpers.NAME_TO_TENANT_CALLBACK).build();
            CollectionConverters$.MODULE$.IteratorHasAsScala(request.liveBrokers().iterator()).asScala().foreach((Function1 & Serializable)brokerInfo -> {
                delta.replay(MetadataCacheTest$.toRecord$1(brokerInfo, image));
                return BoxedUnit.UNIT;
            });
            request.topicStates().forEach(topic -> MetadataCacheTest$.toRecords$1(topic).foreach((Function1 & Serializable)record -> {
                delta.replay(record, (short)0);
                return BoxedUnit.UNIT;
            }));
            request.cells().forEach(cell -> delta.replay(new CellRecord().setCellId(cell.cellId()).setBrokers(cell.brokers()).setState(CellState.READY.code())));
            records.foreach((Function1 & Serializable)record -> {
                MetadataCacheTest$.$anonfun$updateCache$7(delta, record);
                return BoxedUnit.UNIT;
            });
            kRaftMetadataCache.setImage(delta.apply(new MetadataProvenance(100L, 10, 1000L)));
            return;
        }
        throw new RuntimeException("Unsupported cache type");
    }

    public Seq<ApiMessage> updateCache$default$3() {
        return Nil$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private static final RegisterBrokerRecord toRecord$1(UpdateMetadataRequestData.UpdateMetadataBroker broker, MetadataImage image$1) {
        void var5_7;
        boolean bl;
        Uuid uuid;
        long l;
        RegisterBrokerRecord.BrokerEndpointCollection endpoints = new RegisterBrokerRecord.BrokerEndpointCollection();
        broker.endpoints().forEach(e -> endpoints.add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setName(e.listener()).setHost(e.host()).setPort(e.port()).setSecurityProtocol(e.securityProtocol())));
        Option prevBroker = Option$.MODULE$.apply((Object)image$1.cluster().broker(broker.id()));
        if (None$.MODULE$.equals(prevBroker)) {
            l = 0L;
            uuid = Uuid.ZERO_UUID;
            bl = false;
        } else if (prevBroker instanceof Some) {
            BrokerRegistration b = (BrokerRegistration)((Some)prevBroker).value();
            l = b.epoch();
            uuid = b.incarnationId();
            bl = b.fenced();
        } else {
            throw new MatchError((Object)prevBroker);
        }
        boolean bl2 = bl;
        Uuid uuid2 = uuid;
        long epoch = l;
        return new RegisterBrokerRecord().setBrokerId(broker.id()).setBrokerEpoch((long)var5_7).setIncarnationId(uuid2).setEndPoints(endpoints).setRack(broker.rack()).setFenced(bl2);
    }

    private static final Seq toRecords$1(UpdateMetadataRequestData.UpdateMetadataTopicState topic) {
        ArrayBuffer results = new ArrayBuffer();
        HashSet deletedTopicIds = new HashSet();
        results.$plus$eq((Object)new TopicRecord().setName(topic.topicName()).setTopicId(topic.topicId()));
        topic.partitionStates().forEach(partition -> {
            if (partition.leader() == LeaderAndIsr$.MODULE$.LeaderDuringDelete()) {
                if (deletedTopicIds.add(topic.topicId())) {
                    results.$plus$eq((Object)new RemoveTopicRecord().setTopicId(topic.topicId()));
                    return;
                }
                return;
            }
            results.$plus$eq((Object)new PartitionRecord().setPartitionId(partition.partitionIndex()).setTopicId(topic.topicId()).setReplicas(partition.replicas()).setObservers(partition.observers()).setIsr(partition.isr()).setRemovingReplicas(Collections.emptyList()).setAddingReplicas(Collections.emptyList()).setLeader(partition.leader()).setLeaderEpoch(partition.leaderEpoch()).setPartitionEpoch(partition.zkVersion()));
        });
        return results;
    }

    public static final /* synthetic */ void $anonfun$updateCache$7(MetadataDelta delta$1, ApiMessage record) {
        if (record instanceof TopicRecord) {
            TopicRecord topicRecord = (TopicRecord)record;
            delta$1.replay(topicRecord);
            return;
        }
        if (record instanceof PartitionRecord) {
            PartitionRecord partitionRecord = (PartitionRecord)record;
            delta$1.replay(partitionRecord);
            return;
        }
    }

    private MetadataCacheTest$() {
    }
}

