/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import java.util.OptionalInt;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.Fetching$;
import kafka.server.InitialFetchState;
import kafka.server.LeaderEndPoint;
import kafka.server.MockFetcherThread$;
import kafka.server.MockLeaderEndPoint;
import kafka.server.MockTierStateMachine;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionState;
import kafka.server.PausedPartitions;
import kafka.server.TierStateMachine;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordValidationStats;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.junit.jupiter.api.Assertions;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\rb\u0001\u0002\u0016,\u0001AB\u0001\"\u000e\u0001\u0003\u0006\u0004%\tA\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005o!A1\b\u0001BC\u0002\u0013\u0005A\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003>\u0011!\t\u0005A!b\u0001\n\u0003\u0011\u0005\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u0011)\u0003!Q1A\u0005\u0002\tC\u0001b\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\"A!\f\u0001B\u0001B\u0003%1\f\u0003\u0005_\u0001\t\u0005\t\u0015!\u0003`\u0011!\u0011\u0007A!A!\u0002\u0013\u0019\u0007\"\u00024\u0001\t\u00039\u0007bB9\u0001\u0005\u0004%IA\u001d\u0005\b\u0003\u000b\u0001\u0001\u0015!\u0003t\u0011%\t9\u0001\u0001a\u0001\n\u0013\tI\u0001C\u0005\u0002\u0012\u0001\u0001\r\u0011\"\u0003\u0002\u0014!A\u0011q\u0004\u0001!B\u0013\tY\u0001C\u0004\u0002\"\u0001!\t!a\t\t\u000f\u00055\u0002\u0001\"\u0001\u00020!9\u00111\u0007\u0001\u0005\u0002\u0005U\u0002bBA\"\u0001\u0011\u0005\u0011Q\t\u0005\b\u0003C\u0002A\u0011IA2\u0011\u001d\ti\t\u0001C!\u0003\u001fCq!!(\u0001\t\u0003\ny\nC\u0004\u0002(\u0002!\t%!+\t\u000f\u00055\u0006\u0001\"\u0011\u00020\"9\u00111\u0017\u0001\u0005B\u0005U\u0006bBA]\u0001\u0011\u0005\u00131\u0018\u0005\n\u0003#\u0004!\u0019!C)\u0003'Dq!!6\u0001A\u0003%1\rC\u0004\u0002X\u0002!\t!!7\b\u0013\u0005\r8&!A\t\u0002\u0005\u0015h\u0001\u0003\u0016,\u0003\u0003E\t!a:\t\r\u0019\u0014C\u0011AAx\u0011%\t\tPII\u0001\n\u0003\t\u0019\u0010C\u0005\u0003\n\t\n\n\u0011\"\u0001\u0002t\"I!1\u0002\u0012\u0012\u0002\u0013\u0005!Q\u0002\u0005\n\u0005#\u0011\u0013\u0013!C\u0001\u0005'A\u0011Ba\u0006##\u0003%\tA!\u0007\t\u0013\tu!%%A\u0005\u0002\t}!!E'pG.4U\r^2iKJ$\u0006N]3bI*\u0011A&L\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u00039\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001cA\u0011!gM\u0007\u0002W%\u0011Ag\u000b\u0002\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e\u0003)iwnY6MK\u0006$WM]\u000b\u0002oA\u0011!\u0007O\u0005\u0003s-\u0012!#T8dW2+\u0017\rZ3s\u000b:$\u0007k\\5oi\u0006YQn\\2l\u0019\u0016\fG-\u001a:!\u0003QiwnY6US\u0016\u00148\u000b^1uK6\u000b7\r[5oKV\tQ\b\u0005\u00023}%\u0011qh\u000b\u0002\u0015\u001b>\u001c7\u000eV5feN#\u0018\r^3NC\u000eD\u0017N\\3\u0002+5|7m\u001b+jKJ\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8fA\u0005I!/\u001a9mS\u000e\f\u0017\nZ\u000b\u0002\u0007B\u0011AiR\u0007\u0002\u000b*\ta)A\u0003tG\u0006d\u0017-\u0003\u0002I\u000b\n\u0019\u0011J\u001c;\u0002\u0015I,\u0007\u000f\\5dC&#\u0007%\u0001\u0005mK\u0006$WM]%e\u0003%aW-\u00193fe&#\u0007%\u0001\nfqB|g.\u001a8uS\u0006d')Y2l_\u001a4\u0007C\u0001(Y\u001b\u0005y%B\u0001)R\u0003\u0015)H/\u001b7t\u0015\t\u00116+\u0001\u0004d_6lwN\u001c\u0006\u0003]QS!!\u0016,\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0016aA8sO&\u0011\u0011l\u0014\u0002\u0013\u000bb\u0004xN\\3oi&\fGNQ1dW>4g-\u0001\tgC&dW\r\u001a)beRLG/[8ogB\u0011!\u0007X\u0005\u0003;.\u0012\u0001CR1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0002!A\fWo]3e!\u0006\u0014H/\u001b;j_:\u001c\bC\u0001\u001aa\u0013\t\t7F\u0001\tQCV\u001cX\r\u001a)beRLG/[8og\u0006q2m\u001c8gYV,g\u000e^%oi\u0016\u0014h.\u00197NKR\u0014\u0018nY:F]\u0006\u0014G.\u001a\t\u0003\t\u0012L!!Z#\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"\u0012\u0002[5kW2lgn\u001c9\u0011\u0005I\u0002\u0001\"B\u001b\u000e\u0001\u00049\u0004\"B\u001e\u000e\u0001\u0004i\u0004bB!\u000e!\u0003\u0005\ra\u0011\u0005\b\u00156\u0001\n\u00111\u0001D\u0011\u001daU\u0002%AA\u00025CqAW\u0007\u0011\u0002\u0003\u00071\fC\u0004_\u001bA\u0005\t\u0019A0\t\u000f\tl\u0001\u0013!a\u0001G\u00061\"/\u001a9mS\u000e\f\u0007+\u0019:uSRLwN\\*uCR,7/F\u0001t!\u0011!\u0018p_@\u000e\u0003UT!A^<\u0002\u000f5,H/\u00192mK*\u0011\u00010R\u0001\u000bG>dG.Z2uS>t\u0017B\u0001>v\u0005\ri\u0015\r\u001d\t\u0003yvl\u0011!U\u0005\u0003}F\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eE\u00023\u0003\u0003I1!a\u0001,\u00059\u0001\u0016M\u001d;ji&|gn\u0015;bi\u0016\fqC]3qY&\u001c\u0017\rU1si&$\u0018n\u001c8Ti\u0006$Xm\u001d\u0011\u0002%1\fG/Z:u\u000bB|7\r\u001b#fM\u0006,H\u000e^\u000b\u0003\u0003\u0017\u0001B\u0001RA\u0007\u0007&\u0019\u0011qB#\u0003\r=\u0003H/[8o\u0003Ya\u0017\r^3ti\u0016\u0003xn\u00195EK\u001a\fW\u000f\u001c;`I\u0015\fH\u0003BA\u000b\u00037\u00012\u0001RA\f\u0013\r\tI\"\u0012\u0002\u0005+:LG\u000fC\u0005\u0002\u001eE\t\t\u00111\u0001\u0002\f\u0005\u0019\u0001\u0010J\u0019\u0002'1\fG/Z:u\u000bB|7\r\u001b#fM\u0006,H\u000e\u001e\u0011\u0002\u001fM,GOU3qY&\u001c\u0017m\u0015;bi\u0016$b!!\u0006\u0002&\u0005%\u0002BBA\u0014'\u0001\u000710\u0001\bu_BL7\rU1si&$\u0018n\u001c8\t\r\u0005-2\u00031\u0001\u0000\u0003\u0015\u0019H/\u0019;f\u0003U\u0011X\r\u001d7jG\u0006\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016$2a`A\u0019\u0011\u0019\t9\u0003\u0006a\u0001w\u0006\u0001\"/Z:u_J,G+[3s'R\fG/\u001a\u000b\u0007\u0003+\t9$!\u000f\t\r\u0005\u001dR\u00031\u0001|\u0011\u001d\tY$\u0006a\u0001\u0003{\tQ\u0003\u001d:pa>\u001cX\r\u001a'pG\u0006dGj\\4Ti\u0006\u0014H\u000fE\u0002E\u0003\u007fI1!!\u0011F\u0005\u0011auN\\4\u0002\u001b\u0005$G\rU1si&$\u0018n\u001c8t)\u0019\t9%a\u0014\u0002^A)\u0011\u0011JA&w6\tq/C\u0002\u0002N]\u00141aU3u\u0011\u001d\t\tF\u0006a\u0001\u0003'\n!#\u001b8ji&\fGNR3uG\"\u001cF/\u0019;fgB9\u0011\u0011JA+w\u0006]\u0013B\u0001>x!\r\u0011\u0014\u0011L\u0005\u0004\u00037Z#!E%oSRL\u0017\r\u001c$fi\u000eD7\u000b^1uK\"1\u0011q\f\fA\u0002\r\fqBZ8sG\u0016$&/\u001e8dCRLwN\\\u0001\u0015aJ|7-Z:t!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0015\u0011\u0005\u0015\u00141PA?\u0003\u0003\u0003R\u0001RA\u0007\u0003O\u0002B!!\u001b\u0002x5\u0011\u00111\u000e\u0006\u0005\u0003[\ny'A\u0002m_\u001eTA!!\u001d\u0002t\u0005I\u0011N\u001c;fe:\fGn\u001d\u0006\u0004\u0003k\u001a\u0016aB:u_J\fw-Z\u0005\u0005\u0003s\nYGA\u0007M_\u001e\f\u0005\u000f]3oI&sgm\u001c\u0005\u0007\u0003O9\u0002\u0019A>\t\u000f\u0005}t\u00031\u0001\u0002>\u0005Ya-\u001a;dQ>3gm]3u\u0011\u001d\t\u0019i\u0006a\u0001\u0003\u000b\u000bQ\u0002]1si&$\u0018n\u001c8ECR\f\u0007\u0003BAD\u0003\u0013k\u0011\u0001A\u0005\u0004\u0003\u0017\u001b$!\u0003$fi\u000eDG)\u0019;b\u0003!!(/\u001e8dCR,G#B2\u0002\u0012\u0006M\u0005BBA\u00141\u0001\u00071\u0010C\u0004\u0002\u0016b\u0001\r!a&\u0002\u001fQ\u0014XO\\2bi&|gn\u0015;bi\u0016\u00042AMAM\u0013\r\tYj\u000b\u0002\u0016\u001f\u001a47/\u001a;UeVt7-\u0019;j_:\u001cF/\u0019;f\u0003]!(/\u001e8dCR,g)\u001e7ms\u0006sGm\u0015;beR\fE\u000f\u0006\u0004\u0002\u0016\u0005\u0005\u00161\u0015\u0005\u0007\u0003OI\u0002\u0019A>\t\u000f\u0005\u0015\u0016\u00041\u0001\u0002>\u00051qN\u001a4tKR\f1\u0002\\1uKN$X\t]8dQR!\u00111BAV\u0011\u0019\t9C\u0007a\u0001w\u0006qAn\\4Ti\u0006\u0014Ho\u00144gg\u0016$H\u0003BA\u001f\u0003cCa!a\n\u001c\u0001\u0004Y\u0018\u0001\u00047pO\u0016sGm\u00144gg\u0016$H\u0003BA\u001f\u0003oCa!a\n\u001d\u0001\u0004Y\u0018!E3oI>3gm]3u\r>\u0014X\t]8dQR1\u0011QXAf\u0003\u001b\u0004R\u0001RA\u0007\u0003\u007f\u0003B!!1\u0002H6\u0011\u00111\u0019\u0006\u0004%\u0006\u0015'B\u0001\u0017T\u0013\u0011\tI-a1\u0003\u001d=3gm]3u\u0003:$W\t]8dQ\"1\u0011qE\u000fA\u0002mDa!a4\u001e\u0001\u0004\u0019\u0015!B3q_\u000eD\u0017aH5t\u001f\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195TkB\u0004xN\u001d;fIV\t1-\u0001\u0011jg>3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i'V\u0004\bo\u001c:uK\u0012\u0004\u0013A\u0006<fe&4\u0017\u0010T1ti\u001a+Go\u00195fI\u0016\u0003xn\u00195\u0015\r\u0005U\u00111\\Ap\u0011\u0019\ti\u000e\ta\u0001w\u0006I\u0001/\u0019:uSRLwN\u001c\u0005\b\u0003C\u0004\u0003\u0019AA\u0006\u00035)\u0007\u0010]3di\u0016$W\t]8dQ\u0006\tRj\\2l\r\u0016$8\r[3s)\"\u0014X-\u00193\u0011\u0005I\u00123c\u0001\u0012\u0002jB\u0019A)a;\n\u0007\u00055XI\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003K\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aTCAA{U\r\u0019\u0015q_\u0016\u0003\u0003s\u0004B!a?\u0003\u00065\u0011\u0011Q \u0006\u0005\u0003\u007f\u0014\t!A\u0005v]\u000eDWmY6fI*\u0019!1A#\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\b\u0005u(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*TC\u0001B\bU\ri\u0015q_\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\tU!fA.\u0002x\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uI]*\"Aa\u0007+\u0007}\u000b90A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005O\u000b\u0003\u0005CQ3aYA|\u0001")
public class MockFetcherThread
extends AbstractFetcherThread {
    private final MockLeaderEndPoint mockLeader;
    private final MockTierStateMachine mockTierStateMachine;
    private final int replicaId;
    private final int leaderId;
    private final scala.collection.mutable.Map<TopicPartition, PartitionState> replicaPartitionStates;
    private Option<Object> latestEpochDefault;
    private final boolean isOffsetForLeaderEpochSupported;

    public static boolean $lessinit$greater$default$8() {
        return false;
    }

    public static PausedPartitions $lessinit$greater$default$7() {
        return new PausedPartitions();
    }

    public static FailedPartitions $lessinit$greater$default$6() {
        return new FailedPartitions();
    }

    public static ExponentialBackoff $lessinit$greater$default$5() {
        return MockFetcherThread$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return 1;
    }

    public static int $lessinit$greater$default$3() {
        return 0;
    }

    public MockLeaderEndPoint mockLeader() {
        return this.mockLeader;
    }

    public MockTierStateMachine mockTierStateMachine() {
        return this.mockTierStateMachine;
    }

    public int replicaId() {
        return this.replicaId;
    }

    public int leaderId() {
        return this.leaderId;
    }

    private scala.collection.mutable.Map<TopicPartition, PartitionState> replicaPartitionStates() {
        return this.replicaPartitionStates;
    }

    private Option<Object> latestEpochDefault() {
        return this.latestEpochDefault;
    }

    private void latestEpochDefault_$eq(Option<Object> x$1) {
        this.latestEpochDefault = x$1;
    }

    public void setReplicaState(TopicPartition topicPartition, PartitionState state) {
        this.replicaPartitionStates().put((Object)topicPartition, (Object)state);
    }

    public PartitionState replicaPartitionState(TopicPartition topicPartition) {
        return (PartitionState)this.replicaPartitionStates().getOrElse((Object)topicPartition, (Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(18).append("Unknown partition ").append(topicPartition).toString());
        });
    }

    public void restoreTierState(TopicPartition topicPartition, long proposedLocalLogStart) {
        this.replicaPartitionState(topicPartition).logEndOffset_$eq(proposedLocalLogStart);
        this.replicaPartitionState(topicPartition).highWatermark_$eq(proposedLocalLogStart);
    }

    public Set<TopicPartition> addPartitions(Map<TopicPartition, InitialFetchState> initialFetchStates, boolean forceTruncation) {
        this.latestEpochDefault_$eq((Option<Object>)(forceTruncation ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)0))));
        Set partitions = super.addPartitions(initialFetchStates);
        this.latestEpochDefault_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)));
        return partitions;
    }

    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
        PartitionState state = this.replicaPartitionState(topicPartition);
        if (this.mockLeader().isTruncationOnFetchSupported() && FetchResponse.isDivergingEpoch((FetchResponseData.PartitionData)partitionData)) {
            FetchResponseData.EpochEndOffset divergingEpoch = partitionData.divergingEpoch();
            this.truncateOnFetchResponse((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(topicPartition.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(divergingEpoch.epoch()).setEndOffset(divergingEpoch.endOffset()))})));
            return None$.MODULE$;
        }
        if (fetchOffset != state.logEndOffset()) {
            throw new RuntimeException(new StringBuilder(69).append("Offset mismatch for partition ").append(topicPartition).append(": ").append("fetched offset = ").append(fetchOffset).append(", log end offset = ").append(state.logEndOffset()).append(".").toString());
        }
        Iterable batches = CollectionConverters$.MODULE$.IterableHasAsScala(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData).batches()).asScala();
        LongRef maxTimestamp = LongRef.create((long)-1L);
        LongRef offsetOfMaxTimestamp = LongRef.create((long)-1L);
        LongRef lastOffset = LongRef.create((long)state.logEndOffset());
        ObjectRef lastEpoch = ObjectRef.create((Object)OptionalInt.empty());
        batches.foreach((Function1 & Serializable)batch -> {
            MockFetcherThread.$anonfun$processPartitionData$1(maxTimestamp, offsetOfMaxTimestamp, state, lastOffset, lastEpoch, batch);
            return BoxedUnit.UNIT;
        });
        state.logStartOffset_$eq(partitionData.logStartOffset());
        state.highWatermark_$eq(partitionData.highWatermark());
        return new Some((Object)new LogAppendInfo(fetchOffset, lastOffset.elem, (OptionalInt)lastEpoch.elem, maxTimestamp.elem, offsetOfMaxTimestamp.elem, Time.SYSTEM.milliseconds(), state.logStartOffset(), RecordValidationStats.EMPTY, CompressionType.NONE, FetchResponse.recordsSize((FetchResponseData.PartitionData)partitionData), BoxesRunTime.unboxToLong((Object)batches.headOption().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.lastOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L))));
    }

    public boolean truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        PartitionState state = this.replicaPartitionState(topicPartition);
        state.log_$eq((Buffer<RecordBatch>)((Buffer)state.log().takeWhile((Function1 & Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)MockFetcherThread.$anonfun$truncate$1(truncationState, batch)))));
        state.logEndOffset_$eq(BoxesRunTime.unboxToLong((Object)state.log().lastOption().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)MockFetcherThread.$anonfun$truncate$2(x$2))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> state.logStartOffset())));
        state.highWatermark_$eq(package$.MODULE$.min(state.highWatermark(), state.logEndOffset()));
        return true;
    }

    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        PartitionState state = this.replicaPartitionState(topicPartition);
        state.log().clear();
        state.logStartOffset_$eq(offset);
        state.logEndOffset_$eq(offset);
        state.highWatermark_$eq(offset);
    }

    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaPartitionState(topicPartition).log().lastOption().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.partitionLeaderEpoch())).orElse((Function0 & Serializable)() -> this.latestEpochDefault());
    }

    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaPartitionState(topicPartition).logStartOffset();
    }

    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaPartitionState(topicPartition).logEndOffset();
    }

    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        OffsetForLeaderEpochRequestData.OffsetForLeaderPartition epochData = new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(topicPartition.partition()).setLeaderEpoch(epoch);
        OffsetForLeaderEpochResponseData.EpochEndOffset result = this.mockLeader().lookupEndOffsetForEpoch(topicPartition, epochData, this.replicaPartitionState(topicPartition));
        if (result.endOffset() == -1L) {
            return None$.MODULE$;
        }
        return new Some((Object)new OffsetAndEpoch(result.endOffset(), result.leaderEpoch()));
    }

    public boolean isOffsetForLeaderEpochSupported() {
        return this.isOffsetForLeaderEpochSupported;
    }

    public void verifyLastFetchedEpoch(TopicPartition partition, Option<Object> expectedEpoch) {
        if (this.mockLeader().isTruncationOnFetchSupported()) {
            Assertions.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)this.fetchState(partition).map((Function1 & Serializable)x$4 -> x$4.state()));
            Assertions.assertEquals(expectedEpoch, (Object)this.fetchState(partition).flatMap((Function1 & Serializable)x$5 -> x$5.lastFetchedEpoch()));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$processPartitionData$1(LongRef maxTimestamp$1, LongRef offsetOfMaxTimestamp$1, PartitionState state$1, LongRef lastOffset$1, ObjectRef lastEpoch$1, RecordBatch batch) {
        batch.ensureValid();
        if (batch.maxTimestamp() > maxTimestamp$1.elem) {
            maxTimestamp$1.elem = batch.maxTimestamp();
            offsetOfMaxTimestamp$1.elem = batch.baseOffset();
        }
        state$1.log().append((Object)batch);
        state$1.logEndOffset_$eq(batch.nextOffset());
        lastOffset$1.elem = batch.lastOffset();
        lastEpoch$1.elem = OptionalInt.of(batch.partitionLeaderEpoch());
    }

    public static final /* synthetic */ boolean $anonfun$truncate$1(OffsetTruncationState truncationState$1, RecordBatch batch) {
        return batch.lastOffset() < truncationState$1.offset();
    }

    public static final /* synthetic */ long $anonfun$truncate$2(RecordBatch x$2) {
        return x$2.lastOffset() + 1L;
    }

    public MockFetcherThread(MockLeaderEndPoint mockLeader, MockTierStateMachine mockTierStateMachine, int replicaId, int leaderId, ExponentialBackoff exponentialBackoff, FailedPartitions failedPartitions, PausedPartitions pausedPartitions, boolean confluentInternalMetricsEnable) {
        this.mockLeader = mockLeader;
        this.mockTierStateMachine = mockTierStateMachine;
        this.replicaId = replicaId;
        this.leaderId = leaderId;
        BrokerTopicStats x$8 = new BrokerTopicStats(confluentInternalMetricsEnable, Optional.empty());
        boolean x$9 = true;
        Map x$10 = (Map)scala.collection.Map$.MODULE$.empty();
        super("mock-fetcher", "mock-fetcher", (LeaderEndPoint)mockLeader, failedPartitions, pausedPartitions, exponentialBackoff, (TierStateMachine)mockTierStateMachine, x$9, x$8, x$10);
        this.replicaPartitionStates = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.latestEpochDefault = new Some((Object)BoxesRunTime.boxToInteger((int)0));
        this.isOffsetForLeaderEpochSupported = true;
    }
}

