/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.opentelemetry.context.Context;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import kafka.server.ControllerNodeProvider;
import kafka.server.NodeToControllerQueueItem;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.server.ControllerRequestCompletionHandler;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.apache.kafka.server.util.MockTime;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005]d\u0001\u0002\u000e\u001c\u0001\u0001B\u0001b\r\u0001\u0003\u0006\u0004%\t\u0001\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005k!AA\b\u0001B\u0001B\u0003%Q\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0011!A\u0005A!A!\u0002\u0013I\u0005\u0002\u0003'\u0001\u0005\u000b\u0007I\u0011A'\t\u0011Q\u0003!\u0011!Q\u0001\n9C\u0001\"\u0016\u0001\u0003\u0006\u0004%\t!\u0014\u0005\t-\u0002\u0011\t\u0011)A\u0005\u001d\")q\u000b\u0001C\u00011\"9\u0001\r\u0001b\u0001\n\u0003\t\u0007B\u00027\u0001A\u0003%!\rC\u0003n\u0001\u0011\u0005c\u000eC\u0003s\u0001\u0011\u0005c\u000eC\u0003t\u0001\u0011\u0005C\u000f\u0003\u0004I\u0001\u0011\u0005\u0013\u0011\u0006\u0005\t\u0003g\u0001A\u0011A\u000e\u00026!1\u0011Q\t\u0001\u0005\u00029Da!a\u0012\u0001\t\u0003iu!CA%7\u0005\u0005\t\u0012AA&\r!Q2$!A\t\u0002\u00055\u0003BB,\u0016\t\u0003\t)\u0006C\u0005\u0002XU\t\n\u0011\"\u0001\u0002Z!I\u0011qN\u000b\u0012\u0002\u0013\u0005\u0011\u0011\u000f\u0005\n\u0003k*\u0012\u0013!C\u0001\u0003c\u0012!%T8dW:{G-\u001a+p\u0007>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014(B\u0001\u000f\u001e\u0003\u0019\u0019XM\u001d<fe*\ta$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001\t\u0013\u0006\u0005\u0002#O5\t1E\u0003\u0002%K\u0005!A.\u00198h\u0015\u00051\u0013\u0001\u00026bm\u0006L!\u0001K\u0012\u0003\r=\u0013'.Z2u!\tQ\u0013'D\u0001,\u0015\taBF\u0003\u0002\u001f[)\u0011afL\u0001\u0007CB\f7\r[3\u000b\u0003A\n1a\u001c:h\u0013\t\u00114F\u0001\u0010O_\u0012,Gk\\\"p]R\u0014x\u000e\u001c7fe\u000eC\u0017M\u001c8fY6\u000bg.Y4fe\u000611\r\\5f]R,\u0012!\u000e\t\u0003mej\u0011a\u000e\u0006\u0003q1\nqa\u00197jK:$8/\u0003\u0002;o\tQQj\\2l\u00072LWM\u001c;\u0002\u000f\rd\u0017.\u001a8uA\u0005!A/[7f!\tq\u0014)D\u0001@\u0015\t\u00015&\u0001\u0003vi&d\u0017B\u0001\"@\u0005!iunY6US6,\u0017AF2p]R\u0014x\u000e\u001c7fe:{G-\u001a)s_ZLG-\u001a:\u0011\u0005\u00153U\"A\u000e\n\u0005\u001d[\"AF\"p]R\u0014x\u000e\u001c7fe:{G-\u001a)s_ZLG-\u001a:\u0002+\r|g\u000e\u001e:pY2,'/\u00119j-\u0016\u00148/[8ogB\u0011aGS\u0005\u0003\u0017^\u0012qBT8eK\u0006\u0003\u0018NV3sg&|gn]\u0001\u000fe\u0016$(/\u001f+j[\u0016|W\u000f^'t+\u0005q\u0005CA(S\u001b\u0005\u0001&\"A)\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0003&aA%oi\u0006y!/\u001a;ssRKW.Z8vi6\u001b\b%\u0001\tsKF,Xm\u001d;US6,w.\u001e;Ng\u0006\t\"/Z9vKN$H+[7f_V$Xj\u001d\u0011\u0002\rqJg.\u001b;?)\u001dI&l\u0017/^=~\u0003\"!\u0012\u0001\t\u000bMR\u0001\u0019A\u001b\t\u000bqR\u0001\u0019A\u001f\t\u000b\rS\u0001\u0019\u0001#\t\u000f!S\u0001\u0013!a\u0001\u0013\"9AJ\u0003I\u0001\u0002\u0004q\u0005bB+\u000b!\u0003\u0005\rAT\u0001\fk:\u001cXM\u001c;Rk\u0016,X-F\u0001c!\r\u0019w-[\u0007\u0002I*\u0011QMZ\u0001\u000bG>t7-\u001e:sK:$(B\u0001!&\u0013\tAGMA\u000bD_:\u001cWO\u001d:f]Rd\u0015N\\6fI\u0012+\u0017/^3\u0011\u0005\u0015S\u0017BA6\u001c\u0005equ\u000eZ3U_\u000e{g\u000e\u001e:pY2,'/U;fk\u0016LE/Z7\u0002\u0019Ut7/\u001a8u#V,W/\u001a\u0011\u0002\u000bM$\u0018M\u001d;\u0015\u0003=\u0004\"a\u00149\n\u0005E\u0004&\u0001B+oSR\f\u0001b\u001d5vi\u0012|wO\\\u0001\fg\u0016tGMU3rk\u0016\u001cH\u000f\u0006\u0003pk\u0006}\u0001\"\u0002<\u0010\u0001\u00049\u0018a\u0002:fcV,7\u000f\u001e\u0019\u0004q\u00065\u0001#B=\u0002\u0004\u0005%aB\u0001>\u0000\u001b\u0005Y(B\u0001?~\u0003!\u0011X-];fgR\u001c(B\u0001@-\u0003\u0019\u0019w.\\7p]&\u0019\u0011\u0011A>\u0002\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgRLA!!\u0002\u0002\b\t9!)^5mI\u0016\u0014(bAA\u0001wB!\u00111BA\u0007\u0019\u0001!1\"a\u0004v\u0003\u0003\u0005\tQ!\u0001\u0002\u0012\t\u0019q\fJ\u0019\u0012\t\u0005M\u0011\u0011\u0004\t\u0004\u001f\u0006U\u0011bAA\f!\n9aj\u001c;iS:<\u0007c\u0001>\u0002\u001c%\u0019\u0011QD>\u0003\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgRDq!!\t\u0010\u0001\u0004\t\u0019#\u0001\u0005dC2d'-Y2l!\rQ\u0013QE\u0005\u0004\u0003OY#AI\"p]R\u0014x\u000e\u001c7feJ+\u0017/^3ti\u000e{W\u000e\u001d7fi&|g\u000eS1oI2,'\u000f\u0006\u0002\u0002,A)\u0011QFA\u0018\u00136\ta-C\u0002\u00022\u0019\u0014\u0001b\u00149uS>t\u0017\r\\\u0001\u000fQ\u0006tG\r\\3SKN\u0004xN\\:f)\u0011\t9$a\u0011\u0015\u0007=\fI\u0004C\u0004\u0002<E\u0001\r!!\u0010\u0002\u0011I,7\u000f]8og\u0016\u00042ANA \u0013\r\t\te\u000e\u0002\u000f\u00072LWM\u001c;SKN\u0004xN\\:f\u0011\u00151\u0018\u00031\u0001j\u0003\u0011\u0001x\u000e\u001c7\u0002'A,g\u000eZ5oOJ+\u0017/^3ti\u000e{WO\u001c;\u0002E5{7m\u001b(pI\u0016$vnQ8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s!\t)UcE\u0002\u0016\u0003\u001f\u00022aTA)\u0013\r\t\u0019\u0006\u0015\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005-\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0002\\)\u001a\u0011*!\u0018,\u0005\u0005}\u0003\u0003BA1\u0003Wj!!a\u0019\u000b\t\u0005\u0015\u0014qM\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u001bQ\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003[\n\u0019GA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*TCAA:U\rq\u0015QL\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c")
public class MockNodeToControllerChannelManager
implements NodeToControllerChannelManager {
    private final MockClient client;
    private final MockTime time;
    private final ControllerNodeProvider controllerNodeProvider;
    private final NodeApiVersions controllerApiVersions;
    private final int retryTimeoutMs;
    private final int requestTimeoutMs;
    private final ConcurrentLinkedDeque<NodeToControllerQueueItem> unsentQueue;

    public static int $lessinit$greater$default$6() {
        return 30000;
    }

    public static int $lessinit$greater$default$5() {
        return 60000;
    }

    public static NodeApiVersions $lessinit$greater$default$4() {
        return NodeApiVersions.create();
    }

    public MockClient client() {
        return this.client;
    }

    public int retryTimeoutMs() {
        return this.retryTimeoutMs;
    }

    public int requestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public ConcurrentLinkedDeque<NodeToControllerQueueItem> unsentQueue() {
        return this.unsentQueue;
    }

    public void start() {
    }

    public void shutdown() {
    }

    public void sendRequest(AbstractRequest.Builder<? extends AbstractRequest> request, ControllerRequestCompletionHandler callback) {
        this.unsentQueue().add(new NodeToControllerQueueItem(this.time.milliseconds(), request, callback, Context.current()));
    }

    public Optional<NodeApiVersions> controllerApiVersions() {
        return Optional.of(this.controllerApiVersions);
    }

    public void handleResponse(NodeToControllerQueueItem request, ClientResponse response) {
        if (response.authenticationException() != null || response.versionMismatch() != null) {
            request.callback().onComplete(response);
            return;
        }
        if (response.wasDisconnected() || response.responseBody().errorCounts().containsKey(Errors.NOT_CONTROLLER)) {
            this.unsentQueue().addFirst(request);
            return;
        }
        request.callback().onComplete(response);
    }

    public void poll() {
        Iterator<NodeToControllerQueueItem> unsentIterator = this.unsentQueue().iterator();
        boolean canSend = true;
        while (canSend && unsentIterator.hasNext()) {
            NodeToControllerQueueItem queueItem = unsentIterator.next();
            if (this.time.milliseconds() - queueItem.createdTimeMs() >= (long)this.retryTimeoutMs()) {
                queueItem.callback().onTimeout();
                unsentIterator.remove();
                continue;
            }
            Option option = this.controllerNodeProvider.getControllerInfo().node();
            if (option instanceof Some) {
                Node controller = (Node)((Some)option).value();
                if (this.client().ready(controller, this.time.milliseconds())) {
                    ClientRequest clientRequest = this.client().newClientRequest(controller.idString(), queueItem.request(), queueItem.createdTimeMs(), true, this.requestTimeoutMs(), response -> this.handleResponse(queueItem, response));
                    this.client().send(clientRequest, this.time.milliseconds());
                    unsentIterator.remove();
                    continue;
                }
            }
            canSend = false;
        }
        this.client().poll(0L, this.time.milliseconds());
    }

    public int pendingRequestCount() {
        return this.unsentQueue().size();
    }

    public MockNodeToControllerChannelManager(MockClient client, MockTime time, ControllerNodeProvider controllerNodeProvider, NodeApiVersions controllerApiVersions, int retryTimeoutMs, int requestTimeoutMs) {
        this.client = client;
        this.time = time;
        this.controllerNodeProvider = controllerNodeProvider;
        this.controllerApiVersions = controllerApiVersions;
        this.retryTimeoutMs = retryTimeoutMs;
        this.requestTimeoutMs = requestTimeoutMs;
        this.unsentQueue = new ConcurrentLinkedDeque();
        client.setNodeApiVersions(controllerApiVersions);
    }
}

