/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.kafka.availability.NetworkAvailabilityManager;
import io.confluent.kafka.availability.NetworkAvailabilityManager$;
import java.io.Serializable;
import java.util.Properties;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.NetworkAvailabilityManagerRequestTest;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005Y2A!\u0002\u0004\u0001\u0017!)\u0001\u0003\u0001C\u0001#!)1\u0003\u0001C!)!)Q\u0005\u0001C\u0001M!)A\u0007\u0001C\u0001M\t1d*\u001a;x_J\\\u0017I^1jY\u0006\u0014\u0017\u000e\\5us6\u000bg.Y4fe\"+\u0017\r\u001c;iG\",7m\u001b+f]\u0006tGOU3rk\u0016\u001cH\u000fV3ti*\u0011q\u0001C\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003%\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011QBD\u0007\u0002\r%\u0011qB\u0002\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\u00061A(\u001b8jiz\"\u0012A\u0005\t\u0003\u001b\u0001\tqC\u0019:pW\u0016\u0014\bK]8qKJ$\u0018p\u0014<feJLG-Z:\u0015\u0005UY\u0002C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"\u0001B+oSRDQ\u0001\b\u0002A\u0002u\t!\u0002\u001d:pa\u0016\u0014H/[3t!\tq2%D\u0001 \u0015\t\u0001\u0013%\u0001\u0003vi&d'\"\u0001\u0012\u0002\t)\fg/Y\u0005\u0003I}\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0003Q!Xm\u001d;FqR,'O\\1m%\u0016\fX/Z:ugR\tQ\u0003\u000b\u0002\u0004QA\u0011\u0011FM\u0007\u0002U)\u00111\u0006L\u0001\u0004CBL'BA\u0017/\u0003\u001dQW\u000f]5uKJT!a\f\u0019\u0002\u000b),h.\u001b;\u000b\u0003E\n1a\u001c:h\u0013\t\u0019$F\u0001\u0003UKN$\u0018a\u0006;fgRDU-\u00197uQ\u000eCWmY6SKF,Xm\u001d;tQ\t!\u0001\u0006")
public class NetworkAvailabilityManagerHealthcheckTenantRequestTest
extends BaseRequestTest {
    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), NetworkAvailabilityManagerRequestTest.TestAuthorizer.class.getName());
        properties.put(KafkaConfig$.MODULE$.PrincipalBuilderClassProp(), NetworkAvailabilityManagerRequestTest.TestPrincipalBuilderReturningHealthcheckMultitenant.class.getName());
        properties.put(KafkaConfig$.MODULE$.NetworkHealthManagerExternalListenerNameProp(), "PLAINTEXT");
    }

    @Test
    public void testExternalRequests() {
        String topic = "topic";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Map<Object, Object> partitionLeaders = this.createTopicWithAssignment(topic, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 1})))}))), this.createTopicWithAssignment$default$3());
        TestUtils$.MODULE$.waitForAllPartitionsMetadata(this.servers(), topic, 2);
        Assertions.assertEquals((int)1, (int)BoxesRunTime.unboxToInt((Object)partitionLeaders.apply((Object)BoxesRunTime.boxToInteger((int)0))));
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)partitionLeaders.apply((Object)BoxesRunTime.boxToInteger((int)1))));
        ProducerRecord record1 = new ProducerRecord(topic, Predef$.MODULE$.int2Integer(0), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        ProducerRecord record2 = new ProducerRecord(topic, Predef$.MODULE$.int2Integer(1), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        ArrayBuffer futures = new ArrayBuffer();
        futures.$plus$eq((Object)producer.send(record1));
        futures.$plus$eq((Object)producer.send(record2));
        futures.foreach((Function1 & Serializable)x$1 -> (RecordMetadata)x$1.get());
        this.servers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Assertions.assertEquals((long)0L, (long)((NetworkAvailabilityManager)this.brokerSocketServer(i).requestCallbackManager()).externalRequests());
            Assertions.assertEquals((long)0L, (long)((NetworkAvailabilityManager)this.brokerSocketServer(i).requestCallbackManager()).connectionPings());
            Assertions.assertEquals((long)0L, (long)((NetworkAvailabilityManager)this.brokerSocketServer(i).requestCallbackManager()).healthCheckRequests());
        });
    }

    @Test
    public void testHealthCheckRequests() {
        String topic = "topic";
        Properties producerProperties = new Properties();
        producerProperties.setProperty("client.id", NetworkAvailabilityManager$.MODULE$.HEALTH_CHECK_CLIENT_ID());
        KafkaProducer producer = this.createProducer(new ByteArraySerializer(), new ByteArraySerializer(), producerProperties);
        scala.collection.immutable.Map<Object, Object> partitionLeaders = this.createTopicWithAssignment(topic, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 1})))}))), this.createTopicWithAssignment$default$3());
        TestUtils$.MODULE$.waitForAllPartitionsMetadata(this.servers(), topic, 2);
        Assertions.assertEquals((int)1, (int)BoxesRunTime.unboxToInt((Object)partitionLeaders.apply((Object)BoxesRunTime.boxToInteger((int)0))));
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)partitionLeaders.apply((Object)BoxesRunTime.boxToInteger((int)1))));
        ProducerRecord record1 = new ProducerRecord(topic, Predef$.MODULE$.int2Integer(0), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        ProducerRecord record2 = new ProducerRecord(topic, Predef$.MODULE$.int2Integer(1), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        ArrayBuffer futures = new ArrayBuffer();
        futures.$plus$eq((Object)producer.send(record1));
        futures.$plus$eq((Object)producer.send(record2));
        futures.foreach((Function1 & Serializable)x$2 -> (RecordMetadata)x$2.get());
        Assertions.assertTrue((((NetworkAvailabilityManager)this.brokerSocketServer(0).requestCallbackManager()).healthCheckRequests() > 0L ? 1 : 0) != 0);
        this.servers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Assertions.assertEquals((long)0L, (long)((NetworkAvailabilityManager)this.brokerSocketServer(i).requestCallbackManager()).externalRequests());
            Assertions.assertEquals((long)0L, (long)((NetworkAvailabilityManager)this.brokerSocketServer(i).requestCallbackManager()).connectionPings());
        });
    }
}

