/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.server.ConfluentObserverTest;
import kafka.server.ConfluentObserverTest$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r4A\u0001E\t\u0001-!)1\u0004\u0001C\u00019!9a\u0004\u0001a\u0001\n\u0003y\u0002bB\u0016\u0001\u0001\u0004%\t\u0001\f\u0005\u0007g\u0001\u0001\u000b\u0015\u0002\u0011\t\u000fQ\u0002!\u0019!C\u0001k!1\u0011\b\u0001Q\u0001\nYBqA\u000f\u0001C\u0002\u0013\u0005Q\u0007\u0003\u0004<\u0001\u0001\u0006IA\u000e\u0005\u0006y\u0001!\t%\u0010\u0005\u0006!\u0002!\t%\u0015\u0005\u0006-\u0002!\t!\u0015\u0005\u00067\u0002!\t!\u0015\u0005\u0006;\u0002!\t!\u0015\u0005\u0006?\u0002!\t!\u0015\u0005\u0006C\u0002!\t!\u0015\u0002\u001a\u001f\n\u001cXM\u001d<fe\u000e{W\u000e]1uS\nLG.\u001b;z)\u0016\u001cHO\u0003\u0002\u0013'\u000511/\u001a:wKJT\u0011\u0001F\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0003\u0005\u0002\u001935\t\u0011#\u0003\u0002\u001b#\t\t\u0012+^8sk6$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\r\u0001\u0003\u001d\u0019XM\u001d<feN,\u0012\u0001\t\t\u0004C\u0019BS\"\u0001\u0012\u000b\u0005\r\"\u0013AC2pY2,7\r^5p]*\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(E\t\u00191+Z9\u0011\u0005aI\u0013B\u0001\u0016\u0012\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002\u0017M,'O^3sg~#S-\u001d\u000b\u0003[E\u0002\"AL\u0018\u000e\u0003\u0011J!\u0001\r\u0013\u0003\tUs\u0017\u000e\u001e\u0005\be\r\t\t\u00111\u0001!\u0003\rAH%M\u0001\tg\u0016\u0014h/\u001a:tA\u00059!M]8lKJ\fT#\u0001\u001c\u0011\u00059:\u0014B\u0001\u001d%\u0005\rIe\u000e^\u0001\tEJ|7.\u001a:2A\u00059!M]8lKJ\u0014\u0014\u0001\u00032s_.,'O\r\u0011\u0002\u000bM,G/\u00169\u0015\u00055r\u0004\"B \n\u0001\u0004\u0001\u0015\u0001\u0003;fgRLeNZ8\u0011\u0005\u0005SU\"\u0001\"\u000b\u0005\r#\u0015aA1qS*\u0011QIR\u0001\bUV\u0004\u0018\u000e^3s\u0015\t9\u0005*A\u0003kk:LGOC\u0001J\u0003\ry'oZ\u0005\u0003\u0017\n\u0013\u0001\u0002V3ti&sgm\u001c\u0015\u0003\u00135\u0003\"!\u0011(\n\u0005=\u0013%A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eF\u0001.Q\tQ1\u000b\u0005\u0002B)&\u0011QK\u0011\u0002\n\u0003\u001a$XM]#bG\"\fA\u0007^3ti\u000e\u000bg.V:f%\u0016\u0004H.[2b!2\f7-Z7f]R\u001cuN\\:ue\u0006Lg\u000e^,ji\"|W\u000f^(cg\u0016\u0014h/\u001a:tQ\tY\u0001\f\u0005\u0002B3&\u0011!L\u0011\u0002\u0005)\u0016\u001cH/A\u0010uKN$8)\u00198SK\u0006\u001c8/[4o)>,U\u000e\u001d;z\u001f\n\u001cXM\u001d<feND#\u0001\u0004-\u0002iQ,7\u000f^\"b]:|G/V:f%\u0016\u0004H.[2b!2\f7-Z7f]R\u001cuN\\:ue\u0006Lg\u000e^,ji\"|%m]3sm\u0016\u00148\u000f\u000b\u0002\u000e1\u0006iB/Z:u\u0007\u0006tgn\u001c;SK\u0006\u001c8/[4o)>|%m]3sm\u0016\u00148\u000f\u000b\u0002\u000f1\u0006yC/Z:u\u0007\u0006tgn\u001c;F]\u0006\u0014G.Z(cg\u0016\u0014h/\u001a:t)\"\u0014x.^4i\u00032$XM]\"p]\u001aLw-\u0011)Jg\"\u0012q\u0002\u0017")
public class ObserverCompatibilityTest
extends QuorumTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.empty();
    private final int broker1;
    private final int broker2;

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public int broker1() {
        return this.broker1;
    }

    public int broker2() {
        return this.broker2;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        scala.collection.immutable.Map rack = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker1())), (Object)"a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker2())), (Object)"b")}));
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(2, this.zkConnect(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false);
        this.servers_$eq((Seq<KafkaServer>)((Seq)brokerConfigs.map((Function1 & Serializable)config -> {
            void createServer_createServer_createServer_startup;
            void createServer_time;
            config.setProperty(KafkaConfig$.MODULE$.RackProp(), (String)rack.apply((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(config.getProperty(KafkaConfig$.MODULE$.BrokerIdProp()))))));
            config.setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "2.3");
            Time time = Time.SYSTEM;
            KafkaConfig createServer_config = KafkaConfig$.MODULE$.fromProps(config);
            TestUtils$ createServer_this = TestUtils$.MODULE$;
            None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
            boolean bl = true;
            int createServer_createServer_createServer_licenseTopicReplicationFactor = 0;
            return createServer_this.createServer(createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_licenseTopicReplicationFactor, (boolean)createServer_createServer_createServer_startup, false);
        })));
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers(), true);
        super.tearDown();
    }

    @Test
    public void testCanUseReplicaPlacementConstraintWithoutObservers() {
        try (AdminClient resource_resource = (AdminClient)Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava());){
            ObserverCompatibilityTest.$anonfun$testCanUseReplicaPlacementConstraintWithoutObservers$1(resource_resource);
        }
    }

    @Test
    public void testCanReassignToEmptyObservers() {
        try (AdminClient resource_resource = (AdminClient)Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava());){
            ObserverCompatibilityTest.$anonfun$testCanReassignToEmptyObservers$1(resource_resource);
        }
    }

    @Test
    public void testCannotUseReplicaPlacementConstraintWithObservers() {
        try (AdminClient resource_resource = (AdminClient)Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava());){
            ObserverCompatibilityTest.$anonfun$testCannotUseReplicaPlacementConstraintWithObservers$1(resource_resource);
        }
    }

    @Test
    public void testCannotReassignToObservers() {
        try (AdminClient resource_resource = (AdminClient)Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava());){
            ObserverCompatibilityTest.$anonfun$testCannotReassignToObservers$1(this, resource_resource);
        }
    }

    @Test
    public void testCannotEnableObserversThroughAlterConfigAPIs() {
        try (AdminClient resource_resource = (AdminClient)Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava());){
            ObserverCompatibilityTest.$anonfun$testCannotEnableObserversThroughAlterConfigAPIs$1(resource_resource);
        }
    }

    public static final /* synthetic */ Void $anonfun$testCanUseReplicaPlacementConstraintWithoutObservers$1(AdminClient client) {
        String topic = "observer-topic";
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.placement.constraints"), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new ConfluentObserverTest.BasicConstraint(1, "a"), (Option<ConfluentObserverTest.BasicConstraint>)None$.MODULE$))}))).asJava());
        return (Void)client.createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
    }

    public static final /* synthetic */ void $anonfun$testCanReassignToEmptyObservers$1(AdminClient client) {
        String topic = "observer-topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.of(Predef$.MODULE$.short2Short((short)2)));
        client.createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        scala.collection.immutable.Seq replicas = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)client.describeTopics((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).asJava()).allTopicNames().get()).asScala().values().flatMap((Function1 & Serializable)x$1 -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(x$1.partitions()).asScala().flatMap((Function1 & Serializable)x$2 -> CollectionConverters$.MODULE$.ListHasAsScala(x$2.replicas()).asScala()))).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id()))).toSeq();
        Seq swappedBrokers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{BoxesRunTime.unboxToInt((Object)replicas.apply(1)), BoxesRunTime.unboxToInt((Object)replicas.apply(0))}));
        client.alterPartitionReassignments(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)swappedBrokers, (Seq<Object>)Nil$.MODULE$))}))).asJava()).all().get();
        TestUtils$.MODULE$.waitForReplicasAssigned((Admin)client, topicPartition, (Seq<Object>)swappedBrokers);
    }

    public static final /* synthetic */ Throwable $anonfun$testCannotUseReplicaPlacementConstraintWithObservers$1(AdminClient client) {
        String topic = "observer-topic";
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.placement.constraints"), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new ConfluentObserverTest.BasicConstraint(1, "a"), (Option<ConfluentObserverTest.BasicConstraint>)new Some((Object)new ConfluentObserverTest.BasicConstraint(1, "b"))))}))).asJava());
        return TestUtils.assertFutureError((Future)client.createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all(), InvalidReplicaAssignmentException.class);
    }

    public static final /* synthetic */ Throwable $anonfun$testCannotReassignToObservers$1(ObserverCompatibilityTest $this, AdminClient client) {
        String topic = "observer-topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        client.createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        return TestUtils.assertFutureError((Future)client.alterPartitionReassignments(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.broker1()}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.broker2()})))))}))).asJava()).all(), InvalidReplicaAssignmentException.class);
    }

    public static final /* synthetic */ Throwable $anonfun$testCannotEnableObserversThroughAlterConfigAPIs$1(AdminClient client) {
        String topic = "observer-topic";
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        client.createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        Properties configUpdate = new Properties();
        configUpdate.setProperty("confluent.placement.constraints", ConfluentObserverTest$.MODULE$.basicTopicPlacement(new ConfluentObserverTest.BasicConstraint(1, "a"), (Option<ConfluentObserverTest.BasicConstraint>)new Some((Object)new ConfluentObserverTest.BasicConstraint(1, "b"))));
        TestUtils.assertFutureError((Future)ConfluentObserverTest$.MODULE$.alterTopicConfigs((Admin)client, topic, configUpdate).all(), InvalidConfigurationException.class);
        return TestUtils.assertFutureError((Future)TestUtils$.MODULE$.incrementalAlterTopicConfigs((Admin)client, topic, configUpdate, AlterConfigOp.OpType.SET).all(), InvalidConfigurationException.class);
    }

    public ObserverCompatibilityTest() {
        this.broker1 = 0;
        this.broker2 = 1;
    }

    public static final /* synthetic */ Object $anonfun$testCanReassignToEmptyObservers$1$adapted(AdminClient client) {
        ObserverCompatibilityTest.$anonfun$testCanReassignToEmptyObservers$1(client);
        return BoxedUnit.UNIT;
    }
}

