/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.concurrent.TimeUnit;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ControllerMutationQuotaManager;
import kafka.server.PermissiveControllerMutationQuota;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.TokenBucket;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00192Aa\u0001\u0003\u0001\u0013!)\u0001\u0003\u0001C\u0001#!)A\u0003\u0001C\u0001+\t)\u0003+\u001a:nSN\u001c\u0018N^3D_:$(o\u001c7mKJlU\u000f^1uS>t\u0017+^8uCR+7\u000f\u001e\u0006\u0003\u000b\u0019\taa]3sm\u0016\u0014(\"A\u0004\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0003\t\u0003\u00179i\u0011\u0001\u0004\u0006\u0002\u001b\u0005)1oY1mC&\u0011q\u0002\u0004\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0011\u0002CA\n\u0001\u001b\u0005!\u0011\u0001\n;fgR\u001cuN\u001c;s_2dWM]'vi\u0006$\u0018n\u001c8Rk>$\u0018MV5pY\u0006$\u0018n\u001c8\u0015\u0003Y\u0001\"aC\f\n\u0005aa!\u0001B+oSRD#A\u0001\u000e\u0011\u0005m!S\"\u0001\u000f\u000b\u0005uq\u0012aA1qS*\u0011q\u0004I\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\t#%A\u0003kk:LGOC\u0001$\u0003\ry'oZ\u0005\u0003Kq\u0011A\u0001V3ti\u0002")
public class PermissiveControllerMutationQuotaTest {
    /*
     * WARNING - void declaration
     */
    @Test
    public void testControllerMutationQuotaViolation() {
        void add_stat;
        MockTime time = new MockTime(0L, System.currentTimeMillis(), 0L);
        Metrics metrics = new Metrics((Time)time);
        double upperBound_upperBound = 10.0;
        Sensor sensor = metrics.sensor("sensor", new MetricConfig().quota(new Quota(upperBound_upperBound, true)).timeWindow(1L, TimeUnit.SECONDS).samples(10), new Sensor[0]);
        MetricName metricName = metrics.metricName("rate", "test-group");
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(10, 1, ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L, 0, Long.MAX_VALUE);
        ControllerMutationQuotaManager quotaManager = new ControllerMutationQuotaManager(config, metrics, (Time)time, "", (Option)None$.MODULE$);
        TokenBucket tokenBucket = new TokenBucket();
        if (sensor == null) {
            throw null;
        }
        tokenBucket = null;
        Assertions.assertTrue((boolean)sensor.add(metricName, (MeasurableStat)add_stat, null));
        PermissiveControllerMutationQuota quota = new PermissiveControllerMutationQuota((Time)time, sensor, quotaManager);
        Assertions.assertFalse((boolean)quota.isExceeded());
        quota.record(90.0);
        Assertions.assertFalse((boolean)quota.isExceeded());
        Assertions.assertEquals((int)0, (int)quota.throttleTime());
        quota.record(90.0);
        Assertions.assertFalse((boolean)quota.isExceeded());
        Assertions.assertEquals((int)8000, (int)quota.throttleTime());
        quota.record(90.0);
        Assertions.assertFalse((boolean)quota.isExceeded());
        Assertions.assertEquals((int)17000, (int)quota.throttleTime());
        time.sleep(5000L);
        Assertions.assertEquals((int)12000, (int)quota.throttleTime());
        metrics.close();
    }
}

