/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.api.IntegrationTestHarness;
import kafka.cluster.PartitionListener;
import kafka.server.AbstractFetcherThread;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaFetcherThread;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.opentest4j.AssertionFailedError;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileLongRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005c\u0001B\n\u0015\u0001eAQ\u0001\t\u0001\u0005\u0002\u0005BQ\u0001\n\u0001\u0005R\u0015Bq\u0001\f\u0001C\u0002\u0013\u0005S\u0006\u0003\u00047\u0001\u0001\u0006IA\f\u0005\bo\u0001\u0011\r\u0011\"\u00039\u0011\u0019y\u0004\u0001)A\u0005s!9\u0001\t\u0001a\u0001\n\u0013\t\u0005bB#\u0001\u0001\u0004%IA\u0012\u0005\u0007\u0019\u0002\u0001\u000b\u0015\u0002\"\t\u000f5\u0003\u0001\u0019!C\u0005\u0003\"9a\n\u0001a\u0001\n\u0013y\u0005BB)\u0001A\u0003&!\tC\u0003S\u0001\u0011\u00051\u000bC\u0003~\u0001\u0011\u0005a\u0010C\u0004\u0002\b\u0001!\t!!\u0003\t\u000f\u0005M\u0001\u0001\"\u0003\u0002\u0016!9\u00111\b\u0001\u0005\n\u0005u\u0002bBA \u0001\u0011%\u0011Q\b\u0002\u001d!J|G-^2f%\u0016\fX/Z:u!&\u0004X\r\\5oS:<G+Z:u\u0015\t)b#\u0001\u0004tKJ4XM\u001d\u0006\u0002/\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u001b!\tYb$D\u0001\u001d\u0015\tib#A\u0002ba&L!a\b\u000f\u0003-%sG/Z4sCRLwN\u001c+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#\u0001\u0012\u0011\u0005\r\u0002Q\"\u0001\u000b\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u000b\u0002MA\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t\u0019\u0011J\u001c;\u0002\u0019M,'O^3s\u0007>tg-[4\u0016\u00039\u0002\"a\f\u001b\u000e\u0003AR!!\r\u001a\u0002\tU$\u0018\u000e\u001c\u0006\u0002g\u0005!!.\u0019<b\u0013\t)\u0004G\u0001\u0006Qe>\u0004XM\u001d;jKN\fQb]3sm\u0016\u00148i\u001c8gS\u001e\u0004\u0013!\u0003;pa&\u001cg*Y7f+\u0005I\u0004C\u0001\u001e>\u001b\u0005Y$B\u0001\u001f3\u0003\u0011a\u0017M\\4\n\u0005yZ$AB*ue&tw-\u0001\u0006u_BL7MT1nK\u0002\nA\u0002\\3bI\u0016\u0014(I]8lKJ,\u0012A\u0011\t\u0003G\rK!\u0001\u0012\u000b\u0003\u0017-\u000bgm[1Ce>\\WM]\u0001\u0011Y\u0016\fG-\u001a:Ce>\\WM]0%KF$\"a\u0012&\u0011\u0005\u001dB\u0015BA%)\u0005\u0011)f.\u001b;\t\u000f-C\u0011\u0011!a\u0001\u0005\u0006\u0019\u0001\u0010J\u0019\u0002\u001b1,\u0017\rZ3s\u0005J|7.\u001a:!\u000391w\u000e\u001c7po\u0016\u0014(I]8lKJ\f!CZ8mY><XM\u001d\"s_.,'o\u0018\u0013fcR\u0011q\t\u0015\u0005\b\u0017.\t\t\u00111\u0001C\u0003=1w\u000e\u001c7po\u0016\u0014(I]8lKJ\u0004\u0013\u0001\b;fgR\u0004&o\u001c3vG\u0016\u0014V-];fgR\u0004\u0016\u000e]3mS:Lgn\u001a\u000b\u0003\u000fRCQ!V\u0007A\u0002Y\u000ba!];peVl\u0007CA,_\u001d\tAF\f\u0005\u0002ZQ5\t!L\u0003\u0002\\1\u00051AH]8pizJ!!\u0018\u0015\u0002\rA\u0013X\rZ3g\u0013\tqtL\u0003\u0002^Q!\"Q\"Y7o!\t\u00117.D\u0001d\u0015\t!W-\u0001\u0004qCJ\fWn\u001d\u0006\u0003M\u001e\fqA[;qSR,'O\u0003\u0002iS\u0006)!.\u001e8ji*\t!.A\u0002pe\u001eL!\u0001\\2\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017%A8\u0002Em$\u0017n\u001d9mCft\u0015-\\3~]m\f'oZ;nK:$8oV5uQ:\u000bW.Z:~Q\u0011i\u0011o\u001e=\u0011\u0005I,X\"A:\u000b\u0005Q\u001c\u0017\u0001\u00039s_ZLG-\u001a:\n\u0005Y\u001c(a\u0003,bYV,7k\\;sG\u0016\fqa\u001d;sS:<7\u000f\f\u0002zw\u0006\n!0\u0001\u0002{W\u0006\nA0A\u0003le\u00064G/\u0001\u0016uKN$\bK]8ek\u000e,'+Z9vKN$\b+\u001b9fY&t\u0017N\\4XSRDG\u000b\u001b:piRd\u0017N\\4\u0015\u0005\u001d{\b\"B+\u000f\u0001\u00041\u0006\u0006\u0002\bb[:DSAD9x\u0003\u000ba#!_>\u0002GQ,7\u000f\u001e#z]\u0006l\u0017n\u0019)s_\u0012,8-\u001a*fcV,7\u000f\u001e)ja\u0016d\u0017N\\5oOR\u0019q)a\u0003\t\u000bU{\u0001\u0019\u0001,)\t=\tWN\u001c\u0015\u0006\u001fE<\u0018\u0011\u0003\u0017\u0003sn\f1%\u00197uKJ\u0014V-];fgR\u0004\u0016\u000e]3mS:Lgn\u001a#z]\u0006l\u0017nY\"p]\u001aLw\rF\u0003H\u0003/\t\t\u0004C\u0004\u0002\u001aA\u0001\r!a\u0007\u0002\u0017\u0005$W.\u001b8DY&,g\u000e\u001e\t\u0005\u0003;\ti#\u0004\u0002\u0002 )!\u0011\u0011EA\u0012\u0003\u0015\tG-\\5o\u0015\u0011\t)#a\n\u0002\u000f\rd\u0017.\u001a8ug*\u0019q#!\u000b\u000b\u0007\u0005-\u0012.\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003_\tyBA\u0003BI6Lg\u000eC\u0004\u00024A\u0001\r!!\u000e\u0002\rU\u0004H-\u0019;f!\r9\u0013qG\u0005\u0004\u0003sA#a\u0002\"p_2,\u0017M\\\u0001\raJ,\u0007/\u0019:f)>\u0004\u0018n\u0019\u000b\u0002\u000f\u0006qb/\u001a:jMf\u0004&o\u001c3vG\u0016\u0014V-];fgR\u0004\u0016\u000e]3mS:Lgn\u001a")
public class ProduceRequestPipeliningTest
extends IntegrationTestHarness {
    private final Properties serverConfig;
    private final String topicName;
    private KafkaBroker leaderBroker;
    private KafkaBroker followerBroker;

    @Override
    public int brokerCount() {
        return 2;
    }

    @Override
    public Properties serverConfig() {
        return this.serverConfig;
    }

    private String topicName() {
        return this.topicName;
    }

    private KafkaBroker leaderBroker() {
        return this.leaderBroker;
    }

    private void leaderBroker_$eq(KafkaBroker x$1) {
        this.leaderBroker = x$1;
    }

    private KafkaBroker followerBroker() {
        return this.followerBroker;
    }

    private void followerBroker_$eq(KafkaBroker x$1) {
        this.followerBroker = x$1;
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testProduceRequestPipelining(String quorum) {
        this.prepareTopic();
        this.verifyProduceRequestPipelining();
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testProduceRequestPipeliningWithThrottling(String quorum) {
        this.prepareTopic();
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), null)}))).asJava());
        .colon.colon ops = new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(10.0)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(10.0)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("request_percentage", Predef$.MODULE$.double2Double(9.223372036854776E18)), (List)Nil$.MODULE$)));
        .colon.colon quotaAlterations = new .colon.colon((Object)new ClientQuotaAlteration(entity, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ops).asJava()), (List)Nil$.MODULE$);
        adminClient.alterClientQuotas((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)quotaAlterations).asJava()).all().get();
        this.ensureConsistentKRaftMetadata();
        String errorMessage = "Timed out waiting for local write for second record to complete.";
        AssertionFailedError thrownErrorMessage = (AssertionFailedError)Assertions.assertThrows(AssertionFailedError.class, () -> this.verifyProduceRequestPipelining());
        Assertions.assertEquals((Object)errorMessage, (Object)thrownErrorMessage.getMessage());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDynamicProduceRequestPipelining(String quorum) {
        this.prepareTopic();
        this.verifyProduceRequestPipelining();
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        this.alterRequestPipeliningDynamicConfig(adminClient, false);
        String errorMessage = "Timed out waiting for local write for second record to complete.";
        AssertionFailedError thrownErrorMessage = (AssertionFailedError)Assertions.assertThrows(AssertionFailedError.class, () -> this.verifyProduceRequestPipelining());
        Assertions.assertEquals((Object)errorMessage, (Object)thrownErrorMessage.getMessage());
        this.alterRequestPipeliningDynamicConfig(adminClient, true);
        this.verifyProduceRequestPipelining();
    }

    /*
     * WARNING - void declaration
     */
    private void alterRequestPipeliningDynamicConfig(Admin adminClient, boolean update) {
        Properties updatedPipeliningProps = new Properties();
        updatedPipeliningProps.put(KafkaConfig$.MODULE$.RequestPipeliningEnableProp(), Boolean.toString(update));
        TestUtils$.MODULE$.incrementalAlterConfigs(this.brokers(), adminClient, updatedPipeliningProps, false, AlterConfigOp.OpType.SET).all().get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ProduceRequestPipeliningTest.$anonfun$alterRequestPipeliningDynamicConfig$1(this, update)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for brokers to receive updated request pipelining config");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void prepareTopic() {
        String topicName = "test_topic";
        Properties topicProps = new Properties();
        topicProps.put("min.insync.replicas", "2");
        scala.collection.immutable.Map<Object, Object> partitionLeaders = this.createTopic(topicName, 1, this.brokerCount(), topicProps, this.createTopic$default$5(), this.createTopic$default$6());
        this.ensureConsistentKRaftMetadata();
        this.leaderBroker_$eq(this.brokerWithId(Predef$.MODULE$.Integer2int((Integer)this.brokerIds().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ProduceRequestPipeliningTest.$anonfun$prepareTopic$1(partitionLeaders, x$2))).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)"Expected to find leader broker")))));
        this.followerBroker_$eq(this.brokerWithId(Predef$.MODULE$.Integer2int((Integer)this.brokerIds().find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ProduceRequestPipeliningTest.$anonfun$prepareTopic$3(partitionLeaders, x$3))).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)"Expected to find a follower brokers")))));
    }

    private void verifyProduceRequestPipelining() {
        VolatileLongRef partitionLogEndOffset = VolatileLongRef.create((long)-1L);
        VolatileLongRef partitionHighWaterMark = VolatileLongRef.create((long)-1L);
        PartitionListener logUpdateListener = new PartitionListener(null, partitionLogEndOffset, partitionHighWaterMark){
            private final VolatileLongRef partitionLogEndOffset$1;
            private final VolatileLongRef partitionHighWaterMark$1;

            public void onStartOffsetUpdated(TopicPartition partition, long offset) {
                PartitionListener.onStartOffsetUpdated$((PartitionListener)this, (TopicPartition)partition, (long)offset);
            }

            public void onLastStableOffsetUpdated(TopicPartition partition, long offset) {
                PartitionListener.onLastStableOffsetUpdated$((PartitionListener)this, (TopicPartition)partition, (long)offset);
            }

            public void onIsrUpdated(TopicPartition partition, Set<Object> isr) {
                PartitionListener.onIsrUpdated$((PartitionListener)this, (TopicPartition)partition, isr);
            }

            public void onLeaderEpochUpdated(TopicPartition partition, int leaderEpoch) {
                PartitionListener.onLeaderEpochUpdated$((PartitionListener)this, (TopicPartition)partition, (int)leaderEpoch);
            }

            public void onFailed(TopicPartition partition) {
                PartitionListener.onFailed$((PartitionListener)this, (TopicPartition)partition);
            }

            public void onDeleted(TopicPartition partition) {
                PartitionListener.onDeleted$((PartitionListener)this, (TopicPartition)partition);
            }

            public void onEndOffsetUpdated(TopicPartition partition, long offset) {
                this.partitionLogEndOffset$1.elem = offset;
            }

            public void onHighWatermarkUpdated(TopicPartition partition, long offset) {
                this.partitionHighWaterMark$1.elem = offset;
            }
            {
                this.partitionLogEndOffset$1 = partitionLogEndOffset$1;
                this.partitionHighWaterMark$1 = partitionHighWaterMark$1;
            }
        };
        this.leaderBroker().replicaManager().maybeAddListener(new TopicPartition(this.topicName(), 0), logUpdateListener);
        long initialLogEndOffset = partitionLogEndOffset.elem;
        long initialHighWaterMark = partitionHighWaterMark.elem;
        Assertions.assertEquals((long)initialHighWaterMark, (long)initialLogEndOffset);
        Properties producerProps = new Properties();
        producerProps.put("acks", "all");
        producerProps.put("enable.idempotence", "false");
        KafkaProducer producer = this.createProducer(new ByteArraySerializer(), new ByteArraySerializer(), producerProps);
        byte[] keyBytes = new byte[34];
        byte[] valBytes = new byte[33];
        ArrayBuffer recordFutures = new ArrayBuffer();
        ReentrantLock partitionMapLock = (ReentrantLock)TestUtils.fieldValue((Object)((ReplicaFetcherThread)this.followerBroker().replicaManager().replicaFetcherManager().getFetcher(new TopicPartition(this.topicName(), 0)).get()), AbstractFetcherThread.class, (String)"partitionMapLock");
        CoreUtils$.MODULE$.inLock((Lock)partitionMapLock, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            recordFutures.$plus$eq((Object)producer.send(new ProducerRecord(this.topicName(), Predef$.MODULE$.int2Integer(0), (Object)keyBytes, (Object)valBytes)));
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 5000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!(partitionLogEndOffset$1.elem == initialLogEndOffset + 1L)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for local write for first record to complete.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertEquals((long)initialHighWaterMark, (long)partitionHighWaterMark$1.elem);
            recordFutures.$plus$eq((Object)producer.send(new ProducerRecord(this.topicName(), Predef$.MODULE$.int2Integer(0), (Object)keyBytes, (Object)valBytes)));
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 5000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!(partitionLogEndOffset$1.elem == initialLogEndOffset + 2L)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"Timed out waiting for local write for second record to complete.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            Assertions.assertEquals((long)initialHighWaterMark, (long)partitionHighWaterMark$1.elem);
            recordFutures.$plus$eq((Object)producer.send(new ProducerRecord(this.topicName(), Predef$.MODULE$.int2Integer(0), (Object)keyBytes, (Object)valBytes)));
            long l3 = 100L;
            long waitUntilTrue_waitTimeMs3 = 5000L;
            long waitUntilTrue_startTime3 = System.currentTimeMillis();
            while (!(partitionLogEndOffset$1.elem == initialLogEndOffset + 3L)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                    Assertions.fail((String)"Timed out waiting for local write for third record to complete.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
            }
            Assertions.assertEquals((long)initialHighWaterMark, (long)partitionHighWaterMark$1.elem);
        });
        ArrayBuffer recordMetadata = (ArrayBuffer)recordFutures.map((Function1 & Serializable)x$4 -> (RecordMetadata)x$4.get(5000L, TimeUnit.MILLISECONDS));
        Assertions.assertEquals((long)(initialLogEndOffset + 3L), (long)partitionHighWaterMark.elem);
        Assertions.assertEquals((long)(initialLogEndOffset + 3L), (long)partitionLogEndOffset.elem);
        IntRef recordIndex = IntRef.create((int)0);
        recordMetadata.foreach((Function1 & Serializable)record -> {
            ProduceRequestPipeliningTest.$anonfun$verifyProduceRequestPipelining$9(initialLogEndOffset, recordIndex, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$alterRequestPipeliningDynamicConfig$2(boolean update$1, KafkaBroker x$1) {
        return BoxesRunTime.equals((Object)x$1.config().getBoolean(KafkaConfig$.MODULE$.RequestPipeliningEnableProp()), (Object)BoxesRunTime.boxToBoolean((boolean)update$1));
    }

    public static final /* synthetic */ boolean $anonfun$alterRequestPipeliningDynamicConfig$1(ProduceRequestPipeliningTest $this, boolean update$1) {
        return $this.brokers().forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ProduceRequestPipeliningTest.$anonfun$alterRequestPipeliningDynamicConfig$2(update$1, x$1)));
    }

    public static final /* synthetic */ String $anonfun$alterRequestPipeliningDynamicConfig$3() {
        return "Timed out waiting for brokers to receive updated request pipelining config";
    }

    public static final /* synthetic */ boolean $anonfun$prepareTopic$1(scala.collection.immutable.Map partitionLeaders$1, Integer x$2) {
        return BoxesRunTime.equalsNumObject((Number)x$2, (Object)partitionLeaders$1.apply((Object)BoxesRunTime.boxToInteger((int)0)));
    }

    public static final /* synthetic */ boolean $anonfun$prepareTopic$3(scala.collection.immutable.Map partitionLeaders$1, Integer x$3) {
        return !BoxesRunTime.equalsNumObject((Number)x$3, (Object)partitionLeaders$1.apply((Object)BoxesRunTime.boxToInteger((int)0)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyProduceRequestPipelining$2(VolatileLongRef partitionLogEndOffset$1, long initialLogEndOffset$1) {
        return partitionLogEndOffset$1.elem == initialLogEndOffset$1 + 1L;
    }

    public static final /* synthetic */ String $anonfun$verifyProduceRequestPipelining$3() {
        return "Timed out waiting for local write for first record to complete.";
    }

    public static final /* synthetic */ boolean $anonfun$verifyProduceRequestPipelining$4(VolatileLongRef partitionLogEndOffset$1, long initialLogEndOffset$1) {
        return partitionLogEndOffset$1.elem == initialLogEndOffset$1 + 2L;
    }

    public static final /* synthetic */ String $anonfun$verifyProduceRequestPipelining$5() {
        return "Timed out waiting for local write for second record to complete.";
    }

    public static final /* synthetic */ boolean $anonfun$verifyProduceRequestPipelining$6(VolatileLongRef partitionLogEndOffset$1, long initialLogEndOffset$1) {
        return partitionLogEndOffset$1.elem == initialLogEndOffset$1 + 3L;
    }

    public static final /* synthetic */ String $anonfun$verifyProduceRequestPipelining$7() {
        return "Timed out waiting for local write for third record to complete.";
    }

    public static final /* synthetic */ void $anonfun$verifyProduceRequestPipelining$9(long initialLogEndOffset$1, IntRef recordIndex$1, RecordMetadata record) {
        Assertions.assertEquals((long)(initialLogEndOffset$1 + (long)recordIndex$1.elem), (long)record.offset());
        ++recordIndex$1.elem;
    }

    /*
     * WARNING - void declaration
     */
    public ProduceRequestPipeliningTest() {
        void var1_1;
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), Long.toString(TimeUnit.MINUTES.toMillis(5L)));
        this.serverConfig = var1_1;
        this.topicName = "test_topic";
        this.leaderBroker = null;
        this.followerBroker = null;
    }
}

