/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.stream.Stream;
import kafka.server.BaseRequestTest;
import kafka.server.BrokerTopicStats$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaServer;
import kafka.server.ProduceRequestTest$;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.message.ProduceResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.record.BrokerCompressionType;
import org.apache.kafka.test.InterceptorUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005-g\u0001\u0002\u000b\u0016\u0001iAQa\b\u0001\u0005\u0002\u0001BqA\t\u0001C\u0002\u0013\u00051\u0005\u0003\u0004;\u0001\u0001\u0006I\u0001\n\u0005\u0006w\u0001!\t\u0001\u0010\u0005\u0006W\u0002!\t\u0001\u001c\u0005\u0006i\u0002!\t!\u001e\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0011\u001d\tI\u0002\u0001C\u0005\u00037Aq!!\f\u0001\t\u0003\ty\u0003C\u0004\u0002:\u0001!\t!a\u000f\t\r\u0005\u0015\u0003\u0001\"\u0001m\u0011\u0019\tI\u0005\u0001C\u0001Y\"9\u0011Q\n\u0001\u0005\n\u0005=\u0003BBAF\u0001\u0011\u0005A\u000eC\u0004\u0002\u0010\u0002!I!!%\b\u000f\u0005\u0005V\u0003#\u0001\u0002$\u001a1A#\u0006E\u0001\u0003KCaaH\t\u0005\u0002\u00055\u0006bBA\u0006#\u0011\u0005\u0011q\u0016\u0002\u0013!J|G-^2f%\u0016\fX/Z:u)\u0016\u001cHO\u0003\u0002\u0017/\u000511/\u001a:wKJT\u0011\u0001G\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\u0004\u0005\u0002\u001d;5\tQ#\u0003\u0002\u001f+\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002CA\u0011A\u0004A\u0001\u000e[\u0016$(/[2t\u0017\u0016L8+\u001a;\u0016\u0003\u0011\u00022!\n\u0017/\u001b\u00051#BA\u0014)\u0003\u001diW\u000f^1cY\u0016T!!\u000b\u0016\u0002\u0015\r|G\u000e\\3di&|gNC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ticEA\u0002TKR\u0004\"a\f\u001d\u000e\u0003AR!!\r\u001a\u0002\t\r|'/\u001a\u0006\u0003gQ\nq!\\3ue&\u001c7O\u0003\u00026m\u00051\u00110Y7nKJT\u0011aN\u0001\u0004G>l\u0017BA\u001d1\u0005)iU\r\u001e:jG:\u000bW.Z\u0001\u000f[\u0016$(/[2t\u0017\u0016L8+\u001a;!\u0003a!Xm\u001d;TS6\u0004H.\u001a)s_\u0012,8-\u001a*fcV,7\u000f\u001e\u000b\u0003{\u0005\u0003\"AP \u000e\u0003)J!\u0001\u0011\u0016\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0005\u0012\u0001\raQ\u0001\u0007cV|'/^7\u0011\u0005\u0011[eBA#J!\t1%&D\u0001H\u0015\tA\u0015$\u0001\u0004=e>|GOP\u0005\u0003\u0015*\na\u0001\u0015:fI\u00164\u0017B\u0001'N\u0005\u0019\u0019FO]5oO*\u0011!J\u000b\u0015\u0005\t=[F\f\u0005\u0002Q36\t\u0011K\u0003\u0002S'\u00061\u0001/\u0019:b[NT!\u0001V+\u0002\u000f),\b/\u001b;fe*\u0011akV\u0001\u0006UVt\u0017\u000e\u001e\u0006\u00021\u0006\u0019qN]4\n\u0005i\u000b&!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\u0005i\u0016AI>eSN\u0004H.Y=OC6,WPL>be\u001e,X.\u001a8ug^KG\u000f\u001b(b[\u0016\u001cX\u0010\u000b\u0003\u0005?\u00164\u0007C\u00011d\u001b\u0005\t'B\u00012R\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018B\u00013b\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\u0012q-[\u0011\u0002Q\u0006\u0011!p[\u0011\u0002U\u0006)1N]1gi\u0006\u0019E/Z:u!J|G-^2f%\u0016\fX/Z:u\tV\u0014\u0018N\\4QCJ$\u0018\u000e^5p]J+7m\u001c<fef\fe\r^3s+:\u001cG.Z1o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o)\u0005i\u0004FA\u0003o!\ty'/D\u0001q\u0015\t\t8+A\u0002ba&L!a\u001d9\u0003\tQ+7\u000f^\u0001 i\u0016\u001cH\u000f\u0015:pIV\u001cWmV5uQ&sg/\u00197jIRKW.Z:uC6\u0004HcA\u001fwq\")qO\u0002a\u0001\u0007\u00061R.Z:tC\u001e,G+[7f'R\fW\u000e]\"p]\u001aLw\rC\u0003z\r\u0001\u0007!0A\bsK\u000e|'\u000f\u001a+j[\u0016\u001cH/Y7q!\tq40\u0003\u0002}U\t!Aj\u001c8hQ\t1q\n\u000b\u0004\u0007\u007f\u0006\u0015\u0011q\u0001\t\u0004A\u0006\u0005\u0011bAA\u0002C\naQ*\u001a;i_\u0012\u001cv.\u001e:dK\u0006)a/\u00197vK2\u0012\u0011\u0011B\u0011\u0003\u0003\u0017\tq\u0003^5nKN$\u0018-\u001c9D_:4\u0017n\u001a)s_ZLG-\u001a:\u0002/Q,7\u000f\u001e)s_\u0012,8-\u001a+p\u001d>t'+\u001a9mS\u000e\fGcA\u001f\u0002\u0012!)!i\u0002a\u0001\u0007\"\"qaT.]Q\u00159q,ZA\fY\t9\u0017.A\u0013de\u0016\fG/\u001a+pa&\u001c\u0017I\u001c3GS:$\u0007+\u0019:uSRLwN\\,ji\"dU-\u00193feR!\u0011QDA\u0015!\u001dq\u0014qDA\u0012\u0003GI1!!\t+\u0005\u0019!V\u000f\u001d7feA\u0019a(!\n\n\u0007\u0005\u001d\"FA\u0002J]RDa!a\u000b\t\u0001\u0004\u0019\u0015!\u0002;pa&\u001c\u0017\u0001\b;fgR\u001cuN\u001d:vaRd%\u0010\u000e)s_\u0012,8-\u001a*fcV,7\u000f\u001e\u000b\u0004{\u0005E\u0002\"\u0002\"\n\u0001\u0004\u0019\u0005\u0006B\u0005P7rCS!C0f\u0003oa#aZ5\u0002-Q,7\u000f\u001e.T)\u0012\u0003&o\u001c3vG\u0016\u0014V-];fgR$2!PA\u001f\u0011\u0015\u0011%\u00021\u0001DQ\u0011Qqj\u0017/)\u000b)yV-a\u0011-\u0005\u001dL\u0017!\u0010;fgR\u0004&o\u001c3vG\u0016\u0014V-];fgRLen\u00197vI\u0016\u001c(+Z2pe\u0012\u001c(+\u001a6fGR,GMQ=UQ\u0016\u001c\u0016-\\3J]R,'oY3qi>\u0014\bFA\u0006o\u0003\u0001#Xm\u001d;Qe>$WoY3SKF,Xm\u001d;J]\u000edW\u000fZ3t%\u0016\u001cwN\u001d3t%\u0016TWm\u0019;fI\nKH)\u001b4gKJ,g\u000e^%oi\u0016\u00148-\u001a9u_J\u001c\bF\u0001\u0007o\u0003M\u0011W/\u001b7e!J|G-^2f%\u0016\fX/Z:u))\t\t&a\u001a\u0002t\u0005]\u00141\u0010\t\u0005\u0003'\n\u0019'\u0004\u0002\u0002V)!\u0011qKA-\u0003!\u0011X-];fgR\u001c(\u0002BA.\u0003;\naaY8n[>t'b\u0001\r\u0002`)\u0019\u0011\u0011M,\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\t)'!\u0016\u0003\u001dA\u0013x\u000eZ;dKJ+\u0017/^3ti\"9\u0011\u0011N\u0007A\u0002\u0005-\u0014A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0005\u0003[\ny'\u0004\u0002\u0002Z%!\u0011\u0011OA-\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!!\u001e\u000e\u0001\u0004\t\u0019#\u0001\u0003bG.\u001c\bbBA=\u001b\u0001\u0007\u00111E\u0001\ni&lWm\\;u\u001bNDq!! \u000e\u0001\u0004\ty(A\u0004sK\u000e|'\u000fZ:\u0011\t\u0005\u0005\u0015qQ\u0007\u0003\u0003\u0007SA!!\"\u0002Z\u00051!/Z2pe\u0012LA!!#\u0002\u0004\n9!+Z2pe\u0012\u001c\u0018a\u0010;fgR\u0004&o\u001c3vG\u0016\u0014V-];fgRLen\u00197vI\u0016\u001c\u0018J\u001c<bY&$G+[7fgR\fW\u000e]!oI&sG/\u001a:dKB$X\r\u001a*fG>\u0014Hm\u001d\u0015\u0003\u001d9\f!c]3oIB\u0013x\u000eZ;dKJ+\u0017/^3tiR1\u00111SAM\u0003;\u0003B!a\u0015\u0002\u0016&!\u0011qSA+\u0005=\u0001&o\u001c3vG\u0016\u0014Vm\u001d9p]N,\u0007bBAN\u001f\u0001\u0007\u00111E\u0001\tY\u0016\fG-\u001a:JI\"9\u0011qT\bA\u0002\u0005E\u0013a\u0002:fcV,7\u000f^\u0001\u0013!J|G-^2f%\u0016\fX/Z:u)\u0016\u001cH\u000f\u0005\u0002\u001d#M\u0019\u0011#a*\u0011\u0007y\nI+C\u0002\u0002,*\u0012a!\u00118z%\u00164GCAAR+\t\t\t\f\u0005\u0004\u00024\u0006\u0005\u0017QY\u0007\u0003\u0003kSA!a.\u0002:\u000611\u000f\u001e:fC6TA!a/\u0002>\u0006!Q\u000f^5m\u0015\t\ty,\u0001\u0003kCZ\f\u0017\u0002BAb\u0003k\u0013aa\u0015;sK\u0006l\u0007c\u00011\u0002H&\u0019\u0011\u0011Z1\u0003\u0013\u0005\u0013x-^7f]R\u001c\b")
public class ProduceRequestTest
extends BaseRequestTest {
    private final Set<MetricName> metricsKeySet = CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala();

    public static Stream<Arguments> timestampConfigProvider() {
        return ProduceRequestTest$.MODULE$.timestampConfigProvider();
    }

    public Set<MetricName> metricsKeySet() {
        return this.metricsKeySet;
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSimpleProduceRequest(String quorum) {
        void withRecords_records;
        void withRecords_timestampType;
        void var4_4;
        void var3_3;
        void withRecords_records2;
        void withRecords_timestampType2;
        Tuple2<Object, Object> tuple2 = this.createTopicAndFindPartitionWithLeader("topic");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int partition = tuple2._1$mcI$sp();
        int leader = tuple2._2$mcI$sp();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var5_6 = null;
        simpleRecordArray = null;
        this.sendAndCheck$1(MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType2, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records2), 0L, (int)var3_3, (int)var4_4);
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key1".getBytes(), "value1".getBytes()), new SimpleRecord(System.currentTimeMillis(), "key2".getBytes(), "value2".getBytes())};
        CompressionType withRecords_compressionType2 = CompressionType.GZIP;
        byte withRecords_magic2 = 2;
        TimestampType timestampType2 = TimestampType.CREATE_TIME;
        long withRecords_initialOffset2 = 0L;
        timestampType2 = null;
        Object var7_11 = null;
        simpleRecordArray2 = null;
        this.sendAndCheck$1(MemoryRecords.withRecords((byte)withRecords_magic2, (long)withRecords_initialOffset2, (CompressionType)withRecords_compressionType2, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records), 1L, (int)var3_3, (int)var4_4);
    }

    @Test
    public void testProduceRequestDuringPartitionRecoveryAfterUncleanLeaderElection() {
        String topic = "test-topic";
        Properties topicConfig = new Properties();
        topicConfig.put("message.timestamp.type", "LogAppendTime");
        Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 2, (Seq<KafkaBroker>)this.servers(), topicConfig);
        TopicPartition partition = new TopicPartition(topic, 0);
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition.partition())));
        scala.collection.immutable.Set replicas = this.zkClient().getReplicasForPartition(partition).toSet();
        int follower = BoxesRunTime.unboxToInt((Object)replicas.find((Function1)(JFunction1.mcZI.sp & Serializable)x$2 -> x$2 != leader).get());
        int nonReplica = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.servers().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)ProduceRequestTest.$anonfun$testProduceRequestDuringPartitionRecoveryAfterUncleanLeaderElection$2(x$3)))).find((Function1)(JFunction1.mcZI.sp & Serializable)x$4 -> !replicas.contains((Object)BoxesRunTime.boxToInteger((int)x$4))).get());
        TestUtils$.MODULE$.forceOverrideLeaderRecoveryState(((KafkaServer)this.servers().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ProduceRequestTest.$anonfun$testProduceRequestDuringPartitionRecoveryAfterUncleanLeaderElection$4(leader, x$5))).get()).replicaManager().getPartitionOrException(partition), LeaderRecoveryState.RECOVERED);
        this.produceRecordsAndValidateResponse$1(leader, Errors.NONE, 0, partition);
        this.produceRecordsAndValidateResponse$1(follower, Errors.NOT_LEADER_OR_FOLLOWER, -1, partition);
        this.produceRecordsAndValidateResponse$1(nonReplica, Errors.NOT_LEADER_OR_FOLLOWER, -1, partition);
        TestUtils$.MODULE$.forceOverrideLeaderRecoveryState(((KafkaServer)this.servers().find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ProduceRequestTest.$anonfun$testProduceRequestDuringPartitionRecoveryAfterUncleanLeaderElection$5(leader, x$6))).get()).replicaManager().getPartitionOrException(partition), LeaderRecoveryState.RECOVERING);
        this.produceRecordsAndValidateResponse$1(leader, Errors.NOT_LEADER_OR_FOLLOWER, -1, partition);
        this.produceRecordsAndValidateResponse$1(follower, Errors.NOT_LEADER_OR_FOLLOWER, -1, partition);
        this.produceRecordsAndValidateResponse$1(nonReplica, Errors.NOT_LEADER_OR_FOLLOWER, -1, partition);
        TestUtils$.MODULE$.forceOverrideLeaderRecoveryState(((KafkaServer)this.servers().find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ProduceRequestTest.$anonfun$testProduceRequestDuringPartitionRecoveryAfterUncleanLeaderElection$6(leader, x$7))).get()).replicaManager().getPartitionOrException(partition), LeaderRecoveryState.RECOVERED);
        this.produceRecordsAndValidateResponse$1(leader, Errors.NONE, 1, partition);
        this.produceRecordsAndValidateResponse$1(follower, Errors.NOT_LEADER_OR_FOLLOWER, -1, partition);
        this.produceRecordsAndValidateResponse$1(nonReplica, Errors.NOT_LEADER_OR_FOLLOWER, -1, partition);
    }

    @ParameterizedTest
    @MethodSource(value={"timestampConfigProvider"})
    public void testProduceWithInvalidTimestamp(String messageTimeStampConfig, long recordTimestamp) {
        String topic = "topic";
        int partition = 0;
        Properties topicConfig = new Properties();
        topicConfig.setProperty(messageTimeStampConfig, "1000");
        int leader = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaBroker>)this.servers(), topicConfig).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        MemoryRecords records = ProduceRequestTest.createRecords$1((byte)2, recordTimestamp, CompressionType.GZIP);
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        ProduceRequestData forCurrentMagic_data = new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(topicPartition.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)records)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null);
        Object var15_9 = null;
        ProduceResponse produceResponse = this.sendProduceRequest(leader, (ProduceRequest)ProduceRequest.forMagic((byte)2, (ProduceRequestData)forCurrentMagic_data).build());
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse.data().responses()).asScala().head();
        Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicProduceResponse.partitionResponses()).asScala().head();
        TopicPartition tp = new TopicPartition(topicProduceResponse.name(), partitionProduceResponse.index());
        Assertions.assertEquals((Object)topicPartition, (Object)tp);
        Assertions.assertEquals((Object)Errors.INVALID_TIMESTAMP, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
        Assertions.assertEquals((int)3, (int)partitionProduceResponse.recordErrors().size());
        Buffer recordErrors = CollectionConverters$.MODULE$.ListHasAsScala(partitionProduceResponse.recordErrors()).asScala();
        recordErrors.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Assertions.assertEquals((int)i, (int)((ProduceResponseData.BatchIndexAndErrorMessage)recordErrors.apply(i)).batchIndex()));
        recordErrors.foreach((Function1 & Serializable)recordError -> {
            ProduceRequestTest.$anonfun$testProduceWithInvalidTimestamp$2(recordError);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)"One or more records have been rejected due to invalid timestamp", (Object)partitionProduceResponse.errorMessage());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testProduceToNonReplica(String quorum) {
        void withRecords_records;
        void withRecords_timestampType;
        String topic = "topic";
        int partition = 0;
        int leader = BoxesRunTime.unboxToInt((Object)this.createTopic(topic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6()).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        Option nonReplicaOpt = this.brokers().find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ProduceRequestTest.$anonfun$testProduceToNonReplica$1(leader, x$8)));
        Assertions.assertTrue((boolean)nonReplicaOpt.isDefined());
        int nonReplicaId = ((KafkaBroker)nonReplicaOpt.get()).config().brokerId();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("key".getBytes(), "value".getBytes())};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var13_8 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        ProduceRequestData forCurrentMagic_data = new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(topicPartition.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)records)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null);
        Object var15_14 = null;
        ProduceRequest produceRequest = (ProduceRequest)ProduceRequest.forMagic((byte)2, (ProduceRequestData)forCurrentMagic_data).build();
        ProduceResponse produceResponse = this.sendProduceRequest(nonReplicaId, produceRequest);
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse.data().responses()).asScala().head();
        Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicProduceResponse.partitionResponses()).asScala().head();
        Assertions.assertEquals((Object)Errors.NOT_LEADER_OR_FOLLOWER, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
    }

    private Tuple2<Object, Object> createTopicAndFindPartitionWithLeader(String topic) {
        return (Tuple2)this.createTopic(topic, 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6()).collectFirst((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 != null) {
                    int partition = x1._1$mcI$sp();
                    int leader = x1._2$mcI$sp();
                    if (leader != -1) {
                        return (B1)new Tuple2.mcII.sp(partition, leader);
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Object, Object> x1) {
                return x1 != null && x1._2$mcI$sp() != -1;
            }
        }).getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(28).append("No leader elected for topic ").append(topic).toString());
        });
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCorruptLz4ProduceRequest(String quorum) {
        void var4_4;
        void var3_3;
        void withRecords_records;
        void withRecords_timestampType;
        Tuple2<Object, Object> tuple2 = this.createTopicAndFindPartitionWithLeader("topic");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int partition = tuple2._1$mcI$sp();
        int leader = tuple2._2$mcI$sp();
        int timestamp = 1000000;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(Int$.MODULE$.int2long(timestamp), "key".getBytes(), "value".getBytes())};
        CompressionType withRecords_compressionType = CompressionType.LZ4;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var13_7 = null;
        simpleRecordArray = null;
        MemoryRecords memoryRecords = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        int lz4ChecksumOffset = 6;
        memoryRecords.buffer().array()[61 + lz4ChecksumOffset] = 0;
        TopicPartition topicPartition = new TopicPartition("topic", (int)var3_3);
        ProduceRequestData forCurrentMagic_data = new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(topicPartition.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)memoryRecords)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null);
        Object var15_14 = null;
        ProduceResponse produceResponse = this.sendProduceRequest((int)var4_4, (ProduceRequest)ProduceRequest.forMagic((byte)2, (ProduceRequestData)forCurrentMagic_data).build());
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse.data().responses()).asScala().head();
        Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicProduceResponse.partitionResponses()).asScala().head();
        TopicPartition tp = new TopicPartition(topicProduceResponse.name(), partitionProduceResponse.index());
        Assertions.assertEquals((Object)topicPartition, (Object)tp);
        Assertions.assertEquals((Object)Errors.CORRUPT_MESSAGE, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
        Assertions.assertEquals((long)-1L, (long)partitionProduceResponse.baseOffset());
        Assertions.assertEquals((long)-1L, (long)partitionProduceResponse.logAppendTimeMs());
        Assertions.assertEquals((int)this.metricsKeySet().count((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ProduceRequestTest.$anonfun$testCorruptLz4ProduceRequest$1(x$10))), (int)1);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMessageCrcRecordsPerSec())) > 0L ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testZSTDProduceRequest(String quorum) {
        void withRecords_records;
        void withRecords_timestampType;
        String topic = "topic";
        int partition = 0;
        Properties topicConfig = new Properties();
        topicConfig.setProperty("compression.type", BrokerCompressionType.ZSTD.name);
        int x$3 = this.createTopic$default$2();
        int x$4 = this.createTopic$default$3();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        int leader = BoxesRunTime.unboxToInt((Object)this.createTopic(topic, x$3, x$4, topicConfig, x$5, x$6).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())};
        CompressionType withRecords_compressionType = CompressionType.ZSTD;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var21_11 = null;
        simpleRecordArray = null;
        MemoryRecords memoryRecords = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        ProduceRequestData partitionRecords = new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName("topic").setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(partition).setRecords((BaseRecords)memoryRecords)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null);
        ProduceResponse produceResponse1 = this.sendProduceRequest(leader, (ProduceRequest)new ProduceRequest.Builder(7, 7, partitionRecords).build());
        ProduceResponseData.TopicProduceResponse topicProduceResponse1 = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse1.data().responses()).asScala().head();
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse1 = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicProduceResponse1.partitionResponses()).asScala().head();
        TopicPartition tp1 = new TopicPartition(topicProduceResponse1.name(), partitionProduceResponse1.index());
        Assertions.assertEquals((Object)topicPartition, (Object)tp1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)partitionProduceResponse1.errorCode()));
        Assertions.assertEquals((long)0L, (long)partitionProduceResponse1.baseOffset());
        Assertions.assertEquals((long)-1L, (long)partitionProduceResponse1.logAppendTimeMs());
        ProduceResponse produceResponse2 = this.sendProduceRequest(leader, new ProduceRequest.Builder(3, 3, partitionRecords).buildUnsafe((short)3));
        ProduceResponseData.TopicProduceResponse topicProduceResponse2 = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse2.data().responses()).asScala().head();
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse2 = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicProduceResponse2.partitionResponses()).asScala().head();
        TopicPartition tp2 = new TopicPartition(topicProduceResponse2.name(), partitionProduceResponse2.index());
        Assertions.assertEquals((Object)topicPartition, (Object)tp2);
        Assertions.assertEquals((Object)Errors.UNSUPPORTED_COMPRESSION_TYPE, (Object)Errors.forCode((short)partitionProduceResponse2.errorCode()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testProduceRequestIncludesRecordsRejectedByTheSameInterceptor() {
        void withRecords_records;
        void withRecords_timestampType;
        String topic = "topic";
        int partition = 0;
        Properties topicConfig = new Properties();
        topicConfig.setProperty("confluent.append.record.interceptor.classes", InterceptorUtils.MockRecordInterceptor.class.getName());
        int leader = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaBroker>)this.servers(), topicConfig).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key0".getBytes(), "reject me".getBytes()), new SimpleRecord(System.currentTimeMillis(), "key1".getBytes(), "reject me".getBytes()), new SimpleRecord(System.currentTimeMillis(), "key2".getBytes(), "value".getBytes()), new SimpleRecord(System.currentTimeMillis(), "key3".getBytes(), "value".getBytes()), new SimpleRecord(System.currentTimeMillis(), "key4".getBytes(), "reject me".getBytes()), new SimpleRecord(System.currentTimeMillis(), "key5".getBytes(), "value".getBytes())};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var11_6 = null;
        simpleRecordArray = null;
        MemoryRecords memoryRecords = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        ProduceResponse produceResponse = this.sendProduceRequest(leader, this.buildProduceRequest(topicPartition, -1, 3000, (Records)memoryRecords));
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicResponse = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse.data().responses()).asScala().head();
        Assertions.assertEquals((int)1, (int)topicResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionResponse = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicResponse.partitionResponses()).asScala().head();
        Assertions.assertEquals((Object)topicPartition.topic(), (Object)topicResponse.name());
        Assertions.assertEquals((int)topicPartition.partition(), (int)partitionResponse.index());
        Assertions.assertEquals((short)Errors.INVALID_RECORD.code(), (short)partitionResponse.errorCode());
        Assertions.assertEquals((long)-1L, (long)partitionResponse.baseOffset());
        Assertions.assertEquals((long)-1L, (long)partitionResponse.logAppendTimeMs());
        Assertions.assertNotNull((Object)partitionResponse.recordErrors());
        java.util.List recordErrors = partitionResponse.recordErrors();
        Assertions.assertEquals((int)3, (int)recordErrors.size());
        Assertions.assertEquals((int)0, (int)((ProduceResponseData.BatchIndexAndErrorMessage)recordErrors.get(0)).batchIndex());
        Assertions.assertTrue((boolean)((ProduceResponseData.BatchIndexAndErrorMessage)recordErrors.get(0)).batchIndexErrorMessage().endsWith(new StringBuilder(35).append("rejected by the record interceptor ").append(InterceptorUtils.MockRecordInterceptor.class.getName()).toString()));
        Assertions.assertEquals((int)1, (int)((ProduceResponseData.BatchIndexAndErrorMessage)recordErrors.get(1)).batchIndex());
        Assertions.assertTrue((boolean)((ProduceResponseData.BatchIndexAndErrorMessage)recordErrors.get(1)).batchIndexErrorMessage().endsWith(new StringBuilder(35).append("rejected by the record interceptor ").append(InterceptorUtils.MockRecordInterceptor.class.getName()).toString()));
        Assertions.assertEquals((int)4, (int)((ProduceResponseData.BatchIndexAndErrorMessage)recordErrors.get(2)).batchIndex());
        Assertions.assertTrue((boolean)((ProduceResponseData.BatchIndexAndErrorMessage)recordErrors.get(2)).batchIndexErrorMessage().endsWith(new StringBuilder(35).append("rejected by the record interceptor ").append(InterceptorUtils.MockRecordInterceptor.class.getName()).toString()));
        Assertions.assertTrue((boolean)partitionResponse.errorMessage().startsWith("One or more records have been rejected due to 3 record errors in total"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testProduceRequestIncludesRecordsRejectedByDifferentInterceptors() {
        void withRecords_records;
        void withRecords_timestampType;
        String topic = "topic";
        int partition = 0;
        Properties topicConfig = new Properties();
        topicConfig.setProperty("confluent.append.record.interceptor.classes", new StringBuilder(1).append(InterceptorUtils.MockRecordInterceptor.class.getName()).append(",").append(InterceptorUtils.AnotherMockRecordInterceptor.class.getName()).toString());
        int leader = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaBroker>)this.servers(), topicConfig).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key0".getBytes(), "reject me".getBytes()), new SimpleRecord(System.currentTimeMillis(), "key1".getBytes(), "value".getBytes()), new SimpleRecord(System.currentTimeMillis(), "key2".getBytes(), "reject me please".getBytes()), new SimpleRecord(System.currentTimeMillis(), "key3".getBytes(), "value".getBytes())};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var11_6 = null;
        simpleRecordArray = null;
        MemoryRecords memoryRecords = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        ProduceResponse produceResponse = this.sendProduceRequest(leader, this.buildProduceRequest(topicPartition, -1, 3000, (Records)memoryRecords));
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicResponse = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse.data().responses()).asScala().head();
        Assertions.assertEquals((int)1, (int)topicResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionResponse = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicResponse.partitionResponses()).asScala().head();
        Assertions.assertEquals((Object)topicPartition.topic(), (Object)topicResponse.name());
        Assertions.assertEquals((int)topicPartition.partition(), (int)partitionResponse.index());
        Assertions.assertEquals((short)Errors.INVALID_RECORD.code(), (short)partitionResponse.errorCode());
        Assertions.assertEquals((long)-1L, (long)partitionResponse.baseOffset());
        Assertions.assertEquals((long)-1L, (long)partitionResponse.logAppendTimeMs());
        Assertions.assertNotNull((Object)partitionResponse.recordErrors());
        java.util.List recordErrors = partitionResponse.recordErrors();
        Assertions.assertEquals((int)2, (int)recordErrors.size());
        Assertions.assertEquals((int)0, (int)((ProduceResponseData.BatchIndexAndErrorMessage)recordErrors.get(0)).batchIndex());
        Assertions.assertTrue((boolean)((ProduceResponseData.BatchIndexAndErrorMessage)partitionResponse.recordErrors().get(0)).batchIndexErrorMessage().endsWith(new StringBuilder(35).append("rejected by the record interceptor ").append(InterceptorUtils.MockRecordInterceptor.class.getName()).toString()));
        Assertions.assertEquals((int)2, (int)((ProduceResponseData.BatchIndexAndErrorMessage)recordErrors.get(1)).batchIndex());
        Assertions.assertTrue((boolean)((ProduceResponseData.BatchIndexAndErrorMessage)partitionResponse.recordErrors().get(1)).batchIndexErrorMessage().endsWith(new StringBuilder(35).append("rejected by the record interceptor ").append(InterceptorUtils.AnotherMockRecordInterceptor.class.getName()).toString()));
        Assertions.assertTrue((boolean)partitionResponse.errorMessage().startsWith("One or more records have been rejected due to 2 record errors in total"));
    }

    private ProduceRequest buildProduceRequest(TopicPartition topicPartition, int acks, int timeoutMs, Records records) {
        ProduceRequestData.PartitionProduceData partitionData = new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)records);
        ProduceRequestData.TopicProduceData topicData = new ProduceRequestData.TopicProduceData().setName(topicPartition.topic()).setPartitionData(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)partitionData, (List)Nil$.MODULE$)).asJava());
        ProduceRequestData produceData = new ProduceRequestData().setAcks((short)acks).setTimeoutMs(timeoutMs);
        produceData.topicData().add((ImplicitLinkedHashCollection.Element)topicData);
        return (ProduceRequest)ProduceRequest.forMagic((byte)2, (ProduceRequestData)produceData).build();
    }

    @Test
    public void testProduceRequestIncludesInvalidTimestampAndInterceptedRecords() {
        String topic = "topic";
        int partition = 0;
        Properties topicConfig = new Properties();
        topicConfig.setProperty("message.timestamp.difference.max.ms", "1000");
        topicConfig.setProperty("confluent.append.record.interceptor.classes", InterceptorUtils.MockRecordInterceptor.class.getName());
        int leader = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaBroker>)this.servers(), topicConfig).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        long timestamp = System.currentTimeMillis() - 1001L;
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(512), (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(1L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "beautiful".getBytes());
        builder.appendWithOffset(3L, System.currentTimeMillis(), null, "reject me".getBytes());
        MemoryRecords records = builder.build();
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        ProduceResponse produceResponse = this.sendProduceRequest(leader, this.buildProduceRequest(topicPartition, -1, 3000, (Records)records));
        ProduceResponseData.TopicProduceResponse topicResponse = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse.data().responses()).asScala().head();
        ProduceResponseData.PartitionProduceResponse partitionResponse = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicResponse.partitionResponses()).asScala().head();
        Assertions.assertEquals((Object)topicPartition.topic(), (Object)topicResponse.name());
        Assertions.assertEquals((int)topicPartition.partition(), (int)partitionResponse.index());
        Assertions.assertEquals((short)Errors.INVALID_TIMESTAMP.code(), (short)partitionResponse.errorCode());
        Assertions.assertEquals((int)4, (int)partitionResponse.recordErrors().size());
        Assertions.assertTrue((boolean)((ProduceResponseData.BatchIndexAndErrorMessage)partitionResponse.recordErrors().get(3)).batchIndexErrorMessage().endsWith(new StringBuilder(35).append("rejected by the record interceptor ").append(InterceptorUtils.MockRecordInterceptor.class.getName()).toString()));
        Assertions.assertEquals((Object)"One or more records have been rejected due to invalid timestamp", (Object)partitionResponse.errorMessage());
    }

    private ProduceResponse sendProduceRequest(int leaderId, ProduceRequest request) {
        return (ProduceResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ProduceResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private final void sendAndCheck$1(MemoryRecords memoryRecords, long expectedOffset, int partition$1, int leader$1) {
        TopicPartition topicPartition = new TopicPartition("topic", partition$1);
        ProduceRequestData forCurrentMagic_data = new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(topicPartition.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)memoryRecords)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null);
        Object var11_6 = null;
        ProduceResponse produceResponse = this.sendProduceRequest(leader$1, (ProduceRequest)ProduceRequest.forMagic((byte)2, (ProduceRequestData)forCurrentMagic_data).build());
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse.data().responses()).asScala().head();
        Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicProduceResponse.partitionResponses()).asScala().head();
        TopicPartition tp = new TopicPartition(topicProduceResponse.name(), partitionProduceResponse.index());
        Assertions.assertEquals((Object)topicPartition, (Object)tp);
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
        Assertions.assertEquals((long)expectedOffset, (long)partitionProduceResponse.baseOffset());
        Assertions.assertEquals((long)-1L, (long)partitionProduceResponse.logAppendTimeMs());
        Assertions.assertTrue((boolean)partitionProduceResponse.recordErrors().isEmpty());
    }

    public static final /* synthetic */ int $anonfun$testProduceRequestDuringPartitionRecoveryAfterUncleanLeaderElection$2(KafkaServer x$3) {
        return x$3.config().brokerId();
    }

    /*
     * WARNING - void declaration
     */
    private final void produceRecordsAndValidateResponse$1(int brokerId, Errors error, int expectedOffset, TopicPartition partition$2) {
        void withRecords_records;
        void withRecords_timestampType;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var9_6 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        ProduceResponse produceResponse = this.sendProduceRequest(brokerId, this.buildProduceRequest(partition$2, -1, 3000, (Records)records));
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicResponse = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse.data().responses()).asScala().head();
        Assertions.assertEquals((int)1, (int)topicResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionResponse = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicResponse.partitionResponses()).asScala().head();
        Assertions.assertEquals((Object)partition$2.topic(), (Object)topicResponse.name());
        Assertions.assertEquals((int)partition$2.partition(), (int)partitionResponse.index());
        Assertions.assertEquals((long)expectedOffset, (long)partitionResponse.baseOffset(), (String)"Unexpected base Offset");
        Assertions.assertEquals((short)error.code(), (short)partitionResponse.errorCode(), (String)"Unexpected error");
        if (Errors.NONE.equals(error)) {
            Assertions.assertNotEquals((long)-1L, (long)partitionResponse.logAppendTimeMs(), (String)"Unexpected logAppendTime");
            Assertions.assertNotEquals((long)-1L, (long)partitionResponse.logStartOffset(), (String)"No error; Unexpected logStartOffset");
        } else {
            Assertions.assertEquals((long)-1L, (long)partitionResponse.logAppendTimeMs(), (String)"Unexpected logAppendTime during error condition");
            Assertions.assertEquals((long)-1L, (long)partitionResponse.logStartOffset(), (String)"Unexpected logStartOffset during error condition");
        }
        Assertions.assertTrue((boolean)partitionResponse.recordErrors().isEmpty());
    }

    public static final /* synthetic */ boolean $anonfun$testProduceRequestDuringPartitionRecoveryAfterUncleanLeaderElection$4(int leader$2, KafkaServer x$5) {
        return x$5.config().brokerId() == leader$2;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceRequestDuringPartitionRecoveryAfterUncleanLeaderElection$5(int leader$2, KafkaServer x$6) {
        return x$6.config().brokerId() == leader$2;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceRequestDuringPartitionRecoveryAfterUncleanLeaderElection$6(int leader$2, KafkaServer x$7) {
        return x$7.config().brokerId() == leader$2;
    }

    private static final MemoryRecords createRecords$1(byte magicValue, long timestamp, CompressionType codec) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(512), (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(1L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    public static final /* synthetic */ void $anonfun$testProduceWithInvalidTimestamp$2(ProduceResponseData.BatchIndexAndErrorMessage recordError) {
        Assertions.assertNotNull((Object)recordError.batchIndexErrorMessage());
    }

    public static final /* synthetic */ boolean $anonfun$testProduceToNonReplica$1(int leader$3, KafkaBroker x$8) {
        return x$8.config().brokerId() != leader$3;
    }

    public static final /* synthetic */ boolean $anonfun$testCorruptLz4ProduceRequest$1(MetricName x$10) {
        return x$10.getMBeanName().endsWith(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMessageCrcRecordsPerSec()));
    }
}

