/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.server.BaseClientQuotaManagerTest;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ProducerIdQuotaManager;
import kafka.server.ProducerIdQuotaManagerConfig;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005m3Aa\u0004\t\u0001+!)!\u0004\u0001C\u00017!9Q\u0004\u0001b\u0001\n\u0013q\u0002BB\u0014\u0001A\u0003%q\u0004C\u0004)\u0001\t\u0007I\u0011\u0002\u0010\t\r%\u0002\u0001\u0015!\u0003 \u0011\u001dQ\u0003A1A\u0005\n-Baa\f\u0001!\u0002\u0013a\u0003b\u0002\u0019\u0001\u0005\u0004%I!\r\u0005\u0007k\u0001\u0001\u000b\u0011\u0002\u001a\t\u000bY\u0002A\u0011B\u001c\t\u000b\u0019\u0003A\u0011A$\t\u000bU\u0003A\u0011A$\t\u000b]\u0003A\u0011A$\t\u000be\u0003A\u0011A$\u00035A\u0013x\u000eZ;dKJLE-U;pi\u0006l\u0015M\\1hKJ$Vm\u001d;\u000b\u0005E\u0011\u0012AB:feZ,'OC\u0001\u0014\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]AR\"\u0001\t\n\u0005e\u0001\"A\u0007\"bg\u0016\u001cE.[3oiF+x\u000e^1NC:\fw-\u001a:UKN$\u0018A\u0002\u001fj]&$h\bF\u0001\u001d!\t9\u0002!\u0001\u0003Vg\u0016\u0014X#A\u0010\u0011\u0005\u0001*S\"A\u0011\u000b\u0005\t\u001a\u0013\u0001\u00027b]\u001eT\u0011\u0001J\u0001\u0005U\u00064\u0018-\u0003\u0002'C\t11\u000b\u001e:j]\u001e\fQ!V:fe\u0002\n\u0001b\u00117jK:$\u0018\nZ\u0001\n\u00072LWM\u001c;JI\u0002\naaY8oM&<W#\u0001\u0017\u0011\u0005]i\u0013B\u0001\u0018\u0011\u0005q\u0001&o\u001c3vG\u0016\u0014\u0018\nZ)v_R\fW*\u00198bO\u0016\u00148i\u001c8gS\u001e\fqaY8oM&<\u0007%\u0001\u0007dY&,g\u000e^\"p]\u001aLw-F\u00013!\t92'\u0003\u00025!\tA2\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0007>tg-[4\u0002\u001b\rd\u0017.\u001a8u\u0007>tg-[4!\u0003A9\u0018\u000e\u001e5Rk>$\u0018-T1oC\u001e,'\u000f\u0006\u00029}A\u0011\u0011\bP\u0007\u0002u)\t1(A\u0003tG\u0006d\u0017-\u0003\u0002>u\t!QK\\5u\u0011\u0015y$\u00021\u0001A\u0003\u00051\u0007\u0003B\u001dB\u0007bJ!A\u0011\u001e\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CA\fE\u0013\t)\u0005C\u0001\fQe>$WoY3s\u0013\u0012\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0003=\"Xm\u001d;O_RC'o\u001c;uY\u0016<\u0006.\u001a8CK2|woQ8v]R\fVo\u001c;b\u0005\u0016dwn\u001e*bi\u0016\fVo\u001c;b)\u0005A\u0004FA\u0006J!\tQ5+D\u0001L\u0015\taU*A\u0002ba&T!AT(\u0002\u000f),\b/\u001b;fe*\u0011\u0001+U\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002%\u0006\u0019qN]4\n\u0005Q[%\u0001\u0002+fgR\fq\u0006^3ti:{G\u000b\u001b:piRdWm\u00165f]\n+Gn\\<D_VtG/U;pi\u0006\f%m\u001c<f%\u0006$X-U;pi\u0006D#\u0001D%\u0002_Q,7\u000f\u001e(p)\"\u0014x\u000e\u001e;mK^CWM\\!c_Z,7i\\;oiF+x\u000e^1CK2|wOU1uKF+x\u000e^1)\u00055I\u0015!\f;fgR$\u0006N]8ui2,w\u000b[3o\u0003\n|g/Z\"pk:$\u0018+^8uC\u0006\u0013wN^3SCR,\u0017+^8uC\"\u0012a\"\u0013")
public class ProducerIdQuotaManagerTest
extends BaseClientQuotaManagerTest {
    private final String User;
    private final String ClientId;
    private final ProducerIdQuotaManagerConfig config = new ProducerIdQuotaManagerConfig(100, 100);
    private final ClientQuotaManagerConfig clientConfig = new ClientQuotaManagerConfig(10, 1, ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L, 0, Long.MAX_VALUE);

    private String User() {
        return this.User;
    }

    private String ClientId() {
        return this.ClientId;
    }

    private ProducerIdQuotaManagerConfig config() {
        return this.config;
    }

    private ClientQuotaManagerConfig clientConfig() {
        return this.clientConfig;
    }

    private void withQuotaManager(Function1<ProducerIdQuotaManager, BoxedUnit> f) {
        ProducerIdQuotaManager quotaManager = new ProducerIdQuotaManager(this.config(), this.clientConfig(), this.metrics(), (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            f.apply((Object)quotaManager);
        }
        finally {
            quotaManager.shutdown();
        }
    }

    @Test
    public void testNoThrottleWhenBelowCountQuotaBelowRateQuota() {
        ProducerIdQuotaManager withQuotaManager_quotaManager = new ProducerIdQuotaManager(this.config(), this.clientConfig(), this.metrics(), (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            ProducerIdQuotaManagerTest.$anonfun$testNoThrottleWhenBelowCountQuotaBelowRateQuota$1(this, withQuotaManager_quotaManager);
        }
        finally {
            withQuotaManager_quotaManager.shutdown();
        }
    }

    @Test
    public void testNoThrottleWhenBelowCountQuotaAboveRateQuota() {
        ProducerIdQuotaManager withQuotaManager_quotaManager = new ProducerIdQuotaManager(this.config(), this.clientConfig(), this.metrics(), (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            ProducerIdQuotaManagerTest.$anonfun$testNoThrottleWhenBelowCountQuotaAboveRateQuota$1(this, withQuotaManager_quotaManager);
        }
        finally {
            withQuotaManager_quotaManager.shutdown();
        }
    }

    @Test
    public void testNoThrottleWhenAboveCountQuotaBelowRateQuota() {
        ProducerIdQuotaManager withQuotaManager_quotaManager = new ProducerIdQuotaManager(this.config(), this.clientConfig(), this.metrics(), (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            ProducerIdQuotaManagerTest.$anonfun$testNoThrottleWhenAboveCountQuotaBelowRateQuota$1(this, withQuotaManager_quotaManager);
        }
        finally {
            withQuotaManager_quotaManager.shutdown();
        }
    }

    @Test
    public void testThrottleWhenAboveCountQuotaAboveRateQuota() {
        ProducerIdQuotaManager withQuotaManager_quotaManager = new ProducerIdQuotaManager(this.config(), this.clientConfig(), this.metrics(), (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            ProducerIdQuotaManagerTest.$anonfun$testThrottleWhenAboveCountQuotaAboveRateQuota$1(this, withQuotaManager_quotaManager);
        }
        finally {
            withQuotaManager_quotaManager.shutdown();
        }
    }

    public static final /* synthetic */ void $anonfun$testNoThrottleWhenBelowCountQuotaBelowRateQuota$1(ProducerIdQuotaManagerTest $this, ProducerIdQuotaManager quotaManager) {
        double upperBound_upperBound = 10.0;
        quotaManager.updateQuota((Option)new Some((Object)$this.User()), (Option)new Some((Object)$this.ClientId()), (Option)new Some((Object)$this.ClientId()), (Option)new Some((Object)new Quota(upperBound_upperBound, true)));
        KafkaMetric queueSizeMetric = (KafkaMetric)$this.metrics().metrics().get($this.metrics().metricName("queue-size", "ProducerId", ""));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
            Assertions.assertEquals((int)0, (int)$this.maybeRecord((ClientQuotaManager)quotaManager, $this.User(), $this.ClientId(), 1.0));
            $this.time().sleep(1000L);
        });
        Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
    }

    public static final /* synthetic */ void $anonfun$testNoThrottleWhenBelowCountQuotaAboveRateQuota$1(ProducerIdQuotaManagerTest $this, ProducerIdQuotaManager quotaManager) {
        double upperBound_upperBound = 1.0;
        quotaManager.updateQuota((Option)new Some((Object)$this.User()), (Option)new Some((Object)$this.ClientId()), (Option)new Some((Object)$this.ClientId()), (Option)new Some((Object)new Quota(upperBound_upperBound, true)));
        KafkaMetric queueSizeMetric = (KafkaMetric)$this.metrics().metrics().get($this.metrics().metricName("queue-size", "ProducerId", ""));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
            Assertions.assertEquals((int)0, (int)$this.maybeRecord((ClientQuotaManager)quotaManager, $this.User(), $this.ClientId(), 2.0));
            $this.time().sleep(1000L);
        });
        Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
    }

    public static final /* synthetic */ void $anonfun$testNoThrottleWhenAboveCountQuotaBelowRateQuota$1(ProducerIdQuotaManagerTest $this, ProducerIdQuotaManager quotaManager) {
        double upperBound_upperBound = 10.0;
        quotaManager.updateQuota((Option)new Some((Object)$this.User()), (Option)new Some((Object)$this.ClientId()), (Option)new Some((Object)$this.ClientId()), (Option)new Some((Object)new Quota(upperBound_upperBound, true)));
        KafkaMetric queueSizeMetric = (KafkaMetric)$this.metrics().metrics().get($this.metrics().metricName("queue-size", "ProducerId", ""));
        Assertions.assertEquals((int)0, (int)$this.maybeRecord((ClientQuotaManager)quotaManager, $this.User(), $this.ClientId(), 100.0));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> {
            Assertions.assertEquals((int)0, (int)$this.maybeRecord((ClientQuotaManager)quotaManager, $this.User(), $this.ClientId(), 1.0));
            $this.time().sleep(1000L);
        });
        Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
    }

    public static final /* synthetic */ void $anonfun$testThrottleWhenAboveCountQuotaAboveRateQuota$1(ProducerIdQuotaManagerTest $this, ProducerIdQuotaManager quotaManager) {
        double upperBound_upperBound = 10.0;
        quotaManager.updateQuota((Option)new Some((Object)$this.User()), (Option)new Some((Object)$this.ClientId()), (Option)new Some((Object)$this.ClientId()), (Option)new Some((Object)new Quota(upperBound_upperBound, true)));
        KafkaMetric queueSizeMetric = (KafkaMetric)$this.metrics().metrics().get($this.metrics().metricName("queue-size", "ProducerId", ""));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> {
            Assertions.assertEquals((int)0, (int)$this.maybeRecord((ClientQuotaManager)quotaManager, $this.User(), $this.ClientId(), 10.0));
            $this.time().sleep(1000L);
        });
        Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
        int throttleTime = $this.maybeRecord((ClientQuotaManager)quotaManager, $this.User(), $this.ClientId(), 110.0);
        Assertions.assertEquals((int)0, (int)throttleTime, (String)"Should not be throttled");
        throttleTime = $this.maybeRecord((ClientQuotaManager)quotaManager, $this.User(), $this.ClientId(), 110.0);
        Assertions.assertEquals((int)1000, (int)throttleTime, (String)"Should be throttled");
        $this.throttle((ClientQuotaManager)quotaManager, $this.User(), $this.ClientId(), throttleTime, $this.callback());
        Assertions.assertEquals((int)1, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
    }

    public ProducerIdQuotaManagerTest() {
        this.User = "ANONYMOUS";
        this.ClientId = "test-client";
    }

    public static final /* synthetic */ Object $anonfun$testNoThrottleWhenBelowCountQuotaBelowRateQuota$1$adapted(ProducerIdQuotaManagerTest $this, ProducerIdQuotaManager quotaManager) {
        ProducerIdQuotaManagerTest.$anonfun$testNoThrottleWhenBelowCountQuotaBelowRateQuota$1($this, quotaManager);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testNoThrottleWhenBelowCountQuotaAboveRateQuota$1$adapted(ProducerIdQuotaManagerTest $this, ProducerIdQuotaManager quotaManager) {
        ProducerIdQuotaManagerTest.$anonfun$testNoThrottleWhenBelowCountQuotaAboveRateQuota$1($this, quotaManager);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testNoThrottleWhenAboveCountQuotaBelowRateQuota$1$adapted(ProducerIdQuotaManagerTest $this, ProducerIdQuotaManager quotaManager) {
        ProducerIdQuotaManagerTest.$anonfun$testNoThrottleWhenAboveCountQuotaBelowRateQuota$1($this, quotaManager);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testThrottleWhenAboveCountQuotaAboveRateQuota$1$adapted(ProducerIdQuotaManagerTest $this, ProducerIdQuotaManager quotaManager) {
        ProducerIdQuotaManagerTest.$anonfun$testThrottleWhenAboveCountQuotaAboveRateQuota$1($this, quotaManager);
        return BoxedUnit.UNIT;
    }
}

