/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.kafka.replication.push.ReplicationConfig;
import io.confluent.kafka.replication.push.ReplicationState;
import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.server.BaseFetchRequestTest;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005=c\u0001\u0002\u000b\u0016\u0001iAQa\b\u0001\u0005\u0002\u0001BqA\t\u0001C\u0002\u0013\u00051\u0005\u0003\u0004-\u0001\u0001\u0006I\u0001\n\u0005\b[\u0001\u0011\r\u0011\"\u0001/\u0011\u0019Q\u0004\u0001)A\u0005_!91\b\u0001b\u0001\n\u0003q\u0003B\u0002\u001f\u0001A\u0003%q\u0006C\u0005>\u0001\u0001\u0007\t\u0019!C\u0001}!I\u0001\u000b\u0001a\u0001\u0002\u0004%\t!\u0015\u0005\n/\u0002\u0001\r\u0011!Q!\n}Bq\u0001\u0017\u0001C\u0002\u0013\u0005\u0011\f\u0003\u0004[\u0001\u0001\u0006Ia\u0012\u0005\b7\u0002\u0011\r\u0011\"\u0001Z\u0011\u0019a\u0006\u0001)A\u0005\u000f\")Q\f\u0001C!=\")!\r\u0001C\u0001G\")!\u000e\u0001C!W\")Q\u000f\u0001C!m\"9\u0011q\u0002\u0001\u0005\u0002\u0005E!\u0001\n)vg\"\u0014V\r\u001d7jG\u0006$\u0018n\u001c8Ck\u001a4WM]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005Y9\u0012AB:feZ,'OC\u0001\u0019\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u000e\u0011\u0005qiR\"A\u000b\n\u0005y)\"\u0001\u0006\"bg\u00164U\r^2i%\u0016\fX/Z:u)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002CA\u0011A\u0004A\u0001\u0006i>\u0004\u0018nY\u000b\u0002IA\u0011QEK\u0007\u0002M)\u0011q\u0005K\u0001\u0005Y\u0006twMC\u0001*\u0003\u0011Q\u0017M^1\n\u0005-2#AB*ue&tw-\u0001\u0004u_BL7\rI\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oaU\tq\u0006\u0005\u00021q5\t\u0011G\u0003\u00023g\u000511m\\7n_:T!\u0001\u0007\u001b\u000b\u0005U2\u0014AB1qC\u000eDWMC\u00018\u0003\ry'oZ\u0005\u0003sE\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\tu_BL7\rU1si&$\u0018n\u001c81A\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t\u0017'\u0001\tu_BL7\rU1si&$\u0018n\u001c82A\u0005)bn\u001c8JI\u0016l\u0007o\u001c;f]R\u0004&o\u001c3vG\u0016\u0014X#A \u0011\t\u0001+uiR\u0007\u0002\u0003*\u0011!iQ\u0001\taJ|G-^2fe*\u0011AiM\u0001\bG2LWM\u001c;t\u0013\t1\u0015IA\u0007LC\u001a\\\u0017\r\u0015:pIV\u001cWM\u001d\t\u0004\u0011.kU\"A%\u000b\u0003)\u000bQa]2bY\u0006L!\u0001T%\u0003\u000b\u0005\u0013(/Y=\u0011\u0005!s\u0015BA(J\u0005\u0011\u0011\u0015\u0010^3\u000239|g.\u00133f[B|G/\u001a8u!J|G-^2fe~#S-\u001d\u000b\u0003%V\u0003\"\u0001S*\n\u0005QK%\u0001B+oSRDqAV\u0005\u0002\u0002\u0003\u0007q(A\u0002yIE\naC\\8o\u0013\u0012,W\u000e]8uK:$\bK]8ek\u000e,'\u000fI\u0001\u0007[N<\u0017g\u0013\"\u0016\u0003\u001d\u000bq!\\:hc-\u0013\u0005%\u0001\u0004ng\u001e\u001c4JQ\u0001\b[N<7g\u0013\"!\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u0003}\u0003\"\u0001\u00131\n\u0005\u0005L%aA%oi\u0006yqN^3se&$\u0017N\\4Qe>\u00048/F\u0001e!\t)\u0007.D\u0001g\u0015\t9\u0007&\u0001\u0003vi&d\u0017BA5g\u0005)\u0001&o\u001c9feRLWm]\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgV\tA\u000eE\u0002naJl\u0011A\u001c\u0006\u0003_&\u000b!bY8mY\u0016\u001cG/[8o\u0013\t\thNA\u0002TKF\u0004\"\u0001H:\n\u0005Q,\"aC&bM.\f7i\u001c8gS\u001e\fQa]3u+B$\"AU<\t\u000ba\u0014\u0002\u0019A=\u0002\u0011Q,7\u000f^%oM>\u00042A_A\u0002\u001b\u0005Y(B\u0001?~\u0003\r\t\u0007/\u001b\u0006\u0003}~\fqA[;qSR,'OC\u0002\u0002\u0002Y\nQA[;oSRL1!!\u0002|\u0005!!Vm\u001d;J]\u001a|\u0007f\u0001\n\u0002\nA\u0019!0a\u0003\n\u0007\u000551P\u0001\u0006CK\u001a|'/Z#bG\"\f!\u0004^3tiB\u0013x\u000eZ;dK>3XM\u001d\"vM\u001a,'\u000fT5nSR$2AUA\n\u0011\u001d\t)b\u0005a\u0001\u0003/\ta!];peVl\u0007\u0003BA\r\u0003OqA!a\u0007\u0002$A\u0019\u0011QD%\u000e\u0005\u0005}!bAA\u00113\u00051AH]8pizJ1!!\nJ\u0003\u0019\u0001&/\u001a3fM&\u00191&!\u000b\u000b\u0007\u0005\u0015\u0012\nK\u0002\u0014\u0003[\u0001B!a\f\u000265\u0011\u0011\u0011\u0007\u0006\u0004\u0003gi\u0018A\u00029be\u0006l7/\u0003\u0003\u00028\u0005E\"!\u0005)be\u0006lW\r^3sSj,G\rV3ti\":1#a\u000f\u0002H\u0005%\u0003\u0003BA\u001f\u0003\u0007j!!a\u0010\u000b\t\u0005\u0005\u0013\u0011G\u0001\taJ|g/\u001b3fe&!\u0011QIA \u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\u0012\u00111J\u0011\u0003\u0003\u001b\nQa\u001b:bMR\u0004")
public class PushReplicationBufferIntegrationTest
extends BaseFetchRequestTest {
    private final String topic;
    private final TopicPartition topicPartition0 = new TopicPartition(this.topic(), 0);
    private final TopicPartition topicPartition1 = new TopicPartition(this.topic(), 1);
    private KafkaProducer<byte[], byte[]> nonIdempotentProducer;
    private final byte[] msg1KB = new byte[1000];
    private final byte[] msg3KB = new byte[3000];

    public String topic() {
        return this.topic;
    }

    public TopicPartition topicPartition0() {
        return this.topicPartition0;
    }

    public TopicPartition topicPartition1() {
        return this.topicPartition1;
    }

    public KafkaProducer<byte[], byte[]> nonIdempotentProducer() {
        return this.nonIdempotentProducer;
    }

    public void nonIdempotentProducer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.nonIdempotentProducer = x$1;
    }

    public byte[] msg1KB() {
        return this.msg1KB;
    }

    public byte[] msg3KB() {
        return this.msg3KB;
    }

    @Override
    public int brokerCount() {
        return 2;
    }

    public Properties overridingProps() {
        Properties props = new Properties();
        props.put("confluent.api.visibility", ApiMessageType.ApiVisibility.CONFLUENT_CLOUD.toString());
        props.put("confluent.replication.push.feature.enable", "true");
        props.put("confluent.replication.mode", ReplicationConfig.Mode.PULL_PUSH.toString());
        props.put("confluent.replication.linger.ms", "2000");
        props.put("confluent.replication.max.wait.ms", "2000");
        props.put("confluent.replication.max.memory.buffer.bytes", "10000");
        return props;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$1 = this.brokerCount();
        String x$22 = this.zkConnectOrNull();
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        boolean x$11 = false;
        boolean x$12 = false;
        Map x$13 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        int x$14 = 1;
        boolean x$15 = false;
        int x$16 = 1;
        short x$17 = 1;
        int x$18 = 0;
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$1, x$22, false, x$5, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, (Map<Object, String>)x$13, x$14, x$15, x$16, x$17, x$18, true).map((Function1 & Serializable)x$2 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$2, fromProps_overrides, true);
        });
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.createTopicWithAssignment(this.topic(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.createTopicWithAssignment$default$3());
        Properties producerProps = new Properties();
        producerProps.put("enable.idempotence", "false");
        producerProps.put("acks", "1");
        this.nonIdempotentProducer_$eq(this.createProducer(new ByteArraySerializer(), new ByteArraySerializer(), producerProps));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testProduceOverBufferLimit(String quorum) {
        TestUtils$.MODULE$.waitUntilReplicasInPushMode((Seq<KafkaBroker>)this.brokers(), this.topicPartition0());
        TestUtils$.MODULE$.waitUntilReplicasInPushMode((Seq<KafkaBroker>)this.brokers(), this.topicPartition1());
        Assertions.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.brokers().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)PushReplicationBufferIntegrationTest.$anonfun$testProduceOverBufferLimit$1(x$3)))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)x$4 -> PushReplicationBufferIntegrationTest.$anonfun$testProduceOverBufferLimit$2(this, BoxesRunTime.unboxToInt((Object)x$4)));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)x$5 -> PushReplicationBufferIntegrationTest.$anonfun$testProduceOverBufferLimit$3(this, BoxesRunTime.unboxToInt((Object)x$5)));
        Assertions.assertTrue((boolean)TestUtils$.MODULE$.hasAllReplicasInReplicationMode((Seq<KafkaBroker>)this.brokers(), this.topicPartition0(), ReplicationState.Mode.PUSH));
        Assertions.assertTrue((boolean)TestUtils$.MODULE$.hasAllReplicasInReplicationMode((Seq<KafkaBroker>)this.brokers(), this.topicPartition1(), ReplicationState.Mode.PUSH));
        this.nonIdempotentProducer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg3KB())).get();
        Assertions.assertTrue((boolean)TestUtils$.MODULE$.hasAllReplicasInReplicationMode((Seq<KafkaBroker>)this.brokers(), this.topicPartition1(), ReplicationState.Mode.PUSH));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 10000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PushReplicationBufferIntegrationTest.$anonfun$testProduceOverBufferLimit$4(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for follower pull transitions");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.nonIdempotentProducer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(1), null, (Object)this.msg3KB())).get();
        Assertions.assertTrue((boolean)TestUtils$.MODULE$.hasAllReplicasInReplicationMode((Seq<KafkaBroker>)this.brokers(), this.topicPartition1(), ReplicationState.Mode.PUSH));
    }

    public static final /* synthetic */ long $anonfun$testProduceOverBufferLimit$1(KafkaBroker x$3) {
        return x$3.replicaManager().pullTransitionsCount().count();
    }

    public static final /* synthetic */ RecordMetadata $anonfun$testProduceOverBufferLimit$2(PushReplicationBufferIntegrationTest $this, int x$4) {
        return (RecordMetadata)$this.nonIdempotentProducer().send(new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)$this.msg1KB())).get();
    }

    public static final /* synthetic */ RecordMetadata $anonfun$testProduceOverBufferLimit$3(PushReplicationBufferIntegrationTest $this, int x$5) {
        return (RecordMetadata)$this.nonIdempotentProducer().send(new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(1), null, (Object)$this.msg1KB())).get();
    }

    public static final /* synthetic */ boolean $anonfun$testProduceOverBufferLimit$4(PushReplicationBufferIntegrationTest $this) {
        return ((KafkaBroker)$this.brokers().apply(1)).replicaManager().pullTransitionsCount().count() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testProduceOverBufferLimit$5() {
        return "Timed out waiting for follower pull transitions";
    }

    public PushReplicationBufferIntegrationTest() {
        this.topic = "topic";
    }
}

