/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.kafka.replication.push.ReplicationConfig;
import io.confluent.kafka.replication.push.ReplicationState;
import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.server.BaseFetchRequestTest;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.PushReplicationIntegrationTest$RecordRead$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@Tag(value="bazel:shard_count:2")
@ScalaSignature(bytes="\u0006\u0005\r-g\u0001\u0002&L\u0001ACQ!\u0016\u0001\u0005\u0002YCq\u0001\u0017\u0001C\u0002\u0013\u0005\u0011\f\u0003\u0004a\u0001\u0001\u0006IA\u0017\u0005\bC\u0002\u0011\r\u0011\"\u0001c\u0011\u0019Y\u0007\u0001)A\u0005G\"9A\u000e\u0001b\u0001\n\u0003i\u0007BB=\u0001A\u0003%a\u000eC\u0004{\u0001\t\u0007I\u0011A>\t\r}\u0004\u0001\u0015!\u0003}\u0011!\t\t\u0001\u0001b\u0001\n\u0003Y\bbBA\u0002\u0001\u0001\u0006I\u0001 \u0005\u000b\u0003\u000b\u0001\u0001\u0019!a\u0001\n\u0003I\u0006bCA\u0004\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0013A!\"!\u0006\u0001\u0001\u0004\u0005\t\u0015)\u0003[\u0011-\t9\u0002\u0001a\u0001\u0002\u0004%\t!!\u0007\t\u0017\u0005\u0005\u0002\u00011AA\u0002\u0013\u0005\u00111\u0005\u0005\f\u0003O\u0001\u0001\u0019!A!B\u0013\tY\u0002C\u0006\u0002*\u0001\u0001\r\u00111A\u0005\u0002\u0005-\u0002bCA#\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u000fB1\"a\u0013\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002.!Y\u0011Q\n\u0001A\u0002\u0003\u0007I\u0011AA(\u0011-\t\t\u0007\u0001a\u0001\u0002\u0004%\t!a\u0019\t\u0017\u0005\u001d\u0004\u00011A\u0001B\u0003&\u0011\u0011\u000b\u0005\f\u0003S\u0002\u0001\u0019!a\u0001\n\u0003\tY\u0007C\u0006\u0002\u0006\u0002\u0001\r\u00111A\u0005\u0002\u0005\u001d\u0005bCAF\u0001\u0001\u0007\t\u0011)Q\u0005\u0003[Ba!!$\u0001\t\u0003J\u0006bBAH\u0001\u0011\u0005\u0011\u0011\u0013\u0005\b\u0003?\u0003A\u0011IAQ\u0011\u001d\t)\f\u0001C!\u0003oCq!!7\u0001\t\u0003\tY\u000eC\u0004\u0003\u0014\u0001!\tA!\u0006\t\u000f\t}\u0001\u0001\"\u0001\u0003\"!9!1\u0006\u0001\u0005\u0002\t5\u0002b\u0002B\u001c\u0001\u0011\u0005!\u0011\b\u0005\b\u0005\u0007\u0002A\u0011\u0001B#\u0011\u001d\u0011y\u0005\u0001C\u0001\u0005#BqAa\u0017\u0001\t\u0003\u0011i\u0006C\u0004\u0003\u0002\u0002!\tAa!\t\u000f\t5\u0005\u0001\"\u0003\u0003\u0010\"I!1\u0017\u0001\u0012\u0002\u0013%!Q\u0017\u0005\b\u0005\u0017\u0004A\u0011\u0002Bg\u0011\u001d\u0011Y\u000e\u0001C\u0001\u0005;DqAa:\u0001\t\u0003\u0011I\u000fC\u0004\u0004p\u0001!Ia!\u001d\t\u000f\rm\u0004\u0001\"\u0003\u0004~\u00191!\u0011\u001f\u0001A\u0005gD\u0011ba\u00020\u0005+\u0007I\u0011A>\t\u0013\r%qF!E!\u0002\u0013a\bBCB\u0006_\tU\r\u0011\"\u0001\u0004\u000e!Q1qB\u0018\u0003\u0012\u0003\u0006I!!9\t\u0015\tUtF!f\u0001\n\u0003\u0019i\u0001\u0003\u0006\u0004\u0012=\u0012\t\u0012)A\u0005\u0003CDa!V\u0018\u0005\u0002\rM\u0001\"CB\u000e_\u0005\u0005I\u0011AB\u000f\u0011%\u0019)cLI\u0001\n\u0003\u00199\u0003C\u0005\u0004,=\n\n\u0011\"\u0001\u0004.!I1\u0011G\u0018\u0012\u0002\u0013\u00051Q\u0006\u0005\t\u0007gy\u0013\u0011!C!E\"A1QG\u0018\u0002\u0002\u0013\u0005\u0011\fC\u0005\u00048=\n\t\u0011\"\u0001\u0004:!I11I\u0018\u0002\u0002\u0013\u00053Q\t\u0005\n\u0007\u001bz\u0013\u0011!C\u0001\u0007\u001fB\u0011ba\u00150\u0003\u0003%\te!\u0016\t\u0013\res&!A\u0005B\rm\u0003\"CB/_\u0005\u0005I\u0011IB0\u0011%\u0019\tgLA\u0001\n\u0003\u001a\u0019gB\u0005\u0004\u0004\u0002\t\t\u0011#\u0001\u0004\u0006\u001aI!\u0011\u001f\u0001\u0002\u0002#\u00051q\u0011\u0005\u0007+\u0016#\taa(\t\u0013\ruS)!A\u0005F\r}\u0003\"CBQ\u000b\u0006\u0005I\u0011QBR\u0011%\u0019Y+RA\u0001\n\u0003\u001biK\u0001\u0010QkND'+\u001a9mS\u000e\fG/[8o\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u0011A*T\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u00039\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001#B\u0011!kU\u0007\u0002\u0017&\u0011Ak\u0013\u0002\u0015\u0005\u0006\u001cXMR3uG\"\u0014V-];fgR$Vm\u001d;\u0002\rqJg.\u001b;?)\u00059\u0006C\u0001*\u0001\u0003)qW/\\+qI\u0006$Xm]\u000b\u00025B\u00111LX\u0007\u00029*\tQ,A\u0003tG\u0006d\u0017-\u0003\u0002`9\n\u0019\u0011J\u001c;\u0002\u00179,X.\u00169eCR,7\u000fI\u0001\u0006i>\u0004\u0018nY\u000b\u0002GB\u0011A-[\u0007\u0002K*\u0011amZ\u0001\u0005Y\u0006twMC\u0001i\u0003\u0011Q\u0017M^1\n\u0005),'AB*ue&tw-\u0001\u0004u_BL7\rI\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o+\u0005q\u0007CA8x\u001b\u0005\u0001(BA9s\u0003\u0019\u0019w.\\7p]*\u0011aj\u001d\u0006\u0003iV\fa!\u00199bG\",'\"\u0001<\u0002\u0007=\u0014x-\u0003\u0002ya\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0011\u0002/A,8\u000f\u001b+sC:\u001c\u0018\u000e^5p]RKW.Z8vi6\u001bX#\u0001?\u0011\u0005mk\u0018B\u0001@]\u0005\u0011auN\\4\u00021A,8\u000f\u001b+sC:\u001c\u0018\u000e^5p]RKW.Z8vi6\u001b\b%\u0001\bsKR\u0014\u0018\u0010V5nK>,H/T:\u0002\u001fI,GO]=US6,w.\u001e;Ng\u0002\n\u0001\u0002\\3bI\u0016\u0014\u0018\nZ\u0001\rY\u0016\fG-\u001a:JI~#S-\u001d\u000b\u0005\u0003\u0017\t\t\u0002E\u0002\\\u0003\u001bI1!a\u0004]\u0005\u0011)f.\u001b;\t\u0011\u0005MQ\"!AA\u0002i\u000b1\u0001\u001f\u00132\u0003%aW-\u00193fe&#\u0007%\u0001\u0007mK\u0006$WM\u001d\"s_.,'/\u0006\u0002\u0002\u001cA\u0019!+!\b\n\u0007\u0005}1JA\u0006LC\u001a\\\u0017M\u0011:pW\u0016\u0014\u0018\u0001\u00057fC\u0012,'O\u0011:pW\u0016\u0014x\fJ3r)\u0011\tY!!\n\t\u0013\u0005M\u0001#!AA\u0002\u0005m\u0011!\u00047fC\u0012,'O\u0011:pW\u0016\u0014\b%A\u0006g_2dwn^3s\u0013\u0012\u001cXCAA\u0017!\u0015\ty#a\u0010[\u001d\u0011\t\t$a\u000f\u000f\t\u0005M\u0012\u0011H\u0007\u0003\u0003kQ1!a\u000eP\u0003\u0019a$o\\8u}%\tQ,C\u0002\u0002>q\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002B\u0005\r#\u0001C%uKJ\f'\r\\3\u000b\u0007\u0005uB,A\bg_2dwn^3s\u0013\u0012\u001cx\fJ3r)\u0011\tY!!\u0013\t\u0013\u0005M1#!AA\u0002\u00055\u0012\u0001\u00044pY2|w/\u001a:JIN\u0004\u0013aC1e[&t7\t\\5f]R,\"!!\u0015\u0011\t\u0005M\u0013QL\u0007\u0003\u0003+RA!a\u0016\u0002Z\u0005)\u0011\rZ7j]*\u0019\u00111\f:\u0002\u000f\rd\u0017.\u001a8ug&!\u0011qLA+\u0005\u0015\tE-\\5o\u0003=\tG-\\5o\u00072LWM\u001c;`I\u0015\fH\u0003BA\u0006\u0003KB\u0011\"a\u0005\u0017\u0003\u0003\u0005\r!!\u0015\u0002\u0019\u0005$W.\u001b8DY&,g\u000e\u001e\u0011\u0002+9|g.\u00133f[B|G/\u001a8u!J|G-^2feV\u0011\u0011Q\u000e\t\t\u0003_\n)(!\u001f\u0002z5\u0011\u0011\u0011\u000f\u0006\u0005\u0003g\nI&\u0001\u0005qe>$WoY3s\u0013\u0011\t9(!\u001d\u0003\u001b-\u000bgm[1Qe>$WoY3s!\u0015Y\u00161PA@\u0013\r\ti\b\u0018\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00047\u0006\u0005\u0015bAAB9\n!!)\u001f;f\u0003eqwN\\%eK6\u0004x\u000e^3oiB\u0013x\u000eZ;dKJ|F%Z9\u0015\t\u0005-\u0011\u0011\u0012\u0005\n\u0003'I\u0012\u0011!a\u0001\u0003[\naC\\8o\u0013\u0012,W\u000e]8uK:$\bK]8ek\u000e,'\u000fI\u0001\fEJ|7.\u001a:D_VtG/A\bpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9t+\t\t\u0019\n\u0005\u0003\u0002\u0016\u0006mUBAAL\u0015\r\tIjZ\u0001\u0005kRLG.\u0003\u0003\u0002\u001e\u0006]%A\u0003)s_B,'\u000f^5fg\u0006yq-\u001a8fe\u0006$XmQ8oM&<7/\u0006\u0002\u0002$B1\u0011QUAV\u0003_k!!a*\u000b\u0007\u0005%F,\u0001\u0006d_2dWm\u0019;j_:LA!!,\u0002(\n\u00191+Z9\u0011\u0007I\u000b\t,C\u0002\u00024.\u00131bS1gW\u0006\u001cuN\u001c4jO\u0006)1/\u001a;VaR!\u00111BA]\u0011\u001d\tYL\ba\u0001\u0003{\u000b\u0001\u0002^3ti&sgm\u001c\t\u0005\u0003\u007f\u000bi-\u0004\u0002\u0002B*!\u00111YAc\u0003\r\t\u0007/\u001b\u0006\u0005\u0003\u000f\fI-A\u0004kkBLG/\u001a:\u000b\u0007\u0005-W/A\u0003kk:LG/\u0003\u0003\u0002P\u0006\u0005'\u0001\u0003+fgRLeNZ8)\u0007y\t\u0019\u000e\u0005\u0003\u0002@\u0006U\u0017\u0002BAl\u0003\u0003\u0014!BQ3g_J,W)Y2i\u0003U!Xm\u001d;Ti\u0016\fG-_*uCR,7+[7qY\u0016$B!a\u0003\u0002^\"9\u0011q\\\u0010A\u0002\u0005\u0005\u0018AB9v_J,X\u000e\u0005\u0003\u0002d\u0006-h\u0002BAs\u0003O\u00042!a\r]\u0013\r\tI\u000fX\u0001\u0007!J,G-\u001a4\n\u0007)\fiOC\u0002\u0002jrC3aHAy!\u0011\t\u00190!?\u000e\u0005\u0005U(\u0002BA|\u0003\u000b\fa\u0001]1sC6\u001c\u0018\u0002BA~\u0003k\u0014\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:uQ\u001dy\u0012q B\u0006\u0005\u001b\u0001BA!\u0001\u0003\b5\u0011!1\u0001\u0006\u0005\u0005\u000b\t)0\u0001\u0005qe>4\u0018\u000eZ3s\u0013\u0011\u0011IAa\u0001\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\t\u0011y!\t\u0002\u0003\u0012\u0005)1N]1gi\u0006iC/Z:u!V\u001c\bNU3qY&\u001c\u0017\r^5p]J+7m\u001c:eK\u0012LeNU3qY&\u001c\u0017\r^5p]F+x\u000e^1\u0015\t\u0005-!q\u0003\u0005\b\u0003?\u0004\u0003\u0019AAqQ\r\u0001\u0013\u0011\u001f\u0015\bA\u0005}(1\u0002B\u000fY\t\u0011y!\u0001\buKN$8*\u001b7m\u0019\u0016\fG-\u001a:\u0015\t\u0005-!1\u0005\u0005\b\u0003?\f\u0003\u0019AAqQ\r\t\u0013\u0011\u001f\u0015\bC\u0005}(1\u0002B\u0015Y\t\u0011y!A\tuKN$8*\u001b7m\r>dGn\\<feN$B!a\u0003\u00030!9\u0011q\u001c\u0012A\u0002\u0005\u0005\bf\u0001\u0012\u0002r\":!%a@\u0003\f\tUBF\u0001B\b\u0003A!Xm\u001d;DQ\u0006tw-\u001a'fC\u0012,'\u000f\u0006\u0003\u0002\f\tm\u0002bBApG\u0001\u0007\u0011\u0011\u001d\u0015\u0004G\u0005E\bfB\u0012\u0002\u0000\n-!\u0011\t\u0017\u0003\u0005\u001f\ta\u0005^3ti\u0016cWm\u0019;V]\u000edW-\u00198MK\u0006$WM]:G_J|e.\u001a)beRLG/[8o)\u0011\tYAa\u0012\t\u000f\u0005}G\u00051\u0001\u0002b\"\u001aA%!=)\u000f\u0011\nyPa\u0003\u0003N1\u0012!qB\u0001\u0011i\u0016\u001cH/S:s\u000bb\u0004X\u000f\\:j_:$B!a\u0003\u0003T!9\u0011q\\\u0013A\u0002\u0005\u0005\bfA\u0013\u0002r\":Q%a@\u0003\f\teCF\u0001B\b\u0003\u0005\"Xm\u001d;Es:\fW.[2ESN\f'\r\\3QkND'+\u001a9mS\u000e\fG/[8o)\u0019\tYAa\u0018\u0003b!9\u0011q\u001c\u0014A\u0002\u0005\u0005\bb\u0002B2M\u0001\u0007!QM\u0001\u0015I\u0016dW\r^3D_:4\u0017nZ(wKJ\u0014\u0018\u000eZ3\u0011\u0007m\u00139'C\u0002\u0003jq\u0013qAQ8pY\u0016\fg\u000eK\u0002'\u0003cDsA\nB8\u0005k\u00129\b\u0005\u0003\u0003\u0002\tE\u0014\u0002\u0002B:\u0005\u0007\u0011\u0011bQ:w'>,(oY3\u0002\u000bY\fG.^3-\t\te$QP\u0011\u0003\u0005w\n1b\u001b:bMRdc-\u00197tK\u0006\u0012!qP\u0001\u000bWJ\fg\r\u001e\u0017ueV,\u0017A\u000b;fgRLe\u000e^3s]\u0006dGk\u001c9jGNCw.\u001e7e\u001d>$HK]1og&$\u0018n\u001c8U_B+8\u000f\u001b\u000b\u0005\u0003\u0017\u0011)\tC\u0004\u0002`\u001e\u0002\r!!9)\u0007\u001d\n\t\u0010K\u0004(\u0003\u007f\u0014YAa#-\u0005\t=\u0011A\u00059s_\u0012,8-\u001a+p!\u0006\u0014H/\u001b;j_:$\"B!%\u0003(\n%&1\u0016BX!\u0019\tyCa%\u0003\u0016&!\u0011QVA\"!\u0019\u00119J!(\u0003\"6\u0011!\u0011\u0014\u0006\u0005\u00057\u000b9*\u0001\u0006d_:\u001cWO\u001d:f]RLAAa(\u0003\u001a\n1a)\u001e;ve\u0016\u0004B!a\u001c\u0003$&!!QUA9\u00059\u0011VmY8sI6+G/\u00193bi\u0006DQ\u0001\u001c\u0015A\u00029DQ\u0001\u0017\u0015A\u0002iCqA!,)\u0001\u0004\u0011)'A\u000efqB,7\r^!mYJ+\u0007\u000f\\5dCNLe\u000eU;tQ6{G-\u001a\u0005\t\u0005cC\u0003\u0013!a\u00015\u0006A1\u000f^1si.+\u00170\u0001\u000fqe>$WoY3U_B\u000b'\u000f^5uS>tG\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t]&f\u0001.\u0003:.\u0012!1\u0018\t\u0005\u0005{\u00139-\u0004\u0002\u0003@*!!\u0011\u0019Bb\u0003%)hn\u00195fG.,GMC\u0002\u0003Fr\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011IMa0\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0005bo\u0006LG/S*S)!\tYAa4\u0003T\n]\u0007B\u0002BiU\u0001\u0007a.\u0001\u0002ua\"1!Q\u001b\u0016A\u0002i\u000b1B\\;n%\u0016\u0004H.[2bg\"9!\u0011\u001c\u0016A\u0002\u0005m\u0011A\u00027fC\u0012,'/A\bhKRdUm\\(g%\u0016\u0004H.[2b)\u001da(q\u001cBq\u0005GDQ\u0001\\\u0016A\u00029Dq!a\u0006,\u0001\u0004\tY\u0002\u0003\u0004\u0003f.\u0002\rAW\u0001\u000bM>dGn\\<fe&#\u0017A\u0006:fC\u0012lUm]:bO\u0016\u001chI]8n\u0005J|7.\u001a:\u0015\u0011\t-8qMB5\u0007W\u0002b!a\f\u0003\u0014\n5\bc\u0001Bx_5\t\u0001A\u0001\u0006SK\u000e|'\u000f\u001a*fC\u0012\u001cra\fB{\u0005w\u001c\t\u0001E\u0002\\\u0005oL1A!?]\u0005\u0019\te.\u001f*fMB\u00191L!@\n\u0007\t}HLA\u0004Qe>$Wo\u0019;\u0011\t\u0005=21A\u0005\u0005\u0007\u000b\t\u0019E\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004pM\u001a\u001cX\r^\u0001\b_\u001a47/\u001a;!\u0003\rYW-_\u000b\u0003\u0003C\fAa[3zA\u00051a/\u00197vK\u0002\"\u0002B!<\u0004\u0016\r]1\u0011\u0004\u0005\u0007\u0007\u000f1\u0004\u0019\u0001?\t\u000f\r-a\u00071\u0001\u0002b\"9!Q\u000f\u001cA\u0002\u0005\u0005\u0018\u0001B2paf$\u0002B!<\u0004 \r\u000521\u0005\u0005\t\u0007\u000f9\u0004\u0013!a\u0001y\"I11B\u001c\u0011\u0002\u0003\u0007\u0011\u0011\u001d\u0005\n\u0005k:\u0004\u0013!a\u0001\u0003C\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004*)\u001aAP!/\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u00111q\u0006\u0016\u0005\u0003C\u0014I,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$Baa\u000f\u0004BA\u00191l!\u0010\n\u0007\r}BLA\u0002B]fD\u0001\"a\u0005>\u0003\u0003\u0005\rAW\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u00111q\t\t\u0007\u0003K\u001bIea\u000f\n\t\r-\u0013q\u0015\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003f\rE\u0003\"CA\n\u007f\u0005\u0005\t\u0019AB\u001e\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\u0007\r\u001c9\u0006\u0003\u0005\u0002\u0014\u0001\u000b\t\u00111\u0001[\u0003!A\u0017m\u001d5D_\u0012,G#\u0001.\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012aY\u0001\u0007KF,\u0018\r\\:\u0015\t\t\u00154Q\r\u0005\n\u0003'\u0019\u0015\u0011!a\u0001\u0007wAQ\u0001\u001c\u0017A\u00029Da!!\u0002-\u0001\u0004Q\u0006BBB7Y\u0001\u0007!,\u0001\u0005ce>\\WM]%e\u0003m1XM]5gs6+7o]1hKN|e.\u00117m%\u0016\u0004H.[2bgRA\u00111BB:\u0007o\u001aI\b\u0003\u0004\u0004v5\u0002\rAW\u0001\u0014Kb\u0004Xm\u0019;fI:+X.T3tg\u0006<Wm\u001d\u0005\u0007\u0003\u000bi\u0003\u0019\u0001.\t\u000f\u0005%R\u00061\u0001\u0002.\u0005Q!/Z2pe\u0012\u001c\u0016N_3\u0015\u0007i\u001by\bC\u0004\u0004\u0002:\u0002\rA!)\u0002\u001dI,7m\u001c:e\u001b\u0016$\u0018\rZ1uC\u0006Q!+Z2pe\u0012\u0014V-\u00193\u0011\u0007\t=XiE\u0003F\u0007\u0013\u001b)\nE\u0006\u0004\f\u000eEE0!9\u0002b\n5XBABG\u0015\r\u0019y\tX\u0001\beVtG/[7f\u0013\u0011\u0019\u0019j!$\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0005\u0003\u0004\u0018\u000euUBABM\u0015\r\u0019YjZ\u0001\u0003S>LAa!\u0002\u0004\u001aR\u00111QQ\u0001\u0006CB\u0004H.\u001f\u000b\t\u0005[\u001c)ka*\u0004*\"11q\u0001%A\u0002qDqaa\u0003I\u0001\u0004\t\t\u000fC\u0004\u0003v!\u0003\r!!9\u0002\u000fUt\u0017\r\u001d9msR!1qVB^!\u0015Y6\u0011WB[\u0013\r\u0019\u0019\f\u0018\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0011m\u001b9\f`Aq\u0003CL1a!/]\u0005\u0019!V\u000f\u001d7fg!I1QX%\u0002\u0002\u0003\u0007!Q^\u0001\u0004q\u0012\u0002\u0004f\u0002\u0001\u0004B\nU4q\u0019\t\u0005\u0003\u007f\u001b\u0019-\u0003\u0003\u0004F\u0006\u0005'a\u0001+bO\u0006\u00121\u0011Z\u0001\u0014E\u0006TX\r\u001c\u001etQ\u0006\u0014HmX2pk:$(H\r")
public class PushReplicationIntegrationTest
extends BaseFetchRequestTest {
    private volatile PushReplicationIntegrationTest$RecordRead$ RecordRead$module;
    private final int numUpdates;
    private final String topic;
    private final TopicPartition topicPartition = new TopicPartition(this.topic(), 0);
    private final long pushTransitionTimeoutMs;
    private final long retryTimeoutMs = this.pushTransitionTimeoutMs() / 2L;
    private int leaderId;
    private KafkaBroker leaderBroker;
    private Iterable<Object> followerIds;
    private Admin adminClient;
    private KafkaProducer<byte[], byte[]> nonIdempotentProducer;

    public PushReplicationIntegrationTest$RecordRead$ RecordRead() {
        if (this.RecordRead$module == null) {
            this.RecordRead$lzycompute$1();
        }
        return this.RecordRead$module;
    }

    public int numUpdates() {
        return this.numUpdates;
    }

    public String topic() {
        return this.topic;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public long pushTransitionTimeoutMs() {
        return this.pushTransitionTimeoutMs;
    }

    public long retryTimeoutMs() {
        return this.retryTimeoutMs;
    }

    public int leaderId() {
        return this.leaderId;
    }

    public void leaderId_$eq(int x$1) {
        this.leaderId = x$1;
    }

    public KafkaBroker leaderBroker() {
        return this.leaderBroker;
    }

    public void leaderBroker_$eq(KafkaBroker x$1) {
        this.leaderBroker = x$1;
    }

    public Iterable<Object> followerIds() {
        return this.followerIds;
    }

    public void followerIds_$eq(Iterable<Object> x$1) {
        this.followerIds = x$1;
    }

    public Admin adminClient() {
        return this.adminClient;
    }

    public void adminClient_$eq(Admin x$1) {
        this.adminClient = x$1;
    }

    public KafkaProducer<byte[], byte[]> nonIdempotentProducer() {
        return this.nonIdempotentProducer;
    }

    public void nonIdempotentProducer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.nonIdempotentProducer = x$1;
    }

    @Override
    public int brokerCount() {
        return 3;
    }

    public Properties overridingProps() {
        Properties props = new Properties();
        props.put("confluent.api.visibility", ApiMessageType.ApiVisibility.CONFLUENT_CLOUD.toString());
        props.put("confluent.replication.push.feature.enable", "true");
        props.put("confluent.replication.mode", ReplicationConfig.Mode.PULL_PUSH.toString());
        props.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        props.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "*");
        return props;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$1 = this.brokerCount();
        String x$2 = this.zkConnectOrNull();
        boolean x$5 = true;
        None$ x$62 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        boolean x$11 = false;
        boolean x$12 = false;
        Map x$13 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        int x$14 = 1;
        boolean x$15 = false;
        int x$16 = 1;
        short x$17 = 1;
        int x$18 = 0;
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$1, x$2, false, x$5, (Option<SecurityProtocol>)x$62, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, (Map<Object, String>)x$13, x$14, x$15, x$16, x$17, x$18, true).map((Function1 & Serializable)x$6 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$6, fromProps_overrides, true);
        });
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        String x$1 = this.topic();
        int x$2 = this.brokerCount();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        scala.collection.immutable.Map<Object, Object> partitionToLeader = this.createTopic(x$1, x$3, x$2, x$4, x$5, x$6);
        this.leaderId_$eq(BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)this.topicPartition().partition()))));
        this.leaderBroker_$eq((KafkaBroker)this.brokers().apply(this.leaderId()));
        this.followerIds_$eq(TestUtils$.MODULE$.getAllFollowers(this.topicPartition(), (Iterable<KafkaBroker>)this.brokers()));
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(9).append("leader : ").append(this.leaderId()).toString());
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(14).append("followerIds : ").append(this.followerIds()).toString());
        this.adminClient_$eq(this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2()));
        Properties producerProps = new Properties();
        producerProps.put("enable.idempotence", "false");
        this.nonIdempotentProducer_$eq(this.createProducer(new ByteArraySerializer(), new ByteArraySerializer(), producerProps));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testSteadyStateSimple(String quorum) {
        TestUtils$.MODULE$.waitUntilReplicasInPushMode((Seq<KafkaBroker>)this.brokers(), this.topicPartition());
        scala.collection.immutable.Seq<Future<RecordMetadata>> recordFutures = this.produceToPartition(this.topicPartition(), this.numUpdates(), true, 0);
        Assertions.assertTrue((boolean)TestUtils$.MODULE$.hasAllReplicasInReplicationMode((Seq<KafkaBroker>)this.brokers(), this.topicPartition(), ReplicationState.Mode.PUSH));
        LongRef lastProducedOffset = LongRef.create((long)-1L);
        recordFutures.foreach((Function1 & Serializable)recordFuture -> {
            PushReplicationIntegrationTest.$anonfun$testSteadyStateSimple$1(this, lastProducedOffset, recordFuture);
            return BoxedUnit.UNIT;
        });
        long l = 100L;
        long waitUntilTrue_waitTimeMs = this.pushTransitionTimeoutMs();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PushReplicationIntegrationTest.$anonfun$testSteadyStateSimple$3(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PushReplicationIntegrationTest.$anonfun$testSteadyStateSimple$6(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.verifyMessagesOnAllReplicas(this.numUpdates(), this.leaderId(), (Iterable<Object>)this.followerIds().toSeq());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testPushReplicationRecordedInReplicationQuota(String quorum) {
        TestUtils$.MODULE$.waitUntilReplicasInPushMode((Seq<KafkaBroker>)this.brokers(), this.topicPartition());
        KafkaMetric leaderReplicationQuotaMetric = (KafkaMetric)this.leaderBroker().metrics().metrics().get(this.leaderBroker().quotaManagers().leader().rateMetricName());
        double leaderReplicationQuotaRateBeforeProduce = BoxesRunTime.unboxToDouble((Object)leaderReplicationQuotaMetric.metricValue());
        scala.collection.immutable.Seq<Future<RecordMetadata>> updates = this.produceToPartition(this.topicPartition(), this.numUpdates(), true, 0);
        Assertions.assertTrue((boolean)TestUtils$.MODULE$.hasAllReplicasInReplicationMode((Seq<KafkaBroker>)this.brokers(), this.topicPartition(), ReplicationState.Mode.PUSH));
        int recordProducedSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)updates.map((Function1 & Serializable)recordMetadata -> BoxesRunTime.boxToInteger((int)this.recordSize((RecordMetadata)recordMetadata.get(this.retryTimeoutMs(), TimeUnit.MILLISECONDS))))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        long totalReplicationBytesOut = BoxesRunTime.unboxToLong((Object)this.leaderBroker().replicaManager().brokerTopicStats().allTopicsStats().replicationBytesOutRate().map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.count())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        double leaderReplicationQuotaRateAfterProduce = BoxesRunTime.unboxToDouble((Object)leaderReplicationQuotaMetric.metricValue());
        Assertions.assertTrue(((long)(this.followerIds().size() * recordProducedSize) < totalReplicationBytesOut ? 1 : 0) != 0);
        Assertions.assertTrue((leaderReplicationQuotaRateAfterProduce > leaderReplicationQuotaRateBeforeProduce ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testKillLeader(String quorum) {
        TestUtils$.MODULE$.waitUntilReplicasInPushMode((Seq<KafkaBroker>)this.brokers(), this.topicPartition());
        this.produceToPartition(this.topicPartition(), 50, true, 0);
        Assertions.assertTrue((boolean)TestUtils$.MODULE$.hasAllReplicasInReplicationMode((Seq<KafkaBroker>)this.brokers(), this.topicPartition(), ReplicationState.Mode.PUSH));
        this.killBroker(this.leaderId());
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        int newLeader = TestUtils$.MODULE$.awaitLeaderChange(this.brokers(), this.topicPartition(), this.leaderId(), 15000L);
        Iterable<Object> newFollowers = TestUtils$.MODULE$.getAllFollowers(this.topicPartition(), (Iterable<KafkaBroker>)this.brokers());
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(14).append("new leader is ").append(newLeader).toString());
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(19).append("new followers are: ").append(newFollowers).toString());
        this.awaitISR(this.topicPartition(), 3, (KafkaBroker)this.brokers().apply(newLeader));
        TestUtils$.MODULE$.waitUntilReplicasInPushMode((Seq<KafkaBroker>)this.brokers(), this.topicPartition());
        scala.collection.immutable.Seq<RecordRead> recordsFromLeader = this.readMessagesFromBroker(this.topicPartition(), newLeader, newLeader);
        newFollowers.foreach((Function1)(JFunction1.mcVI.sp & Serializable)followerId -> Assertions.assertEquals((Object)recordsFromLeader, this.readMessagesFromBroker(this.topicPartition(), newLeader, followerId)));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testKillFollowers(String quorum) {
        TestUtils$.MODULE$.waitUntilReplicasInPushMode((Seq<KafkaBroker>)this.brokers(), this.topicPartition());
        scala.collection.immutable.Seq<Future<RecordMetadata>> writeFutures = this.produceToPartition(this.topicPartition(), this.numUpdates(), true, 0);
        Assertions.assertTrue((boolean)TestUtils$.MODULE$.hasAllReplicasInReplicationMode((Seq<KafkaBroker>)this.brokers(), this.topicPartition(), ReplicationState.Mode.PUSH));
        this.followerIds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)index -> this.killBroker(index));
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        int newLeader = TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), this.topicPartition(), 15000L);
        Iterable<Object> newFollowers = TestUtils$.MODULE$.getAllFollowers(this.topicPartition(), (Iterable<KafkaBroker>)this.brokers());
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(14).append("new leader is ").append(newLeader).toString());
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(19).append("new followers are: ").append(newFollowers).toString());
        this.awaitISR(this.topicPartition(), 3, (KafkaBroker)this.brokers().apply(newLeader));
        TestUtils$.MODULE$.waitUntilReplicasInPushMode((Seq<KafkaBroker>)this.brokers(), this.topicPartition());
        writeFutures.foreach((Function1 & Serializable)x$10 -> (RecordMetadata)x$10.get(this.retryTimeoutMs(), TimeUnit.MILLISECONDS));
        this.verifyMessagesOnAllReplicas(this.numUpdates(), newLeader, newFollowers);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testChangeLeader(String quorum) {
        TestUtils$.MODULE$.waitUntilReplicasInPushMode((Seq<KafkaBroker>)this.brokers(), this.topicPartition());
        this.produceToPartition(this.topicPartition(), this.numUpdates(), true, 0);
        Assertions.assertTrue((boolean)TestUtils$.MODULE$.hasAllReplicasInReplicationMode((Seq<KafkaBroker>)this.brokers(), this.topicPartition(), ReplicationState.Mode.PUSH));
        this.changeLeader(this.adminClient(), this.topicPartition());
        int newLeader = TestUtils$.MODULE$.awaitLeaderChange(this.brokers(), this.topicPartition(), this.leaderId(), 15000L);
        Iterable<Object> newFollowers = TestUtils$.MODULE$.getAllFollowers(this.topicPartition(), (Iterable<KafkaBroker>)this.brokers());
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(14).append("new leader is ").append(newLeader).toString());
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(19).append("new followers are: ").append(newFollowers).toString());
        TestUtils$.MODULE$.waitUntilReplicasInPushMode((Seq<KafkaBroker>)this.brokers(), this.topicPartition());
        this.produceToPartition(this.topicPartition(), this.numUpdates(), true, 0);
        scala.collection.immutable.Seq<RecordRead> recordsFromLeader = this.readMessagesFromBroker(this.topicPartition(), newLeader, newLeader);
        newFollowers.foreach((Function1)(JFunction1.mcVI.sp & Serializable)followerId -> Assertions.assertEquals((Object)recordsFromLeader, this.readMessagesFromBroker(this.topicPartition(), newLeader, followerId)));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testElectUncleanLeadersForOnePartition(String quorum) {
        int broker1 = 0;
        int broker2 = 1;
        scala.collection.immutable.Seq assignment1 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        TopicPartition partition1 = new TopicPartition("unclean-test-topic-1", 0);
        this.createTopicWithAssignment(partition1.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition())), (Object)assignment1)}))), this.createTopicWithAssignment$default$3());
        TestUtils$.MODULE$.assertLeader(this.adminClient(), partition1, broker1);
        TestUtils$.MODULE$.waitUntilReplicasInPushMode((Seq<KafkaBroker>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker1, broker2})).map((Function1 & Serializable)brokerId -> PushReplicationIntegrationTest.$anonfun$testElectUncleanLeadersForOnePartition$1(this, BoxesRunTime.unboxToInt((Object)brokerId)))), partition1);
        this.produceToPartition(partition1, this.numUpdates(), true, 0);
        this.killBroker(broker2);
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.adminClient(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker2}))));
        this.produceToPartition(partition1, this.numUpdates(), false, this.numUpdates());
        this.killBroker(broker1);
        TestUtils$.MODULE$.waitForLeaderToBecome(this.adminClient(), partition1, (Option<Object>)None$.MODULE$);
        ((KafkaBroker)this.brokers().apply(broker2)).startup();
        TestUtils$.MODULE$.waitForOnlineBroker(this.adminClient(), broker2);
        ((Optional)((java.util.Map)this.adminClient().electLeaders(ElectionType.UNCLEAN, CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava()).partitions().get()).get(partition1)).ifPresent(t -> Assertions.fail((String)new StringBuilder(60).append("Unexpected exception during leader election: ").append(t).append(" for partition ").append(partition1).toString()));
        TestUtils$.MODULE$.assertLeader(this.adminClient(), partition1, broker2);
        this.produceToPartition(partition1, this.numUpdates(), false, this.numUpdates() * 2);
        ((KafkaBroker)this.brokers().apply(broker1)).startup();
        TestUtils$.MODULE$.waitUntilReplicasInPushMode((Seq<KafkaBroker>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker1, broker2})).map((Function1 & Serializable)brokerId -> PushReplicationIntegrationTest.$anonfun$testElectUncleanLeadersForOnePartition$3(this, BoxesRunTime.unboxToInt((Object)brokerId)))), partition1);
        scala.collection.immutable.Seq<RecordRead> recordsFromLeader = this.readMessagesFromBroker(partition1, broker2, broker2);
        Assertions.assertEquals(this.readMessagesFromBroker(partition1, broker2, broker1), recordsFromLeader);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testIsrExpulsion(String quorum) {
        TestUtils$.MODULE$.waitUntilReplicasInPushMode((Seq<KafkaBroker>)this.brokers(), this.topicPartition());
        this.produceToPartition(this.topicPartition(), this.numUpdates(), true, 0);
        Assertions.assertTrue((boolean)TestUtils$.MODULE$.hasAllReplicasInReplicationMode((Seq<KafkaBroker>)this.brokers(), this.topicPartition(), ReplicationState.Mode.PUSH));
        this.killBroker(BoxesRunTime.unboxToInt((Object)this.followerIds().head()));
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.adminClient(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{BoxesRunTime.unboxToInt((Object)this.followerIds().head())}))));
        this.produceToPartition(this.topicPartition(), this.numUpdates(), false, this.numUpdates());
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        this.awaitISR(this.topicPartition(), 3, (KafkaBroker)this.brokers().apply(this.leaderId()));
        TestUtils$.MODULE$.waitUntilReplicasInPushMode((Seq<KafkaBroker>)this.brokers(), this.topicPartition());
        TestUtils$.MODULE$.waitUntilReplicasInPushMode((Seq<KafkaBroker>)this.brokers(), this.topicPartition());
        this.verifyMessagesOnAllReplicas(2 * this.numUpdates(), this.leaderId(), this.followerIds());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @CsvSource(value={"kraft,false", "kraft,true"})
    public void testDynamicDisablePushReplication(String quorum, boolean deleteConfigOverride) {
        void var7_8;
        AlterConfigOp.OpType opType;
        Properties properties;
        TestUtils$.MODULE$.waitUntilReplicasInPushMode((Seq<KafkaBroker>)this.brokers(), this.topicPartition());
        Properties disablePushProps = new Properties();
        disablePushProps.put("confluent.replication.mode", ReplicationConfig.Mode.PULL.toString());
        TestUtils$.MODULE$.incrementalAlterConfigs(this.brokers(), this.adminClient(), disablePushProps, false, AlterConfigOp.OpType.SET).all().get();
        TestUtils$.MODULE$.waitUntilReplicasInPullMode((Seq<KafkaBroker>)this.brokers(), (Seq<TopicPartition>)new .colon.colon((Object)this.topicPartition(), (List)Nil$.MODULE$));
        this.produceToPartition(this.topicPartition(), this.numUpdates(), false, 0).foreach((Function1 & Serializable)x$11 -> (RecordMetadata)x$11.get(this.retryTimeoutMs(), TimeUnit.MILLISECONDS));
        Assertions.assertTrue((boolean)TestUtils$.MODULE$.hasAllReplicasInReplicationMode((Seq<KafkaBroker>)this.brokers(), this.topicPartition(), ReplicationState.Mode.PULL));
        this.adminClient().close(Duration.ZERO);
        this.nonIdempotentProducer().close(Duration.ZERO);
        this.killAllBrokers();
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        this.updateBootstrapServers();
        int newLeader = TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), this.topicPartition(), 15000L);
        this.awaitISR(this.topicPartition(), 3, (KafkaBroker)this.brokers().apply(newLeader));
        TestUtils$.MODULE$.waitUntilReplicasInPullMode((Seq<KafkaBroker>)this.brokers(), (Seq<TopicPartition>)new .colon.colon((Object)this.topicPartition(), (List)Nil$.MODULE$));
        if (deleteConfigOverride) {
            Properties deletePushOverrideProps = new Properties();
            deletePushOverrideProps.put("confluent.replication.mode", "");
            properties = deletePushOverrideProps;
            opType = AlterConfigOp.OpType.DELETE;
        } else {
            Properties enablePushProps = new Properties();
            enablePushProps.put("confluent.replication.mode", ReplicationConfig.Mode.PULL_PUSH.toString());
            properties = enablePushProps;
            opType = AlterConfigOp.OpType.SET;
        }
        AlterConfigOp.OpType opType2 = opType;
        Properties enablePushProps = properties;
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        TestUtils$.MODULE$.incrementalAlterConfigs(this.brokers(), admin, (Properties)var7_8, false, opType2).all().get();
        Assertions.assertTrue((boolean)TestUtils$.MODULE$.hasAllReplicasInReplicationMode((Seq<KafkaBroker>)this.brokers(), this.topicPartition(), ReplicationState.Mode.PULL));
        this.nonIdempotentProducer_$eq(this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()));
        this.produceToPartition(this.topicPartition(), this.numUpdates(), false, 0).foreach((Function1 & Serializable)x$13 -> (RecordMetadata)x$13.get(this.retryTimeoutMs(), TimeUnit.MILLISECONDS));
        this.nonIdempotentProducer().close(Duration.ZERO);
        Assertions.assertTrue((boolean)TestUtils$.MODULE$.hasAllReplicasInReplicationMode((Seq<KafkaBroker>)this.brokers(), this.topicPartition(), ReplicationState.Mode.PULL));
        this.killAllBrokers();
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        newLeader = TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), this.topicPartition(), 15000L);
        this.awaitISR(this.topicPartition(), 3, (KafkaBroker)this.brokers().apply(newLeader));
        TestUtils$.MODULE$.waitUntilReplicasInPushMode((Seq<KafkaBroker>)this.brokers(), (Seq<TopicPartition>)new .colon.colon((Object)this.topicPartition(), (List)Nil$.MODULE$));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testInternalTopicShouldNotTransitionToPush(String quorum) {
        TopicPartition internalTopicPartition = new TopicPartition("__consumer_offsets", 0);
        TestUtils$.MODULE$.waitUntilReplicasInPushMode((Seq<KafkaBroker>)this.brokers(), this.topicPartition());
        Assertions.assertFalse((boolean)TestUtils$.MODULE$.hasAllReplicasInReplicationMode((Seq<KafkaBroker>)this.brokers(), internalTopicPartition, ReplicationState.Mode.PUSH));
    }

    private scala.collection.immutable.Seq<Future<RecordMetadata>> produceToPartition(TopicPartition topicPartition, int numUpdates, boolean expectAllReplicasInPushMode, int startKey) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(startKey), startKey + numUpdates).map((Function1 & Serializable)i -> PushReplicationIntegrationTest.$anonfun$produceToPartition$1(this, expectAllReplicasInPushMode, topicPartition, BoxesRunTime.unboxToInt((Object)i)));
    }

    private int produceToPartition$default$4() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private void awaitISR(TopicPartition tp, int numReplicas, KafkaBroker leader) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PushReplicationIntegrationTest.$anonfun$awaitISR$1(numReplicas, leader, tp)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PushReplicationIntegrationTest.$anonfun$awaitISR$2(numReplicas, leader, tp));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public long getLeoOfReplica(TopicPartition topicPartition, KafkaBroker leaderBroker, int followerId) {
        Option partition = leaderBroker.replicaManager().onlinePartition(topicPartition);
        if (partition.isEmpty() || ((Partition)partition.get()).getReplica(followerId).isEmpty()) {
            return BoxesRunTime.unboxToLong((Object)Assertions.fail((String)"Trying to get LEO of en empty partition or follower"));
        }
        return ((Replica)((Partition)partition.get()).getReplica((int)followerId).get()).stateSnapshot().logEndOffsetMetadata().messageOffset;
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Seq<RecordRead> readMessagesFromBroker(TopicPartition topicPartition, int leaderId, int brokerId) {
        scala.collection.immutable.Seq seq;
        boolean readFromFollower = leaderId != brokerId;
        Properties consumerProps = new Properties();
        consumerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        consumerProps.put("auto.offset.reset", "earliest");
        if (readFromFollower) {
            consumerProps.put("client.rack", Integer.toString(brokerId));
        }
        try (KafkaConsumer consumer = new KafkaConsumer(consumerProps, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());){
            consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$)).asJava());
            if (readFromFollower) {
                long l = 100L;
                long waitUntilTrue_waitTimeMs = 15000L;
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!PushReplicationIntegrationTest.$anonfun$readMessagesFromBroker$1(this, topicPartition, leaderId, brokerId)) {
                    void waitUntilTrue_pause;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)"Preferred replica is not set");
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
            }
            Seq read = TestUtils$.MODULE$.consumeRecordsFor(consumer, 1000L);
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append("read ").append(read.size()).append(" records from broker ").append(brokerId).toString());
            seq = ((IterableOnceOps)read.map((Function1 & Serializable)x -> new RecordRead(this, x.offset(), TestUtils$.MODULE$.recordKeyAsString((ConsumerRecord<byte[], byte[]>)x), TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)x)))).toSeq();
        }
        return seq;
    }

    private void verifyMessagesOnAllReplicas(int expectedNumMessages, int leaderId, Iterable<Object> followerIds) {
        scala.collection.immutable.Seq<RecordRead> recordsFromLeader = this.readMessagesFromBroker(this.topicPartition(), leaderId, leaderId);
        Assertions.assertEquals((int)expectedNumMessages, (int)recordsFromLeader.size());
        recordsFromLeader.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Assertions.assertEquals((Object)new StringBuilder(4).append("key ").append(i).toString(), (Object)((RecordRead)recordsFromLeader.apply(i)).key(), (String)new StringBuilder(26).append("different key at position ").append(i).toString());
            Assertions.assertEquals((Object)new StringBuilder(6).append("value ").append(i).toString(), (Object)((RecordRead)recordsFromLeader.apply(i)).value(), (String)new StringBuilder(28).append("different value at position ").append(i).toString());
            Assertions.assertEquals((long)i, (long)((RecordRead)recordsFromLeader.apply(i)).offset(), (String)new StringBuilder(29).append("different offset at position ").append(i).toString());
        });
        followerIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable)followerId -> Assertions.assertEquals((Object)recordsFromLeader, this.readMessagesFromBroker(this.topicPartition(), leaderId, followerId)));
    }

    private int recordSize(RecordMetadata recordMetadata) {
        int size = 0;
        if (recordMetadata.serializedKeySize() > 0) {
            size += recordMetadata.serializedKeySize();
        }
        if (recordMetadata.serializedValueSize() > 0) {
            size += recordMetadata.serializedValueSize();
        }
        return size;
    }

    private final void RecordRead$lzycompute$1() {
        synchronized (this) {
            if (this.RecordRead$module == null) {
                this.RecordRead$module = new PushReplicationIntegrationTest$RecordRead$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testSteadyStateSimple$1(PushReplicationIntegrationTest $this, LongRef lastProducedOffset$1, Future recordFuture) {
        long messageOffset = ((RecordMetadata)recordFuture.get($this.retryTimeoutMs(), TimeUnit.MILLISECONDS)).offset();
        Assertions.assertTrue((messageOffset > lastProducedOffset$1.elem ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)TestUtils$.MODULE$.hasAllReplicasInReplicationMode((Seq<KafkaBroker>)$this.brokers(), $this.topicPartition(), ReplicationState.Mode.PUSH));
        Assertions.assertTrue((boolean)$this.followerIds().forall((Function1)(JFunction1.mcZI.sp & Serializable)followerId -> $this.getLeoOfReplica($this.topicPartition(), $this.leaderBroker(), followerId) >= lastProducedOffset$1.elem));
        lastProducedOffset$1.elem = messageOffset;
    }

    public static final /* synthetic */ boolean $anonfun$testSteadyStateSimple$4(PushReplicationIntegrationTest $this, KafkaBroker x$7) {
        return x$7.replicaManager().getLog($this.topicPartition()).map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.highWatermark())).contains((Object)BoxesRunTime.boxToInteger((int)$this.numUpdates()));
    }

    public static final /* synthetic */ boolean $anonfun$testSteadyStateSimple$3(PushReplicationIntegrationTest $this) {
        return $this.brokers().forall((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)PushReplicationIntegrationTest.$anonfun$testSteadyStateSimple$4($this, x$7)));
    }

    public static final /* synthetic */ String $anonfun$testSteadyStateSimple$6(PushReplicationIntegrationTest $this) {
        return new StringBuilder(55).append("Timed out waiting for HWM to be advanced to numUpdates=").append($this.numUpdates()).toString();
    }

    public static final /* synthetic */ KafkaBroker $anonfun$testElectUncleanLeadersForOnePartition$1(PushReplicationIntegrationTest $this, int brokerId) {
        return (KafkaBroker)$this.brokers().apply(brokerId);
    }

    public static final /* synthetic */ KafkaBroker $anonfun$testElectUncleanLeadersForOnePartition$3(PushReplicationIntegrationTest $this, int brokerId) {
        return (KafkaBroker)$this.brokers().apply(brokerId);
    }

    public static final /* synthetic */ Future $anonfun$produceToPartition$1(PushReplicationIntegrationTest $this, boolean expectAllReplicasInPushMode$1, TopicPartition topicPartition$1, int i) {
        if (expectAllReplicasInPushMode$1) {
            Assertions.assertTrue((boolean)TestUtils$.MODULE$.hasAllReplicasInReplicationMode((Seq<KafkaBroker>)$this.brokers(), topicPartition$1, ReplicationState.Mode.PUSH));
        }
        return $this.nonIdempotentProducer().send(new ProducerRecord(topicPartition$1.topic(), (Object)new StringBuilder(4).append("key ").append(i).toString().getBytes(), (Object)new StringBuilder(6).append("value ").append(i).toString().getBytes()));
    }

    private static final scala.collection.immutable.Set isr$1(KafkaBroker leader$1, TopicPartition tp$1) {
        return ((Partition)leader$1.replicaManager().onlinePartition(tp$1).get()).inSyncReplicaIds();
    }

    public static final /* synthetic */ boolean $anonfun$awaitISR$1(int numReplicas$1, KafkaBroker leader$1, TopicPartition tp$1) {
        return PushReplicationIntegrationTest.isr$1(leader$1, tp$1).size() == numReplicas$1;
    }

    public static final /* synthetic */ String $anonfun$awaitISR$2(int numReplicas$1, KafkaBroker leader$1, TopicPartition tp$1) {
        return new StringBuilder(73).append("Timed out waiting for replicas to join ISR. numReplicas=").append(numReplicas$1).append(", leader=").append(leader$1.config().brokerId()).append(", isr={").append(PushReplicationIntegrationTest.isr$1(leader$1, tp$1)).append("}").toString();
    }

    public static final /* synthetic */ boolean $anonfun$readMessagesFromBroker$1(PushReplicationIntegrationTest $this, TopicPartition topicPartition$2, int leaderId$1, int brokerId$1) {
        int preferredReplica = $this.getPreferredReplica(topicPartition$2.topic(), leaderId$1, brokerId$1);
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(18).append("preferredReplica: ").append(preferredReplica).toString());
        return preferredReplica != -1;
    }

    public static final /* synthetic */ String $anonfun$readMessagesFromBroker$3() {
        return "Preferred replica is not set";
    }

    public PushReplicationIntegrationTest() {
        this.numUpdates = 50;
        this.topic = "topic";
        this.pushTransitionTimeoutMs = 10000L;
    }

    public class RecordRead
    implements Product,
    Serializable {
        private final long offset;
        private final String key;
        private final String value;
        public final /* synthetic */ PushReplicationIntegrationTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public long offset() {
            return this.offset;
        }

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        public RecordRead copy(long offset, String key, String value) {
            return new RecordRead(this.kafka$server$PushReplicationIntegrationTest$RecordRead$$$outer(), offset, key, value);
        }

        public long copy$default$1() {
            return this.offset();
        }

        public String copy$default$2() {
            return this.key();
        }

        public String copy$default$3() {
            return this.value();
        }

        public String productPrefix() {
            return "RecordRead";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.offset());
                }
                case 1: {
                    return this.key();
                }
                case 2: {
                    return this.value();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RecordRead;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "offset";
                }
                case 1: {
                    return "key";
                }
                case 2: {
                    return "value";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.longHash((long)this.offset())), (int)Statics.anyHash((Object)this.key())), (int)Statics.anyHash((Object)this.value())), (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof RecordRead && ((RecordRead)x$1).kafka$server$PushReplicationIntegrationTest$RecordRead$$$outer() == this.kafka$server$PushReplicationIntegrationTest$RecordRead$$$outer())) break block3;
                    RecordRead recordRead = (RecordRead)x$1;
                    if (this.offset() != recordRead.offset()) break block3;
                    String string = this.key();
                    String string2 = recordRead.key();
                    if (string != null ? !string.equals(string2) : string2 != null) break block3;
                    String string3 = this.value();
                    String string4 = recordRead.value();
                    if ((string3 != null ? !string3.equals(string4) : string4 != null) || !recordRead.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ PushReplicationIntegrationTest kafka$server$PushReplicationIntegrationTest$RecordRead$$$outer() {
            return this.$outer;
        }

        public RecordRead(PushReplicationIntegrationTest $outer, long offset, String key, String value) {
            this.offset = offset;
            this.key = key;
            this.value = value;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

