/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.replication.push.ReplicationConfig;
import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.Configuration;
import kafka.controller.ClusterBalanceManager;
import kafka.server.ControllerServer;
import kafka.server.FaultHandlerFactory;
import kafka.server.KRaftQuorumImplementation;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer$;
import kafka.server.QuorumImplementation;
import kafka.server.QuorumTestHarness$;
import kafka.server.QuorumTestHarnessFaultHandlerFactory;
import kafka.server.SharedServer;
import kafka.server.ZooKeeperQuorumImplementation;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestInfoUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesEnsemble;
import org.apache.kafka.metadata.properties.MetaPropertiesVersion;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.MockFaultHandler;
import org.apache.kafka.test.TestUtils;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.provider.Arguments;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\r=c!\u0002$H\u0003\u0003a\u0005\"B-\u0001\t\u0003Q\u0006bB/\u0001\u0005\u0004%\tA\u0018\u0005\u0007E\u0002\u0001\u000b\u0011B0\t\u000f\r\u0004!\u0019!C\u0001=\"1A\r\u0001Q\u0001\n}Cq!\u001a\u0001C\u0002\u0013\u0005a\f\u0003\u0004g\u0001\u0001\u0006Ia\u0018\u0005\u0006O\u0002!\t\u0002\u001b\u0005\u0006_\u0002!\t\u0002\u001d\u0005\b\u0003\u0003\u0001A\u0011CA\u0002\u0011\u001d\t\t\u0003\u0001C\t\u0003GA1\"!\r\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00024!Y\u0011\u0011\n\u0001A\u0002\u0003\u0007I\u0011BA&\u0011-\t9\u0006\u0001a\u0001\u0002\u0003\u0006K!!\u000e\t\u0017\u0005e\u0003\u00011AA\u0002\u0013%\u00111\f\u0005\f\u0003G\u0002\u0001\u0019!a\u0001\n\u0013\t)\u0007C\u0006\u0002j\u0001\u0001\r\u0011!Q!\n\u0005u\u0003\"CA6\u0001\t\u0007I\u0011AA7\u0011!\t\t\t\u0001Q\u0001\n\u0005=\u0004bBAB\u0001\u0011\u0005\u0011Q\u0011\u0005\b\u0003\u000f\u0003A\u0011AAC\u0011\u001d\tI\t\u0001C\u0001\u0003\u000bCq!a#\u0001\t\u0003\ti\tC\u0004\u0002$\u0002!\t!!*\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002&\"9\u0011\u0011\u0016\u0001\u0005\u0002\u0005\u0015\u0005bBAV\u0001\u0011\u0005\u0011Q\u0016\u0005\b\u0003g\u0003A\u0011BA[\u0011\u001d\ti\f\u0001C\u0005\u0003\u007fCq!a2\u0001\t\u0003\tI\rC\u0004\u0002X\u0002!\t!!7\t\u000f\u0005\u0005\b\u0001\"\u0001\u0002Z\"9\u00111\u001d\u0001\u0005\u0002\u0005\u0015\bBBAw\u0001\u0011\u0005a\fC\u0004\u0002p\u0002!\t!!=\t\u000f\t%\u0001\u0001\"\u0001\u0002r\"9!1\u0002\u0001\u0005\u0002\t5\u0001b\u0002B\u000b\u0001\u0011\u0005!q\u0003\u0005\b\u0005K\u0001A\u0011\u0001B\u0014\u0011\u001d\u0011)\u0003\u0001C\u0001\u0003KCqA!\f\u0001\t\u0003\u0011y\u0003C\u0005\u00034\u0001\u0011\r\u0011\"\u0001\u00036!A!Q\b\u0001!\u0002\u0013\u00119\u0004C\u0005\u0003@\u0001\u0001\r\u0011\"\u0001\u0003B!I!\u0011\u000b\u0001A\u0002\u0013\u0005!1\u000b\u0005\t\u0005/\u0002\u0001\u0015)\u0003\u0003D!I!\u0011\f\u0001C\u0002\u0013\u0005!1\f\u0005\t\u0005S\u0002\u0001\u0015!\u0003\u0003^!9!1\u000e\u0001\u0005\u0002\t5\u0004b\u0002B=\u0001\u0011\u0005!1\u0010\u0005\n\u0005K\u0003\u0011\u0013!C\u0001\u0005OC\u0011B!0\u0001#\u0003%\tAa0\t\u0013\t\r\u0007!%A\u0005\u0002\t\u0015\u0007b\u0002Be\u0001\u0011\u0005\u0011Q\u0015\u0005\b\u0005\u0017\u0004A\u0011AAS\u0011\u001d\u0011i\r\u0001C\u0001\u0005\u001fDqA!7\u0001\t\u0003\u0011Y\u000eC\u0004\u0003b\u0002!I!!.\t\u000f\t\r\b\u0001\"\u0001\u0002&\"9!Q\u001e\u0001\u0005\u0002\t=xaBB\u0007\u000f\"\u00051q\u0002\u0004\u0007\r\u001eC\ta!\u0005\t\resD\u0011AB\n\u0011%\u0019)B\u0010b\u0001\n\u0003\u00199\u0002\u0003\u0005\u0004\u001ey\u0002\u000b\u0011BB\r\u0011\u001d\u0019yB\u0010C\u0001\u0003KCqa!\u000b?\t\u0003\t)\u000bC\u0004\u00044y\"\ta!\u000e\t\u000f\r5c\b\"\u0001\u00046\t\t\u0012+^8sk6$Vm\u001d;ICJtWm]:\u000b\u0005!K\u0015AB:feZ,'OC\u0001K\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A'T!\tq\u0015+D\u0001P\u0015\u0005\u0001\u0016!B:dC2\f\u0017B\u0001*P\u0005\u0019\te.\u001f*fMB\u0011AkV\u0007\u0002+*\u0011a+S\u0001\u0006kRLGn]\u0005\u00031V\u0013q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u00027B\u0011A\fA\u0007\u0002\u000f\u0006\u0019\"p[\"p]:,7\r^5p]RKW.Z8viV\tq\f\u0005\u0002OA&\u0011\u0011m\u0014\u0002\u0004\u0013:$\u0018\u0001\u0006>l\u0007>tg.Z2uS>tG+[7f_V$\b%\u0001\t{WN+7o]5p]RKW.Z8vi\u0006\t\"p[*fgNLwN\u001c+j[\u0016|W\u000f\u001e\u0011\u0002+i\\W*\u0019=J]\u001ac\u0017n\u001a5u%\u0016\fX/Z:ug\u00061\"p['bq&sg\t\\5hQR\u0014V-];fgR\u001c\b%A\u0007{W\u0006\u001bGn]#oC\ndW\rZ\u000b\u0002SB\u0019aJ\u001b7\n\u0005-|%AB(qi&|g\u000e\u0005\u0002O[&\u0011an\u0014\u0002\b\u0005>|G.Z1o\u0003\t\u001awN\u001c;s_2dWM\u001d'jgR,g.\u001a:TK\u000e,(/\u001b;z!J|Go\\2pYV\t\u0011\u000f\u0005\u0002s}6\t1O\u0003\u0002uk\u0006!\u0011-\u001e;i\u0015\t1x/\u0001\u0005tK\u000e,(/\u001b;z\u0015\tA\u00180\u0001\u0004d_6lwN\u001c\u0006\u0003\u0015jT!a\u001f?\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0018aA8sO&\u0011qp\u001d\u0002\u0011'\u0016\u001cWO]5usB\u0013x\u000e^8d_2\fac\u001b:bMR\u001cuN\u001c;s_2dWM]\"p]\u001aLwm\u001d\u000b\u0003\u0003\u000b\u0001b!a\u0002\u0002\u000e\u0005EQBAA\u0005\u0015\r\tYaT\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\b\u0003\u0013\u00111aU3r!\u0011\t\u0019\"!\b\u000e\u0005\u0005U!\u0002BA\f\u00033\tA!\u001e;jY*\u0011\u00111D\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002 \u0005U!A\u0003)s_B,'\u000f^5fg\u0006yQ.\u001a;bI\u0006$\u0018MV3sg&|g.\u0006\u0002\u0002&A!\u0011qEA\u0017\u001b\t\tICC\u0002y\u0003WQ!\u0001S=\n\t\u0005=\u0012\u0011\u0006\u0002\u0010\u001b\u0016$\u0018\rZ1uCZ+'o]5p]\u0006AA/Z:u\u0013:4w.\u0006\u0002\u00026A!\u0011qGA#\u001b\t\tID\u0003\u0003\u0002<\u0005u\u0012aA1qS*!\u0011qHA!\u0003\u001dQW\u000f]5uKJT1!a\u0011}\u0003\u0015QWO\\5u\u0013\u0011\t9%!\u000f\u0003\u0011Q+7\u000f^%oM>\fA\u0002^3ti&sgm\\0%KF$B!!\u0014\u0002TA\u0019a*a\u0014\n\u0007\u0005EsJ\u0001\u0003V]&$\b\"CA+\u001b\u0005\u0005\t\u0019AA\u001b\u0003\rAH%M\u0001\ni\u0016\u001cH/\u00138g_\u0002\na\"[7qY\u0016lWM\u001c;bi&|g.\u0006\u0002\u0002^A\u0019A,a\u0018\n\u0007\u0005\u0005tI\u0001\u000bRk>\u0014X/\\%na2,W.\u001a8uCRLwN\\\u0001\u0013S6\u0004H.Z7f]R\fG/[8o?\u0012*\u0017\u000f\u0006\u0003\u0002N\u0005\u001d\u0004\"CA+!\u0005\u0005\t\u0019AA/\u0003=IW\u000e\u001d7f[\u0016tG/\u0019;j_:\u0004\u0013\u0001\u00052p_R\u001cHO]1q%\u0016\u001cwN\u001d3t+\t\ty\u0007\u0005\u0004\u0002r\u0005]\u00141P\u0007\u0003\u0003gRA!!\u001e\u0002\n\u00059Q.\u001e;bE2,\u0017\u0002BA=\u0003g\u0012!\u0002T5ti\n+hMZ3s!\u0011\t9#! \n\t\u0005}\u0014\u0011\u0006\u0002\u0015\u0003BLW*Z:tC\u001e,\u0017I\u001c3WKJ\u001c\u0018n\u001c8\u0002#\t|w\u000e^:ue\u0006\u0004(+Z2pe\u0012\u001c\b%A\u0006jg.\u0013\u0016M\u001a;UKN$H#\u00017\u0002#%\u001c(l['jOJ\fG/[8o)\u0016\u001cH/\u0001\u000fjg:+wo\u0012:pkB\u001cun\u001c:eS:\fGo\u001c:F]\u0006\u0014G.\u001a3\u000275\f\u0017PY3He>,\b\u000f\u0015:pi>\u001cw\u000e\\*qK\u000eLg-[3e)\u0011\ty)!)\u0011\t9S\u0017\u0011\u0013\t\u0005\u0003'\u000bi*\u0004\u0002\u0002\u0016*!\u0011qSAM\u0003!\u0019wN\\:v[\u0016\u0014(bAANs\u000691\r\\5f]R\u001c\u0018\u0002BAP\u0003+\u0013Qb\u0012:pkB\u0004&o\u001c;pG>d\u0007bBA\u0019/\u0001\u0007\u0011QG\u0001\u000eG\",7m[%t5.#Vm\u001d;\u0015\u0005\u00055\u0013\u0001E2iK\u000e\\\u0017j]&SC\u001a$H+Z:u\u0003UI7\u000fU;tQJ+\u0007\u000f\\5dCRLwN\u001c+fgR\f!$\\1zE\u0016,e.\u00192mKB+8\u000f\u001b*fa2L7-\u0019;j_:$B!!\u0014\u00020\"9\u0011\u0011W\u000eA\u0002\u0005E\u0011!\u00029s_B\u001c\u0018\u0001B1t5.$\"!a.\u0011\u0007q\u000bI,C\u0002\u0002<\u001e\u0013QDW8p\u0017\u0016,\u0007/\u001a:Rk>\u0014X/\\%na2,W.\u001a8uCRLwN\\\u0001\bCN\\%+\u00194u)\t\t\t\rE\u0002]\u0003\u0007L1!!2H\u0005eY%+\u00194u#V|'/^7J[BdW-\\3oi\u0006$\u0018n\u001c8\u0002\u0013i|wn[3fa\u0016\u0014XCAAf!\u0011\ti-a5\u000e\u0005\u0005='bAAi\u0013\u0006\u0011!p[\u0005\u0005\u0003+\fyMA\tF[\n,G\rZ3e5>|7.Z3qKJ\f\u0001B_6DY&,g\u000e^\u000b\u0003\u00037\u0004B!!4\u0002^&!\u0011q\\Ah\u00055Y\u0015MZ6b5.\u001cE.[3oi\u0006q!p[\"mS\u0016tGo\u0014:Ok2d\u0017!D1e[&t'l[\"mS\u0016tG/\u0006\u0002\u0002hB!\u0011QZAu\u0013\u0011\tY/a4\u0003\u001b\u0005#W.\u001b8[W\u000ec\u0017.\u001a8u\u0003\u0019Q8\u000eU8si\u0006I!p[\"p]:,7\r^\u000b\u0003\u0003g\u0004B!!>\u0003\u00049!\u0011q_A\u0000!\r\tIpT\u0007\u0003\u0003wT1!!@L\u0003\u0019a$o\\8u}%\u0019!\u0011A(\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011)Aa\u0002\u0003\rM#(/\u001b8h\u0015\r\u0011\taT\u0001\u0010u.\u001cuN\u001c8fGR|%OT;mY\u0006\u00012m\u001c8ue>dG.\u001a:TKJ4XM]\u000b\u0003\u0005\u001f\u00012\u0001\u0018B\t\u0013\r\u0011\u0019b\u0012\u0002\u0011\u0007>tGO]8mY\u0016\u00148+\u001a:wKJ\f\u0001d\u001d5vi\u0012|wO\\\"p]R\u0014x\u000e\u001c7feN+'O^3s)\t\u0011I\u0002\u0005\u0003\u0003\u001c\t\u0005RB\u0001B\u000f\u0015\u0011\u0011y\"!\u0007\u0002\t1\fgnZ\u0005\u0005\u0005G\u0011iBA\u0004J]R,w-\u001a:\u0002/I,7\u000f^1si\u000e{g\u000e\u001e:pY2,'oU3sm\u0016\u0014H\u0003BA'\u0005SAqAa\u000b(\u0001\u0004\u0011I\"\u0001\u0005qe\u00164\bk\u001c:u\u0003E\u0019wN\u001c;s_2dWM]*feZ,'o]\u000b\u0003\u0005c\u0001b!a\u0002\u0002\u000e\t=\u0011a\u00054bk2$\b*\u00198eY\u0016\u0014h)Y2u_JLXC\u0001B\u001c!\ra&\u0011H\u0005\u0004\u0005w9%\u0001J)v_J,X\u000eV3ti\"\u000b'O\\3tg\u001a\u000bW\u000f\u001c;IC:$G.\u001a:GC\u000e$xN]=\u0002)\u0019\fW\u000f\u001c;IC:$G.\u001a:GC\u000e$xN]=!\u0003U\u0019G.^:uKJ\u0014\u0015\r\\1oG\u0016l\u0015M\\1hKJ,\"Aa\u0011\u0011\t9S'Q\t\t\u0005\u0005\u000f\u0012i%\u0004\u0002\u0003J)\u0019!1J%\u0002\u0015\r|g\u000e\u001e:pY2,'/\u0003\u0003\u0003P\t%#!F\"mkN$XM\u001d\"bY\u0006t7-Z'b]\u0006<WM]\u0001\u001aG2,8\u000f^3s\u0005\u0006d\u0017M\\2f\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002N\tU\u0003\"CA+[\u0005\u0005\t\u0019\u0001B\"\u0003Y\u0019G.^:uKJ\u0014\u0015\r\\1oG\u0016l\u0015M\\1hKJ\u0004\u0013\u0001\u00044bk2$\b*\u00198eY\u0016\u0014XC\u0001B/!\u0011\u0011yF!\u001a\u000e\u0005\t\u0005$\u0002\u0002B2\u0003W\tQAZ1vYRLAAa\u001a\u0003b\t\u0001Rj\\2l\r\u0006,H\u000e\u001e%b]\u0012dWM]\u0001\u000eM\u0006,H\u000e\u001e%b]\u0012dWM\u001d\u0011\u0002\u000bM,G/\u00169\u0015\t\u00055#q\u000e\u0005\b\u0003c\t\u0004\u0019AA\u001bQ\r\t$1\u000f\t\u0005\u0003o\u0011)(\u0003\u0003\u0003x\u0005e\"A\u0003\"fM>\u0014X-R1dQ\u0006a1M]3bi\u0016\u0014%o\\6feRQ!Q\u0010BB\u0005\u001b\u0013YJa(\u0011\u0007q\u0013y(C\u0002\u0003\u0002\u001e\u00131bS1gW\u0006\u0014%o\\6fe\"9!Q\u0011\u001aA\u0002\t\u001d\u0015AB2p]\u001aLw\rE\u0002]\u0005\u0013K1Aa#H\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u0013\t=%\u0007%AA\u0002\tE\u0015\u0001\u0002;j[\u0016\u0004BAa%\u0003\u00186\u0011!Q\u0013\u0006\u0003-^LAA!'\u0003\u0016\n!A+[7f\u0011!\u0011iJ\rI\u0001\u0002\u0004a\u0017aB:uCJ$X\u000f\u001d\u0005\n\u0005C\u0013\u0004\u0013!a\u0001\u0005G\u000b\u0001\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=\u0011\t9S\u00171_\u0001\u0017GJ,\u0017\r^3Ce>\\WM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011\u0016\u0016\u0005\u0005#\u0013Yk\u000b\u0002\u0003.B!!q\u0016B]\u001b\t\u0011\tL\u0003\u0003\u00034\nU\u0016!C;oG\",7m[3e\u0015\r\u00119lT\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B^\u0005c\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003Y\u0019'/Z1uK\n\u0013xn[3sI\u0011,g-Y;mi\u0012\u001aTC\u0001BaU\ra'1V\u0001\u0017GJ,\u0017\r^3Ce>\\WM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!q\u0019\u0016\u0005\u0005G\u0013Y+A\ttQV$Hm\\<o5>|7*Z3qKJ\fqc\u001d5vi\u0012|wO\\&SC\u001a$8i\u001c8ue>dG.\u001a:\u0002/=\u0004H/[8oC2lU\r^1eCR\f'+Z2pe\u0012\u001cXC\u0001Bi!\u0011q%Na5\u0011\r\u0005E$Q[A>\u0013\u0011\u00119.a\u001d\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM]\u0001\u000f]\u0016<8JU1giF+xN];n)\u0019\t\tM!8\u0003`\"9\u0011\u0011G\u001dA\u0002\u0005U\u0002B\u0002BOs\u0001\u0007A.\u0001\noK^Tvn\\&fKB,'/U;peVl\u0017\u0001\u0003;fCJ$un\u001e8)\u0007m\u00129\u000f\u0005\u0003\u00028\t%\u0018\u0002\u0002Bv\u0003s\u0011\u0011\"\u00114uKJ,\u0015m\u00195\u0002W\r\u0014X-\u0019;f5>|7*Z3qKJ\u001cE.[3oiR{GK]5hO\u0016\u00148+Z:tS>tW\t\u001f9jef$BA!=\u0003|B!!1\u001fB|\u001b\t\u0011)PC\u0002\u0002HjLAA!?\u0003v\nI!l\\8LK\u0016\u0004XM\u001d\u0005\b\u0005{d\u0004\u0019\u0001By\u0003%Qxn\\&fKB,'\u000fK\u0004\u0001\u0007\u0003\u00199a!\u0003\u0011\t\u0005]21A\u0005\u0005\u0007\u000b\tIDA\u0002UC\u001e\fQA^1mk\u0016\f#aa\u0003\u0002\u0017%tG/Z4sCRLwN\\\u0001\u0012#V|'/^7UKN$\b*\u0019:oKN\u001c\bC\u0001/?'\tqT\n\u0006\u0002\u0004\u0010\u0005I\"l[\"mS\u0016tG/\u0012<f]R$\u0006N]3bIN+hMZ5y+\t\u0019I\u0002\u0005\u0003\u0003\u001c\rm\u0011\u0002\u0002B\u0003\u0005;\t!DW6DY&,g\u000e^#wK:$H\u000b\u001b:fC\u0012\u001cVO\u001a4jq\u0002\n!b]3u+B\u001cE.Y:tQ\r\u001151\u0005\t\u0005\u0003o\u0019)#\u0003\u0003\u0004(\u0005e\"!\u0003\"fM>\u0014X-\u00117m\u00035!X-\u0019:E_^t7\t\\1tg\"\u001a1i!\f\u0011\t\u0005]2qF\u0005\u0005\u0007c\tID\u0001\u0005BMR,'/\u00117m\u00031\nE\u000e\\*vaB|'\u000f^3e#V|'/^7B]\u0012\u0014V\r\u001d7jG\u0006$\u0018n\u001c8D_6\u0014\u0017N\\1uS>t7/\u0006\u0002\u00048A)aj!\u000f\u0004>%\u001911H(\u0003\u000b\u0005\u0013(/Y=\u0011\t\r}2\u0011J\u0007\u0003\u0007\u0003RAaa\u0011\u0004F\u0005A\u0001O]8wS\u0012,'O\u0003\u0003\u0004H\u0005u\u0012A\u00029be\u0006l7/\u0003\u0003\u0004L\r\u0005#!C!sOVlWM\u001c;t\u0003Y\nE\u000e\\*vaB|'\u000f^3e#V|'/^7B]\u0012\u0014V\r\u001d7jG\u0006$\u0018n\u001c8D_6\u0014\u0017N\\1uS>t7oV5uQ.K\u0007\u000f\u000f\u001b9\u0001")
public abstract class QuorumTestHarness
implements Logging {
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private final int zkMaxInFlightRequests = Integer.MAX_VALUE;
    private TestInfo testInfo;
    private QuorumImplementation implementation;
    private final ListBuffer<ApiMessageAndVersion> bootstrapRecords = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final QuorumTestHarnessFaultHandlerFactory faultHandlerFactory = new QuorumTestHarnessFaultHandlerFactory(new MockFaultHandler("quorumTestHarnessFaultHandler"));
    private Option<ClusterBalanceManager> clusterBalanceManager = Option$.MODULE$.empty();
    private final MockFaultHandler faultHandler = this.faultHandlerFactory().faultHandler();
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Arguments[] AllSupportedQuorumAndReplicationCombinationsWithKip848() {
        return QuorumTestHarness$.MODULE$.AllSupportedQuorumAndReplicationCombinationsWithKip848();
    }

    public static Arguments[] AllSupportedQuorumAndReplicationCombinations() {
        return QuorumTestHarness$.MODULE$.AllSupportedQuorumAndReplicationCombinations();
    }

    @AfterAll
    public static void tearDownClass() {
        QuorumTestHarness$.MODULE$.tearDownClass();
    }

    @BeforeAll
    public static void setUpClass() {
        TestUtils$.MODULE$.verifyNoUnexpectedThreads("@BeforeAll");
    }

    public static String ZkClientEventThreadSuffix() {
        return QuorumTestHarness$.MODULE$.ZkClientEventThreadSuffix();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    public int zkMaxInFlightRequests() {
        return this.zkMaxInFlightRequests;
    }

    public Option<Object> zkAclsEnabled() {
        return None$.MODULE$;
    }

    public SecurityProtocol controllerListenerSecurityProtocol() {
        return SecurityProtocol.PLAINTEXT;
    }

    public Seq<Properties> kraftControllerConfigs() {
        return new .colon.colon((Object)new Properties(), (List)Nil$.MODULE$);
    }

    public MetadataVersion metadataVersion() {
        return MetadataVersion.latestTesting();
    }

    private TestInfo testInfo() {
        return this.testInfo;
    }

    private void testInfo_$eq(TestInfo x$1) {
        this.testInfo = x$1;
    }

    private QuorumImplementation implementation() {
        return this.implementation;
    }

    private void implementation_$eq(QuorumImplementation x$1) {
        this.implementation = x$1;
    }

    public ListBuffer<ApiMessageAndVersion> bootstrapRecords() {
        return this.bootstrapRecords;
    }

    public boolean isKRaftTest() {
        return TestInfoUtils$.MODULE$.isKRaft(this.testInfo());
    }

    public boolean isZkMigrationTest() {
        return TestInfoUtils$.MODULE$.isZkMigrationTest(this.testInfo());
    }

    public boolean isNewGroupCoordinatorEnabled() {
        return TestInfoUtils$.MODULE$.isNewGroupCoordinatorEnabled(this.testInfo());
    }

    public Option<GroupProtocol> maybeGroupProtocolSpecified(TestInfo testInfo) {
        return TestInfoUtils$.MODULE$.maybeGroupProtocolSpecified(testInfo);
    }

    public void checkIsZKTest() {
        if (this.isKRaftTest()) {
            throw new RuntimeException("This function can't be accessed when running the test in KRaft mode. ZooKeeper mode is required.");
        }
    }

    public void checkIsKRaftTest() {
        if (!this.isKRaftTest()) {
            throw new RuntimeException("This function can't be accessed when running the test in ZooKeeper mode. KRaft mode is required.");
        }
    }

    public boolean isPushReplicationTest() {
        return TestInfoUtils$.MODULE$.isPushReplication(this.testInfo());
    }

    public void maybeEnablePushReplication(Properties props) {
        if (this.isPushReplicationTest()) {
            props.setProperty("confluent.replication.push.feature.enable", "true");
            props.setProperty("confluent.api.visibility", ApiMessageType.ApiVisibility.CONFLUENT_CLOUD.toString());
            props.setProperty("confluent.replication.mode", ReplicationConfig.Mode.PULL_PUSH.toString());
            return;
        }
    }

    private ZooKeeperQuorumImplementation asZk() {
        this.checkIsZKTest();
        return (ZooKeeperQuorumImplementation)this.implementation();
    }

    private KRaftQuorumImplementation asKRaft() {
        this.checkIsKRaftTest();
        return (KRaftQuorumImplementation)this.implementation();
    }

    public EmbeddedZookeeper zookeeper() {
        return this.asZk().zookeeper();
    }

    public KafkaZkClient zkClient() {
        return this.asZk().zkClient();
    }

    public KafkaZkClient zkClientOrNull() {
        if (this.isKRaftTest()) {
            return null;
        }
        return this.asZk().zkClient();
    }

    public AdminZkClient adminZkClient() {
        return this.asZk().adminZkClient();
    }

    public int zkPort() {
        return this.asZk().zookeeper().port();
    }

    public String zkConnect() {
        return new StringBuilder(10).append("127.0.0.1:").append(this.zkPort()).toString();
    }

    public String zkConnectOrNull() {
        if (this.isKRaftTest()) {
            return null;
        }
        return this.zkConnect();
    }

    public ControllerServer controllerServer() {
        return this.asKRaft().controllerServer();
    }

    public Integer shutdownControllerServer() {
        if (!this.isKRaftTest()) {
            throw new UnsupportedOperationException("Non-KRaft tests do not have a controller server");
        }
        return this.asKRaft().shutdownController();
    }

    public void restartControllerServer(Integer prevPort) {
        if (!this.isKRaftTest()) {
            throw new UnsupportedOperationException("Non-KRaft tests do not have a controller server");
        }
        this.asKRaft().restartController(prevPort);
    }

    public void restartControllerServer() {
        if (!this.isKRaftTest()) {
            throw new UnsupportedOperationException("Non-KRaft tests do not have a controller server");
        }
        this.asKRaft().restartController();
    }

    public Seq<ControllerServer> controllerServers() {
        if (this.isKRaftTest()) {
            return new .colon.colon((Object)this.asKRaft().controllerServer(), (List)Nil$.MODULE$);
        }
        return Nil$.MODULE$;
    }

    public QuorumTestHarnessFaultHandlerFactory faultHandlerFactory() {
        return this.faultHandlerFactory;
    }

    public Option<ClusterBalanceManager> clusterBalanceManager() {
        return this.clusterBalanceManager;
    }

    public void clusterBalanceManager_$eq(Option<ClusterBalanceManager> x$1) {
        this.clusterBalanceManager = x$1;
    }

    public MockFaultHandler faultHandler() {
        return this.faultHandler;
    }

    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.testInfo_$eq(testInfo);
        Exit.setExitProcedure((code, message) -> {
            try {
                try {
                    throw new RuntimeException(new StringBuilder(16).append("exit(").append(code).append(", ").append(message).append(") called!").toString());
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "test error", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.tearDown();
                throw throwable;
            }
        });
        Exit.setHaltProcedure((code, message) -> {
            try {
                try {
                    throw new RuntimeException(new StringBuilder(16).append("halt(").append(code).append(", ").append(message).append(") called!").toString());
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "test error", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.tearDown();
                throw throwable;
            }
        });
        String name = (String)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(testInfo.getTestMethod())).map((Function1 & Serializable)x$6 -> x$6.toString()).getOrElse((Function0 & Serializable)() -> "[unspecified]");
        if (TestInfoUtils$.MODULE$.isKRaft(testInfo)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(19).append("Running KRAFT test ").append(name).toString());
            this.implementation_$eq(this.newKRaftQuorum(testInfo, true));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(16).append("Running ZK test ").append(name).toString());
        this.implementation_$eq(this.newZooKeeperQuorum());
    }

    public KafkaBroker createBroker(KafkaConfig config, Time time, boolean startup, Option<String> threadNamePrefix) {
        return this.implementation().createBroker(config, time, startup, threadNamePrefix);
    }

    public Time createBroker$default$2() {
        return Time.SYSTEM;
    }

    public boolean createBroker$default$3() {
        return true;
    }

    public Option<String> createBroker$default$4() {
        return None$.MODULE$;
    }

    public void shutdownZooKeeper() {
        this.asZk().shutdown();
    }

    public void shutdownKRaftController() {
        KRaftQuorumImplementation kRaftQuorumImplementation = this.asKRaft();
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> kRaftQuorumImplementation.controllerServer().shutdown(), kRaftQuorumImplementation.log(), Level.WARN);
    }

    public Option<ArrayBuffer<ApiMessageAndVersion>> optionalMetadataRecords() {
        return None$.MODULE$;
    }

    public KRaftQuorumImplementation newKRaftQuorum(TestInfo testInfo, boolean startup) {
        Seq<Properties> propsList = this.kraftControllerConfigs();
        if (propsList.size() != 1) {
            throw new RuntimeException("Only one KRaft controller is supported for now.");
        }
        Properties props = (Properties)propsList.apply(0);
        props.setProperty(KafkaConfig$.MODULE$.ServerMaxStartupTimeMsProp(), Long.toString(TimeUnit.MINUTES.toMillis(10L)));
        props.setProperty(KafkaConfig$.MODULE$.LogDirProp(), TestUtils.tempDirectory(null, null).getAbsolutePath());
        if (TestInfoUtils$.MODULE$.isCombinedKRaft(testInfo)) {
            props.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller,broker");
        } else {
            props.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
        }
        props.setProperty(KafkaConfig$.MODULE$.UnstableMetadataVersionsEnableProp(), "true");
        props.setProperty(KafkaConfig$.MODULE$.UnstableApiVersionsEnableProp(), "true");
        if (props.getProperty(KafkaConfig$.MODULE$.NodeIdProp()) == null) {
            props.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1000");
        }
        props.setProperty("confluent.security.event.logger.exporter.kafka.topic.replicas", "1");
        int nodeId = Integer.parseInt(props.getProperty(KafkaConfig$.MODULE$.NodeIdProp()));
        File metadataDir = TestUtils.tempDirectory(null, null);
        MetaProperties metaProperties = new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId(Uuid.randomUuid().toString()).setNodeId(nodeId).build();
        TestUtils$.MODULE$.formatDirectories((scala.collection.immutable.Seq<String>)new .colon.colon((Object)metadataDir.getAbsolutePath(), (List)Nil$.MODULE$), metaProperties, this.metadataVersion(), this.optionalMetadataRecords());
        ArrayList<ApiMessageAndVersion> metadataRecords = new ArrayList<ApiMessageAndVersion>();
        metadataRecords.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("confluent.metadata.version").setFeatureLevel(this.metadataVersion().confluentFeatureLevel()), (short)0));
        this.optionalMetadataRecords().foreach((Function1 & Serializable)metadataArguments -> {
            metadataArguments.foreach((Function1 & Serializable)record -> BoxesRunTime.boxToBoolean((boolean)metadataRecords$1.add(record)));
            return BoxedUnit.UNIT;
        });
        BootstrapMetadata bootstrapMetadata = BootstrapMetadata.fromRecords(metadataRecords, (String)"test harness");
        props.setProperty(KafkaConfig$.MODULE$.MetadataLogDirProp(), metadataDir.getAbsolutePath());
        if (!props.containsKey(KafkaConfig$.MODULE$.ControllerListenerNamesProp())) {
            String proto = this.controllerListenerSecurityProtocol().toString();
            props.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), new StringBuilder(11).append("CONTROLLER:").append(proto).toString());
            props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), "CONTROLLER://localhost:0");
            props.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
        }
        props.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(12).append(nodeId).append("@localhost:0").toString());
        KafkaConfig config = new KafkaConfig((Map)props);
        CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture = new CompletableFuture<Map<Integer, RaftConfig.AddressSpec>>();
        Metrics metrics = new Metrics();
        None$ interBrokerPortFuture = startup ? None$.MODULE$ : new Some(new CompletableFuture());
        MetaPropertiesEnsemble metaPropertiesEnsemble = new MetaPropertiesEnsemble.Loader().addMetadataLogDir(metadataDir.getAbsolutePath()).load();
        metaPropertiesEnsemble.verify(Optional.of(metaProperties.clusterId().get()), OptionalInt.of(nodeId), EnumSet.of(MetaPropertiesEnsemble.VerificationFlag.REQUIRE_AT_LEAST_ONE_VALID, MetaPropertiesEnsemble.VerificationFlag.REQUIRE_METADATA_LOG_DIR));
        SharedServer sharedServer = new SharedServer(config, metaPropertiesEnsemble, Time.SYSTEM, metrics, controllerQuorumVotersFuture, (FaultHandlerFactory)this.faultHandlerFactory(), Option$.MODULE$.apply((Object)ConfluentConfigs.buildMultitenantMetadata((Map)config.values(), (Metrics)metrics)), KafkaRaftServer$.MODULE$.configSchema(), (Option)interBrokerPortFuture);
        ObjectRef controllerServer = ObjectRef.create(null);
        try {
            controllerServer.elem = new ControllerServer(sharedServer, KafkaRaftServer$.MODULE$.configSchema(), bootstrapMetadata);
            this.clusterBalanceManager_$eq((Option<ClusterBalanceManager>)new Some((Object)((ControllerServer)controllerServer.elem).clusterBalanceManager()));
            ((ControllerServer)controllerServer.elem).socketServerFirstBoundPortFuture().whenComplete((port, e) -> {
                if (e != null) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error completing controller socket server future", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    controllerQuorumVotersFuture.completeExceptionally((Throwable)e);
                    return;
                }
                controllerQuorumVotersFuture.complete(Collections.singletonMap(Predef$.MODULE$.int2Integer(nodeId), new RaftConfig.InetAddressSpec(new InetSocketAddress("localhost", Predef$.MODULE$.Integer2int(port)))));
            });
            if (startup) {
                ((ControllerServer)controllerServer.elem).startup();
            }
        }
        catch (Throwable e2) {
            if ((ControllerServer)controllerServer.elem != null) {
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> ((ControllerServer)controllerServer$1.elem).shutdown(), (Logging)this, Level.WARN);
            }
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> sharedServer.stopForController(), (Logging)this, Level.WARN);
            throw e2;
        }
        return new KRaftQuorumImplementation((ControllerServer)controllerServer.elem, this.faultHandlerFactory(), metadataDir, controllerQuorumVotersFuture, (String)metaProperties.clusterId().get(), this, (FaultHandler)this.faultHandler());
    }

    private ZooKeeperQuorumImplementation newZooKeeperQuorum() {
        AdminZkClient adminZkClient;
        EmbeddedZookeeper zookeeper = new EmbeddedZookeeper();
        ObjectRef zkClient = ObjectRef.create(null);
        String zkConnect = new StringBuilder(10).append("127.0.0.1:").append(zookeeper.port()).toString();
        try {
            boolean x$2 = BoxesRunTime.unboxToBoolean((Object)this.zkAclsEnabled().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> JaasUtils.isZkSaslEnabled()));
            int x$3 = this.zkSessionTimeout();
            int x$4 = this.zkConnectionTimeout();
            int x$5 = this.zkMaxInFlightRequests();
            Time x$6 = Time.SYSTEM;
            ZKClientConfig x$8 = new ZKClientConfig();
            String x$10 = "kafka.server";
            String x$11 = "SessionExpireListener";
            boolean x$12 = false;
            zkClient.elem = KafkaZkClient$.MODULE$.apply(zkConnect, x$2, x$3, x$4, x$5, x$6, "ZooKeeperTestHarness", x$8, x$10, x$11, x$12, false);
            adminZkClient = new AdminZkClient((KafkaZkClient)zkClient.elem, (Option)None$.MODULE$);
        }
        catch (Throwable t) {
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> zookeeper.shutdown(), (Logging)this, Level.WARN);
            if ((KafkaZkClient)zkClient.elem != null) {
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> ((KafkaZkClient)zkClient$1.elem).close(), (Logging)this, Level.WARN);
            }
            throw t;
        }
        return new ZooKeeperQuorumImplementation(zookeeper, zkConnect, (KafkaZkClient)zkClient.elem, adminZkClient, this);
    }

    @AfterEach
    public void tearDown() {
        this.clusterBalanceManager().foreach((Function1 & Serializable)c -> {
            QuorumTestHarness.$anonfun$tearDown$1(this, c);
            return BoxedUnit.UNIT;
        });
        if (this.implementation() != null) {
            this.implementation().shutdown();
        }
        Exit.resetExitProcedure();
        Exit.resetHaltProcedure();
        TestUtils$.MODULE$.clearYammerMetrics();
        System.clearProperty("java.security.auth.login.config");
        Configuration.setConfiguration(null);
        this.faultHandler().maybeRethrowFirstException();
    }

    public ZooKeeper createZooKeeperClientToTriggerSessionExpiry(ZooKeeper zooKeeper) {
        Watcher dummyWatcher = new Watcher(null){

            public void process(WatchedEvent event) {
            }
        };
        ZooKeeper anotherZkClient = new ZooKeeper(this.zkConnect(), 1000, dummyWatcher, zooKeeper.getSessionId(), zooKeeper.getSessionPasswd());
        Assertions.assertNull((Object)anotherZkClient.exists("/nonexistent", false));
        return anotherZkClient;
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(QuorumTestHarness $this, ClusterBalanceManager c) {
        c.onControllerChange(LeaderAndEpoch.UNKNOWN);
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> c.close(), (Logging)$this, Level.WARN);
    }

    public QuorumTestHarness() {
        this.zkConnectionTimeout = 10000;
        this.zkSessionTimeout = 15000;
    }
}

