/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import kafka.server.BrokerBackpressureConfig$;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClusterLinkReplicationConfig;
import kafka.server.Defaults$;
import kafka.server.DiskUsageBasedThrottlingConfig$;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaFactory$;
import kafka.server.QuotaType;
import kafka.server.ReplicationQuotaManagerConfig;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005m2AAC\u0006\u0001!!)q\u0003\u0001C\u00011!)1\u0004\u0001C\u00019!)Q\u0006\u0001C\u00019!)q\u0006\u0001C\u00019!)\u0011\u0007\u0001C\u00019!)1\u0007\u0001C\u00019!)Q\u0007\u0001C\u00019!)q\u0007\u0001C\u00019!)\u0011\b\u0001C\u00019\t\u0001\u0012+^8uC\u001a\u000b7\r^8ssR+7\u000f\u001e\u0006\u0003\u00195\taa]3sm\u0016\u0014(\"\u0001\b\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0005\t\u0003%Ui\u0011a\u0005\u0006\u0002)\u0005)1oY1mC&\u0011ac\u0005\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005I\u0002C\u0001\u000e\u0001\u001b\u0005Y\u0011!\u000e;fgR\u0014V\r\u001d7jG\u0006$\u0018n\u001c8D_:4\u0017nZ*fiN\u001cuN\u001d:fGR\u0014\u0016\r^3G_JdU-\u00193feRC'o\u001c;uY\u0016$\u0012!\b\t\u0003%yI!aH\n\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005\u0005\u0002\"AI\u0016\u000e\u0003\rR!\u0001J\u0013\u0002\u0007\u0005\u0004\u0018N\u0003\u0002'O\u00059!.\u001e9ji\u0016\u0014(B\u0001\u0015*\u0003\u0015QWO\\5u\u0015\u0005Q\u0013aA8sO&\u0011Af\t\u0002\u0005)\u0016\u001cH/A\u001cuKN$(+\u001a9mS\u000e\fG/[8o\u0007>tg-[4TKR\u001c8i\u001c:sK\u000e$(+\u0019;f\r>\u0014hi\u001c7m_^,'\u000f\u00165s_R$H.\u001a\u0015\u0003\u0007\u0005\n!\t^3tiJ+\u0007\u000f\\5dCRLwN\\\"p]\u001aLwmU3ug\u0012+g-Y;mi\u001a{'/\u00117uKJdun\u001a#jeN\u0014V\r\u001d7jG\u0006$\u0018n\u001c8UQJ|G\u000f\u001e7fQ\t!\u0011%A\u000buKN$(I]8lKJ\fVo\u001c;b\u0019&l\u0017\u000e^:)\u0005\u0015\t\u0013!\u000e;fgR\u001cE.[3oiJ+\u0017/^3ti\u000e{gNZ5h'\u0016$8oQ8se\u0016\u001cGOQ1dWB\u0014Xm]:ve\u0016\u001cuN\u001c4jOND#AB\u0011\u00027Q,7\u000f\u001e#jg.\u0014\u0015mY6qe\u0016\u001c8/\u001e:f\u0007>tg-[4tQ\t9\u0011%\u0001\u000buKN$8\t\\;ti\u0016\u0014H*\u001b8l#V|G/\u0019\u0015\u0003\u0011\u0005\n\u0011\u0004^3ti\u000ec\u0017.\u001a8u)\"\u0014x.^4iaV$\u0018+^8uC\"\u0012\u0011\"\t")
public class QuotaFactoryTest {
    @Test
    public void testReplicationConfigSetsCorrectRateForLeaderThrottle() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "*");
        props.put(KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), "none");
        props.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), "1111");
        props.put(KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), "2222");
        ReplicationQuotaManagerConfig config = QuotaFactory$.MODULE$.replicationConfig(KafkaConfig$.MODULE$.fromProps(props), (QuotaType)QuotaType.LeaderReplication$.MODULE$);
        Assertions.assertTrue((boolean)config.allReplicasThrottled(), (String)"Expected all leader replicas to be throttled");
        Assertions.assertEquals((long)1111L, (long)config.quotaBytesPerSecond());
    }

    @Test
    public void testReplicationConfigSetsCorrectRateForFollowerThrottle() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "none");
        props.put(KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), "*");
        props.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), "1111");
        props.put(KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), "2222");
        ReplicationQuotaManagerConfig config = QuotaFactory$.MODULE$.replicationConfig(KafkaConfig$.MODULE$.fromProps(props), (QuotaType)QuotaType.FollowerReplication$.MODULE$);
        Assertions.assertTrue((boolean)config.allReplicasThrottled(), (String)"Expected all follower replicas to be throttled");
        Assertions.assertEquals((long)2222L, (long)config.quotaBytesPerSecond());
    }

    @Test
    public void testReplicationConfigSetsDefaultForAlterLogDirsReplicationThrottle() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "none");
        props.put(KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), "*");
        props.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), "1111");
        props.put(KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), "2222");
        ReplicationQuotaManagerConfig config = QuotaFactory$.MODULE$.replicationConfig(KafkaConfig$.MODULE$.fromProps(props), (QuotaType)QuotaType.AlterLogDirsReplication$.MODULE$);
        Assertions.assertFalse((boolean)config.allReplicasThrottled(), (String)"Expected no log dir replicas to be throttled");
        Assertions.assertEquals((long)Defaults$.MODULE$.QuotaBytesPerSecond(), (long)config.quotaBytesPerSecond());
    }

    @Test
    public void testBrokerQuotaLimits() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put("confluent.broker.limit.producer.bytes.per.second", "500");
        props.put("confluent.broker.limit.consumer.bytes.per.second", "1500");
        Assertions.assertEquals((double)QuotaFactory$.MODULE$.clientConfig(KafkaConfig$.MODULE$.fromProps(props), (QuotaType)QuotaType.Produce$.MODULE$).brokerQuotaLimit(), (double)500.0);
        Assertions.assertEquals((double)QuotaFactory$.MODULE$.clientConfig(KafkaConfig$.MODULE$.fromProps(props), (QuotaType)QuotaType.Fetch$.MODULE$).brokerQuotaLimit(), (double)1500.0);
    }

    @Test
    public void testClientRequestConfigSetsCorrectBackpressureConfigs() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.QueuedMaxRequestsProp(), "500");
        props.put("confluent.backpressure.types", "request");
        props.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
        props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://localhost:0,EXTERNAL://localhost:0");
        props.setProperty(KafkaConfig$.MODULE$.AdvertisedListenersProp(), "PLAINTEXT://localhost:0,EXTERNAL://localhost:0");
        props.put("confluent.multitenant.listener.names", "EXTERNAL");
        ClientQuotaManagerConfig config = QuotaFactory$.MODULE$.clientConfig(KafkaConfig$.MODULE$.fromProps(props), (QuotaType)QuotaType.Request$.MODULE$);
        Assertions.assertFalse((boolean)config.backpressureConfig().backpressureEnabledInConfig(), (String)"Expected request backpressure disabled");
        Assertions.assertEquals((Object)new .colon.colon((Object)"EXTERNAL", (List)Nil$.MODULE$), (Object)config.backpressureConfig().tenantEndpointListenerNames());
        Assertions.assertEquals((double)500.0, (double)config.backpressureConfig().maxQueueSize(), (double)0.0);
        Assertions.assertEquals((double)Predef$.MODULE$.Long2long(ConfluentConfigs.BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_DEFAULT), (double)config.backpressureConfig().minBrokerRequestQuota(), (double)0.0);
        Assertions.assertEquals((Object)"p95", (Object)config.backpressureConfig().queueSizePercentile());
        props.put("confluent.backpressure.request.min.broker.limit", "100");
        props.put("confluent.backpressure.request.queue.size.percentile", "p99");
        ClientQuotaManagerConfig config2 = QuotaFactory$.MODULE$.clientConfig(KafkaConfig$.MODULE$.fromProps(props), (QuotaType)QuotaType.Request$.MODULE$);
        Assertions.assertEquals((double)100.0, (double)config2.backpressureConfig().minBrokerRequestQuota(), (double)0.0);
        Assertions.assertEquals((Object)"p99", (Object)config2.backpressureConfig().queueSizePercentile());
        props.put("confluent.backpressure.request.min.broker.limit", "0");
        props.put("confluent.backpressure.request.queue.size.percentile", "p105");
        ClientQuotaManagerConfig config3 = QuotaFactory$.MODULE$.clientConfig(KafkaConfig$.MODULE$.fromProps(props), (QuotaType)QuotaType.Request$.MODULE$);
        Assertions.assertEquals((double)BrokerBackpressureConfig$.MODULE$.MinBrokerRequestQuota(), (double)config3.backpressureConfig().minBrokerRequestQuota(), (double)0.0);
        Assertions.assertEquals((Object)"p95", (Object)config3.backpressureConfig().queueSizePercentile());
    }

    @Test
    public void testDiskBackpressureConfigs() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put("confluent.cluster.link.enable", "true");
        props.put("confluent.backpressure.types", "request");
        props.put("confluent.multitenant.listener.names", "EXTERNAL");
        ClientQuotaManagerConfig config = QuotaFactory$.MODULE$.clientConfig(KafkaConfig$.MODULE$.fromProps(props), (QuotaType)QuotaType.Produce$.MODULE$);
        Assertions.assertEquals((long)0x500000000L, (long)config.diskThrottlingConfig().freeDiskThresholdBytes());
        props.put("confluent.backpressure.disk.free.threshold.bytes", "1234567");
        config = QuotaFactory$.MODULE$.clientConfig(KafkaConfig$.MODULE$.fromProps(props), (QuotaType)QuotaType.Produce$.MODULE$);
        Assertions.assertEquals((long)DiskUsageBasedThrottlingConfig$.MODULE$.MinDiskThresholdBytes(), (long)config.diskThrottlingConfig().freeDiskThresholdBytes());
        long thresholdBytes = 0x80000000L;
        props.put("confluent.backpressure.disk.free.threshold.bytes", Long.toString(thresholdBytes));
        config = QuotaFactory$.MODULE$.clientConfig(KafkaConfig$.MODULE$.fromProps(props), (QuotaType)QuotaType.Produce$.MODULE$);
        Assertions.assertEquals((long)thresholdBytes, (long)config.diskThrottlingConfig().freeDiskThresholdBytes());
        props.put("confluent.cluster.link.enable", "false");
        config = QuotaFactory$.MODULE$.clientConfig(KafkaConfig$.MODULE$.fromProps(props), (QuotaType)QuotaType.Produce$.MODULE$);
        Assertions.assertEquals((long)thresholdBytes, (long)config.diskThrottlingConfig().freeDiskThresholdBytes());
    }

    @Test
    public void testClusterLinkQuota() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put("confluent.cluster.link.enable", "true");
        props.put("confluent.cluster.link.io.max.bytes.per.second", "10000");
        ClusterLinkReplicationConfig quotaConfig = QuotaFactory$.MODULE$.clusterLinkReplicationConfig(KafkaConfig$.MODULE$.fromProps(props));
        Assertions.assertEquals((long)10000L, (long)quotaConfig.replicationQuotaManagerConfig().quotaBytesPerSecond());
        Assertions.assertTrue((boolean)quotaConfig.replicationQuotaManagerConfig().allReplicasThrottled());
        props.put("confluent.cluster.link.io.max.bytes.per.second", Long.toString(Long.MAX_VALUE));
        ClusterLinkReplicationConfig quotaConfig2 = QuotaFactory$.MODULE$.clusterLinkReplicationConfig(KafkaConfig$.MODULE$.fromProps(props));
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)quotaConfig2.replicationQuotaManagerConfig().quotaBytesPerSecond());
        Assertions.assertFalse((boolean)quotaConfig2.replicationQuotaManagerConfig().allReplicasThrottled());
    }

    @Test
    public void testClientThroughputQuota() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        ClientQuotaManagerConfig produceQuotaConfig = QuotaFactory$.MODULE$.clientConfig(KafkaConfig$.MODULE$.fromProps(props), (QuotaType)QuotaType.Produce$.MODULE$);
        Assertions.assertEquals((int)11, (int)produceQuotaConfig.numQuotaSamples());
        ClientQuotaManagerConfig fetchQuotaConfig = QuotaFactory$.MODULE$.clientConfig(KafkaConfig$.MODULE$.fromProps(props), (QuotaType)QuotaType.Fetch$.MODULE$);
        Assertions.assertEquals((int)11, (int)fetchQuotaConfig.numQuotaSamples());
        ClientQuotaManagerConfig requestQuotaConfig = QuotaFactory$.MODULE$.clientConfig(KafkaConfig$.MODULE$.fromProps(props), (QuotaType)QuotaType.Request$.MODULE$);
        Assertions.assertEquals((int)11, (int)requestQuotaConfig.numQuotaSamples());
    }
}

