/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Properties;
import kafka.raft.KafkaRaftManager;
import kafka.server.KafkaConfig$;
import kafka.testkit.KafkaClusterTestKit;
import kafka.testkit.TestKitNodes;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.EncryptedEnvelopeRecord;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.metadata.AesGcm128MetadataEncryptor;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RecordsSnapshotReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@Timeout(value=120L)
@ScalaSignature(bytes="\u0006\u0005=2A\u0001B\u0003\u0001\u0015!)\u0011\u0003\u0001C\u0001%!)Q\u0003\u0001C\u0001-!)q\u0005\u0001C\u0001-\t9\"+\u00194u\u00072,8\u000f^3s':\f\u0007o\u001d5piR+7\u000f\u001e\u0006\u0003\r\u001d\taa]3sm\u0016\u0014(\"\u0001\u0005\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0003\t\u0003\u0019=i\u0011!\u0004\u0006\u0002\u001d\u0005)1oY1mC&\u0011\u0001#\u0004\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0019\u0002C\u0001\u000b\u0001\u001b\u0005)\u0011A\u0006;fgR\u001cf.\u00199tQ>$8oR3oKJ\fG/\u001a3\u0015\u0003]\u0001\"\u0001\u0004\r\n\u0005ei!\u0001B+oSRD#AA\u000e\u0011\u0005q)S\"A\u000f\u000b\u0005yy\u0012aA1qS*\u0011\u0001%I\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u00113%A\u0003kk:LGOC\u0001%\u0003\ry'oZ\u0005\u0003Mu\u0011A\u0001V3ti\u0006yC/Z:u':\f\u0007o\u001d5piN<UM\\3sCR,GmV5uQ\u0006\u0003\bO]8qe&\fG/Z#oGJL\b\u000f^5p]\"\u00121a\u0007\u0015\u0005\u0001)jc\u0006\u0005\u0002\u001dW%\u0011A&\b\u0002\b)&lWm\\;u\u0003\u00151\u0018\r\\;f=\u0005A\b")
public class RaftClusterSnapshotTest {
    @Test
    public void testSnapshotsGenerated() {
        int numberOfBrokers = 3;
        int numberOfControllers = 3;
        try (KafkaClusterTestKit resource_resource = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(numberOfBrokers).setNumControllerNodes(numberOfControllers).build()).setConfigProp(KafkaConfig$.MODULE$.MetadataSnapshotMaxNewRecordBytesProp(), "10").setConfigProp(KafkaConfig$.MODULE$.MetadataMaxIdleIntervalMsProp(), "0").build();){
            RaftClusterSnapshotTest.$anonfun$testSnapshotsGenerated$1(numberOfControllers, numberOfBrokers, resource_resource);
        }
    }

    @Test
    public void testSnapshotsGeneratedWithAppropriateEncryption() {
        AesGcm128MetadataEncryptor kraftEncryptor = new AesGcm128MetadataEncryptor();
        try (KafkaClusterTestKit resource_resource = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MetadataSnapshotMaxIntervalMsProp(), "1").setConfigProp(KafkaConfig$.MODULE$.MetadataMaxIdleIntervalMsProp(), "1").setConfigProp("confluent.metadata.active.encryptor", kraftEncryptor.id().toString()).setConfigProp("confluent.metadata.encryptor.classes", new StringBuilder(1).append(kraftEncryptor.id()).append("=").append(kraftEncryptor.getClass().getCanonicalName()).toString()).setConfigProp("confluent.metadata.encryptor.secrets", new StringBuilder(1).append(kraftEncryptor.id()).append("=").append(Base64.getUrlEncoder().withoutPadding().encodeToString(kraftEncryptor.secret())).toString()).build();){
            RaftClusterSnapshotTest.$anonfun$testSnapshotsGeneratedWithAppropriateEncryption$1(resource_resource);
        }
    }

    public static final /* synthetic */ boolean $anonfun$testSnapshotsGenerated$3(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((KafkaRaftManager)x0$1._2()).replicatedLog().latestSnapshotId().isPresent();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testSnapshotsGenerated$2(KafkaClusterTestKit cluster$1) {
        return CollectionConverters$.MODULE$.MapHasAsScala(cluster$1.raftManagers()).asScala().forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RaftClusterSnapshotTest.$anonfun$testSnapshotsGenerated$3(x0$1)));
    }

    public static final /* synthetic */ String $anonfun$testSnapshotsGenerated$4(KafkaClusterTestKit cluster$1) {
        return new StringBuilder(65).append("Expected for every controller and broker to generate a snapshot: ").append(CollectionConverters$.MODULE$.MapHasAsScala(cluster$1.raftManagers()).asScala().map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                Integer id = (Integer)x0$2._1();
                KafkaRaftManager raftManager = (KafkaRaftManager)x0$2._2();
                return new Tuple2((Object)id, (Object)raftManager.replicatedLog().latestSnapshotId());
            }
            throw new MatchError(null);
        })).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testSnapshotsGenerated$6(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$testSnapshotsGenerated$8(RecordsSnapshotReader snapshot) {
        Assertions.assertTrue((boolean)snapshot.hasNext());
        while (snapshot.hasNext()) {
            Batch batch = snapshot.next();
            Assertions.assertTrue((batch.sizeInBytes() > 0 ? 1 : 0) != 0);
            Assertions.assertNotEquals(Collections.emptyList(), (Object)batch.records());
        }
    }

    public static final /* synthetic */ void $anonfun$testSnapshotsGenerated$7(Tuple2 x$1) {
        if (x$1 != null) {
            KafkaRaftManager raftManager = (KafkaRaftManager)x$1._2();
            try (RecordsSnapshotReader resource_resource = RecordsSnapshotReader.of((RawSnapshotReader)((RawSnapshotReader)raftManager.replicatedLog().latestSnapshot().get()), (RecordSerde)new MetadataRecordSerde(), (BufferSupplier)BufferSupplier.create(), (int)1, (boolean)true);){
                RaftClusterSnapshotTest.$anonfun$testSnapshotsGenerated$8(resource_resource);
            }
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testSnapshotsGenerated$1(int numberOfControllers$1, int numberOfBrokers$1, KafkaClusterTestKit cluster) {
        cluster.format();
        cluster.startup();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!RaftClusterSnapshotTest.$anonfun$testSnapshotsGenerated$2(cluster)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RaftClusterSnapshotTest.$anonfun$testSnapshotsGenerated$4(cluster));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)(numberOfControllers$1 + numberOfBrokers$1), (int)cluster.raftManagers().size());
        CollectionConverters$.MODULE$.MapHasAsScala(cluster.raftManagers()).asScala().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)RaftClusterSnapshotTest.$anonfun$testSnapshotsGenerated$6(check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> {
            RaftClusterSnapshotTest.$anonfun$testSnapshotsGenerated$7(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Void $anonfun$testSnapshotsGeneratedWithAppropriateEncryption$2(Admin admin) {
        return (Void)admin.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), Arrays.asList(new AlterConfigOp(new ConfigEntry("unknown.config.that.will.be.treated.as.password", "abc"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.MaxConnectionsProp(), "100"), AlterConfigOp.OpType.SET)))).all().get();
    }

    public static final /* synthetic */ boolean $anonfun$testSnapshotsGeneratedWithAppropriateEncryption$4(Tuple2 check$ifrefutable$2) {
        return check$ifrefutable$2 != null;
    }

    public static final /* synthetic */ void $anonfun$testSnapshotsGeneratedWithAppropriateEncryption$6(RecordsSnapshotReader snapshot) {
        Assertions.assertTrue((boolean)snapshot.hasNext());
        BooleanRef sawConfigRecord = BooleanRef.create((boolean)false);
        BooleanRef sawEncryptedRecord = BooleanRef.create((boolean)false);
        while (snapshot.hasNext()) {
            Batch batch = snapshot.next();
            Assertions.assertTrue((batch.sizeInBytes() > 0 ? 1 : 0) != 0);
            batch.records().forEach(record -> {
                if (record.message() instanceof EncryptedEnvelopeRecord) {
                    sawEncryptedRecord$1.elem = true;
                    return;
                }
                if (record.message() instanceof ConfigRecord) {
                    sawConfigRecord$1.elem = true;
                    return;
                }
            });
            Assertions.assertTrue((boolean)sawEncryptedRecord.elem);
            Assertions.assertTrue((boolean)sawConfigRecord.elem);
        }
    }

    public static final /* synthetic */ void $anonfun$testSnapshotsGeneratedWithAppropriateEncryption$5(Tuple2 x$2) {
        if (x$2 != null) {
            KafkaRaftManager raftManager = (KafkaRaftManager)x$2._2();
            try (RecordsSnapshotReader resource_resource = RecordsSnapshotReader.of((RawSnapshotReader)((RawSnapshotReader)raftManager.replicatedLog().latestSnapshot().get()), (RecordSerde)new MetadataRecordSerde(), (BufferSupplier)BufferSupplier.create(), (int)1, (boolean)true);){
                RaftClusterSnapshotTest.$anonfun$testSnapshotsGeneratedWithAppropriateEncryption$6(resource_resource);
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testSnapshotsGeneratedWithAppropriateEncryption$3(KafkaClusterTestKit cluster$2) {
        CollectionConverters$.MODULE$.MapHasAsScala(cluster$2.raftManagers()).asScala().withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)RaftClusterSnapshotTest.$anonfun$testSnapshotsGeneratedWithAppropriateEncryption$4(check$ifrefutable$2))).foreach((Function1 & Serializable)x$2 -> {
            RaftClusterSnapshotTest.$anonfun$testSnapshotsGeneratedWithAppropriateEncryption$5(x$2);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testSnapshotsGeneratedWithAppropriateEncryption$1(KafkaClusterTestKit cluster) {
        cluster.format();
        cluster.startup();
        try (Admin resource_resource = Admin.create((Properties)cluster.clientProperties());){
            RaftClusterSnapshotTest.$anonfun$testSnapshotsGeneratedWithAppropriateEncryption$2(resource_resource);
        }
        Object var1_1 = null;
        long l = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                RaftClusterSnapshotTest.$anonfun$testSnapshotsGeneratedWithAppropriateEncryption$3(cluster);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var9_8 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ Object $anonfun$testSnapshotsGenerated$1$adapted(int numberOfControllers$1, int numberOfBrokers$1, KafkaClusterTestKit cluster) {
        RaftClusterSnapshotTest.$anonfun$testSnapshotsGenerated$1(numberOfControllers$1, numberOfBrokers$1, cluster);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSnapshotsGeneratedWithAppropriateEncryption$1$adapted(KafkaClusterTestKit cluster) {
        RaftClusterSnapshotTest.$anonfun$testSnapshotsGeneratedWithAppropriateEncryption$1(cluster);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSnapshotsGenerated$8$adapted(RecordsSnapshotReader snapshot) {
        RaftClusterSnapshotTest.$anonfun$testSnapshotsGenerated$8(snapshot);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSnapshotsGeneratedWithAppropriateEncryption$6$adapted(RecordsSnapshotReader snapshot) {
        RaftClusterSnapshotTest.$anonfun$testSnapshotsGeneratedWithAppropriateEncryption$6(snapshot);
        return BoxedUnit.UNIT;
    }
}

