/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Properties;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerFeatures$;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.Fetching$;
import kafka.server.FullPartitionFetchMetadata;
import kafka.server.InitialFetchState;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LeaderEndPoint;
import kafka.server.LocalLeaderEndPoint;
import kafka.server.PartitionFetchMetadata;
import kafka.server.PartitionFetchState;
import kafka.server.PausedPartitions;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaAlterLogDirsThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicaState;
import kafka.server.ReplicationQuotaManager;
import kafka.server.Truncating$;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.DelayedItem;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.server.common.DirectoryEventHandler;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.FetchParams;
import org.apache.kafka.storage.internals.log.FetchPartitionData;
import org.apache.kafka.storage.internals.log.FetchPartitionStats;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.Integral;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u001df\u0001B\u0017/\u0001MBQA\u000f\u0001\u0005\u0002mBqA\u0010\u0001C\u0002\u0013%q\b\u0003\u0004L\u0001\u0001\u0006I\u0001\u0011\u0005\b\u0019\u0002\u0011\r\u0011\"\u0003@\u0011\u0019i\u0005\u0001)A\u0005\u0001\"9a\n\u0001b\u0001\n\u0013y\u0005BB*\u0001A\u0003%\u0001\u000bC\u0004U\u0001\t\u0007I\u0011B+\t\r\u0019\u0004\u0001\u0015!\u0003W\u0011\u001d9\u0007A1A\u0005\n!DaA\u001b\u0001!\u0002\u0013I\u0007bB6\u0001\u0005\u0004%I\u0001\u001c\u0005\u0007a\u0002\u0001\u000b\u0011B7\t\u000fE\u0004!\u0019!C\u0005e\"1a\u000f\u0001Q\u0001\nMDqa\u001e\u0001C\u0002\u0013%\u0001\u0010\u0003\u0004}\u0001\u0001\u0006I!\u001f\u0005\b{\u0002\u0011\r\u0011\"\u0003\u007f\u0011\u001d\ty\u0002\u0001Q\u0001\n}D\u0011\"!\t\u0001\u0005\u0004%I!a\t\t\u0011\u0005E\u0002\u0001)A\u0005\u0003KA\u0011\"a\r\u0001\u0005\u0004%I!!\u000e\t\u0011\u0005\r\u0003\u0001)A\u0005\u0003oAq!!\u0012\u0001\t\u0013\t9\u0005C\u0005\u0002d\u0001\t\n\u0011\"\u0003\u0002f!9\u00111\u0010\u0001\u0005\u0002\u0005u\u0004bBAN\u0001\u0011\u0005\u0011Q\u0010\u0005\b\u0003?\u0003A\u0011AA?\u0011\u001d\t\u0019\u000b\u0001C\u0005\u0003KCq!a7\u0001\t\u0003\ti\bC\u0004\u0002`\u0002!\t!! \t\u000f\u0005\r\b\u0001\"\u0001\u0002~!9\u0011q\u001d\u0001\u0005\n\u0005%\bb\u0002B\u0013\u0001\u0011\u0005\u0011Q\u0010\u0005\b\u0005S\u0001A\u0011AA?\u0011\u001d\u0011i\u0003\u0001C\u0001\u0003{BqA!\r\u0001\t\u0003\ti\bC\u0004\u00036\u0001!\t!! \t\u000f\te\u0002\u0001\"\u0001\u0002~!9!Q\b\u0001\u0005\u0002\u0005u\u0004b\u0002B!\u0001\u0011\u0005\u0011Q\u0010\u0005\b\u0005\u000b\u0002A\u0011AA?\u0011\u001d\u0011I\u0005\u0001C\u0001\u0005\u0017BqA!\u001e\u0001\t\u0003\u00119HA\u000fSKBd\u0017nY1BYR,'\u000fT8h\t&\u00148\u000f\u00165sK\u0006$G+Z:u\u0015\ty\u0003'\u0001\u0004tKJ4XM\u001d\u0006\u0002c\u0005)1.\u00194lC\u000e\u00011C\u0001\u00015!\t)\u0004(D\u00017\u0015\u00059\u0014!B:dC2\f\u0017BA\u001d7\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\u0010\t\u0003{\u0001i\u0011AL\u0001\u0005iF\u0002\b'F\u0001A!\t\t\u0015*D\u0001C\u0015\t\u0019E)\u0001\u0004d_6lwN\u001c\u0006\u0003c\u0015S!AR$\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0015aA8sO&\u0011!J\u0011\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003\u0015!\u0018\u0007\u001d\u0019!\u0003\u0011!\u0018\u0007]\u0019\u0002\u000bQ\f\u0004/\r\u0011\u0002\u000fQ|\u0007/[2JIV\t\u0001\u000b\u0005\u0002B#&\u0011!K\u0011\u0002\u0005+VLG-\u0001\u0005u_BL7-\u00133!\u0003!!x\u000e]5d\u0013\u0012\u001cX#\u0001,\u0011\t]cf\fU\u0007\u00021*\u0011\u0011LW\u0001\nS6lW\u000f^1cY\u0016T!a\u0017\u001c\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002^1\n\u0019Q*\u00199\u0011\u0005}#W\"\u00011\u000b\u0005\u0005\u0014\u0017\u0001\u00027b]\u001eT\u0011aY\u0001\u0005U\u00064\u0018-\u0003\u0002fA\n11\u000b\u001e:j]\u001e\f\u0011\u0002^8qS\u000eLEm\u001d\u0011\u0002\u0015Q|\u0007/[2OC6,7/F\u0001j!\u00119F\f\u00150\u0002\u0017Q|\u0007/[2OC6,7\u000fI\u0001\u0007i&$\u0017\u0007\u001d\u0019\u0016\u00035\u0004\"!\u00118\n\u0005=\u0014%\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0003\u001d!\u0018\u000eZ\u0019qa\u0001\n\u0001CZ1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0016\u0003M\u0004\"!\u0010;\n\u0005Ut#\u0001\u0005$bS2,G\rU1si&$\u0018n\u001c8t\u0003E1\u0017-\u001b7fIB\u000b'\u000f^5uS>t7\u000fI\u0001\u0011a\u0006,8/\u001a3QCJ$\u0018\u000e^5p]N,\u0012!\u001f\t\u0003{iL!a\u001f\u0018\u0003!A\u000bWo]3e!\u0006\u0014H/\u001b;j_:\u001c\u0018!\u00059bkN,G\rU1si&$\u0018n\u001c8tA\u0005y\u0001/\u0019:uSRLwN\\*uCR,7/F\u0001\u0000!\u0019\t\t!a\u0002\u0002\f5\u0011\u00111\u0001\u0006\u0004\u0003\u000b\u0011\u0017\u0001B;uS2LA!!\u0003\u0002\u0004\t!A*[:u!\u0011\ti!!\u0007\u000f\t\u0005=\u0011QC\u0007\u0003\u0003#Q1!a\u0005C\u0003\u001diWm]:bO\u0016LA!a\u0006\u0002\u0012\u0005IR\u000b\u001d3bi\u0016lU\r^1eCR\f'+Z9vKN$H)\u0019;b\u0013\u0011\tY\"!\b\u00039U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCB\u000b'\u000f^5uS>t7\u000b^1uK*!\u0011qCA\t\u0003A\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016\u001c\b%A\u000bva\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;\u0016\u0005\u0005\u0015\u0002\u0003BA\u0014\u0003[i!!!\u000b\u000b\u0007\u0005-\")\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\ty#!\u000b\u0003+U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti\u00061R\u000f\u001d3bi\u0016lU\r^1eCR\f'+Z9vKN$\b%A\u0007nKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u000b\u0003\u0003o\u0001B!!\u000f\u0002@5\u0011\u00111\b\u0006\u0004\u0003{q\u0013\u0001C7fi\u0006$\u0017\r^1\n\t\u0005\u0005\u00131\b\u0002\u00105.lU\r^1eCR\f7)Y2iK\u0006qQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004\u0013!E5oSRL\u0017\r\u001c$fi\u000eD7\u000b^1uKR1\u0011\u0011JA(\u00033\u00022!PA&\u0013\r\tiE\f\u0002\u0012\u0013:LG/[1m\r\u0016$8\r[*uCR,\u0007bBA)1\u0001\u0007\u00111K\u0001\fM\u0016$8\r[(gMN,G\u000fE\u00026\u0003+J1!a\u00167\u0005\u0011auN\\4\t\u0013\u0005m\u0003\u0004%AA\u0002\u0005u\u0013a\u00037fC\u0012,'/\u00129pG\"\u00042!NA0\u0013\r\t\tG\u000e\u0002\u0004\u0013:$\u0018aG5oSRL\u0017\r\u001c$fi\u000eD7\u000b^1uK\u0012\"WMZ1vYR$#'\u0006\u0002\u0002h)\"\u0011QLA5W\t\tY\u0007\u0005\u0003\u0002n\u0005]TBAA8\u0015\u0011\t\t(a\u001d\u0002\u0013Ut7\r[3dW\u0016$'bAA;m\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005e\u0014q\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001L:i_VdGMT8u\u0003\u0012$\u0007+\u0019:uSRLwN\\%g\rV$XO]3M_\u001eL5OT8u\t\u00164\u0017N\\3e)\t\ty\bE\u00026\u0003\u0003K1!a!7\u0005\u0011)f.\u001b;)\u0007i\t9\t\u0005\u0003\u0002\n\u0006]UBAAF\u0015\u0011\ti)a$\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002\u0012\u0006M\u0015a\u00026va&$XM\u001d\u0006\u0004\u0003+;\u0015!\u00026v]&$\u0018\u0002BAM\u0003\u0017\u0013A\u0001V3ti\u0006a3\u000f[8vY\u0012,\u0006\u000fZ1uK2+\u0017\rZ3s\u000bB|7\r[!gi\u0016\u0014h)\u001a8dK\u0012,\u0005o\\2i\u000bJ\u0014xN\u001d\u0015\u00047\u0005\u001d\u0015AJ:i_VdGMU3qY\u0006\u001cWmQ;se\u0016tG\u000fT8h\t&\u0014x\u000b[3o\u0007\u0006,x\r\u001b;Va\"\u001aA$a\"\u0002/U\u0004H-\u0019;f%\u0016\f7o]5h]6,g\u000e^*uCR,G\u0003CAT\u0003[\u000b9,a/\u0011\u000bU\nI+a \n\u0007\u0005-fG\u0001\u0004PaRLwN\u001c\u0005\b\u0003_k\u0002\u0019AAY\u0003\u0019!\bN]3bIB\u0019Q(a-\n\u0007\u0005UfFA\rSKBd\u0017nY1BYR,'\u000fT8h\t&\u00148\u000f\u00165sK\u0006$\u0007bBA];\u0001\u0007\u0011QL\u0001\fa\u0006\u0014H/\u001b;j_:LE\rC\u0004\u0002>v\u0001\r!a0\u0002\u00119,wo\u0015;bi\u0016\u0004B!!1\u0002V:!\u00111YAi\u001d\u0011\t)-a4\u000f\t\u0005\u001d\u0017QZ\u0007\u0003\u0003\u0013T1!a33\u0003\u0019a$o\\8u}%\t\u0011'\u0003\u00020a%\u0019\u00111\u001b\u0018\u00023I+\u0007\u000f\\5dC\u0006cG/\u001a:M_\u001e$\u0015N]:UQJ,\u0017\rZ\u0005\u0005\u0003/\fINA\tSK\u0006\u001c8/[4o[\u0016tGo\u0015;bi\u0016T1!a5/\u0003A\u001b\bn\\;mIJ+\u0007\u000f\\1dK\u000e+(O]3oi2{w\rR5s/\",gnQ1vO\"$X\u000b],ji\"\fe\r^3s\u0003N\u001c\u0018n\u001a8nK:$(+Z9vKN$\b*Y:CK\u0016t7i\\7qY\u0016$X\r\u001a\u0015\u0004=\u0005\u001d\u0015\u0001Q:i_VdGMU3wKJ$\u0018I\\=TG\",G-\u001e7fI\u0006\u001b8/[4o[\u0016tGOU3rk\u0016\u001cH/\u00134BgNLwM\\7f]RL5oQ1oG\u0016dG.\u001a3)\u0007}\t9)A\u001ftQ>,H\u000e\u001a*fm\u0016\u0014HOU3bgNLwM\\7f]R\u001chi\u001c:J]\u000e|W\u000e\u001d7fi\u00164U\u000f^;sKJ+\u0007\u000f\\5dCB\u0013x.\\8uS>t7\u000fK\u0002!\u0003\u000f\u000bq#\\8dW\u001a+Go\u00195Ge>l7)\u001e:sK:$Hj\\4\u0015\u0019\u0005}\u00141^Ax\u0003s\u0014\u0019A!\u0004\t\r\u00055\u0018\u00051\u0001n\u0003A!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002r\u0006\u0002\r!a=\u0002\u0017I,\u0017/^3ti\u0012\u000bG/\u0019\t\u0004{\u0005U\u0018bAA|]\t1\u0002+\u0019:uSRLwN\u001c$fi\u000eDW*\u001a;bI\u0006$\u0018\rC\u0004\u0002|\u0006\u0002\r!!@\u0002\r\r|gNZ5h!\ri\u0014q`\u0005\u0004\u0005\u0003q#aC&bM.\f7i\u001c8gS\u001eDqA!\u0002\"\u0001\u0004\u00119!\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\u0007u\u0012I!C\u0002\u0003\f9\u0012aBU3qY&\u001c\u0017-T1oC\u001e,'\u000fC\u0004\u0003\u0010\u0005\u0002\rA!\u0005\u0002\u0019I,7\u000f]8og\u0016$\u0015\r^1\u0011\t\tM!\u0011E\u0007\u0003\u0005+QAAa\u0006\u0003\u001a\u0005\u0019An\\4\u000b\t\tm!QD\u0001\nS:$XM\u001d8bYNT1Aa\bE\u0003\u001d\u0019Ho\u001c:bO\u0016LAAa\t\u0003\u0016\t\u0011b)\u001a;dQB\u000b'\u000f^5uS>tG)\u0019;b\u0003\tJ7o];fg\u0016\u0003xn\u00195SKF,Xm\u001d;Ge>lGj\\2bYJ+\u0007\u000f\\5dC\"\u001a!%a\"\u0002{\u0019,Go\u00195Fa>\u001c\u0007n\u001d$s_6dU-\u00193feNCw.\u001e7e\u0011\u0006tG\r\\3Fq\u000e,\u0007\u000f^5p]\u001a\u0013x.\\$fi2{7-\u00197SKBd\u0017nY1)\u0007\r\n9)A\u000ftQ>,H\u000e\u001a+sk:\u001c\u0017\r^3U_J+\u0007\u000f\\5dC>3gm]3uQ\r!\u0013qQ\u0001.g\"|W\u000f\u001c3UeVt7-\u0019;f)>,e\u000eZ(gMN,Go\u00144MCJ<Wm\u001d;D_6lwN\\#q_\u000eD\u0007fA\u0013\u0002\b\u0006\t5\u000f[8vY\u0012$&/\u001e8dCR,Gk\\%oSRL\u0017\r\u001c$fi\u000eDwJ\u001a4tKRLeMU3qY&\u001c\u0017MU3ukJt7/\u00168eK\u001aLg.\u001a3PM\u001a\u001cX\r\u001e\u0015\u0004M\u0005\u001d\u0015aK:i_VdG\rU8mY&sG-\u001a4j]&$X\r\\=JMJ+\u0007\u000f\\5dC:{G/\u0011<bS2\f'\r\\3)\u0007\u001d\n9)\u0001\u0014tQ>,H\u000e\u001a$fi\u000eDG*Z1eKJ,\u0005o\\2i\u001f:4\u0015N]:u\r\u0016$8\r[(oYfD3\u0001KAD\u0003q\u0019\bn\\;mI\u001a+Go\u00195P]\u0016\u0014V\r\u001d7jG\u0006\fE/\u0011+j[\u0016D3!KAD\u00035\u001a\bn\\;mI\u001a+Go\u00195O_:$U\r\\1zK\u0012\fe\u000e\u001a(p]R\u0013XO\\2bi&twMU3qY&\u001c\u0017m\u001d\u0015\u0004U\u0005\u001d\u0015\u0001B:uk\n$B\"a \u0003N\tm#q\fB2\u0005gBqAa\u0014,\u0001\u0004\u0011\t&A\u0004m_\u001e$\u0016\u0007\u001d\u0019\u0011\t\tM#qK\u0007\u0003\u0005+R1Aa\u00061\u0013\u0011\u0011IF!\u0016\u0003\u0017\u0005\u00137\u000f\u001e:bGRdun\u001a\u0005\b\u0005;Z\u0003\u0019\u0001B)\u0003\u001dawn\u001a+2aFBqA!\u0019,\u0001\u0004\u0011\t&A\u0005gkR,(/\u001a'pO\"9!QM\u0016A\u0002\t\u001d\u0014!\u00039beRLG/[8o!\u0011\u0011IGa\u001c\u000e\u0005\t-$b\u0001B7a\u000591\r\\;ti\u0016\u0014\u0018\u0002\u0002B9\u0005W\u0012\u0011\u0002U1si&$\u0018n\u001c8\t\u000f\t\u00151\u00061\u0001\u0003\b\u0005)2\u000f^;c/&$\bNR3uG\"lUm]:bO\u0016\u001cHCDA@\u0005s\u0012YH! \u0003\u0000\t\u0005%1\u0011\u0005\b\u0005\u001fb\u0003\u0019\u0001B)\u0011\u001d\u0011i\u0006\fa\u0001\u0005#BqA!\u0019-\u0001\u0004\u0011\t\u0006C\u0004\u0003f1\u0002\rAa\u001a\t\u000f\t\u0015A\u00061\u0001\u0003\b!9!Q\u0011\u0017A\u0002\t\u001d\u0015\u0001\u0005:fgB|gn]3DC2d'-Y2l!\u0019\u0011IIa$\u0003\u00146\u0011!1\u0012\u0006\u0004\u0005\u001b;\u0015aB7pG.LGo\\\u0005\u0005\u0005#\u0013YI\u0001\bBe\u001e,X.\u001a8u\u0007\u0006\u0004Ho\u001c:\u0011\u000fU\u0012)J!'\u0002\u0000%\u0019!q\u0013\u001c\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0002BN\u0005;\u0013\t+D\u0001[\u0013\r\u0011yJ\u0017\u0002\u0004'\u0016\f\bCB\u001b\u0003$6\u0014\t\"C\u0002\u0003&Z\u0012a\u0001V;qY\u0016\u0014\u0004")
public class ReplicaAlterLogDirsThreadTest {
    private final TopicPartition t1p0 = new TopicPartition("topic1", 0);
    private final TopicPartition t1p1 = new TopicPartition("topic1", 1);
    private final Uuid topicId = Uuid.randomUuid();
    private final scala.collection.immutable.Map<String, Uuid> topicIds = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic1"), (Object)this.topicId())}));
    private final scala.collection.immutable.Map<Uuid, String> topicNames = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicId()), (Object)"topic1")}));
    private final TopicIdPartition tid1p0 = new TopicIdPartition(this.topicId(), this.t1p0());
    private final FailedPartitions failedPartitions = new FailedPartitions();
    private final PausedPartitions pausedPartitions = new PausedPartitions();
    private final java.util.List<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName("topic1").setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0), (List)Nil$.MODULE$)).asJava();
    private final UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(ApiKeys.UPDATE_METADATA.latestVersion(), 0, 0, 0L, Collections.emptyList(), this.partitionStates(), Collections.emptyList(), CollectionConverters$.MODULE$.MapHasAsJava(this.topicIds()).asJava(), Collections.emptyList(), false).build();
    private final ZkMetadataCache metadataCache = new ZkMetadataCache(0, MetadataVersion.latestTesting(), BrokerFeatures$.MODULE$.createEmpty(), (Seq)Seq$.MODULE$.empty(), false, false);

    private TopicPartition t1p0() {
        return this.t1p0;
    }

    private TopicPartition t1p1() {
        return this.t1p1;
    }

    private Uuid topicId() {
        return this.topicId;
    }

    private scala.collection.immutable.Map<String, Uuid> topicIds() {
        return this.topicIds;
    }

    private scala.collection.immutable.Map<Uuid, String> topicNames() {
        return this.topicNames;
    }

    private TopicIdPartition tid1p0() {
        return this.tid1p0;
    }

    private FailedPartitions failedPartitions() {
        return this.failedPartitions;
    }

    private PausedPartitions pausedPartitions() {
        return this.pausedPartitions;
    }

    private java.util.List<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates() {
        return this.partitionStates;
    }

    private UpdateMetadataRequest updateMetadataRequest() {
        return this.updateMetadataRequest;
    }

    private ZkMetadataCache metadataCache() {
        return this.metadataCache;
    }

    private InitialFetchState initialFetchState(long fetchOffset, int leaderEpoch) {
        Some x$1 = new Some((Object)this.topicId());
        BrokerEndPoint x$2 = new BrokerEndPoint(0, "localhost", 9092);
        None$ x$5 = None$.MODULE$;
        return new InitialFetchState((Option)x$1, x$2, leaderEpoch, fetchOffset, (Option)x$5);
    }

    private int initialFetchState$default$2() {
        return 1;
    }

    @Test
    public void shouldNotAddPartitionIfFutureLogIsNotDefined() {
        int brokerId = 1;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(brokerId, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread", (LeaderEndPoint)leader, this.failedPartitions(), this.pausedPartitions(), exponentialBackoff, replicaManager, quotaManager, new BrokerTopicStats(), DirectoryEventHandler.NOOP);
        Set addedPartitions = thread.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, 1))})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)addedPartitions);
        Assertions.assertEquals((int)0, (int)thread.partitionCount());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)thread.fetchState(this.t1p0()));
    }

    @Test
    public void shouldUpdateLeaderEpochAfterFencedEpochError() {
        int brokerId = 1;
        int partitionId = 0;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(brokerId, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        AbstractLog futureLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        int leaderEpoch = 5;
        int logEndOffset = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partition.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.onlinePartition(this.t1p0())).thenReturn((Object)new Some((Object)partition));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quotaManager.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)logEndOffset));
        Mockito.when((Object)partition.futureLocalLogOrException()).thenReturn((Object)futureLog);
        ((Partition)Mockito.doNothing().when((Object)partition)).truncateTo(0L, true);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.maybeReplaceCurrentWithFutureReplica())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)partition.logDirectoryId()).thenReturn((Object)new Some((Object)Uuid.fromString((String)"gOZOXHnkR9eiA1W9ZuLk8A")));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)None$.MODULE$);
        FullPartitionFetchMetadata fencedRequestData = new FullPartitionFetchMetadata(this.topicId(), 0L, 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), Optional.empty(), -1L);
        FetchPartitionData fencedResponseData = new FetchPartitionData(Errors.FENCED_LEADER_EPOCH, -1L, -1L, (Records)MemoryRecords.EMPTY, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false, new FetchPartitionStats(0L, 0L));
        this.mockFetchFromCurrentLog(this.tid1p0(), (PartitionFetchMetadata)fencedRequestData, config, replicaManager, fencedResponseData);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread", (LeaderEndPoint)leader, this.failedPartitions(), this.pausedPartitions(), exponentialBackoff, replicaManager, quotaManager, new BrokerTopicStats(), DirectoryEventHandler.NOOP);
        thread.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, leaderEpoch - 1))})));
        Assertions.assertTrue((boolean)thread.fetchState(this.t1p0()).isDefined());
        Assertions.assertEquals((int)1, (int)thread.partitionCount());
        thread.doWork();
        Assertions.assertTrue((boolean)this.failedPartitions().contains(this.t1p0()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)thread.fetchState(this.t1p0()));
        Assertions.assertEquals((int)0, (int)thread.partitionCount());
        thread.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, leaderEpoch))})));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)), (Object)thread.fetchState(this.t1p0()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.currentLeaderEpoch())));
        Assertions.assertEquals((int)1, (int)thread.partitionCount());
        FullPartitionFetchMetadata requestData = new FullPartitionFetchMetadata(this.topicId(), 0L, 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), Optional.empty(), -1L);
        FetchPartitionData responseData = new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)MemoryRecords.EMPTY, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false, new FetchPartitionStats(0L, 0L));
        this.mockFetchFromCurrentLog(this.tid1p0(), (PartitionFetchMetadata)requestData, config, replicaManager, responseData);
        thread.doWork();
        Assertions.assertFalse((boolean)this.failedPartitions().contains(this.t1p0()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)thread.fetchState(this.t1p0()));
        Assertions.assertEquals((int)0, (int)thread.partitionCount());
    }

    @Test
    public void shouldReplaceCurrentLogDirWhenCaughtUp() {
        int brokerId = 1;
        int partitionId = 0;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(brokerId, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        AbstractLog futureLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        int leaderEpoch = 5;
        int logEndOffset = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partition.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.onlinePartition(this.t1p0())).thenReturn((Object)new Some((Object)partition));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quotaManager.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)logEndOffset));
        Mockito.when((Object)partition.futureLocalLogOrException()).thenReturn((Object)futureLog);
        ((Partition)Mockito.doNothing().when((Object)partition)).truncateTo(0L, true);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.maybeReplaceCurrentWithFutureReplica())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)partition.logDirectoryId()).thenReturn((Object)new Some((Object)Uuid.fromString((String)"PGLOjDjKQaCOXFOtxymIig")));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)None$.MODULE$);
        FullPartitionFetchMetadata requestData = new FullPartitionFetchMetadata(this.topicId(), 0L, 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), Optional.empty(), -1L);
        FetchPartitionData responseData = new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)MemoryRecords.EMPTY, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false, new FetchPartitionStats(0L, 0L));
        this.mockFetchFromCurrentLog(this.tid1p0(), (PartitionFetchMetadata)requestData, config, replicaManager, responseData);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread", (LeaderEndPoint)leader, this.failedPartitions(), this.pausedPartitions(), exponentialBackoff, replicaManager, quotaManager, new BrokerTopicStats(), DirectoryEventHandler.NOOP);
        thread.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, leaderEpoch))})));
        Assertions.assertTrue((boolean)thread.fetchState(this.t1p0()).isDefined());
        Assertions.assertEquals((int)1, (int)thread.partitionCount());
        thread.doWork();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)thread.fetchState(this.t1p0()));
        Assertions.assertEquals((int)0, (int)thread.partitionCount());
    }

    private Option<BoxedUnit> updateReassignmentState(ReplicaAlterLogDirsThread thread, int partitionId, ReplicaAlterLogDirsThread.ReassignmentState newState) {
        return this.topicNames().get((Object)this.topicId()).map((Function1 & Serializable)topicName -> {
            thread.updateReassignmentState(new TopicPartition(topicName, partitionId), newState);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void shouldReplaceCurrentLogDirWhenCaughtUpWithAfterAssignmentRequestHasBeenCompleted() {
        int brokerId = 1;
        int partitionId = 0;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(brokerId, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        DirectoryEventHandler directoryEventHandler = (DirectoryEventHandler)Mockito.mock(DirectoryEventHandler.class);
        AbstractLog futureLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        int leaderEpoch = 5;
        int logEndOffset = 0;
        Uuid currentDirectoryId = Uuid.fromString((String)"EzI9SqkFQKW1iFc1ZwP9SQ");
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partition.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)partition.topicId()).thenReturn((Object)new Some((Object)this.topicId()));
        Mockito.when((Object)partition.futureReplicaDirectoryId()).thenReturn((Object)new Some((Object)Uuid.randomUuid()));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.onlinePartition(this.t1p0())).thenReturn((Object)new Some((Object)partition));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quotaManager.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)logEndOffset));
        Mockito.when((Object)partition.futureLocalLogOrException()).thenReturn((Object)futureLog);
        ((Partition)Mockito.doNothing().when((Object)partition)).truncateTo(0L, true);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.maybeReplaceCurrentWithFutureReplica())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.runCallbackIfFutureReplicaCaughtUp((Function1)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)partition.logDirectoryId()).thenReturn((Object)new Some((Object)currentDirectoryId));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)None$.MODULE$);
        FullPartitionFetchMetadata requestData = new FullPartitionFetchMetadata(this.topicId(), 0L, 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), Optional.empty(), -1L);
        FetchPartitionData responseData = new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)MemoryRecords.EMPTY, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false, new FetchPartitionStats(0L, 0L));
        this.mockFetchFromCurrentLog(this.tid1p0(), (PartitionFetchMetadata)requestData, config, replicaManager, responseData);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread", (LeaderEndPoint)leader, this.failedPartitions(), this.pausedPartitions(), exponentialBackoff, replicaManager, quotaManager, new BrokerTopicStats(), directoryEventHandler);
        thread.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, leaderEpoch))})));
        Assertions.assertTrue((boolean)thread.fetchState(this.t1p0()).isDefined());
        Assertions.assertEquals((int)1, (int)thread.partitionCount());
        thread.doWork();
        Assertions.assertTrue((boolean)thread.fetchState(this.t1p0()).isDefined());
        Assertions.assertEquals((int)1, (int)thread.partitionCount());
        this.updateReassignmentState(thread, partitionId, (ReplicaAlterLogDirsThread.ReassignmentState)ReplicaAlterLogDirsThread.ReassignmentState$.Queued$.MODULE$);
        thread.doWork();
        Assertions.assertTrue((boolean)thread.fetchState(this.t1p0()).isDefined());
        Assertions.assertEquals((int)1, (int)thread.partitionCount());
        this.updateReassignmentState(thread, partitionId, (ReplicaAlterLogDirsThread.ReassignmentState)ReplicaAlterLogDirsThread.ReassignmentState$.Accepted$.MODULE$);
        thread.doWork();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)thread.fetchState(this.t1p0()));
        Assertions.assertEquals((int)0, (int)thread.partitionCount());
        Mockito.verifyNoInteractions((Object[])new Object[]{directoryEventHandler});
    }

    @Test
    public void shouldRevertAnyScheduledAssignmentRequestIfAssignmentIsCancelled() {
        int brokerId = 1;
        int partitionId = 0;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(brokerId, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        DirectoryEventHandler directoryEventHandler = (DirectoryEventHandler)Mockito.mock(DirectoryEventHandler.class);
        AbstractLog futureLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        int leaderEpoch = 5;
        int logEndOffset = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partition.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)partition.topicId()).thenReturn((Object)new Some((Object)this.topicId()));
        Mockito.when((Object)partition.futureReplicaDirectoryId()).thenReturn((Object)new Some((Object)Uuid.randomUuid()));
        Mockito.when((Object)partition.logDirectoryId()).thenReturn((Object)new Some((Object)Uuid.randomUuid()));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.onlinePartition(this.t1p0())).thenReturn((Object)new Some((Object)partition));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quotaManager.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)logEndOffset));
        Mockito.when((Object)partition.futureLocalLogOrException()).thenReturn((Object)futureLog);
        ((Partition)Mockito.doNothing().when((Object)partition)).truncateTo(0L, true);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.maybeReplaceCurrentWithFutureReplica())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.runCallbackIfFutureReplicaCaughtUp((Function1)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)None$.MODULE$);
        FullPartitionFetchMetadata requestData = new FullPartitionFetchMetadata(this.topicId(), 0L, 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), Optional.empty(), -1L);
        FetchPartitionData responseData = new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)MemoryRecords.EMPTY, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false, new FetchPartitionStats(0L, 0L));
        this.mockFetchFromCurrentLog(this.tid1p0(), (PartitionFetchMetadata)requestData, config, replicaManager, responseData);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread", (LeaderEndPoint)leader, this.failedPartitions(), this.pausedPartitions(), exponentialBackoff, replicaManager, quotaManager, new BrokerTopicStats(), directoryEventHandler);
        thread.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, leaderEpoch))})));
        Assertions.assertTrue((boolean)thread.fetchState(this.t1p0()).isDefined());
        Assertions.assertEquals((int)1, (int)thread.partitionCount());
        thread.doWork();
        Assertions.assertTrue((boolean)thread.fetchState(this.t1p0()).isDefined());
        Assertions.assertEquals((int)1, (int)thread.partitionCount());
        this.updateReassignmentState(thread, partitionId, (ReplicaAlterLogDirsThread.ReassignmentState)ReplicaAlterLogDirsThread.ReassignmentState$.Queued$.MODULE$);
        thread.removePartitions((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.t1p0()})));
        Assertions.assertTrue((boolean)thread.fetchState(this.t1p0()).isEmpty());
        Assertions.assertEquals((int)0, (int)thread.partitionCount());
        ArgumentCaptor topicIdPartitionCaptureT1p0 = ArgumentCaptor.forClass(org.apache.kafka.server.common.TopicIdPartition.class);
        ArgumentCaptor logIdCaptureT1p0 = ArgumentCaptor.forClass(Uuid.class);
        ((DirectoryEventHandler)Mockito.verify((Object)directoryEventHandler)).handleAssignment((org.apache.kafka.server.common.TopicIdPartition)topicIdPartitionCaptureT1p0.capture(), (Uuid)logIdCaptureT1p0.capture(), (String)ArgumentMatchers.eq((Object)"Reverting reassignment for canceled future replica"), (Runnable)ArgumentMatchers.any());
        Assertions.assertEquals((Object)new org.apache.kafka.server.common.TopicIdPartition(this.topicId(), this.t1p0().partition()), (Object)topicIdPartitionCaptureT1p0.getValue());
        Assertions.assertEquals((Object)partition.logDirectoryId().get(), (Object)logIdCaptureT1p0.getValue());
    }

    @Test
    public void shouldRevertReassignmentsForIncompleteFutureReplicaPromotions() {
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        DirectoryEventHandler directoryEventHandler = (DirectoryEventHandler)Mockito.mock(DirectoryEventHandler.class);
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread", (LeaderEndPoint)leader, this.failedPartitions(), this.pausedPartitions(), exponentialBackoff, replicaManager, quotaManager, (BrokerTopicStats)Mockito.mock(BrokerTopicStats.class), directoryEventHandler);
        Seq tp2 = (Seq)((IterableOps)Seq$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)4), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1 & Serializable)x$2 -> ReplicaAlterLogDirsThreadTest.$anonfun$shouldRevertReassignmentsForIncompleteFutureReplicaPromotions$1(BoxesRunTime.unboxToInt((Object)x$2)));
        Seq tips = (Seq)((IterableOps)Seq$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)4), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1 & Serializable)x$3 -> ReplicaAlterLogDirsThreadTest.$anonfun$shouldRevertReassignmentsForIncompleteFutureReplicaPromotions$2(this, BoxesRunTime.unboxToInt((Object)x$3)));
        Seq dirIds = (Seq)((IterableOps)Seq$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)4), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1 & Serializable)i -> ReplicaAlterLogDirsThreadTest.$anonfun$shouldRevertReassignmentsForIncompleteFutureReplicaPromotions$3(BoxesRunTime.unboxToInt((Object)i)));
        tp2.foreach((Function1 & Serializable)tp -> thread.promotionStates().put(tp, new ReplicaAlterLogDirsThread.PromotionState((ReplicaAlterLogDirsThread.ReassignmentState)ReplicaAlterLogDirsThread.ReassignmentState$.None$.MODULE$, (Option)new Some((Object)this.topicId()), (Option)new Some(dirIds.apply(tp.partition())))));
        thread.updateReassignmentState((TopicPartition)tp2.apply(0), (ReplicaAlterLogDirsThread.ReassignmentState)ReplicaAlterLogDirsThread.ReassignmentState$.None$.MODULE$);
        thread.updateReassignmentState((TopicPartition)tp2.apply(1), (ReplicaAlterLogDirsThread.ReassignmentState)ReplicaAlterLogDirsThread.ReassignmentState$.Queued$.MODULE$);
        thread.updateReassignmentState((TopicPartition)tp2.apply(2), (ReplicaAlterLogDirsThread.ReassignmentState)ReplicaAlterLogDirsThread.ReassignmentState$.Accepted$.MODULE$);
        thread.updateReassignmentState((TopicPartition)tp2.apply(3), (ReplicaAlterLogDirsThread.ReassignmentState)ReplicaAlterLogDirsThread.ReassignmentState$.Effective$.MODULE$);
        thread.removePartitions((Set)tp2.toSet());
        ((DirectoryEventHandler)Mockito.verify((Object)directoryEventHandler)).handleAssignment((org.apache.kafka.server.common.TopicIdPartition)ArgumentMatchers.eq((Object)tips.apply(1)), (Uuid)ArgumentMatchers.eq((Object)dirIds.apply(1)), (String)ArgumentMatchers.eq((Object)"Reverting reassignment for canceled future replica"), (Runnable)ArgumentMatchers.any());
        ((DirectoryEventHandler)Mockito.verify((Object)directoryEventHandler)).handleAssignment((org.apache.kafka.server.common.TopicIdPartition)ArgumentMatchers.eq((Object)tips.apply(2)), (Uuid)ArgumentMatchers.eq((Object)dirIds.apply(2)), (String)ArgumentMatchers.eq((Object)"Reverting reassignment for canceled future replica"), (Runnable)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{directoryEventHandler});
    }

    private void mockFetchFromCurrentLog(TopicIdPartition topicIdPartition, PartitionFetchMetadata requestData, KafkaConfig config, ReplicaManager replicaManager, FetchPartitionData responseData) {
        ArgumentCaptor callbackCaptor = ArgumentCaptor.forClass(Function1.class);
        ArgumentMatcher<Seq<Tuple2<TopicIdPartition, PartitionFetchMetadata>>> argumentMatcher = new ArgumentMatcher<Seq<Tuple2<TopicIdPartition, PartitionFetchMetadata>>>(null, topicIdPartition, requestData){
            private final TopicIdPartition topicIdPartition$1;
            private final PartitionFetchMetadata requestData$1;

            public Class<?> type() {
                return super.type();
            }

            public boolean matches(Seq<Tuple2<TopicIdPartition, PartitionFetchMetadata>> argument) {
                Option option;
                if (argument != null && !(option = package$.MODULE$.$plus$colon().unapply(argument)).isEmpty()) {
                    Tuple2 tuple2 = (Tuple2)((Tuple2)option.get())._1();
                    Seq seq = (Seq)((Tuple2)option.get())._2();
                    if (tuple2 != null) {
                        SeqOps seqOps;
                        TopicIdPartition tp = (TopicIdPartition)tuple2._1();
                        PartitionFetchMetadata partitionData = (PartitionFetchMetadata)tuple2._2();
                        if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = Seq$.MODULE$.unapplySeq((SeqOps)seq))) {
                            new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
                            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0) == 0) {
                                TopicIdPartition topicIdPartition = tp;
                                TopicIdPartition topicIdPartition2 = this.topicIdPartition$1;
                                if (!(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null)) {
                                    Uuid uuid = partitionData.topicId();
                                    Uuid uuid2 = this.requestData$1.topicId();
                                    if (!(uuid != null ? !uuid.equals(uuid2) : uuid2 != null) && partitionData.fetchOffset() == this.requestData$1.fetchOffset()) {
                                        Optional optional = partitionData.currentLeaderEpoch();
                                        Optional optional2 = this.requestData$1.currentLeaderEpoch();
                                        if (!(optional != null ? !((Object)optional).equals(optional2) : optional2 != null)) {
                                            Optional optional3 = partitionData.lastFetchedEpoch();
                                            Optional optional4 = this.requestData$1.lastFetchedEpoch();
                                            if (!(optional3 != null ? !((Object)optional3).equals(optional4) : optional4 != null)) {
                                                if (partitionData.startOffset() == this.requestData$1.startOffset() && partitionData.maxBytes() == this.requestData$1.maxBytes()) {
                                                    return true;
                                                }
                                            }
                                        }
                                    }
                                }
                                return false;
                            }
                        }
                    }
                }
                return false;
            }
            {
                this.topicIdPartition$1 = topicIdPartition$1;
                this.requestData$1 = requestData$1;
            }
        };
        FetchParams expectedFetchParams = new FetchParams(ApiKeys.FETCH.latestVersion(), -3, -1L, 0L, 0, Predef$.MODULE$.Integer2int(config.replicaFetchResponseMaxBytes()), FetchIsolation.LOG_END, Optional.empty());
        replicaManager.fetchMessages((FetchParams)ArgumentMatchers.eq((Object)expectedFetchParams), (Seq)ArgumentMatchers.argThat((ArgumentMatcher)argumentMatcher), (ReplicaQuota)ArgumentMatchers.eq((Object)QuotaFactory.UnboundedQuota$.MODULE$), (Function1)callbackCaptor.capture(), ArgumentMatchers.eq((boolean)false));
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$4 -> {
            ReplicaAlterLogDirsThreadTest.$anonfun$mockFetchFromCurrentLog$1(callbackCaptor, topicIdPartition, responseData, x$4);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void issuesEpochRequestFromLocalReplica() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        Partition partitionT1p0 = (Partition)Mockito.mock(Partition.class);
        Partition partitionT1p1 = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int partitionT1p0Id = 0;
        int partitionT1p1Id = 1;
        int leaderEpochT1p0 = 2;
        int leaderEpochT1p1 = 5;
        int leoT1p0 = 13;
        int leoT1p1 = 232;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partitionT1p0.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionT1p0Id));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partitionT1p0.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionT1p1Id));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partitionT1p0);
        Mockito.when((Object)partitionT1p0.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpochT1p0, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionT1p0Id).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpochT1p0).setEndOffset((long)leoT1p0));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p1())).thenReturn((Object)partitionT1p1);
        Mockito.when((Object)partitionT1p1.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpochT1p1, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionT1p1Id).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpochT1p1).setEndOffset((long)leoT1p1));
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, null);
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        Map result = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, this.failedPartitions(), this.pausedPartitions(), exponentialBackoff, replicaManager, null, null, DirectoryEventHandler.NOOP).leader().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.t1p0().partition()).setLeaderEpoch(leaderEpochT1p0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.t1p1().partition()).setLeaderEpoch(leaderEpochT1p1))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.t1p0().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpochT1p0).setEndOffset((long)leoT1p0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.t1p1().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpochT1p1).setEndOffset((long)leoT1p1))}))), (Object)result, (String)"results from leader epoch request should have offset from local replica");
    }

    @Test
    public void fetchEpochsFromLeaderShouldHandleExceptionFromGetLocalReplica() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        Partition partitionT1p0 = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int partitionId = 0;
        int leaderEpoch = 2;
        int leo = 13;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partitionT1p0.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partitionT1p0);
        Mockito.when((Object)partitionT1p0.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)leo));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p1())).thenThrow(new Throwable[]{new KafkaStorageException()});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, null);
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        Map result = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, this.failedPartitions(), this.pausedPartitions(), exponentialBackoff, replicaManager, null, null, DirectoryEventHandler.NOOP).leader().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.t1p0().partition()).setLeaderEpoch(leaderEpoch)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.t1p1().partition()).setLeaderEpoch(leaderEpoch))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.t1p0().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)leo)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.t1p1().partition()).setErrorCode(Errors.KAFKA_STORAGE_ERROR.code()))}))), (Object)result);
    }

    @Test
    public void shouldTruncateToReplicaOffset() {
        ArgumentCaptor truncateCaptureT1p0 = ArgumentCaptor.forClass(Long.TYPE);
        ArgumentCaptor truncateCaptureT1p1 = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        AbstractLog logT1p0 = (AbstractLog)Mockito.mock(AbstractLog.class);
        AbstractLog logT1p1 = (AbstractLog)Mockito.mock(AbstractLog.class);
        AbstractLog futureLogT1p0 = (AbstractLog)Mockito.mock(AbstractLog.class);
        AbstractLog futureLogT1p1 = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partitionT1p0 = (Partition)Mockito.mock(Partition.class);
        Partition partitionT1p1 = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ArgumentCaptor responseCallback = ArgumentCaptor.forClass(Function1.class);
        int partitionT1p0Id = 0;
        int partitionT1p1Id = 1;
        int leaderEpoch = 2;
        int futureReplicaLEO = 191;
        int replicaT1p0LEO = 190;
        int replicaT1p1LEO = 192;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partitionT1p0.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionT1p0Id));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partitionT1p1.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionT1p1Id));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partitionT1p0);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p1())).thenReturn((Object)partitionT1p1);
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLogT1p0);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p1())).thenReturn((Object)futureLogT1p1);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p1()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLogT1p0.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(futureReplicaLEO)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLogT1p1.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(futureReplicaLEO)));
        Mockito.when((Object)futureLogT1p0.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)futureLogT1p0.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch)));
        Mockito.when((Object)partitionT1p0.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionT1p0Id).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)replicaT1p0LEO));
        Mockito.when((Object)futureLogT1p1.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)futureLogT1p1.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch)));
        Mockito.when((Object)partitionT1p1.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionT1p1Id).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)replicaT1p1LEO));
        Mockito.when((Object)partitionT1p0.logDirectoryId()).thenReturn((Object)new Some((Object)Uuid.fromString((String)"Jsg8ufNCQYONNquPt7VYpA")));
        Mockito.when((Object)partitionT1p1.logDirectoryId()).thenReturn((Object)new Some((Object)Uuid.fromString((String)"D2Yf6FtNROGVKoIZadSFIg")));
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        this.stubWithFetchMessages(logT1p0, logT1p1, futureLogT1p0, partitionT1p0, replicaManager, (ArgumentCaptor<Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, this.failedPartitions(), this.pausedPartitions(), exponentialBackoff, replicaManager, quotaManager, null, DirectoryEventHandler.NOOP);
        thread.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState(0L, 1))})));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partitionT1p0)).truncateTo(BoxesRunTime.unboxToLong((Object)truncateCaptureT1p0.capture()), ArgumentMatchers.anyBoolean());
        ((Partition)Mockito.verify((Object)partitionT1p1)).truncateTo(BoxesRunTime.unboxToLong((Object)truncateCaptureT1p1.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertEquals((long)replicaT1p0LEO, (long)BoxesRunTime.unboxToLong((Object)truncateCaptureT1p0.getValue()));
        Assertions.assertEquals((long)futureReplicaLEO, (long)BoxesRunTime.unboxToLong((Object)truncateCaptureT1p1.getValue()));
    }

    @Test
    public void shouldTruncateToEndOffsetOfLargestCommonEpoch() {
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        AbstractLog futureLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ArgumentCaptor responseCallback = ArgumentCaptor.forClass(Function1.class);
        int partitionId = 0;
        int leaderEpoch = 5;
        int futureReplicaLEO = 195;
        int replicaLEO = 200;
        int replicaEpochEndOffset = 190;
        int futureReplicaEpochEndOffset = 191;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partition.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(futureReplicaLEO)));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)(leaderEpoch - 2))));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch - 1).setEndOffset((long)replicaLEO));
        Mockito.when((Object)futureLog.endOffsetForEpoch(leaderEpoch - 1)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch - 2)));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch - 2, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch - 2).setEndOffset((long)replicaEpochEndOffset));
        Mockito.when((Object)futureLog.endOffsetForEpoch(leaderEpoch - 2)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaEpochEndOffset, leaderEpoch - 2)));
        Mockito.when((Object)partition.logDirectoryId()).thenReturn((Object)new Some((Object)Uuid.fromString((String)"n6WOe2zPScqZLIreCWN6Ug")));
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        this.stubWithFetchMessages(log, null, futureLog, partition, replicaManager, (ArgumentCaptor<Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, this.failedPartitions(), this.pausedPartitions(), exponentialBackoff, replicaManager, quotaManager, null, DirectoryEventHandler.NOOP);
        thread.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, 1))})));
        thread.doWork();
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.eq((boolean)true));
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)replicaEpochEndOffset)), (String)new StringBuilder(48).append("Expected offset ").append(replicaEpochEndOffset).append(" in captured truncation offsets ").append(truncateToCapture.getAllValues()).toString());
    }

    @Test
    public void shouldTruncateToInitialFetchOffsetIfReplicaReturnsUndefinedOffset() {
        ArgumentCaptor truncated = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        AbstractLog futureLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ArgumentCaptor responseCallback = ArgumentCaptor.forClass(Function1.class);
        int initialFetchOffset = 100;
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)partition.logDirectoryId()).thenReturn((Object)new Some((Object)Uuid.fromString((String)"b2e1ihvGQiu6A504oKoddQ")));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)None$.MODULE$);
        this.stubWithFetchMessages(log, null, futureLog, partition, replicaManager, (ArgumentCaptor<Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, this.failedPartitions(), this.pausedPartitions(), exponentialBackoff, replicaManager, quotaManager, null, DirectoryEventHandler.NOOP);
        thread.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(initialFetchOffset, 1))})));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition)).truncateTo(BoxesRunTime.unboxToLong((Object)truncated.capture()), ArgumentMatchers.eq((boolean)true));
        Assertions.assertEquals((long)initialFetchOffset, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()), (String)"Expected future replica to truncate to initial fetch offset if replica returns UNDEFINED_EPOCH_OFFSET");
    }

    @Test
    public void shouldPollIndefinitelyIfReplicaNotAvailable() {
        ArgumentCaptor truncated = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        AbstractLog futureLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ArgumentCaptor responseCallback = ArgumentCaptor.forClass(Function1.class);
        int partitionId = 0;
        int futureReplicaLeaderEpoch = 1;
        int futureReplicaLEO = 290;
        int replicaLEO = 300;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partition.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)partition.logDirectoryId()).thenReturn((Object)new Some((Object)Uuid.fromString((String)"wO7bUpvcSZC0QKEK6P6AiA")));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(futureReplicaLEO)));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)futureReplicaLeaderEpoch)));
        Mockito.when((Object)futureLog.endOffsetForEpoch(futureReplicaLeaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, futureReplicaLeaderEpoch)));
        Mockito.when((Object)replicaManager.localLog(this.t1p0())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), futureReplicaLeaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.REPLICA_NOT_AVAILABLE.code())).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.REPLICA_NOT_AVAILABLE.code())).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.REPLICA_NOT_AVAILABLE.code())).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(futureReplicaLeaderEpoch).setEndOffset((long)replicaLEO));
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        replicaManager.fetchMessages((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(), (Function1)responseCallback.capture(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$5 -> {
            ReplicaAlterLogDirsThreadTest.$anonfun$shouldPollIndefinitelyIfReplicaNotAvailable$1(responseCallback, x$5);
            return BoxedUnit.UNIT;
        });
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, this.failedPartitions(), this.pausedPartitions(), exponentialBackoff, replicaManager, quotaManager, null, DirectoryEventHandler.NOOP);
        thread.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, 1))})));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> thread.doWork());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.never())).truncateTo(BoxesRunTime.unboxToLong((Object)truncated.capture()), ArgumentMatchers.eq((boolean)true));
        Assertions.assertEquals((int)0, (int)truncated.getAllValues().size());
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition)).truncateTo(BoxesRunTime.unboxToLong((Object)truncated.capture()), ArgumentMatchers.eq((boolean)true));
        Assertions.assertEquals((long)futureReplicaLEO, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()));
    }

    @Test
    public void shouldFetchLeaderEpochOnFirstFetchOnly() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        AbstractLog futureLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ArgumentCaptor responseCallback = ArgumentCaptor.forClass(Function1.class);
        int partitionId = 0;
        int leaderEpoch = 5;
        int futureReplicaLEO = 190;
        int replicaLEO = 213;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partition.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)partition.logDirectoryId()).thenReturn((Object)new Some((Object)Uuid.fromString((String)"dybMM9CpRP2s6HSslW4NHg")));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)replicaLEO));
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(futureReplicaLEO)));
        Mockito.when((Object)futureLog.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch)));
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        this.stubWithFetchMessages(log, null, futureLog, partition, replicaManager, (ArgumentCaptor<Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, this.failedPartitions(), this.pausedPartitions(), exponentialBackoff, replicaManager, quotaManager, null, DirectoryEventHandler.NOOP);
        thread.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, 1))})));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$7 -> thread.doWork());
        ((Partition)Mockito.verify((Object)partition)).lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false);
        ((Partition)Mockito.verify((Object)partition)).truncateTo(Int$.MODULE$.int2long(futureReplicaLEO), true);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldFetchOneReplicaAtATime() {
        void var15_15;
        void var14_14;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        AbstractLog futureLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p1())).thenReturn((Object)partition);
        Mockito.when((Object)partition.logDirectoryId()).thenReturn((Object)new Some((Object)Uuid.fromString((String)"Y0qUL19gSmKAXmohmrUM4g")));
        this.stub(log, null, futureLog, partition, replicaManager);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        int leaderEpoch = 1;
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, this.failedPartitions(), this.pausedPartitions(), exponentialBackoff, replicaManager, quotaManager, null, DirectoryEventHandler.NOOP);
        thread.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, leaderEpoch)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState(0L, leaderEpoch))})));
        Object[] objectArray = new Tuple2[2];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId()), 150L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, 0));
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId()), 160L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, 0));
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions = thread.leader().buildFetch((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        if (resultWithPartitions == null) {
            throw new MatchError(null);
        }
        Option fetchRequestOpt = (Option)resultWithPartitions.result();
        Map partitionsWithError = resultWithPartitions.partitionsWithError();
        Assertions.assertTrue((boolean)var14_14.isDefined());
        FetchRequest.Builder fetchRequest = ((AbstractFetcherThread.ReplicaFetch)var14_14.get()).fetchRequest();
        Assertions.assertFalse((boolean)fetchRequest.fetchData().isEmpty());
        Assertions.assertFalse((boolean)var15_15.nonEmpty());
        FetchRequest request = (FetchRequest)fetchRequest.build();
        Assertions.assertEquals((int)0, (int)request.minBytes());
        scala.collection.immutable.Seq fetchInfos = CollectionConverters$.MODULE$.MapHasAsScala(request.fetchData(CollectionConverters$.MODULE$.MapHasAsJava(this.topicNames()).asJava())).asScala().toSeq();
        Assertions.assertEquals((int)1, (int)fetchInfos.length());
        Assertions.assertEquals((Object)this.t1p0(), (Object)((TopicIdPartition)((Tuple2)fetchInfos.head())._1()).topicPartition(), (String)"Expected fetch request for first partition");
        Assertions.assertEquals((long)150L, (long)((FetchRequest.PartitionData)((Tuple2)fetchInfos.head())._2()).fetchOffset);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldFetchNonDelayedAndNonTruncatingReplicas() {
        void var26_47;
        void var25_46;
        void var21_42;
        void var20_41;
        void apply_failedAttempts;
        void apply_replicationSessionId;
        void apply_lastFetchedEpoch;
        void apply_state;
        void apply_lag;
        void apply_offset;
        void var16_30;
        void var15_29;
        void apply_failedAttempts2;
        void apply_replicationSessionId2;
        void apply_lastFetchedEpoch2;
        void apply_state2;
        void apply_lag2;
        void apply_offset2;
        void apply_failedAttempts3;
        void apply_replicationSessionId3;
        void apply_lastFetchedEpoch3;
        void apply_state3;
        void apply_lag3;
        void apply_offset3;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        AbstractLog futureLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int startOffset = 123;
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(startOffset)));
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p1())).thenReturn((Object)partition);
        Mockito.when((Object)partition.logDirectoryId()).thenReturn((Object)new Some((Object)Uuid.fromString((String)"rtrdy3nsQwO1OQUEUYGxRQ")));
        this.stub(log, null, futureLog, partition, replicaManager);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        int leaderEpoch = 1;
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, this.failedPartitions(), this.pausedPartitions(), exponentialBackoff, replicaManager, quotaManager, null, DirectoryEventHandler.NOOP);
        thread.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, leaderEpoch)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState(0L, leaderEpoch))})));
        Object[] objectArray = new Tuple2[2];
        boolean bl = false;
        None$ none$ = None$.MODULE$;
        None$ none$2 = None$.MODULE$;
        Fetching$ fetching$ = Fetching$.MODULE$;
        None$ none$3 = None$.MODULE$;
        long l = 150L;
        Some apply_topicId = new Some((Object)this.topicId());
        Object var27_20 = null;
        none$3 = null;
        fetching$ = null;
        none$2 = null;
        none$ = null;
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new PartitionFetchState((Option)apply_topicId, (long)apply_offset3, (Option)apply_lag3, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state3, (Option)apply_lastFetchedEpoch3, (Option)apply_replicationSessionId3, (int)apply_failedAttempts3));
        boolean bl2 = false;
        None$ none$4 = None$.MODULE$;
        None$ none$5 = None$.MODULE$;
        Truncating$ truncating$ = Truncating$.MODULE$;
        None$ none$6 = None$.MODULE$;
        long l2 = 160L;
        Some apply_topicId2 = new Some((Object)this.topicId());
        Object var35_27 = null;
        none$6 = null;
        truncating$ = null;
        none$5 = null;
        none$4 = null;
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState((Option)apply_topicId2, (long)apply_offset2, (Option)apply_lag2, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state2, (Option)apply_lastFetchedEpoch2, (Option)apply_replicationSessionId2, (int)apply_failedAttempts2));
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions = thread.leader().buildFetch((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        if (resultWithPartitions == null) {
            throw new MatchError(null);
        }
        Option fetchRequestOpt = (Option)resultWithPartitions.result();
        Map partitionsWithError = resultWithPartitions.partitionsWithError();
        Assertions.assertTrue((boolean)var15_29.isDefined());
        AbstractFetcherThread.ReplicaFetch fetchRequest = (AbstractFetcherThread.ReplicaFetch)var15_29.get();
        Assertions.assertFalse((boolean)fetchRequest.partitionData().isEmpty());
        Assertions.assertFalse((boolean)var16_30.nonEmpty());
        scala.collection.immutable.Seq fetchInfos = CollectionConverters$.MODULE$.MapHasAsScala(((FetchRequest)fetchRequest.fetchRequest().build()).fetchData(CollectionConverters$.MODULE$.MapHasAsJava(this.topicNames()).asJava())).asScala().toSeq();
        Assertions.assertEquals((int)1, (int)fetchInfos.length());
        Assertions.assertEquals((Object)this.t1p0(), (Object)((TopicIdPartition)((Tuple2)fetchInfos.head())._1()).topicPartition(), (String)"Expected fetch request for non-truncating partition");
        Assertions.assertEquals((long)150L, (long)((FetchRequest.PartitionData)((Tuple2)fetchInfos.head())._2()).fetchOffset);
        Object[] objectArray2 = new Tuple2[2];
        boolean bl3 = false;
        None$ none$7 = None$.MODULE$;
        None$ none$8 = None$.MODULE$;
        Fetching$ fetching$2 = Fetching$.MODULE$;
        None$ none$9 = None$.MODULE$;
        long l3 = 140L;
        Some apply_topicId3 = new Some((Object)this.topicId());
        Object var43_39 = null;
        none$9 = null;
        fetching$2 = null;
        none$8 = null;
        none$7 = null;
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new PartitionFetchState((Option)apply_topicId3, (long)apply_offset, (Option)apply_lag, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state, (Option)apply_lastFetchedEpoch, (Option)apply_replicationSessionId, (int)apply_failedAttempts));
        objectArray2[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId()), 160L, (Option)None$.MODULE$, leaderEpoch, (Option)new Some((Object)new DelayedItem(5000L)), (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, 0));
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions2 = thread.leader().buildFetch((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)));
        if (resultWithPartitions2 == null) {
            throw new MatchError(null);
        }
        Option fetchRequest2Opt = (Option)resultWithPartitions2.result();
        Map partitionsWithError2 = resultWithPartitions2.partitionsWithError();
        Assertions.assertTrue((boolean)var20_41.isDefined());
        AbstractFetcherThread.ReplicaFetch fetchRequest2 = (AbstractFetcherThread.ReplicaFetch)var20_41.get();
        Assertions.assertFalse((boolean)fetchRequest2.partitionData().isEmpty());
        Assertions.assertFalse((boolean)var21_42.nonEmpty());
        scala.collection.immutable.Seq fetchInfos2 = CollectionConverters$.MODULE$.MapHasAsScala(((FetchRequest)fetchRequest2.fetchRequest().build()).fetchData(CollectionConverters$.MODULE$.MapHasAsJava(this.topicNames()).asJava())).asScala().toSeq();
        Assertions.assertEquals((int)1, (int)fetchInfos2.length());
        Assertions.assertEquals((Object)this.t1p0(), (Object)((TopicIdPartition)((Tuple2)fetchInfos2.head())._1()).topicPartition(), (String)"Expected fetch request for non-delayed partition");
        Assertions.assertEquals((long)140L, (long)((FetchRequest.PartitionData)((Tuple2)fetchInfos2.head())._2()).fetchOffset);
        Object[] objectArray3 = new Tuple2[2];
        objectArray3[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId()), 140L, (Option)None$.MODULE$, leaderEpoch, (Option)new Some((Object)new DelayedItem(5000L)), (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, 0));
        objectArray3[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId()), 160L, (Option)None$.MODULE$, leaderEpoch, (Option)new Some((Object)new DelayedItem(5000L)), (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, 0));
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions3 = thread.leader().buildFetch((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray3)));
        if (resultWithPartitions3 == null) {
            throw new MatchError(null);
        }
        Option fetchRequest3Opt = (Option)resultWithPartitions3.result();
        Map partitionsWithError3 = resultWithPartitions3.partitionsWithError();
        Assertions.assertTrue((boolean)var25_46.isEmpty(), (String)"Expected no fetch requests since all partitions are delayed");
        Assertions.assertFalse((boolean)var26_47.nonEmpty());
    }

    public void stub(AbstractLog logT1p0, AbstractLog logT1p1, AbstractLog futureLog, Partition partition, ReplicaManager replicaManager) {
        Mockito.when((Object)replicaManager.localLog(this.t1p0())).thenReturn((Object)new Some((Object)logT1p0));
        Mockito.when((Object)replicaManager.localLogOrException(this.t1p0())).thenReturn((Object)logT1p0);
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.onlinePartition(this.t1p0())).thenReturn((Object)new Some((Object)partition));
        Mockito.when((Object)replicaManager.localLog(this.t1p1())).thenReturn((Object)new Some((Object)logT1p1));
        Mockito.when((Object)replicaManager.localLogOrException(this.t1p1())).thenReturn((Object)logT1p1);
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p1())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p1()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.onlinePartition(this.t1p1())).thenReturn((Object)new Some((Object)partition));
    }

    public void stubWithFetchMessages(AbstractLog logT1p0, AbstractLog logT1p1, AbstractLog futureLog, Partition partition, ReplicaManager replicaManager, ArgumentCaptor<Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit>> responseCallback) {
        this.stub(logT1p0, logT1p1, futureLog, partition, replicaManager);
        replicaManager.fetchMessages((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(), (Function1)responseCallback.capture(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$12 -> {
            ReplicaAlterLogDirsThreadTest.$anonfun$stubWithFetchMessages$1(responseCallback, x$12);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ TopicPartition $anonfun$shouldRevertReassignmentsForIncompleteFutureReplicaPromotions$1(int x$2) {
        return new TopicPartition("t", x$2);
    }

    public static final /* synthetic */ org.apache.kafka.server.common.TopicIdPartition $anonfun$shouldRevertReassignmentsForIncompleteFutureReplicaPromotions$2(ReplicaAlterLogDirsThreadTest $this, int x$3) {
        return new org.apache.kafka.server.common.TopicIdPartition($this.topicId(), x$3);
    }

    public static final /* synthetic */ Uuid $anonfun$shouldRevertReassignmentsForIncompleteFutureReplicaPromotions$3(int i) {
        return Uuid.fromString((String)new StringBuilder(21).append("TESTBROKER0000DIR").append(i).append("AAAA").toString());
    }

    public static final /* synthetic */ void $anonfun$mockFetchFromCurrentLog$1(ArgumentCaptor callbackCaptor$1, TopicIdPartition topicIdPartition$1, FetchPartitionData responseData$1, InvocationOnMock x$4) {
        ((Function1)callbackCaptor$1.getValue()).apply((Object)new .colon.colon((Object)new Tuple2((Object)topicIdPartition$1, (Object)responseData$1), (List)Nil$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$shouldPollIndefinitelyIfReplicaNotAvailable$1(ArgumentCaptor responseCallback$1, InvocationOnMock x$5) {
        ((Function1)responseCallback$1.getValue()).apply((Object)Seq$.MODULE$.empty());
    }

    public static final /* synthetic */ void $anonfun$stubWithFetchMessages$1(ArgumentCaptor responseCallback$2, InvocationOnMock x$12) {
        ((Function1)responseCallback$2.getValue()).apply((Object)Seq$.MODULE$.empty());
    }

    public ReplicaAlterLogDirsThreadTest() {
        this.metadataCache().updateMetadata(0, this.updateMetadataRequest());
    }
}

