/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import kafka.log.LogManager;
import kafka.server.BrokerConfigHandler;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.server.QuotaType;
import kafka.server.ReplicationQuotaManager;
import kafka.server.ReplicationQuotasTest$ReplicationResults$;
import kafka.server.ReplicationQuotasTest$ReplicationTestSettings$;
import kafka.server.ZkConfigManager;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@Tag(value="bazel:shard_count:2")
@ScalaSignature(bytes="\u0006\u0005\r5g\u0001\u00020`\u0001\u0011DQ!\u001b\u0001\u0005\u0002)DQ\u0001\u001c\u0001\u0005\u00025Dqa\u001f\u0001C\u0002\u0013\u0005A\u0010C\u0004\u0002\b\u0001\u0001\u000b\u0011B?\t\u0013\u0005%\u0001\u00011A\u0005\u0002\u0005-\u0001\"CA\u0016\u0001\u0001\u0007I\u0011AA\u0017\u0011!\tI\u0004\u0001Q!\n\u00055\u0001\"CA\u001e\u0001\t\u0007I\u0011AA\u001f\u0011!\ty\u0005\u0001Q\u0001\n\u0005}\u0002bCA)\u0001\u0001\u0007\t\u0019!C\u0001\u0003'B1\"!\u001c\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002p!Y\u00111\u000f\u0001A\u0002\u0003\u0005\u000b\u0015BA+\u0011\u001d\t)\b\u0001C!\u0003oBq!a$\u0001\t\u0003\t9\bC\u0004\u0002\u001a\u0002!\t!a\u001e\t\u000f\u0005u\u0005\u0001\"\u0001\u0002x!9\u0011\u0011\u0015\u0001\u0005\u0002\u0005]\u0004bBAS\u0001\u0011\u0005\u0011q\u0015\u0005\b\u0005#\u0003A\u0011\u0001BJ\u0011\u001d\u0011I\n\u0001C\u0001\u00057CqAa(\u0001\t\u0003\t9\bC\u0004\u0003$\u0002!\t!a\u001e\t\u000f\t\u001d\u0006\u0001\"\u0001\u0002x!9!1\u0016\u0001\u0005\u0002\t5\u0006b\u0002BZ\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0005o\u0003A\u0011AA<\u0011\u001d\u0011Y\f\u0001C\u0001\u0005{CqA!1\u0001\t\u0003\u0011\u0019\rC\u0004\u0003V\u0002!\tAa6\t\u000f\tu\u0007\u0001\"\u0003\u0003`\"9!1\u001e\u0001\u0005\n\t5hA\u0002B3\u0001\u0001\u00139\u0007\u0003\u0006\u0003j\u0001\u0012)\u001a!C\u0001\u0003\u001fD\u0011Ba\u001b!\u0005#\u0005\u000b\u0011\u00028\t\u0015\t5\u0004E!f\u0001\n\u0003\ty\rC\u0005\u0003p\u0001\u0012\t\u0012)A\u0005]\"1\u0011\u000e\tC\u0001\u0005cB\u0011\"a=!\u0003\u0003%\tAa\u001e\t\u0013\u0005}\b%%A\u0005\u0002\t\u0005\u0001\"\u0003B\fAE\u0005I\u0011\u0001B\u0001\u0011%\u0011I\u0003IA\u0001\n\u0003\ni\u0004C\u0005\u0003,\u0001\n\t\u0011\"\u0001\u0002V\"I!Q\u0006\u0011\u0002\u0002\u0013\u0005!Q\u0010\u0005\n\u0005s\u0001\u0013\u0011!C!\u0005wA\u0011B!\u0013!\u0003\u0003%\tA!!\t\u0013\t=\u0003%!A\u0005B\t\u0015\u0005\"\u0003B+A\u0005\u0005I\u0011\tB,\u0011%\u0011I\u0006IA\u0001\n\u0003\u0012Y\u0006C\u0005\u0003^\u0001\n\t\u0011\"\u0011\u0003\n\u001eI!1\u001f\u0001\u0002\u0002#\u0005!Q\u001f\u0004\n\u0005K\u0002\u0011\u0011!E\u0001\u0005oDa![\u001a\u0005\u0002\r=\u0001\"\u0003B-g\u0005\u0005IQ\tB.\u0011%\u0019\tbMA\u0001\n\u0003\u001b\u0019\u0002C\u0005\u0004\u001aM\n\t\u0011\"!\u0004\u001c\u00191\u0011q\u0017\u0001A\u0003sC!\"!49\u0005+\u0007I\u0011AAh\u0011%\t\t\u000e\u000fB\tB\u0003%a\u000e\u0003\u0006\u0002Tb\u0012)\u001a!C\u0001\u0003+D\u0011\"a69\u0005#\u0005\u000b\u0011\u0002<\t\u0013\u0005e\u0007H!f\u0001\n\u0003a\b\"CAnq\tE\t\u0015!\u0003~\u0011)\ti\u000e\u000fBK\u0002\u0013\u0005\u0011q\u001c\u0005\u000b\u0003OD$\u0011#Q\u0001\n\u0005\u0005\bBB59\t\u0003\tI\u000fC\u0005\u0002tb\n\t\u0011\"\u0001\u0002v\"I\u0011q \u001d\u0012\u0002\u0013\u0005!\u0011\u0001\u0005\n\u0005/A\u0014\u0013!C\u0001\u00053A\u0011B!\b9#\u0003%\tAa\b\t\u0013\t\r\u0002(%A\u0005\u0002\t\u0015\u0002\"\u0003B\u0015q\u0005\u0005I\u0011IA\u001f\u0011%\u0011Y\u0003OA\u0001\n\u0003\t)\u000eC\u0005\u0003.a\n\t\u0011\"\u0001\u00030!I!\u0011\b\u001d\u0002\u0002\u0013\u0005#1\b\u0005\n\u0005\u0013B\u0014\u0011!C\u0001\u0005\u0017B\u0011Ba\u00149\u0003\u0003%\tE!\u0015\t\u0013\tU\u0003(!A\u0005B\t]\u0003\"\u0003B-q\u0005\u0005I\u0011\tB.\u0011%\u0011i\u0006OA\u0001\n\u0003\u0012yfB\u0005\u0004*\u0001\t\t\u0011#\u0001\u0004,\u0019I\u0011q\u0017\u0001\u0002\u0002#\u00051Q\u0006\u0005\u0007SF#\ta!\u000e\t\u0013\te\u0013+!A\u0005F\tm\u0003\"CB\t#\u0006\u0005I\u0011QB\u001c\u0011%\u0019I\"UA\u0001\n\u0003\u001b\t\u0005C\u0004\u0004N\u0001!\taa\u0014\t\u000f\r\u0005\u0004\u0001\"\u0001\u0004d!I1q\u000f\u0001\u0012\u0002\u0013\u0005!Q\u0005\u0005\n\u0007s\u0002\u0011\u0013!C\u0001\u0005KAqaa\u001f\u0001\t\u0003\u0019i\bC\u0004\u0004\u0012\u0002!Iaa%\t\u000f\r\u001d\u0006\u0001\"\u0003\u0004*\"911\u0017\u0001\u0005\u0002\rU&!\u0006*fa2L7-\u0019;j_:\fVo\u001c;bgR+7\u000f\u001e\u0006\u0003A\u0006\faa]3sm\u0016\u0014(\"\u00012\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u001a\t\u0003M\u001el\u0011aX\u0005\u0003Q~\u0013\u0011#U;peVlG+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\t1\u000e\u0005\u0002g\u0001\u0005a\u0001/\u001a:dK:$XI\u001d:peR\u0019a\u000e^=\u0011\u0005=\u0014X\"\u00019\u000b\u0003E\fQa]2bY\u0006L!a\u001d9\u0003\t1{gn\u001a\u0005\u0006k\n\u0001\rA^\u0001\ba\u0016\u00148-\u001a8u!\tyw/\u0003\u0002ya\n\u0019\u0011J\u001c;\t\u000bi\u0014\u0001\u0019\u00018\u0002\u000bY\fG.^3\u0002\u00115\u001cx-\r\u00191\u0017\n+\u0012! \t\u0005_z\f\t!\u0003\u0002\u0000a\n)\u0011I\u001d:bsB\u0019q.a\u0001\n\u0007\u0005\u0015\u0001O\u0001\u0003CsR,\u0017!C7tOF\u0002\u0004g\u0013\"!\u0003\u001d\u0011'o\\6feN,\"!!\u0004\u0011\r\u0005=\u0011qDA\u0013\u001d\u0011\t\t\"a\u0007\u000f\t\u0005M\u0011\u0011D\u0007\u0003\u0003+Q1!a\u0006d\u0003\u0019a$o\\8u}%\t\u0011/C\u0002\u0002\u001eA\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002\"\u0005\r\"aA*fc*\u0019\u0011Q\u00049\u0011\u0007\u0019\f9#C\u0002\u0002*}\u00131bS1gW\u0006\u001cVM\u001d<fe\u0006Y!M]8lKJ\u001cx\fJ3r)\u0011\ty#!\u000e\u0011\u0007=\f\t$C\u0002\u00024A\u0014A!\u00168ji\"I\u0011q\u0007\u0004\u0002\u0002\u0003\u0007\u0011QB\u0001\u0004q\u0012\n\u0014\u0001\u00032s_.,'o\u001d\u0011\u0002\u000bQ|\u0007/[2\u0016\u0005\u0005}\u0002\u0003BA!\u0003\u0017j!!a\u0011\u000b\t\u0005\u0015\u0013qI\u0001\u0005Y\u0006twM\u0003\u0002\u0002J\u0005!!.\u0019<b\u0013\u0011\ti%a\u0011\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005A\u0001O]8ek\u000e,'/\u0006\u0002\u0002VA1\u0011qKA5{vl!!!\u0017\u000b\t\u0005E\u00131\f\u0006\u0005\u0003;\ny&A\u0004dY&,g\u000e^:\u000b\u0007\t\f\tG\u0003\u0003\u0002d\u0005\u0015\u0014AB1qC\u000eDWM\u0003\u0002\u0002h\u0005\u0019qN]4\n\t\u0005-\u0014\u0011\f\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\u0002\u0019A\u0014x\u000eZ;dKJ|F%Z9\u0015\t\u0005=\u0012\u0011\u000f\u0005\n\u0003oY\u0011\u0011!a\u0001\u0003+\n\u0011\u0002\u001d:pIV\u001cWM\u001d\u0011\u0002\u0011Q,\u0017M\u001d#po:$\"!a\f)\u00075\tY\b\u0005\u0003\u0002~\u0005-UBAA@\u0015\u0011\t\t)a!\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002\u0006\u0006\u001d\u0015a\u00026va&$XM\u001d\u0006\u0005\u0003\u0013\u000b)'A\u0003kk:LG/\u0003\u0003\u0002\u000e\u0006}$!C!gi\u0016\u0014X)Y2i\u0003-\u001a\bn\\;mI\n{w\u000e^:ue\u0006\u0004Hk^8Ce>\\WM]:XSRDG*Z1eKJ$\u0006N]8ui2,\u0007f\u0001\b\u0002\u0014B!\u0011QPAK\u0013\u0011\t9*a \u0003\tQ+7\u000f^\u0001.g\"|W\u000f\u001c3C_>$8\u000f\u001e:baR;xN\u0011:pW\u0016\u00148oV5uQ\u001a{G\u000e\\8xKJ$\u0006N]8ui2,\u0007fA\b\u0002\u0014\u0006Y4\u000f[8vY\u0012\u0014un\u001c;tiJ\f\u0007\u000fV<p\u0005J|7.\u001a:t/&$\bN\u0011:pW\u0016\u0014(+\u001a9mS\u000e\f7OR8mY><XM\u001d+ie>$H\u000f\\3)\u0007A\t\u0019*A\u001dtQ>,H\u000e\u001a\"p_R\u001cHO]1q)^|'I]8lKJ\u001cx+\u001b;i\u0005J|7.\u001a:SKBd\u0017nY1t\u0019\u0016\fG-\u001a:UQJ|G\u000f\u001e7fQ\r\t\u00121S\u0001\u0011g\"|W\u000f\u001c3NCR\u001c\u0007.U;pi\u0006$b!a\f\u0002*\n5\u0005bBAV%\u0001\u0007\u0011QV\u0001\u0010e\u0016\u0004H.[2bi&|g\u000eV3tiB9q.a,\u00024\n\r\u0014bAAYa\nIa)\u001e8di&|g.\r\t\u0004\u0003kCT\"\u0001\u0001\u0003/I+\u0007\u000f\\5dCRLwN\u001c+fgR\u001cV\r\u001e;j]\u001e\u001c8c\u0002\u001d\u0002<\u0006\u0005\u0017q\u0019\t\u0004_\u0006u\u0016bAA`a\n1\u0011I\\=SK\u001a\u00042a\\Ab\u0013\r\t)\r\u001d\u0002\b!J|G-^2u!\u0011\ty!!3\n\t\u0005-\u00171\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u000ei\"\u0014x\u000e\u001e;mK\nKH/Z:\u0016\u00039\fa\u0002\u001e5s_R$H.\u001a\"zi\u0016\u001c\b%\u0001\u0005ng\u001e\u001cu.\u001e8u+\u00051\u0018!C7tO\u000e{WO\u001c;!\u0003\ri7oZ\u0001\u0005[N<\u0007%\u0001\buQJ|G\u000f\u001e7f\u0019\u0016\fG-\u001a:\u0016\u0005\u0005\u0005\bcA8\u0002d&\u0019\u0011Q\u001d9\u0003\u000f\t{w\u000e\\3b]\u0006yA\u000f\u001b:piRdW\rT3bI\u0016\u0014\b\u0005\u0006\u0006\u00024\u0006-\u0018Q^Ax\u0003cDa!!4B\u0001\u0004q\u0007BBAj\u0003\u0002\u0007a\u000f\u0003\u0004\u0002Z\u0006\u0003\r! \u0005\b\u0003;\f\u0005\u0019AAq\u0003\u0011\u0019w\u000e]=\u0015\u0015\u0005M\u0016q_A}\u0003w\fi\u0010\u0003\u0005\u0002N\n\u0003\n\u00111\u0001o\u0011!\t\u0019N\u0011I\u0001\u0002\u00041\b\u0002CAm\u0005B\u0005\t\u0019A?\t\u0013\u0005u'\t%AA\u0002\u0005\u0005\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005\u0007Q3A\u001cB\u0003W\t\u00119\u0001\u0005\u0003\u0003\n\tMQB\u0001B\u0006\u0015\u0011\u0011iAa\u0004\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\ta\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tU!1\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u00057Q3A\u001eB\u0003\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"A!\t+\u0007u\u0014)!\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t\u001d\"\u0006BAq\u0005\u000b\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&D\u0018\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005c\u00119\u0004E\u0002p\u0005gI1A!\u000eq\u0005\r\te.\u001f\u0005\t\u0003oI\u0015\u0011!a\u0001m\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003>A1!q\bB#\u0005ci!A!\u0011\u000b\u0007\t\r\u0003/\u0001\u0006d_2dWm\u0019;j_:LAAa\u0012\u0003B\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\tO!\u0014\t\u0013\u0005]2*!AA\u0002\tE\u0012A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a\u0010\u0003T!A\u0011q\u0007'\u0002\u0002\u0003\u0007a/\u0001\u0005iCND7i\u001c3f)\u00051\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005}\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0002b\n\u0005\u0004\"CA\u001c\u001f\u0006\u0005\t\u0019\u0001B\u0019!\r\t)\f\t\u0002\u0013%\u0016\u0004H.[2bi&|gNU3tk2$8oE\u0004!\u0003w\u000b\t-a2\u0002\u001fUtG\u000f\u001b:piRdW\r\u001a+j[\u0016\f\u0001#\u001e8uQJ|G\u000f\u001e7fIRKW.\u001a\u0011\u0002\u001bQD'o\u001c;uY\u0016$G+[7f\u00039!\bN]8ui2,G\rV5nK\u0002\"bAa\u0019\u0003t\tU\u0004B\u0002B5K\u0001\u0007a\u000e\u0003\u0004\u0003n\u0015\u0002\rA\u001c\u000b\u0007\u0005G\u0012IHa\u001f\t\u0011\t%d\u0005%AA\u00029D\u0001B!\u001c'!\u0003\u0005\rA\u001c\u000b\u0005\u0005c\u0011y\b\u0003\u0005\u00028-\n\t\u00111\u0001w)\u0011\t\tOa!\t\u0013\u0005]R&!AA\u0002\tEB\u0003BA \u0005\u000fC\u0001\"a\u000e/\u0003\u0003\u0005\rA\u001e\u000b\u0005\u0003C\u0014Y\tC\u0005\u00028E\n\t\u00111\u0001\u00032!9!q\u0012\nA\u0002\u0005\u0005\u0018A\u0005;fgRdU-\u00193feRC'o\u001c;uY\u0016\fAE]3qY&\u001c\u0017\r^3XSRD7\u000b^1uS\u000e$\u0006N]8ui2,GMU3qY&\u001c\u0017m\u001d\u000b\u0005\u0005G\u0012)\nC\u0004\u0003\u0018N\u0001\r!a-\u0002\u0011M,G\u000f^5oON\f\u0001I]3qY&\u001c\u0017\r^3XSRDG)\u001f8b[&\u001cG\u000b\u001b:piRdW\r\u001a*fa2L7-Y:UQJ|Wo\u001a5B]\u0006\u001b\u00180\\7fiJL7\rV8q_2|w-\u001f\u000b\u0005\u0005G\u0012i\nC\u0004\u0003\u0018R\u0001\r!a-\u00023MDw.\u001e7e)\"\u0014x\u000e\u001e;mK>cGmU3h[\u0016tGo\u001d\u0015\u0004+\u0005M\u0015\u0001\t;fgR4u\u000e\u001c7po\u0016\u0014\u0018j\u001d+ie>$H\u000f\\3e\u001f:\u001cF/\u0019:ukBD3AFAJ\u0003I\"Xm\u001d;G_2dwn^3s\u0013N$\u0006N]8ui2,Gm\u00148Ti\u0006\u0014H/\u001e9XSRD7\t\\;ti\u0016\u0014H*\u001b8lS:<\u0007fA\f\u0002\u0014\u0006\u0011c/\u001a:jMf4u\u000e\u001c7po\u0016\u0014\u0018j\u001d+ie>$H\u000f\\3e\u001f:\u001cF/\u0019:ukB$B!a\f\u00030\"9!\u0011\u0017\rA\u0002\u0005\u0005\u0018!E2mkN$XM\u001d'j].,e.\u00192mK\u0006\u0019D/Z:u\r>dGn\\<fe\u000e{gNZ5h\u0013N,fn\u00195b]\u001e,Gm\u00148BGRLg/\u001a#jg.$\u0006N]8ui2Lgn\u001a\u0015\u00043\u0005M\u0015!\u0012;fgR4u\u000e\u001c7po\u0016\u00148i\u001c8gS\u001eL5/\u00168dQ\u0006tw-\u001a3P]\u0006\u001bG/\u001b<f\t&\u001c8\u000e\u00165s_R$H.\u001b8h/&$\bn\u00117vgR,'\u000fT5oW&tw\rK\u0002\u001b\u0003'\u000bQG^3sS\u001aLhi\u001c7m_^,'oQ8oM&<\u0017j]+oG\"\fgnZ3e\u001f:\f5\r^5wK\u0012K7o\u001b+ie>$H\u000f\\5oOR!\u0011q\u0006B`\u0011\u001d\u0011\tl\u0007a\u0001\u0003C\fQf\u0019:fCR,'I]8lKJ<\u0016\u000e\u001e5ESN\\Wk]1hK\n\u000b7/\u001a3UQJ|G\u000f\u001e7j]\u001el\u0015-\u001f2f)!\t)C!2\u0003J\nM\u0007B\u0002Bd9\u0001\u0007a/\u0001\u0005ce>\\WM]%e\u0011\u001d\u0011Y\r\ba\u0001\u0005\u001b\f1\u0002\u001e5s_R$H.Z(qiB!qNa4o\u0013\r\u0011\t\u000e\u001d\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\tEF\u00041\u0001\u0002b\u00069\u0011\r\u001a3ECR\fGCBA\u0018\u00053\u0014Y\u000e\u0003\u0004\u0002Tv\u0001\rA\u001e\u0005\u0007\u00033l\u0002\u0019A?\u0002+]\f\u0017\u000e\u001e$pe>3gm]3ugR{W*\u0019;dQRA\u0011q\u0006Bq\u0005K\u0014I\u000f\u0003\u0004\u0003dz\u0001\rA^\u0001\u0007_\u001a47/\u001a;\t\r\t\u001dh\u00041\u0001w\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\t\r\t\u001dg\u00041\u0001w\u0003%\u0011'o\\6fe\u001a{'\u000f\u0006\u0003\u0002&\t=\bB\u0002By?\u0001\u0007a/\u0001\u0002jI\u0006\u0011\"+\u001a9mS\u000e\fG/[8o%\u0016\u001cX\u000f\u001c;t!\r\t)lM\n\u0006g\te8Q\u0001\t\t\u0005w\u001c\tA\u001c8\u0003d5\u0011!Q \u0006\u0004\u0005\u007f\u0004\u0018a\u0002:v]RLW.Z\u0005\u0005\u0007\u0007\u0011iPA\tBEN$(/Y2u\rVt7\r^5p]J\u0002Baa\u0002\u0004\u000e5\u00111\u0011\u0002\u0006\u0005\u0007\u0017\t9%\u0001\u0002j_&!\u00111ZB\u0005)\t\u0011)0A\u0003baBd\u0017\u0010\u0006\u0004\u0003d\rU1q\u0003\u0005\u0007\u0005S2\u0004\u0019\u00018\t\r\t5d\u00071\u0001o\u0003\u001d)h.\u00199qYf$Ba!\b\u0004&A)qNa4\u0004 A)qn!\to]&\u001911\u00059\u0003\rQ+\b\u000f\\33\u0011%\u00199cNA\u0001\u0002\u0004\u0011\u0019'A\u0002yIA\nqCU3qY&\u001c\u0017\r^5p]R+7\u000f^*fiRLgnZ:\u0011\u0007\u0005U\u0016kE\u0003R\u0007_\u0019)\u0001E\u0006\u0003|\u000eEbN^?\u0002b\u0006M\u0016\u0002BB\u001a\u0005{\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c85)\t\u0019Y\u0003\u0006\u0006\u00024\u000ee21HB\u001f\u0007\u007fAa!!4U\u0001\u0004q\u0007BBAj)\u0002\u0007a\u000f\u0003\u0004\u0002ZR\u0003\r! \u0005\b\u0003;$\u0006\u0019AAq)\u0011\u0019\u0019ea\u0013\u0011\u000b=\u0014ym!\u0012\u0011\u0011=\u001c9E\u001c<~\u0003CL1a!\u0013q\u0005\u0019!V\u000f\u001d7fi!I1qE+\u0002\u0002\u0003\u0007\u00111W\u0001\u0003iB$Ba!\u0015\u0004^A!11KB-\u001b\t\u0019)F\u0003\u0003\u0004X\u0005}\u0013AB2p[6|g.\u0003\u0003\u0004\\\rU#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007\u0007?2\u0006\u0019\u0001<\u0002\u0013A\f'\u000f^5uS>t\u0017!D2sK\u0006$XM\u0011:pW\u0016\u00148\u000f\u0006\u0006\u00020\r\u001541NB8\u0007gBqaa\u001aX\u0001\u0004\u0019I'A\u0005ce>\\WM]%egB)\u0011qBA\u0010m\"11QN,A\u00029\f\u0001\u0002\u001e5s_R$H.\u001a\u0005\n\u0007c:\u0006\u0013!a\u0001\u0003C\fq\u0004\u001e5s_R$H.Z!mY\n\u0013xn[3s\u0019\u0016\fG-\u001a:SKBd\u0017nY1t\u0011%\u0019)h\u0016I\u0001\u0002\u0004\t\t/A\u0011uQJ|G\u000f\u001e7f\u00032d'I]8lKJ4u\u000e\u001c7po\u0016\u0014(+\u001a9mS\u000e\f7/A\fde\u0016\fG/\u001a\"s_.,'o\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u000592M]3bi\u0016\u0014%o\\6feN$C-\u001a4bk2$H\u0005N\u0001\u0018i\"\u0014x\u000e\u001e;mK\u0012\u0014V\r\u001d7jG\u0006\u001c8i\u001c8gS\u001e$Baa \u0004\u000eB!1\u0011QBE\u001d\u0011\u0019\u0019i!\"\u0011\u0007\u0005M\u0001/C\u0002\u0004\bB\fa\u0001\u0015:fI\u00164\u0017\u0002BA'\u0007\u0017S1aa\"q\u0011\u001d\u0019yI\u0017a\u0001\u0003C\f\u0011d\u001d5pk2$G\u000b\u001b:piRdW-\u00117m%\u0016\u0004H.[2bg\u00061\u0011M\u001e*bi\u0016$ba!&\u0004\u001c\u000e\u0015\u0006cA8\u0004\u0018&\u00191\u0011\u00149\u0003\r\u0011{WO\u00197f\u0011\u001d\u0019ij\u0017a\u0001\u0007?\u000bqB]3qY&\u001c\u0017\r^5p]RK\b/\u001a\t\u0004M\u000e\u0005\u0016bABR?\nI\u0011+^8uCRK\b/\u001a\u0005\b\u0003\u0013Y\u0006\u0019AB5\u00031iW-Y:ve\u0016$'+\u0019;f)\u0019\u0019)ja+\u00040\"91Q\u0016/A\u0002\u0005\u0015\u0012A\u00022s_.,'\u000fC\u0004\u00042r\u0003\raa(\u0002\u000fI,\u0007\u000fV=qK\u0006Y2/\u001a;B]\u0012,fn]3u\tft\u0017-\\5d)\"\u0014x\u000e\u001e;mKN$\u0002\"a\f\u00048\u000ee6Q\u0018\u0005\b\u0003\u0013i\u0006\u0019AB5\u0011\u0019\u0019Y,\u0018a\u0001]\u0006\u00192\u000f^1uS\u000e$\u0006N]8ui2,')\u001f;fg\"11qX/A\u00029\fA\u0003Z=oC6L7\r\u00165s_R$H.\u001a\"zi\u0016\u001c\bF\u0002\u0001\u0004Dj\u001cI\r\u0005\u0003\u0002~\r\u0015\u0017\u0002BBd\u0003\u007f\u00121\u0001V1hC\t\u0019Y-A\ncCj,GNO:iCJ$wlY8v]RT$\u0007")
public class ReplicationQuotasTest
extends QuorumTestHarness {
    private volatile ReplicationQuotasTest$ReplicationResults$ ReplicationResults$module;
    private volatile ReplicationQuotasTest$ReplicationTestSettings$ ReplicationTestSettings$module;
    private final byte[] msg100KB = new byte[100000];
    private scala.collection.immutable.Seq<KafkaServer> brokers = Nil$.MODULE$;
    private final String topic;
    private KafkaProducer<byte[], byte[]> producer;

    public ReplicationQuotasTest$ReplicationResults$ ReplicationResults() {
        if (this.ReplicationResults$module == null) {
            this.ReplicationResults$lzycompute$1();
        }
        return this.ReplicationResults$module;
    }

    public ReplicationQuotasTest$ReplicationTestSettings$ ReplicationTestSettings() {
        if (this.ReplicationTestSettings$module == null) {
            this.ReplicationTestSettings$lzycompute$1();
        }
        return this.ReplicationTestSettings$module;
    }

    public long percentError(int percent, long value) {
        return Math.round((double)(value * (long)percent) / 100.0);
    }

    public byte[] msg100KB() {
        return this.msg100KB;
    }

    public scala.collection.immutable.Seq<KafkaServer> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(scala.collection.immutable.Seq<KafkaServer> x$1) {
        this.brokers = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    @Override
    @AfterEach
    public void tearDown() {
        Option$.MODULE$.apply(this.producer()).foreach((Function1 & Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.shutdownServers(this.brokers(), true);
        super.tearDown();
    }

    @Test
    public void shouldBootstrapTwoBrokersWithLeaderThrottle() {
        this.shouldMatchQuota((Function1<ReplicationTestSettings, ReplicationResults>)(Function1 & Serializable)settings -> this.replicateWithDynamicThrottledReplicasThroughAnAsymmetricTopology((ReplicationTestSettings)settings), true);
    }

    @Test
    public void shouldBootstrapTwoBrokersWithFollowerThrottle() {
        this.shouldMatchQuota((Function1<ReplicationTestSettings, ReplicationResults>)(Function1 & Serializable)settings -> this.replicateWithDynamicThrottledReplicasThroughAnAsymmetricTopology((ReplicationTestSettings)settings), false);
    }

    @Test
    public void shouldBootstrapTwoBrokersWithBrokerReplicasFollowerThrottle() {
        this.shouldMatchQuota((Function1<ReplicationTestSettings, ReplicationResults>)(Function1 & Serializable)settings -> this.replicateWithStaticThrottledReplicas((ReplicationTestSettings)settings), false);
    }

    @Test
    public void shouldBootstrapTwoBrokersWithBrokerReplicasLeaderThrottle() {
        this.shouldMatchQuota((Function1<ReplicationTestSettings, ReplicationResults>)(Function1 & Serializable)settings -> this.replicateWithStaticThrottledReplicas((ReplicationTestSettings)settings), true);
    }

    public void shouldMatchQuota(Function1<ReplicationTestSettings, ReplicationResults> replicationTest, boolean testLeaderThrottle) {
        byte[] msg = this.msg100KB();
        int msgCount = 100;
        int expectedDuration = 10;
        long throttle = msgCount * msg.length / expectedDuration;
        if (!testLeaderThrottle) {
            throttle *= 3L;
        }
        ReplicationResults replicationResults = (ReplicationResults)replicationTest.apply((Object)new ReplicationTestSettings(this, throttle, msgCount, msg, testLeaderThrottle));
        double throttledLowerBound = (double)(expectedDuration * 1000) * 0.9;
        int throttledUpperBound = expectedDuration * 1000 * 3;
        Assertions.assertTrue(((double)replicationResults.unthrottledTime() < throttledLowerBound ? 1 : 0) != 0, (String)new StringBuilder(12).append("Expected ").append(replicationResults.unthrottledTime()).append(" < ").append(throttledLowerBound).toString());
        Assertions.assertTrue(((double)replicationResults.throttledTime() > throttledLowerBound ? 1 : 0) != 0, (String)new StringBuilder(12).append("Expected ").append(replicationResults.throttledTime()).append(" > ").append(throttledLowerBound).toString());
        Assertions.assertTrue((replicationResults.throttledTime() < (long)throttledUpperBound ? 1 : 0) != 0, (String)new StringBuilder(12).append("Expected ").append(replicationResults.throttledTime()).append(" < ").append(throttledUpperBound).toString());
        double rateUpperBound = (double)throttle * 1.1;
        double rateLowerBound = (double)throttle * 0.5;
        double rate = testLeaderThrottle ? this.avRate((QuotaType)QuotaType.LeaderReplication$.MODULE$, (scala.collection.immutable.Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(100), 105)) : this.avRate((QuotaType)QuotaType.FollowerReplication$.MODULE$, (scala.collection.immutable.Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(106), 107));
        Assertions.assertTrue((rate < rateUpperBound ? 1 : 0) != 0, (String)new StringBuilder(12).append("Expected ").append(rate).append(" < ").append(rateUpperBound).toString());
        Assertions.assertTrue((rate > rateLowerBound ? 1 : 0) != 0, (String)new StringBuilder(12).append("Expected ").append(rate).append(" > ").append(rateLowerBound).toString());
    }

    public ReplicationResults replicateWithStaticThrottledReplicas(ReplicationTestSettings settings) {
        Range.Inclusive initialBrokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(100), 105);
        this.createBrokers((scala.collection.immutable.Seq<Object>)initialBrokers, settings.throttleBytes(), settings.throttleLeader(), !settings.throttleLeader());
        this.createBrokers((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{108}))), settings.throttleBytes(), this.createBrokers$default$3(), this.createBrokers$default$4());
        this.setAndUnsetDynamicThrottles((scala.collection.immutable.Seq<Object>)initialBrokers, settings.throttleBytes(), 100L);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{101, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{102, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{103, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{104, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{105, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{108, 109})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)assignment, this.brokers());
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), SecurityProtocol.PLAINTEXT), 1, 60000L, 0x100000L, Integer.MAX_VALUE, 30000, 0, 16384, "none", 20000, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArraySerializer(), new ByteArraySerializer(), false));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), settings.msgCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1 & Serializable)partition -> ReplicationQuotasTest.$anonfun$replicateWithStaticThrottledReplicas$2(this, settings, BoxesRunTime.unboxToInt((Object)partition))));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)id -> this.waitForOffsetsToMatch(settings.msgCount(), id, 100 + id));
        this.waitForOffsetsToMatch(settings.msgCount(), 6, 108);
        long start = System.currentTimeMillis();
        this.createBrokers((scala.collection.immutable.Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(106), 107), settings.throttleBytes(), settings.throttleLeader(), !settings.throttleLeader());
        this.createBrokers((scala.collection.immutable.Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(109), 109), settings.throttleBytes(), this.createBrokers$default$3(), this.createBrokers$default$4());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(100), 107).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> {
            String string;
            ReplicationQuotaManager replicationQuotaManager;
            KafkaServer broker = this.brokerFor(brokerId);
            if (settings.throttleLeader()) {
                replicationQuotaManager = broker.quotaManagers().leader();
                string = "leader";
            } else {
                replicationQuotaManager = broker.quotaManagers().follower();
                string = "follower";
            }
            String string2 = string;
            Assertions.assertTrue((boolean)replicationQuotaManager.isThrottled(this.tp(0)), (String)new StringBuilder(33).append("Expected all ").append(string2).append(" replicas on broker ").append(brokerId).toString());
        });
        this.waitForOffsetsToMatch(settings.msgCount(), 6, 109);
        long unthrottledTime = System.currentTimeMillis() - start;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)id -> this.waitForOffsetsToMatch(settings.msgCount(), id, 106));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(3), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)id -> this.waitForOffsetsToMatch(settings.msgCount(), id, 107));
        long throttledTime = System.currentTimeMillis() - start;
        return new ReplicationResults(this, unthrottledTime, throttledTime);
    }

    public ReplicationResults replicateWithDynamicThrottledReplicasThroughAnAsymmetricTopology(ReplicationTestSettings settings) {
        this.createBrokers((scala.collection.immutable.Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(100), 105), settings.throttleBytes(), this.createBrokers$default$3(), this.createBrokers$default$4());
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{101, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{102, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{103, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{104, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{105, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{101, 107})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)assignment, this.brokers());
        if (settings.throttleLeader()) {
            this.adminZkClient().changeTopicConfig(this.topic(), CoreUtils$.MODULE$.propsWith("leader.replication.throttled.replicas", "0:100,1:101,2:102,3:103,4:104,5:105"));
        } else {
            this.adminZkClient().changeTopicConfig(this.topic(), CoreUtils$.MODULE$.propsWith("follower.replication.throttled.replicas", "0:106,1:106,2:106,3:107,4:107,5:107"));
        }
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.plaintextBootstrapServers(this.brokers()), 1, 60000L, 0x100000L, Integer.MAX_VALUE, 30000, 0, 16384, "none", 20000, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArraySerializer(), new ByteArraySerializer(), false));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), settings.msgCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 7).foreach((Function1 & Serializable)partition -> ReplicationQuotasTest.$anonfun$replicateWithDynamicThrottledReplicasThroughAnAsymmetricTopology$2(this, settings, BoxesRunTime.unboxToInt((Object)partition))));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)id -> this.waitForOffsetsToMatch(settings.msgCount(), id, 100 + id));
        this.waitForOffsetsToMatch(settings.msgCount(), 6, 100);
        this.waitForOffsetsToMatch(settings.msgCount(), 7, 101);
        long start = System.currentTimeMillis();
        this.createBrokers((scala.collection.immutable.Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(106), 107), settings.throttleBytes(), this.createBrokers$default$3(), this.createBrokers$default$4());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(106), 107).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Assertions.assertEquals((long)settings.throttleBytes(), (long)this.brokerFor(brokerId).quotaManagers().follower().upperBound()));
        if (!settings.throttleLeader()) {
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> Assertions.assertTrue((boolean)this.brokerFor(106).quotaManagers().follower().isThrottled(this.tp(partition))));
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(3), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> Assertions.assertTrue((boolean)this.brokerFor(107).quotaManagers().follower().isThrottled(this.tp(partition))));
        }
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(6), 7).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)id -> this.waitForOffsetsToMatch(settings.msgCount(), id, 100 + id));
        long unthrottledTook = System.currentTimeMillis() - start;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)id -> this.waitForOffsetsToMatch(settings.msgCount(), id, 106));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(3), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)id -> this.waitForOffsetsToMatch(settings.msgCount(), id, 107));
        long throttledTook = System.currentTimeMillis() - start;
        return new ReplicationResults(this, unthrottledTook, throttledTook);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldThrottleOldSegments() {
        void createServer_createServer_createServer_startup;
        void createServer_time;
        void createServer_config;
        void createServer_createServer_createServer_startup2;
        void createServer_time2;
        void createServer_config2;
        Properties config = TestUtils$.MODULE$.createBrokerConfig(100, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        config.put("log.segment.bytes", Integer.toString(0x100000));
        Time time = Time.SYSTEM;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(config);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        boolean bl = true;
        int createServer_createServer_createServer_licenseTopicReplicationFactor = 0;
        Object var14_5 = null;
        Object var11_4 = null;
        kafkaConfig = null;
        time = null;
        this.brokers_$eq((scala.collection.immutable.Seq<KafkaServer>)new .colon.colon((Object)createServer_this.createServer((KafkaConfig)createServer_config2, (Time)createServer_time2, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_licenseTopicReplicationFactor, (boolean)createServer_createServer_createServer_startup2, false), (List)Nil$.MODULE$));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.brokers());
        byte[] msg = this.msg100KB();
        int msgCount = 200;
        int expectedDuration = 4;
        long throttle = msg.length * msgCount / expectedDuration;
        this.adminZkClient().changeBrokerConfig((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100})), CoreUtils$.MODULE$.propsWith(KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), Long.toString(throttle)));
        this.adminZkClient().changeTopicConfig(this.topic(), CoreUtils$.MODULE$.propsWith("leader.replication.throttled.replicas", "0:100"));
        this.addData(msgCount, msg);
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Starting new broker");
        Time time2 = Time.SYSTEM;
        KafkaConfig kafkaConfig2 = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(101, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        TestUtils$ createServer_this2 = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix2 = None$.MODULE$;
        boolean bl2 = true;
        int createServer_createServer_createServer_licenseTopicReplicationFactor2 = 0;
        Object var20_15 = null;
        Object var17_14 = null;
        kafkaConfig2 = null;
        time2 = null;
        this.brokers_$eq((scala.collection.immutable.Seq<KafkaServer>)((scala.collection.immutable.Seq)this.brokers().$colon$plus((Object)createServer_this2.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix2, createServer_createServer_createServer_licenseTopicReplicationFactor2, (boolean)createServer_createServer_createServer_startup, false))));
        long start = System.currentTimeMillis();
        this.waitForOffsetsToMatch(msgCount, 0, 101);
        long throttledTook = System.currentTimeMillis() - start;
        Assertions.assertTrue(((double)throttledTook > (double)(expectedDuration * 1000) * 0.9 ? 1 : 0) != 0, (String)new StringBuilder(42).append("Throttled replication of ").append(throttledTook).append("ms should be > ").append((double)(expectedDuration * 1000) * 0.9).append("ms").toString());
        Assertions.assertTrue(((double)throttledTook < (double)(expectedDuration * 1000) * 1.5 ? 1 : 0) != 0, (String)new StringBuilder(42).append("Throttled replication of ").append(throttledTook).append("ms should be < ").append(expectedDuration * 1500).append("ms").toString());
    }

    @Test
    public void testFollowerIsThrottledOnStartup() {
        this.verifyFollowerIsThrottledOnStartup(false);
    }

    @Test
    public void testFollowerIsThrottledOnStartupWithClusterLinking() {
        this.verifyFollowerIsThrottledOnStartup(true);
    }

    public void verifyFollowerIsThrottledOnStartup(boolean clusterLinkEnable) {
        byte[] msg = this.msg100KB();
        int msgCount = 20;
        int expectedDuration = 4;
        int multiplier = clusterLinkEnable ? 4 : 2;
        long throttle = msg.length * msgCount / (multiplier * expectedDuration);
        this.brokers_$eq((scala.collection.immutable.Seq<KafkaServer>)new .colon.colon((Object)this.createBrokerWithDiskUsageBasedThrottlingMaybe(100, (Option<Object>)None$.MODULE$, clusterLinkEnable), (List)Nil$.MODULE$));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.brokers());
        this.addData(msgCount, msg);
        this.brokers_$eq((scala.collection.immutable.Seq<KafkaServer>)((scala.collection.immutable.Seq)this.brokers().$colon$plus((Object)this.createBrokerWithDiskUsageBasedThrottlingMaybe(101, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)throttle)), clusterLinkEnable))));
        long start = System.currentTimeMillis();
        this.waitForOffsetsToMatch(msgCount, 0, 101);
        long throttledTook = System.currentTimeMillis() - start;
        Assertions.assertTrue(((double)throttledTook > (double)(expectedDuration * 1000) * 0.9 ? 1 : 0) != 0, (String)new StringBuilder(42).append("Throttled replication of ").append(throttledTook).append("ms should be > ").append((double)(expectedDuration * 1000) * 0.9).append("ms").toString());
        Assertions.assertTrue(((double)throttledTook < (double)(expectedDuration * 1000) * 1.5 ? 1 : 0) != 0, (String)new StringBuilder(42).append("Throttled replication of ").append(throttledTook).append("ms should be < ").append(expectedDuration * 1500).append("ms").toString());
    }

    @Test
    public void testFollowerConfigIsUnchangedOnActiveDiskThrottling() {
        this.verifyFollowerConfigIsUnchangedOnActiveDiskThrottling(false);
    }

    @Test
    public void testFollowerConfigIsUnchangedOnActiveDiskThrottlingWithClusterLinking() {
        this.verifyFollowerConfigIsUnchangedOnActiveDiskThrottling(true);
    }

    /*
     * WARNING - void declaration
     */
    public void verifyFollowerConfigIsUnchangedOnActiveDiskThrottling(boolean clusterLinkEnable) {
        long throttle = 131072L;
        KafkaServer throttledBroker = this.createBrokerWithDiskUsageBasedThrottlingMaybe(100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)throttle)), clusterLinkEnable);
        this.brokers_$eq((scala.collection.immutable.Seq<KafkaServer>)new .colon.colon((Object)throttledBroker, (List)Nil$.MODULE$));
        AtomicReference<None$> lastUpdatedThrottleOptRef = new AtomicReference<None$>(None$.MODULE$);
        AtomicReference<None$> lastUpdatedClusterLinkThrottleOptRef = new AtomicReference<None$>(None$.MODULE$);
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> throttledBroker.dynamicConfigManager().shutdown(), (Logging)this, Level.WARN);
        throttledBroker.dynamicConfigHandlers_$eq((Map)throttledBroker.dynamicConfigHandlers().$plus$plus((IterableOnce)new .colon.colon((Object)new Tuple2((Object)"brokers", (Object)new BrokerConfigHandler(null, throttledBroker, lastUpdatedThrottleOptRef, lastUpdatedClusterLinkThrottleOptRef){
            private final AtomicReference lastUpdatedThrottleOptRef$1;
            private final AtomicReference lastUpdatedClusterLinkThrottleOptRef$1;

            public void processConfigChanges(String brokerId, Properties properties) {
                super.processConfigChanges(brokerId, properties);
                this.lastUpdatedThrottleOptRef$1.set(this.quotaManagers().follower().lastSignalledQuotaOptRef().get());
                this.lastUpdatedClusterLinkThrottleOptRef$1.set(this.quotaManagers().clusterLinkProduce().lastSignalledQuotaOptRef().get());
            }
            {
                this.lastUpdatedThrottleOptRef$1 = lastUpdatedThrottleOptRef$1;
                this.lastUpdatedClusterLinkThrottleOptRef$1 = lastUpdatedClusterLinkThrottleOptRef$1;
                super(throttledBroker$1.config(), throttledBroker$1.quotaManagers());
            }
        }), (List)Nil$.MODULE$).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
        throttledBroker.dynamicConfigManager_$eq(new ZkConfigManager(throttledBroker.zkClient(), throttledBroker.dynamicConfigHandlers()));
        throttledBroker.dynamicConfigManager().startup();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReplicationQuotasTest.$anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$2(throttledBroker, throttle)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Follower throttle couldn't be applied within timeout");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        lastUpdatedThrottleOptRef.set(None$.MODULE$);
        lastUpdatedClusterLinkThrottleOptRef.set(None$.MODULE$);
        this.adminZkClient().changeBrokerConfig((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100})), CoreUtils$.MODULE$.propsWith((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)Long.toString(throttle + 1L)), new Tuple2((Object)KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), (Object)"*"), new Tuple2((Object)KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)"1000"), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), (Object)"1001"), new Tuple2((Object)KafkaConfig$.MODULE$.ClusterLinkIoMaxBytesPerSecondProp(), (Object)"1002")})));
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ReplicationQuotasTest.$anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$4(lastUpdatedThrottleOptRef)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)ReplicationQuotasTest.$anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)throttle, (long)BoxesRunTime.unboxToLong((Object)((Option)lastUpdatedThrottleOptRef.get()).get()));
        if (clusterLinkEnable) {
            long l3 = 100L;
            long waitUntilTrue_waitTimeMs3 = 15000L;
            long waitUntilTrue_startTime3 = System.currentTimeMillis();
            while (!ReplicationQuotasTest.$anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$6(lastUpdatedClusterLinkThrottleOptRef)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                    Assertions.fail((String)"Cluster link throttle not updated");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
            }
            Assertions.assertEquals((long)throttle, (long)BoxesRunTime.unboxToLong((Object)((Option)lastUpdatedClusterLinkThrottleOptRef.get()).get()));
        }
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs4 = 15000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!ReplicationQuotasTest.$anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$8(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"Leader replication not updated");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        long l5 = 100L;
        long waitUntilTrue_waitTimeMs5 = 15000L;
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!ReplicationQuotasTest.$anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$10(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)"alterLogDirs not updated");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    public KafkaServer createBrokerWithDiskUsageBasedThrottlingMaybe(int brokerId, Option<Object> throttleOpt, boolean clusterLinkEnable) {
        void createServer_createServer_createServer_startup;
        void createServer_time;
        void createServer_config;
        Properties config = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        config.put("log.segment.bytes", Integer.toString(0x100000));
        config.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), Boolean.toString(clusterLinkEnable));
        throttleOpt.foreach((Function1 & Serializable)throttle -> ReplicationQuotasTest.$anonfun$createBrokerWithDiskUsageBasedThrottlingMaybe$1(config, BoxesRunTime.unboxToLong((Object)throttle)));
        Time time = Time.SYSTEM;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(config);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        boolean bl = true;
        int createServer_createServer_createServer_licenseTopicReplicationFactor = 0;
        return createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_licenseTopicReplicationFactor, (boolean)createServer_createServer_createServer_startup, false);
    }

    public void addData(int msgCount, byte[] msg) {
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.plaintextBootstrapServers(this.brokers()), 0, 60000L, 0x100000L, Integer.MAX_VALUE, 30000, 0, 16384, "none", 20000, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArraySerializer(), new ByteArraySerializer(), false));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), msgCount).map((Function1 & Serializable)x$6 -> ReplicationQuotasTest.$anonfun$addData$1(this, msg, BoxesRunTime.unboxToInt((Object)x$6))).foreach((Function1 & Serializable)x$7 -> (RecordMetadata)x$7.get());
        this.waitForOffsetsToMatch(msgCount, 0, 100);
    }

    /*
     * WARNING - void declaration
     */
    private void waitForOffsetsToMatch(int offset, int partitionId, int brokerId) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReplicationQuotasTest.$anonfun$waitForOffsetsToMatch$1(this, offset, brokerId, partitionId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ReplicationQuotasTest.$anonfun$waitForOffsetsToMatch$4(partitionId, brokerId));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private KafkaServer brokerFor(int id) {
        return (KafkaServer)((IterableOps)this.brokers().filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ReplicationQuotasTest.$anonfun$brokerFor$1(id, x$9)))).head();
    }

    public TopicPartition tp(int partition) {
        return new TopicPartition(this.topic(), partition);
    }

    public void createBrokers(scala.collection.immutable.Seq<Object> brokerIds, long throttle, boolean throttleAllBrokerLeaderReplicas, boolean throttleAllBrokerFollowerReplicas) {
        brokerIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable)id -> {
            void createServer_createServer_createServer_startup;
            void createServer_time;
            void createServer_config;
            Properties props = TestUtils$.MODULE$.createBrokerConfig(id, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
            props.setProperty(KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), Long.toString(throttle));
            props.setProperty(KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), Long.toString(throttle));
            props.setProperty(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), this.throttledReplicasConfig(throttleAllBrokerLeaderReplicas));
            props.setProperty(KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), this.throttledReplicasConfig(throttleAllBrokerFollowerReplicas));
            Time time = Time.SYSTEM;
            KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
            TestUtils$ createServer_this = TestUtils$.MODULE$;
            None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
            boolean bl = true;
            int createServer_createServer_createServer_licenseTopicReplicationFactor = 0;
            Object var10_9 = null;
            Object var7_8 = null;
            kafkaConfig = null;
            time = null;
            this.brokers_$eq((scala.collection.immutable.Seq<KafkaServer>)((scala.collection.immutable.Seq)this.brokers().$colon$plus((Object)createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_licenseTopicReplicationFactor, (boolean)createServer_createServer_createServer_startup, false))));
            Assertions.assertEquals((long)throttle, (long)this.brokerFor(id).quotaManagers().leader().upperBound());
            Assertions.assertEquals((long)throttle, (long)this.brokerFor(id).quotaManagers().follower().upperBound());
        });
    }

    public boolean createBrokers$default$3() {
        return false;
    }

    public boolean createBrokers$default$4() {
        return false;
    }

    public String throttledReplicasConfig(boolean shouldThrottleAllReplicas) {
        if (shouldThrottleAllReplicas) {
            return "*";
        }
        return "none";
    }

    private double avRate(QuotaType replicationType, scala.collection.immutable.Seq<Object> brokers) {
        return BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)((IterableOps)brokers.map((Function1 & Serializable)id -> this.brokerFor(BoxesRunTime.unboxToInt((Object)id)))).map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToDouble((double)this.measuredRate(x$10, replicationType)))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)brokers.length();
    }

    private double measuredRate(KafkaServer broker, QuotaType repType) {
        MetricName metricName = broker.metrics().metricName("byte-rate", repType.toString());
        return BoxesRunTime.unboxToDouble((Object)((KafkaMetric)CollectionConverters$.MODULE$.MapHasAsScala(broker.metrics().metrics()).asScala().apply((Object)metricName)).metricValue());
    }

    /*
     * WARNING - void declaration
     */
    public void setAndUnsetDynamicThrottles(scala.collection.immutable.Seq<Object> brokers, long staticThrottleBytes, long dynamicThrottleBytes) {
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> this.adminZkClient().changeBrokerConfig((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId})), CoreUtils$.MODULE$.propsWith((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)Long.toString(dynamicThrottleBytes)), new Tuple2((Object)KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)Long.toString(dynamicThrottleBytes))}))));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!brokers.forall((Function1)(JFunction1.mcZI.sp & Serializable)brokerId -> dynamicThrottleBytes$1 == $this.brokerFor(brokerId).quotaManagers().leader().upperBound() && dynamicThrottleBytes$1 == $this.brokerFor(brokerId).quotaManagers().follower().upperBound())) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Dynamically set throttles weren't as expected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> this.adminZkClient().changeBrokerConfig((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId})), CoreUtils$.MODULE$.propsWith((scala.collection.immutable.Seq)Nil$.MODULE$)));
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!brokers.forall((Function1)(JFunction1.mcZI.sp & Serializable)brokerId -> staticThrottleBytes$1 == $this.brokerFor(brokerId).quotaManagers().leader().upperBound() && staticThrottleBytes$1 == $this.brokerFor(brokerId).quotaManagers().follower().upperBound())) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Throttles weren't reverted to the statically set ones as expected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    private final void ReplicationResults$lzycompute$1() {
        synchronized (this) {
            if (this.ReplicationResults$module == null) {
                this.ReplicationResults$module = new ReplicationQuotasTest$ReplicationResults$(this);
            }
            return;
        }
    }

    private final void ReplicationTestSettings$lzycompute$1() {
        synchronized (this) {
            if (this.ReplicationTestSettings$module == null) {
                this.ReplicationTestSettings$module = new ReplicationQuotasTest$ReplicationTestSettings$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ Future $anonfun$replicateWithStaticThrottledReplicas$2(ReplicationQuotasTest $this, ReplicationTestSettings settings$1, int partition) {
        return $this.producer().send(new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)settings$1.msg()));
    }

    public static final /* synthetic */ Future $anonfun$replicateWithDynamicThrottledReplicasThroughAnAsymmetricTopology$2(ReplicationQuotasTest $this, ReplicationTestSettings settings$2, int partition) {
        return $this.producer().send(new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)settings$2.msg()));
    }

    public static final /* synthetic */ boolean $anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$2(KafkaServer throttledBroker$1, long throttle$1) {
        return BoxesRunTime.unboxToLong((Object)((Option)throttledBroker$1.quotaManagers().follower().lastSignalledQuotaOptRef().get()).get()) == throttle$1;
    }

    public static final /* synthetic */ String $anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$3() {
        return "Follower throttle couldn't be applied within timeout";
    }

    public static final /* synthetic */ boolean $anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$4(AtomicReference lastUpdatedThrottleOptRef$1) {
        return ((Option)lastUpdatedThrottleOptRef$1.get()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$5() {
        return new StringBuilder(41).append("updateReplicationConfig() incomplete for ").append(KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$6(AtomicReference lastUpdatedClusterLinkThrottleOptRef$1) {
        return ((Option)lastUpdatedClusterLinkThrottleOptRef$1.get()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$7() {
        return "Cluster link throttle not updated";
    }

    public static final /* synthetic */ boolean $anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$8(ReplicationQuotasTest $this) {
        return ((KafkaServer)$this.brokers().head()).quotaManagers().leader().upperBound() == 1000L;
    }

    public static final /* synthetic */ String $anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$9() {
        return "Leader replication not updated";
    }

    public static final /* synthetic */ boolean $anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$10(ReplicationQuotasTest $this) {
        return ((KafkaServer)$this.brokers().head()).quotaManagers().alterLogDirs().upperBound() == 1001L;
    }

    public static final /* synthetic */ String $anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$11() {
        return "alterLogDirs not updated";
    }

    public static final /* synthetic */ Object $anonfun$createBrokerWithDiskUsageBasedThrottlingMaybe$1(Properties config$1, long throttle) {
        config$1.setProperty(KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp(), "16384");
        config$1.setProperty("confluent.backpressure.disk.enable", Boolean.toString(true));
        config$1.setProperty("confluent.backpressure.disk.produce.bytes.per.second", Long.toString(throttle));
        return config$1.setProperty("confluent.backpressure.disk.free.threshold.bytes", Long.toString(Long.MAX_VALUE));
    }

    public static final /* synthetic */ Future $anonfun$addData$1(ReplicationQuotasTest $this, byte[] msg$1, int x$6) {
        return $this.producer().send(new ProducerRecord($this.topic(), (Object)msg$1));
    }

    public static final /* synthetic */ boolean $anonfun$waitForOffsetsToMatch$1(ReplicationQuotasTest $this, int offset$1, int brokerId$1, int partitionId$1) {
        LogManager qual$1 = $this.brokerFor(brokerId$1).getLogManager();
        TopicPartition x$1 = new TopicPartition($this.topic(), partitionId$1);
        boolean x$2 = qual$1.getLog$default$2();
        return BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)offset$1), (Object)qual$1.getLog(x$1, x$2).map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.logEndOffset())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
    }

    public static final /* synthetic */ String $anonfun$waitForOffsetsToMatch$4(int partitionId$1, int brokerId$1) {
        return new StringBuilder(47).append("Offsets did not match for partition ").append(partitionId$1).append(" on broker ").append(brokerId$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$brokerFor$1(int id$1, KafkaServer x$9) {
        return x$9.config().brokerId() == id$1;
    }

    public static final /* synthetic */ String $anonfun$setAndUnsetDynamicThrottles$4() {
        return "Dynamically set throttles weren't as expected";
    }

    public static final /* synthetic */ String $anonfun$setAndUnsetDynamicThrottles$8() {
        return "Throttles weren't reverted to the statically set ones as expected";
    }

    public ReplicationQuotasTest() {
        this.topic = "topic1";
    }

    public class ReplicationResults
    implements Product,
    Serializable {
        private final long unthrottledTime;
        private final long throttledTime;
        public final /* synthetic */ ReplicationQuotasTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public long unthrottledTime() {
            return this.unthrottledTime;
        }

        public long throttledTime() {
            return this.throttledTime;
        }

        public ReplicationResults copy(long unthrottledTime, long throttledTime) {
            return new ReplicationResults(this.kafka$server$ReplicationQuotasTest$ReplicationResults$$$outer(), unthrottledTime, throttledTime);
        }

        public long copy$default$1() {
            return this.unthrottledTime();
        }

        public long copy$default$2() {
            return this.throttledTime();
        }

        public String productPrefix() {
            return "ReplicationResults";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.unthrottledTime());
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.throttledTime());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ReplicationResults;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "unthrottledTime";
                }
                case 1: {
                    return "throttledTime";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.longHash((long)this.unthrottledTime())), (int)Statics.longHash((long)this.throttledTime())), (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof ReplicationResults && ((ReplicationResults)x$1).kafka$server$ReplicationQuotasTest$ReplicationResults$$$outer() == this.kafka$server$ReplicationQuotasTest$ReplicationResults$$$outer())) break block3;
                    ReplicationResults replicationResults = (ReplicationResults)x$1;
                    if (this.unthrottledTime() != replicationResults.unthrottledTime() || this.throttledTime() != replicationResults.throttledTime() || !replicationResults.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ ReplicationQuotasTest kafka$server$ReplicationQuotasTest$ReplicationResults$$$outer() {
            return this.$outer;
        }

        public ReplicationResults(ReplicationQuotasTest $outer, long unthrottledTime, long throttledTime) {
            this.unthrottledTime = unthrottledTime;
            this.throttledTime = throttledTime;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class ReplicationTestSettings
    implements Product,
    Serializable {
        private final long throttleBytes;
        private final int msgCount;
        private final byte[] msg;
        private final boolean throttleLeader;
        public final /* synthetic */ ReplicationQuotasTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public long throttleBytes() {
            return this.throttleBytes;
        }

        public int msgCount() {
            return this.msgCount;
        }

        public byte[] msg() {
            return this.msg;
        }

        public boolean throttleLeader() {
            return this.throttleLeader;
        }

        public ReplicationTestSettings copy(long throttleBytes, int msgCount, byte[] msg, boolean throttleLeader) {
            return new ReplicationTestSettings(this.kafka$server$ReplicationQuotasTest$ReplicationTestSettings$$$outer(), throttleBytes, msgCount, msg, throttleLeader);
        }

        public long copy$default$1() {
            return this.throttleBytes();
        }

        public int copy$default$2() {
            return this.msgCount();
        }

        public byte[] copy$default$3() {
            return this.msg();
        }

        public boolean copy$default$4() {
            return this.throttleLeader();
        }

        public String productPrefix() {
            return "ReplicationTestSettings";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.throttleBytes());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.msgCount());
                }
                case 2: {
                    return this.msg();
                }
                case 3: {
                    return BoxesRunTime.boxToBoolean((boolean)this.throttleLeader());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ReplicationTestSettings;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "throttleBytes";
                }
                case 1: {
                    return "msgCount";
                }
                case 2: {
                    return "msg";
                }
                case 3: {
                    return "throttleLeader";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.longHash((long)this.throttleBytes())), (int)this.msgCount()), (int)Statics.anyHash((Object)this.msg())), (int)(this.throttleLeader() ? 1231 : 1237)), (int)4);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof ReplicationTestSettings && ((ReplicationTestSettings)x$1).kafka$server$ReplicationQuotasTest$ReplicationTestSettings$$$outer() == this.kafka$server$ReplicationQuotasTest$ReplicationTestSettings$$$outer())) break block3;
                    ReplicationTestSettings replicationTestSettings = (ReplicationTestSettings)x$1;
                    if (this.throttleBytes() != replicationTestSettings.throttleBytes() || this.msgCount() != replicationTestSettings.msgCount() || this.throttleLeader() != replicationTestSettings.throttleLeader() || this.msg() != replicationTestSettings.msg() || !replicationTestSettings.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ ReplicationQuotasTest kafka$server$ReplicationQuotasTest$ReplicationTestSettings$$$outer() {
            return this.$outer;
        }

        public ReplicationTestSettings(ReplicationQuotasTest $outer, long throttleBytes, int msgCount, byte[] msg, boolean throttleLeader) {
            this.throttleBytes = throttleBytes;
            this.msgCount = msgCount;
            this.msg = msg;
            this.throttleLeader = throttleLeader;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

